/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2;

import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc2.ISvnOperationRunner;
import org.tmatesoft.svn.core.wc2.SvnOperation;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SvnOperationRunner
implements ISVNEventHandler,
ISvnOperationRunner {
    private SvnOperation operation;
    private SVNWCContext wcContext;

    @Override
    public Object run(SvnOperation svnOperation) {
        this.setOperation(svnOperation);
        try {
            Object object = this.run();
            return object;
        }
        finally {
            this.reset(this.getWcGeneration());
        }
    }

    @Override
    public void reset(SvnWcGeneration svnWcGeneration) {
        this.setOperation(null);
        this.setWcContext(null);
    }

    @Override
    public void setWcContext(SVNWCContext sVNWCContext) {
        this.wcContext = sVNWCContext;
    }

    protected SVNWCContext getWcContext() {
        return this.wcContext;
    }

    protected abstract Object run();

    public void setOperation(SvnOperation svnOperation) {
        this.operation = svnOperation;
    }

    public SvnOperation getOperation() {
        return this.operation;
    }

    @Override
    public void checkCancelled() {
        if (this.getOperation() != null && this.getOperation().isCancelled()) {
            SVNErrorManager.cancel("Operation cancelled", SVNLogType.WC);
        }
        if (this.getOperation() != null && this.getOperation().getCanceller() != null) {
            this.getOperation().getCanceller().checkCancelled();
        }
    }

    @Override
    public void handleEvent(SVNEvent sVNEvent, double d2) {
        ISVNEventHandler iSVNEventHandler = null;
        if (this.getOperation() != null) {
            iSVNEventHandler = this.getOperation().getEventHandler();
        } else if (this.getWcContext() != null) {
            iSVNEventHandler = this.getWcContext().getEventHandler();
        }
        if (iSVNEventHandler != null) {
            iSVNEventHandler.handleEvent(sVNEvent, d2);
        }
    }

    protected void handleEvent(SVNEvent sVNEvent) {
        this.handleEvent(sVNEvent, -1.0);
    }
}

