/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db.statement;

import java.util.HashSet;
import java.util.Set;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema$NODES__Fields;

public class SVNWCDbSelectMinMaxRevisions
extends SVNSqlJetSelectStatement {
    private long minRevision = -1L;
    private long maxRevision = -1L;
    private long minChangedRevision = -1L;
    private long maxChangedRevision = -1L;
    private Set expectedPresence = new HashSet(2);

    public SVNWCDbSelectMinMaxRevisions(SVNSqlJetDb sVNSqlJetDb) {
        super(sVNSqlJetDb, SVNWCDbSchema.NODES);
        this.expectedPresence.add(ISVNWCDb$SVNWCDbStatus.Normal);
        this.expectedPresence.add(ISVNWCDb$SVNWCDbStatus.Incomplete);
    }

    @Override
    public void reset() {
        super.reset();
        this.maxChangedRevision = -1L;
        this.minChangedRevision = -1L;
        this.maxRevision = -1L;
        this.minRevision = -1L;
    }

    public long getMinRevision() {
        return this.minRevision;
    }

    public long getMaxRevision() {
        return this.maxRevision;
    }

    public long getMinChangedRevision() {
        return this.minChangedRevision;
    }

    public long getMaxChangedRevision() {
        return this.maxChangedRevision;
    }

    @Override
    public boolean next() {
        boolean bl2 = false;
        while (super.next()) {
            bl2 = true;
            long l2 = this.getColumnLong(SVNWCDbSchema$NODES__Fields.revision);
            if (this.minRevision == -1L || l2 < this.minRevision) {
                this.minRevision = l2;
            }
            if (this.maxRevision == -1L || l2 > this.maxRevision) {
                this.maxRevision = l2;
            }
            long l3 = this.getColumnLong(SVNWCDbSchema$NODES__Fields.changed_revision);
            if (this.minChangedRevision == -1L || l3 < this.minChangedRevision) {
                this.minChangedRevision = l3;
            }
            if (this.maxChangedRevision != -1L && l3 <= this.maxChangedRevision) continue;
            this.maxChangedRevision = l3;
        }
        return bl2;
    }

    @Override
    protected String getPathScope() {
        return (String)this.getBind(2);
    }

    @Override
    protected boolean isStrictiDescendant() {
        return false;
    }

    @Override
    protected boolean isFilterPassed() {
        return this.getColumnLong(SVNWCDbSchema$NODES__Fields.op_depth) == 0L && this.expectedPresence.contains((Object)SvnWcDbStatementUtil.getColumnPresence(this)) && this.isColumnNull(SVNWCDbSchema$NODES__Fields.file_external);
    }

    @Override
    protected Object[] getWhere() {
        return new Object[]{this.getBind(1)};
    }
}

