/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db.statement;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbNodesCurrent;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema$ACTUAL_NODE__Fields;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema$NODES__Fields;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema$NODES__Indices;

public class SVNWCDbCollectTargets
extends SVNWCDbNodesCurrent {
    private SVNDepth depth;
    private File target;
    private Collection changelists;
    private SVNSqlJetSelectStatement selectChangelist;
    private Set receivedPaths;

    public SVNWCDbCollectTargets(SVNSqlJetDb sVNSqlJetDb, long l2, File file, SVNDepth sVNDepth, Collection collection) {
        super(sVNSqlJetDb);
        this.setDepth(sVNDepth);
        this.setTarget(file);
        this.setChangelists(collection);
        if (this.getChangelists() != null && !this.getChangelists().isEmpty()) {
            this.selectChangelist = new SVNSqlJetSelectStatement(sVNSqlJetDb, SVNWCDbSchema.ACTUAL_NODE);
        }
        if (this.getDepth() == SVNDepth.FILES || this.getDepth() == SVNDepth.IMMEDIATES) {
            this.setIndexName(SVNWCDbSchema$NODES__Indices.I_NODES_PARENT.toString());
            this.receivedPaths = new HashSet();
        }
        if (this.getDepth() == SVNDepth.FILES || this.getDepth() == SVNDepth.IMMEDIATES || this.getDepth() == SVNDepth.EMPTY) {
            this.bindf("is", l2, this.getTarget());
        } else {
            this.bindf("i", l2);
        }
    }

    @Override
    protected boolean isFilterPassed() {
        if (this.getDepth() == SVNDepth.FILES || this.getDepth() == SVNDepth.IMMEDIATES ? !this.receivedPaths.add(this.getColumnString(SVNWCDbSchema$NODES__Fields.local_relpath)) : !super.isFilterPassed()) {
            return false;
        }
        if (this.getDepth() == SVNDepth.FILES) {
            String string = this.getColumnString(SVNWCDbSchema$NODES__Fields.kind);
            return "file".equals(string) && this.matchesChangelist();
        }
        if (this.getDepth() == SVNDepth.INFINITY) {
            String string = SVNFileUtil.getFilePath(this.getTarget());
            if ("".equals(string)) {
                return this.matchesChangelist();
            }
            String string2 = this.getColumnString(SVNWCDbSchema$NODES__Fields.local_relpath);
            return (string.equals(string2) || string2.startsWith(string + '/')) && this.matchesChangelist();
        }
        return this.matchesChangelist();
    }

    private boolean matchesChangelist() {
        if (this.getChangelists() == null || this.getChangelists().isEmpty()) {
            return true;
        }
        try {
            this.selectChangelist.bindf("is", this.getColumnLong(SVNWCDbSchema$NODES__Fields.wc_id), this.getColumnString(SVNWCDbSchema$NODES__Fields.local_relpath));
            if (this.selectChangelist.next()) {
                boolean bl2 = this.changelists.contains(this.selectChangelist.getColumnString(SVNWCDbSchema$ACTUAL_NODE__Fields.changelist));
                return bl2;
            }
        }
        finally {
            this.selectChangelist.reset();
        }
        return false;
    }

    private File getTarget() {
        return this.target;
    }

    private SVNDepth getDepth() {
        return this.depth;
    }

    private Collection getChangelists() {
        return this.changelists;
    }

    private void setDepth(SVNDepth sVNDepth) {
        this.depth = sVNDepth;
    }

    private void setTarget(File file) {
        this.target = file;
    }

    private void setChangelists(Collection collection) {
        this.changelists = collection == null ? collection : new HashSet(collection);
    }
}

