/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb$Mode;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc16.SVNUpdateClient16;
import org.tmatesoft.svn.core.internal.wc17.SVNExternalsStore;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbDeletionInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbDeletionInfo$DeletionInfoField;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb$DirParsedInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb$ReposInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbDir;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$AdditionInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$DeletionInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$MovedFromInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$MovedInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$RepositoryInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbProperties;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared$1;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared$Target;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbCollectTargets;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema$ACTUAL_NODE__Fields;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema$LOCK__Fields;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema$NODES__Fields;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema$REPOSITORY__Fields;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnWcDbShared {
    public static final byte[] EMPTY_PROPS_BLOB = new byte[]{40, 41};

    public static void begingReadTransaction(SVNWCDbRoot sVNWCDbRoot) {
        sVNWCDbRoot.getSDb().beginTransaction(SqlJetTransactionMode.READ_ONLY);
    }

    public static void begingWriteTransaction(SVNWCDbRoot sVNWCDbRoot) {
        sVNWCDbRoot.getSDb().beginTransaction(SqlJetTransactionMode.WRITE);
    }

    public static void commitTransaction(SVNWCDbRoot sVNWCDbRoot) {
        sVNWCDbRoot.getSDb().commit();
    }

    public static void rollbackTransaction(SVNWCDbRoot sVNWCDbRoot) {
        sVNWCDbRoot.getSDb().rollback();
    }

    protected static void nodeNotFound(File file) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)file);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
    }

    protected static void nodeIsNotInstallable(File file) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' is not installable.", (Object)file);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean doesNodeExists(SVNWCDbRoot sVNWCDbRoot, File file) {
        SVNSqlJetStatement sVNSqlJetStatement = null;
        try {
            sVNSqlJetStatement = sVNWCDbRoot.getSDb().getStatement(SVNWCDbStatements.DOES_NODE_EXIST);
            sVNSqlJetStatement.bindf("is", sVNWCDbRoot.getWcId(), file);
            boolean bl2 = sVNSqlJetStatement.next();
            return bl2;
        }
        finally {
            if (sVNSqlJetStatement != null) {
                sVNSqlJetStatement.reset();
            }
        }
    }

    protected static void nodeNotFound(SVNWCDbRoot sVNWCDbRoot, File file) {
        SvnWcDbShared.nodeNotFound(sVNWCDbRoot.getAbsPath(file));
    }

    protected static void sqliteError(SqlJetException sqlJetException) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, sqlJetException);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Collection collectTargets(SVNWCDbRoot sVNWCDbRoot, File file, SVNDepth sVNDepth, Collection collection) {
        SVNWCDbCollectTargets sVNWCDbCollectTargets = null;
        ArrayList<SvnWcDbShared$Target> arrayList = new ArrayList<SvnWcDbShared$Target>();
        try {
            String string;
            long l2;
            sVNWCDbCollectTargets = new SVNWCDbCollectTargets(sVNWCDbRoot.getSDb(), sVNWCDbRoot.getWcId(), file, sVNDepth, collection);
            while (((SVNSqlJetStatement)sVNWCDbCollectTargets).next()) {
                l2 = SvnWcDbStatementUtil.getColumnInt64(sVNWCDbCollectTargets, SVNWCDbSchema$NODES__Fields.wc_id);
                string = SvnWcDbStatementUtil.getColumnText(sVNWCDbCollectTargets, SVNWCDbSchema$NODES__Fields.local_relpath);
                arrayList.add(new SvnWcDbShared$Target(l2, string));
            }
            if (sVNDepth == SVNDepth.FILES || sVNDepth == SVNDepth.IMMEDIATES) {
                SvnWcDbStatementUtil.reset(sVNWCDbCollectTargets);
                sVNWCDbCollectTargets = new SVNWCDbCollectTargets(sVNWCDbRoot.getSDb(), sVNWCDbRoot.getWcId(), file, SVNDepth.EMPTY, collection);
                while (((SVNSqlJetStatement)sVNWCDbCollectTargets).next()) {
                    l2 = SvnWcDbStatementUtil.getColumnInt64(sVNWCDbCollectTargets, SVNWCDbSchema$NODES__Fields.wc_id);
                    string = SvnWcDbStatementUtil.getColumnText(sVNWCDbCollectTargets, SVNWCDbSchema$NODES__Fields.local_relpath);
                    arrayList.add(new SvnWcDbShared$Target(l2, string));
                }
            }
        }
        catch (Throwable throwable) {
            SvnWcDbStatementUtil.reset(sVNWCDbCollectTargets);
            throw throwable;
        }
        SvnWcDbStatementUtil.reset(sVNWCDbCollectTargets);
        return arrayList;
    }

    public static Structure scanAddition(SVNWCDb sVNWCDb, File file) {
        SVNWCDb$ReposInfo sVNWCDb$ReposInfo;
        SVNWCDb$DirParsedInfo sVNWCDb$DirParsedInfo = sVNWCDb.parseDir(file, SVNSqlJetDb$Mode.ReadOnly);
        SVNWCDbDir sVNWCDbDir = sVNWCDb$DirParsedInfo.wcDbDir;
        File file2 = sVNWCDb$DirParsedInfo.localRelPath;
        Structure structure = SvnWcDbShared.scanAddition(sVNWCDbDir.getWCRoot(), file2, new StructureFields$AdditionInfo[0]);
        if (structure.hasField(StructureFields$AdditionInfo.reposRootUrl)) {
            sVNWCDb$ReposInfo = sVNWCDb.fetchReposInfo(sVNWCDbDir.getWCRoot().getSDb(), structure.lng(StructureFields$AdditionInfo.reposId));
            structure.set((Enum)StructureFields$AdditionInfo.reposRootUrl, SVNURL.parseURIEncoded(sVNWCDb$ReposInfo.reposRootUrl));
            structure.set((Enum)StructureFields$AdditionInfo.reposUuid, sVNWCDb$ReposInfo.reposUuid);
        }
        if (structure.hasField(StructureFields$AdditionInfo.originalRootUrl) && structure.lng(StructureFields$AdditionInfo.originalReposId) >= 0L) {
            sVNWCDb$ReposInfo = sVNWCDb.fetchReposInfo(sVNWCDbDir.getWCRoot().getSDb(), structure.lng(StructureFields$AdditionInfo.originalReposId));
            structure.set((Enum)StructureFields$AdditionInfo.originalRootUrl, SVNURL.parseURIEncoded(sVNWCDb$ReposInfo.reposRootUrl));
            structure.set((Enum)StructureFields$AdditionInfo.originalUuid, sVNWCDb$ReposInfo.reposUuid);
        }
        return structure;
    }

    public static Structure scanMoved(SVNWCDb sVNWCDb, File file) {
        Structure structure = Structure.obtain(StructureFields$MovedInfo.class);
        SVNWCDb$DirParsedInfo sVNWCDb$DirParsedInfo = sVNWCDb.parseDir(file, SVNSqlJetDb$Mode.ReadOnly);
        SVNWCDbDir sVNWCDbDir = sVNWCDb$DirParsedInfo.wcDbDir;
        File file2 = sVNWCDb$DirParsedInfo.localRelPath;
        SVNWCDbRoot sVNWCDbRoot = sVNWCDbDir.getWCRoot();
        Structure structure2 = SvnWcDbShared.scanAddition(sVNWCDbDir.getWCRoot(), file2, StructureFields$AdditionInfo.values());
        if (structure2.get(StructureFields$AdditionInfo.status) != ISVNWCDb$SVNWCDbStatus.MovedHere || structure2.get(StructureFields$AdditionInfo.movedFromRelPath) == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Path ''{0}'' was not moved here", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        structure.set((Enum)StructureFields$MovedInfo.opRootAbsPath, structure2.get(StructureFields$AdditionInfo.opRootAbsPath));
        structure.set((Enum)StructureFields$MovedInfo.movedFromAbsPath, sVNWCDbRoot.getAbsPath((File)structure2.get(StructureFields$AdditionInfo.movedFromRelPath)));
        structure.set((Enum)StructureFields$MovedInfo.movedFromOpRootAbsPath, sVNWCDbRoot.getAbsPath((File)structure2.get(StructureFields$AdditionInfo.movedFromOpRootRelPath)));
        long l2 = structure2.lng(StructureFields$AdditionInfo.movedFromOpDepth);
        File file3 = (File)structure2.get(StructureFields$AdditionInfo.movedFromOpRootRelPath);
        while ((long)SVNWCUtils.relpathDepth(file3) > l2) {
            file3 = SVNFileUtil.getFileDir(file3);
        }
        structure.set((Enum)StructureFields$MovedInfo.movedFromDeleteAbsPath, sVNWCDbRoot.getAbsPath(file3));
        return structure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Structure scanAddition(SVNWCDbRoot sVNWCDbRoot, File file, StructureFields$AdditionInfo ... structureFields$AdditionInfoArray) {
        Structure structure = Structure.obtain(StructureFields$AdditionInfo.class, structureFields$AdditionInfoArray);
        structure.set((Enum)StructureFields$AdditionInfo.originalRevision, -1L);
        structure.set((Enum)StructureFields$AdditionInfo.originalReposId, -1L);
        structure.set((Enum)StructureFields$AdditionInfo.movedFromOpDepth, 0L);
        SvnWcDbShared.begingReadTransaction(sVNWCDbRoot);
        File file2 = SVNFileUtil.createFilePath("");
        File file3 = file;
        SVNSqlJetStatement sVNSqlJetStatement = null;
        try {
            Object object;
            File file4 = SVNFileUtil.createFilePath("");
            sVNSqlJetStatement = sVNWCDbRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_WORKING_NODE);
            sVNSqlJetStatement.bindf("is", sVNWCDbRoot.getWcId(), file);
            if (!sVNSqlJetStatement.next()) {
                SvnWcDbStatementUtil.reset(sVNSqlJetStatement);
                SvnWcDbShared.nodeNotFound(sVNWCDbRoot, file);
            }
            ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus = SvnWcDbStatementUtil.getColumnPresence(sVNSqlJetStatement);
            long l2 = SvnWcDbStatementUtil.getColumnInt64(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.op_depth);
            if (l2 == 0L || iSVNWCDb$SVNWCDbStatus != ISVNWCDb$SVNWCDbStatus.Normal && iSVNWCDb$SVNWCDbStatus != ISVNWCDb$SVNWCDbStatus.Incomplete) {
                SvnWcDbStatementUtil.reset(sVNSqlJetStatement);
                object = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Expected node ''{0}'' to be added.", (Object)sVNWCDbRoot.getAbsPath(file));
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            structure.set((Enum)StructureFields$AdditionInfo.originalRevision, SvnWcDbStatementUtil.getColumnRevNum(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.revision));
            structure.set((Enum)StructureFields$AdditionInfo.status, (Object)ISVNWCDb$SVNWCDbStatus.Added);
            file3 = file;
            int n2 = SVNWCUtils.relpathDepth(file);
            while ((long)n2 > l2) {
                file4 = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(SVNFileUtil.getFileName(file3)), file4);
                file3 = SVNFileUtil.getFileDir(file3);
                --n2;
            }
            structure.set((Enum)StructureFields$AdditionInfo.opRootRelPath, file3);
            structure.set((Enum)StructureFields$AdditionInfo.opRootAbsPath, sVNWCDbRoot.getAbsPath(file3));
            if (structure.hasField(StructureFields$AdditionInfo.originalReposRelPath) || structure.hasField(StructureFields$AdditionInfo.originalRootUrl) || structure.hasField(StructureFields$AdditionInfo.originalUuid) || structure.hasField(StructureFields$AdditionInfo.originalRevision) && structure.lng(StructureFields$AdditionInfo.originalRevision) == -1L || structure.hasField(StructureFields$AdditionInfo.status)) {
                if (!file.equals(file3)) {
                    SvnWcDbStatementUtil.reset(sVNSqlJetStatement);
                    sVNSqlJetStatement.bindf("is", sVNWCDbRoot.getWcId(), file3);
                    if (!sVNSqlJetStatement.next()) {
                        SvnWcDbStatementUtil.reset(sVNSqlJetStatement);
                        SvnWcDbShared.nodeNotFound(sVNWCDbRoot, file3);
                    }
                    if (structure.hasField(StructureFields$AdditionInfo.originalRevision) && structure.lng(StructureFields$AdditionInfo.originalRevision) == -1L) {
                        structure.set((Enum)StructureFields$AdditionInfo.originalRevision, SvnWcDbStatementUtil.getColumnRevNum(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.revision));
                    }
                }
                structure.set((Enum)StructureFields$AdditionInfo.originalReposRelPath, SvnWcDbStatementUtil.getColumnPath(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.repos_path));
                if (!SvnWcDbStatementUtil.isColumnNull(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.repos_id) && (structure.hasField(StructureFields$AdditionInfo.status) || structure.hasField(StructureFields$AdditionInfo.originalReposId) || structure.hasField(StructureFields$AdditionInfo.movedFromRelPath) || structure.hasField(StructureFields$AdditionInfo.movedFromOpRootRelPath))) {
                    structure.set((Enum)StructureFields$AdditionInfo.originalReposId, SvnWcDbStatementUtil.getColumnInt64(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.repos_id));
                    boolean bl2 = SvnWcDbStatementUtil.getColumnBoolean(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.moved_here);
                    if (bl2) {
                        structure.set((Enum)StructureFields$AdditionInfo.status, (Object)ISVNWCDb$SVNWCDbStatus.MovedHere);
                    } else {
                        structure.set((Enum)StructureFields$AdditionInfo.status, (Object)ISVNWCDb$SVNWCDbStatus.Copied);
                    }
                    if (bl2 && (structure.hasField(StructureFields$AdditionInfo.movedFromRelPath) || structure.hasField(StructureFields$AdditionInfo.movedFromOpRootRelPath))) {
                        Structure structure2 = SvnWcDbShared.getMovedFromInfo(sVNWCDbRoot, file3, file);
                        if (structure2.hasValue(StructureFields$MovedFromInfo.opDepth)) {
                            structure.set((Enum)StructureFields$AdditionInfo.movedFromOpDepth, structure2.lng(StructureFields$MovedFromInfo.opDepth));
                        }
                        structure.set((Enum)StructureFields$AdditionInfo.movedFromOpRootRelPath, structure2.get(StructureFields$MovedFromInfo.movedFromOpRootRelPath));
                        structure.set((Enum)StructureFields$AdditionInfo.movedFromRelPath, structure2.get(StructureFields$MovedFromInfo.movedFromRelPath));
                    }
                }
            }
            block3: while (true) {
                SvnWcDbStatementUtil.reset(sVNSqlJetStatement);
                file4 = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(SVNFileUtil.getFileName(file3)), file4);
                file3 = SVNFileUtil.getFileDir(file3);
                sVNSqlJetStatement.bindf("is", sVNWCDbRoot.getWcId(), file3);
                if (!sVNSqlJetStatement.next()) break;
                l2 = SvnWcDbStatementUtil.getColumnInt64(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.op_depth);
                n2 = SVNWCUtils.relpathDepth(file3);
                while (true) {
                    if ((long)n2 <= l2) continue block3;
                    file4 = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(SVNFileUtil.getFileName(file3)), file4);
                    file3 = SVNFileUtil.getFileDir(file3);
                    --n2;
                }
                break;
            }
            SvnWcDbStatementUtil.reset(sVNSqlJetStatement);
            file2 = file4;
            if (structure.hasField(StructureFields$AdditionInfo.reposRelPath) || structure.hasField(StructureFields$AdditionInfo.reposId)) {
                object = SvnWcDbShared.getDepthInfo(sVNWCDbRoot, file3, 0L, StructureFields$NodeInfo.reposRelPath, StructureFields$NodeInfo.reposId);
                structure.set((Enum)StructureFields$AdditionInfo.reposRelPath, SVNFileUtil.createFilePath((File)((Structure)object).get(StructureFields$NodeInfo.reposRelPath), file2));
                structure.set((Enum)StructureFields$AdditionInfo.reposId, ((Structure)object).lng(StructureFields$NodeInfo.reposId));
                ((Structure)object).release();
            }
        }
        catch (Throwable throwable) {
            SvnWcDbStatementUtil.reset(sVNSqlJetStatement);
            SvnWcDbShared.commitTransaction(sVNWCDbRoot);
            throw throwable;
        }
        SvnWcDbStatementUtil.reset(sVNSqlJetStatement);
        SvnWcDbShared.commitTransaction(sVNWCDbRoot);
        return structure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Structure getMovedFromInfo(SVNWCDbRoot sVNWCDbRoot, File file, File file2) {
        SVNSqlJetStatement sVNSqlJetStatement;
        Structure structure;
        block5: {
            block4: {
                Structure structure2;
                structure = Structure.obtain(StructureFields$MovedFromInfo.class);
                sVNSqlJetStatement = null;
                try {
                    sVNSqlJetStatement = sVNWCDbRoot.getSDb().getStatement(sVNWCDbRoot.getFormat() == 29 ? SVNWCDbStatements.SELECT_MOVED_FROM_RELPATH_17 : SVNWCDbStatements.SELECT_MOVED_FROM_RELPATH);
                    sVNSqlJetStatement.bindf("is", sVNWCDbRoot.getWcId(), file);
                    if (sVNSqlJetStatement.next()) break block4;
                    structure2 = structure;
                }
                catch (Throwable throwable) {
                    SvnWcDbStatementUtil.reset(sVNSqlJetStatement);
                    throw throwable;
                }
                SvnWcDbStatementUtil.reset(sVNSqlJetStatement);
                return structure2;
            }
            structure.set((Enum)StructureFields$MovedFromInfo.opDepth, SvnWcDbStatementUtil.getColumnInt64(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.op_depth));
            File file3 = SvnWcDbStatementUtil.getColumnPath(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.local_relpath);
            structure.set((Enum)StructureFields$MovedFromInfo.movedFromOpRootRelPath, file3);
            if (file.equals(file2)) {
                structure.set((Enum)StructureFields$MovedFromInfo.movedFromRelPath, file3);
                break block5;
            }
            File file4 = SVNWCUtils.skipAncestor(file, file2);
            structure.set((Enum)StructureFields$MovedFromInfo.movedFromRelPath, SVNFileUtil.createFilePath(file3, file4));
        }
        SvnWcDbStatementUtil.reset(sVNSqlJetStatement);
        return structure;
    }

    public static Structure scanDeletion(SVNWCDb sVNWCDb, File file) {
        SVNWCDb$DirParsedInfo sVNWCDb$DirParsedInfo = sVNWCDb.parseDir(file, SVNSqlJetDb$Mode.ReadOnly);
        SVNWCDbDir sVNWCDbDir = sVNWCDb$DirParsedInfo.wcDbDir;
        File file2 = sVNWCDb$DirParsedInfo.localRelPath;
        return SvnWcDbShared.scanDeletion(sVNWCDbDir.getWCRoot(), file2);
    }

    protected static Structure scanDeletion(SVNWCDbRoot sVNWCDbRoot, File file) {
        Structure structure = Structure.obtain(StructureFields$DeletionInfo.class);
        ISVNWCDb$WCDbDeletionInfo iSVNWCDb$WCDbDeletionInfo = sVNWCDbRoot.getDb().scanDeletion(SVNFileUtil.createFilePath(sVNWCDbRoot.getAbsPath(), file), ISVNWCDb$WCDbDeletionInfo$DeletionInfoField.values());
        structure.set((Enum)StructureFields$DeletionInfo.baseDelRelPath, SVNFileUtil.skipAncestor(sVNWCDbRoot.getAbsPath(), iSVNWCDb$WCDbDeletionInfo.baseDelAbsPath));
        structure.set((Enum)StructureFields$DeletionInfo.movedToRelPath, SVNFileUtil.skipAncestor(sVNWCDbRoot.getAbsPath(), iSVNWCDb$WCDbDeletionInfo.movedToAbsPath));
        structure.set((Enum)StructureFields$DeletionInfo.movedToOpRootRelPath, SVNFileUtil.skipAncestor(sVNWCDbRoot.getAbsPath(), iSVNWCDb$WCDbDeletionInfo.movedToOpRootAbsPath));
        structure.set((Enum)StructureFields$DeletionInfo.workDelAbsPath, iSVNWCDb$WCDbDeletionInfo.workDelAbsPath);
        structure.set((Enum)StructureFields$DeletionInfo.workDelRelPath, SVNFileUtil.skipAncestor(sVNWCDbRoot.getAbsPath(), iSVNWCDb$WCDbDeletionInfo.baseDelAbsPath));
        return structure;
    }

    public static Structure getBaseInfo(SVNWCDbRoot sVNWCDbRoot, File file, StructureFields$NodeInfo ... structureFields$NodeInfoArray) {
        return SvnWcDbShared.getDepthInfo(sVNWCDbRoot, file, 0L, structureFields$NodeInfoArray);
    }

    public static Structure getBaseInfo(SVNWCDb sVNWCDb, File file, StructureFields$NodeInfo ... structureFields$NodeInfoArray) {
        SVNWCDb$DirParsedInfo sVNWCDb$DirParsedInfo = sVNWCDb.parseDir(file, SVNSqlJetDb$Mode.ReadOnly);
        SVNWCDbDir sVNWCDbDir = sVNWCDb$DirParsedInfo.wcDbDir;
        File file2 = sVNWCDb$DirParsedInfo.localRelPath;
        return SvnWcDbShared.getDepthInfo(sVNWCDbDir.getWCRoot(), file2, 0L, structureFields$NodeInfoArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Structure getDepthInfo(SVNWCDbRoot sVNWCDbRoot, File file, long l2, StructureFields$NodeInfo ... structureFields$NodeInfoArray) {
        Structure structure;
        block32: {
            structure = Structure.obtain(StructureFields$NodeInfo.class, structureFields$NodeInfoArray);
            SVNSqlJetStatement sVNSqlJetStatement = sVNWCDbRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_DEPTH_NODE);
            try {
                sVNSqlJetStatement.bindf("isi", sVNWCDbRoot.getWcId(), SVNFileUtil.getFilePath(file), l2);
                if (sVNSqlJetStatement.next()) {
                    Object object;
                    ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind = SvnWcDbStatementUtil.getColumnKind(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.kind);
                    if (structure.hasField(StructureFields$NodeInfo.kind)) {
                        structure.set((Enum)StructureFields$NodeInfo.kind, (Object)iSVNWCDb$SVNWCDbKind);
                    }
                    if (structure.hasField(StructureFields$NodeInfo.status)) {
                        structure.set((Enum)StructureFields$NodeInfo.status, (Object)SvnWcDbStatementUtil.getColumnPresence(sVNSqlJetStatement));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.reposId)) {
                        structure.set((Enum)StructureFields$NodeInfo.reposId, SvnWcDbStatementUtil.getColumnInt64(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.repos_id));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.revision)) {
                        structure.set((Enum)StructureFields$NodeInfo.revision, SvnWcDbStatementUtil.getColumnRevNum(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.revision));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.reposRelPath)) {
                        structure.set((Enum)StructureFields$NodeInfo.reposRelPath, SvnWcDbStatementUtil.getColumnPath(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.repos_path));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.reposRootUrl) || structure.hasField(StructureFields$NodeInfo.reposUuid)) {
                        if (SvnWcDbStatementUtil.isColumnNull(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.repos_id)) {
                            if (structure.hasField(StructureFields$NodeInfo.reposRootUrl)) {
                                structure.set((Enum)StructureFields$NodeInfo.reposRootUrl, null);
                            }
                            if (structure.hasField(StructureFields$NodeInfo.reposUuid)) {
                                structure.set((Enum)StructureFields$NodeInfo.reposUuid, null);
                            }
                        } else {
                            object = sVNWCDbRoot.getDb().fetchRepositoryInfo(sVNWCDbRoot.getSDb(), SvnWcDbStatementUtil.getColumnInt64(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.repos_id));
                            ((Structure)object).from(StructureFields$RepositoryInfo.reposRootUrl, StructureFields$RepositoryInfo.reposUuid).into(structure, StructureFields$NodeInfo.reposRootUrl, StructureFields$NodeInfo.reposUuid);
                            ((Structure)object).release();
                        }
                    }
                    if (structure.hasField(StructureFields$NodeInfo.changedRev)) {
                        structure.set((Enum)StructureFields$NodeInfo.changedRev, SvnWcDbStatementUtil.getColumnRevNum(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.changed_revision));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.changedDate)) {
                        structure.set((Enum)StructureFields$NodeInfo.changedDate, SvnWcDbStatementUtil.getColumnDate(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.changed_date));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.changedAuthor)) {
                        structure.set((Enum)StructureFields$NodeInfo.changedAuthor, SvnWcDbStatementUtil.getColumnText(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.changed_author));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.depth)) {
                        if (iSVNWCDb$SVNWCDbKind != ISVNWCDb$SVNWCDbKind.Dir) {
                            structure.set((Enum)StructureFields$NodeInfo.depth, SVNDepth.UNKNOWN);
                        } else {
                            object = SvnWcDbStatementUtil.getColumnText(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.depth);
                            if (object == null) {
                                structure.set((Enum)StructureFields$NodeInfo.depth, SVNDepth.UNKNOWN);
                            } else {
                                structure.set((Enum)StructureFields$NodeInfo.depth, SvnWcDbStatementUtil.parseDepth((String)object));
                            }
                        }
                    }
                    if (structure.hasField(StructureFields$NodeInfo.checksum)) {
                        if (iSVNWCDb$SVNWCDbKind != ISVNWCDb$SVNWCDbKind.File) {
                            structure.set((Enum)StructureFields$NodeInfo.checksum, null);
                        } else {
                            try {
                                structure.set((Enum)StructureFields$NodeInfo.checksum, SvnWcDbStatementUtil.getColumnChecksum(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.checksum));
                            }
                            catch (SVNException sVNException) {
                                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(sVNException.getErrorMessage().getErrorCode(), "The node ''{0}'' has a corrupt checksum value.", (Object)sVNWCDbRoot.getAbsPath(file));
                                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                            }
                        }
                    }
                    if (structure.hasField(StructureFields$NodeInfo.target)) {
                        if (iSVNWCDb$SVNWCDbKind != ISVNWCDb$SVNWCDbKind.Symlink) {
                            structure.set((Enum)StructureFields$NodeInfo.target, null);
                        } else {
                            structure.set((Enum)StructureFields$NodeInfo.target, SvnWcDbStatementUtil.getColumnPath(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.symlink_target));
                        }
                    }
                    if (structure.hasField(StructureFields$NodeInfo.updateRoot)) {
                        structure.set((Enum)StructureFields$NodeInfo.updateRoot, SvnWcDbStatementUtil.getColumnText(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.file_external) != null);
                    }
                    if (structure.hasField(StructureFields$NodeInfo.hadProps)) {
                        structure.set((Enum)StructureFields$NodeInfo.hadProps, SvnWcDbStatementUtil.hasColumnProperties(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.properties));
                    }
                    break block32;
                }
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)sVNWCDbRoot.getAbsPath(file));
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            finally {
                sVNSqlJetStatement.reset();
            }
        }
        return structure;
    }

    protected static Structure readInfo(SVNWCDbRoot sVNWCDbRoot, File file, StructureFields$NodeInfo ... structureFields$NodeInfoArray) {
        return SvnWcDbShared.readInfo(sVNWCDbRoot, file, false, structureFields$NodeInfoArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Structure readInfo(SVNWCDbRoot sVNWCDbRoot, File file, boolean bl2, StructureFields$NodeInfo ... structureFields$NodeInfoArray) {
        Structure structure;
        block67: {
            structure = Structure.obtain(StructureFields$NodeInfo.class, structureFields$NodeInfoArray);
            SVNSqlJetStatement sVNSqlJetStatement = null;
            SVNSqlJetStatement sVNSqlJetStatement2 = null;
            try {
                sVNSqlJetStatement = sVNWCDbRoot.getSDb().getStatement(structure.hasField(StructureFields$NodeInfo.lock) ? SVNWCDbStatements.SELECT_NODE_INFO_WITH_LOCK : SVNWCDbStatements.SELECT_NODE_INFO);
                sVNSqlJetStatement.bindf("is", sVNWCDbRoot.getWcId(), file);
                boolean bl3 = sVNSqlJetStatement.next();
                boolean bl4 = false;
                if (structure.hasField(StructureFields$NodeInfo.changelist) || structure.hasField(StructureFields$NodeInfo.conflicted) || structure.hasField(StructureFields$NodeInfo.propsMod)) {
                    sVNSqlJetStatement2 = sVNWCDbRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
                    sVNSqlJetStatement2.bindf("is", sVNWCDbRoot.getWcId(), file);
                    bl4 = sVNSqlJetStatement2.next();
                }
                if (bl3) {
                    Object object;
                    Object object2;
                    long l2 = SvnWcDbStatementUtil.getColumnInt64(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.op_depth);
                    ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind = SvnWcDbStatementUtil.getColumnKind(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.kind);
                    if (structure.hasField(StructureFields$NodeInfo.status)) {
                        structure.set((Enum)StructureFields$NodeInfo.status, (Object)SvnWcDbStatementUtil.getColumnPresence(sVNSqlJetStatement));
                        if (l2 != 0L) {
                            structure.set((Enum)StructureFields$NodeInfo.status, (Object)SVNWCDb.getWorkingStatus((ISVNWCDb$SVNWCDbStatus)((Object)structure.get(StructureFields$NodeInfo.status))));
                        }
                    }
                    if (structure.hasField(StructureFields$NodeInfo.kind)) {
                        structure.set((Enum)StructureFields$NodeInfo.kind, (Object)iSVNWCDb$SVNWCDbKind);
                    }
                    structure.set((Enum)StructureFields$NodeInfo.reposId, l2 != 0L ? -1L : SvnWcDbStatementUtil.getColumnInt64(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.repos_id));
                    if (structure.hasField(StructureFields$NodeInfo.revision)) {
                        structure.set((Enum)StructureFields$NodeInfo.revision, l2 != 0L ? -1L : SvnWcDbStatementUtil.getColumnRevNum(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.revision));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.reposRelPath)) {
                        structure.set((Enum)StructureFields$NodeInfo.reposRelPath, l2 != 0L ? null : SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.repos_path)));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.changedDate)) {
                        structure.set((Enum)StructureFields$NodeInfo.changedDate, SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.changed_date)));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.changedRev)) {
                        structure.set((Enum)StructureFields$NodeInfo.changedRev, SvnWcDbStatementUtil.getColumnRevNum(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.changed_revision));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.changedAuthor)) {
                        structure.set((Enum)StructureFields$NodeInfo.changedAuthor, SvnWcDbStatementUtil.getColumnText(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.changed_author));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.recordedTime)) {
                        structure.set((Enum)StructureFields$NodeInfo.recordedTime, SvnWcDbStatementUtil.getColumnInt64(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.last_mod_time));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.depth)) {
                        if (iSVNWCDb$SVNWCDbKind != ISVNWCDb$SVNWCDbKind.Dir) {
                            structure.set((Enum)StructureFields$NodeInfo.depth, SVNDepth.UNKNOWN);
                        } else {
                            structure.set((Enum)StructureFields$NodeInfo.depth, SvnWcDbStatementUtil.getColumnDepth(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.depth));
                        }
                    }
                    if (structure.hasField(StructureFields$NodeInfo.checksum)) {
                        if (iSVNWCDb$SVNWCDbKind != ISVNWCDb$SVNWCDbKind.File) {
                            structure.set((Enum)StructureFields$NodeInfo.checksum, null);
                        } else {
                            try {
                                structure.set((Enum)StructureFields$NodeInfo.checksum, SvnWcDbStatementUtil.getColumnChecksum(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.checksum));
                            }
                            catch (SVNException sVNException) {
                                object2 = SVNErrorMessage.create(sVNException.getErrorMessage().getErrorCode(), "The node ''{0}'' has a corrupt checksum value.", (Object)sVNWCDbRoot.getAbsPath(file));
                                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
                            }
                        }
                    }
                    if (structure.hasField(StructureFields$NodeInfo.recordedSize)) {
                        structure.set((Enum)StructureFields$NodeInfo.recordedSize, SvnWcDbStatementUtil.getColumnInt64(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.translated_size));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.target)) {
                        structure.set((Enum)StructureFields$NodeInfo.target, SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.symlink_target)));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.changelist) && bl4) {
                        structure.set((Enum)StructureFields$NodeInfo.changelist, SvnWcDbStatementUtil.getColumnText(sVNSqlJetStatement2, SVNWCDbSchema$ACTUAL_NODE__Fields.changelist));
                    }
                    structure.set((Enum)StructureFields$NodeInfo.originalReposId, l2 == 0L ? -1L : SvnWcDbStatementUtil.getColumnInt64(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.repos_id));
                    if (structure.hasField(StructureFields$NodeInfo.originalRevision)) {
                        structure.set((Enum)StructureFields$NodeInfo.originalRevision, l2 == 0L ? -1L : SvnWcDbStatementUtil.getColumnRevNum(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.revision));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.originalReposRelpath)) {
                        structure.set((Enum)StructureFields$NodeInfo.originalReposRelpath, l2 == 0L ? null : SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.repos_path)));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.propsMod)) {
                        structure.set((Enum)StructureFields$NodeInfo.propsMod, bl4 && !SvnWcDbStatementUtil.isColumnNull(sVNSqlJetStatement2, SVNWCDbSchema$ACTUAL_NODE__Fields.properties));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.hadProps)) {
                        object = SvnWcDbStatementUtil.getColumnBlob(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.properties);
                        structure.set((Enum)StructureFields$NodeInfo.hadProps, object != null && ((byte[])object).length > 2);
                    }
                    if (structure.hasField(StructureFields$NodeInfo.conflicted)) {
                        if (bl4) {
                            if (sVNWCDbRoot.getFormat() == 29) {
                                structure.set((Enum)StructureFields$NodeInfo.conflicted, !SvnWcDbStatementUtil.isColumnNull(sVNSqlJetStatement2, SVNWCDbSchema$ACTUAL_NODE__Fields.tree_conflict_data) || !SvnWcDbStatementUtil.isColumnNull(sVNSqlJetStatement2, SVNWCDbSchema$ACTUAL_NODE__Fields.prop_reject) || !SvnWcDbStatementUtil.isColumnNull(sVNSqlJetStatement2, SVNWCDbSchema$ACTUAL_NODE__Fields.conflict_old) || !SvnWcDbStatementUtil.isColumnNull(sVNSqlJetStatement2, SVNWCDbSchema$ACTUAL_NODE__Fields.conflict_new) || !SvnWcDbStatementUtil.isColumnNull(sVNSqlJetStatement2, SVNWCDbSchema$ACTUAL_NODE__Fields.conflict_working));
                            } else {
                                structure.set((Enum)StructureFields$NodeInfo.conflicted, !SvnWcDbStatementUtil.isColumnNull(sVNSqlJetStatement2, SVNWCDbSchema$ACTUAL_NODE__Fields.conflict_data));
                            }
                        } else {
                            structure.set((Enum)StructureFields$NodeInfo.conflicted, false);
                        }
                    }
                    if (structure.hasField(StructureFields$NodeInfo.lock)) {
                        if (l2 == 0L) {
                            object = sVNSqlJetStatement.getJoinedStatement(SVNWCDbSchema.LOCK.toString());
                            object2 = SvnWcDbStatementUtil.getLockFromColumns((SVNSqlJetStatement)object, SVNWCDbSchema$LOCK__Fields.lock_token, SVNWCDbSchema$LOCK__Fields.lock_owner, SVNWCDbSchema$LOCK__Fields.lock_comment, SVNWCDbSchema$LOCK__Fields.lock_date);
                            structure.set((Enum)StructureFields$NodeInfo.lock, object2);
                        } else {
                            structure.set((Enum)StructureFields$NodeInfo.lock, null);
                        }
                    }
                    if (structure.hasField(StructureFields$NodeInfo.haveWork)) {
                        structure.set((Enum)StructureFields$NodeInfo.haveWork, l2 != 0L);
                    }
                    if (structure.hasField(StructureFields$NodeInfo.opRoot)) {
                        structure.set((Enum)StructureFields$NodeInfo.opRoot, l2 > 0L && l2 == (long)SVNWCUtils.relpathDepth(file));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.haveBase) || structure.hasField(StructureFields$NodeInfo.haveMoreWork)) {
                        if (structure.hasField(StructureFields$NodeInfo.haveMoreWork)) {
                            structure.set((Enum)StructureFields$NodeInfo.haveMoreWork, false);
                        }
                        while (l2 != 0L && (bl3 = sVNSqlJetStatement.next())) {
                            l2 = SvnWcDbStatementUtil.getColumnInt64(sVNSqlJetStatement, SVNWCDbSchema$NODES__Fields.op_depth);
                            if (!structure.hasField(StructureFields$NodeInfo.haveMoreWork)) continue;
                            if (l2 > 0L) {
                                structure.set((Enum)StructureFields$NodeInfo.haveMoreWork, true);
                            }
                            if (structure.hasField(StructureFields$NodeInfo.haveBase)) continue;
                        }
                        if (structure.hasField(StructureFields$NodeInfo.haveBase)) {
                            structure.set((Enum)StructureFields$NodeInfo.haveBase, l2 == 0L);
                        }
                    }
                    break block67;
                }
                if (bl4) {
                    if (SvnWcDbStatementUtil.isColumnNull(sVNSqlJetStatement2, SVNWCDbSchema$ACTUAL_NODE__Fields.conflict_data) && SvnWcDbStatementUtil.isColumnNull(sVNSqlJetStatement2, SVNWCDbSchema$ACTUAL_NODE__Fields.tree_conflict_data) && SvnWcDbStatementUtil.isColumnNull(sVNSqlJetStatement2, SVNWCDbSchema$ACTUAL_NODE__Fields.prop_reject) && SvnWcDbStatementUtil.isColumnNull(sVNSqlJetStatement2, SVNWCDbSchema$ACTUAL_NODE__Fields.conflict_old) && SvnWcDbStatementUtil.isColumnNull(sVNSqlJetStatement2, SVNWCDbSchema$ACTUAL_NODE__Fields.conflict_new) && SvnWcDbStatementUtil.isColumnNull(sVNSqlJetStatement2, SVNWCDbSchema$ACTUAL_NODE__Fields.conflict_working)) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Corrupt data for ''{0}''", (Object)sVNWCDbRoot.getAbsPath(file));
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                    }
                    structure.set((Enum)StructureFields$NodeInfo.conflicted, true);
                    if (structure.hasField(StructureFields$NodeInfo.opRoot)) {
                        structure.set((Enum)StructureFields$NodeInfo.opRoot, false);
                    }
                    if (structure.hasField(StructureFields$NodeInfo.status)) {
                        structure.set((Enum)StructureFields$NodeInfo.status, (Object)ISVNWCDb$SVNWCDbStatus.Normal);
                    }
                    if (structure.hasField(StructureFields$NodeInfo.kind)) {
                        structure.set((Enum)StructureFields$NodeInfo.kind, (Object)ISVNWCDb$SVNWCDbKind.Unknown);
                    }
                    if (structure.hasField(StructureFields$NodeInfo.revision)) {
                        structure.set((Enum)StructureFields$NodeInfo.revision, -1L);
                    }
                    structure.set((Enum)StructureFields$NodeInfo.reposId, -1L);
                    if (structure.hasField(StructureFields$NodeInfo.changedRev)) {
                        structure.set((Enum)StructureFields$NodeInfo.changedRev, -1L);
                    }
                    if (structure.hasField(StructureFields$NodeInfo.depth)) {
                        structure.set((Enum)StructureFields$NodeInfo.depth, SVNDepth.UNKNOWN);
                    }
                    if (structure.hasField(StructureFields$NodeInfo.originalRevision)) {
                        structure.set((Enum)StructureFields$NodeInfo.originalRevision, -1L);
                    }
                    if (structure.hasField(StructureFields$NodeInfo.originalReposId)) {
                        structure.set((Enum)StructureFields$NodeInfo.originalReposId, -1L);
                    }
                    if (structure.hasField(StructureFields$NodeInfo.changelist)) {
                        structure.set((Enum)StructureFields$NodeInfo.changelist, sVNSqlJetStatement2.getColumnString(SVNWCDbSchema$ACTUAL_NODE__Fields.changelist));
                    }
                    if (structure.hasField(StructureFields$NodeInfo.originalRevision)) {
                        structure.set((Enum)StructureFields$NodeInfo.originalRevision, -1L);
                    }
                } else {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)sVNWCDbRoot.getAbsPath(file));
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
            }
            finally {
                try {
                    if (sVNSqlJetStatement != null) {
                        sVNSqlJetStatement.reset();
                    }
                }
                catch (SVNException sVNException) {}
                try {
                    if (sVNSqlJetStatement2 != null) {
                        sVNSqlJetStatement2.reset();
                    }
                }
                catch (SVNException sVNException) {}
            }
        }
        return structure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void canonicalizeURLs(SVNWCDbRoot sVNWCDbRoot, boolean bl2, SVNExternalsStore sVNExternalsStore, boolean bl3) {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            SvnWcDbShared.begingWriteTransaction(sVNWCDbRoot);
            object = sVNWCDbRoot.getSDb().getDb().getTable(SVNWCDbSchema.REPOSITORY.toString());
            ISqlJetCursor iSqlJetCursor = object.open();
            while (!iSqlJetCursor.eof()) {
                String string;
                Object object2 = iSqlJetCursor.getString(SVNWCDbSchema$REPOSITORY__Fields.root.toString());
                SVNURL sVNURL = SVNUpdateClient16.canonicalizeURL(SVNURL.parseURIEncoded((String)object2), bl3);
                if (sVNURL != null && !((String)object2).equals(string = sVNURL.toString())) {
                    hashMap.put(SVNWCDbSchema$REPOSITORY__Fields.root.toString(), string);
                    iSqlJetCursor.updateByFieldNames(hashMap);
                }
                iSqlJetCursor.next();
            }
            iSqlJetCursor.close();
        }
        catch (SqlJetException sqlJetException) {
            SvnWcDbShared.rollbackTransaction(sVNWCDbRoot);
        }
        finally {
            SvnWcDbShared.commitTransaction(sVNWCDbRoot);
        }
        if (bl2) {
            object = new HashMap();
            SvnWcDbProperties.readPropertiesRecursively(sVNWCDbRoot, new File(""), SVNDepth.INFINITY, false, false, null, new SvnWcDbShared$1(bl3, (Map)object, sVNExternalsStore));
            for (Object object2 : object.keySet()) {
                sVNWCDbRoot.getDb().opSetProps((File)object2, (SVNProperties)object.get(object2), null, false, null);
            }
        }
    }
}

