/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetUpdateStatement;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb$DirParsedInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$AdditionInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$DeletionInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$RepositoryInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbRelocate$ISvnRelocateValidator;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbRelocate$RecursiveUpdateNodeRepo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbRelocate$UpdateLockReposId;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnWcDbRelocate
extends SvnWcDbShared {
    public static void relocate(SVNWCContext sVNWCContext, File file, SVNURL sVNURL, SVNURL sVNURL2, SvnWcDbRelocate$ISvnRelocateValidator svnWcDbRelocate$ISvnRelocateValidator) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (!sVNWCContext.getDb().isWCRoot(file)) {
            try {
                object5 = sVNWCContext.getDb().getWCRoot(file);
                object4 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OP_ON_CWD, "Cannot relocate ''{0}'' as it is not the root of a working copy; try relocating ''{1}'' instead", file, object5);
                SVNErrorManager.error(object4, SVNLogType.WC);
            }
            catch (SVNException sVNException) {
                object4 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OP_ON_CWD, "Cannot relocate ''{0}'' as it is not the root of a working copy", (Object)file);
                SVNErrorManager.error(object4, SVNLogType.WC);
            }
        }
        object5 = sVNWCContext.getDb().readInfo(file, StructureFields$NodeInfo.kind, StructureFields$NodeInfo.reposRelPath, StructureFields$NodeInfo.reposRootUrl, StructureFields$NodeInfo.reposUuid);
        object4 = (ISVNWCDb$SVNWCDbKind)((Object)((Structure)object5).get(StructureFields$NodeInfo.kind));
        File file2 = (File)((Structure)object5).get(StructureFields$NodeInfo.reposRelPath);
        SVNURL sVNURL3 = (SVNURL)((Structure)object5).get(StructureFields$NodeInfo.reposRootUrl);
        String string = (String)((Structure)object5).get(StructureFields$NodeInfo.reposUuid);
        if (object4 != ISVNWCDb$SVNWCDbKind.Dir) {
            object3 = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "Cannot relocate a single file");
            SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
        }
        if (!((SVNURL)(object3 = sVNURL3.appendPath(SVNFileUtil.getFilePath(file2), false))).toString().startsWith(sVNURL.toString())) {
            object2 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_RELOCATION, "Invalid source URL prefix: ''{0}'' (does not overlap target's URL ''{1}'')", sVNURL, object3);
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
        }
        object2 = ((SVNURL)object3).equals(sVNURL) ? sVNURL2 : SVNURL.parseURIEncoded(sVNURL2.toString() + ((SVNURL)object3).toString().substring(sVNURL.toString().length()));
        String string2 = SVNFileUtil.getFilePath(file2);
        String string3 = ((SVNURL)object2).getPath();
        if (!string3.endsWith(string2)) {
            object = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_RELOCATION, "Invalid relocation destination: ''{0}'' (does not point to target)", object2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        string3 = string3.substring(0, string3.length() - string2.length());
        object = ((SVNURL)object2).setPath(string3, false);
        if (svnWcDbRelocate$ISvnRelocateValidator != null) {
            svnWcDbRelocate$ISvnRelocateValidator.validateRelocation(string, (SVNURL)object2, (SVNURL)object);
        }
        SvnWcDbRelocate.relocate((SVNWCDb)sVNWCContext.getDb(), file, (SVNURL)object);
    }

    private static void relocate(SVNWCDb sVNWCDb, File file, SVNURL sVNURL) {
        Object object;
        SVNWCDb$DirParsedInfo sVNWCDb$DirParsedInfo = sVNWCDb.obtainWcRoot(file);
        Object object2 = sVNWCDb$DirParsedInfo.localRelPath;
        SVNWCDbRoot sVNWCDbRoot = sVNWCDb$DirParsedInfo.wcDbDir.getWCRoot();
        Structure structure = SvnWcDbShared.readInfo(sVNWCDbRoot, (File)object2, StructureFields$NodeInfo.status, StructureFields$NodeInfo.reposId, StructureFields$NodeInfo.haveBase);
        ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus = (ISVNWCDb$SVNWCDbStatus)((Object)structure.get(StructureFields$NodeInfo.status));
        long l2 = structure.lng(StructureFields$NodeInfo.reposId);
        boolean bl2 = structure.is(StructureFields$NodeInfo.haveBase);
        structure.release();
        if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Excluded) {
            object = SVNFileUtil.getFileDir((File)object2);
            structure = SvnWcDbShared.readInfo(sVNWCDbRoot, (File)object2, StructureFields$NodeInfo.status, StructureFields$NodeInfo.reposId);
            iSVNWCDb$SVNWCDbStatus = (ISVNWCDb$SVNWCDbStatus)((Object)structure.get(StructureFields$NodeInfo.status));
            l2 = structure.lng(StructureFields$NodeInfo.reposId);
            object2 = object;
            structure.release();
        }
        if (l2 == -1L) {
            if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Deleted) {
                object = SvnWcDbRelocate.scanDeletion(sVNWCDbRoot, (File)object2);
                if (((Structure)object).hasValue(StructureFields$DeletionInfo.workDelRelPath)) {
                    iSVNWCDb$SVNWCDbStatus = ISVNWCDb$SVNWCDbStatus.Added;
                    object2 = SVNFileUtil.getFileDir((File)((Structure)object).get(StructureFields$DeletionInfo.workDelRelPath));
                }
                ((Structure)object).release();
            }
            if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Added) {
                object = SvnWcDbRelocate.scanAddition(sVNWCDbRoot, (File)object2, StructureFields$AdditionInfo.reposId);
                l2 = ((Structure)object).lng(StructureFields$AdditionInfo.reposId);
                ((Structure)object).release();
            } else {
                object = SvnWcDbRelocate.getDepthInfo(sVNWCDbRoot, (File)object2, 0L, StructureFields$NodeInfo.reposId);
                l2 = ((Structure)object).lng(StructureFields$NodeInfo.reposId);
                ((Structure)object).release();
            }
        }
        object = sVNWCDb.fetchRepositoryInfo(sVNWCDbRoot.getSDb(), l2);
        String string = ((Structure)object).text(StructureFields$RepositoryInfo.reposUuid);
        ((Structure)object).release();
        SvnWcDbRelocate.begingWriteTransaction(sVNWCDbRoot);
        try {
            SvnWcDbRelocate.relocate(sVNWCDbRoot, (File)object2, sVNURL, string, bl2, l2);
        }
        catch (SVNException sVNException) {
            SvnWcDbRelocate.rollbackTransaction(sVNWCDbRoot);
            throw sVNException;
        }
        finally {
            SvnWcDbRelocate.commitTransaction(sVNWCDbRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void relocate(SVNWCDbRoot sVNWCDbRoot, File file, SVNURL sVNURL, String string, boolean bl2, long l2) {
        long l3 = sVNWCDbRoot.getDb().createReposId(sVNWCDbRoot.getSDb(), sVNURL, string);
        SVNSqlJetUpdateStatement sVNSqlJetUpdateStatement = new SvnWcDbRelocate$RecursiveUpdateNodeRepo(sVNWCDbRoot.getSDb());
        try {
            sVNSqlJetUpdateStatement.bindf("isii", sVNWCDbRoot.getWcId(), file, l2, l3);
            sVNSqlJetUpdateStatement.done();
        }
        finally {
            sVNSqlJetUpdateStatement.reset();
        }
        if (bl2) {
            sVNSqlJetUpdateStatement = new SvnWcDbRelocate$UpdateLockReposId(sVNWCDbRoot.getSDb());
            try {
                sVNSqlJetUpdateStatement.bindf("ii", l2, l3);
                sVNSqlJetUpdateStatement.done();
            }
            finally {
                sVNSqlJetUpdateStatement.reset();
            }
        }
    }
}

