/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb$Mode;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb$DirParsedInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbPristines$PristineTransfer;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbPristines$RemoveUnreferencedPristine;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema$NODES__Fields;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema$PRISTINE__Fields;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnChecksum$Kind;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnWcDbPristines
extends SvnWcDbShared {
    private static final String PRISTINE_STORAGE_EXT = ".svn-base";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupPristine(SVNWCDbRoot sVNWCDbRoot, File file) {
        SVNSqlJetStatement sVNSqlJetStatement = sVNWCDbRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_UNREFERENCED_PRISTINES);
        try {
            while (sVNSqlJetStatement.next()) {
                SvnChecksum svnChecksum = SvnChecksum.fromString(sVNSqlJetStatement.getColumnString(SVNWCDbSchema$PRISTINE__Fields.checksum));
                SvnWcDbPristines.removePristineIfUnreferenced(sVNWCDbRoot, file, svnChecksum);
            }
        }
        finally {
            sVNSqlJetStatement.reset();
        }
    }

    private static void removePristineIfUnreferenced(SVNWCDbRoot sVNWCDbRoot, File file, SvnChecksum svnChecksum) {
        SvnWcDbPristines$RemoveUnreferencedPristine svnWcDbPristines$RemoveUnreferencedPristine = new SvnWcDbPristines$RemoveUnreferencedPristine();
        svnWcDbPristines$RemoveUnreferencedPristine.sha1_checksum = svnChecksum;
        svnWcDbPristines$RemoveUnreferencedPristine.pristineAbsPath = SvnWcDbPristines.getPristineFileName(sVNWCDbRoot, svnChecksum, false);
        svnWcDbPristines$RemoveUnreferencedPristine.root = sVNWCDbRoot;
        sVNWCDbRoot.getSDb().runTransaction(svnWcDbPristines$RemoveUnreferencedPristine);
    }

    public static File getPristineTempDir(SVNWCDbRoot sVNWCDbRoot, File file) {
        return SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(sVNWCDbRoot.getAbsPath(), SVNFileUtil.getAdminDirectoryName()), "");
    }

    public static File getPristineFuturePath(SVNWCDbRoot sVNWCDbRoot, SvnChecksum svnChecksum) {
        return SvnWcDbPristines.getPristineFileName(sVNWCDbRoot, svnChecksum, false);
    }

    public static File getPristineFileName(SVNWCDbRoot sVNWCDbRoot, SvnChecksum svnChecksum, boolean bl2) {
        assert (sVNWCDbRoot != null);
        assert (svnChecksum != null);
        assert (svnChecksum.getKind() == SvnChecksum$Kind.sha1);
        File file = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(sVNWCDbRoot.getAbsPath(), SVNFileUtil.getAdminDirectoryName()), "pristine");
        String string = svnChecksum.getDigest();
        assert (string != null);
        String string2 = string.substring(0, 2);
        if (bl2) {
            File file2 = SVNFileUtil.createFilePath(file, string2);
            file2.mkdirs();
        }
        return SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(file, string2), string + PRISTINE_STORAGE_EXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPristine(SVNWCDbRoot sVNWCDbRoot, SvnChecksum svnChecksum) {
        File file;
        SVNNodeKind sVNNodeKind;
        boolean bl2 = false;
        SVNSqlJetStatement sVNSqlJetStatement = sVNWCDbRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_PRISTINE_MD5_CHECKSUM);
        sVNSqlJetStatement.bindf("s", svnChecksum);
        try {
            bl2 = sVNSqlJetStatement.next();
        }
        finally {
            sVNSqlJetStatement.reset();
        }
        if (bl2 && (sVNNodeKind = SVNFileType.getNodeKind(SVNFileType.getType(file = SvnWcDbPristines.getPristineFileName(sVNWCDbRoot, svnChecksum, false)))) != SVNNodeKind.FILE) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_DB_ERROR, "The pristine text with checksum ''{0}'' was found in the DB but not on disk", (Object)svnChecksum);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SvnChecksum getPristineSHA1(SVNWCDbRoot sVNWCDbRoot, SvnChecksum svnChecksum) {
        SVNSqlJetStatement sVNSqlJetStatement = sVNWCDbRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_PRISTINE_SHA1_CHECKSUM);
        try {
            sVNSqlJetStatement.bindChecksum(1, svnChecksum);
            boolean bl2 = sVNSqlJetStatement.next();
            if (!bl2) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_DB_ERROR, "The pristine text with MD5 checksum ''{0}'' not found", (Object)svnChecksum.toString());
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                SvnChecksum svnChecksum2 = null;
                return svnChecksum2;
            }
            SvnChecksum svnChecksum3 = SvnWcDbStatementUtil.getColumnChecksum(sVNSqlJetStatement, SVNWCDbSchema$PRISTINE__Fields.checksum);
            assert (svnChecksum3.getKind() == SvnChecksum$Kind.sha1);
            SvnChecksum svnChecksum4 = svnChecksum3;
            return svnChecksum4;
        }
        finally {
            sVNSqlJetStatement.reset();
        }
    }

    public static File getPristinePath(SVNWCDbRoot sVNWCDbRoot, SvnChecksum svnChecksum) {
        boolean bl2 = SvnWcDbPristines.checkPristine(sVNWCDbRoot, svnChecksum);
        if (!bl2) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_DB_ERROR, "Pristine text not found");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        return SvnWcDbPristines.getPristineFileName(sVNWCDbRoot, svnChecksum, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePristine(SVNWCDbRoot sVNWCDbRoot, SvnChecksum svnChecksum) {
        boolean bl2;
        SVNSqlJetStatement sVNSqlJetStatement = sVNWCDbRoot.getSDb().getStatement(SVNWCDbStatements.LOOK_FOR_WORK);
        try {
            bl2 = sVNSqlJetStatement.next();
        }
        finally {
            sVNSqlJetStatement.reset();
        }
        if (bl2) {
            return;
        }
        SvnWcDbPristines.pristineRemove(sVNWCDbRoot, svnChecksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pristineRemove(SVNWCDbRoot sVNWCDbRoot, SvnChecksum svnChecksum) {
        SVNSqlJetStatement sVNSqlJetStatement = sVNWCDbRoot.getSDb().getStatement(SVNWCDbStatements.DELETE_PRISTINE);
        try {
            sVNSqlJetStatement.bindChecksum(1, svnChecksum);
            if (sVNSqlJetStatement.done() != 0L) {
                File file = SvnWcDbPristines.getPristineFileName(sVNWCDbRoot, svnChecksum, true);
                SVNFileUtil.deleteFile(file);
            }
        }
        finally {
            sVNSqlJetStatement.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installPristine(SVNWCDbRoot sVNWCDbRoot, File file, SvnChecksum svnChecksum, SvnChecksum svnChecksum2) {
        File file2 = SvnWcDbPristines.getPristineFileName(sVNWCDbRoot, svnChecksum, true);
        if (file2.isFile()) {
            SVNFileUtil.deleteFile(file);
            return;
        }
        SVNFileUtil.rename(file, file2);
        long l2 = file2.length();
        SVNSqlJetStatement sVNSqlJetStatement = sVNWCDbRoot.getSDb().getStatement(SVNWCDbStatements.INSERT_PRISTINE);
        try {
            sVNSqlJetStatement.bindChecksum(1, svnChecksum);
            sVNSqlJetStatement.bindChecksum(2, svnChecksum2);
            sVNSqlJetStatement.bindLong(3, l2);
            sVNSqlJetStatement.done();
        }
        finally {
            sVNSqlJetStatement.reset();
        }
    }

    public static InputStream readPristine(SVNWCDbRoot sVNWCDbRoot, File file, SvnChecksum svnChecksum) {
        File file2 = SvnWcDbPristines.getPristineFileName(sVNWCDbRoot, svnChecksum, false);
        return SVNFileUtil.openFileForReading(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fixPristinesRefCount(SVNWCDbRoot sVNWCDbRoot) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        SvnWcDbPristines.begingWriteTransaction(sVNWCDbRoot);
        try {
            String string;
            ISqlJetTable iSqlJetTable = sVNWCDbRoot.getSDb().getDb().getTable(SVNWCDbSchema.NODES.toString());
            try (ISqlJetCursor iSqlJetCursor = iSqlJetTable.open();){
                while (!iSqlJetCursor.eof()) {
                    long l2 = iSqlJetCursor.getInteger(SVNWCDbSchema$NODES__Fields.op_depth.toString());
                    if (l2 == 0L) {
                        string = iSqlJetCursor.getString(SVNWCDbSchema$NODES__Fields.checksum.toString());
                        if (hashMap.containsKey(string)) {
                            hashMap.put(string, (Long)hashMap.get(string) + 1L);
                        } else {
                            hashMap.put(string, 1L);
                        }
                    }
                    iSqlJetCursor.next();
                }
            }
            ISqlJetTable iSqlJetTable2 = sVNWCDbRoot.getSDb().getDb().getTable(SVNWCDbSchema.PRISTINE.toString());
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                iSqlJetCursor = iSqlJetTable2.lookup(null, string);
                try {
                    if (iSqlJetCursor.eof()) continue;
                    long l3 = iSqlJetCursor.getInteger(SVNWCDbSchema$PRISTINE__Fields.refcount.toString());
                    if (l3 != (Long)hashMap.get(string)) {
                        HashMap hashMap2 = new HashMap();
                        iSqlJetCursor.updateByFieldNames(hashMap2);
                    }
                    iterator.remove();
                }
                finally {
                    iSqlJetCursor.close();
                }
            }
        }
        catch (SqlJetException sqlJetException) {
            SvnWcDbPristines.rollbackTransaction(sVNWCDbRoot);
            SVNSqlJetDb.createSqlJetError(sqlJetException);
        }
        finally {
            SvnWcDbPristines.commitTransaction(sVNWCDbRoot);
        }
    }

    public static void checkPristineChecksumRefcounts(SVNWCDbRoot sVNWCDbRoot) {
        Serializable serializable;
        SvnChecksum svnChecksum;
        Map map = SvnWcDbPristines.calculateCorrectChecksumRefcounts(sVNWCDbRoot);
        Map map2 = SvnWcDbPristines.loadChecksumsRefcountsFromTable(sVNWCDbRoot);
        for (Map.Entry entry : map2.entrySet()) {
            int n2;
            svnChecksum = (SvnChecksum)entry.getKey();
            serializable = (Integer)entry.getValue();
            Integer n3 = (Integer)map.get(svnChecksum);
            int n4 = n3 == null ? 0 : n3;
            if (n4 == (n2 = serializable == null ? 0 : serializable)) continue;
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Working copy ''{0}'' is corrupted: {1} table contains incorrect ''refcount'' value {2} for checksum {3} (instead of {4})", sVNWCDbRoot.getAbsPath().getAbsolutePath().replace('/', File.separatorChar), SVNWCDbSchema.PRISTINE.name(), n2, svnChecksum, n4);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        for (Map.Entry entry : map.entrySet()) {
            svnChecksum = (SvnChecksum)entry.getKey();
            if (map2.containsKey(svnChecksum)) continue;
            serializable = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Working copy ''{0}'' is corrupted: checksum {1} that is present in {2} table is not listed in {3} table", sVNWCDbRoot.getAbsPath().getAbsolutePath().replace('/', File.separatorChar), svnChecksum, SVNWCDbSchema.NODES.name(), SVNWCDbSchema.PRISTINE.name());
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map calculateCorrectChecksumRefcounts(SVNWCDbRoot sVNWCDbRoot) {
        HashMap<SvnChecksum, Integer> hashMap = new HashMap<SvnChecksum, Integer>();
        SqlJetDb sqlJetDb = sVNWCDbRoot.getSDb().getDb();
        try {
            ISqlJetTable iSqlJetTable = sqlJetDb.getTable(SVNWCDbSchema.NODES.name());
            sqlJetDb.beginTransaction(SqlJetTransactionMode.READ_ONLY);
            ISqlJetCursor iSqlJetCursor = iSqlJetTable.open();
            while (!iSqlJetCursor.eof()) {
                String string = iSqlJetCursor.getString(SVNWCDbSchema$NODES__Fields.checksum.name());
                if (string != null) {
                    SvnChecksum svnChecksum = SvnChecksum.fromString(string);
                    Integer n2 = (Integer)hashMap.get(svnChecksum);
                    int n3 = n2 == null ? 1 : n2 + 1;
                    hashMap.put(svnChecksum, n3);
                }
                iSqlJetCursor.next();
            }
            iSqlJetCursor.close();
        }
        catch (SqlJetException sqlJetException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_DB_ERROR, sqlJetException);
            SVNErrorManager.error(sVNErrorMessage, sqlJetException, SVNLogType.WC);
        }
        finally {
            try {
                sqlJetDb.commit();
            }
            catch (SqlJetException sqlJetException) {}
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map loadChecksumsRefcountsFromTable(SVNWCDbRoot sVNWCDbRoot) {
        HashMap<SvnChecksum, Integer> hashMap = new HashMap<SvnChecksum, Integer>();
        SqlJetDb sqlJetDb = sVNWCDbRoot.getSDb().getDb();
        try {
            ISqlJetTable iSqlJetTable = sqlJetDb.getTable(SVNWCDbSchema.PRISTINE.name());
            sqlJetDb.beginTransaction(SqlJetTransactionMode.READ_ONLY);
            ISqlJetCursor iSqlJetCursor = iSqlJetTable.open();
            while (!iSqlJetCursor.eof()) {
                String string = iSqlJetCursor.getString(SVNWCDbSchema$PRISTINE__Fields.checksum.name());
                if (string != null) {
                    SvnChecksum svnChecksum = SvnChecksum.fromString(string);
                    long l2 = iSqlJetCursor.getInteger(SVNWCDbSchema$PRISTINE__Fields.refcount.name());
                    hashMap.put(svnChecksum, (int)l2);
                }
                iSqlJetCursor.next();
            }
            iSqlJetCursor.close();
        }
        catch (SqlJetException sqlJetException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_DB_ERROR, sqlJetException);
            SVNErrorManager.error(sVNErrorMessage, sqlJetException, SVNLogType.WC);
        }
        finally {
            try {
                sqlJetDb.commit();
            }
            catch (SqlJetException sqlJetException) {}
        }
        return hashMap;
    }

    public static void transferPristine(SVNWCDb sVNWCDb, File file, File file2) {
        SVNWCDb$DirParsedInfo sVNWCDb$DirParsedInfo = sVNWCDb.parseDir(file, SVNSqlJetDb$Mode.ReadOnly);
        SVNWCDb.verifyDirUsable(sVNWCDb$DirParsedInfo.wcDbDir);
        SVNWCDb$DirParsedInfo sVNWCDb$DirParsedInfo2 = sVNWCDb.parseDir(file2, SVNSqlJetDb$Mode.ReadOnly);
        SVNWCDb.verifyDirUsable(sVNWCDb$DirParsedInfo2.wcDbDir);
        if (sVNWCDb$DirParsedInfo.wcDbDir.getWCRoot() == sVNWCDb$DirParsedInfo2.wcDbDir.getWCRoot() && sVNWCDb$DirParsedInfo.wcDbDir.getWCRoot().getSDb() == sVNWCDb$DirParsedInfo2.wcDbDir.getWCRoot().getSDb()) {
            return;
        }
        SvnWcDbPristines$PristineTransfer svnWcDbPristines$PristineTransfer = new SvnWcDbPristines$PristineTransfer(null);
        svnWcDbPristines$PristineTransfer.srcWcRoot = sVNWCDb$DirParsedInfo.wcDbDir.getWCRoot();
        svnWcDbPristines$PristineTransfer.dstWcRoot = sVNWCDb$DirParsedInfo2.wcDbDir.getWCRoot();
        svnWcDbPristines$PristineTransfer.srcRelPath = sVNWCDb$DirParsedInfo.localRelPath;
        sVNWCDb$DirParsedInfo.wcDbDir.getWCRoot().getSDb().runTransaction(svnWcDbPristines$PristineTransfer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void maybeTransferOnePristine(SVNWCDbRoot sVNWCDbRoot, SVNWCDbRoot sVNWCDbRoot2, SvnChecksum svnChecksum, SvnChecksum svnChecksum2, long l2) {
        SVNSqlJetStatement sVNSqlJetStatement = sVNWCDbRoot2.getSDb().getStatement(SVNWCDbStatements.INSERT_OR_IGNORE_PRISTINE);
        try {
            sVNSqlJetStatement.bindChecksum(1, svnChecksum);
            sVNSqlJetStatement.bindChecksum(2, svnChecksum2);
            sVNSqlJetStatement.bindLong(3, l2);
            long l3 = sVNSqlJetStatement.done();
            if (l3 == 0L) {
                return;
            }
        }
        finally {
            sVNSqlJetStatement.reset();
        }
        File file = SvnWcDbPristines.getPristineFileName(sVNWCDbRoot, svnChecksum, false);
        File file2 = SvnWcDbPristines.getPristineFileName(sVNWCDbRoot2, svnChecksum, true);
        SVNFileUtil.copy(file, file2, true, false);
    }

    static /* synthetic */ void access$200(SVNWCDbRoot sVNWCDbRoot, SVNWCDbRoot sVNWCDbRoot2, SvnChecksum svnChecksum, SvnChecksum svnChecksum2, long l2) {
        SvnWcDbPristines.maybeTransferOnePristine(sVNWCDbRoot, sVNWCDbRoot2, svnChecksum, svnChecksum2, l2);
    }
}

