/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCConflictDescription17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb$DirParsedInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts$ConflictInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts$ConflictKind;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts$ConflictStatus;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts$PropertyConflictInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts$TextConflictInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts$TreeConflictInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema$ACTUAL_NODE__Fields;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnWcDbConflicts
extends SvnWcDbShared {
    private static final String CONFLICT_OP_UPDATE = "update";
    private static final String CONFLICT_OP_SWITCH = "switch";
    private static final String CONFLICT_OP_MERGE = "merge";

    public static SVNSkel convertToConflictSkel(String string, String string2, String string3, String string4, byte[] byArray) {
        SVNSkel sVNSkel = null;
        if (string != null || string3 != null || string2 != null) {
            sVNSkel = SvnWcDbConflicts.createConflictSkel();
            SvnWcDbConflicts.addTextConflict(sVNSkel, string2, string, string3);
        }
        if (string4 != null) {
            if (sVNSkel == null) {
                sVNSkel = SvnWcDbConflicts.createConflictSkel();
            }
            SvnWcDbConflicts.addPropConflict(sVNSkel, string4);
        }
        if (byArray != null) {
            if (sVNSkel == null) {
                sVNSkel = SvnWcDbConflicts.createConflictSkel();
            }
            SVNSkel sVNSkel2 = SVNSkel.parse(byArray);
            File file = SVNFileUtil.createFilePath("");
            SVNTreeConflictDescription sVNTreeConflictDescription = SVNTreeConflictUtil.readSingleTreeConflict(sVNSkel2, file);
            SvnWcDbConflicts.addTreeConflict(sVNSkel, sVNTreeConflictDescription.getConflictReason(), sVNTreeConflictDescription.getConflictAction());
            if (sVNTreeConflictDescription.getOperation() != null && sVNTreeConflictDescription.getOperation() != SVNOperation.NONE) {
                SvnWcDbConflicts.setConflictOperation(sVNSkel, sVNTreeConflictDescription.getOperation(), sVNTreeConflictDescription.getSourceLeftVersion(), sVNTreeConflictDescription.getSourceRightVersion());
            }
        } else if (sVNSkel != null) {
            SvnWcDbConflicts.setConflictOperation(sVNSkel, SVNOperation.UPDATE, null, null);
        }
        return sVNSkel;
    }

    public static SVNSkel convertToConflictSkel(File file, SVNWCDb sVNWCDb, String string, String string2, String string3, String string4, String string5, byte[] byArray) {
        Object object;
        File file2;
        Object object2;
        SVNSkel sVNSkel = null;
        if (string2 != null || string4 != null || string3 != null) {
            sVNSkel = SvnWcDbConflicts.createConflictSkel();
            object2 = null;
            file2 = null;
            object = null;
            if (string2 != null) {
                object2 = SVNFileUtil.createFilePath(file, string2);
            }
            if (string4 != null) {
                file2 = SVNFileUtil.createFilePath(file, string4);
            }
            if (string3 != null) {
                object = SVNFileUtil.createFilePath(file, string3);
            }
            SvnWcDbConflicts.addTextConflict(sVNSkel, sVNWCDb, file, (File)object, (File)object2, file2);
        }
        if (string5 != null) {
            if (sVNSkel == null) {
                sVNSkel = SvnWcDbConflicts.createConflictSkel();
            }
            object2 = SVNFileUtil.createFilePath(file, string5);
            SvnWcDbConflicts.addPropConflict(sVNSkel, sVNWCDb, file, (File)object2, null, null, null, Collections.emptySet());
        }
        if (byArray != null) {
            if (sVNSkel == null) {
                sVNSkel = SvnWcDbConflicts.createConflictSkel();
            }
            object2 = SVNSkel.parse(byArray);
            file2 = SVNFileUtil.createFilePath(file, string);
            object = SVNTreeConflictUtil.readSingleTreeConflict((SVNSkel)object2, file2);
            SvnWcDbConflicts.addTreeConflict(sVNSkel, sVNWCDb, file, ((SVNConflictDescription)object).getConflictReason(), ((SVNConflictDescription)object).getConflictAction(), null);
            if (((SVNTreeConflictDescription)object).getOperation() != null && ((SVNTreeConflictDescription)object).getOperation() != SVNOperation.NONE) {
                SvnWcDbConflicts.setConflictOperation(sVNSkel, ((SVNTreeConflictDescription)object).getOperation(), ((SVNTreeConflictDescription)object).getSourceLeftVersion(), ((SVNTreeConflictDescription)object).getSourceRightVersion());
            }
        } else if (sVNSkel != null) {
            SvnWcDbConflicts.setConflictOperation(sVNSkel, SVNOperation.UPDATE, null, null);
        }
        return sVNSkel;
    }

    public static List convertFromSkel(SVNWCDb sVNWCDb, File file, boolean bl2, SVNSkel sVNSkel) {
        Object object;
        Structure structure;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (sVNSkel == null) {
            return arrayList;
        }
        Structure structure2 = SvnWcDbConflicts.readConflictInfo(sVNSkel);
        List list = (List)structure2.get(SvnWcDbConflicts$ConflictInfo.locations);
        SVNConflictVersion sVNConflictVersion = null;
        SVNConflictVersion sVNConflictVersion2 = null;
        if (list != null && list.size() > 0) {
            sVNConflictVersion = (SVNConflictVersion)list.get(0);
        }
        if (list != null && list.size() > 1) {
            sVNConflictVersion2 = (SVNConflictVersion)list.get(1);
        }
        if (structure2.is(SvnWcDbConflicts$ConflictInfo.propConflicted)) {
            SvnWcDbConflicts.readPropertyConflicts(arrayList, sVNWCDb, file, sVNSkel, bl2, (SVNOperation)structure2.get(SvnWcDbConflicts$ConflictInfo.conflictOperation), sVNConflictVersion, sVNConflictVersion2);
        }
        if (structure2.is(SvnWcDbConflicts$ConflictInfo.textConflicted)) {
            structure = SvnWcDbConflicts.readTextConflict(sVNWCDb, file, sVNSkel);
            object = SVNWCConflictDescription17.createText(file);
            ((SVNWCConflictDescription17)object).setOperation((SVNOperation)structure2.get(SvnWcDbConflicts$ConflictInfo.conflictOperation));
            ((SVNWCConflictDescription17)object).setSrcLeftVersion(sVNConflictVersion);
            ((SVNWCConflictDescription17)object).setSrcRightVersion(sVNConflictVersion2);
            ((SVNWCConflictDescription17)object).setTheirFile((File)structure.get(SvnWcDbConflicts$TextConflictInfo.theirAbsPath));
            ((SVNWCConflictDescription17)object).setBaseFile((File)structure.get(SvnWcDbConflicts$TextConflictInfo.theirOldAbsPath));
            ((SVNWCConflictDescription17)object).setMyFile((File)structure.get(SvnWcDbConflicts$TextConflictInfo.mineAbsPath));
            ((SVNWCConflictDescription17)object).setMergedFile(file);
            arrayList.add(object);
        }
        if (structure2.is(SvnWcDbConflicts$ConflictInfo.treeConflicted)) {
            structure = SvnWcDbConflicts.readTreeConflict(sVNWCDb, file, sVNSkel);
            object = sVNConflictVersion != null ? sVNConflictVersion.getKind() : (sVNConflictVersion2 != null ? sVNConflictVersion2.getKind() : SVNNodeKind.FILE);
            SVNWCConflictDescription17 sVNWCConflictDescription17 = SVNWCConflictDescription17.createTree(file, (SVNNodeKind)object, (SVNOperation)structure2.get(SvnWcDbConflicts$ConflictInfo.conflictOperation), sVNConflictVersion, sVNConflictVersion2);
            sVNWCConflictDescription17.setReason((SVNConflictReason)structure.get(SvnWcDbConflicts$TreeConflictInfo.localChange));
            sVNWCConflictDescription17.setAction((SVNConflictAction)structure.get(SvnWcDbConflicts$TreeConflictInfo.incomingChange));
            arrayList.add(sVNWCConflictDescription17);
        }
        return arrayList;
    }

    public static SVNSkel createConflictSkel() {
        SVNSkel sVNSkel = SVNSkel.createEmptyList();
        sVNSkel.prepend(SVNSkel.createEmptyList());
        sVNSkel.prepend(SVNSkel.createEmptyList());
        return sVNSkel;
    }

    public static boolean isConflictSkelComplete(SVNSkel sVNSkel) {
        if (sVNSkel == null || sVNSkel.getListSize() < 2) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.INCOMPLETE_DATA, "Not a conflict skel");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (sVNSkel.first().getListSize() < 2) {
            return false;
        }
        return sVNSkel.first().next().getListSize() != 0;
    }

    public static void prependLocation(SVNSkel sVNSkel, SVNConflictVersion sVNConflictVersion) {
        SVNSkel sVNSkel2 = SVNSkel.createEmptyList();
        if (sVNConflictVersion == null) {
            sVNSkel.prepend(sVNSkel2);
            return;
        }
        sVNSkel2.prepend(SVNSkel.createAtom(sVNConflictVersion.getKind().toString()));
        sVNSkel2.prepend(SVNSkel.createAtom(Long.toString(sVNConflictVersion.getPegRevision())));
        sVNSkel2.prepend(SVNSkel.createAtom(sVNConflictVersion.getPath()));
        sVNSkel2.prepend(SVNSkel.createEmptyList());
        sVNSkel2.prepend(SVNSkel.createAtom(sVNConflictVersion.getRepositoryRoot().toString()));
        sVNSkel2.prepend(SVNSkel.createAtom("subversion"));
        sVNSkel.prepend(sVNSkel2);
    }

    public static void setConflictOperation(SVNSkel sVNSkel, SVNOperation sVNOperation, SVNConflictVersion sVNConflictVersion, SVNConflictVersion sVNConflictVersion2) {
        SVNSkel sVNSkel2 = sVNSkel.first();
        SVNSkel sVNSkel3 = SVNSkel.createEmptyList();
        SvnWcDbConflicts.prependLocation(sVNSkel3, sVNConflictVersion2);
        SvnWcDbConflicts.prependLocation(sVNSkel3, sVNConflictVersion);
        sVNSkel2.prepend(sVNSkel3);
        sVNSkel2.prepend(SVNSkel.createAtom(sVNOperation.getName()));
    }

    public static void addTextConflict(SVNSkel sVNSkel, ISVNWCDb iSVNWCDb, File file, File file2, File file3, File file4) {
        File file5;
        SVNSkel sVNSkel2 = SVNSkel.createEmptyList();
        SVNSkel sVNSkel3 = SVNSkel.createEmptyList();
        if (file4 != null) {
            file5 = iSVNWCDb.toRelPath(file4);
            sVNSkel3.prepend(SVNSkel.createAtom(SVNFileUtil.getFilePath(file5)));
        } else {
            sVNSkel3.prepend(SVNSkel.createEmptyList());
        }
        if (file2 != null) {
            file5 = iSVNWCDb.toRelPath(file2);
            sVNSkel3.prepend(SVNSkel.createAtom(SVNFileUtil.getFilePath(file5)));
        } else {
            sVNSkel3.prepend(SVNSkel.createEmptyList());
        }
        if (file3 != null) {
            file5 = iSVNWCDb.toRelPath(file3);
            sVNSkel3.prepend(SVNSkel.createAtom(SVNFileUtil.getFilePath(file5)));
        } else {
            sVNSkel3.prepend(SVNSkel.createEmptyList());
        }
        sVNSkel2.prepend(sVNSkel3);
        sVNSkel2.prepend(SVNSkel.createAtom(SvnWcDbConflicts$ConflictKind.text.toString()));
        sVNSkel.first().next().prepend(sVNSkel2);
    }

    public static void addPropConflict(SVNSkel sVNSkel, ISVNWCDb iSVNWCDb, File file, File file2, SVNProperties sVNProperties, SVNProperties sVNProperties2, SVNProperties sVNProperties3, Collection collection) {
        SVNSkel sVNSkel2 = SVNSkel.createEmptyList();
        if (sVNProperties3 != null) {
            sVNSkel2.prepend(SVNSkel.createPropList(sVNProperties3.asMap()));
        } else {
            sVNSkel2.prepend(SVNSkel.createAtom(""));
        }
        if (sVNProperties != null) {
            sVNSkel2.prepend(SVNSkel.createPropList(sVNProperties.asMap()));
        } else {
            sVNSkel2.prepend(SVNSkel.createAtom(""));
        }
        if (sVNProperties2 != null) {
            sVNSkel2.prepend(SVNSkel.createPropList(sVNProperties2.asMap()));
        } else {
            sVNSkel2.prepend(SVNSkel.createAtom(""));
        }
        SVNSkel sVNSkel3 = SVNSkel.createEmptyList();
        for (Object object : collection) {
            sVNSkel3.prepend(SVNSkel.createAtom((String)object));
        }
        sVNSkel2.prepend(sVNSkel3);
        SVNSkel sVNSkel4 = SVNSkel.createEmptyList();
        if (file2 != null) {
            Object object;
            object = iSVNWCDb.toRelPath(file2);
            sVNSkel4.prepend(SVNSkel.createAtom(SVNFileUtil.getFilePath((File)object)));
        }
        sVNSkel2.prepend(sVNSkel4);
        sVNSkel2.prepend(SVNSkel.createAtom(SvnWcDbConflicts$ConflictKind.prop.toString()));
        sVNSkel.first().next().prepend(sVNSkel2);
    }

    public static void addTreeConflict(SVNSkel sVNSkel, ISVNWCDb iSVNWCDb, File file, SVNConflictReason sVNConflictReason, SVNConflictAction sVNConflictAction, File file2) {
        Object object;
        SVNSkel sVNSkel2 = SVNSkel.createEmptyList();
        if (sVNConflictReason == SVNConflictReason.MOVED_AWAY && file2 != null) {
            object = iSVNWCDb.toRelPath(file2);
            sVNSkel2.prepend(SVNSkel.createAtom(SVNFileUtil.getFilePath((File)object)));
        }
        sVNSkel2.prepend(SVNSkel.createAtom(sVNConflictAction.getName()));
        sVNSkel2.prepend(SVNSkel.createAtom(sVNConflictReason.getName()));
        object = SVNSkel.createEmptyList();
        sVNSkel2.prepend((SVNSkel)object);
        sVNSkel2.prepend(SVNSkel.createAtom(SvnWcDbConflicts$ConflictKind.tree.toString()));
        sVNSkel.first().next().prepend(sVNSkel2);
    }

    public static SVNSkel readConflict(SVNWCDb sVNWCDb, File file) {
        SVNWCDb$DirParsedInfo sVNWCDb$DirParsedInfo = sVNWCDb.obtainWcRoot(file);
        SVNSqlJetDb sVNSqlJetDb = sVNWCDb$DirParsedInfo.wcDbDir.getWCRoot().getSDb();
        long l2 = sVNWCDb$DirParsedInfo.wcDbDir.getWCRoot().getWcId();
        File file2 = sVNWCDb$DirParsedInfo.localRelPath;
        return SvnWcDbConflicts.readConflictInternal(sVNWCDb$DirParsedInfo.wcDbDir.getWCRoot(), file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNSkel readConflictInternal(SVNWCDbRoot sVNWCDbRoot, File file) {
        long l2 = sVNWCDbRoot.getWcId();
        SVNSqlJetDb sVNSqlJetDb = sVNWCDbRoot.getSDb();
        String string = file.getPath().replace(File.separatorChar, '/');
        SVNSqlJetStatement sVNSqlJetStatement = sVNSqlJetDb.getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
        try {
            Object object;
            Object object2;
            sVNSqlJetStatement.bindf("is", l2, string);
            if (!sVNSqlJetStatement.next()) {
                object2 = sVNSqlJetDb.getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
                try {
                    ((SVNSqlJetStatement)object2).bindf("is", l2, string);
                    if (((SVNSqlJetStatement)object2).next()) {
                        SVNSkel sVNSkel = null;
                        return sVNSkel;
                    }
                }
                finally {
                    SvnWcDbStatementUtil.reset((SVNSqlJetStatement)object2);
                }
                object = SVNFileUtil.createFilePath(sVNWCDbRoot.getAbsPath(), file);
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", object);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            if ((object2 = (Object)sVNSqlJetStatement.getColumnBlob(SVNWCDbSchema$ACTUAL_NODE__Fields.conflict_data)) != null) {
                object = SVNSkel.parse((byte[])object2);
                return object;
            }
        }
        finally {
            SvnWcDbStatementUtil.reset(sVNSqlJetStatement);
        }
        return null;
    }

    public static Structure readConflictInfo(SVNSkel sVNSkel) {
        Serializable serializable;
        Structure structure = Structure.obtain(SvnWcDbConflicts$ConflictInfo.class);
        SVNSkel sVNSkel2 = SvnWcDbConflicts.readConflictOperation(sVNSkel);
        if (sVNSkel2 == null) {
            serializable = SVNErrorMessage.create(SVNErrorCode.INCOMPLETE_DATA, "Not a completed conflict skel");
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        SVNSkel sVNSkel3 = sVNSkel2.first();
        structure.set((Enum)SvnWcDbConflicts$ConflictInfo.conflictOperation, SVNOperation.fromString(sVNSkel3.getValue()));
        sVNSkel3 = sVNSkel3.next();
        serializable = new ArrayList();
        structure.set((Enum)SvnWcDbConflicts$ConflictInfo.locations, serializable);
        for (int i2 = 0; i2 < sVNSkel3.getListSize(); ++i2) {
            SVNConflictVersion sVNConflictVersion = SvnWcDbConflicts.readConflictLocation(sVNSkel3.getChild(i2));
            serializable.add(sVNConflictVersion);
        }
        structure.set((Enum)SvnWcDbConflicts$ConflictInfo.textConflicted, SvnWcDbConflicts.hasConflictKind(sVNSkel, SvnWcDbConflicts$ConflictKind.text));
        structure.set((Enum)SvnWcDbConflicts$ConflictInfo.propConflicted, SvnWcDbConflicts.hasConflictKind(sVNSkel, SvnWcDbConflicts$ConflictKind.prop));
        structure.set((Enum)SvnWcDbConflicts$ConflictInfo.treeConflicted, SvnWcDbConflicts.hasConflictKind(sVNSkel, SvnWcDbConflicts$ConflictKind.tree));
        return structure;
    }

    public static void readPropertyConflicts(List list, SVNWCDb sVNWCDb, File file, SVNSkel sVNSkel, boolean bl2, SVNOperation sVNOperation, SVNConflictVersion sVNConflictVersion, SVNConflictVersion sVNConflictVersion2) {
        Structure structure = SvnWcDbConflicts.readPropertyConflict(sVNWCDb, file, sVNSkel);
        Set set = (Set)structure.get(SvnWcDbConflicts$PropertyConflictInfo.conflictedPropNames);
        if (!bl2 || set.isEmpty()) {
            SVNWCConflictDescription17 sVNWCConflictDescription17 = SVNWCConflictDescription17.createProp(file, SVNNodeKind.UNKNOWN, "");
            sVNWCConflictDescription17.setTheirFile((File)structure.get(SvnWcDbConflicts$PropertyConflictInfo.markerAbspath));
            sVNWCConflictDescription17.setOperation(sVNOperation);
            sVNWCConflictDescription17.setSrcLeftVersion(sVNConflictVersion);
            sVNWCConflictDescription17.setSrcRightVersion(sVNConflictVersion2);
            list.add(sVNWCConflictDescription17);
            return;
        }
        File file2 = sVNWCDb.getWCRootTempDir(file);
        for (String string : set) {
            File file3;
            SVNWCConflictDescription17 sVNWCConflictDescription17 = SVNWCConflictDescription17.createProp(file, SVNNodeKind.UNKNOWN, string);
            sVNWCConflictDescription17.setOperation(sVNOperation);
            sVNWCConflictDescription17.setSrcLeftVersion(sVNConflictVersion);
            sVNWCConflictDescription17.setSrcRightVersion(sVNConflictVersion2);
            sVNWCConflictDescription17.setPropertyName(string);
            Map map = (Map)structure.get(SvnWcDbConflicts$PropertyConflictInfo.mineProps);
            Map map2 = (Map)structure.get(SvnWcDbConflicts$PropertyConflictInfo.theirProps);
            Map map3 = (Map)structure.get(SvnWcDbConflicts$PropertyConflictInfo.theirOldProps);
            byte[] byArray = (byte[])map.get(string);
            byte[] byArray2 = (byte[])map2.get(string);
            byte[] byArray3 = (byte[])map3.get(string);
            if (byArray2 == null) {
                sVNWCConflictDescription17.setAction(SVNConflictAction.DELETE);
            } else if (byArray == null) {
                sVNWCConflictDescription17.setAction(SVNConflictAction.ADD);
            } else {
                sVNWCConflictDescription17.setAction(SVNConflictAction.EDIT);
            }
            if (byArray == null) {
                sVNWCConflictDescription17.setReason(SVNConflictReason.DELETED);
            } else if (byArray2 == null) {
                sVNWCConflictDescription17.setReason(SVNConflictReason.ADDED);
            } else {
                sVNWCConflictDescription17.setReason(SVNConflictReason.EDITED);
            }
            sVNWCConflictDescription17.setTheirFile((File)structure.get(SvnWcDbConflicts$PropertyConflictInfo.markerAbspath));
            if (byArray != null) {
                file3 = SVNFileUtil.createUniqueFile(file2, "svn.", ".prop.tmp", false);
                sVNWCConflictDescription17.setMyFile(file3);
                SVNFileUtil.writeToFile(file3, byArray);
            }
            if (byArray2 != null) {
                file3 = SVNFileUtil.createUniqueFile(file2, "svn.", ".prop.tmp", false);
                sVNWCConflictDescription17.setMergedFile(file3);
                SVNFileUtil.writeToFile(file3, byArray2);
            }
            if (byArray3 != null) {
                file3 = SVNFileUtil.createUniqueFile(file2, "svn.", ".prop.tmp", false);
                sVNWCConflictDescription17.setBaseFile(file3);
                SVNFileUtil.writeToFile(file3, byArray3);
            }
            list.add(sVNWCConflictDescription17);
        }
    }

    public static Structure readPropertyConflict(ISVNWCDb iSVNWCDb, File file, SVNSkel sVNSkel) {
        Serializable serializable;
        Object object;
        SVNSkel sVNSkel2 = SvnWcDbConflicts.getConflict(sVNSkel, SvnWcDbConflicts$ConflictKind.prop);
        if (sVNSkel2 == null) {
            object = SVNErrorMessage.create(SVNErrorCode.WC_MISSING, "Conflict not set");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        Structure structure = Structure.obtain(SvnWcDbConflicts$PropertyConflictInfo.class);
        object = sVNSkel2.first().next();
        if (((SVNSkel)object).first() != null && ((SVNSkel)object).first().isAtom()) {
            serializable = SVNFileUtil.createFilePath(((SVNSkel)object).first().getValue());
            structure.set((Enum)SvnWcDbConflicts$PropertyConflictInfo.markerAbspath, iSVNWCDb.fromRelPath(file, (File)serializable));
        }
        object = ((SVNSkel)object).next();
        serializable = new HashSet();
        for (int i2 = 0; i2 < ((SVNSkel)object).getListSize(); ++i2) {
            serializable.add(((SVNSkel)object).getChild(i2).getValue());
        }
        structure.set((Enum)SvnWcDbConflicts$PropertyConflictInfo.conflictedPropNames, serializable);
        object = ((SVNSkel)object).next();
        if (((SVNSkel)object).isValidPropList()) {
            structure.set((Enum)SvnWcDbConflicts$PropertyConflictInfo.theirOldProps, ((SVNSkel)object).parsePropList());
        } else {
            structure.set((Enum)SvnWcDbConflicts$PropertyConflictInfo.theirOldProps, new HashMap());
        }
        object = ((SVNSkel)object).next();
        if (((SVNSkel)object).isValidPropList()) {
            structure.set((Enum)SvnWcDbConflicts$PropertyConflictInfo.mineProps, ((SVNSkel)object).parsePropList());
        } else {
            structure.set((Enum)SvnWcDbConflicts$PropertyConflictInfo.mineProps, new HashMap());
        }
        object = ((SVNSkel)object).next();
        if (((SVNSkel)object).isValidPropList()) {
            structure.set((Enum)SvnWcDbConflicts$PropertyConflictInfo.theirProps, ((SVNSkel)object).parsePropList());
        } else {
            structure.set((Enum)SvnWcDbConflicts$PropertyConflictInfo.theirProps, new HashMap());
        }
        return structure;
    }

    public static Structure readTextConflict(ISVNWCDb iSVNWCDb, File file, SVNSkel sVNSkel) {
        File file2;
        Object object;
        SVNSkel sVNSkel2 = SvnWcDbConflicts.getConflict(sVNSkel, SvnWcDbConflicts$ConflictKind.text);
        if (sVNSkel2 == null) {
            object = SVNErrorMessage.create(SVNErrorCode.WC_MISSING, "Conflict not set");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = Structure.obtain(SvnWcDbConflicts$TextConflictInfo.class);
        SVNSkel sVNSkel3 = sVNSkel2.first().next().first();
        if (sVNSkel3.isAtom()) {
            file2 = iSVNWCDb.fromRelPath(iSVNWCDb.getWCRoot(file), new File(sVNSkel3.getValue()));
            ((Structure)object).set((Enum)SvnWcDbConflicts$TextConflictInfo.theirOldAbsPath, file2);
        }
        if ((sVNSkel3 = sVNSkel3.next()).isAtom()) {
            file2 = iSVNWCDb.fromRelPath(iSVNWCDb.getWCRoot(file), new File(sVNSkel3.getValue()));
            ((Structure)object).set((Enum)SvnWcDbConflicts$TextConflictInfo.mineAbsPath, file2);
        }
        if ((sVNSkel3 = sVNSkel3.next()).isAtom()) {
            file2 = iSVNWCDb.fromRelPath(iSVNWCDb.getWCRoot(file), new File(sVNSkel3.getValue()));
            ((Structure)object).set((Enum)SvnWcDbConflicts$TextConflictInfo.theirAbsPath, file2);
        }
        return object;
    }

    public static Structure readTreeConflict(ISVNWCDb iSVNWCDb, File file, SVNSkel sVNSkel) {
        Object object;
        SVNSkel sVNSkel2 = SvnWcDbConflicts.getConflict(sVNSkel, SvnWcDbConflicts$ConflictKind.tree);
        if (sVNSkel2 == null) {
            object = SVNErrorMessage.create(SVNErrorCode.WC_MISSING, "Conflict not set");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = Structure.obtain(SvnWcDbConflicts$TreeConflictInfo.class);
        SVNSkel sVNSkel3 = sVNSkel2.first().next().next();
        SVNConflictReason sVNConflictReason = SVNConflictReason.fromString(sVNSkel3.getValue());
        if (sVNConflictReason == null) {
            sVNConflictReason = SVNConflictReason.EDITED;
        }
        boolean bl2 = sVNConflictReason == SVNConflictReason.MOVED_AWAY;
        ((Structure)object).set((Enum)SvnWcDbConflicts$TreeConflictInfo.localChange, sVNConflictReason);
        sVNSkel3 = sVNSkel3.next();
        SVNConflictAction sVNConflictAction = SVNConflictAction.fromString(sVNSkel3.getValue());
        if (sVNConflictAction == null) {
            sVNConflictAction = SVNConflictAction.EDIT;
        }
        ((Structure)object).set((Enum)SvnWcDbConflicts$TreeConflictInfo.incomingChange, sVNConflictAction);
        sVNSkel3 = sVNSkel3.next();
        if (sVNSkel3 != null && bl2) {
            ((Structure)object).set((Enum)SvnWcDbConflicts$TreeConflictInfo.moveSrcOpRootAbsPath, iSVNWCDb.fromRelPath(iSVNWCDb.getWCRoot(file), new File(sVNSkel3.getValue())));
        }
        return object;
    }

    public static Structure getConflictStatusForUpdate(SVNWCDb sVNWCDb, File file, boolean bl2) {
        Structure structure = SvnWcDbConflicts.getConflictStatus(sVNWCDb, file);
        if (bl2) {
            structure.set((Enum)SvnWcDbConflicts$ConflictStatus.conflicted, structure.is(SvnWcDbConflicts$ConflictStatus.treeConflicted));
        } else {
            structure.set((Enum)SvnWcDbConflicts$ConflictStatus.conflicted, structure.is(SvnWcDbConflicts$ConflictStatus.treeConflicted) || structure.is(SvnWcDbConflicts$ConflictStatus.textConflicted) || structure.is(SvnWcDbConflicts$ConflictStatus.propConflicted));
        }
        return structure;
    }

    private static Structure getConflictStatus(SVNWCDb sVNWCDb, File file) {
        Object object;
        Object object2;
        Structure structure;
        Structure structure2 = Structure.obtain(SvnWcDbConflicts$ConflictStatus.class);
        SVNSkel sVNSkel = SvnWcDbConflicts.readConflict(sVNWCDb, file);
        if (sVNSkel == null) {
            return structure2;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        Structure structure3 = SvnWcDbConflicts.readConflictInfo(sVNSkel);
        if (structure3.is(SvnWcDbConflicts$ConflictInfo.textConflicted)) {
            structure = SvnWcDbConflicts.readTextConflict(sVNWCDb, file, sVNSkel);
            object2 = (File)structure.get(SvnWcDbConflicts$TextConflictInfo.mineAbsPath);
            object = (File)structure.get(SvnWcDbConflicts$TextConflictInfo.theirAbsPath);
            File file2 = (File)structure.get(SvnWcDbConflicts$TextConflictInfo.theirOldAbsPath);
            boolean bl4 = false;
            if (object2 != null) {
                structure2.set((Enum)SvnWcDbConflicts$ConflictStatus.textConflicted, SVNFileType.getType((File)object2) == SVNFileType.FILE);
                bl4 = structure2.is(SvnWcDbConflicts$ConflictStatus.textConflicted);
            }
            if (!bl4 && object != null) {
                structure2.set((Enum)SvnWcDbConflicts$ConflictStatus.textConflicted, SVNFileType.getType((File)object) == SVNFileType.FILE);
                bl4 = structure2.is(SvnWcDbConflicts$ConflictStatus.textConflicted);
            }
            if (!bl4 && file2 != null) {
                structure2.set((Enum)SvnWcDbConflicts$ConflictStatus.textConflicted, SVNFileType.getType(file2) == SVNFileType.FILE);
                bl4 = structure2.is(SvnWcDbConflicts$ConflictStatus.textConflicted);
            }
            if (!(bl4 || object2 == null && object == null && file2 == null)) {
                bl2 = false;
            }
        }
        if (structure3.is(SvnWcDbConflicts$ConflictInfo.propConflicted)) {
            structure = SvnWcDbConflicts.readPropertyConflict(sVNWCDb, file, sVNSkel);
            object2 = (File)structure.get(SvnWcDbConflicts$PropertyConflictInfo.markerAbspath);
            if (object2 != null) {
                structure2.set((Enum)SvnWcDbConflicts$ConflictStatus.propConflicted, SVNFileType.getType((File)object2) == SVNFileType.FILE);
            }
            if (!structure2.is(SvnWcDbConflicts$ConflictStatus.propConflicted)) {
                bl3 = true;
            }
        }
        if (structure3.is(SvnWcDbConflicts$ConflictInfo.treeConflicted)) {
            structure = SvnWcDbConflicts.readTreeConflict(sVNWCDb, file, sVNSkel);
            object2 = (SVNConflictReason)structure.get(SvnWcDbConflicts$TreeConflictInfo.incomingChange);
            object = (SVNConflictAction)structure.get(SvnWcDbConflicts$TreeConflictInfo.localChange);
            if (object2 == SVNConflictReason.MOVED_AWAY && object == SVNConflictAction.EDIT) {
                structure2.set((Enum)SvnWcDbConflicts$ConflictStatus.treeConflicted, false);
                structure2.set((Enum)SvnWcDbConflicts$ConflictStatus.conflictIgnored, true);
            }
        }
        if ((bl3 || bl2) && sVNWCDb.isWCLockOwns(file, false)) {
            sVNWCDb.opMarkResolved(file, bl2, bl3, false, null);
        }
        return structure2;
    }

    private static SVNSkel readConflictOperation(SVNSkel sVNSkel) {
        if (sVNSkel == null) {
            return null;
        }
        return sVNSkel.first();
    }

    private static boolean hasConflictKind(SVNSkel sVNSkel, SvnWcDbConflicts$ConflictKind svnWcDbConflicts$ConflictKind) {
        return SvnWcDbConflicts.getConflict(sVNSkel, svnWcDbConflicts$ConflictKind) != null;
    }

    public static SVNSkel getConflict(SVNSkel sVNSkel, SvnWcDbConflicts$ConflictKind svnWcDbConflicts$ConflictKind) {
        for (SVNSkel sVNSkel2 = sVNSkel.first().next().first(); sVNSkel2 != null; sVNSkel2 = sVNSkel2.next()) {
            if (!svnWcDbConflicts$ConflictKind.name().equalsIgnoreCase(sVNSkel2.first().getValue())) continue;
            return sVNSkel2;
        }
        return null;
    }

    private static SVNConflictVersion readConflictLocation(SVNSkel sVNSkel) {
        SVNSkel sVNSkel2 = sVNSkel.first();
        if (sVNSkel2 == null || !sVNSkel2.contentEquals("subversion")) {
            return null;
        }
        sVNSkel2 = sVNSkel2.next();
        SVNURL sVNURL = SVNURL.parseURIEncoded(sVNSkel2.getValue());
        sVNSkel2 = sVNSkel2.next();
        sVNSkel2 = sVNSkel2.next();
        String string = sVNSkel2.getValue();
        sVNSkel2 = sVNSkel2.next();
        long l2 = Long.parseLong(sVNSkel2.getValue());
        sVNSkel2 = sVNSkel2.next();
        SVNNodeKind sVNNodeKind = SVNNodeKind.parseKind(sVNSkel2.getValue());
        return new SVNConflictVersion(sVNURL, string, l2, sVNNodeKind);
    }

    public static void conflictSkelOpUpdate(SVNSkel sVNSkel, SVNConflictVersion sVNConflictVersion, SVNConflictVersion sVNConflictVersion2) {
        assert (sVNSkel != null && sVNSkel.first() != null && sVNSkel.first().next() != null && !sVNSkel.first().next().isAtom());
        SVNSkel sVNSkel2 = SvnWcDbConflicts.getOperation(sVNSkel);
        assert (sVNSkel2 == null);
        sVNSkel2 = sVNSkel.getChild(0);
        SVNSkel sVNSkel3 = SVNSkel.createEmptyList();
        SvnWcDbConflicts.prependLocation(sVNSkel3, sVNConflictVersion2);
        SvnWcDbConflicts.prependLocation(sVNSkel3, sVNConflictVersion);
        sVNSkel2.prepend(sVNSkel3);
        sVNSkel2.prependString(CONFLICT_OP_UPDATE);
    }

    public static void conflictSkelOpSwitch(SVNSkel sVNSkel, SVNConflictVersion sVNConflictVersion, SVNConflictVersion sVNConflictVersion2) {
        assert (sVNSkel != null && sVNSkel.first() != null && sVNSkel.first().next() != null && !sVNSkel.first().next().isAtom());
        SVNSkel sVNSkel2 = SvnWcDbConflicts.getOperation(sVNSkel);
        assert (sVNSkel2 == null);
        sVNSkel2 = sVNSkel.getChild(0);
        SVNSkel sVNSkel3 = SVNSkel.createEmptyList();
        SvnWcDbConflicts.prependLocation(sVNSkel3, sVNConflictVersion2);
        SvnWcDbConflicts.prependLocation(sVNSkel3, sVNConflictVersion);
        sVNSkel2.prepend(sVNSkel3);
        sVNSkel2.prependString(CONFLICT_OP_SWITCH);
    }

    public static void conflictSkelOpMerge(SVNSkel sVNSkel, SVNConflictVersion sVNConflictVersion, SVNConflictVersion sVNConflictVersion2) {
        assert (sVNSkel != null && sVNSkel.first() != null && sVNSkel.first().next() != null && !sVNSkel.first().next().isAtom());
        SVNSkel sVNSkel2 = SvnWcDbConflicts.getOperation(sVNSkel);
        assert (sVNSkel2 == null);
        sVNSkel2 = sVNSkel.getChild(0);
        SVNSkel sVNSkel3 = SVNSkel.createEmptyList();
        SvnWcDbConflicts.prependLocation(sVNSkel3, sVNConflictVersion2);
        SvnWcDbConflicts.prependLocation(sVNSkel3, sVNConflictVersion);
        sVNSkel2.prepend(sVNSkel3);
        sVNSkel2.prependString(CONFLICT_OP_MERGE);
    }

    public static SVNSkel createConflictMarkers(ISVNWCDb iSVNWCDb, File file, SVNSkel sVNSkel) {
        Structure structure = SvnWcDbConflicts.readConflictInfo(sVNSkel);
        SVNOperation sVNOperation = (SVNOperation)structure.get(SvnWcDbConflicts$ConflictInfo.conflictOperation);
        boolean bl2 = structure.is(SvnWcDbConflicts$ConflictInfo.propConflicted);
        if (bl2) {
            String string;
            File file2;
            SVNFileType sVNFileType = SVNFileType.getType(file);
            if (sVNFileType == SVNFileType.DIRECTORY) {
                file2 = file;
                string = "dir_conflicts";
            } else {
                file2 = SVNFileUtil.getParentFile(file);
                string = SVNFileUtil.getFileName(file);
            }
            File file3 = SVNFileUtil.createUniqueFile(file2, string, ".prej", false);
            File file4 = iSVNWCDb.toRelPath(file3);
            SVNSkel sVNSkel2 = SvnWcDbConflicts.getConflict(sVNSkel, SvnWcDbConflicts$ConflictKind.prop);
            sVNSkel2.first().next().prependPath(file4);
            Structure structure2 = SvnWcDbConflicts.readPropertyConflict(iSVNWCDb, file, sVNSkel);
            SVNProperties sVNProperties = SVNProperties.wrap((Map)structure2.get(SvnWcDbConflicts$PropertyConflictInfo.mineProps));
            SVNProperties sVNProperties2 = SVNProperties.wrap((Map)structure2.get(SvnWcDbConflicts$PropertyConflictInfo.theirOldProps));
            SVNProperties sVNProperties3 = SVNProperties.wrap((Map)structure2.get(SvnWcDbConflicts$PropertyConflictInfo.theirProps));
            Collection collection = (Collection)structure2.get(SvnWcDbConflicts$PropertyConflictInfo.conflictedPropNames);
            SVNProperties sVNProperties4 = sVNOperation == SVNOperation.MERGE ? iSVNWCDb.readPristineProperties(file) : sVNProperties2;
            SVNSkel sVNSkel3 = SVNSkel.createEmptyList();
            sVNSkel3.prepend(SVNSkel.createEmptyList());
            for (String string2 : collection) {
                SvnWcDbConflicts.addPropConflict(sVNSkel3, string2, sVNProperties4 != null ? sVNProperties4.getSVNPropertyValue(string2) : null, sVNProperties != null ? sVNProperties.getSVNPropertyValue(string2) : null, sVNProperties3 != null ? sVNProperties3.getSVNPropertyValue(string2) : null, sVNProperties2 != null ? sVNProperties2.getSVNPropertyValue(string2) : null);
            }
            return SVNWCContext.wqBuildPrejInstall(iSVNWCDb, file, sVNSkel3);
        }
        return null;
    }

    private static SVNSkel getOperation(SVNSkel sVNSkel) {
        assert (sVNSkel != null && sVNSkel.first() != null && sVNSkel.first().next() != null && !sVNSkel.first().next().isAtom());
        SVNSkel sVNSkel2 = sVNSkel.first();
        if (sVNSkel2.first() == null) {
            sVNSkel2 = null;
        }
        return sVNSkel2;
    }

    public static void addPropConflict(SVNSkel sVNSkel, String string, SVNPropertyValue sVNPropertyValue, SVNPropertyValue sVNPropertyValue2, SVNPropertyValue sVNPropertyValue3, SVNPropertyValue sVNPropertyValue4) {
        SVNSkel sVNSkel2 = SVNSkel.createEmptyList();
        SvnWcDbConflicts.prependPropValue(sVNPropertyValue4, sVNSkel2);
        SvnWcDbConflicts.prependPropValue(sVNPropertyValue3, sVNSkel2);
        SvnWcDbConflicts.prependPropValue(sVNPropertyValue2, sVNSkel2);
        SvnWcDbConflicts.prependPropValue(sVNPropertyValue, sVNSkel2);
        sVNSkel2.prependString(string);
        sVNSkel2.prependString(SvnWcDbConflicts$ConflictKind.prop.toString());
        sVNSkel.appendChild(sVNSkel2);
    }

    public static void prependPropValue(SVNPropertyValue sVNPropertyValue, SVNSkel sVNSkel) {
        SVNSkel sVNSkel2 = SVNSkel.createEmptyList();
        if (sVNPropertyValue != null && (sVNPropertyValue.getBytes() != null || sVNPropertyValue.getString() != null)) {
            sVNSkel2.prependPropertyValue(sVNPropertyValue);
        }
        sVNSkel.prepend(sVNSkel2);
    }

    public static SVNSkel treeConflictDescriptionToSkel(ISVNWCDb iSVNWCDb, File file, SVNTreeConflictDescription sVNTreeConflictDescription) {
        SVNSkel sVNSkel = SvnWcDbConflicts.createConflictSkel();
        SvnWcDbConflicts.addTreeConflict(sVNSkel, iSVNWCDb, file, sVNTreeConflictDescription.getConflictReason(), sVNTreeConflictDescription.getConflictAction(), null);
        if (sVNTreeConflictDescription.getOperation() != null) {
            if (sVNTreeConflictDescription.getOperation() == SVNOperation.UPDATE) {
                SvnWcDbConflicts.conflictSkelOpUpdate(sVNSkel, sVNTreeConflictDescription.getSourceLeftVersion(), sVNTreeConflictDescription.getSourceRightVersion());
            } else if (sVNTreeConflictDescription.getOperation() == SVNOperation.SWITCH) {
                SvnWcDbConflicts.conflictSkelOpSwitch(sVNSkel, sVNTreeConflictDescription.getSourceLeftVersion(), sVNTreeConflictDescription.getSourceRightVersion());
            } else if (sVNTreeConflictDescription.getOperation() == SVNOperation.MERGE) {
                SvnWcDbConflicts.conflictSkelOpMerge(sVNSkel, sVNTreeConflictDescription.getSourceLeftVersion(), sVNTreeConflictDescription.getSourceRightVersion());
            }
        }
        return sVNSkel;
    }

    public static boolean conflictSkelResolve(SVNSkel sVNSkel, ISVNWCDb iSVNWCDb, File file, boolean bl2, String string, boolean bl3) {
        Object object;
        SVNSkel sVNSkel2 = SvnWcDbConflicts.getOperation(sVNSkel);
        if (sVNSkel2 == null) {
            object = SVNErrorMessage.create(SVNErrorCode.INCOMPLETE_DATA, "Not a completed conflict skel");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = sVNSkel.first().next();
        HashSet<SVNSkel> hashSet = new HashSet<SVNSkel>();
        SVNSkel sVNSkel3 = ((SVNSkel)object).first();
        while (sVNSkel3 != null) {
            SVNSkel sVNSkel4 = sVNSkel3.first();
            if (bl2 && sVNSkel4.contentEquals(SvnWcDbConflicts$ConflictKind.text.name())) {
                hashSet.add(sVNSkel3);
                sVNSkel3 = sVNSkel3.next();
                continue;
            }
            if (string != null && sVNSkel4.contentEquals(SvnWcDbConflicts$ConflictKind.prop.name())) {
                SVNSkel sVNSkel5;
                SVNSkel sVNSkel6 = sVNSkel4.next().next();
                if (string.length() == 0) {
                    sVNSkel6.removeAllChildren();
                    sVNSkel5 = null;
                } else {
                    HashSet<SVNSkel> hashSet2 = new HashSet<SVNSkel>();
                    for (sVNSkel5 = sVNSkel6.first(); sVNSkel5 != null; sVNSkel5 = sVNSkel5.next()) {
                        if (!sVNSkel5.contentEquals(string)) continue;
                        hashSet2.add(sVNSkel5);
                        sVNSkel5 = sVNSkel5.next();
                        break;
                    }
                    sVNSkel6.removeChildren(hashSet2);
                }
                if (sVNSkel4.next().next().first() == null) {
                    hashSet.add(sVNSkel3);
                    sVNSkel3 = sVNSkel3.next();
                    continue;
                }
            } else if (bl3 && sVNSkel4.contentEquals(SvnWcDbConflicts$ConflictKind.tree.name())) {
                hashSet.add(sVNSkel3);
                sVNSkel3 = sVNSkel3.next();
                continue;
            }
            sVNSkel3 = sVNSkel3.next();
        }
        ((SVNSkel)object).removeChildren(hashSet);
        return !SvnWcDbConflicts.isConflictSkelComplete(sVNSkel);
    }

    public static List readConflictMarkers(SVNWCDb sVNWCDb, File file, SVNSkel sVNSkel) {
        assert (sVNSkel != null);
        ArrayList<File> arrayList = null;
        for (SVNSkel sVNSkel2 = sVNSkel.first().next().first(); sVNSkel2 != null; sVNSkel2 = sVNSkel2.next()) {
            for (SVNSkel sVNSkel3 = sVNSkel2.first().next().first(); sVNSkel3 != null; sVNSkel3 = sVNSkel3.next()) {
                if (!sVNSkel3.isAtom()) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<File>(4);
                }
                File file2 = sVNWCDb.fromRelPath(file, SVNFileUtil.createFilePath(sVNSkel3.getValue()));
                arrayList.add(file2);
            }
        }
        return arrayList;
    }

    public static SVNSkel upgradeConflictSkelFromRaw(ISVNWCDb iSVNWCDb, File file, File file2, String string, String string2, String string3, File file3, SVNSkel sVNSkel) {
        Object object;
        Object object2;
        File file4;
        File file5 = iSVNWCDb.getWCRoot(file);
        SVNSkel sVNSkel2 = null;
        if (string != null || string3 != null || string2 != null) {
            sVNSkel2 = SvnWcDbConflicts.createConflictSkel();
            file4 = null;
            if (string != null) {
                file4 = SVNFileUtil.createFilePath(file5, string);
            }
            object2 = null;
            if (string3 != null) {
                object2 = SVNFileUtil.createFilePath(file5, string3);
            }
            object = null;
            if (string2 != null) {
                object = SVNFileUtil.createFilePath(file5, string2);
            }
            SvnWcDbConflicts.addTextConflict(sVNSkel2, iSVNWCDb, file, (File)object, file4, (File)object2);
        }
        if (file3 != null) {
            if (sVNSkel2 == null) {
                sVNSkel2 = SvnWcDbConflicts.createConflictSkel();
            }
            SvnWcDbConflicts.addPropConflict(sVNSkel2, iSVNWCDb, file, file3, null, null, null, new HashSet());
        }
        if (sVNSkel != null) {
            if (sVNSkel2 == null) {
                sVNSkel2 = SvnWcDbConflicts.createConflictSkel();
            }
            file4 = SVNFileUtil.createFilePath(file5, file2);
            object2 = SVNTreeConflictUtil.readSingleTreeConflict(sVNSkel, SVNFileUtil.getFileDir(file4));
            SvnWcDbConflicts.addTreeConflict(sVNSkel2, iSVNWCDb, file, ((SVNConflictDescription)object2).getConflictReason(), ((SVNConflictDescription)object2).getConflictAction(), null);
            object = ((SVNTreeConflictDescription)object2).getOperation();
            if (object == SVNOperation.UPDATE) {
                SvnWcDbConflicts.conflictSkelOpUpdate(sVNSkel2, ((SVNTreeConflictDescription)object2).getSourceLeftVersion(), ((SVNTreeConflictDescription)object2).getSourceRightVersion());
            } else if (object == SVNOperation.SWITCH) {
                SvnWcDbConflicts.conflictSkelOpSwitch(sVNSkel2, ((SVNTreeConflictDescription)object2).getSourceLeftVersion(), ((SVNTreeConflictDescription)object2).getSourceRightVersion());
            } else if (object == SVNOperation.MERGE) {
                SvnWcDbConflicts.conflictSkelOpMerge(sVNSkel2, ((SVNTreeConflictDescription)object2).getSourceLeftVersion(), ((SVNTreeConflictDescription)object2).getSourceRightVersion());
            } else {
                SvnWcDbConflicts.conflictSkelOpUpdate(sVNSkel2, ((SVNTreeConflictDescription)object2).getSourceLeftVersion(), ((SVNTreeConflictDescription)object2).getSourceRightVersion());
            }
        } else if (sVNSkel2 != null) {
            SvnWcDbConflicts.conflictSkelOpUpdate(sVNSkel2, null, null);
        }
        return sVNSkel2;
    }

    private static void addTextConflict(SVNSkel sVNSkel, String string, String string2, String string3) {
        SVNSkel sVNSkel2 = SVNSkel.createEmptyList();
        SVNSkel sVNSkel3 = SVNSkel.createEmptyList();
        if (string3 != null) {
            sVNSkel3.prepend(SVNSkel.createAtom(string3));
        } else {
            sVNSkel3.prepend(SVNSkel.createEmptyList());
        }
        if (string != null) {
            sVNSkel3.prepend(SVNSkel.createAtom(string));
        } else {
            sVNSkel3.prepend(SVNSkel.createEmptyList());
        }
        if (string2 != null) {
            sVNSkel3.prepend(SVNSkel.createAtom(string2));
        } else {
            sVNSkel3.prepend(SVNSkel.createEmptyList());
        }
        sVNSkel2.prepend(sVNSkel3);
        sVNSkel2.prepend(SVNSkel.createAtom(SvnWcDbConflicts$ConflictKind.text.toString()));
        sVNSkel.first().next().prepend(sVNSkel2);
    }

    private static void addPropConflict(SVNSkel sVNSkel, String string) {
        SVNSkel sVNSkel2 = SVNSkel.createEmptyList();
        SVNSkel sVNSkel3 = SVNSkel.createEmptyList();
        sVNSkel2.prepend(sVNSkel3);
        SVNSkel sVNSkel4 = SVNSkel.createEmptyList();
        if (string != null) {
            sVNSkel4.prepend(SVNSkel.createAtom(string));
        }
        sVNSkel2.prepend(sVNSkel4);
        sVNSkel2.prepend(SVNSkel.createAtom(SvnWcDbConflicts$ConflictKind.prop.toString()));
        sVNSkel.first().next().prepend(sVNSkel2);
    }

    private static void addTreeConflict(SVNSkel sVNSkel, SVNConflictReason sVNConflictReason, SVNConflictAction sVNConflictAction) {
        SVNSkel sVNSkel2 = SVNSkel.createEmptyList();
        sVNSkel2.prepend(SVNSkel.createAtom(sVNConflictAction.getName()));
        sVNSkel2.prepend(SVNSkel.createAtom(sVNConflictReason.getName()));
        SVNSkel sVNSkel3 = SVNSkel.createEmptyList();
        sVNSkel2.prepend(sVNSkel3);
        sVNSkel2.prepend(SVNSkel.createAtom(SvnWcDbConflicts$ConflictKind.tree.toString()));
        sVNSkel.first().next().prepend(sVNSkel2);
    }
}

