/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.schema.SqlJetConflictAction;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.svn.core.internal.db.ISVNSqlJetTrigger;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema$NODES__Fields;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema$PRISTINE__Fields;

public class SvnNodesPristineTrigger
implements ISVNSqlJetTrigger {
    private Map checksumTriggerValues;

    @Override
    public void beforeUpdate(ISqlJetCursor iSqlJetCursor, Map map) {
        if (map.containsKey(SVNWCDbSchema$NODES__Fields.checksum.toString())) {
            String string = (String)map.get(SVNWCDbSchema$NODES__Fields.checksum.toString());
            String string2 = iSqlJetCursor.getString(SVNWCDbSchema$NODES__Fields.checksum.toString());
            this.changeRefCount(string2, -1);
            this.changeRefCount(string, 1);
        }
    }

    @Override
    public void beforeDelete(ISqlJetCursor iSqlJetCursor) {
        String string = iSqlJetCursor.getString(SVNWCDbSchema$NODES__Fields.checksum.toString());
        this.changeRefCount(string, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeInsert(SqlJetConflictAction sqlJetConflictAction, ISqlJetTable iSqlJetTable, Map map) {
        Object object;
        if (sqlJetConflictAction == SqlJetConflictAction.REPLACE) {
            object = map.get(SVNWCDbSchema$NODES__Fields.wc_id.toString());
            Object v2 = map.get(SVNWCDbSchema$NODES__Fields.local_relpath.toString());
            Object v3 = map.get(SVNWCDbSchema$NODES__Fields.op_depth.toString());
            try (ISqlJetCursor iSqlJetCursor = iSqlJetTable.lookup(null, object, v2, v3);){
                if (!iSqlJetCursor.eof()) {
                    this.changeRefCount(iSqlJetCursor.getString(SVNWCDbSchema$NODES__Fields.checksum.toString()), -1);
                }
            }
        }
        object = (String)map.get(SVNWCDbSchema$NODES__Fields.checksum.toString());
        this.changeRefCount((String)object, 1);
    }

    private void changeRefCount(String string, int n2) {
        if (string != null) {
            if (!this.getTriggerValues().containsKey(string)) {
                this.getTriggerValues().put(string, n2);
            } else {
                this.getTriggerValues().put(string, (Integer)this.getTriggerValues().get(string) + n2);
            }
        }
    }

    private Map getTriggerValues() {
        if (this.checksumTriggerValues == null) {
            this.checksumTriggerValues = new HashMap();
        }
        return this.checksumTriggerValues;
    }

    @Override
    public void statementStarted(SqlJetDb sqlJetDb) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statementCompleted(SqlJetDb sqlJetDb, SqlJetException sqlJetException) {
        try {
            if (sqlJetException == null && !this.getTriggerValues().isEmpty()) {
                HashMap<String, Long> hashMap = new HashMap<String, Long>();
                ISqlJetTable iSqlJetTable = sqlJetDb.getTable(SVNWCDbSchema.PRISTINE.toString());
                for (String string : this.getTriggerValues().keySet()) {
                    long l2 = ((Integer)this.getTriggerValues().get(string)).intValue();
                    if (l2 == 0L) continue;
                    ISqlJetCursor iSqlJetCursor = iSqlJetTable.lookup(null, string);
                    if (iSqlJetCursor != null && !iSqlJetCursor.eof()) {
                        long l3 = iSqlJetCursor.getInteger(SVNWCDbSchema$PRISTINE__Fields.refcount.toString());
                        if ((l3 += l2) < 0L) {
                            l3 = 0L;
                        }
                        hashMap.put(SVNWCDbSchema$PRISTINE__Fields.refcount.toString(), l3);
                        iSqlJetCursor.updateByFieldNames(hashMap);
                    }
                    iSqlJetCursor.close();
                }
            }
        }
        finally {
            this.checksumTriggerValues = null;
        }
    }
}

