/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNUpdateEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$MergeInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$MergePropertiesInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$WritableBaseInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo$BaseInfoField;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnChecksum$Kind;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnExternalUpdateEditor
implements ISVNUpdateEditor {
    private long targetRevision;
    private String name;
    private long originalRevision;
    private File localAbsPath;
    private SVNWCContext context;
    private SvnChecksum originalChecksum;
    private File wriAbsPath;
    private SVNDeltaProcessor deltaProcessor = new SVNDeltaProcessor();
    private SVNWCContext$WritableBaseInfo currentBase;
    private SVNProperties davPropChanges;
    private SVNProperties entryPropChanges;
    private SVNProperties regularPropChanges;
    private SVNURL url;
    private SVNURL reposRootUrl;
    private long changedRev;
    private String changedAuthor;
    private SVNDate changedDate;
    private String[] extPatterns;
    private boolean useCommitTimes;
    private String reposUuid;
    private File recordAncestorAbspath;
    private File recordedReposRelPath;
    private long recordedPegRevision;
    private long recordedRevision;
    private SvnChecksum newMd5Checksum;
    private SvnChecksum newSha1Checksum;
    private boolean fileClosed;
    private Map iprops;
    private boolean added;

    public static ISVNUpdateEditor createEditor(SVNWCContext sVNWCContext, File file, File file2, SVNURL sVNURL, SVNURL sVNURL2, String string, Map map, boolean bl2, String[] stringArray, File file3, SVNURL sVNURL3, SVNRevision sVNRevision, SVNRevision sVNRevision2) {
        SvnExternalUpdateEditor svnExternalUpdateEditor = new SvnExternalUpdateEditor();
        svnExternalUpdateEditor.context = sVNWCContext;
        svnExternalUpdateEditor.localAbsPath = file;
        svnExternalUpdateEditor.wriAbsPath = file2 != null ? file2 : SVNFileUtil.getParentFile(file);
        svnExternalUpdateEditor.url = sVNURL;
        svnExternalUpdateEditor.reposRootUrl = sVNURL2;
        svnExternalUpdateEditor.reposUuid = string;
        svnExternalUpdateEditor.name = SVNFileUtil.getFileName(file);
        svnExternalUpdateEditor.useCommitTimes = bl2;
        svnExternalUpdateEditor.extPatterns = stringArray;
        svnExternalUpdateEditor.recordAncestorAbspath = file3;
        svnExternalUpdateEditor.recordedReposRelPath = SVNFileUtil.createFilePath(SVNURLUtil.getRelativeURL(sVNURL2, sVNURL3, false));
        svnExternalUpdateEditor.recordedPegRevision = sVNRevision != null ? sVNRevision.getNumber() : -1L;
        svnExternalUpdateEditor.recordedRevision = sVNRevision2 != null ? sVNRevision2.getNumber() : -1L;
        svnExternalUpdateEditor.iprops = map;
        return (ISVNUpdateEditor)SVNCancellableEditor.newInstance(svnExternalUpdateEditor, sVNWCContext.getEventHandler(), null);
    }

    @Override
    public void targetRevision(long l2) {
        this.targetRevision = l2;
    }

    @Override
    public void openRoot(long l2) {
    }

    @Override
    public void deleteEntry(String string, long l2) {
    }

    @Override
    public void absentDir(String string) {
    }

    @Override
    public void absentFile(String string) {
    }

    @Override
    public void addDir(String string, String string2, long l2) {
    }

    @Override
    public void openDir(String string, long l2) {
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
    }

    @Override
    public void closeDir() {
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        String string3 = SVNPathUtil.tail(string);
        if (!string3.equals(this.name)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "This editor can only update ''{0}''", (Object)this.localAbsPath);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        this.originalRevision = -1L;
        this.added = true;
    }

    @Override
    public void openFile(String string, long l2) {
        Object object;
        String string2 = SVNPathUtil.tail(string);
        if (!string2.equals(this.name)) {
            object = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "This editor can only update ''{0}''", (Object)this.localAbsPath);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = this.context.getDb().getBaseInfo(this.localAbsPath, ISVNWCDb$WCDbBaseInfo$BaseInfoField.kind, ISVNWCDb$WCDbBaseInfo$BaseInfoField.revision, ISVNWCDb$WCDbBaseInfo$BaseInfoField.changedRev, ISVNWCDb$WCDbBaseInfo$BaseInfoField.changedAuthor, ISVNWCDb$WCDbBaseInfo$BaseInfoField.changedDate, ISVNWCDb$WCDbBaseInfo$BaseInfoField.checksum);
        this.originalRevision = ((ISVNWCDb$WCDbBaseInfo)object).revision;
        this.changedRev = ((ISVNWCDb$WCDbBaseInfo)object).changedRev;
        this.changedDate = ((ISVNWCDb$WCDbBaseInfo)object).changedDate;
        this.changedAuthor = ((ISVNWCDb$WCDbBaseInfo)object).changedAuthor;
        this.originalChecksum = ((ISVNWCDb$WCDbBaseInfo)object).checksum;
        if (((ISVNWCDb$WCDbBaseInfo)object).kind != ISVNWCDb$SVNWCDbKind.File) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Node ''{0}'' is not existing file external", (Object)this.localAbsPath);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        if (SVNProperty.isRegularProperty(string2)) {
            if (this.regularPropChanges == null) {
                this.regularPropChanges = new SVNProperties();
            }
            this.regularPropChanges.put(string2, sVNPropertyValue);
        } else if (SVNProperty.isEntryProperty(string2)) {
            if (this.entryPropChanges == null) {
                this.entryPropChanges = new SVNProperties();
            }
            this.entryPropChanges.put(string2, sVNPropertyValue);
        } else if (SVNProperty.isWorkingCopyProperty(string2)) {
            if (this.davPropChanges == null) {
                this.davPropChanges = new SVNProperties();
            }
            this.davPropChanges.put(string2, sVNPropertyValue);
        }
    }

    @Override
    public void closeFile(String string, String string2) {
        Object object;
        Object object2;
        SVNProperties sVNProperties;
        Serializable serializable;
        Object object32;
        Object object4;
        Object object5;
        this.fileClosed = true;
        if (string2 != null) {
            SvnChecksum svnChecksum = new SvnChecksum(SvnChecksum$Kind.md5, string2);
            object5 = this.newMd5Checksum;
            if (object5 == null && (object5 = this.originalChecksum) != null && ((SvnChecksum)object5).getKind() != SvnChecksum$Kind.md5) {
                object5 = this.context.getDb().getPristineMD5(this.wriAbsPath, (SvnChecksum)object5);
            }
            if (!svnChecksum.equals(object5)) {
                object4 = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}'':\n   expected: ''{1}''\n     actual: ''{2}''\n", this.localAbsPath, svnChecksum, object5);
                SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.WC);
            }
        }
        if (this.newSha1Checksum != null) {
            this.context.getDb().installPristine(this.currentBase.tempBaseAbspath, this.currentBase.getSHA1Checksum(), this.currentBase.getMD5Checksum());
            SVNFileUtil.deleteFile(this.currentBase.tempBaseAbspath);
        }
        boolean bl2 = this.originalRevision == -1L;
        object5 = SVNFileUtil.createFilePath(SVNURLUtil.getRelativeURL(this.reposRootUrl, this.url, false));
        object4 = null;
        SVNProperties sVNProperties2 = null;
        SVNProperties sVNProperties3 = new SVNProperties();
        SVNSkel sVNSkel = null;
        SVNSkel sVNSkel2 = null;
        if (!bl2) {
            object4 = this.originalChecksum;
            sVNProperties3 = this.context.getDb().getBaseProps(this.localAbsPath);
            sVNProperties2 = this.context.getDb().readProperties(this.localAbsPath);
        }
        if (sVNProperties2 == null) {
            sVNProperties2 = new SVNProperties();
        }
        if (this.newSha1Checksum != null) {
            object4 = this.newSha1Checksum;
        }
        for (Object object32 : this.entryPropChanges.nameSet()) {
            serializable = this.entryPropChanges.getSVNPropertyValue((String)object32);
            if (serializable == null) continue;
            if ("svn:entry:committed-date".equals(object32)) {
                this.changedDate = SVNDate.parseDate(((SVNPropertyValue)serializable).getString());
                continue;
            }
            if ("svn:entry:last-author".equals(object32)) {
                this.changedAuthor = ((SVNPropertyValue)serializable).getString();
                continue;
            }
            if (!"svn:entry:committed-rev".equals(object32)) continue;
            try {
                this.changedRev = Long.parseLong(((SVNPropertyValue)serializable).getString());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        Object object6 = SVNStatusType.UNKNOWN;
        object32 = SVNStatusType.UNKNOWN;
        if (this.regularPropChanges != null) {
            SVNWCContext$MergePropertiesInfo sVNWCContext$MergePropertiesInfo = new SVNWCContext$MergePropertiesInfo();
            sVNWCContext$MergePropertiesInfo.newActualProperties = new SVNProperties();
            sVNWCContext$MergePropertiesInfo.newBaseProperties = new SVNProperties();
            sVNProperties = new SVNProperties(sVNProperties3);
            sVNProperties.putAll(this.regularPropChanges);
            sVNProperties.removeNullValues();
            sVNWCContext$MergePropertiesInfo = this.context.mergeProperties2(sVNWCContext$MergePropertiesInfo, this.localAbsPath, ISVNWCDb$SVNWCDbKind.File, null, null, null, sVNProperties3, sVNProperties2, this.regularPropChanges, true, false, this.context.getOptions().getConflictResolver());
            object32 = sVNWCContext$MergePropertiesInfo.mergeOutcome;
            serializable = sVNWCContext$MergePropertiesInfo.newActualProperties;
            sVNSkel2 = sVNWCContext$MergePropertiesInfo.conflictSkel;
        } else {
            serializable = sVNProperties3;
            sVNProperties = sVNProperties2;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.newSha1Checksum != null) {
            object2 = SVNFileType.getType(this.localAbsPath);
            object = SVNFileType.getNodeKind((SVNFileType)object2);
            if (object == SVNNodeKind.NONE) {
                bl3 = true;
                object6 = SVNStatusType.CHANGED;
            } else if (object != SVNNodeKind.FILE || this.added && object == SVNNodeKind.FILE) {
                bl4 = true;
                object6 = SVNStatusType.UNCHANGED;
            } else {
                boolean bl5 = this.context.isTextModified(this.localAbsPath, false);
                if (!bl5) {
                    bl3 = true;
                    object6 = SVNStatusType.CHANGED;
                } else {
                    SVNProperties sVNProperties4 = new SVNProperties();
                    if (this.regularPropChanges != null) {
                        sVNProperties4.putAll(this.regularPropChanges);
                    }
                    if (this.entryPropChanges != null) {
                        sVNProperties4.putAll(this.entryPropChanges);
                    }
                    if (this.davPropChanges != null) {
                        sVNProperties4.putAll(this.davPropChanges);
                    }
                    SVNWCContext$MergeInfo sVNWCContext$MergeInfo = new SVNWCContext$MergeInfo();
                    sVNWCContext$MergeInfo.conflictSkel = null;
                    SVNWCContext$MergeInfo sVNWCContext$MergeInfo2 = SVNUpdateEditor17.performFileMerge(sVNWCContext$MergeInfo, this.context, this.localAbsPath, this.wriAbsPath, (SvnChecksum)object4, this.originalChecksum, sVNProperties2, this.extPatterns, this.originalRevision, this.targetRevision, sVNProperties4);
                    if (sVNWCContext$MergeInfo2.workItems != null) {
                        sVNSkel = SVNWCContext.wqMerge(sVNSkel, sVNWCContext$MergeInfo2.workItems);
                    }
                    object6 = sVNWCContext$MergeInfo2.foundTextConflict ? SVNStatusType.CONFLICTED : SVNStatusType.MERGED;
                    sVNSkel2 = sVNWCContext$MergeInfo2.conflictSkel;
                }
            }
            if (bl3) {
                SVNSkel sVNSkel3 = this.context.wqBuildFileInstall(this.localAbsPath, null, this.useCommitTimes, true);
                sVNSkel = SVNWCContext.wqMerge(sVNSkel, sVNSkel3);
            }
        } else {
            object6 = SVNStatusType.UNCHANGED;
        }
        if (sVNSkel2 != null) {
            SvnWcDbConflicts.conflictSkelOpSwitch(sVNSkel2, new SVNConflictVersion(this.reposRootUrl, SVNFileUtil.getFilePath((File)object5), this.originalRevision, SVNNodeKind.FILE), new SVNConflictVersion(this.reposRootUrl, SVNFileUtil.getFilePath((File)object5), this.targetRevision, SVNNodeKind.FILE));
            object2 = SvnWcDbConflicts.createConflictMarkers(this.context.getDb(), this.localAbsPath, sVNSkel2);
            sVNSkel = SVNWCContext.wqMerge(sVNSkel, (SVNSkel)object2);
        }
        if (this.davPropChanges != null) {
            this.davPropChanges.removeNullValues();
        }
        SvnWcDbExternals.addExternalFile(this.context, this.localAbsPath, this.wriAbsPath, (File)object5, this.reposRootUrl, this.reposUuid, this.targetRevision, sVNProperties, this.iprops, this.changedRev, this.changedDate, this.changedAuthor, (SvnChecksum)object4, this.davPropChanges, this.recordAncestorAbspath, this.recordedReposRelPath, this.recordedPegRevision, this.recordedRevision, true, (SVNProperties)serializable, false, sVNSkel2, sVNSkel);
        this.iprops = null;
        this.context.wqRun(this.wriAbsPath);
        if (this.context.getEventHandler() != null) {
            object2 = null;
            object2 = !this.added ? (bl4 ? SVNEventAction.UPDATE_SHADOWED_UPDATE : SVNEventAction.UPDATE_UPDATE) : (bl4 ? SVNEventAction.UPDATE_SHADOWED_ADD : SVNEventAction.UPDATE_ADD);
            object = this.context.getProperty(this.localAbsPath, "svn:mime-type");
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(this.localAbsPath, SVNNodeKind.FILE, (String)object, this.targetRevision, (SVNStatusType)object6, (SVNStatusType)object32, null, (SVNEventAction)object2, null, null, null);
            sVNEvent.setPreviousRevision(this.originalRevision);
            this.context.getEventHandler().handleEvent(sVNEvent, -1.0);
        }
    }

    @Override
    public SVNCommitInfo closeEdit() {
        if (!this.fileClosed || this.iprops != null) {
            HashMap<File, Map> hashMap;
            HashMap<File, Map> hashMap2 = hashMap = this.iprops != null ? new HashMap<File, Map>() : null;
            if (hashMap != null) {
                hashMap.put(this.localAbsPath, this.iprops);
            }
            this.context.getDb().opBumpRevisionPostUpdate(this.localAbsPath, SVNDepth.INFINITY, null, null, null, this.targetRevision, null, hashMap, this.context.getEventHandler());
        }
        return null;
    }

    @Override
    public void abortEdit() {
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        InputStream inputStream = SVNFileUtil.DUMMY_IN;
        if (this.originalChecksum != null) {
            SvnChecksum svnChecksum;
            SvnChecksum svnChecksum2;
            if (string2 != null && !(svnChecksum2 = new SvnChecksum(SvnChecksum$Kind.md5, string2)).equals(svnChecksum = this.originalChecksum.getKind() != SvnChecksum$Kind.md5 ? this.context.getDb().getPristineMD5(this.wriAbsPath, this.originalChecksum) : this.originalChecksum)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Base checksum mismatch for ''{0}'':\n   expected: ''{1}''\n     actual: ''{2}''\n", this.localAbsPath, svnChecksum2, svnChecksum);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            inputStream = this.context.getDb().readPristine(this.wriAbsPath, this.originalChecksum);
        }
        this.currentBase = this.context.openWritableBase(this.wriAbsPath, true, true);
        this.deltaProcessor.applyTextDelta(inputStream, this.currentBase.stream, true);
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        if (this.currentBase == null) {
            return SVNFileUtil.DUMMY_OUT;
        }
        try {
            this.deltaProcessor.textDeltaChunk(sVNDiffWindow);
        }
        catch (SVNException sVNException) {
            this.deltaProcessor.textDeltaEnd();
            SVNFileUtil.deleteFile(this.currentBase.tempBaseAbspath);
            this.currentBase.tempBaseAbspath = null;
            throw sVNException;
        }
        return SVNFileUtil.DUMMY_OUT;
    }

    @Override
    public void textDeltaEnd(String string) {
        if (this.currentBase == null) {
            return;
        }
        this.deltaProcessor.textDeltaEnd();
        this.newSha1Checksum = this.currentBase.getSHA1Checksum();
        this.newMd5Checksum = this.currentBase.getMD5Checksum();
    }

    @Override
    public long getTargetRevision() {
        return this.targetRevision;
    }
}

