/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNWCDbRoot {
    private SVNWCDb db;
    private File absPath;
    private SVNSqlJetDb sDb;
    private long wcId;
    private int format;
    private List ownedLocks = new ArrayList();

    public SVNWCDbRoot(SVNWCDb sVNWCDb, File file, SVNSqlJetDb sVNSqlJetDb, long l2, int n2, boolean bl2, boolean bl3, boolean bl4) {
        Serializable serializable;
        if (sVNSqlJetDb != null) {
            try {
                n2 = sVNSqlJetDb.getDb().getOptions().getUserVersion();
            }
            catch (SqlJetException sqlJetException) {
                if (sqlJetException.getErrorCode() == SqlJetErrorCode.NOTADB) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, sqlJetException);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
                SVNSqlJetDb.createSqlJetError(sqlJetException);
            }
        }
        if (n2 < 1) {
            serializable = new SqlJetException(SqlJetErrorCode.BUSY);
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR), serializable, SVNLogType.WC);
        }
        if (n2 < 4) {
            serializable = SVNErrorMessage.create(SVNErrorCode.WC_UPGRADE_REQUIRED, "Working copy format of ''{0}'' is too old ''{1}''", new Object[]{file, n2});
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        if (n2 > 31) {
            serializable = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT, "This client is too old to work with the working copy at\n''{0}'' (format ''{1}'').", new Object[]{file, n2});
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        if (bl3 && n2 < 29) {
            if (bl2) {
                n2 = SvnNgUpgradeSDb.upgrade(file, sVNWCDb, sVNSqlJetDb, n2, null);
            } else {
                serializable = SVNErrorMessage.create(SVNErrorCode.WC_UPGRADE_REQUIRED, "Working copy format of ''{0}'' is too old ''{1}''", new Object[]{file, n2});
                SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
            }
        }
        if (n2 >= 13 && bl4) {
            sVNSqlJetDb.verifyNoWork();
        }
        this.db = sVNWCDb;
        this.absPath = file;
        this.sDb = sVNSqlJetDb;
        this.wcId = l2;
        this.format = n2;
    }

    public SVNWCDb getDb() {
        return this.db;
    }

    public File getAbsPath() {
        return this.absPath;
    }

    public SVNSqlJetDb getSDb() {
        return this.sDb;
    }

    public long getWcId() {
        return this.wcId;
    }

    public int getFormat() {
        return this.format;
    }

    public List getOwnedLocks() {
        return this.ownedLocks;
    }

    public void close() {
        assert (this.sDb != null);
        try {
            this.sDb.close();
        }
        finally {
            this.sDb = null;
        }
    }

    public File getAbsPath(File file) {
        return SVNFileUtil.createFilePath(this.getAbsPath(), file);
    }

    public void ensureNoUnfinishedTransactions() {
        if (this.sDb != null && this.sDb.getOpenCount() != 0) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, "There are unfinished transactions detected in ''{0}''", (Object)this.absPath);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
    }

    public File computeRelPath(File file) {
        String string = SVNPathUtil.getRelativePath(this.getAbsPath().getPath(), file.getPath());
        return SVNFileUtil.createFilePath(string);
    }
}

