/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb$Mode;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;

public class SVNWCDbDir {
    private File localAbsPath;
    private SVNWCDbRoot wcRoot;
    private SVNWCDbDir parent;
    private SVNWCAccess admAccess;

    public SVNWCDbDir(File file) {
        this.localAbsPath = file;
    }

    public File getLocalAbsPath() {
        return this.localAbsPath;
    }

    public SVNWCDbRoot getWCRoot() {
        return this.wcRoot;
    }

    public SVNWCDbDir getParent() {
        return this.parent;
    }

    public SVNWCAccess getAdmAccess() {
        return this.admAccess;
    }

    public void setLocalAbsPath(File file) {
        this.localAbsPath = file;
    }

    public void setWCRoot(SVNWCDbRoot sVNWCDbRoot) {
        this.wcRoot = sVNWCDbRoot;
    }

    public void setParent(SVNWCDbDir sVNWCDbDir) {
        this.parent = sVNWCDbDir;
    }

    public static boolean isUsable(SVNWCDbDir sVNWCDbDir) {
        return sVNWCDbDir != null && sVNWCDbDir.getWCRoot() != null && sVNWCDbDir.getWCRoot().getFormat() >= 29 && sVNWCDbDir.getWCRoot().getFormat() <= 31;
    }

    public File computeRelPath() {
        String string = SVNPathUtil.getRelativePath(this.wcRoot.getAbsPath().toString(), this.localAbsPath.toString());
        return SVNFileUtil.createFilePath(string);
    }

    public void flushEntries(File file) {
        SVNWCDbDir sVNWCDbDir;
        if (this.admAccess != null) {
            this.admAccess.close();
        }
        if (file != null && file.equals(this.localAbsPath) && !file.equals(this.wcRoot.getAbsPath()) && (sVNWCDbDir = this.wcRoot.getDb().navigateToParent(this, SVNSqlJetDb$Mode.ReadOnly)) != null && sVNWCDbDir.getAdmAccess() != null) {
            sVNWCDbDir.getAdmAccess().close();
        }
    }
}

