/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import java.util.Arrays;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils$UnserializedFileExternalInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNWCUtils {
    public static boolean isRecursiveDepth(SVNDepth sVNDepth) {
        return sVNDepth == SVNDepth.INFINITY || sVNDepth == SVNDepth.UNKNOWN;
    }

    public static File admChild(File file, String string) {
        return SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(file, SVNFileUtil.getAdminDirectoryName()), string);
    }

    public static void admCleanupTmpArea(SVNWCContext sVNWCContext, File file) {
        assert (SVNFileUtil.isAbsolute(file));
        sVNWCContext.writeCheck(file);
        File file2 = SVNWCUtils.admChild(file, "tmp");
        SVNFileUtil.deleteAll(file2, true);
        SVNWCUtils.admInitTmpArea(file);
    }

    public static void admInitTmpArea(File file) {
        SVNFileUtil.ensureDirectoryExists(SVNWCUtils.admChild(file, "tmp"));
    }

    public static SVNDate readDate(long l2) {
        long l3 = l2 / 1000L;
        return new SVNDate(l3, (int)(l2 - l3 * 1000L));
    }

    public static SVNProperties propDiffs(SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        byte[] byArray;
        Object object;
        SVNProperties sVNProperties3 = new SVNProperties();
        for (String string : sVNProperties2.nameSet()) {
            SVNPropertyValue sVNPropertyValue;
            object = SVNPropertyValue.getPropertyAsBytes(sVNProperties2.getSVNPropertyValue(string));
            byArray = SVNPropertyValue.getPropertyAsBytes(sVNProperties.getSVNPropertyValue(string));
            if (byArray == null) {
                sVNPropertyValue = SVNPropertyValue.create(null);
                sVNProperties3.put(string, sVNPropertyValue);
                continue;
            }
            if (Arrays.equals(object, byArray)) continue;
            sVNPropertyValue = SVNPropertyValue.create(string, byArray);
            sVNProperties3.put(string, sVNPropertyValue);
        }
        for (String string : sVNProperties.nameSet()) {
            object = sVNProperties.getSVNPropertyValue(string);
            if (null != sVNProperties2.getSVNPropertyValue(string)) continue;
            byArray = object;
            sVNProperties3.put(string, (SVNPropertyValue)byArray);
        }
        return sVNProperties3;
    }

    public static int relpathDepth(File file) {
        if (file == null) {
            return 0;
        }
        return SVNWCUtils.relpathDepth(file.getPath().replace(File.separatorChar, '/'));
    }

    public static int relpathDepth(String string) {
        if (string == null || "".equals(string)) {
            return 0;
        }
        int n2 = 1;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (string.charAt(i2) != '/') continue;
            ++n2;
        }
        return n2;
    }

    public static File relpathPrefix(File file, long l2) {
        return SVNFileUtil.createFilePath(SVNWCUtils.relpathPrefix(SVNFileUtil.getFilePath(file), l2));
    }

    public static String relpathPrefix(String string, long l2) {
        int n2;
        if (l2 <= 0L) {
            return "";
        }
        for (n2 = 0; n2 < string.length() && (string.charAt(n2) != '/' || --l2 != 0L); ++n2) {
        }
        return string.substring(0, n2);
    }

    public static SVNWCUtils$UnserializedFileExternalInfo unserializeFileExternal(String string) {
        SVNWCUtils$UnserializedFileExternalInfo sVNWCUtils$UnserializedFileExternalInfo = new SVNWCUtils$UnserializedFileExternalInfo();
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            sVNWCUtils$UnserializedFileExternalInfo.pegRevision = SVNAdminUtil.parseRevision(stringBuffer);
            sVNWCUtils$UnserializedFileExternalInfo.revision = SVNAdminUtil.parseRevision(stringBuffer);
            sVNWCUtils$UnserializedFileExternalInfo.path = stringBuffer.toString();
        }
        return sVNWCUtils$UnserializedFileExternalInfo;
    }

    public static String serializeFileExternal(String string, SVNRevision sVNRevision, SVNRevision sVNRevision2) {
        String string2 = null;
        if (string != null) {
            String string3 = SVNAdminUtil.asString(sVNRevision2, string);
            String string4 = SVNAdminUtil.asString(sVNRevision, string);
            string2 = string4 + ":" + string3 + ":" + string;
        }
        return string2;
    }

    public static String getPathAsChild(File file, File file2) {
        if (file == null || file2 == null) {
            return null;
        }
        if (file.equals(file2)) {
            return null;
        }
        String string = file.toString();
        String string2 = file2.toString();
        return SVNWCUtils.isChild(string, string2);
    }

    public static boolean isChild(File file, File file2) {
        return SVNWCUtils.isChild(SVNFileUtil.getFilePath(file), SVNFileUtil.getFilePath(file2)) != null;
    }

    public static String isChild(String string, String string2) {
        if (string2.equals(string)) {
            return "";
        }
        if ("".equals(string)) {
            return string2;
        }
        string2 = string2.replace(File.separatorChar, '/');
        string = string.replace(File.separatorChar, '/');
        return SVNPathUtil.getPathAsChild(string, string2);
    }

    public static boolean isAncestor(File file, File file2) {
        if (file == null || file2 == null) {
            return false;
        }
        if (file.equals(file2)) {
            return true;
        }
        String string = file.getPath().replace(File.separatorChar, '/');
        String string2 = file2.getPath().replace(File.separatorChar, '/');
        return SVNPathUtil.isAncestor(string, string2);
    }

    public static File skipAncestor(File file, File file2) {
        if (!SVNWCUtils.isAncestor(file, file2)) {
            return file2;
        }
        return SVNFileUtil.createFilePath(SVNWCUtils.getPathAsChild(file, file2));
    }

    public static String isChild(SVNURL sVNURL, SVNURL sVNURL2) {
        if (sVNURL == null || sVNURL2 == null) {
            return null;
        }
        if (sVNURL.equals(sVNURL2)) {
            return null;
        }
        String string = sVNURL.toDecodedString();
        String string2 = sVNURL2.toDecodedString();
        return SVNWCUtils.isChild(string, string2);
    }

    public static SVNURL join(SVNURL sVNURL, File file) {
        return sVNURL.appendPath(SVNFileUtil.getFilePath(file), false);
    }

    public static long parseLong(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Could not convert ''{0}'' into a number", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
            return 0L;
        }
    }
}

