/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.ISVNEditor2;
import org.tmatesoft.svn.core.internal.wc17.SVNTreeConflictEditor$UpdateWorkingProps;
import org.tmatesoft.svn.core.internal.wc17.SVNTreeConflictEditor$WorkingNodeVersion;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$MergeInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$MergePropertiesInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$TreeLocalModsInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb$BaseMovedTo;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts$ConflictInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts$TreeConflictInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbPristines;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema$NODES__Fields;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffEditor;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNTreeConflictEditor
implements ISVNEditor2 {
    private final SVNOperation operation;
    private final SVNConflictVersion oldVersion;
    private final SVNConflictVersion newVersion;
    private final SVNWCDb db;
    private final SVNWCDbRoot wcRoot;
    private final File moveRootDstRelPath;
    private ISVNEventHandler eventHandler;
    private File conflictRootRelPath;

    public SVNTreeConflictEditor(SVNWCDb sVNWCDb, SVNOperation sVNOperation, SVNConflictVersion sVNConflictVersion, SVNConflictVersion sVNConflictVersion2, SVNWCDbRoot sVNWCDbRoot, File file) {
        this.operation = sVNOperation;
        this.oldVersion = sVNConflictVersion;
        this.newVersion = sVNConflictVersion2;
        this.db = sVNWCDb;
        this.wcRoot = sVNWCDbRoot;
        this.moveRootDstRelPath = file;
    }

    @Override
    public void addDir(String string, List list, SVNProperties sVNProperties, long l2) {
        SVNNodeKind sVNNodeKind;
        File file;
        int n2 = SVNWCUtils.relpathDepth(this.moveRootDstRelPath);
        File file2 = SVNFileUtil.createFilePath(string);
        this.db.extendParentDelete(this.wcRoot.getSDb(), this.wcRoot.getWcId(), file2, SVNNodeKind.DIR, n2);
        try {
            Structure structure = SvnWcDbShared.getDepthInfo(this.wcRoot, file2, SVNWCUtils.relpathDepth(this.moveRootDstRelPath), new StructureFields$NodeInfo[0]);
            ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind = (ISVNWCDb$SVNWCDbKind)((Object)structure.get(StructureFields$NodeInfo.kind));
            file = (File)structure.get(StructureFields$NodeInfo.reposRelPath);
            sVNNodeKind = iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE;
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                sVNNodeKind = SVNNodeKind.NONE;
                file = null;
            }
            throw sVNException;
        }
        boolean bl2 = this.checkTreeConflict(file2, sVNNodeKind, SVNNodeKind.DIR, file, SVNConflictAction.ADD);
        if (bl2) {
            return;
        }
        SVNEventAction sVNEventAction = SVNEventAction.ADD;
        File file3 = SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), file2);
        sVNNodeKind = SVNFileType.getNodeKind(SVNFileType.getType(file3));
        if (sVNNodeKind == SVNNodeKind.FILE) {
            this.markTreeConflict(file2, this.oldVersion, this.newVersion, this.moveRootDstRelPath, this.operation, sVNNodeKind, SVNNodeKind.DIR, file, SVNConflictReason.UNVERSIONED, SVNConflictAction.ADD, null);
            this.conflictRootRelPath = file2;
            sVNEventAction = SVNEventAction.TREE_CONFLICT;
            bl2 = true;
        } else if (sVNNodeKind == SVNNodeKind.NONE) {
            SVNSkel sVNSkel = SVNWCContext.wqBuildDirInstall(this.db, file3);
            this.db.wqAdd(this.wcRoot.getAbsPath(), sVNSkel);
        } else if (sVNNodeKind == SVNNodeKind.DIR) {
            // empty if block
        }
        if (!bl2) {
            SVNWCDb.updateMoveListAdd(this.wcRoot, file2, sVNEventAction, SVNNodeKind.DIR, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE);
        }
    }

    @Override
    public void addFile(String string, SvnChecksum svnChecksum, InputStream inputStream, SVNProperties sVNProperties, long l2) {
        SVNNodeKind sVNNodeKind;
        Object object;
        File file = SVNFileUtil.createFilePath(string);
        int n2 = SVNWCUtils.relpathDepth(this.moveRootDstRelPath);
        this.db.extendParentDelete(this.wcRoot.getSDb(), this.wcRoot.getWcId(), file, SVNNodeKind.FILE, n2);
        File file2 = null;
        try {
            Structure structure = SvnWcDbShared.getDepthInfo(this.wcRoot, file, SVNWCUtils.relpathDepth(this.moveRootDstRelPath), new StructureFields$NodeInfo[0]);
            object = (ISVNWCDb$SVNWCDbKind)((Object)structure.get(StructureFields$NodeInfo.kind));
            file2 = (File)structure.get(StructureFields$NodeInfo.reposRelPath);
            sVNNodeKind = object == ISVNWCDb$SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE;
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                sVNNodeKind = SVNNodeKind.NONE;
                file2 = null;
            }
            throw sVNException;
        }
        boolean bl2 = this.checkTreeConflict(file, sVNNodeKind, SVNNodeKind.FILE, file2, SVNConflictAction.ADD);
        if (bl2) {
            return;
        }
        object = SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), file);
        sVNNodeKind = SVNFileType.getNodeKind(SVNFileType.getType((File)object));
        if (sVNNodeKind != SVNNodeKind.NONE) {
            this.markTreeConflict(file, this.oldVersion, this.newVersion, this.moveRootDstRelPath, this.operation, sVNNodeKind, SVNNodeKind.FILE, file2, SVNConflictReason.UNVERSIONED, SVNConflictAction.ADD, null);
            this.conflictRootRelPath = file;
        }
        SVNSkel sVNSkel = SVNWCContext.wqBuildFileInstall(this.db, SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), file), null, false, true);
        this.db.wqAdd(this.wcRoot.getAbsPath(), sVNSkel);
        SVNWCDb.updateMoveListAdd(this.wcRoot, file, SVNEventAction.UPDATE_ADD, SVNNodeKind.FILE, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE);
    }

    @Override
    public void addSymlink(String string, String string2, SVNProperties sVNProperties, long l2) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
    }

    @Override
    public void addAbsent(String string, SVNNodeKind sVNNodeKind, long l2) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
    }

    @Override
    public void alterDir(String string, long l2, List list, SVNProperties sVNProperties) {
        assert (l2 == this.oldVersion.getPegRevision());
        File file = SVNFileUtil.createFilePath(string);
        SVNTreeConflictEditor$WorkingNodeVersion sVNTreeConflictEditor$WorkingNodeVersion = new SVNTreeConflictEditor$WorkingNodeVersion(null);
        SVNTreeConflictEditor$WorkingNodeVersion sVNTreeConflictEditor$WorkingNodeVersion2 = new SVNTreeConflictEditor$WorkingNodeVersion(null);
        Structure structure = SvnWcDbShared.getDepthInfo(this.wcRoot, file, SVNWCUtils.relpathDepth(this.moveRootDstRelPath), new StructureFields$NodeInfo[0]);
        ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus = (ISVNWCDb$SVNWCDbStatus)((Object)structure.get(StructureFields$NodeInfo.status));
        ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind = (ISVNWCDb$SVNWCDbKind)((Object)structure.get(StructureFields$NodeInfo.kind));
        File file2 = (File)structure.get(StructureFields$NodeInfo.reposRelPath);
        long l3 = structure.lng(StructureFields$NodeInfo.revision);
        sVNTreeConflictEditor$WorkingNodeVersion.checksum = (SvnChecksum)structure.get(StructureFields$NodeInfo.checksum);
        sVNTreeConflictEditor$WorkingNodeVersion.props = (SVNProperties)structure.get(StructureFields$NodeInfo.propsMod);
        if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Deleted && file2 != null) {
            iSVNWCDb$SVNWCDbStatus = ISVNWCDb$SVNWCDbStatus.NotPresent;
        }
        assert (l3 == l2 || iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.NotPresent);
        assert (iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.Dir);
        boolean bl2 = this.checkTreeConflict(file, iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNNodeKind.DIR, file2, SVNConflictAction.EDIT);
        if (bl2) {
            return;
        }
        sVNTreeConflictEditor$WorkingNodeVersion.locationAndKind = this.oldVersion;
        sVNTreeConflictEditor$WorkingNodeVersion2.locationAndKind = this.newVersion;
        sVNTreeConflictEditor$WorkingNodeVersion2.checksum = null;
        SVNProperties sVNProperties2 = sVNTreeConflictEditor$WorkingNodeVersion2.props = sVNProperties != null ? sVNProperties : sVNTreeConflictEditor$WorkingNodeVersion.props;
        if (sVNProperties != null) {
            File file3 = SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), file);
            SVNTreeConflictEditor$UpdateWorkingProps sVNTreeConflictEditor$UpdateWorkingProps = this.updateWorkingProps(null, file3, sVNTreeConflictEditor$WorkingNodeVersion, sVNTreeConflictEditor$WorkingNodeVersion2);
            SVNSkel sVNSkel = sVNTreeConflictEditor$UpdateWorkingProps.conflictSkel;
            SVNProperties sVNProperties3 = sVNTreeConflictEditor$UpdateWorkingProps.propChanges;
            SVNProperties sVNProperties4 = sVNTreeConflictEditor$UpdateWorkingProps.actualProps;
            SVNStatusType sVNStatusType = sVNTreeConflictEditor$UpdateWorkingProps.propState;
            if (sVNSkel != null) {
                SVNSkel sVNSkel2 = this.createConflictMarkers(file3, file2, sVNSkel, this.operation, sVNTreeConflictEditor$WorkingNodeVersion, sVNTreeConflictEditor$WorkingNodeVersion2, SVNNodeKind.DIR);
                this.db.markConflictInternal(this.wcRoot, file, sVNSkel);
                this.db.wqAdd(this.wcRoot.getAbsPath(), sVNSkel2);
            }
            SVNWCDb.updateMoveListAdd(this.wcRoot, file, SVNEventAction.UPDATE_UPDATE, SVNNodeKind.DIR, SVNStatusType.INAPPLICABLE, sVNStatusType);
        }
    }

    @Override
    public void alterFile(String string, long l2, SVNProperties sVNProperties, SvnChecksum svnChecksum, InputStream inputStream) {
        SVNTreeConflictEditor$WorkingNodeVersion sVNTreeConflictEditor$WorkingNodeVersion = new SVNTreeConflictEditor$WorkingNodeVersion(null);
        SVNTreeConflictEditor$WorkingNodeVersion sVNTreeConflictEditor$WorkingNodeVersion2 = new SVNTreeConflictEditor$WorkingNodeVersion(null);
        File file = SVNFileUtil.createFilePath(string);
        Structure structure = SvnWcDbShared.getDepthInfo(this.wcRoot, file, SVNWCUtils.relpathDepth(this.moveRootDstRelPath), StructureFields$NodeInfo.status, StructureFields$NodeInfo.kind, StructureFields$NodeInfo.revision, StructureFields$NodeInfo.reposRelPath, StructureFields$NodeInfo.checksum, StructureFields$NodeInfo.propsMod);
        ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus = (ISVNWCDb$SVNWCDbStatus)((Object)structure.get(StructureFields$NodeInfo.status));
        ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind = (ISVNWCDb$SVNWCDbKind)((Object)structure.get(StructureFields$NodeInfo.kind));
        long l3 = structure.lng(StructureFields$NodeInfo.revision);
        File file2 = (File)structure.get(StructureFields$NodeInfo.reposRelPath);
        sVNTreeConflictEditor$WorkingNodeVersion.checksum = (SvnChecksum)structure.get(StructureFields$NodeInfo.checksum);
        sVNTreeConflictEditor$WorkingNodeVersion.props = (SVNProperties)structure.get(StructureFields$NodeInfo.propsMod);
        if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Deleted && file2 != null) {
            iSVNWCDb$SVNWCDbStatus = ISVNWCDb$SVNWCDbStatus.NotPresent;
        }
        assert (l3 == l2 || iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.NotPresent);
        assert (iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.File);
        boolean bl2 = this.checkTreeConflict(file, iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNNodeKind.FILE, file2, SVNConflictAction.EDIT);
        if (bl2) {
            return;
        }
        sVNTreeConflictEditor$WorkingNodeVersion.locationAndKind = this.oldVersion;
        sVNTreeConflictEditor$WorkingNodeVersion2.locationAndKind = this.newVersion;
        sVNTreeConflictEditor$WorkingNodeVersion2.checksum = svnChecksum != null ? svnChecksum : sVNTreeConflictEditor$WorkingNodeVersion.checksum;
        SVNProperties sVNProperties2 = sVNTreeConflictEditor$WorkingNodeVersion2.props = sVNProperties != null ? sVNProperties : sVNTreeConflictEditor$WorkingNodeVersion.props;
        if (!SvnChecksum.match(svnChecksum, sVNTreeConflictEditor$WorkingNodeVersion.checksum) || sVNProperties != null) {
            this.updateWorkingFile(file, file2, this.operation, sVNTreeConflictEditor$WorkingNodeVersion, sVNTreeConflictEditor$WorkingNodeVersion2);
        }
    }

    @Override
    public void alterSymlink(String string, long l2, SVNProperties sVNProperties, String string2) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void delete(String string, long l2) {
        int n2;
        Object object;
        boolean bl2;
        Object object2;
        Object object3;
        File file;
        File file2 = SVNFileUtil.createFilePath(string);
        int n3 = SVNWCUtils.relpathDepth(this.moveRootDstRelPath);
        boolean bl3 = false;
        File file3 = SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), file2);
        File file4 = SVNFileUtil.getFileDir(file2);
        Structure structure = SvnWcDbShared.getDepthInfo(this.wcRoot, file2, SVNWCUtils.relpathDepth(this.moveRootDstRelPath), StructureFields$NodeInfo.kind, StructureFields$NodeInfo.reposRelPath);
        ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind = (ISVNWCDb$SVNWCDbKind)((Object)structure.get(StructureFields$NodeInfo.kind));
        boolean bl4 = this.checkTreeConflict(file2, iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNNodeKind.UNKNOWN, file = (File)structure.get(StructureFields$NodeInfo.reposRelPath), SVNConflictAction.DELETE);
        if (!bl4) {
            object3 = new SVNWCContext(this.db, this.eventHandler);
            object2 = object3.hasLocalMods(file3, file3);
            boolean n22 = ((SVNWCContext$TreeLocalModsInfo)object2).modificationsFound;
            boolean bl5 = bl2 = !((SVNWCContext$TreeLocalModsInfo)object2).nonDeleteModificationsFound;
            if (n22) {
                SVNSqlJetStatement sVNSqlJetStatement;
                if (!bl2) {
                    sVNSqlJetStatement = this.wcRoot.getSDb().getStatement(SVNWCDbStatements.UPDATE_OP_DEPTH_RECURSIVE);
                    try {
                        sVNSqlJetStatement.bindf("isii", this.wcRoot.getWcId(), file2, n3, SVNWCUtils.relpathDepth(file2));
                        sVNSqlJetStatement.done();
                    }
                    finally {
                        sVNSqlJetStatement.reset();
                    }
                    object = SVNConflictReason.EDITED;
                } else {
                    sVNSqlJetStatement = this.wcRoot.getSDb().getStatement(SVNWCDbStatements.DELETE_WORKING_OP_DEPTH_ABOVE);
                    try {
                        sVNSqlJetStatement.bindf("isi", this.wcRoot.getWcId(), file2, n3);
                        sVNSqlJetStatement.done();
                    }
                    finally {
                        sVNSqlJetStatement.reset();
                    }
                    object = SVNConflictReason.DELETED;
                    bl3 = true;
                }
                bl4 = true;
                this.markTreeConflict(file2, this.oldVersion, this.newVersion, this.moveRootDstRelPath, this.operation, iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNNodeKind.NONE, file, (SVNConflictReason)object, SVNConflictAction.DELETE, null);
                this.conflictRootRelPath = file2;
            }
        }
        if (!bl4 || bl3) {
            void var15_19;
            object2 = this.wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_CHILDREN_OP_DEPTH);
            try {
                boolean bl6;
                ((SVNSqlJetStatement)object2).bindf("isi", this.wcRoot.getWcId(), file2, n3);
                boolean sVNSkel = ((SVNSqlJetStatement)object2).next();
                while (bl6) {
                    object3 = SvnWcDbStatementUtil.getColumnKind((SVNSqlJetStatement)object2, SVNWCDbSchema$NODES__Fields.kind);
                    File file5 = SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), ((SVNSqlJetStatement)object2).getColumnString(SVNWCDbSchema$NODES__Fields.local_relpath));
                    object = object3 == ISVNWCDb$SVNWCDbKind.Dir ? SVNWCContext.wqBuildDirRemove(this.db, this.wcRoot.getAbsPath(), file5, false) : SVNWCContext.wqBuildFileRemove(this.db, this.wcRoot.getAbsPath(), file5);
                    this.db.wqAdd(this.wcRoot.getAbsPath(), (SVNSkel)object);
                    bl6 = ((SVNSqlJetStatement)object2).next();
                }
            }
            finally {
                ((SVNSqlJetStatement)object2).reset();
            }
            structure = SvnWcDbShared.getDepthInfo(this.wcRoot, file2, n3, StructureFields$NodeInfo.kind);
            object3 = (ISVNWCDb$SVNWCDbKind)((Object)structure.get(StructureFields$NodeInfo.kind));
            if (object3 == ISVNWCDb$SVNWCDbKind.Dir) {
                SVNSkel sVNSkel = SVNWCContext.wqBuildDirRemove(this.db, this.wcRoot.getAbsPath(), file3, false);
            } else {
                SVNSkel sVNSkel = SVNWCContext.wqBuildFileRemove(this.db, this.wcRoot.getAbsPath(), file3);
            }
            this.db.wqAdd(this.wcRoot.getAbsPath(), (SVNSkel)var15_19);
            if (!bl4) {
                SVNWCDb.updateMoveListAdd(this.wcRoot, file2, SVNEventAction.UPDATE_DELETE, object3 == ISVNWCDb$SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE);
            }
        }
        boolean bl7 = false;
        object2 = this.wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_HIGHEST_WORKING_NODE);
        try {
            ((SVNSqlJetStatement)object2).bindf("isi", this.wcRoot.getWcId(), file4, n3);
            bl2 = ((SVNSqlJetStatement)object2).next();
            if (bl2) {
                n2 = (int)((SVNSqlJetStatement)object2).getColumnLong(SVNWCDbSchema$NODES__Fields.op_depth);
            }
        }
        finally {
            ((SVNSqlJetStatement)object2).reset();
        }
        if (bl2) {
            object2 = this.wcRoot.getSDb().getStatement(SVNWCDbStatements.DELETE_NO_LOWER_LAYER);
            try {
                ((SVNSqlJetStatement)object2).bindf("isii", this.wcRoot.getWcId(), file4, n3, n2);
                ((SVNSqlJetStatement)object2).done();
            }
            finally {
                ((SVNSqlJetStatement)object2).reset();
            }
            object2 = this.wcRoot.getSDb().getStatement(SVNWCDbStatements.REPLACE_WITH_BASE_DELETED);
            try {
                ((SVNSqlJetStatement)object2).bindf("isi", this.wcRoot.getWcId(), file2, n3);
            }
            finally {
                ((SVNSqlJetStatement)object2).reset();
            }
        }
        object2 = this.wcRoot.getSDb().getStatement(SVNWCDbStatements.DELETE_WORKING_OP_DEPTH);
        try {
            ((SVNSqlJetStatement)object2).bindf("isi", this.wcRoot.getWcId(), file2, n3);
            ((SVNSqlJetStatement)object2).done();
        }
        finally {
            ((SVNSqlJetStatement)object2).reset();
        }
        this.db.retractParentDelete(this.wcRoot.getSDb(), this.wcRoot.getWcId(), file2, n3);
    }

    @Override
    public void copy(String string, long l2, String string2, long l3) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
    }

    @Override
    public void move(String string, long l2, String string2, long l3) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
    }

    @Override
    public void rotate(List list, List list2) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
    }

    @Override
    public void complete() {
    }

    @Override
    public void abort() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkTreeConflict(File file, SVNNodeKind sVNNodeKind, SVNNodeKind sVNNodeKind2, File file2, SVNConflictAction sVNConflictAction) {
        boolean bl2;
        int n2 = SVNWCUtils.relpathDepth(this.moveRootDstRelPath);
        int n3 = 0;
        if (this.conflictRootRelPath != null) {
            if (SVNPathUtil.isAncestor(SVNFileUtil.getFilePath(this.conflictRootRelPath), SVNFileUtil.getFilePath(file))) {
                return true;
            }
            this.conflictRootRelPath = null;
        }
        SVNSqlJetStatement sVNSqlJetStatement = this.wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_LOWEST_WORKING_NODE);
        try {
            sVNSqlJetStatement.bindf("isi", this.wcRoot.getWcId(), file, n2);
            bl2 = sVNSqlJetStatement.next();
            if (bl2) {
                n3 = (int)sVNSqlJetStatement.getColumnLong(SVNWCDbSchema$NODES__Fields.op_depth);
            }
        }
        finally {
            sVNSqlJetStatement.reset();
        }
        if (!bl2) {
            return false;
        }
        boolean bl3 = true;
        File file3 = file;
        while (SVNWCUtils.relpathDepth(file3) > n3) {
            file3 = SVNFileUtil.getFileDir(file3);
            sVNNodeKind = sVNNodeKind2 = SVNNodeKind.DIR;
            if (file2 != null) {
                file2 = SVNFileUtil.getFileDir(file2);
            }
            sVNConflictAction = SVNConflictAction.EDIT;
        }
        SVNWCDb$BaseMovedTo sVNWCDb$BaseMovedTo = this.db.opDepthMovedTo(n2, this.wcRoot, file3);
        File file4 = sVNWCDb$BaseMovedTo.moveDstRelPath;
        File file5 = sVNWCDb$BaseMovedTo.moveSrcOpRootRelPath;
        this.markTreeConflict(file3, this.oldVersion, this.newVersion, this.moveRootDstRelPath, this.operation, sVNNodeKind, sVNNodeKind2, file2, file4 != null ? SVNConflictReason.MOVED_AWAY : SVNConflictReason.DELETED, sVNConflictAction, file5);
        this.conflictRootRelPath = file3;
        return bl3;
    }

    private SVNTreeConflictEditor$UpdateWorkingProps updateWorkingProps(SVNSkel sVNSkel, File file, SVNTreeConflictEditor$WorkingNodeVersion sVNTreeConflictEditor$WorkingNodeVersion, SVNTreeConflictEditor$WorkingNodeVersion sVNTreeConflictEditor$WorkingNodeVersion2) {
        SVNTreeConflictEditor$UpdateWorkingProps sVNTreeConflictEditor$UpdateWorkingProps = new SVNTreeConflictEditor$UpdateWorkingProps(null);
        if (sVNTreeConflictEditor$WorkingNodeVersion.props == null) {
            sVNTreeConflictEditor$WorkingNodeVersion.props = new SVNProperties();
        }
        if (sVNTreeConflictEditor$WorkingNodeVersion2.props == null) {
            sVNTreeConflictEditor$WorkingNodeVersion2.props = new SVNProperties();
        }
        sVNTreeConflictEditor$UpdateWorkingProps.actualProps = this.db.readProperties(file);
        sVNTreeConflictEditor$UpdateWorkingProps.propChanges = SvnDiffEditor.computePropDiff(sVNTreeConflictEditor$WorkingNodeVersion.props, sVNTreeConflictEditor$WorkingNodeVersion2.props);
        SVNWCContext sVNWCContext = new SVNWCContext(this.db, this.eventHandler);
        SVNWCContext$MergePropertiesInfo sVNWCContext$MergePropertiesInfo = new SVNWCContext$MergePropertiesInfo();
        sVNWCContext$MergePropertiesInfo.conflictSkel = sVNSkel;
        sVNWCContext$MergePropertiesInfo = sVNWCContext.mergeProperties3(sVNWCContext$MergePropertiesInfo, file, sVNTreeConflictEditor$WorkingNodeVersion.props, sVNTreeConflictEditor$WorkingNodeVersion.props, sVNTreeConflictEditor$UpdateWorkingProps.actualProps, sVNTreeConflictEditor$UpdateWorkingProps.propChanges);
        sVNTreeConflictEditor$UpdateWorkingProps.conflictSkel = sVNWCContext$MergePropertiesInfo.conflictSkel;
        SVNProperties sVNProperties = sVNWCContext$MergePropertiesInfo.newActualProperties;
        sVNTreeConflictEditor$UpdateWorkingProps.propState = sVNWCContext$MergePropertiesInfo.mergeOutcome;
        SVNProperties sVNProperties2 = SvnDiffEditor.computePropDiff(sVNTreeConflictEditor$WorkingNodeVersion2.props, sVNProperties);
        if (sVNProperties2.size() > 0) {
            sVNProperties = null;
        }
        this.db.opSetProps(file, sVNProperties, null, SVNWCContext.hasMagicProperty(sVNTreeConflictEditor$UpdateWorkingProps.propChanges), null);
        return sVNTreeConflictEditor$UpdateWorkingProps;
    }

    private SVNSkel createConflictMarkers(File file, File file2, SVNSkel sVNSkel, SVNOperation sVNOperation, SVNTreeConflictEditor$WorkingNodeVersion sVNTreeConflictEditor$WorkingNodeVersion, SVNTreeConflictEditor$WorkingNodeVersion sVNTreeConflictEditor$WorkingNodeVersion2, SVNNodeKind sVNNodeKind) {
        File file3 = SVNFileUtil.skipAncestor(SVNFileUtil.createFilePath(this.oldVersion.getPath()), file2);
        SVNConflictVersion sVNConflictVersion = new SVNConflictVersion(sVNTreeConflictEditor$WorkingNodeVersion.locationAndKind.getRepositoryRoot(), SVNFileUtil.getFilePath(file2), sVNTreeConflictEditor$WorkingNodeVersion.locationAndKind.getPegRevision(), sVNNodeKind);
        SVNConflictVersion sVNConflictVersion2 = new SVNConflictVersion(sVNTreeConflictEditor$WorkingNodeVersion2.locationAndKind.getRepositoryRoot(), SVNPathUtil.append(sVNTreeConflictEditor$WorkingNodeVersion.locationAndKind.getPath(), SVNFileUtil.getFilePath(file3)), sVNTreeConflictEditor$WorkingNodeVersion2.locationAndKind.getPegRevision(), sVNNodeKind);
        if (sVNOperation == SVNOperation.UPDATE) {
            SvnWcDbConflicts.conflictSkelOpUpdate(sVNSkel, sVNConflictVersion, sVNConflictVersion2);
        } else {
            SvnWcDbConflicts.conflictSkelOpSwitch(sVNSkel, sVNConflictVersion, sVNConflictVersion2);
        }
        SVNWCContext sVNWCContext = new SVNWCContext(this.db, this.eventHandler);
        return sVNWCContext.conflictCreateMarker(sVNSkel, file);
    }

    private void updateWorkingFile(File file, File file2, SVNOperation sVNOperation, SVNTreeConflictEditor$WorkingNodeVersion sVNTreeConflictEditor$WorkingNodeVersion, SVNTreeConflictEditor$WorkingNodeVersion sVNTreeConflictEditor$WorkingNodeVersion2) {
        SVNStatusType sVNStatusType;
        Object object;
        SVNSkel sVNSkel = null;
        File file3 = SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), file);
        SVNTreeConflictEditor$UpdateWorkingProps sVNTreeConflictEditor$UpdateWorkingProps = this.updateWorkingProps(null, file3, sVNTreeConflictEditor$WorkingNodeVersion, sVNTreeConflictEditor$WorkingNodeVersion2);
        SVNSkel sVNSkel2 = sVNTreeConflictEditor$UpdateWorkingProps.conflictSkel;
        SVNStatusType sVNStatusType2 = sVNTreeConflictEditor$UpdateWorkingProps.propState;
        SVNProperties sVNProperties = sVNTreeConflictEditor$UpdateWorkingProps.propChanges;
        SVNProperties sVNProperties2 = sVNTreeConflictEditor$UpdateWorkingProps.actualProps;
        if (!SvnChecksum.match(sVNTreeConflictEditor$WorkingNodeVersion2.checksum, sVNTreeConflictEditor$WorkingNodeVersion.checksum)) {
            object = new SVNWCContext(this.db, this.eventHandler);
            boolean bl2 = ((SVNWCContext)object).isTextModified(file3, false);
            if (!bl2) {
                SVNSkel sVNSkel3 = ((SVNWCContext)object).wqBuildFileInstall(file3, null, false, true);
                sVNSkel = SVNWCContext.wqMerge(sVNSkel, sVNSkel3);
                sVNStatusType = SVNStatusType.CHANGED;
            } else {
                File file4 = SvnWcDbPristines.getPristinePath(this.wcRoot, sVNTreeConflictEditor$WorkingNodeVersion.checksum);
                File file5 = SvnWcDbPristines.getPristinePath(this.wcRoot, sVNTreeConflictEditor$WorkingNodeVersion2.checksum);
                SVNWCContext$MergeInfo sVNWCContext$MergeInfo = ((SVNWCContext)object).merge(sVNSkel, sVNSkel2, file4, file5, file3, file3, null, null, null, sVNProperties2, false, null, sVNProperties);
                sVNSkel2 = sVNWCContext$MergeInfo.conflictSkel;
                SVNSkel sVNSkel4 = sVNWCContext$MergeInfo.workItems;
                SVNStatusType sVNStatusType3 = sVNWCContext$MergeInfo.mergeOutcome;
                sVNSkel = SVNWCContext.wqMerge(sVNSkel, sVNSkel4);
                sVNStatusType = sVNStatusType3 == SVNStatusType.CONFLICTED ? SVNStatusType.CONFLICTED : SVNStatusType.MERGED;
            }
        } else {
            sVNStatusType = SVNStatusType.UNCHANGED;
        }
        if (sVNSkel2 != null) {
            object = this.createConflictMarkers(file3, file2, sVNSkel2, sVNOperation, sVNTreeConflictEditor$WorkingNodeVersion, sVNTreeConflictEditor$WorkingNodeVersion2, SVNNodeKind.FILE);
            this.db.markConflictInternal(this.wcRoot, file, sVNSkel2);
            sVNSkel = SVNWCContext.wqMerge(sVNSkel, (SVNSkel)object);
        }
        this.db.wqAdd(this.wcRoot.getAbsPath(), sVNSkel);
        SVNWCDb.updateMoveListAdd(this.wcRoot, file, SVNEventAction.UPDATE_UPDATE, SVNNodeKind.FILE, sVNStatusType, sVNStatusType2);
    }

    private void markTreeConflict(File file, SVNConflictVersion sVNConflictVersion, SVNConflictVersion sVNConflictVersion2, File file2, SVNOperation sVNOperation, SVNNodeKind sVNNodeKind, SVNNodeKind sVNNodeKind2, File file3, SVNConflictReason sVNConflictReason, SVNConflictAction sVNConflictAction, File file4) {
        Object object;
        Object object2;
        SVNSkel sVNSkel;
        File file5;
        File file6 = file4 != null ? SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), file4) : null;
        File file7 = file3 != null ? SVNFileUtil.skipAncestor(SVNFileUtil.createFilePath(sVNConflictVersion.getPath()), file3) : null;
        File file8 = file5 = file7 != null ? SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(sVNConflictVersion2.getPath()), file7) : null;
        if (file5 == null) {
            file5 = SVNFileUtil.createFilePath(sVNConflictVersion2.getPath(), SVNFileUtil.getFilePath(SVNFileUtil.skipAncestor(file2, file)));
        }
        try {
            sVNSkel = this.db.readConflictInternal(this.wcRoot, file);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                sVNSkel = null;
            }
            throw sVNException;
        }
        if (sVNSkel != null) {
            Object object3;
            object2 = SvnWcDbConflicts.readConflictInfo(sVNSkel);
            object = (SVNOperation)((Structure)object2).get(SvnWcDbConflicts$ConflictInfo.conflictOperation);
            boolean bl2 = ((Structure)object2).is(SvnWcDbConflicts$ConflictInfo.treeConflicted);
            if (object != SVNOperation.UPDATE && object != SVNOperation.SWITCH) {
                object3 = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "'{0}' already in conflict", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
            }
            if (bl2) {
                object3 = SvnWcDbConflicts.readTreeConflict(this.db, this.wcRoot.getAbsPath(), sVNSkel);
                SVNConflictReason sVNConflictReason2 = (SVNConflictReason)((Structure)object3).get(SvnWcDbConflicts$TreeConflictInfo.localChange);
                SVNConflictAction sVNConflictAction2 = (SVNConflictAction)((Structure)object3).get(SvnWcDbConflicts$TreeConflictInfo.incomingChange);
                File file9 = (File)((Structure)object3).get(SvnWcDbConflicts$TreeConflictInfo.moveSrcOpRootAbsPath);
                if (sVNConflictReason != sVNConflictReason2 || sVNConflictAction != sVNConflictAction2 || sVNConflictReason == SVNConflictReason.MOVED_AWAY && !file4.equals(SVNFileUtil.skipAncestor(this.wcRoot.getAbsPath(), file9))) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "'{0}' already in conflict", (Object)file);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
                return;
            }
        } else {
            sVNSkel = SvnWcDbConflicts.createConflictSkel();
        }
        SvnWcDbConflicts.addTreeConflict(sVNSkel, this.db, SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), file), sVNConflictReason, sVNConflictAction, file6);
        object2 = sVNConflictReason != SVNConflictReason.UNVERSIONED && file3 != null ? new SVNConflictVersion(sVNConflictVersion.getRepositoryRoot(), SVNFileUtil.getFilePath(file3), sVNConflictVersion.getPegRevision(), sVNNodeKind) : null;
        object = new SVNConflictVersion(sVNConflictVersion2.getRepositoryRoot(), SVNFileUtil.getFilePath(file5), sVNConflictVersion2.getPegRevision(), sVNNodeKind2);
        if (sVNOperation == SVNOperation.UPDATE) {
            SvnWcDbConflicts.conflictSkelOpUpdate(sVNSkel, (SVNConflictVersion)object2, (SVNConflictVersion)object);
        } else {
            assert (sVNOperation == SVNOperation.SWITCH);
            SvnWcDbConflicts.conflictSkelOpSwitch(sVNSkel, (SVNConflictVersion)object2, (SVNConflictVersion)object);
        }
        this.db.markConflictInternal(this.wcRoot, file, sVNSkel);
        SVNWCDb.updateMoveListAdd(this.wcRoot, file, SVNEventAction.TREE_CONFLICT, sVNNodeKind2, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE);
    }
}

