/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.util.HashMap;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNReporter17;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SVNStatusReporter17
implements ISVNReporter,
ISVNReporterBaton {
    private SVNRepository repository;
    private SVNReporter17 reportBaton;
    private SVNStatusEditor17 editor;
    private SVNURL repositoryLocation;
    private HashMap locks;
    private ISVNReporter reporter;
    private SVNURL repositoryRoot;

    public SVNStatusReporter17(SVNRepository sVNRepository, SVNReporter17 sVNReporter17, SVNStatusEditor17 sVNStatusEditor17) {
        this.repository = sVNRepository;
        this.reportBaton = sVNReporter17;
        this.editor = sVNStatusEditor17;
        this.repositoryLocation = sVNRepository.getLocation();
        this.locks = new HashMap();
    }

    @Override
    public void report(ISVNReporter iSVNReporter) {
        this.reporter = iSVNReporter;
        this.reportBaton.report(this);
    }

    @Override
    public void setPath(String string, String string2, long l2, boolean bl2) {
        this.setPath(string, string2, l2, SVNDepth.INFINITY, bl2);
    }

    @Override
    public void setPath(String string, String string2, long l2, SVNDepth sVNDepth, boolean bl2) {
        this.reporter.setPath(string, string2, l2, sVNDepth, bl2);
    }

    @Override
    public void deletePath(String string) {
        this.reporter.deletePath(string);
    }

    @Override
    public void linkPath(SVNURL sVNURL, String string, String string2, long l2, boolean bl2) {
        this.setPath(string, string2, l2, SVNDepth.INFINITY, bl2);
    }

    @Override
    public void linkPath(SVNURL sVNURL, String string, String string2, long l2, SVNDepth sVNDepth, boolean bl2) {
        SVNURL sVNURL2 = SVNURLUtil.getCommonURLAncestor(sVNURL, this.repositoryLocation);
        if (SVNPathUtil.getPathAsChild(sVNURL2.getPath(), this.repositoryLocation.getPath()) != null) {
            this.repositoryLocation = sVNURL2;
        }
        this.reporter.linkPath(sVNURL, string, string2, l2, sVNDepth, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishReport() {
        SVNLock[] sVNLockArray = null;
        SVNURL sVNURL = this.repository.getLocation();
        try {
            this.repositoryRoot = this.repository.getRepositoryRoot(true);
            this.repository.setLocation(this.repositoryLocation, false);
            sVNLockArray = this.repository.getLocks("");
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage() == null || sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.RA_NOT_IMPLEMENTED) {
                throw sVNException;
            }
        }
        finally {
            this.repository.setLocation(sVNURL, false);
            this.repository.closeSession();
        }
        if (sVNLockArray != null) {
            for (int i2 = 0; i2 < sVNLockArray.length; ++i2) {
                SVNLock sVNLock = sVNLockArray[i2];
                this.locks.put(sVNLock.getPath(), sVNLock);
            }
        }
        this.editor.setRepositoryInfo(this.repositoryRoot, this.locks);
        this.reporter.finishReport();
    }

    @Override
    public void abortReport() {
        this.reporter.abortReport();
    }
}

