/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb$Mode;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17$DefaultSvnFileListHook;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$ConflictInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbAdditionInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbAdditionInfo$AdditionInfoField;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo$BaseInfoField;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbDeletionInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbDeletionInfo$DeletionInfoField;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbInfo$InfoField;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbRepositoryInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbRepositoryInfo$RepositoryInfoField;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb$DirParsedInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$InheritedProperties;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$MovedInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeOriginInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbProperties;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.hooks.ISvnFileListHook;

public class SVNStatusEditor17 {
    protected SVNWCContext myWCContext;
    protected File myPath;
    protected boolean myIsReportAll;
    protected boolean myIsNoIgnore;
    protected SVNDepth myDepth;
    protected ISvnObjectReceiver myStatusHandler;
    protected Map myExternalsMap;
    protected Collection myGlobalIgnores;
    protected SVNURL myRepositoryRoot;
    protected Map myRepositoryLocks;
    protected long myTargetRevision;
    protected String myWCRootPath;
    protected ISvnFileListHook myFileListHook;
    protected ISvnFileListHook myDefaultFileListHook;
    protected boolean myIsGetExcluded;
    private boolean myIgnoreTextMods;
    private SVNWCDbRoot wcRoot;

    public SVNStatusEditor17(File file, SVNWCContext sVNWCContext, ISVNOptions iSVNOptions, boolean bl2, boolean bl3, SVNDepth sVNDepth, ISvnObjectReceiver iSvnObjectReceiver) {
        this.myWCContext = sVNWCContext;
        this.myPath = file;
        this.myIsNoIgnore = bl2;
        this.myIsReportAll = bl3;
        this.myDepth = sVNDepth;
        this.myStatusHandler = iSvnObjectReceiver;
        this.myExternalsMap = new HashMap();
        this.myGlobalIgnores = SVNStatusEditor17.getGlobalIgnores(iSVNOptions);
        this.myTargetRevision = -1L;
        this.myFileListHook = this.myDefaultFileListHook = new SVNStatusEditor17$DefaultSvnFileListHook();
        this.myIsGetExcluded = false;
    }

    protected void collectExternals(File file) {
        this.myExternalsMap = this.myWCContext.getDb().getExternalsDefinedBelow(file);
    }

    public SVNCommitInfo closeEdit() {
        boolean bl2;
        String string;
        File file;
        SVNNodeKind sVNNodeKind = SVNFileType.getNodeKind(SVNFileType.getType(this.myPath));
        SVNNodeKind sVNNodeKind2 = this.myWCContext.readKind(this.myPath, false);
        if (sVNNodeKind2 == SVNNodeKind.FILE && sVNNodeKind == SVNNodeKind.FILE) {
            file = SVNFileUtil.getFileDir(this.myPath);
            string = SVNFileUtil.getFileName(this.myPath);
            bl2 = true;
        } else if (sVNNodeKind2 == SVNNodeKind.DIR && sVNNodeKind == SVNNodeKind.DIR) {
            file = this.myPath;
            string = null;
            bl2 = false;
        } else {
            file = SVNFileUtil.getFileDir(this.myPath);
            string = SVNFileUtil.getFileName(this.myPath);
            bl2 = false;
        }
        SVNFileType sVNFileType = SVNFileType.getType(file);
        this.getDirStatus(file, string, bl2, null, null, sVNFileType, this.myGlobalIgnores, this.myDepth, this.myIsReportAll, true, this.getDefaultHandler());
        return null;
    }

    public long getTargetRevision() {
        return this.myTargetRevision;
    }

    public void targetRevision(long l2) {
        this.myTargetRevision = l2;
    }

    public void setFileListHook(ISvnFileListHook iSvnFileListHook) {
        if (iSvnFileListHook != null) {
            this.myFileListHook = iSvnFileListHook;
        }
    }

    public SVNDepth getDepth() {
        return this.myDepth;
    }

    protected ISvnObjectReceiver getDefaultHandler() {
        return this.myStatusHandler;
    }

    protected boolean isReportAll() {
        return this.myIsReportAll;
    }

    protected boolean isNoIgnore() {
        return this.myIsNoIgnore;
    }

    public static Collection getGlobalIgnores(ISVNOptions iSVNOptions) {
        String[] stringArray;
        if (iSVNOptions != null && (stringArray = iSVNOptions.getIgnorePatterns()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                hashSet.add(stringArray[i2]);
            }
            return hashSet;
        }
        return Collections.emptySet();
    }

    private void sendStatusStructure(File file, ISVNWCDb$WCDbRepositoryInfo iSVNWCDb$WCDbRepositoryInfo, ISVNWCDb$SVNWCDbInfo iSVNWCDb$SVNWCDbInfo, SVNNodeKind sVNNodeKind, boolean bl2, boolean bl3, ISvnObjectReceiver iSvnObjectReceiver) {
        Object object;
        SVNLock sVNLock = null;
        if (this.myRepositoryLocks != null && (object = SVNStatusEditor17.getRepositoryRootUrlRelPath(this.myWCContext, iSVNWCDb$WCDbRepositoryInfo, iSVNWCDb$SVNWCDbInfo, file)) != null && ((ISVNWCDb$WCDbRepositoryInfo)object).relPath != null) {
            sVNLock = (SVNLock)this.myRepositoryLocks.get("/" + SVNFileUtil.getFilePath(((ISVNWCDb$WCDbRepositoryInfo)object).relPath));
        }
        object = SVNStatusEditor17.assembleStatus(this.myWCContext, file, iSVNWCDb$WCDbRepositoryInfo, iSVNWCDb$SVNWCDbInfo, sVNNodeKind, bl2, bl3, this.myIgnoreTextMods, sVNLock);
        if ((object = this.tweakStatus((SvnStatus)object)) != null && iSvnObjectReceiver != null) {
            iSvnObjectReceiver.receive(SvnTarget.fromFile(file), object);
        }
    }

    private SvnStatus tweakStatus(SvnStatus svnStatus) {
        if (svnStatus != null && svnStatus.isFileExternal()) {
            svnStatus.setSwitched(false);
        }
        return svnStatus;
    }

    private void sendUnversionedItem(File file, SVNNodeKind sVNNodeKind, boolean bl2, Collection collection, boolean bl3, int n2, ISvnObjectReceiver iSvnObjectReceiver) {
        boolean bl4 = SvnNgPropertiesManager.isIgnored(SVNFileUtil.getFileName(file), collection);
        boolean bl5 = this.isExternal(file);
        SvnStatus svnStatus = SVNStatusEditor17.assembleUnversioned17(file, sVNNodeKind, bl2, bl4);
        if (svnStatus != null) {
            if (bl5) {
                svnStatus.setNodeStatus(SVNStatusType.STATUS_EXTERNAL);
            }
            if (svnStatus.isConflicted()) {
                bl4 = false;
            }
            if (n2 > 0) {
                svnStatus.setWorkingCopyFormat(n2);
            }
            if (iSvnObjectReceiver != null && (bl3 || !bl4 || bl5)) {
                iSvnObjectReceiver.receive(SvnTarget.fromFile(file), svnStatus);
            }
        }
    }

    public static SvnStatus assembleUnversioned17(File file, SVNNodeKind sVNNodeKind, boolean bl2, boolean bl3) {
        SvnStatus svnStatus = new SvnStatus();
        svnStatus.setPath(file);
        svnStatus.setKind(SVNNodeKind.UNKNOWN);
        svnStatus.setDepth(SVNDepth.UNKNOWN);
        svnStatus.setNodeStatus(SVNStatusType.STATUS_NONE);
        svnStatus.setTextStatus(SVNStatusType.STATUS_NONE);
        svnStatus.setPropertiesStatus(SVNStatusType.STATUS_NONE);
        svnStatus.setRepositoryNodeStatus(SVNStatusType.STATUS_NONE);
        svnStatus.setRepositoryTextStatus(SVNStatusType.STATUS_NONE);
        svnStatus.setRepositoryPropertiesStatus(SVNStatusType.STATUS_NONE);
        if (sVNNodeKind != SVNNodeKind.NONE) {
            if (bl3) {
                svnStatus.setNodeStatus(SVNStatusType.STATUS_IGNORED);
            } else {
                svnStatus.setNodeStatus(SVNStatusType.STATUS_UNVERSIONED);
            }
        } else if (bl2) {
            svnStatus.setNodeStatus(SVNStatusType.STATUS_CONFLICTED);
        }
        svnStatus.setRevision(-1L);
        svnStatus.setChangedRevision(-1L);
        svnStatus.setRepositoryChangedRevision(-1L);
        svnStatus.setRepositoryKind(SVNNodeKind.NONE);
        svnStatus.setConflicted(bl2);
        svnStatus.setChangelist(null);
        return svnStatus;
    }

    public static SvnStatus assembleStatus(SVNWCContext sVNWCContext, File file, ISVNWCDb$WCDbRepositoryInfo iSVNWCDb$WCDbRepositoryInfo, ISVNWCDb$SVNWCDbInfo iSVNWCDb$SVNWCDbInfo, SVNNodeKind sVNNodeKind, boolean bl2, boolean bl3, boolean bl4, SVNLock sVNLock) {
        Object object;
        Object object2;
        boolean bl5;
        File file2;
        long l2;
        boolean bl6;
        SVNStatusType sVNStatusType;
        SVNStatusType sVNStatusType2;
        SVNStatusType sVNStatusType3;
        boolean bl7;
        block54: {
            Object object3;
            bl7 = false;
            sVNStatusType3 = SVNStatusType.STATUS_NORMAL;
            sVNStatusType2 = SVNStatusType.STATUS_NORMAL;
            sVNStatusType = SVNStatusType.STATUS_NONE;
            if (iSVNWCDb$SVNWCDbInfo == null) {
                iSVNWCDb$SVNWCDbInfo = SVNStatusEditor17.readInfo(sVNWCContext, file);
            }
            if (iSVNWCDb$SVNWCDbInfo.reposRelpath == null || iSVNWCDb$WCDbRepositoryInfo == null || iSVNWCDb$WCDbRepositoryInfo.relPath == null) {
                bl6 = false;
            } else {
                object3 = SVNFileUtil.getFilePath(SVNWCUtils.skipAncestor(iSVNWCDb$WCDbRepositoryInfo.relPath, iSVNWCDb$SVNWCDbInfo.reposRelpath));
                boolean bl8 = bl6 = object3 == null || !((String)object3).equals(SVNFileUtil.getFileName(file));
            }
            if (iSVNWCDb$SVNWCDbInfo.status == ISVNWCDb$SVNWCDbStatus.Incomplete || iSVNWCDb$SVNWCDbInfo.incomplete) {
                sVNStatusType3 = SVNStatusType.STATUS_INCOMPLETE;
            } else if (iSVNWCDb$SVNWCDbInfo.status == ISVNWCDb$SVNWCDbStatus.Deleted) {
                sVNStatusType3 = SVNStatusType.STATUS_DELETED;
                if (!iSVNWCDb$SVNWCDbInfo.haveBase || iSVNWCDb$SVNWCDbInfo.haveMoreWork || iSVNWCDb$SVNWCDbInfo.copied) {
                    bl7 = true;
                } else if (!iSVNWCDb$SVNWCDbInfo.haveMoreWork && iSVNWCDb$SVNWCDbInfo.haveBase) {
                    bl7 = false;
                } else {
                    object3 = sVNWCContext.getDb().scanDeletion(file, new ISVNWCDb$WCDbDeletionInfo$DeletionInfoField[0]);
                    if (((ISVNWCDb$WCDbDeletionInfo)object3).workDelAbsPath != null) {
                        bl7 = true;
                    }
                }
            } else {
                Object object4 = object3 = iSVNWCDb$SVNWCDbInfo.kind == ISVNWCDb$SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE;
                if (sVNNodeKind == null || sVNNodeKind != object3) {
                    sVNStatusType3 = sVNNodeKind == null || sVNNodeKind == SVNNodeKind.NONE ? SVNStatusType.STATUS_MISSING : SVNStatusType.STATUS_OBSTRUCTED;
                }
            }
            if (iSVNWCDb$SVNWCDbInfo.status != ISVNWCDb$SVNWCDbStatus.Deleted) {
                if (iSVNWCDb$SVNWCDbInfo.propsMod) {
                    sVNStatusType = SVNStatusType.STATUS_MODIFIED;
                } else if (iSVNWCDb$SVNWCDbInfo.hadProps) {
                    sVNStatusType = SVNStatusType.STATUS_NORMAL;
                }
            }
            if (iSVNWCDb$SVNWCDbInfo.kind != ISVNWCDb$SVNWCDbKind.Dir && sVNStatusType3 == SVNStatusType.STATUS_NORMAL) {
                boolean bl9 = false;
                long l3 = SVNFileUtil.getFileLength(file);
                l2 = SVNFileUtil.getFileLastModifiedMicros(file);
                if (!(iSVNWCDb$SVNWCDbInfo.kind != ISVNWCDb$SVNWCDbKind.File && iSVNWCDb$SVNWCDbInfo.kind != ISVNWCDb$SVNWCDbKind.Symlink || SVNFileUtil.symlinksSupported() && iSVNWCDb$SVNWCDbInfo.special != bl2)) {
                    if (!iSVNWCDb$SVNWCDbInfo.hasChecksum) {
                        bl9 = true;
                    } else if (bl4 || sVNNodeKind != null && iSVNWCDb$SVNWCDbInfo.recordedSize != -1L && iSVNWCDb$SVNWCDbInfo.recordedModTime != 0L && SVNFileUtil.compareFileTimestamps(iSVNWCDb$SVNWCDbInfo.recordedModTime, l2) && iSVNWCDb$SVNWCDbInfo.recordedSize == l3) {
                        bl9 = false;
                    } else {
                        try {
                            bl9 = sVNWCContext.isTextModified(file, false);
                        }
                        catch (SVNException sVNException) {
                            if (!SVNWCContext.isErrorAccess(sVNException)) {
                                throw sVNException;
                            }
                            bl9 = true;
                        }
                    }
                } else if (SVNFileUtil.symlinksSupported() && iSVNWCDb$SVNWCDbInfo.special != (sVNNodeKind != null && bl2)) {
                    sVNStatusType3 = SVNStatusType.STATUS_OBSTRUCTED;
                }
                if (bl9) {
                    sVNStatusType2 = SVNStatusType.STATUS_MODIFIED;
                }
            }
            file2 = null;
            bl5 = iSVNWCDb$SVNWCDbInfo.conflicted;
            if (bl5) {
                object2 = sVNWCContext.getConflicted(file, true, true, true);
                if (!(((SVNWCContext$ConflictInfo)object2).propConflicted || ((SVNWCContext$ConflictInfo)object2).textConflicted || ((SVNWCContext$ConflictInfo)object2).treeConflicted)) {
                    bl5 = false;
                }
            }
            if (sVNStatusType3 == SVNStatusType.STATUS_NORMAL && iSVNWCDb$SVNWCDbInfo.status == ISVNWCDb$SVNWCDbStatus.Added) {
                bl7 = iSVNWCDb$SVNWCDbInfo.copied;
                if (iSVNWCDb$SVNWCDbInfo.opRoot) {
                    if (!iSVNWCDb$SVNWCDbInfo.haveBase && !iSVNWCDb$SVNWCDbInfo.haveMoreWork) {
                        sVNStatusType3 = SVNStatusType.STATUS_ADDED;
                    } else {
                        object2 = sVNWCContext.getDb().readInfoBelowWorking(file);
                        sVNStatusType3 = ((ISVNWCDb$WCDbInfo)object2).status != ISVNWCDb$SVNWCDbStatus.NotPresent && ((ISVNWCDb$WCDbInfo)object2).status != ISVNWCDb$SVNWCDbStatus.Deleted ? SVNStatusType.STATUS_REPLACED : SVNStatusType.STATUS_ADDED;
                    }
                }
                if (iSVNWCDb$SVNWCDbInfo.movedHere && iSVNWCDb$SVNWCDbInfo.opRoot) {
                    try {
                        object2 = SvnWcDbShared.scanMoved((SVNWCDb)sVNWCContext.getDb(), file);
                        file2 = (File)((Structure)object2).get(StructureFields$MovedInfo.movedFromAbsPath);
                    }
                    catch (SVNException sVNException) {
                        if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_UNEXPECTED_STATUS) break block54;
                        throw sVNException;
                    }
                }
            }
        }
        if (sVNStatusType3 == SVNStatusType.STATUS_NORMAL) {
            sVNStatusType3 = sVNStatusType2;
        }
        if (sVNStatusType3 == SVNStatusType.STATUS_NORMAL && sVNStatusType != SVNStatusType.STATUS_NONE) {
            sVNStatusType3 = sVNStatusType;
        }
        if (!(bl3 || sVNStatusType3 != SVNStatusType.STATUS_NONE && sVNStatusType3 != SVNStatusType.STATUS_NORMAL || bl6 || iSVNWCDb$SVNWCDbInfo.locked || iSVNWCDb$SVNWCDbInfo.lock != null || sVNLock != null || iSVNWCDb$SVNWCDbInfo.changelist != null || bl5)) {
            return null;
        }
        object2 = null;
        l2 = -1L;
        if (bl7) {
            object = sVNWCContext.getNodeOrigin(file, false, StructureFields$NodeOriginInfo.reposRootUrl, StructureFields$NodeOriginInfo.reposRelpath, StructureFields$NodeOriginInfo.revision);
            object2 = (SVNURL)((Structure)object).get(StructureFields$NodeOriginInfo.reposRootUrl);
            if (object2 != null) {
                object2 = SVNWCUtils.join((SVNURL)object2, (File)((Structure)object).get(StructureFields$NodeOriginInfo.reposRelpath));
                l2 = ((Structure)object).lng(StructureFields$NodeOriginInfo.revision);
            }
            ((Structure)object).release();
        }
        object = null;
        switch (iSVNWCDb$SVNWCDbInfo.kind) {
            case Dir: {
                object = SVNNodeKind.DIR;
                break;
            }
            case File: 
            case Symlink: {
                object = SVNNodeKind.FILE;
                break;
            }
            default: {
                object = SVNNodeKind.UNKNOWN;
            }
        }
        SvnStatus svnStatus = new SvnStatus();
        svnStatus.setKind((SVNNodeKind)object);
        svnStatus.setPath(file);
        ISVNWCDb$WCDbRepositoryInfo iSVNWCDb$WCDbRepositoryInfo2 = SVNStatusEditor17.getRepositoryRootUrlRelPath(sVNWCContext, iSVNWCDb$WCDbRepositoryInfo, iSVNWCDb$SVNWCDbInfo, file);
        if (iSVNWCDb$SVNWCDbInfo.lock != null) {
            svnStatus.setLock(new SVNLock(SVNFileUtil.getFilePath(iSVNWCDb$WCDbRepositoryInfo2.relPath), iSVNWCDb$SVNWCDbInfo.lock.token, iSVNWCDb$SVNWCDbInfo.lock.owner, iSVNWCDb$SVNWCDbInfo.lock.comment, iSVNWCDb$SVNWCDbInfo.lock.date, null));
        }
        svnStatus.setCopyFromUrl((SVNURL)object2);
        svnStatus.setCopyFromRevision(l2);
        svnStatus.setDepth(iSVNWCDb$SVNWCDbInfo.depth);
        svnStatus.setNodeStatus(sVNStatusType3);
        svnStatus.setTextStatus(sVNStatusType2);
        svnStatus.setPropertiesStatus(sVNStatusType);
        svnStatus.setRepositoryNodeStatus(SVNStatusType.STATUS_NONE);
        svnStatus.setRepositoryTextStatus(SVNStatusType.STATUS_NONE);
        svnStatus.setRepositoryPropertiesStatus(SVNStatusType.STATUS_NONE);
        svnStatus.setSwitched(bl6);
        svnStatus.setCopied(bl7);
        svnStatus.setRepositoryLock(sVNLock);
        svnStatus.setRevision(iSVNWCDb$SVNWCDbInfo.revnum);
        svnStatus.setChangedRevision(iSVNWCDb$SVNWCDbInfo.changedRev);
        svnStatus.setChangedAuthor(iSVNWCDb$SVNWCDbInfo.changedAuthor);
        svnStatus.setChangedDate(iSVNWCDb$SVNWCDbInfo.changedDate);
        svnStatus.setRepositoryKind(SVNNodeKind.NONE);
        svnStatus.setRepositoryChangedRevision(-1L);
        svnStatus.setRepositoryChangedDate(null);
        svnStatus.setRepositoryChangedAuthor(null);
        svnStatus.setWcLocked(iSVNWCDb$SVNWCDbInfo.locked);
        svnStatus.setConflicted(bl5);
        svnStatus.setVersioned(true);
        svnStatus.setChangelist(iSVNWCDb$SVNWCDbInfo.changelist);
        svnStatus.setRepositoryRootUrl(iSVNWCDb$WCDbRepositoryInfo2.rootUrl);
        svnStatus.setRepositoryRelativePath(SVNFileUtil.getFilePath(iSVNWCDb$WCDbRepositoryInfo2.relPath));
        svnStatus.setRepositoryUuid(iSVNWCDb$WCDbRepositoryInfo2.uuid);
        svnStatus.setTextStatus(sVNStatusType2);
        svnStatus.setNodeStatus(sVNStatusType3);
        svnStatus.setPropertiesStatus(sVNStatusType);
        if (svnStatus.isVersioned() && svnStatus.isConflicted()) {
            SVNWCContext$ConflictInfo sVNWCContext$ConflictInfo = sVNWCContext.getConflicted(svnStatus.getPath(), true, true, true);
            if (sVNWCContext$ConflictInfo.textConflicted) {
                svnStatus.setTextStatus(SVNStatusType.STATUS_CONFLICTED);
            }
            if (sVNWCContext$ConflictInfo.propConflicted) {
                svnStatus.setPropertiesStatus(SVNStatusType.STATUS_CONFLICTED);
            }
            if (sVNWCContext$ConflictInfo.textConflicted || sVNWCContext$ConflictInfo.propConflicted) {
                svnStatus.setNodeStatus(SVNStatusType.STATUS_CONFLICTED);
            }
        }
        svnStatus.setFileExternal(iSVNWCDb$SVNWCDbInfo.fileExternal);
        svnStatus.setMovedFromPath(file2);
        if (iSVNWCDb$SVNWCDbInfo.movedToAbsPath != null) {
            svnStatus.setMovedToPath(iSVNWCDb$SVNWCDbInfo.movedToAbsPath);
        }
        if (iSVNWCDb$SVNWCDbInfo.format != -1) {
            svnStatus.setWorkingCopyFormat(iSVNWCDb$SVNWCDbInfo.format);
        }
        return svnStatus;
    }

    private boolean isExternal(File file) {
        if (!this.myExternalsMap.containsKey(file)) {
            for (File file2 : this.myExternalsMap.keySet()) {
                if (!SVNWCUtils.isChild(file, file2)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private Collection collectIgnorePatterns(SVNWCDbRoot sVNWCDbRoot, File file, Collection collection) {
        Object object;
        Object object2;
        SVNProperties sVNProperties;
        ArrayList arrayList = new ArrayList();
        if (collection != null) {
            arrayList.addAll(collection);
        }
        if ((sVNProperties = SvnWcDbProperties.readProperties(sVNWCDbRoot, file)) != null) {
            object2 = sVNProperties.getStringValue("svn:ignore");
            if (object2 != null) {
                SvnNgPropertiesManager.splitAndAppend(arrayList, (String)object2);
            }
            if ((object = sVNProperties.getStringValue("svn:global-ignores")) != null) {
                SvnNgPropertiesManager.splitAndAppend(arrayList, (String)object);
            }
        }
        object2 = null;
        try {
            object2 = SvnWcDbProperties.readInheritedProperties(sVNWCDbRoot, file, "svn:global-ignores");
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_UNEXPECTED_STATUS) {
                return arrayList;
            }
            throw sVNException;
        }
        object = object2.iterator();
        while (object.hasNext()) {
            Structure structure = (Structure)object.next();
            SVNProperties sVNProperties2 = (SVNProperties)structure.get(StructureFields$InheritedProperties.properties);
            SvnNgPropertiesManager.splitAndAppend(arrayList, sVNProperties2.getStringValue("svn:global-ignores"));
        }
        return arrayList;
    }

    public void setRepositoryInfo(SVNURL sVNURL, HashMap hashMap) {
        this.myRepositoryRoot = sVNURL;
        this.myRepositoryLocks = hashMap;
    }

    private static ISVNWCDb$SVNWCDbInfo readInfo(SVNWCContext sVNWCContext, File file) {
        Object object;
        ISVNWCDb$SVNWCDbInfo iSVNWCDb$SVNWCDbInfo = new ISVNWCDb$SVNWCDbInfo();
        ISVNWCDb$WCDbInfo iSVNWCDb$WCDbInfo = sVNWCContext.getDb().readInfo(file, ISVNWCDb$WCDbInfo$InfoField.status, ISVNWCDb$WCDbInfo$InfoField.kind, ISVNWCDb$WCDbInfo$InfoField.revision, ISVNWCDb$WCDbInfo$InfoField.reposRelPath, ISVNWCDb$WCDbInfo$InfoField.reposRootUrl, ISVNWCDb$WCDbInfo$InfoField.reposUuid, ISVNWCDb$WCDbInfo$InfoField.changedRev, ISVNWCDb$WCDbInfo$InfoField.changedDate, ISVNWCDb$WCDbInfo$InfoField.changedAuthor, ISVNWCDb$WCDbInfo$InfoField.depth, ISVNWCDb$WCDbInfo$InfoField.checksum, ISVNWCDb$WCDbInfo$InfoField.lock, ISVNWCDb$WCDbInfo$InfoField.translatedSize, ISVNWCDb$WCDbInfo$InfoField.lastModTime, ISVNWCDb$WCDbInfo$InfoField.changelist, ISVNWCDb$WCDbInfo$InfoField.originalReposRelpath, ISVNWCDb$WCDbInfo$InfoField.conflicted, ISVNWCDb$WCDbInfo$InfoField.opRoot, ISVNWCDb$WCDbInfo$InfoField.hadProps, ISVNWCDb$WCDbInfo$InfoField.propsMod, ISVNWCDb$WCDbInfo$InfoField.haveBase, ISVNWCDb$WCDbInfo$InfoField.haveMoreWork, ISVNWCDb$WCDbInfo$InfoField.movedHere, ISVNWCDb$WCDbInfo$InfoField.movedTo);
        iSVNWCDb$SVNWCDbInfo.load(iSVNWCDb$WCDbInfo);
        iSVNWCDb$SVNWCDbInfo.locked = sVNWCContext.getDb().isWCLocked(file);
        ISVNWCDb$WCDbBaseInfo iSVNWCDb$WCDbBaseInfo = null;
        if (iSVNWCDb$SVNWCDbInfo.haveBase && (iSVNWCDb$SVNWCDbInfo.status == ISVNWCDb$SVNWCDbStatus.Added || iSVNWCDb$SVNWCDbInfo.status == ISVNWCDb$SVNWCDbStatus.Deleted)) {
            iSVNWCDb$WCDbBaseInfo = sVNWCContext.getDb().getBaseInfo(file, ISVNWCDb$WCDbBaseInfo$BaseInfoField.lock, ISVNWCDb$WCDbBaseInfo$BaseInfoField.updateRoot);
            iSVNWCDb$SVNWCDbInfo.lock = iSVNWCDb$WCDbBaseInfo.lock;
        }
        if (iSVNWCDb$SVNWCDbInfo.haveBase && iSVNWCDb$SVNWCDbInfo.kind == ISVNWCDb$SVNWCDbKind.File) {
            if (iSVNWCDb$WCDbBaseInfo == null) {
                iSVNWCDb$WCDbBaseInfo = sVNWCContext.getDb().getBaseInfo(file, ISVNWCDb$WCDbBaseInfo$BaseInfoField.lock, ISVNWCDb$WCDbBaseInfo$BaseInfoField.updateRoot);
            }
            iSVNWCDb$SVNWCDbInfo.fileExternal = iSVNWCDb$WCDbBaseInfo.updateRoot;
        } else {
            iSVNWCDb$SVNWCDbInfo.fileExternal = false;
        }
        iSVNWCDb$SVNWCDbInfo.hasChecksum = iSVNWCDb$WCDbInfo.checksum != null;
        boolean bl2 = iSVNWCDb$SVNWCDbInfo.copied = iSVNWCDb$WCDbInfo.originalReposRelpath != null;
        if (iSVNWCDb$SVNWCDbInfo.kind == ISVNWCDb$SVNWCDbKind.File && (iSVNWCDb$SVNWCDbInfo.hadProps || iSVNWCDb$SVNWCDbInfo.propsMod)) {
            object = iSVNWCDb$SVNWCDbInfo.propsMod ? sVNWCContext.getDb().readProperties(file) : sVNWCContext.getDb().readPristineProperties(file);
            iSVNWCDb$SVNWCDbInfo.special = ((SVNProperties)object).getSVNPropertyValue("svn:special") != null;
        }
        object = ((SVNWCDb)sVNWCContext.getDb()).parseDir(file, SVNSqlJetDb$Mode.ReadOnly);
        iSVNWCDb$SVNWCDbInfo.format = ((SVNWCDb$DirParsedInfo)object).wcDbDir.getWCRoot().getFormat();
        return iSVNWCDb$SVNWCDbInfo;
    }

    public void walkStatus(File file, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, Collection collection) {
        boolean bl5;
        String string;
        File file2;
        ISVNWCDb$SVNWCDbInfo iSVNWCDb$SVNWCDbInfo;
        block5: {
            this.collectExternals(file);
            if (collection == null) {
                collection = SVNStatusEditor17.getGlobalIgnores(this.myWCContext.getOptions());
            }
            iSVNWCDb$SVNWCDbInfo = null;
            try {
                iSVNWCDb$SVNWCDbInfo = SVNStatusEditor17.readInfo(this.myWCContext, file);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block5;
                throw sVNException;
            }
        }
        SVNFileType sVNFileType = SVNFileType.getType(file);
        if (iSVNWCDb$SVNWCDbInfo != null && iSVNWCDb$SVNWCDbInfo.kind == ISVNWCDb$SVNWCDbKind.Dir && iSVNWCDb$SVNWCDbInfo.status != ISVNWCDb$SVNWCDbStatus.Excluded && iSVNWCDb$SVNWCDbInfo.status != ISVNWCDb$SVNWCDbStatus.NotPresent && iSVNWCDb$SVNWCDbInfo.status != ISVNWCDb$SVNWCDbStatus.ServerExcluded) {
            file2 = file;
            string = null;
            bl5 = false;
        } else {
            iSVNWCDb$SVNWCDbInfo = null;
            file2 = SVNFileUtil.getParentFile(file);
            string = SVNFileUtil.getFileName(file);
            bl5 = true;
        }
        this.myIgnoreTextMods = bl4;
        this.getDirStatus(file2, string, bl5, null, iSVNWCDb$SVNWCDbInfo, sVNFileType, collection, sVNDepth, bl2, bl3, this.getDefaultHandler());
    }

    protected void getDirStatus(File file, String string, boolean bl2, ISVNWCDb$WCDbRepositoryInfo iSVNWCDb$WCDbRepositoryInfo, ISVNWCDb$SVNWCDbInfo iSVNWCDb$SVNWCDbInfo, SVNFileType sVNFileType, Collection collection, SVNDepth sVNDepth, boolean bl3, boolean bl4, ISvnObjectReceiver iSvnObjectReceiver) {
        Iterator iterator;
        Map map;
        this.myWCContext.checkCancelled();
        if (sVNDepth == SVNDepth.UNKNOWN) {
            sVNDepth = SVNDepth.INFINITY;
        }
        if ((map = this.myFileListHook.listFiles(file)) == null) {
            map = Collections.emptyMap();
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashMap<String, ISVNWCDb$SVNWCDbInfo> hashMap = new HashMap<String, ISVNWCDb$SVNWCDbInfo>();
        Collection collection2 = null;
        if (iSVNWCDb$SVNWCDbInfo == null) {
            iSVNWCDb$SVNWCDbInfo = SVNStatusEditor17.readInfo(this.myWCContext, file);
        }
        ISVNWCDb$WCDbRepositoryInfo iSVNWCDb$WCDbRepositoryInfo2 = SVNStatusEditor17.getRepositoryRootUrlRelPath(this.myWCContext, iSVNWCDb$WCDbRepositoryInfo, iSVNWCDb$SVNWCDbInfo, file);
        if (this.wcRoot == null) {
            iterator = ((SVNWCDb)this.myWCContext.getDb()).parseDir(file, SVNSqlJetDb$Mode.ReadOnly);
            this.wcRoot = ((SVNWCDb$DirParsedInfo)((Object)iterator)).wcDbDir.getWCRoot();
        }
        if (string == null) {
            iterator = this.wcRoot.computeRelPath(file);
            ((SVNWCDb)this.myWCContext.getDb()).readChildren(this.wcRoot, (File)((Object)iterator), hashMap, hashSet2);
            hashSet.addAll(hashMap.keySet());
            hashSet.addAll(map.keySet());
            hashSet.addAll(hashSet2);
        } else {
            Object object;
            block19: {
                iterator = SVNFileUtil.createFilePath(file, string);
                object = null;
                try {
                    object = SVNStatusEditor17.readInfo(this.myWCContext, (File)((Object)iterator));
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block19;
                    throw sVNException;
                }
            }
            if (object != null) {
                if (!((ISVNWCDb$SVNWCDbInfo)object).conflicted || ((ISVNWCDb$SVNWCDbInfo)object).status != ISVNWCDb$SVNWCDbStatus.Normal || ((ISVNWCDb$SVNWCDbInfo)object).kind != ISVNWCDb$SVNWCDbKind.Unknown) {
                    hashMap.put(string, (ISVNWCDb$SVNWCDbInfo)object);
                }
                if (((ISVNWCDb$SVNWCDbInfo)object).conflicted) {
                    hashSet2.add(string);
                }
            }
            hashSet.add(string);
        }
        if (string == null) {
            if (!bl2) {
                this.sendStatusStructure(file, iSVNWCDb$WCDbRepositoryInfo, iSVNWCDb$SVNWCDbInfo, SVNFileType.getNodeKind(sVNFileType), sVNFileType == SVNFileType.SYMLINK, bl3, iSvnObjectReceiver);
            }
            if (sVNDepth == SVNDepth.EMPTY) {
                return;
            }
        }
        for (Object object : hashSet) {
            File file2 = SVNFileUtil.createFilePath(file, (String)object);
            SVNFileType sVNFileType2 = map.containsKey(object) ? SVNFileType.getType((File)map.get(object)) : null;
            ISVNWCDb$SVNWCDbInfo iSVNWCDb$SVNWCDbInfo2 = (ISVNWCDb$SVNWCDbInfo)hashMap.get(object);
            if (iSVNWCDb$SVNWCDbInfo2 != null && iSVNWCDb$SVNWCDbInfo2.status != ISVNWCDb$SVNWCDbStatus.NotPresent && iSVNWCDb$SVNWCDbInfo2.status != ISVNWCDb$SVNWCDbStatus.Excluded && iSVNWCDb$SVNWCDbInfo2.status != ISVNWCDb$SVNWCDbStatus.ServerExcluded) {
                if (sVNDepth == SVNDepth.FILES && iSVNWCDb$SVNWCDbInfo2.kind == ISVNWCDb$SVNWCDbKind.Dir) continue;
                this.sendStatusStructure(file2, iSVNWCDb$WCDbRepositoryInfo2, iSVNWCDb$SVNWCDbInfo2, SVNFileType.getNodeKind(sVNFileType2), sVNFileType2 == SVNFileType.SYMLINK, bl3, iSvnObjectReceiver);
                if (sVNDepth != SVNDepth.INFINITY || iSVNWCDb$SVNWCDbInfo2.kind != ISVNWCDb$SVNWCDbKind.Dir) continue;
                this.getDirStatus(file2, null, true, iSVNWCDb$WCDbRepositoryInfo2, iSVNWCDb$SVNWCDbInfo2, sVNFileType2, collection, SVNDepth.INFINITY, bl3, bl4, iSvnObjectReceiver);
                continue;
            }
            if (hashSet2.contains(object)) {
                if (collection != null && collection2 == null) {
                    collection2 = this.collectIgnorePatterns(this.wcRoot, this.wcRoot.computeRelPath(file), collection);
                }
                this.sendUnversionedItem(file2, SVNFileType.getNodeKind(sVNFileType2), true, collection2, bl4, this.wcRoot.getFormat(), iSvnObjectReceiver);
                continue;
            }
            if (sVNFileType2 == null || sVNDepth == SVNDepth.FILES && sVNFileType2 == SVNFileType.DIRECTORY || SVNFileUtil.getAdminDirectoryName().equals(object)) continue;
            if (collection != null && collection2 == null) {
                collection2 = this.collectIgnorePatterns(this.wcRoot, this.wcRoot.computeRelPath(file), collection);
            }
            this.sendUnversionedItem(file2, SVNFileType.getNodeKind(sVNFileType2), false, collection2, bl4 || string != null, this.wcRoot.getFormat(), iSvnObjectReceiver);
        }
    }

    private static ISVNWCDb$WCDbRepositoryInfo getRepositoryRootUrlRelPath(SVNWCContext sVNWCContext, ISVNWCDb$WCDbRepositoryInfo iSVNWCDb$WCDbRepositoryInfo, ISVNWCDb$SVNWCDbInfo iSVNWCDb$SVNWCDbInfo, File file) {
        ISVNWCDb$WCDbRepositoryInfo iSVNWCDb$WCDbRepositoryInfo2 = new ISVNWCDb$WCDbRepositoryInfo();
        if (iSVNWCDb$SVNWCDbInfo.reposRelpath != null && iSVNWCDb$SVNWCDbInfo.reposRootUrl != null) {
            iSVNWCDb$WCDbRepositoryInfo2.relPath = iSVNWCDb$SVNWCDbInfo.reposRelpath;
            iSVNWCDb$WCDbRepositoryInfo2.uuid = iSVNWCDb$SVNWCDbInfo.reposUuid;
            iSVNWCDb$WCDbRepositoryInfo2.rootUrl = iSVNWCDb$SVNWCDbInfo.reposRootUrl;
        } else if (iSVNWCDb$WCDbRepositoryInfo != null && iSVNWCDb$WCDbRepositoryInfo.rootUrl != null && iSVNWCDb$WCDbRepositoryInfo.relPath != null) {
            iSVNWCDb$WCDbRepositoryInfo2.relPath = SVNFileUtil.createFilePath(iSVNWCDb$WCDbRepositoryInfo.relPath, SVNFileUtil.getFileName(file));
            iSVNWCDb$WCDbRepositoryInfo2.uuid = iSVNWCDb$WCDbRepositoryInfo.uuid;
            iSVNWCDb$WCDbRepositoryInfo2.rootUrl = iSVNWCDb$WCDbRepositoryInfo.rootUrl;
        } else if (iSVNWCDb$SVNWCDbInfo.status == ISVNWCDb$SVNWCDbStatus.Added) {
            ISVNWCDb$WCDbAdditionInfo iSVNWCDb$WCDbAdditionInfo = sVNWCContext.getDb().scanAddition(file, ISVNWCDb$WCDbAdditionInfo$AdditionInfoField.reposRelPath, ISVNWCDb$WCDbAdditionInfo$AdditionInfoField.reposRootUrl, ISVNWCDb$WCDbAdditionInfo$AdditionInfoField.reposUuid);
            iSVNWCDb$WCDbRepositoryInfo2.relPath = iSVNWCDb$WCDbAdditionInfo.reposRelPath;
            iSVNWCDb$WCDbRepositoryInfo2.uuid = iSVNWCDb$WCDbAdditionInfo.reposUuid;
            iSVNWCDb$WCDbRepositoryInfo2.rootUrl = iSVNWCDb$WCDbAdditionInfo.reposRootUrl;
        } else {
            ISVNWCDb$WCDbRepositoryInfo iSVNWCDb$WCDbRepositoryInfo3 = sVNWCContext.getDb().readRepositoryInfo(file, ISVNWCDb$WCDbRepositoryInfo$RepositoryInfoField.relPath, ISVNWCDb$WCDbRepositoryInfo$RepositoryInfoField.rootUrl, ISVNWCDb$WCDbRepositoryInfo$RepositoryInfoField.uuid);
            iSVNWCDb$WCDbRepositoryInfo2.relPath = iSVNWCDb$WCDbRepositoryInfo3.relPath;
            iSVNWCDb$WCDbRepositoryInfo2.uuid = iSVNWCDb$WCDbRepositoryInfo3.uuid;
            iSVNWCDb$WCDbRepositoryInfo2.rootUrl = iSVNWCDb$WCDbRepositoryInfo3.rootUrl;
        }
        return iSVNWCDb$WCDbRepositoryInfo2;
    }

    public static SvnStatus internalStatus(SVNWCContext sVNWCContext, File file, boolean bl2) {
        boolean bl3;
        boolean bl4;
        ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind;
        SVNNodeKind sVNNodeKind;
        ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus;
        block17: {
            iSVNWCDb$SVNWCDbStatus = null;
            sVNNodeKind = SVNNodeKind.UNKNOWN;
            assert (SVNWCDb.isAbsolute(file));
            try {
                ISVNWCDb$SVNWCDbInfo iSVNWCDb$SVNWCDbInfo = sVNWCContext.getDb().readSingleInfo(file, !bl2, ISVNWCDb$WCDbInfo$InfoField.values());
                if (bl2) {
                    sVNNodeKind = SVNFileType.getNodeKind(SVNFileType.getType(file));
                }
                iSVNWCDb$SVNWCDbStatus = iSVNWCDb$SVNWCDbInfo.status;
                iSVNWCDb$SVNWCDbKind = iSVNWCDb$SVNWCDbInfo.kind;
                bl4 = iSVNWCDb$SVNWCDbInfo.conflicted;
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                    throw sVNException;
                }
                Object var7_6 = null;
                iSVNWCDb$SVNWCDbKind = ISVNWCDb$SVNWCDbKind.Unknown;
                bl4 = false;
                if (!bl2) break block17;
                sVNNodeKind = SVNFileType.getNodeKind(SVNFileType.getType(file));
            }
        }
        if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.ServerExcluded || iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.NotPresent || iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Excluded) {
            iSVNWCDb$SVNWCDbKind = ISVNWCDb$SVNWCDbKind.Unknown;
        }
        if (iSVNWCDb$SVNWCDbKind != ISVNWCDb$SVNWCDbKind.Unknown && (bl3 = sVNWCContext.getDb().isNodeHidden(file))) {
            iSVNWCDb$SVNWCDbKind = ISVNWCDb$SVNWCDbKind.Unknown;
        }
        if (iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.Unknown) {
            return SVNStatusEditor17.assembleUnversioned17(file, sVNNodeKind, bl4, false);
        }
        boolean bl5 = SVNFileUtil.getParentFile(file) == null ? true : sVNWCContext.getDb().isWCRoot(file);
        ISVNWCDb$WCDbRepositoryInfo iSVNWCDb$WCDbRepositoryInfo = new ISVNWCDb$WCDbRepositoryInfo();
        if (SVNFileUtil.getFileDir(file) != null && !bl5) {
            File file2 = SVNFileUtil.getFileDir(file);
            if (bl2) {
                try {
                    ISVNWCDb$WCDbInfo iSVNWCDb$WCDbInfo = sVNWCContext.getDb().readInfo(file2, ISVNWCDb$WCDbInfo$InfoField.reposRelPath, ISVNWCDb$WCDbInfo$InfoField.reposRootUrl, ISVNWCDb$WCDbInfo$InfoField.reposUuid);
                    iSVNWCDb$WCDbRepositoryInfo.relPath = iSVNWCDb$WCDbInfo.reposRelPath;
                    iSVNWCDb$WCDbRepositoryInfo.rootUrl = iSVNWCDb$WCDbInfo.reposRootUrl;
                    iSVNWCDb$WCDbRepositoryInfo.uuid = iSVNWCDb$WCDbInfo.reposUuid;
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND || sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_WORKING_COPY) {
                        iSVNWCDb$WCDbRepositoryInfo.relPath = null;
                        iSVNWCDb$WCDbRepositoryInfo.rootUrl = null;
                        iSVNWCDb$WCDbRepositoryInfo.uuid = null;
                    }
                    throw sVNException;
                }
            } else {
                try {
                    ISVNWCDb$WCDbBaseInfo iSVNWCDb$WCDbBaseInfo = sVNWCContext.getDb().getBaseInfo(file2, ISVNWCDb$WCDbBaseInfo$BaseInfoField.reposRelPath, ISVNWCDb$WCDbBaseInfo$BaseInfoField.reposRootUrl, ISVNWCDb$WCDbBaseInfo$BaseInfoField.reposUuid);
                    iSVNWCDb$WCDbRepositoryInfo.relPath = iSVNWCDb$WCDbBaseInfo.reposRelPath;
                    iSVNWCDb$WCDbRepositoryInfo.rootUrl = iSVNWCDb$WCDbBaseInfo.reposRootUrl;
                    iSVNWCDb$WCDbRepositoryInfo.uuid = iSVNWCDb$WCDbBaseInfo.reposUuid;
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND || sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_WORKING_COPY) {
                        iSVNWCDb$WCDbRepositoryInfo.relPath = null;
                        iSVNWCDb$WCDbRepositoryInfo.rootUrl = null;
                        iSVNWCDb$WCDbRepositoryInfo.uuid = null;
                    }
                    throw sVNException;
                }
            }
        }
        return SVNStatusEditor17.assembleStatus(sVNWCContext, file, iSVNWCDb$WCDbRepositoryInfo, null, sVNNodeKind, false, true, false, null);
    }
}

