/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbLock;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo$BaseInfoField;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbInfo$InfoField;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb$DirParsedInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.util.ISVNDebugLog;

public class SVNReporter17
implements ISVNReporterBaton {
    private final File path;
    private SVNWCContext wcContext;
    private SVNDepth depth;
    private final boolean isRestoreFiles;
    private final boolean isUseDepthCompatibilityTrick;
    private final boolean isHonorDepthExclude;
    private boolean isUseCommitTimes;
    private int reportedFilesCount;
    private int totalFilesCount;

    public SVNReporter17(File file, SVNWCContext sVNWCContext, boolean bl2, boolean bl3, SVNDepth sVNDepth, boolean bl4, boolean bl5, boolean bl6, boolean bl7, ISVNDebugLog iSVNDebugLog) {
        this.path = file;
        this.wcContext = sVNWCContext;
        this.isRestoreFiles = bl2;
        this.isUseDepthCompatibilityTrick = bl3;
        this.depth = sVNDepth;
        this.isHonorDepthExclude = bl6;
        this.isUseCommitTimes = bl7;
    }

    public int getReportedFilesCount() {
        return this.reportedFilesCount;
    }

    public int getTotalFilesCount() {
        return this.totalFilesCount;
    }

    @Override
    public void report(ISVNReporter iSVNReporter) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl2;
        Object object5;
        assert (SVNWCDb.isAbsolute(this.path));
        ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus = null;
        ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind = null;
        long l2 = 0L;
        File file = null;
        SVNURL sVNURL = null;
        SVNDepth sVNDepth = SVNDepth.UNKNOWN;
        ISVNWCDb$SVNWCDbLock iSVNWCDb$SVNWCDbLock = null;
        SVNErrorMessage sVNErrorMessage = null;
        try {
            object5 = this.wcContext.getDb().getBaseInfo(this.path, ISVNWCDb$WCDbBaseInfo$BaseInfoField.status, ISVNWCDb$WCDbBaseInfo$BaseInfoField.kind, ISVNWCDb$WCDbBaseInfo$BaseInfoField.revision, ISVNWCDb$WCDbBaseInfo$BaseInfoField.reposRelPath, ISVNWCDb$WCDbBaseInfo$BaseInfoField.reposRootUrl, ISVNWCDb$WCDbBaseInfo$BaseInfoField.depth, ISVNWCDb$WCDbBaseInfo$BaseInfoField.lock);
            iSVNWCDb$SVNWCDbStatus = ((ISVNWCDb$WCDbBaseInfo)object5).status;
            iSVNWCDb$SVNWCDbKind = ((ISVNWCDb$WCDbBaseInfo)object5).kind;
            l2 = ((ISVNWCDb$WCDbBaseInfo)object5).revision;
            file = ((ISVNWCDb$WCDbBaseInfo)object5).reposRelPath;
            sVNURL = ((ISVNWCDb$WCDbBaseInfo)object5).reposRootUrl;
            sVNDepth = ((ISVNWCDb$WCDbBaseInfo)object5).depth;
            iSVNWCDb$SVNWCDbLock = ((ISVNWCDb$WCDbBaseInfo)object5).lock;
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw sVNException;
            }
            sVNErrorMessage = sVNException.getErrorMessage();
        }
        if (sVNErrorMessage != null || iSVNWCDb$SVNWCDbStatus != ISVNWCDb$SVNWCDbStatus.Normal && iSVNWCDb$SVNWCDbStatus != ISVNWCDb$SVNWCDbStatus.Incomplete) {
            if (this.depth == SVNDepth.UNKNOWN) {
                this.depth = SVNDepth.INFINITY;
            }
            iSVNReporter.setPath("", null, 0L, this.depth, false);
            iSVNReporter.deletePath("");
            iSVNReporter.finishReport();
            return;
        }
        if (sVNDepth == SVNDepth.UNKNOWN) {
            sVNDepth = SVNDepth.INFINITY;
        }
        boolean bl3 = bl2 = iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Incomplete;
        if (this.isUseDepthCompatibilityTrick && sVNDepth.compareTo(SVNDepth.IMMEDIATES) <= 0 && this.depth.compareTo(sVNDepth) > 0) {
            bl2 = true;
        }
        object5 = SVNFileType.UNKNOWN;
        if (this.isRestoreFiles) {
            object5 = SVNFileType.getType(this.path);
        }
        if (this.isRestoreFiles && object5 == SVNFileType.NONE) {
            object4 = null;
            try {
                object4 = this.wcContext.getDb().readInfo(this.path, ISVNWCDb$WCDbInfo$InfoField.status, ISVNWCDb$WCDbInfo$InfoField.kind, ISVNWCDb$WCDbInfo$InfoField.checksum);
                object3 = ((ISVNWCDb$WCDbInfo)object4).status;
                object2 = ((ISVNWCDb$WCDbInfo)object4).kind;
                object = ((ISVNWCDb$WCDbInfo)object4).checksum;
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    object3 = ISVNWCDb$SVNWCDbStatus.NotPresent;
                    object2 = ISVNWCDb$SVNWCDbKind.File;
                    object = null;
                }
                throw sVNException;
            }
            if (!(object3 != ISVNWCDb$SVNWCDbStatus.Normal && object3 != ISVNWCDb$SVNWCDbStatus.Added && object3 != ISVNWCDb$SVNWCDbStatus.Incomplete || object2 != ISVNWCDb$SVNWCDbKind.Dir && object == null)) {
                SVNReporter17.restoreNode(this.wcContext, this.path, object2, l2, this.isUseCommitTimes);
            }
        }
        try {
            object4 = sVNDepth;
            if (this.isHonorDepthExclude && this.depth != SVNDepth.UNKNOWN && this.depth.compareTo(sVNDepth) < 0) {
                object4 = this.depth;
            }
            iSVNReporter.setPath("", null, l2, (SVNDepth)object4, bl2);
            if (iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.Dir) {
                if (this.depth != SVNDepth.EMPTY) {
                    object2 = ((SVNWCDb)this.wcContext.getDb()).obtainWcRoot(this.path);
                    this.reportRevisionsAndDepths(((SVNWCDb$DirParsedInfo)object2).wcDbDir.getWCRoot(), this.path, ((SVNWCDb$DirParsedInfo)object2).localRelPath, SVNFileUtil.createFilePath(""), l2, file, sVNURL, (SVNDepth)object4, iSVNReporter, this.isRestoreFiles, this.depth, bl2);
                }
            } else if (iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.Symlink || iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.File) {
                object2 = SVNFileUtil.getFileName(this.path);
                object3 = SVNFileUtil.getParentFile(this.path);
                object = this.wcContext.getDb().getBaseInfo((File)object3, ISVNWCDb$WCDbBaseInfo$BaseInfoField.reposRelPath);
                if (!file.equals(SVNFileUtil.createFilePath(((ISVNWCDb$WCDbBaseInfo)object).reposRelPath, (String)object2))) {
                    SVNURL sVNURL2 = SVNWCUtils.join(sVNURL, file);
                    iSVNReporter.linkPath(sVNURL2, "", iSVNWCDb$SVNWCDbLock != null ? iSVNWCDb$SVNWCDbLock.token : null, l2, SVNDepth.INFINITY, false);
                } else if (iSVNWCDb$SVNWCDbLock != null) {
                    iSVNReporter.setPath("", iSVNWCDb$SVNWCDbLock.token, l2, SVNDepth.INFINITY, false);
                }
            }
            iSVNReporter.finishReport();
        }
        catch (SVNException sVNException) {
            try {
                iSVNReporter.abortReport();
            }
            catch (SVNException sVNException2) {
                sVNException.getErrorMessage().setChildErrorMessage(sVNException2.getErrorMessage());
            }
            throw sVNException;
        }
    }

    public static boolean restoreNode(SVNWCContext sVNWCContext, File file, ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind, long l2, boolean bl2) {
        boolean bl3 = false;
        if (iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.File || iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.Symlink) {
            SVNReporter17.restoreFile(sVNWCContext, file, bl2, true);
            bl3 = true;
        } else if (iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.Dir) {
            file.mkdirs();
            bl3 = true;
        }
        if (bl3 && sVNWCContext.getEventHandler() != null) {
            sVNWCContext.getEventHandler().handleEvent(SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, null, l2, SVNEventAction.RESTORE, null, null, null), 0.0);
        }
        return bl3;
    }

    private void reportRevisionsAndDepths(SVNWCDbRoot sVNWCDbRoot, File file, File file2, File file3, long l2, File file4, SVNURL sVNURL, SVNDepth sVNDepth, ISVNReporter iSVNReporter, boolean bl2, SVNDepth sVNDepth2, boolean bl3) {
        Map map = this.wcContext.getDb().getBaseChildrenMap(sVNWCDbRoot, file2, true);
        HashSet<String> hashSet = null;
        if (bl2) {
            hashSet = new HashSet<String>();
            File[] fileArray = SVNFileListUtil.listFiles(file);
            if (fileArray != null) {
                for (File file5 : fileArray) {
                    hashSet.add(SVNFileUtil.getFileName(file5));
                }
            } else {
                Object object = SVNFileType.getType(file);
                if (object != SVNFileType.DIRECTORY) {
                    bl2 = false;
                }
            }
        }
        for (Object object : map.keySet()) {
            boolean bl4;
            Object object2;
            Object object3;
            Object object4;
            File file5;
            int n2 = 0;
            this.wcContext.checkCancelled();
            String string = SVNFileUtil.getFilePath(SVNFileUtil.createFilePath(file3, (String)object));
            file5 = SVNFileUtil.createFilePath(file, (String)object);
            ISVNWCDb$WCDbBaseInfo iSVNWCDb$WCDbBaseInfo = (ISVNWCDb$WCDbBaseInfo)map.get(object);
            if (iSVNWCDb$WCDbBaseInfo.updateRoot) continue;
            if (iSVNWCDb$WCDbBaseInfo.status == ISVNWCDb$SVNWCDbStatus.Excluded) {
                if (this.isHonorDepthExclude) {
                    iSVNReporter.setPath(string, null, l2, SVNDepth.EXCLUDE, false);
                    continue;
                }
                if (bl3) continue;
                iSVNReporter.deletePath(string);
                continue;
            }
            if (iSVNWCDb$WCDbBaseInfo.status == ISVNWCDb$SVNWCDbStatus.ServerExcluded || iSVNWCDb$WCDbBaseInfo.status == ISVNWCDb$SVNWCDbStatus.NotPresent) {
                if (bl3) continue;
                iSVNReporter.deletePath(string);
                continue;
            }
            if (bl2 && !hashSet.contains(object)) {
                ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind;
                object4 = null;
                try {
                    object4 = this.wcContext.getDb().readInfo(file5, ISVNWCDb$WCDbInfo$InfoField.status, ISVNWCDb$WCDbInfo$InfoField.kind, ISVNWCDb$WCDbInfo$InfoField.checksum);
                    object3 = ((ISVNWCDb$WCDbInfo)object4).status;
                    iSVNWCDb$SVNWCDbKind = ((ISVNWCDb$WCDbInfo)object4).kind;
                    object2 = ((ISVNWCDb$WCDbInfo)object4).checksum;
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                        object3 = ISVNWCDb$SVNWCDbStatus.NotPresent;
                        iSVNWCDb$SVNWCDbKind = ISVNWCDb$SVNWCDbKind.File;
                        object2 = null;
                    }
                    throw sVNException;
                }
                if (!(object3 != ISVNWCDb$SVNWCDbStatus.Normal && object3 != ISVNWCDb$SVNWCDbStatus.Added && object3 != ISVNWCDb$SVNWCDbStatus.Incomplete || iSVNWCDb$SVNWCDbKind != ISVNWCDb$SVNWCDbKind.Dir && object2 == null || SVNFileType.getType(file5) != SVNFileType.NONE)) {
                    SVNReporter17.restoreNode(this.wcContext, file5, iSVNWCDb$SVNWCDbKind, l2, this.isUseCommitTimes);
                }
            }
            if (iSVNWCDb$WCDbBaseInfo.reposRelPath == null) {
                iSVNWCDb$WCDbBaseInfo.reposRelPath = SVNFileUtil.createFilePath(file4, (String)object);
            } else {
                object4 = SVNWCUtils.getPathAsChild(file4, iSVNWCDb$WCDbBaseInfo.reposRelPath);
                if (object4 == null || !((String)object).equals(object4)) {
                    n2 = 1;
                }
            }
            if (iSVNWCDb$WCDbBaseInfo.depth == SVNDepth.UNKNOWN) {
                iSVNWCDb$WCDbBaseInfo.depth = SVNDepth.INFINITY;
            }
            if (iSVNWCDb$WCDbBaseInfo.kind == ISVNWCDb$SVNWCDbKind.File || iSVNWCDb$WCDbBaseInfo.kind == ISVNWCDb$SVNWCDbKind.Symlink) {
                if (bl3) {
                    if (n2 != 0) {
                        object4 = SVNWCUtils.join(sVNURL, iSVNWCDb$WCDbBaseInfo.reposRelPath);
                        iSVNReporter.linkPath((SVNURL)object4, string, iSVNWCDb$WCDbBaseInfo.lock != null ? iSVNWCDb$WCDbBaseInfo.lock.token : null, iSVNWCDb$WCDbBaseInfo.revision, iSVNWCDb$WCDbBaseInfo.depth, false);
                        continue;
                    }
                    iSVNReporter.setPath(string, iSVNWCDb$WCDbBaseInfo.lock != null ? iSVNWCDb$WCDbBaseInfo.lock.token : null, iSVNWCDb$WCDbBaseInfo.revision, iSVNWCDb$WCDbBaseInfo.depth, false);
                    continue;
                }
                if (n2 != 0) {
                    object4 = SVNWCUtils.join(sVNURL, iSVNWCDb$WCDbBaseInfo.reposRelPath);
                    iSVNReporter.linkPath((SVNURL)object4, string, iSVNWCDb$WCDbBaseInfo.lock != null ? iSVNWCDb$WCDbBaseInfo.lock.token : null, iSVNWCDb$WCDbBaseInfo.revision, iSVNWCDb$WCDbBaseInfo.depth, false);
                    continue;
                }
                if (iSVNWCDb$WCDbBaseInfo.revision == l2 && iSVNWCDb$WCDbBaseInfo.lock == null && sVNDepth != SVNDepth.EMPTY) continue;
                iSVNReporter.setPath(string, iSVNWCDb$WCDbBaseInfo.lock != null ? iSVNWCDb$WCDbBaseInfo.lock.token : null, iSVNWCDb$WCDbBaseInfo.revision, iSVNWCDb$WCDbBaseInfo.depth, false);
                continue;
            }
            if (iSVNWCDb$WCDbBaseInfo.kind != ISVNWCDb$SVNWCDbKind.Dir || sVNDepth2 != SVNDepth.UNKNOWN && sVNDepth2.compareTo(SVNDepth.FILES) <= 0) continue;
            boolean bl5 = bl4 = iSVNWCDb$WCDbBaseInfo.status == ISVNWCDb$SVNWCDbStatus.Incomplete;
            object3 = iSVNWCDb$WCDbBaseInfo.depth;
            if (!sVNDepth2.isRecursive()) {
                object3 = SVNDepth.EMPTY;
            }
            if (bl4 && iSVNWCDb$WCDbBaseInfo.revision < 0L) {
                iSVNWCDb$WCDbBaseInfo.revision = l2;
            }
            if (this.isUseDepthCompatibilityTrick && iSVNWCDb$WCDbBaseInfo.depth.compareTo(SVNDepth.FILES) <= 0 && sVNDepth2.compareTo(iSVNWCDb$WCDbBaseInfo.depth) > 0) {
                bl5 = true;
            }
            if (bl3) {
                if (n2 != 0) {
                    object2 = SVNWCUtils.join(sVNURL, iSVNWCDb$WCDbBaseInfo.reposRelPath);
                    iSVNReporter.linkPath((SVNURL)object2, string, iSVNWCDb$WCDbBaseInfo.lock != null ? iSVNWCDb$WCDbBaseInfo.lock.token : null, iSVNWCDb$WCDbBaseInfo.revision, (SVNDepth)object3, bl5);
                } else {
                    iSVNReporter.setPath(string, iSVNWCDb$WCDbBaseInfo.lock != null ? iSVNWCDb$WCDbBaseInfo.lock.token : null, iSVNWCDb$WCDbBaseInfo.revision, (SVNDepth)object3, bl5);
                }
            } else if (n2 != 0) {
                object2 = SVNWCUtils.join(sVNURL, iSVNWCDb$WCDbBaseInfo.reposRelPath);
                iSVNReporter.linkPath((SVNURL)object2, string, iSVNWCDb$WCDbBaseInfo.lock != null ? iSVNWCDb$WCDbBaseInfo.lock.token : null, iSVNWCDb$WCDbBaseInfo.revision, (SVNDepth)object3, bl5);
            } else if (iSVNWCDb$WCDbBaseInfo.revision != l2 || bl4 || iSVNWCDb$WCDbBaseInfo.lock != null || sVNDepth == SVNDepth.EMPTY || sVNDepth == SVNDepth.FILES || sVNDepth == SVNDepth.IMMEDIATES && iSVNWCDb$WCDbBaseInfo.depth != SVNDepth.EMPTY || iSVNWCDb$WCDbBaseInfo.depth.compareTo(SVNDepth.INFINITY) < 0 && sVNDepth2.isRecursive()) {
                iSVNReporter.setPath(string, iSVNWCDb$WCDbBaseInfo.lock != null ? iSVNWCDb$WCDbBaseInfo.lock.token : null, iSVNWCDb$WCDbBaseInfo.revision, (SVNDepth)object3, bl5);
            }
            if (!sVNDepth2.isRecursive()) continue;
            object2 = iSVNWCDb$WCDbBaseInfo.reposRelPath;
            if (object2 == null) {
                object2 = SVNFileUtil.createFilePath(file4, (String)object);
            }
            this.reportRevisionsAndDepths(sVNWCDbRoot, file5, SVNFileUtil.createFilePath(file2, (String)object), SVNFileUtil.createFilePath(string), iSVNWCDb$WCDbBaseInfo.revision, (File)object2, sVNURL, iSVNWCDb$WCDbBaseInfo.depth, iSVNReporter, bl2, sVNDepth2, bl5);
        }
    }

    private static void restoreFile(SVNWCContext sVNWCContext, File file, boolean bl2, boolean bl3) {
        SVNSkel sVNSkel = sVNWCContext.wqBuildFileInstall(file, null, bl2, true);
        sVNWCContext.getDb().addWorkQueue(file, sVNSkel);
        sVNWCContext.wqRun(file);
        if (bl3) {
            SVNReporter17.resolveTextConflict(sVNWCContext, file);
        }
    }

    private static void resolveTextConflict(SVNWCContext sVNWCContext, File file) {
        sVNWCContext.resolveConflictOnNode(file, true, false, SVNConflictChoice.MERGED);
    }
}

