/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumInputStream;
import org.tmatesoft.svn.core.internal.wc17.ISVNEditor2;
import org.tmatesoft.svn.core.internal.wc17.ISVNEditorProxyCallbacks;
import org.tmatesoft.svn.core.internal.wc17.SVNEditorProxy$ChangeNode;
import org.tmatesoft.svn.core.internal.wc17.SVNEditorProxy$DirectoryBaton;
import org.tmatesoft.svn.core.internal.wc17.SVNEditorProxy$FileBaton;
import org.tmatesoft.svn.core.internal.wc17.SVNEditorProxy$RestructureAction;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnChecksum$Kind;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNEditorProxy
implements ISVNEditor {
    private final ISVNEditor2 editor2;
    private final ISVNEditorProxyCallbacks proxyCallbacks;
    private SVNEditorProxy$DirectoryBaton currentDirectoryBaton;
    private SVNEditorProxy$FileBaton currentFileBaton;
    private InputStream source;
    private OutputStream target;
    private SVNDeltaProcessor svnDeltaProcessor;
    private boolean closed;
    private List pathOrder;
    private Map changes;
    private SVNURL repositoryRoot;
    private String baseRelPath;
    private File tempDirectory;

    public SVNEditorProxy(ISVNEditor2 iSVNEditor2, ISVNEditorProxyCallbacks iSVNEditorProxyCallbacks) {
        this.editor2 = iSVNEditor2;
        this.proxyCallbacks = iSVNEditorProxyCallbacks;
        this.svnDeltaProcessor = new SVNDeltaProcessor();
        this.tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        this.changes = new HashMap();
        this.pathOrder = new ArrayList();
    }

    public void setRepositoryRoot(SVNURL sVNURL) {
        this.repositoryRoot = sVNURL;
    }

    public void setBaseRelPath(String string) {
        this.baseRelPath = string;
    }

    public void setTempDirectory(File file) {
        this.tempDirectory = file;
    }

    @Override
    public void targetRevision(long l2) {
        this.proxyCallbacks.getExtraCallbacks().targetRevision(l2);
    }

    @Override
    public void openRoot(long l2) {
        SVNEditorProxy$DirectoryBaton sVNEditorProxy$DirectoryBaton = new SVNEditorProxy$DirectoryBaton(null);
        sVNEditorProxy$DirectoryBaton.path = "";
        this.proxyCallbacks.getExtraCallbacks().startEdit(l2);
        sVNEditorProxy$DirectoryBaton.parent = this.currentDirectoryBaton;
        this.currentDirectoryBaton = sVNEditorProxy$DirectoryBaton;
    }

    @Override
    public void deleteEntry(String string, long l2) {
        String string2 = this.mapToReposRelPath(string);
        SVNEditorProxy$ChangeNode sVNEditorProxy$ChangeNode = this.locateChange(string2);
        long l3 = SVNRevision.isValidRevisionNumber(l2) ? l2 : this.currentDirectoryBaton.baseRevision;
        assert (SVNEditorProxy$ChangeNode.access$100(sVNEditorProxy$ChangeNode) == SVNEditorProxy$RestructureAction.RESTRUCTURE_NONE);
        SVNEditorProxy$ChangeNode.access$102(sVNEditorProxy$ChangeNode, SVNEditorProxy$RestructureAction.RESTRUCTURE_DELETE);
        assert (!SVNRevision.isValidRevisionNumber(SVNEditorProxy$ChangeNode.access$200(sVNEditorProxy$ChangeNode)) || SVNEditorProxy$ChangeNode.access$200(sVNEditorProxy$ChangeNode) == l3);
        SVNEditorProxy$ChangeNode.access$202(sVNEditorProxy$ChangeNode, l3);
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        SVNEditorProxy$DirectoryBaton sVNEditorProxy$DirectoryBaton = new SVNEditorProxy$DirectoryBaton(null);
        String string3 = this.mapToReposRelPath(string);
        SVNEditorProxy$ChangeNode sVNEditorProxy$ChangeNode = this.locateChange(string3);
        SVNEditorProxy$ChangeNode.access$102(sVNEditorProxy$ChangeNode, SVNEditorProxy$RestructureAction.RESTRUCTURE_ADD);
        SVNEditorProxy$ChangeNode.access$302(sVNEditorProxy$ChangeNode, SVNNodeKind.DIR);
        sVNEditorProxy$DirectoryBaton.path = string3;
        sVNEditorProxy$DirectoryBaton.baseRevision = this.currentDirectoryBaton.baseRevision;
        if (string2 == null) {
            if (this.currentDirectoryBaton.copyFromRelPath != null) {
                String string4 = SVNPathUtil.tail(string3);
                sVNEditorProxy$DirectoryBaton.copyFromRelPath = SVNPathUtil.append(this.currentDirectoryBaton.copyFromRelPath, string4);
                sVNEditorProxy$DirectoryBaton.copyFromRevision = this.currentDirectoryBaton.copyFromRevision;
            }
        } else {
            SVNEditorProxy$ChangeNode.access$402(sVNEditorProxy$ChangeNode, this.mapToReposRelPath(string2));
            SVNEditorProxy$ChangeNode.access$502(sVNEditorProxy$ChangeNode, l2);
            sVNEditorProxy$DirectoryBaton.copyFromRelPath = SVNEditorProxy$ChangeNode.access$400(sVNEditorProxy$ChangeNode);
            sVNEditorProxy$DirectoryBaton.copyFromRevision = SVNEditorProxy$ChangeNode.access$500(sVNEditorProxy$ChangeNode);
        }
        sVNEditorProxy$DirectoryBaton.parent = this.currentDirectoryBaton;
        this.currentDirectoryBaton = sVNEditorProxy$DirectoryBaton;
    }

    @Override
    public void openDir(String string, long l2) {
        String string2;
        SVNEditorProxy$DirectoryBaton sVNEditorProxy$DirectoryBaton = new SVNEditorProxy$DirectoryBaton(null);
        sVNEditorProxy$DirectoryBaton.path = string2 = this.mapToReposRelPath(string);
        sVNEditorProxy$DirectoryBaton.baseRevision = l2;
        if (this.currentDirectoryBaton.copyFromRelPath != null) {
            String string3 = SVNPathUtil.tail(string2);
            sVNEditorProxy$DirectoryBaton.copyFromRelPath = SVNPathUtil.append(this.currentDirectoryBaton.copyFromRelPath, string3);
            sVNEditorProxy$DirectoryBaton.copyFromRevision = this.currentDirectoryBaton.copyFromRevision;
        }
        sVNEditorProxy$DirectoryBaton.parent = this.currentDirectoryBaton;
        this.currentDirectoryBaton = sVNEditorProxy$DirectoryBaton;
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        this.applyPropEdit(this.currentDirectoryBaton.path, SVNNodeKind.DIR, this.currentDirectoryBaton.baseRevision, string, sVNPropertyValue);
    }

    @Override
    public void closeDir() {
        this.currentDirectoryBaton = this.currentDirectoryBaton.parent;
    }

    @Override
    public void absentDir(String string) {
        String string2 = this.mapToReposRelPath(string);
        SVNEditorProxy$ChangeNode sVNEditorProxy$ChangeNode = this.locateChange(string2);
        SVNEditorProxy$ChangeNode.access$102(sVNEditorProxy$ChangeNode, SVNEditorProxy$RestructureAction.RESTRUCTURE_ADD_ABSENT);
        SVNEditorProxy$ChangeNode.access$302(sVNEditorProxy$ChangeNode, SVNNodeKind.DIR);
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        this.currentFileBaton = new SVNEditorProxy$FileBaton(null);
        String string3 = this.mapToReposRelPath(string);
        SVNEditorProxy$ChangeNode sVNEditorProxy$ChangeNode = this.locateChange(string3);
        SVNEditorProxy$ChangeNode.access$102(sVNEditorProxy$ChangeNode, SVNEditorProxy$RestructureAction.RESTRUCTURE_ADD);
        SVNEditorProxy$ChangeNode.access$302(sVNEditorProxy$ChangeNode, SVNNodeKind.FILE);
        this.currentFileBaton.path = string3;
        this.currentFileBaton.baseRevision = this.currentDirectoryBaton.baseRevision;
        if (string2 == null) {
            this.currentFileBaton.deltaBase = null;
        } else {
            SVNEditorProxy$ChangeNode.access$402(sVNEditorProxy$ChangeNode, this.mapToReposRelPath(string2));
            SVNEditorProxy$ChangeNode.access$502(sVNEditorProxy$ChangeNode, l2);
            this.currentFileBaton.deltaBase = this.proxyCallbacks.fetchBase(string2, l2);
        }
    }

    @Override
    public void openFile(String string, long l2) {
        String string2;
        this.currentFileBaton = new SVNEditorProxy$FileBaton(null);
        this.currentFileBaton.path = string2 = this.mapToReposRelPath(string);
        this.currentFileBaton.baseRevision = l2;
        if (this.currentDirectoryBaton.copyFromRelPath != null) {
            String string3 = SVNPathUtil.tail(string2);
            String string4 = SVNPathUtil.append(this.currentDirectoryBaton.copyFromRelPath, string3);
            this.currentFileBaton.deltaBase = this.proxyCallbacks.fetchBase(string4, this.currentDirectoryBaton.copyFromRevision);
        } else {
            this.currentFileBaton.deltaBase = this.proxyCallbacks.fetchBase(string2, l2);
        }
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        SVNEditorProxy$ChangeNode sVNEditorProxy$ChangeNode = this.locateChange(this.currentFileBaton.path);
        assert (!SVNEditorProxy$ChangeNode.access$700(sVNEditorProxy$ChangeNode));
        assert (SVNEditorProxy$ChangeNode.access$800(sVNEditorProxy$ChangeNode) == null);
        assert (!SVNRevision.isValidRevisionNumber(SVNEditorProxy$ChangeNode.access$900(sVNEditorProxy$ChangeNode)) || SVNEditorProxy$ChangeNode.access$900(sVNEditorProxy$ChangeNode) == this.currentFileBaton.baseRevision);
        SVNEditorProxy$ChangeNode.access$902(sVNEditorProxy$ChangeNode, this.currentFileBaton.baseRevision);
        this.source = this.currentFileBaton.deltaBase == null ? SVNFileUtil.DUMMY_IN : this.openDeltaBase(this.currentFileBaton);
        SVNEditorProxy$ChangeNode.access$702(sVNEditorProxy$ChangeNode, true);
        this.target = this.openDeltaTarget(this.currentFileBaton);
        SVNEditorProxy$ChangeNode.access$802(sVNEditorProxy$ChangeNode, this.currentFileBaton.deltaTarget);
        this.svnDeltaProcessor.applyTextDelta(this.source, this.target, true);
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        return this.svnDeltaProcessor.textDeltaChunk(sVNDiffWindow);
    }

    @Override
    public void textDeltaEnd(String string) {
        this.svnDeltaProcessor.textDeltaEnd();
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        if ("svn:entry:lock-token".equals(string2) && sVNPropertyValue == null) {
            String string3 = this.mapToReposRelPath(this.currentFileBaton.path);
            SVNEditorProxy$ChangeNode sVNEditorProxy$ChangeNode = this.locateChange(string3);
            SVNEditorProxy$ChangeNode.access$1002(sVNEditorProxy$ChangeNode, true);
        }
        this.applyPropEdit(this.currentFileBaton.path, SVNNodeKind.FILE, this.currentFileBaton.baseRevision, string2, sVNPropertyValue);
    }

    @Override
    public void closeFile(String string, String string2) {
        SVNFileUtil.closeFile(this.source);
        SVNFileUtil.closeFile(this.target);
        try {
            SVNFileUtil.deleteFile(this.currentFileBaton.deltaTarget);
        }
        catch (SVNException sVNException) {
            SVNDebugLog.getDefaultLog().log(SVNLogType.CLIENT, sVNException, Level.ALL);
        }
    }

    @Override
    public void absentFile(String string) {
        String string2 = this.mapToReposRelPath(string);
        SVNEditorProxy$ChangeNode sVNEditorProxy$ChangeNode = this.locateChange(string2);
        SVNEditorProxy$ChangeNode.access$102(sVNEditorProxy$ChangeNode, SVNEditorProxy$RestructureAction.RESTRUCTURE_ADD_ABSENT);
        SVNEditorProxy$ChangeNode.access$302(sVNEditorProxy$ChangeNode, SVNNodeKind.FILE);
    }

    @Override
    public SVNCommitInfo closeEdit() {
        this.runEv2Actions();
        this.closed = true;
        this.editor2.complete();
        return null;
    }

    @Override
    public void abortEdit() {
        this.runEv2Actions();
        if (!this.closed) {
            this.editor2.abort();
        }
    }

    private void applyPropEdit(String string, SVNNodeKind sVNNodeKind, long l2, String string2, SVNPropertyValue sVNPropertyValue) {
        SVNEditorProxy$ChangeNode sVNEditorProxy$ChangeNode = this.locateChange(string);
        assert (SVNEditorProxy$ChangeNode.access$300(sVNEditorProxy$ChangeNode) == SVNNodeKind.UNKNOWN || SVNEditorProxy$ChangeNode.access$300(sVNEditorProxy$ChangeNode) == sVNNodeKind);
        SVNEditorProxy$ChangeNode.access$302(sVNEditorProxy$ChangeNode, sVNNodeKind);
        assert (!SVNRevision.isValidRevisionNumber(SVNEditorProxy$ChangeNode.access$900(sVNEditorProxy$ChangeNode)) || SVNEditorProxy$ChangeNode.access$900(sVNEditorProxy$ChangeNode) == l2);
        SVNEditorProxy$ChangeNode.access$902(sVNEditorProxy$ChangeNode, l2);
        if (SVNEditorProxy$ChangeNode.access$1100(sVNEditorProxy$ChangeNode) == null) {
            if (SVNEditorProxy$ChangeNode.access$400(sVNEditorProxy$ChangeNode) != null) {
                SVNEditorProxy$ChangeNode.access$1102(sVNEditorProxy$ChangeNode, this.proxyCallbacks.fetchProperties(SVNEditorProxy$ChangeNode.access$400(sVNEditorProxy$ChangeNode), SVNEditorProxy$ChangeNode.access$500(sVNEditorProxy$ChangeNode)));
            } else if (SVNEditorProxy$ChangeNode.access$100(sVNEditorProxy$ChangeNode) == SVNEditorProxy$RestructureAction.RESTRUCTURE_ADD) {
                SVNEditorProxy$ChangeNode.access$1102(sVNEditorProxy$ChangeNode, new SVNProperties());
            } else {
                SVNEditorProxy$ChangeNode.access$1102(sVNEditorProxy$ChangeNode, this.proxyCallbacks.fetchProperties(string, l2));
            }
        }
        if (SVNEditorProxy$ChangeNode.access$1100(sVNEditorProxy$ChangeNode) == null) {
            SVNEditorProxy$ChangeNode.access$1102(sVNEditorProxy$ChangeNode, new SVNProperties());
        }
        if (sVNPropertyValue == null) {
            SVNEditorProxy$ChangeNode.access$1100(sVNEditorProxy$ChangeNode).put(string2, (SVNPropertyValue)null);
        } else {
            SVNEditorProxy$ChangeNode.access$1100(sVNEditorProxy$ChangeNode).put(string2, sVNPropertyValue);
        }
    }

    private void runEv2Actions() {
        for (String string : this.pathOrder) {
            SVNEditorProxy$ChangeNode sVNEditorProxy$ChangeNode = (SVNEditorProxy$ChangeNode)this.changes.get(string);
            this.processAction(string, sVNEditorProxy$ChangeNode);
        }
    }

    private void processAction(String string, SVNEditorProxy$ChangeNode sVNEditorProxy$ChangeNode) {
        SVNProperties sVNProperties = null;
        InputStream inputStream = null;
        SVNNodeKind sVNNodeKind = SVNNodeKind.UNKNOWN;
        SvnChecksum svnChecksum = null;
        if (SVNEditorProxy$ChangeNode.access$1000(sVNEditorProxy$ChangeNode)) {
            this.proxyCallbacks.unlock(string);
        }
        if (SVNEditorProxy$ChangeNode.access$100(sVNEditorProxy$ChangeNode) == SVNEditorProxy$RestructureAction.RESTRUCTURE_DELETE) {
            this.editor2.delete(string, SVNEditorProxy$ChangeNode.access$200(sVNEditorProxy$ChangeNode));
            return;
        }
        if (SVNEditorProxy$ChangeNode.access$100(sVNEditorProxy$ChangeNode) == SVNEditorProxy$RestructureAction.RESTRUCTURE_ADD_ABSENT) {
            this.editor2.addAbsent(string, SVNEditorProxy$ChangeNode.access$300(sVNEditorProxy$ChangeNode), SVNEditorProxy$ChangeNode.access$200(sVNEditorProxy$ChangeNode));
        }
        if (SVNEditorProxy$ChangeNode.access$700(sVNEditorProxy$ChangeNode)) {
            sVNNodeKind = SVNNodeKind.FILE;
            if (SVNEditorProxy$ChangeNode.access$800(sVNEditorProxy$ChangeNode) != null) {
                svnChecksum = this.fileChecksum(SVNEditorProxy$ChangeNode.access$800(sVNEditorProxy$ChangeNode), SvnChecksum$Kind.sha1);
                inputStream = SVNFileUtil.openFileForReading(SVNEditorProxy$ChangeNode.access$800(sVNEditorProxy$ChangeNode));
            } else {
                inputStream = SVNFileUtil.DUMMY_IN;
                svnChecksum = new SvnChecksum(SvnChecksum$Kind.sha1, "da39a3ee5e6b4b0d3255bfef95601890afd80709");
            }
        }
        if (SVNEditorProxy$ChangeNode.access$1100(sVNEditorProxy$ChangeNode) != null) {
            sVNNodeKind = SVNEditorProxy$ChangeNode.access$300(sVNEditorProxy$ChangeNode);
            sVNProperties = SVNEditorProxy$ChangeNode.access$1100(sVNEditorProxy$ChangeNode);
        }
        if (SVNEditorProxy$ChangeNode.access$100(sVNEditorProxy$ChangeNode) == SVNEditorProxy$RestructureAction.RESTRUCTURE_ADD) {
            long l2 = SVNEditorProxy$ChangeNode.access$200(sVNEditorProxy$ChangeNode);
            sVNNodeKind = SVNEditorProxy$ChangeNode.access$300(sVNEditorProxy$ChangeNode);
            if (SVNEditorProxy$ChangeNode.access$400(sVNEditorProxy$ChangeNode) != null) {
                this.editor2.copy(SVNEditorProxy$ChangeNode.access$400(sVNEditorProxy$ChangeNode), SVNEditorProxy$ChangeNode.access$500(sVNEditorProxy$ChangeNode), string, l2);
            } else {
                if (sVNProperties == null) {
                    sVNProperties = new SVNProperties();
                }
                if (sVNNodeKind == SVNNodeKind.DIR) {
                    List list = this.getChildren(string);
                    this.editor2.addDir(string, list, sVNProperties, l2);
                } else {
                    if (SVNEditorProxy$ChangeNode.access$800(sVNEditorProxy$ChangeNode) == null) {
                        inputStream = SVNFileUtil.DUMMY_IN;
                        svnChecksum = new SvnChecksum(SvnChecksum$Kind.sha1, "da39a3ee5e6b4b0d3255bfef95601890afd80709");
                    }
                    this.editor2.addFile(string, svnChecksum, inputStream, sVNProperties, l2);
                }
            }
        }
        if (sVNProperties != null || inputStream != null) {
            if (sVNNodeKind == SVNNodeKind.DIR) {
                this.editor2.alterDir(string, SVNEditorProxy$ChangeNode.access$900(sVNEditorProxy$ChangeNode), null, sVNProperties);
            } else {
                this.editor2.alterFile(string, SVNEditorProxy$ChangeNode.access$900(sVNEditorProxy$ChangeNode), sVNProperties, svnChecksum, inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SvnChecksum fileChecksum(File file, SvnChecksum$Kind svnChecksum$Kind) {
        SVNChecksumInputStream sVNChecksumInputStream = new SVNChecksumInputStream(SVNFileUtil.openFileForReading(file), svnChecksum$Kind.name());
        try {
            byte[] byArray = new byte[2048];
            while (true) {
                int n2;
                if ((n2 = sVNChecksumInputStream.read(byArray)) < 0) {
                    SvnChecksum svnChecksum = new SvnChecksum(svnChecksum$Kind, sVNChecksumInputStream.getDigest());
                    return svnChecksum;
                }
                continue;
                break;
            }
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.CLIENT);
            return null;
        }
        finally {
            SVNFileUtil.closeFile(sVNChecksumInputStream);
        }
    }

    private List getChildren(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry entry : this.changes.entrySet()) {
            String string2 = (String)entry.getKey();
            String string3 = SVNPathUtil.getPathAsChild(string, string2);
            if (string3 == null || string3.length() == 0 || string3.indexOf(47) >= 0) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    private SVNEditorProxy$ChangeNode locateChange(String string) {
        SVNEditorProxy$ChangeNode sVNEditorProxy$ChangeNode = (SVNEditorProxy$ChangeNode)this.changes.get(string);
        if (sVNEditorProxy$ChangeNode != null) {
            return sVNEditorProxy$ChangeNode;
        }
        this.pathOrder.add(string);
        sVNEditorProxy$ChangeNode = new SVNEditorProxy$ChangeNode(null);
        SVNEditorProxy$ChangeNode.access$902(sVNEditorProxy$ChangeNode, -1L);
        SVNEditorProxy$ChangeNode.access$202(sVNEditorProxy$ChangeNode, -1L);
        SVNEditorProxy$ChangeNode.access$302(sVNEditorProxy$ChangeNode, SVNNodeKind.UNKNOWN);
        this.changes.put(string, sVNEditorProxy$ChangeNode);
        return sVNEditorProxy$ChangeNode;
    }

    private String mapToReposRelPath(String string) {
        if (SVNPathUtil.isURL(string)) {
            return SVNPathUtil.getPathAsChild(SVNEncodingUtil.uriDecode(string), this.repositoryRoot.toDecodedString());
        }
        return SVNPathUtil.append(this.baseRelPath, string.startsWith("/") ? string.substring("/".length()) : string);
    }

    private InputStream openDeltaBase(SVNEditorProxy$FileBaton sVNEditorProxy$FileBaton) {
        return SVNFileUtil.openFileForReading(sVNEditorProxy$FileBaton.deltaBase);
    }

    private OutputStream openDeltaTarget(SVNEditorProxy$FileBaton sVNEditorProxy$FileBaton) {
        sVNEditorProxy$FileBaton.deltaTarget = SVNFileUtil.createUniqueFile(this.tempDirectory, "editor", ".tmp", false);
        return SVNFileUtil.openFileForWriting(sVNEditorProxy$FileBaton.deltaTarget);
    }
}

