/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumInputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumOutputStream;
import org.tmatesoft.svn.core.internal.wc17.SVNCommitter17$CopyingStream;
import org.tmatesoft.svn.core.internal.wc17.SVNCommitter17$TransmittedChecksums;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$PristineContentsInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$WritableBaseInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbInfo$InfoField;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnChecksum$Kind;
import org.tmatesoft.svn.core.wc2.SvnCommitItem;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCommitter17
implements ISVNCommitPathHandler {
    private SVNWCContext myContext;
    private Map myCommittables;
    private SVNURL myRepositoryRoot;
    private Map myMd5Checksums;
    private Map mySha1Checksums;
    private Map myModifiedFiles;
    private SVNDeltaGenerator myDeltaGenerator;
    private Collection deletedPaths;

    public SVNCommitter17(SVNWCContext sVNWCContext, Map map, SVNURL sVNURL, Collection collection, Map map2, Map map3) {
        this.myContext = sVNWCContext;
        this.myCommittables = map;
        this.myRepositoryRoot = sVNURL;
        this.myMd5Checksums = map2;
        this.mySha1Checksums = map3;
        this.myModifiedFiles = new TreeMap();
        this.deletedPaths = new TreeSet();
    }

    public static SVNCommitInfo commit(SVNWCContext sVNWCContext, Collection collection, Map map, SVNURL sVNURL, ISVNEditor iSVNEditor, Map map2, Map map3) {
        SVNCommitter17 sVNCommitter17 = new SVNCommitter17(sVNWCContext, map, sVNURL, collection, map2, map3);
        SVNCommitUtil.driveCommitEditor(sVNCommitter17, map.keySet(), iSVNEditor, -1L);
        sVNCommitter17.sendTextDeltas(iSVNEditor);
        return iSVNEditor.closeEdit();
    }

    public Collection getDeletedPaths() {
        return this.deletedPaths;
    }

    @Override
    public boolean handleCommitPath(String string, ISVNEditor iSVNEditor) {
        Object object;
        SvnCommitItem svnCommitItem = (SvnCommitItem)this.myCommittables.get(string);
        this.myContext.checkCancelled();
        if (svnCommitItem.hasFlag(16)) {
            SVNErrorMessage sVNErrorMessage;
            if (svnCommitItem.getCopyFromUrl() == null) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Commit item ''{0}'' has copy flag but no copyfrom URL", (Object)svnCommitItem.getPath());
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            } else if (svnCommitItem.getCopyFromRevision() < 0L) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Commit item ''{0}'' has copy flag but an invalid revision", (Object)svnCommitItem.getPath());
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
        }
        boolean bl2 = false;
        File file = null;
        if (svnCommitItem.getKind() != SVNNodeKind.NONE && svnCommitItem.getPath() != null) {
            file = svnCommitItem.getPath();
        }
        long l2 = svnCommitItem.getRevision();
        SVNEvent sVNEvent = null;
        if (svnCommitItem.hasFlag(1) && svnCommitItem.hasFlag(2)) {
            sVNEvent = SVNEventFactory.createSVNEvent(file, svnCommitItem.getKind(), null, -1L, SVNEventAction.COMMIT_REPLACED, null, null, null);
            sVNEvent.setPreviousRevision(l2);
        } else if (svnCommitItem.hasFlag(2)) {
            sVNEvent = SVNEventFactory.createSVNEvent(file, svnCommitItem.getKind(), null, -1L, SVNEventAction.COMMIT_DELETED, null, null, null);
            sVNEvent.setPreviousRevision(l2);
        } else if (svnCommitItem.hasFlag(1)) {
            object = null;
            if (svnCommitItem.getKind() == SVNNodeKind.FILE && file != null) {
                object = this.myContext.getProperty(file, "svn:mime-type");
            }
            sVNEvent = SVNEventFactory.createSVNEvent(file, svnCommitItem.getKind(), (String)object, -1L, SVNEventAction.COMMIT_ADDED, null, null, null);
            sVNEvent.setPreviousRevision(svnCommitItem.getCopyFromRevision() >= 0L ? svnCommitItem.getCopyFromRevision() : -1L);
            sVNEvent.setPreviousURL(svnCommitItem.getCopyFromUrl());
        } else if (svnCommitItem.hasFlag(4) || svnCommitItem.hasFlag(8)) {
            object = SVNStatusType.UNCHANGED;
            if (svnCommitItem.hasFlag(4)) {
                object = SVNStatusType.CHANGED;
            }
            SVNStatusType sVNStatusType = SVNStatusType.UNCHANGED;
            if (svnCommitItem.hasFlag(8)) {
                sVNStatusType = SVNStatusType.CHANGED;
            }
            sVNEvent = SVNEventFactory.createSVNEvent(file, svnCommitItem.getKind(), null, -1L, (SVNStatusType)object, sVNStatusType, null, SVNEventAction.COMMIT_MODIFIED, null, null, null);
            sVNEvent.setPreviousRevision(l2);
        }
        if (sVNEvent != null) {
            sVNEvent.setURL(svnCommitItem.getUrl());
            if (this.myContext.getEventHandler() != null) {
                this.myContext.getEventHandler().handleEvent(sVNEvent, -1.0);
            }
        }
        if (svnCommitItem.hasFlag(2)) {
            try {
                iSVNEditor.deleteEntry(string, l2);
            }
            catch (SVNException sVNException) {
                this.fixError(file, string, sVNException, svnCommitItem.getKind());
            }
            if (!svnCommitItem.hasFlag(1)) {
                this.deletedPaths.add(file);
            }
        }
        long l3 = svnCommitItem.getCopyFromRevision();
        Map map = svnCommitItem.getOutgoingProperties();
        boolean bl3 = false;
        if (svnCommitItem.hasFlag(1)) {
            String string2 = this.getCopyFromPath(svnCommitItem.getCopyFromUrl());
            if (svnCommitItem.getKind() == SVNNodeKind.FILE) {
                iSVNEditor.addFile(string, string2, l3);
                bl3 = true;
            } else {
                iSVNEditor.addDir(string, string2, l3);
                bl2 = true;
            }
            if (map != null) {
                for (Object object2 : map.keySet()) {
                    SVNPropertyValue sVNPropertyValue = (SVNPropertyValue)map.get(object2);
                    if (svnCommitItem.getKind() == SVNNodeKind.FILE) {
                        iSVNEditor.changeFileProperty(string, (String)object2, sVNPropertyValue);
                        continue;
                    }
                    iSVNEditor.changeDirProperty((String)object2, sVNPropertyValue);
                }
                map = null;
            }
        }
        if (svnCommitItem.hasFlag(8)) {
            if (svnCommitItem.getKind() == SVNNodeKind.FILE) {
                if (!bl3) {
                    try {
                        iSVNEditor.openFile(string, l2);
                    }
                    catch (SVNException sVNException) {
                        this.fixError(file, string, sVNException, SVNNodeKind.FILE);
                    }
                }
                bl3 = true;
            } else if (!svnCommitItem.hasFlag(1)) {
                try {
                    if ("".equals(string)) {
                        iSVNEditor.openRoot(l2);
                    } else {
                        iSVNEditor.openDir(string, l2);
                    }
                }
                catch (SVNException sVNException) {
                    this.fixError(file, string, sVNException, SVNNodeKind.DIR);
                }
                bl2 = true;
            }
            if (svnCommitItem.hasFlag(8)) {
                try {
                    this.sendPropertiesDelta(file, string, svnCommitItem, iSVNEditor);
                }
                catch (SVNException sVNException) {
                    this.fixError(file, string, sVNException, svnCommitItem.getKind());
                }
            }
            if (map != null) {
                for (Object object3 : map.keySet()) {
                    Object object2;
                    object2 = (SVNPropertyValue)map.get(object3);
                    if (svnCommitItem.getKind() == SVNNodeKind.FILE) {
                        iSVNEditor.changeFileProperty(string, (String)object3, (SVNPropertyValue)object2);
                        continue;
                    }
                    iSVNEditor.changeDirProperty((String)object3, (SVNPropertyValue)object2);
                }
            }
        }
        if (svnCommitItem.hasFlag(4) && svnCommitItem.getKind() == SVNNodeKind.FILE) {
            if (!bl3) {
                try {
                    iSVNEditor.openFile(string, l2);
                }
                catch (SVNException sVNException) {
                    this.fixError(file, string, sVNException, SVNNodeKind.FILE);
                }
            }
            this.myModifiedFiles.put(string, svnCommitItem);
        } else if (bl3) {
            try {
                iSVNEditor.closeFile(string, null);
            }
            catch (SVNException sVNException) {
                this.fixError(file, string, sVNException, SVNNodeKind.FILE);
            }
        }
        return bl2;
    }

    private void fixError(File file, String string, SVNException sVNException, SVNNodeKind sVNNodeKind) {
        SVNErrorMessage sVNErrorMessage = sVNException.getErrorMessage();
        if (sVNErrorMessage.getErrorCode() == SVNErrorCode.FS_NOT_FOUND || sVNErrorMessage.getErrorCode() == SVNErrorCode.FS_ALREADY_EXISTS || sVNErrorMessage.getErrorCode() == SVNErrorCode.FS_TXN_OUT_OF_DATE || sVNErrorMessage.getErrorCode() == SVNErrorCode.RA_DAV_PATH_NOT_FOUND || sVNErrorMessage.getErrorCode() == SVNErrorCode.RA_DAV_ALREADY_EXISTS || sVNErrorMessage.hasChildWithErrorCode(SVNErrorCode.RA_OUT_OF_DATE)) {
            SVNEvent sVNEvent;
            if (this.myContext.getEventHandler() != null && (sVNEvent = file != null ? SVNEventFactory.createSVNEvent(file, sVNNodeKind, null, -1L, SVNEventAction.FAILED_OUT_OF_DATE, null, sVNErrorMessage, null) : null) != null) {
                this.myContext.getEventHandler().handleEvent(sVNEvent, -1.0);
            }
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_UP_TO_DATE, sVNNodeKind == SVNNodeKind.DIR ? "Directory ''{0}'' is out of date" : "File ''{0}'' is out of date", (Object)file);
            throw new SVNException(sVNErrorMessage);
        }
        if (sVNErrorMessage.hasChildWithErrorCode(SVNErrorCode.FS_NO_LOCK_TOKEN) || sVNErrorMessage.getErrorCode() == SVNErrorCode.FS_LOCK_OWNER_MISMATCH || sVNErrorMessage.getErrorCode() == SVNErrorCode.RA_NOT_LOCKED) {
            SVNEvent sVNEvent;
            if (this.myContext.getEventHandler() != null && (sVNEvent = file != null ? SVNEventFactory.createSVNEvent(file, sVNNodeKind, null, -1L, SVNEventAction.FAILED_LOCKED, null, sVNErrorMessage, null) : null) != null) {
                this.myContext.getEventHandler().handleEvent(sVNEvent, -1.0);
            }
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_NO_LOCK_TOKEN, sVNNodeKind == SVNNodeKind.DIR ? "Directory ''{0}'' is locked in another working copy" : "File ''{0}'' is locked in another working copy", (Object)file);
            throw new SVNException(sVNErrorMessage);
        }
        if ((sVNErrorMessage.hasChildWithErrorCode(SVNErrorCode.RA_DAV_FORBIDDEN) || sVNErrorMessage.getErrorCode() == SVNErrorCode.AUTHZ_UNWRITABLE) && this.myContext.getEventHandler() != null) {
            SVNEvent sVNEvent = file != null ? SVNEventFactory.createSVNEvent(file, sVNNodeKind, null, -1L, SVNEventAction.FAILED_FORBIDDEN_BY_SERVER, null, sVNErrorMessage, null) : null;
            if (sVNEvent != null) {
                this.myContext.getEventHandler().handleEvent(sVNEvent, -1.0);
            }
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_FORBIDDEN_BY_SERVER, sVNNodeKind == SVNNodeKind.DIR ? "Changing directory ''{0}'' is forbidden by the server" : "Changing file ''{0}'' is forbidden by the server", (Object)file);
            throw new SVNException(sVNErrorMessage);
        }
        throw sVNException;
    }

    private String getCopyFromPath(SVNURL sVNURL) {
        if (sVNURL == null) {
            return null;
        }
        String string = sVNURL.getPath();
        if (this.myRepositoryRoot.getPath().equals(string)) {
            return "/";
        }
        return string.substring(this.myRepositoryRoot.getPath().length());
    }

    private void sendPropertiesDelta(File file, String string, SvnCommitItem svnCommitItem, ISVNEditor iSVNEditor) {
        SVNNodeKind sVNNodeKind = this.myContext.readKind(file, false);
        SVNProperties sVNProperties = this.myContext.getPropDiffs((File)file).propChanges;
        for (Object e2 : sVNProperties.nameSet()) {
            String string2 = (String)e2;
            SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string2);
            if (sVNNodeKind == SVNNodeKind.FILE) {
                iSVNEditor.changeFileProperty(string, string2, sVNPropertyValue);
                continue;
            }
            iSVNEditor.changeDirProperty(string2, sVNPropertyValue);
        }
    }

    public void sendTextDeltas(ISVNEditor iSVNEditor) {
        for (String string : this.myModifiedFiles.keySet()) {
            SvnCommitItem svnCommitItem = (SvnCommitItem)this.myModifiedFiles.get(string);
            this.myContext.checkCancelled();
            File file = svnCommitItem.getPath();
            if (this.myContext.getEventHandler() != null) {
                SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, null, -1L, SVNEventAction.COMMIT_DELTA_SENT, null, null, null);
                this.myContext.getEventHandler().handleEvent(sVNEvent, -1.0);
            }
            boolean bl2 = svnCommitItem.hasFlag(1);
            SVNCommitter17$TransmittedChecksums sVNCommitter17$TransmittedChecksums = this.transmitTextDeltas(string, file, bl2, iSVNEditor);
            SvnChecksum svnChecksum = sVNCommitter17$TransmittedChecksums.md5Checksum;
            SvnChecksum svnChecksum2 = sVNCommitter17$TransmittedChecksums.sha1Checksum;
            if (this.myMd5Checksums != null) {
                this.myMd5Checksums.put(file, svnChecksum);
            }
            if (this.mySha1Checksums == null) continue;
            this.mySha1Checksums.put(file, svnChecksum2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNCommitter17$TransmittedChecksums transmitTextDeltas(String string, File file, boolean bl2, ISVNEditor iSVNEditor) {
        Object object;
        Object object2;
        InputStream inputStream = SVNFileUtil.DUMMY_IN;
        InputStream inputStream2 = SVNFileUtil.DUMMY_IN;
        SvnChecksum svnChecksum = null;
        SvnChecksum svnChecksum2 = null;
        SvnChecksum svnChecksum3 = null;
        SVNChecksumOutputStream sVNChecksumOutputStream = null;
        SVNChecksumInputStream sVNChecksumInputStream = null;
        SVNErrorMessage sVNErrorMessage = null;
        File file2 = null;
        try {
            inputStream = this.myContext.getTranslatedStream(file, file, true, false);
            object2 = this.myContext.openWritableBase(file, false, true);
            object = ((SVNWCContext$WritableBaseInfo)object2).stream;
            file2 = ((SVNWCContext$WritableBaseInfo)object2).tempBaseAbspath;
            sVNChecksumOutputStream = ((SVNWCContext$WritableBaseInfo)object2).sha1ChecksumStream;
            inputStream = new SVNCommitter17$CopyingStream(this, (OutputStream)object, inputStream);
            File file3 = null;
            if (!bl2) {
                SVNWCContext$PristineContentsInfo sVNWCContext$PristineContentsInfo = this.myContext.getPristineContents(file, true, true);
                file3 = sVNWCContext$PristineContentsInfo.path;
                inputStream2 = sVNWCContext$PristineContentsInfo.stream;
                if (inputStream2 == null) {
                    inputStream2 = SVNFileUtil.DUMMY_IN;
                }
                if ((svnChecksum = this.myContext.getDb().readInfo((File)file, (ISVNWCDb$WCDbInfo$InfoField[])new ISVNWCDb$WCDbInfo$InfoField[]{ISVNWCDb$WCDbInfo$InfoField.checksum}).checksum) != null && svnChecksum.getKind() != SvnChecksum$Kind.md5) {
                    svnChecksum = this.myContext.getDb().getPristineMD5(file, svnChecksum);
                }
                if (svnChecksum != null) {
                    sVNChecksumInputStream = new SVNChecksumInputStream(inputStream2, "MD5");
                    inputStream2 = sVNChecksumInputStream;
                } else {
                    svnChecksum = new SvnChecksum(SvnChecksum$Kind.md5, SVNFileUtil.computeChecksum(file3));
                }
            }
            iSVNEditor.applyTextDelta(string, svnChecksum != null ? svnChecksum.getDigest() : null);
            if (this.myDeltaGenerator == null) {
                this.myDeltaGenerator = new SVNDeltaGenerator();
            }
            svnChecksum2 = new SvnChecksum(SvnChecksum$Kind.md5, this.myDeltaGenerator.sendDelta(string, inputStream2, 0L, inputStream, iSVNEditor, true));
            if (sVNChecksumInputStream != null) {
                this.readRemainingStream(sVNChecksumInputStream, file3);
                svnChecksum3 = new SvnChecksum(SvnChecksum$Kind.md5, sVNChecksumInputStream.getDigest());
            }
        }
        catch (SVNException sVNException) {
            sVNErrorMessage = sVNException.getErrorMessage().wrap("While preparing ''{0}'' for commit", file);
        }
        finally {
            SVNFileUtil.closeFile(inputStream);
            SVNFileUtil.closeFile(inputStream2);
        }
        if (svnChecksum != null && svnChecksum3 != null && !svnChecksum.equals(svnChecksum3)) {
            object2 = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''; expected: ''{1}'', actual: ''{2}''", file, svnChecksum.getDigest(), svnChecksum3.getDigest());
            object = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE);
            SVNErrorManager.error((SVNErrorMessage)object, (SVNErrorMessage)object2, SVNLogType.WC);
        }
        if (sVNErrorMessage != null) {
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        try {
            iSVNEditor.closeFile(string, svnChecksum2 != null ? svnChecksum2.getDigest() : null);
        }
        catch (SVNException sVNException) {
            this.fixError(file, string, sVNException, SVNNodeKind.FILE);
        }
        object2 = new SvnChecksum(SvnChecksum$Kind.sha1, sVNChecksumOutputStream.getDigest());
        this.myContext.getDb().installPristine(file2, (SvnChecksum)object2, svnChecksum2);
        object = new SVNCommitter17$TransmittedChecksums();
        ((SVNCommitter17$TransmittedChecksums)object).md5Checksum = svnChecksum2;
        ((SVNCommitter17$TransmittedChecksums)object).sha1Checksum = object2;
        return object;
    }

    private void readRemainingStream(SVNChecksumInputStream sVNChecksumInputStream, File file) {
        int n2;
        byte[] byArray = new byte[1024];
        do {
            try {
                n2 = sVNChecksumInputStream.read(byArray);
            }
            catch (IOException iOException) {
                SVNErrorMessage sVNErrorMessage = file != null ? SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read from file ''{0}'': {1}", file, iOException.getMessage()) : SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read from stream: {0}", file, iOException.getMessage());
                SVNErrorManager.error(sVNErrorMessage, Level.FINE, SVNLogType.WC);
                return;
            }
        } while (n2 >= 0);
    }
}

