/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import java.io.OutputStream;
import java.util.LinkedList;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNAmbientDepthFilterEditor17$AmbientReadInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNAmbientDepthFilterEditor17$DirBaton;
import org.tmatesoft.svn.core.internal.wc17.SVNAmbientDepthFilterEditor17$FileBaton;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo$BaseInfoField;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbInfo$InfoField;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAmbientDepthFilterEditor17
implements ISVNUpdateEditor {
    private ISVNEditor myDelegate;
    private SVNWCContext myWcContext;
    private File myAnchor;
    private String myTarget;
    private boolean myReadBase;
    private LinkedList myDirs;
    private SVNAmbientDepthFilterEditor17$DirBaton myCurrentDirBaton;
    private SVNAmbientDepthFilterEditor17$FileBaton myCurrentFileBaton;

    public SVNAmbientDepthFilterEditor17(ISVNUpdateEditor iSVNUpdateEditor, SVNWCContext sVNWCContext, File file, String string, boolean bl2) {
        this.myDelegate = iSVNUpdateEditor;
        this.myWcContext = sVNWCContext;
        this.myAnchor = file;
        this.myTarget = string;
        this.myReadBase = bl2;
        this.myDirs = new LinkedList();
    }

    public static ISVNEditor wrap(SVNWCContext sVNWCContext, File file, String string, ISVNUpdateEditor iSVNUpdateEditor, boolean bl2) {
        if (!bl2) {
            return new SVNAmbientDepthFilterEditor17(iSVNUpdateEditor, sVNWCContext, file, string, true);
        }
        return iSVNUpdateEditor;
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.applyTextDelta(string, string2);
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return SVNFileUtil.DUMMY_OUT;
        }
        return this.myDelegate.textDeltaChunk(string, sVNDiffWindow);
    }

    @Override
    public void textDeltaEnd(String string) {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.textDeltaEnd(string);
    }

    @Override
    public void targetRevision(long l2) {
        this.myDelegate.targetRevision(l2);
    }

    @Override
    public void openRoot(long l2) {
        this.myCurrentDirBaton = this.makeDirBaton(null, null);
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        if (this.myTarget == null || "".equals(this.myTarget)) {
            SVNAmbientDepthFilterEditor17$AmbientReadInfo sVNAmbientDepthFilterEditor17$AmbientReadInfo = this.ambientReadInfo(this.myAnchor, this.myReadBase);
            if (sVNAmbientDepthFilterEditor17$AmbientReadInfo.kind != ISVNWCDb$SVNWCDbKind.Unknown && !sVNAmbientDepthFilterEditor17$AmbientReadInfo.hidden) {
                this.myCurrentDirBaton.myAmbientDepth = sVNAmbientDepthFilterEditor17$AmbientReadInfo.depth;
            }
        }
        this.myDelegate.openRoot(l2);
    }

    @Override
    public void deleteEntry(String string, long l2) {
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        if (this.myCurrentDirBaton.myAmbientDepth.compareTo(SVNDepth.IMMEDIATES) < 0) {
            File file = SVNFileUtil.createFilePath(this.myAnchor, SVNWCUtils.getPathAsChild(this.myAnchor, SVNFileUtil.createFilePath(string)));
            SVNAmbientDepthFilterEditor17$AmbientReadInfo sVNAmbientDepthFilterEditor17$AmbientReadInfo = this.ambientReadInfo(file, this.myReadBase);
            if (sVNAmbientDepthFilterEditor17$AmbientReadInfo.kind == ISVNWCDb$SVNWCDbKind.Unknown || sVNAmbientDepthFilterEditor17$AmbientReadInfo.hidden) {
                return;
            }
        }
        this.myDelegate.deleteEntry(string, l2);
    }

    @Override
    public void absentDir(String string) {
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.absentDir(string);
    }

    @Override
    public void absentFile(String string) {
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.absentFile(string);
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        SVNAmbientDepthFilterEditor17$DirBaton sVNAmbientDepthFilterEditor17$DirBaton = this.myCurrentDirBaton;
        this.myCurrentDirBaton = this.makeDirBaton(string, sVNAmbientDepthFilterEditor17$DirBaton);
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myCurrentDirBaton.myAmbientDepth = string.equals(this.myTarget) ? SVNDepth.INFINITY : (sVNAmbientDepthFilterEditor17$DirBaton.myAmbientDepth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : SVNDepth.INFINITY);
        this.myDelegate.addDir(string, string2, l2);
    }

    @Override
    public void openDir(String string, long l2) {
        SVNAmbientDepthFilterEditor17$DirBaton sVNAmbientDepthFilterEditor17$DirBaton = this.myCurrentDirBaton;
        this.myCurrentDirBaton = this.makeDirBaton(string, sVNAmbientDepthFilterEditor17$DirBaton);
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.openDir(string, l2);
        File file = SVNFileUtil.createFilePath(this.myAnchor, SVNWCUtils.skipAncestor(this.myAnchor, SVNFileUtil.createFilePath(string)));
        SVNAmbientDepthFilterEditor17$AmbientReadInfo sVNAmbientDepthFilterEditor17$AmbientReadInfo = this.ambientReadInfo(file, this.myReadBase);
        if (sVNAmbientDepthFilterEditor17$AmbientReadInfo.kind != ISVNWCDb$SVNWCDbKind.Unknown && !sVNAmbientDepthFilterEditor17$AmbientReadInfo.hidden) {
            this.myCurrentDirBaton.myAmbientDepth = sVNAmbientDepthFilterEditor17$AmbientReadInfo.depth;
        }
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.changeDirProperty(string, sVNPropertyValue);
    }

    @Override
    public void closeDir() {
        SVNAmbientDepthFilterEditor17$DirBaton sVNAmbientDepthFilterEditor17$DirBaton = (SVNAmbientDepthFilterEditor17$DirBaton)this.myDirs.removeLast();
        this.myCurrentDirBaton = this.myDirs.isEmpty() ? null : (SVNAmbientDepthFilterEditor17$DirBaton)this.myDirs.getLast();
        if (sVNAmbientDepthFilterEditor17$DirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.closeDir();
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        this.myCurrentFileBaton = this.makeFileBaton(this.myCurrentDirBaton, string);
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.addFile(string, string2, l2);
    }

    @Override
    public void openFile(String string, long l2) {
        this.myCurrentFileBaton = this.makeFileBaton(this.myCurrentDirBaton, string);
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.openFile(string, l2);
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.changeFileProperty(string, string2, sVNPropertyValue);
    }

    @Override
    public void closeFile(String string, String string2) {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.closeFile(string, string2);
    }

    @Override
    public SVNCommitInfo closeEdit() {
        return this.myDelegate.closeEdit();
    }

    @Override
    public void abortEdit() {
    }

    private SVNAmbientDepthFilterEditor17$DirBaton makeDirBaton(String string, SVNAmbientDepthFilterEditor17$DirBaton sVNAmbientDepthFilterEditor17$DirBaton) {
        Object object;
        if (sVNAmbientDepthFilterEditor17$DirBaton != null && string == null) {
            object = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "aborting in SVNAmbientDepthFilterEditor17.makeDirBation(): parentBaton != null while path == null");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
        }
        if (sVNAmbientDepthFilterEditor17$DirBaton != null && sVNAmbientDepthFilterEditor17$DirBaton.myIsAmbientlyExcluded) {
            this.myDirs.addLast(sVNAmbientDepthFilterEditor17$DirBaton);
            return sVNAmbientDepthFilterEditor17$DirBaton;
        }
        object = new SVNAmbientDepthFilterEditor17$DirBaton(this, null);
        this.myDirs.addLast(object);
        if (sVNAmbientDepthFilterEditor17$DirBaton != null && sVNAmbientDepthFilterEditor17$DirBaton.myAmbientDepth != SVNDepth.UNKNOWN) {
            boolean bl2;
            boolean bl3;
            File file = SVNFileUtil.createFilePath(this.myAnchor, SVNWCUtils.getPathAsChild(this.myAnchor, SVNFileUtil.createFilePath(string)));
            SVNAmbientDepthFilterEditor17$AmbientReadInfo sVNAmbientDepthFilterEditor17$AmbientReadInfo = this.ambientReadInfo(file, this.myReadBase);
            ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus = sVNAmbientDepthFilterEditor17$AmbientReadInfo.status;
            ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind = sVNAmbientDepthFilterEditor17$AmbientReadInfo.kind;
            boolean bl4 = bl3 = iSVNWCDb$SVNWCDbKind != ISVNWCDb$SVNWCDbKind.Unknown;
            if (sVNAmbientDepthFilterEditor17$DirBaton.myAmbientDepth == SVNDepth.EMPTY || sVNAmbientDepthFilterEditor17$DirBaton.myAmbientDepth == SVNDepth.FILES) {
                bl2 = !bl3;
            } else {
                boolean bl5 = bl2 = bl3 && iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Excluded;
            }
            if (bl2) {
                ((SVNAmbientDepthFilterEditor17$DirBaton)object).myIsAmbientlyExcluded = true;
                return object;
            }
        }
        ((SVNAmbientDepthFilterEditor17$DirBaton)object).myAmbientDepth = SVNDepth.UNKNOWN;
        return object;
    }

    private SVNAmbientDepthFilterEditor17$FileBaton makeFileBaton(SVNAmbientDepthFilterEditor17$DirBaton sVNAmbientDepthFilterEditor17$DirBaton, String string) {
        Object object;
        if (string == null) {
            object = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "aborting in SVNAmbientDepthFilterEditor.makeFileBation(): path == null");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
        }
        object = new SVNAmbientDepthFilterEditor17$FileBaton(this, null);
        if (sVNAmbientDepthFilterEditor17$DirBaton.myIsAmbientlyExcluded) {
            ((SVNAmbientDepthFilterEditor17$FileBaton)object).myIsAmbientlyExcluded = true;
            return object;
        }
        File file = SVNFileUtil.createFilePath(this.myAnchor, SVNWCUtils.getPathAsChild(this.myAnchor, SVNFileUtil.createFilePath(string)));
        SVNAmbientDepthFilterEditor17$AmbientReadInfo sVNAmbientDepthFilterEditor17$AmbientReadInfo = this.ambientReadInfo(file, this.myReadBase);
        if (sVNAmbientDepthFilterEditor17$DirBaton.myAmbientDepth == SVNDepth.EMPTY && (sVNAmbientDepthFilterEditor17$AmbientReadInfo.hidden || sVNAmbientDepthFilterEditor17$AmbientReadInfo.kind == ISVNWCDb$SVNWCDbKind.Unknown)) {
            ((SVNAmbientDepthFilterEditor17$FileBaton)object).myIsAmbientlyExcluded = true;
        }
        if (sVNAmbientDepthFilterEditor17$DirBaton.myAmbientDepth != SVNDepth.UNKNOWN && sVNAmbientDepthFilterEditor17$AmbientReadInfo.status == ISVNWCDb$SVNWCDbStatus.Excluded) {
            ((SVNAmbientDepthFilterEditor17$FileBaton)object).myIsAmbientlyExcluded = true;
        }
        return object;
    }

    private SVNAmbientDepthFilterEditor17$AmbientReadInfo ambientReadInfo(File file, boolean bl2) {
        SVNAmbientDepthFilterEditor17$AmbientReadInfo sVNAmbientDepthFilterEditor17$AmbientReadInfo = new SVNAmbientDepthFilterEditor17$AmbientReadInfo(this, null);
        try {
            if (bl2) {
                ISVNWCDb$WCDbBaseInfo iSVNWCDb$WCDbBaseInfo = this.myWcContext.getDb().getBaseInfo(file, ISVNWCDb$WCDbBaseInfo$BaseInfoField.status, ISVNWCDb$WCDbBaseInfo$BaseInfoField.kind, ISVNWCDb$WCDbBaseInfo$BaseInfoField.depth);
                sVNAmbientDepthFilterEditor17$AmbientReadInfo.status = iSVNWCDb$WCDbBaseInfo.status;
                sVNAmbientDepthFilterEditor17$AmbientReadInfo.kind = iSVNWCDb$WCDbBaseInfo.kind;
                sVNAmbientDepthFilterEditor17$AmbientReadInfo.depth = iSVNWCDb$WCDbBaseInfo.depth;
            } else {
                ISVNWCDb$WCDbInfo iSVNWCDb$WCDbInfo = this.myWcContext.getDb().readInfo(file, ISVNWCDb$WCDbInfo$InfoField.status, ISVNWCDb$WCDbInfo$InfoField.kind, ISVNWCDb$WCDbInfo$InfoField.depth);
                sVNAmbientDepthFilterEditor17$AmbientReadInfo.status = iSVNWCDb$WCDbInfo.status;
                sVNAmbientDepthFilterEditor17$AmbientReadInfo.kind = iSVNWCDb$WCDbInfo.kind;
                sVNAmbientDepthFilterEditor17$AmbientReadInfo.depth = iSVNWCDb$WCDbInfo.depth;
            }
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                sVNAmbientDepthFilterEditor17$AmbientReadInfo.status = ISVNWCDb$SVNWCDbStatus.Normal;
                sVNAmbientDepthFilterEditor17$AmbientReadInfo.kind = ISVNWCDb$SVNWCDbKind.Unknown;
                sVNAmbientDepthFilterEditor17$AmbientReadInfo.depth = SVNDepth.UNKNOWN;
            }
            throw sVNException;
        }
        sVNAmbientDepthFilterEditor17$AmbientReadInfo.hidden = false;
        switch (sVNAmbientDepthFilterEditor17$AmbientReadInfo.status) {
            case NotPresent: 
            case ServerExcluded: 
            case Excluded: {
                sVNAmbientDepthFilterEditor17$AmbientReadInfo.hidden = true;
                break;
            }
        }
        return sVNAmbientDepthFilterEditor17$AmbientReadInfo;
    }

    @Override
    public long getTargetRevision() {
        if (this.myDelegate instanceof ISVNUpdateEditor) {
            return ((ISVNUpdateEditor)this.myDelegate).getTargetRevision();
        }
        return -1L;
    }
}

