/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc16;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNRevisionProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream$IOCancelException;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate;
import org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate$SVNRepositoryLocation;
import org.tmatesoft.svn.core.internal.wc16.SVNStatusClient16;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16$1;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16$10;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16$11;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16$12;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16$2;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16$3;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16$4;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16$5;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16$6;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16$7;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16$8;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16$9;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16$LockInfo;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16$PropFetchHandler;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16$PropSetHandler;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16$PropSetHandlerExt;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNAddParameters;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNInfoHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.ISVNPropertyValueProvider;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNWCClient16
extends SVNBasicDelegate {
    private ISVNAddParameters myAddParameters;
    private ISVNCommitHandler myCommitHandler;
    private boolean myIsRevertMissingDirectories;

    public SVNWCClient16(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
    }

    public SVNWCClient16(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public void setAddParameters(ISVNAddParameters iSVNAddParameters) {
        this.myAddParameters = iSVNAddParameters;
    }

    public ISVNCommitHandler getCommitHandler() {
        return this.myCommitHandler;
    }

    public void setCommitHandler(ISVNCommitHandler iSVNCommitHandler) {
        this.myCommitHandler = iSVNCommitHandler;
    }

    protected ISVNAddParameters getAddParameters() {
        return this.myAddParameters;
    }

    public void setRevertMissingDirectories(boolean bl2) {
        this.myIsRevertMissingDirectories = bl2;
    }

    public boolean isRevertMissingDirectories() {
        return this.myIsRevertMissingDirectories;
    }

    public void doGetFileContents(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, OutputStream outputStream) {
        this.doGetFileContents(file, sVNRevision, sVNRevision2, bl2, null, outputStream);
    }

    public void doGetFileContents(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, SVNProperties sVNProperties, OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        if (sVNRevision2 == null || !sVNRevision2.isValid()) {
            sVNRevision2 = SVNRevision.BASE;
        } else if (sVNRevision2 == SVNRevision.COMMITTED) {
            sVNRevision2 = SVNRevision.BASE;
        }
        if (!(sVNRevision.isValid() && sVNRevision != SVNRevision.BASE && sVNRevision != SVNRevision.WORKING || sVNRevision2.isValid() && sVNRevision2 != SVNRevision.BASE && sVNRevision2 != SVNRevision.WORKING)) {
            this.doGetLocalFileContents(file, outputStream, sVNRevision2, bl2, sVNProperties);
        } else {
            Object object;
            SVNRepository sVNRepository = this.createRepository(null, file, null, sVNRevision, sVNRevision2, null);
            this.checkCancelled();
            long l2 = this.getRevisionNumber(sVNRevision2, sVNRepository, file);
            SVNNodeKind sVNNodeKind = sVNRepository.checkPath("", l2);
            if (sVNNodeKind == SVNNodeKind.DIR) {
                object = SVNErrorMessage.create(SVNErrorCode.CLIENT_IS_DIRECTORY, "URL ''{0}'' refers to a directory", (Object)sVNRepository.getLocation());
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            this.checkCancelled();
            if (!bl2) {
                sVNRepository.getFile("", l2, sVNProperties, new SVNCancellableOutputStream(outputStream, this));
            } else {
                if (sVNProperties == null) {
                    sVNProperties = new SVNProperties();
                }
                sVNRepository.getFile("", l2, sVNProperties, null);
                this.checkCancelled();
                object = sVNProperties.getStringValue("svn:keywords");
                String string = sVNProperties.getStringValue("svn:eol-style");
                String string2 = sVNProperties.getStringValue("svn:mime-type");
                String string3 = SVNTranslator.getCharset(sVNProperties.getStringValue("svnkit:charset"), string2, file.getPath(), this.getOptions());
                if (object != null || string != null || string3 != null) {
                    String string4 = sVNProperties.getStringValue("svn:entry:committed-rev");
                    String string5 = sVNProperties.getStringValue("svn:entry:committed-date");
                    String string6 = sVNProperties.getStringValue("svn:entry:last-author");
                    Map map = SVNTranslator.computeKeywords((String)object, bl2 ? sVNRepository.getLocation().toString() : null, sVNRepository.getRepositoryRoot(true).toString(), string6, string5, string4, this.getOptions());
                    OutputStream outputStream2 = SVNTranslator.getTranslatingOutputStream(outputStream, string3, SVNTranslator.getEOL(string, this.getOptions()), false, map, bl2);
                    sVNRepository.getFile("", l2, null, new SVNCancellableOutputStream(outputStream2, this.getEventDispatcher()));
                    try {
                        outputStream2.flush();
                    }
                    catch (IOExceptionWrapper iOExceptionWrapper) {
                        throw iOExceptionWrapper.getOriginalException();
                    }
                    catch (IOException iOException) {
                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage()), SVNLogType.WC);
                    }
                } else {
                    sVNRepository.getFile("", l2, null, new SVNCancellableOutputStream(outputStream, this.getEventDispatcher()));
                }
            }
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage()), SVNLogType.WC);
            }
        }
    }

    public void doGetFileContents(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, OutputStream outputStream) {
        this.doGetFileContents(sVNURL, sVNRevision, sVNRevision2, bl2, null, outputStream);
    }

    public void doGetFileContents(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, SVNProperties sVNProperties, OutputStream outputStream) {
        Object object;
        sVNRevision2 = sVNRevision2 == null || !sVNRevision2.isValid() ? SVNRevision.HEAD : sVNRevision2;
        SVNRepository sVNRepository = this.createRepository(sVNURL, null, null, sVNRevision, sVNRevision2, null);
        this.checkCancelled();
        long l2 = this.getRevisionNumber(sVNRevision2, sVNRepository, null);
        this.checkCancelled();
        SVNNodeKind sVNNodeKind = sVNRepository.checkPath("", l2);
        this.checkCancelled();
        if (sVNNodeKind == SVNNodeKind.DIR) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_IS_DIRECTORY, "URL ''{0}'' refers to a directory", (Object)sVNURL);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        this.checkCancelled();
        if (!bl2) {
            sVNRepository.getFile("", l2, sVNProperties, new SVNCancellableOutputStream(outputStream, this));
        } else {
            if (sVNProperties == null) {
                sVNProperties = new SVNProperties();
            }
            sVNRepository.getFile("", l2, sVNProperties, null);
            this.checkCancelled();
            object = sVNProperties.getStringValue("svn:mime-type");
            String string = SVNTranslator.getCharset(sVNProperties.getStringValue("svnkit:charset"), (String)object, sVNRepository.getLocation().toString(), this.getOptions());
            String string2 = sVNProperties.getStringValue("svn:keywords");
            String string3 = sVNProperties.getStringValue("svn:eol-style");
            if (string != null || string2 != null || string3 != null) {
                String string4 = sVNProperties.getStringValue("svn:entry:committed-rev");
                String string5 = sVNProperties.getStringValue("svn:entry:committed-date");
                String string6 = sVNProperties.getStringValue("svn:entry:last-author");
                Map map = SVNTranslator.computeKeywords(string2, bl2 ? sVNRepository.getLocation().toString() : null, sVNRepository.getRepositoryRoot(true).toString(), string6, string5, string4, this.getOptions());
                OutputStream outputStream2 = SVNTranslator.getTranslatingOutputStream(outputStream, string, SVNTranslator.getEOL(string3, this.getOptions()), false, map, bl2);
                sVNRepository.getFile("", l2, null, new SVNCancellableOutputStream(outputStream2, this.getEventDispatcher()));
                try {
                    outputStream2.flush();
                }
                catch (IOExceptionWrapper iOExceptionWrapper) {
                    throw iOExceptionWrapper.getOriginalException();
                }
                catch (IOException iOException) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage()), SVNLogType.WC);
                }
            } else {
                sVNRepository.getFile("", l2, null, new SVNCancellableOutputStream(outputStream, this.getEventDispatcher()));
            }
        }
        try {
            outputStream.flush();
        }
        catch (IOException iOException) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage()), SVNLogType.WC);
        }
    }

    public void doCleanup(File file) {
        this.doCleanup(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCleanup(File file, boolean bl2) {
        Object object;
        SVNFileType sVNFileType = SVNFileType.getType(file);
        if (sVNFileType == SVNFileType.NONE) {
            object = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' does not exist", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        } else if (sVNFileType == SVNFileType.FILE) {
            file = file.getParentFile();
        } else if (sVNFileType == SVNFileType.SYMLINK && SVNFileType.getType(file = SVNFileUtil.resolveSymlink(file)) == SVNFileType.FILE) {
            file = file.getParentFile();
        }
        object = this.createWCAccess();
        try {
            SVNAdminArea sVNAdminArea = ((SVNWCAccess)object).open(file, true, true, 0);
            sVNAdminArea.cleanup();
            if (bl2) {
                SVNPropertiesManager.deleteWCProperties(sVNAdminArea, null, true);
            }
        }
        catch (SVNException sVNException) {
            if (sVNException instanceof SVNCancelException) {
                throw sVNException;
            }
            if (!SVNAdminArea.isSafeCleanup()) {
                throw sVNException;
            }
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "CLEANUP FAILED for " + file);
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, sVNException);
        }
        finally {
            ((SVNWCAccess)object).close();
            this.sleepForTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetProperty(File file, String string, SVNPropertyValue sVNPropertyValue, boolean bl2, SVNDepth sVNDepth, ISVNPropertyHandler iSVNPropertyHandler, Collection collection) {
        Object object;
        sVNDepth = sVNDepth == null ? SVNDepth.UNKNOWN : sVNDepth;
        int n2 = -1;
        if (sVNDepth == SVNDepth.EMPTY || sVNDepth == SVNDepth.FILES) {
            n2 = 0;
        }
        if (sVNPropertyValue != null && !SVNPropertiesManager.isValidPropertyName(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Bad property name ''{0}''", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (SVNRevisionProperty.isRevisionProperty(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Revision property ''{0}'' not allowed in this context", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        } else if (SVNProperty.isWorkingCopyProperty(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        } else if (SVNProperty.isEntryProperty(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property ''{0}'' is an entry property", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = this.createWCAccess();
        try {
            boolean bl3;
            ((SVNWCAccess)object).probeOpen(file, true, n2);
            SVNEntry sVNEntry = ((SVNWCAccess)object).getVersionedEntry(file, false);
            if (SVNDepth.FILES.compareTo(sVNDepth) <= 0 && sVNEntry.isDirectory()) {
                SVNWCClient16$PropSetHandler sVNWCClient16$PropSetHandler = new SVNWCClient16$PropSetHandler(this, bl2, string, sVNPropertyValue, iSVNPropertyHandler, collection);
                ((SVNWCAccess)object).walkEntries(file, sVNWCClient16$PropSetHandler, false, sVNDepth);
            } else if (SVNWCAccess.matchesChangeList(collection, sVNEntry) && (bl3 = SVNPropertiesManager.setProperty((SVNWCAccess)object, file, string, sVNPropertyValue, bl2)) && iSVNPropertyHandler != null) {
                iSVNPropertyHandler.handleProperty(file, new SVNPropertyData(string, sVNPropertyValue, this.getOptions()));
            }
        }
        finally {
            ((SVNWCAccess)object).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetProperty(File file, ISVNPropertyValueProvider iSVNPropertyValueProvider, boolean bl2, SVNDepth sVNDepth, ISVNPropertyHandler iSVNPropertyHandler, Collection collection) {
        sVNDepth = sVNDepth == null ? SVNDepth.UNKNOWN : sVNDepth;
        int n2 = -1;
        if (sVNDepth == SVNDepth.EMPTY || sVNDepth == SVNDepth.FILES) {
            n2 = 0;
        }
        try (SVNWCAccess sVNWCAccess = this.createWCAccess();){
            sVNWCAccess.probeOpen(file, true, n2);
            SVNEntry sVNEntry = sVNWCAccess.getVersionedEntry(file, false);
            if (SVNDepth.FILES.compareTo(sVNDepth) <= 0 && sVNEntry.isDirectory()) {
                SVNWCClient16$PropSetHandlerExt sVNWCClient16$PropSetHandlerExt = new SVNWCClient16$PropSetHandlerExt(this, bl2, iSVNPropertyValueProvider, iSVNPropertyHandler, collection);
                sVNWCAccess.walkEntries(file, sVNWCClient16$PropSetHandlerExt, false, sVNDepth);
            } else if (SVNWCAccess.matchesChangeList(collection, sVNEntry)) {
                SVNAdminArea sVNAdminArea = sVNEntry.getAdminArea();
                this.setLocalProperties(file, sVNEntry, sVNAdminArea, bl2, iSVNPropertyValueProvider, iSVNPropertyHandler);
            }
        }
    }

    public SVNCommitInfo doSetProperty(SVNURL sVNURL, String string, SVNPropertyValue sVNPropertyValue, SVNRevision sVNRevision, String string2, SVNProperties sVNProperties, boolean bl2, ISVNPropertyHandler iSVNPropertyHandler) {
        Serializable serializable;
        SVNErrorMessage sVNErrorMessage;
        Object object;
        if (sVNPropertyValue != null && !SVNPropertiesManager.isValidPropertyName(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Bad property name ''{0}''", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (SVNRevisionProperty.isRevisionProperty(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Revision property ''{0}'' not allowed in this context", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        } else if (SVNProperty.isWorkingCopyProperty(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        } else if (SVNProperty.isEntryProperty(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property ''{0}'' is an entry property", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = this.createRepository(sVNURL, null, null, true);
        long l2 = -1L;
        try {
            l2 = this.getRevisionNumber(sVNRevision, (SVNRepository)object, null);
        }
        catch (SVNException sVNException) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Setting property on non-local target ''{0}'' needs a base revision", (Object)sVNURL);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if ("svn:eol-style".equals(string) || "svn:keywords".equals(string) || "svnkit:charset".equals(string)) {
            serializable = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Setting property ''{0}'' on non-local target ''{1}'' is not supported", string, sVNURL);
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        if ((serializable = ((SVNRepository)object).checkPath("", l2)) == SVNNodeKind.NONE) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' does not exist in revision {1}", sVNURL.getPath(), l2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (sVNPropertyValue != null && SVNProperty.isSVNProperty(string)) {
            long l3 = l2;
            sVNPropertyValue = SVNPropertiesManager.validatePropertyValue(sVNURL, serializable, string, sVNPropertyValue, bl2, this.getOptions(), new SVNWCClient16$1(this, (SVNRepository)object, l3));
        }
        ArrayList<SVNCommitItem> arrayList = new ArrayList<SVNCommitItem>(2);
        SVNCommitItem sVNCommitItem = new SVNCommitItem(null, sVNURL, null, (SVNNodeKind)serializable, SVNRevision.create(l2), SVNRevision.UNDEFINED, false, false, true, false, false, false);
        arrayList.add(sVNCommitItem);
        SVNCommitItem[] sVNCommitItemArray = arrayList.toArray(new SVNCommitItem[arrayList.size()]);
        String string3 = this.getCommitHandler() != null ? this.getCommitHandler().getCommitMessage(string2, sVNCommitItemArray) : (string2 = string2 == null ? "" : string2);
        if (string2 == null) {
            return SVNCommitInfo.NULL;
        }
        string2 = SVNCommitUtil.validateCommitMessage(string2);
        if (this.getCommitHandler() != null) {
            sVNProperties = this.getCommitHandler().getRevisionProperties(string2, sVNCommitItemArray, sVNProperties);
        }
        SVNPropertiesManager.validateRevisionProperties(sVNProperties);
        SVNCommitInfo sVNCommitInfo = null;
        ISVNEditor iSVNEditor = ((SVNRepository)object).getCommitEditor(string2, null, true, sVNProperties, null);
        try {
            iSVNEditor.openRoot(l2);
            if (serializable == SVNNodeKind.FILE) {
                iSVNEditor.openFile("", l2);
                iSVNEditor.changeFileProperty("", string, sVNPropertyValue);
                iSVNEditor.closeFile("", null);
            } else {
                iSVNEditor.changeDirProperty(string, sVNPropertyValue);
            }
            iSVNEditor.closeDir();
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(null, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.COMMIT_FINALIZING, SVNEventAction.COMMIT_FINALIZING, null, null);
            sVNEvent.setURL(sVNURL);
            this.handleEvent(sVNEvent, -1.0);
            sVNCommitInfo = iSVNEditor.closeEdit();
        }
        catch (SVNException sVNException) {
            iSVNEditor.abortEdit();
            throw sVNException;
        }
        if (iSVNPropertyHandler != null) {
            iSVNPropertyHandler.handleProperty(sVNURL, new SVNPropertyData(string, sVNPropertyValue, this.getOptions()));
        }
        return sVNCommitInfo;
    }

    public void doSetRevisionProperty(File file, SVNRevision sVNRevision, String string, SVNPropertyValue sVNPropertyValue, boolean bl2, ISVNPropertyHandler iSVNPropertyHandler) {
        Object object;
        if (sVNPropertyValue != null && !SVNPropertiesManager.isValidPropertyName(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Bad property name ''{0}''", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = this.getURL(file);
        this.doSetRevisionProperty((SVNURL)object, sVNRevision, string, sVNPropertyValue, bl2, iSVNPropertyHandler);
    }

    public void doSetRevisionProperty(SVNURL sVNURL, SVNRevision sVNRevision, String string, SVNPropertyValue sVNPropertyValue, boolean bl2, ISVNPropertyHandler iSVNPropertyHandler) {
        Object object;
        if (sVNPropertyValue != null && !SVNPropertiesManager.isValidPropertyName(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Bad property name ''{0}''", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (!bl2 && "svn:author".equals(string) && sVNPropertyValue != null && sVNPropertyValue.isString() && sVNPropertyValue.getString().indexOf(10) >= 0) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_REVISION_AUTHOR_CONTAINS_NEWLINE, "Value will not be set unless forced");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (SVNProperty.isWorkingCopyProperty(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (SVNProperty.isEntryProperty(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property ''{0}'' is an entry property", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = this.createRepository(sVNURL, null, null, SVNRevision.UNDEFINED, sVNRevision, null);
        long l2 = this.getRevisionNumber(sVNRevision, (SVNRepository)object, null);
        ((SVNRepository)object).setRevisionPropertyValue(l2, string, sVNPropertyValue);
        if (iSVNPropertyHandler != null) {
            iSVNPropertyHandler.handleProperty(l2, new SVNPropertyData(string, sVNPropertyValue, this.getOptions()));
        }
    }

    public SVNPropertyData doGetProperty(File file, String string, SVNRevision sVNRevision, SVNRevision sVNRevision2) {
        SVNPropertyData[] sVNPropertyDataArray = new SVNPropertyData[1];
        this.doGetProperty(file, string, sVNRevision, sVNRevision2, SVNDepth.EMPTY, new SVNWCClient16$2(this, sVNPropertyDataArray, file), null);
        return sVNPropertyDataArray[0];
    }

    public SVNPropertyData doGetProperty(SVNURL sVNURL, String string, SVNRevision sVNRevision, SVNRevision sVNRevision2) {
        SVNPropertyData[] sVNPropertyDataArray = new SVNPropertyData[1];
        this.doGetProperty(sVNURL, string, sVNRevision, sVNRevision2, SVNDepth.EMPTY, (ISVNPropertyHandler)new SVNWCClient16$3(this, sVNPropertyDataArray, sVNURL));
        return sVNPropertyDataArray[0];
    }

    public void doGetProperty(File file, String string, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, ISVNPropertyHandler iSVNPropertyHandler) {
        this.doGetProperty(file, string, sVNRevision, sVNRevision2, SVNDepth.getInfinityOrEmptyDepth(bl2), iSVNPropertyHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetProperty(File file, String string, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, ISVNPropertyHandler iSVNPropertyHandler, Collection collection) {
        Object object;
        if (SVNProperty.isWorkingCopyProperty(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (SVNProperty.isEntryProperty(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property ''{0}'' is an entry property", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (sVNDepth == null || sVNDepth == SVNDepth.UNKNOWN) {
            sVNDepth = SVNDepth.EMPTY;
        }
        if (sVNRevision2 != SVNRevision.WORKING && sVNRevision2 != SVNRevision.BASE && sVNRevision2 != SVNRevision.COMMITTED && sVNRevision2 != SVNRevision.UNDEFINED || sVNRevision != SVNRevision.WORKING && sVNRevision != SVNRevision.BASE && sVNRevision != SVNRevision.COMMITTED && sVNRevision != SVNRevision.UNDEFINED) {
            object = new long[]{-1L};
            SVNRepository sVNRepository = this.createRepository(null, file, null, sVNRevision, sVNRevision2, (long[])object);
            sVNRevision2 = SVNRevision.create((long)object[0]);
            this.doGetRemoteProperty(sVNRepository.getLocation(), "", sVNRepository, string, sVNRevision2, sVNDepth, iSVNPropertyHandler);
        } else {
            object = this.createWCAccess();
            try {
                int n2 = this.getLevelsToLockFromDepth(sVNDepth);
                SVNAdminArea sVNAdminArea = ((SVNWCAccess)object).probeOpen(file, false, n2);
                SVNEntry sVNEntry = ((SVNWCAccess)object).getVersionedEntry(file, false);
                boolean bl2 = sVNRevision2 == SVNRevision.BASE || sVNRevision2 == SVNRevision.COMMITTED;
                this.doGetLocalProperty(sVNEntry, sVNAdminArea, string, bl2, iSVNPropertyHandler, sVNDepth, collection);
            }
            finally {
                ((SVNWCAccess)object).close();
            }
        }
    }

    public void doGetProperty(SVNURL sVNURL, String string, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, ISVNPropertyHandler iSVNPropertyHandler) {
        this.doGetProperty(sVNURL, string, sVNRevision, sVNRevision2, SVNDepth.getInfinityOrEmptyDepth(bl2), iSVNPropertyHandler);
    }

    public void doGetProperty(SVNURL sVNURL, String string, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, ISVNPropertyHandler iSVNPropertyHandler) {
        Object object;
        if (SVNProperty.isWorkingCopyProperty(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (SVNProperty.isEntryProperty(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property ''{0}'' is an entry property", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = new long[]{-1L};
        SVNRepository sVNRepository = this.createRepository(sVNURL, null, null, sVNRevision, sVNRevision2, (long[])object);
        sVNRevision2 = object[0] < 0L ? sVNRevision2 : SVNRevision.create((long)object[0]);
        this.doGetRemoteProperty(sVNURL, "", sVNRepository, string, sVNRevision2, sVNDepth, iSVNPropertyHandler);
    }

    public void doGetRevisionProperty(File file, String string, SVNRevision sVNRevision, ISVNPropertyHandler iSVNPropertyHandler) {
        Object object;
        if (SVNProperty.isWorkingCopyProperty(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (SVNProperty.isEntryProperty(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property ''{0}'' is an entry property", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (!sVNRevision.isValid()) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Valid revision have to be specified to fetch revision property");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
        }
        object = this.createRepository(null, file, null, SVNRevision.UNDEFINED, sVNRevision, null);
        long l2 = this.getRevisionNumber(sVNRevision, (SVNRepository)object, file);
        this.doGetRevisionProperty((SVNRepository)object, string, l2, iSVNPropertyHandler);
    }

    public long doGetRevisionProperty(SVNURL sVNURL, String string, SVNRevision sVNRevision, ISVNPropertyHandler iSVNPropertyHandler) {
        Object object;
        if (SVNProperty.isWorkingCopyProperty(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (SVNProperty.isEntryProperty(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property ''{0}'' is an entry property", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (!sVNRevision.isValid()) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Valid revision have to be specified to fetch revision property");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
        }
        object = this.createRepository(sVNURL, null, null, true);
        long l2 = this.getRevisionNumber(sVNRevision, (SVNRepository)object, null);
        this.doGetRevisionProperty((SVNRepository)object, string, l2, iSVNPropertyHandler);
        return l2;
    }

    public void doDelete(File file, boolean bl2, boolean bl3) {
        this.doDelete(file, bl2, true, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete(File file, boolean bl2, boolean bl3, boolean bl4) {
        file = file.getAbsoluteFile();
        try (SVNWCAccess sVNWCAccess = this.createWCAccess();){
            if (!bl2 && bl3) {
                SVNWCManager.canDelete(file, this.getOptions(), this);
            }
            SVNAdminArea sVNAdminArea = sVNWCAccess.open(file.getParentFile(), true, 0);
            if (!bl4) {
                SVNWCManager.delete(sVNWCAccess, sVNAdminArea, file, bl3, true);
            }
        }
    }

    public void doAdd(File file, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        SVNDepth sVNDepth = SVNDepth.getInfinityOrEmptyDepth(bl5);
        this.doAdd(file, bl2, bl3, bl4, sVNDepth, false, false, bl4);
    }

    public void doAdd(File file, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        SVNDepth sVNDepth = SVNDepth.getInfinityOrEmptyDepth(bl5);
        this.doAdd(file, bl2, bl3, bl4, sVNDepth, false, bl6, bl4);
    }

    public void doAdd(File file, boolean bl2, boolean bl3, boolean bl4, SVNDepth sVNDepth, boolean bl5, boolean bl6) {
        this.doAdd(file, bl2, bl3, bl4, sVNDepth, false, bl5, bl6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAdd(File[] fileArray, boolean bl2, boolean bl3, boolean bl4, SVNDepth sVNDepth, boolean bl5, boolean bl6, boolean bl7) {
        this.setEventPathPrefix("");
        try {
            if (fileArray != null) {
                for (int i2 = 0; i2 < fileArray.length; ++i2) {
                    this.doAdd(fileArray[i2], bl2, bl3, bl4, sVNDepth, bl5, bl6, bl7);
                }
            }
        }
        finally {
            this.setEventPathPrefix(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAdd(File file, boolean bl2, boolean bl3, boolean bl4, SVNDepth sVNDepth, boolean bl5, boolean bl6, boolean bl7) {
        Object object;
        sVNDepth = sVNDepth == null ? SVNDepth.UNKNOWN : sVNDepth;
        file = file.getAbsoluteFile();
        if (!bl3 && bl7 && file.getParentFile() != null) {
            object = this.createWCAccess();
            try {
                this.addParentDirectories((SVNWCAccess)object, file.getParentFile());
            }
            finally {
                ((SVNWCAccess)object).close();
            }
        }
        object = SVNFileType.getType(file);
        if (bl2 && bl3 && object == SVNFileType.DIRECTORY) {
            this.doAdd(file, bl2, false, true, SVNDepth.EMPTY, bl5, true, bl7);
            return;
        }
        if (bl3) {
            File file2;
            File file3 = file;
            for (file2 = file; file2 != null && SVNFileType.getType(file2) == SVNFileType.NONE; file2 = file2.getParentFile()) {
                if (!file2.equals(file) && !bl7) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create directoy ''{0}'' with non-existent parents", (Object)file);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
                file3 = file2;
            }
            boolean bl8 = file.mkdirs();
            if (!bl8) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create new directory ''{0}''", (Object)file);
                while (file2 == null ? file != null : !file.equals(file2)) {
                    SVNFileUtil.deleteAll(file, true);
                    file = file.getParentFile();
                }
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            try {
                this.doAdd(file3, false, false, bl4, sVNDepth, bl5, true, bl7);
            }
            catch (SVNException sVNException) {
                SVNFileUtil.deleteAll(file3, true);
                throw sVNException;
            }
            return;
        }
        try (SVNWCAccess sVNWCAccess = this.createWCAccess();){
            SVNAdminArea sVNAdminArea = null;
            SVNFileType sVNFileType = SVNFileType.getType(file);
            sVNAdminArea = sVNFileType == SVNFileType.DIRECTORY ? sVNWCAccess.open(SVNWCUtil.isVersionedDirectory(file.getParentFile()) ? file.getParentFile() : file, true, 0) : sVNWCAccess.open(file.getParentFile(), true, 0);
            if (sVNFileType == SVNFileType.DIRECTORY && sVNDepth.compareTo(SVNDepth.FILES) >= 0) {
                File file4 = SVNWCUtil.getWorkingCopyRoot(sVNAdminArea.getRoot(), true);
                this.addDirectory(file4, file, sVNAdminArea, bl2, bl6, sVNDepth, bl5);
            } else if (sVNFileType == SVNFileType.FILE || sVNFileType == SVNFileType.SYMLINK) {
                this.addFile(file, sVNFileType, sVNAdminArea);
            } else {
                SVNWCManager.add(file, sVNAdminArea, null, SVNRevision.UNDEFINED, bl5 ? sVNDepth : null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMarkReplaced(File file) {
        file = file.getAbsoluteFile();
        try (SVNWCAccess sVNWCAccess = this.createWCAccess();){
            SVNAdminAreaInfo sVNAdminAreaInfo = sVNWCAccess.openAnchor(file, true, -1);
            SVNAdminArea sVNAdminArea = sVNAdminAreaInfo.getAnchor();
            if (file.equals(sVNAdminArea.getRoot().getAbsoluteFile())) {
                SVNWCManager.markTree(sVNAdminArea, "replace", false, false, 1);
            } else {
                SVNEntry sVNEntry = sVNAdminArea.getEntry(file.getName(), false);
                SVNWCManager.markEntry(sVNAdminArea, sVNEntry, "replace", false, false, 1);
            }
            sVNAdminArea.saveEntries(false);
        }
    }

    public void doRevert(File file, boolean bl2) {
        this.doRevert(new File[]{file}, SVNDepth.getInfinityOrEmptyDepth(bl2), null);
    }

    public void doRevert(File[] fileArray, boolean bl2) {
        this.doRevert(fileArray, bl2 ? SVNDepth.INFINITY : SVNDepth.EMPTY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRevert(File[] fileArray, SVNDepth sVNDepth, Collection collection) {
        boolean bl2 = false;
        try {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                Object object;
                Object object2;
                File file = fileArray[i2];
                file = file.getAbsoluteFile();
                try (SVNWCAccess sVNWCAccess = this.createWCAccess();){
                    int n2 = this.getLevelsToLockFromDepth(sVNDepth);
                    object2 = sVNWCAccess.openAnchor(file, true, n2);
                    object = sVNWCAccess.getEntry(file, false);
                    if (object != null && ((SVNEntry)object).isDirectory() && ((SVNEntry)object).isScheduledForAddition() && sVNDepth != SVNDepth.INFINITY) {
                        sVNDepth = SVNDepth.INFINITY;
                        sVNWCAccess.close();
                        object2 = sVNWCAccess.openAnchor(file, true, -1);
                    }
                    boolean bl3 = this.getOptions().isUseCommitTimes();
                    bl2 |= this.doRevert(file, ((SVNAdminAreaInfo)object2).getAnchor(), sVNDepth, bl3, collection);
                    continue;
                }
            }
        }
        finally {
            if (bl2) {
                this.sleepForTimeStamp();
            }
        }
    }

    public void doResolve(File file, boolean bl2) {
        this.doResolve(file, SVNDepth.fromRecurse(bl2), SVNConflictChoice.MERGED);
    }

    public void doResolve(File file, SVNDepth sVNDepth, SVNConflictChoice sVNConflictChoice) {
        this.doResolve(file, sVNDepth, true, true, sVNConflictChoice);
    }

    public void doResolve(File file, SVNDepth sVNDepth, boolean bl2, boolean bl3, SVNConflictChoice sVNConflictChoice) {
        this.doResolve(file, sVNDepth, bl2, bl3, true, sVNConflictChoice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doResolve(File file, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, SVNConflictChoice sVNConflictChoice) {
        SVNConflictChoice sVNConflictChoice2 = sVNConflictChoice == null ? SVNConflictChoice.MERGED : sVNConflictChoice;
        file = file.getAbsoluteFile();
        SVNWCAccess sVNWCAccess = this.createWCAccess();
        int n2 = -1;
        if (sVNDepth == SVNDepth.EMPTY || sVNDepth == SVNDepth.FILES) {
            n2 = 0;
        }
        try {
            sVNWCAccess.probeOpen(file, true, n2);
            if (!sVNWCAccess.isWCRoot(file)) {
                sVNWCAccess.close();
                if (n2 >= 0) {
                    ++n2;
                }
                sVNWCAccess.probeOpen(file.getParentFile(), true, n2);
            }
            SVNWCClient16$4 sVNWCClient16$4 = new SVNWCClient16$4(this, sVNWCAccess, bl4, sVNConflictChoice2, bl2, bl3);
            if (sVNDepth == SVNDepth.EMPTY) {
                SVNEntry sVNEntry = sVNWCAccess.getEntry(file, false);
                if (sVNEntry != null) {
                    sVNWCClient16$4.handleEntry(file, sVNEntry);
                } else {
                    SVNTreeConflictDescription sVNTreeConflictDescription = sVNWCAccess.getTreeConflict(file);
                    if (sVNTreeConflictDescription != null) {
                        sVNWCClient16$4.handleEntry(file, null);
                    } else {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", (Object)file);
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                    }
                }
            } else {
                sVNWCAccess.walkEntries(file, sVNWCClient16$4, false, true, sVNDepth);
            }
        }
        finally {
            sVNWCAccess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLock(File[] fileArray, boolean bl2, String string) {
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        SVNHashMap sVNHashMap = new SVNHashMap();
        SVNHashMap sVNHashMap2 = new SVNHashMap();
        try (SVNWCAccess sVNWCAccess = this.createWCAccess();){
            SVNURL sVNURL = this.collectLockInfo(sVNWCAccess, fileArray, sVNHashMap, sVNHashMap2, true, bl2);
            SVNRepository sVNRepository = this.createRepository(sVNURL, fileArray[0], sVNWCAccess, true);
            SVNURL sVNURL2 = sVNRepository.getRepositoryRoot(true);
            sVNRepository.lock(sVNHashMap2, string, bl2, new SVNWCClient16$5(this, sVNURL2, sVNHashMap, sVNWCAccess));
        }
    }

    public void doLock(SVNURL[] sVNURLArray, boolean bl2, String string) {
        SVNHashSet sVNHashSet = new SVNHashSet();
        SVNURL sVNURL = SVNURLUtil.condenceURLs(sVNURLArray, sVNHashSet, false);
        if (sVNHashSet.isEmpty()) {
            sVNHashSet.add("");
        }
        SVNHashMap sVNHashMap = new SVNHashMap();
        for (String string2 : sVNHashSet) {
            string2 = SVNEncodingUtil.uriDecode(string2);
            sVNHashMap.put(string2, null);
        }
        this.checkCancelled();
        SVNRepository sVNRepository = this.createRepository(sVNURL, null, null, true);
        sVNRepository.lock(sVNHashMap, string, bl2, new SVNWCClient16$6(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUnlock(File[] fileArray, boolean bl2) {
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        SVNHashMap sVNHashMap = new SVNHashMap();
        SVNHashMap sVNHashMap2 = new SVNHashMap();
        try (SVNWCAccess sVNWCAccess = this.createWCAccess();){
            SVNURL sVNURL = this.collectLockInfo(sVNWCAccess, fileArray, sVNHashMap, sVNHashMap2, false, bl2);
            this.checkCancelled();
            SVNRepository sVNRepository = this.createRepository(sVNURL, fileArray[0], sVNWCAccess, true);
            SVNURL sVNURL2 = sVNRepository.getRepositoryRoot(true);
            sVNRepository.unlock(sVNHashMap2, bl2, new SVNWCClient16$7(this, sVNURL2, sVNHashMap, sVNWCAccess));
        }
    }

    public void doUnlock(SVNURL[] sVNURLArray, boolean bl2) {
        SVNHashSet sVNHashSet = new SVNHashSet();
        SVNURL sVNURL = SVNURLUtil.condenceURLs(sVNURLArray, sVNHashSet, false);
        if (sVNHashSet.isEmpty()) {
            sVNHashSet.add("");
        }
        Map map = new SVNHashMap();
        for (String string : sVNHashSet) {
            string = SVNEncodingUtil.uriDecode(string);
            map.put(string, null);
        }
        this.checkCancelled();
        SVNRepository sVNRepository = this.createRepository(sVNURL, null, null, true);
        if (!bl2) {
            map = this.fetchLockTokens(sVNRepository, map);
        }
        sVNRepository.unlock(map, bl2, new SVNWCClient16$8(this));
    }

    public void doInfo(File file, SVNRevision sVNRevision, boolean bl2, ISVNInfoHandler iSVNInfoHandler) {
        this.doInfo(file, SVNRevision.UNDEFINED, sVNRevision, SVNDepth.getInfinityOrEmptyDepth(bl2), null, iSVNInfoHandler);
    }

    public void doInfo(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, ISVNInfoHandler iSVNInfoHandler) {
        this.doInfo(file, sVNRevision, sVNRevision2, SVNDepth.getInfinityOrEmptyDepth(bl2), null, iSVNInfoHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInfo(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, Collection collection, ISVNInfoHandler iSVNInfoHandler) {
        boolean bl2;
        if (iSVNInfoHandler == null) {
            return;
        }
        boolean bl3 = bl2 = !(sVNRevision2 != null && sVNRevision2.isValid() && !sVNRevision2.isLocal() || sVNRevision != null && sVNRevision.isValid() && !sVNRevision.isLocal());
        if (!bl2) {
            SVNWCAccess sVNWCAccess = this.createWCAccess();
            SVNRevision sVNRevision3 = null;
            SVNURL sVNURL = null;
            try {
                sVNWCAccess.probeOpen(file, false, 0);
                SVNEntry sVNEntry = sVNWCAccess.getVersionedEntry(file, false);
                sVNURL = sVNEntry.getSVNURL();
                if (sVNURL == null) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)file);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
                sVNRevision3 = SVNRevision.create(sVNEntry.getRevision());
            }
            finally {
                sVNWCAccess.close();
            }
            this.doInfo(sVNURL, sVNRevision == null || !sVNRevision.isValid() || sVNRevision.isLocal() ? sVNRevision3 : sVNRevision, sVNRevision2, sVNDepth, iSVNInfoHandler);
            return;
        }
        SVNHashSet sVNHashSet = null;
        if (collection != null) {
            sVNHashSet = new SVNHashSet();
            for (String string : collection) {
                sVNHashSet.add(string);
            }
        }
        this.crawlEntries(file, sVNDepth, sVNHashSet, iSVNInfoHandler);
    }

    public void doInfo(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, ISVNInfoHandler iSVNInfoHandler) {
        this.doInfo(sVNURL, sVNRevision, sVNRevision2, SVNDepth.getInfinityOrEmptyDepth(bl2), iSVNInfoHandler);
    }

    public void doInfo(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, ISVNInfoHandler iSVNInfoHandler) {
        Object object;
        Object object2;
        Object object3;
        SVNLock[] sVNLockArray;
        SVNBasicDelegate$SVNRepositoryLocation[] sVNBasicDelegate$SVNRepositoryLocationArray;
        String string;
        String string2;
        SVNURL sVNURL2;
        SVNDirEntry sVNDirEntry;
        SVNRepository sVNRepository;
        long[] lArray;
        block28: {
            sVNDepth = sVNDepth == null ? SVNDepth.UNKNOWN : sVNDepth;
            lArray = new long[]{-1L};
            sVNRepository = this.createRepository(sVNURL, null, null, sVNRevision, sVNRevision2, lArray);
            sVNURL = sVNRepository.getLocation();
            sVNDirEntry = null;
            sVNURL2 = sVNRepository.getRepositoryRoot(true);
            string2 = sVNRepository.getRepositoryUUID(true);
            string = SVNPathUtil.tail(sVNURL.getPath());
            try {
                sVNDirEntry = sVNRepository.info("", lArray[0]);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage() != null && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                    if (sVNURL.equals(sVNURL2)) {
                        if (sVNDepth.compareTo(SVNDepth.EMPTY) > 0) {
                            SVNLock[] sVNLockArray2 = null;
                            if (sVNRevision == SVNRevision.HEAD) {
                                try {
                                    sVNLockArray2 = sVNRepository.getLocks("");
                                }
                                catch (SVNException sVNException2) {
                                    SVNErrorCode sVNErrorCode = sVNException2.getErrorMessage().getErrorCode();
                                    if (sVNErrorCode == SVNErrorCode.RA_NOT_IMPLEMENTED || sVNErrorCode == SVNErrorCode.UNSUPPORTED_FEATURE) {
                                        sVNLockArray2 = new SVNLock[]{};
                                    }
                                    throw sVNException2;
                                }
                            } else {
                                sVNLockArray2 = new SVNLock[]{};
                            }
                            sVNLockArray2 = sVNLockArray2 == null ? new SVNLock[]{} : sVNLockArray2;
                            SVNHashMap sVNHashMap = new SVNHashMap();
                            for (int i2 = 0; i2 < sVNLockArray2.length; ++i2) {
                                SVNLock sVNLock = sVNLockArray2[i2];
                                sVNHashMap.put(sVNLock.getPath(), sVNLock);
                            }
                            this.pushDirInfo(sVNRepository, SVNRevision.create(lArray[0]), "", sVNRepository.getRepositoryRoot(true), string2, sVNURL, sVNHashMap, sVNDepth, iSVNInfoHandler);
                            return;
                        }
                        sVNBasicDelegate$SVNRepositoryLocationArray = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Server does not support retrieving information about the repository root");
                        SVNErrorManager.error((SVNErrorMessage)sVNBasicDelegate$SVNRepositoryLocationArray, SVNLogType.WC);
                    }
                    if ((sVNBasicDelegate$SVNRepositoryLocationArray = sVNRepository.checkPath("", lArray[0])) == SVNNodeKind.NONE) {
                        sVNLockArray = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' non-existent in revision {1}", sVNURL, lArray[0]);
                        SVNErrorManager.error((SVNErrorMessage)sVNLockArray, SVNLogType.WC);
                    }
                    sVNLockArray = this.createRepository(sVNURL.removePathTail(), null, null, false);
                    object3 = sVNLockArray.getDir("", lArray[0], null, 57, (Collection)null);
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        SVNDirEntry sVNDirEntry2 = (SVNDirEntry)object2.next();
                        if (!string.equals(sVNDirEntry2.getName())) continue;
                        sVNDirEntry = sVNDirEntry2;
                        break;
                    }
                    if (sVNDirEntry == null) {
                        object2 = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' non-existent in revision {1}", sVNURL, lArray[0]);
                        SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
                    }
                }
                throw sVNException;
            }
            if (sVNDirEntry == null || sVNDirEntry.getKind() == SVNNodeKind.NONE) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' non-existent in revision ''{1}''", sVNURL, lArray[0]);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            object = null;
            if (sVNDirEntry.getKind() == SVNNodeKind.FILE) {
                try {
                    sVNBasicDelegate$SVNRepositoryLocationArray = this.getLocations(sVNURL, null, null, SVNRevision.create(lArray[0]), SVNRevision.HEAD, SVNRevision.UNDEFINED);
                    if (sVNBasicDelegate$SVNRepositoryLocationArray == null || sVNBasicDelegate$SVNRepositoryLocationArray.length <= 0 || !(sVNLockArray = sVNBasicDelegate$SVNRepositoryLocationArray[0].getURL()).equals(sVNURL)) break block28;
                    try {
                        object = sVNRepository.getLock("");
                    }
                    catch (SVNException sVNException) {
                        if (sVNException.getErrorMessage() == null || sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.RA_NOT_IMPLEMENTED) {
                            throw sVNException;
                        }
                    }
                }
                catch (SVNException sVNException) {
                    sVNLockArray = sVNException.getErrorMessage().getErrorCode();
                    if (sVNLockArray == SVNErrorCode.FS_NOT_FOUND || sVNLockArray == SVNErrorCode.CLIENT_UNRELATED_RESOURCES) break block28;
                    throw sVNException;
                }
            }
        }
        sVNBasicDelegate$SVNRepositoryLocationArray = SVNInfo.createInfo(string, sVNURL2, string2, sVNURL, SVNRevision.create(lArray[0]), sVNDirEntry, (SVNLock)object);
        iSVNInfoHandler.handleInfo((SVNInfo)sVNBasicDelegate$SVNRepositoryLocationArray);
        if (sVNDepth.compareTo(SVNDepth.EMPTY) > 0 && sVNDirEntry.getKind() == SVNNodeKind.DIR) {
            sVNLockArray = null;
            if (sVNRevision == SVNRevision.HEAD) {
                try {
                    sVNLockArray = sVNRepository.getLocks("");
                }
                catch (SVNException sVNException) {
                    object2 = sVNException.getErrorMessage().getErrorCode();
                    if (object2 == SVNErrorCode.RA_NOT_IMPLEMENTED || object2 == SVNErrorCode.UNSUPPORTED_FEATURE) {
                        sVNLockArray = new SVNLock[]{};
                    }
                    throw sVNException;
                }
            } else {
                sVNLockArray = new SVNLock[]{};
            }
            sVNLockArray = sVNLockArray == null ? new SVNLock[]{} : sVNLockArray;
            object3 = new SVNHashMap();
            for (int i3 = 0; i3 < sVNLockArray.length; ++i3) {
                object = sVNLockArray[i3];
                object3.put(((SVNLock)object).getPath(), object);
            }
            this.pushDirInfo(sVNRepository, SVNRevision.create(lArray[0]), "", sVNRepository.getRepositoryRoot(true), string2, sVNURL, (Map)object3, sVNDepth, iSVNInfoHandler);
        }
    }

    public String doGetWorkingCopyID(File file, String string) {
        return this.doGetWorkingCopyID(file, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGetWorkingCopyID(File file, String string, boolean bl2) {
        try (SVNWCAccess sVNWCAccess = this.createWCAccess();){
            sVNWCAccess.open(file, false, 0);
        }
        SVNStatusClient16 sVNStatusClient16 = new SVNStatusClient16((ISVNAuthenticationManager)null, this.getOptions());
        sVNStatusClient16.setIgnoreExternals(true);
        long[] lArray = new long[1];
        long[] lArray2 = new long[]{-1L};
        boolean[] blArray = new boolean[3];
        String[] stringArray = new String[1];
        sVNStatusClient16.doStatus(file, SVNRevision.WORKING, SVNDepth.INFINITY, false, true, false, false, new SVNWCClient16$9(this, bl2, lArray2, lArray, blArray, stringArray, file), null);
        if (!blArray[0] && string != null) {
            blArray[0] = stringArray[0] == null ? true : !stringArray[0].endsWith(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(lArray2[0]);
        if (lArray2[0] != lArray[0]) {
            stringBuffer.append(":").append(lArray[0]);
        }
        if (blArray[1]) {
            stringBuffer.append("M");
        }
        if (blArray[0]) {
            stringBuffer.append("S");
        }
        if (blArray[2]) {
            stringBuffer.append("P");
        }
        return stringBuffer.toString();
    }

    public SVNInfo doInfo(File file, SVNRevision sVNRevision) {
        SVNInfo[] sVNInfoArray = new SVNInfo[1];
        this.doInfo(file, SVNRevision.UNDEFINED, sVNRevision, SVNDepth.EMPTY, null, new SVNWCClient16$10(this, sVNInfoArray));
        return sVNInfoArray[0];
    }

    public SVNInfo doInfo(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2) {
        SVNInfo[] sVNInfoArray = new SVNInfo[1];
        this.doInfo(sVNURL, sVNRevision, sVNRevision2, SVNDepth.EMPTY, (ISVNInfoHandler)new SVNWCClient16$11(this, sVNInfoArray));
        return sVNInfoArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCleanupWCProperties(File file) {
        try (SVNWCAccess sVNWCAccess = SVNWCAccess.newInstance(this);){
            SVNAdminArea sVNAdminArea = sVNWCAccess.open(file, true, true, -1);
            if (sVNAdminArea != null) {
                SVNPropertiesManager.deleteWCProperties(sVNAdminArea, null, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetWCFormat(File file, int n2) {
        SVNAdminAreaInfo sVNAdminAreaInfo = null;
        try (SVNWCAccess sVNWCAccess = SVNWCAccess.newInstance(this);){
            sVNAdminAreaInfo = sVNWCAccess.openAnchor(file, false, -1);
            this.setWCFormat(sVNAdminAreaInfo, sVNAdminAreaInfo.getTarget(), n2);
        }
        if (!this.isIgnoreExternals() && sVNAdminAreaInfo != null) {
            File file2;
            String string;
            int n3;
            SVNExternal[] sVNExternalArray;
            String string2;
            SVNHashSet sVNHashSet = new SVNHashSet();
            Map map = sVNAdminAreaInfo.getOldExternals();
            for (String string3 : map.keySet()) {
                string2 = (String)map.get(string3);
                if (string2 == null) continue;
                sVNExternalArray = SVNExternal.parseExternals("", string2);
                for (n3 = 0; n3 < sVNExternalArray.length; ++n3) {
                    string = sVNExternalArray[n3].getPath();
                    file2 = new File(sVNAdminAreaInfo.getAnchor().getRoot(), SVNPathUtil.append(string3, string));
                    if (!sVNHashSet.add(file2)) continue;
                    try {
                        sVNWCAccess.open(file2, false, 0);
                    }
                    catch (SVNException sVNException) {
                        if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) continue;
                        throw sVNException;
                    }
                    finally {
                        sVNWCAccess.close();
                    }
                    try {
                        this.doSetWCFormat(file2, n2);
                        continue;
                    }
                    catch (SVNException sVNException) {
                        if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) continue;
                        throw sVNException;
                    }
                }
            }
            map = sVNAdminAreaInfo.getNewExternals();
            for (String string3 : map.keySet()) {
                string2 = (String)map.get(string3);
                if (string2 == null) continue;
                sVNExternalArray = SVNExternal.parseExternals("", string2);
                for (n3 = 0; n3 < sVNExternalArray.length; ++n3) {
                    string = sVNExternalArray[n3].getPath();
                    file2 = new File(sVNAdminAreaInfo.getAnchor().getRoot(), SVNPathUtil.append(string3, string));
                    if (!sVNHashSet.add(file2)) continue;
                    try {
                        sVNWCAccess.open(file2, false, 0);
                    }
                    catch (SVNException sVNException) {
                        if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) continue;
                        throw sVNException;
                    }
                    finally {
                        sVNWCAccess.close();
                    }
                    try {
                        this.doSetWCFormat(file2, n2);
                        continue;
                    }
                    catch (SVNException sVNException) {
                        if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) continue;
                        throw sVNException;
                    }
                }
            }
        }
    }

    public void doSetProperty(File file, String string, SVNPropertyValue sVNPropertyValue, boolean bl2, boolean bl3, ISVNPropertyHandler iSVNPropertyHandler) {
        this.doSetProperty(file, string, sVNPropertyValue, bl2, SVNDepth.getInfinityOrEmptyDepth(bl3), iSVNPropertyHandler, null);
    }

    private SVNAdminArea addParentDirectories(SVNWCAccess sVNWCAccess, File file) {
        try {
            return sVNWCAccess.open(file, true, 0);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                if (file.getParentFile() == null) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_NO_VERSIONED_PARENT);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                } else if (SVNFileUtil.getAdminDirectoryName().equals(file.getName())) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RESERVED_FILENAME_SPECIFIED, "''{0}'' ends in a reserved name", (Object)file);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                } else {
                    File file2 = file.getParentFile();
                    SVNAdminArea sVNAdminArea = this.addParentDirectories(sVNWCAccess, file2);
                    SVNWCManager.add(file, sVNAdminArea, null, SVNRevision.UNDEFINED, SVNDepth.INFINITY);
                    return sVNWCAccess.getAdminArea(file);
                }
            }
            throw sVNException;
        }
    }

    private void doGetRevisionProperty(SVNRepository sVNRepository, String string, long l2, ISVNPropertyHandler iSVNPropertyHandler) {
        if (string != null) {
            SVNPropertyValue sVNPropertyValue = sVNRepository.getRevisionPropertyValue(l2, string);
            if (sVNPropertyValue != null) {
                iSVNPropertyHandler.handleProperty(l2, new SVNPropertyData(string, sVNPropertyValue, this.getOptions()));
            }
        } else {
            SVNProperties sVNProperties = new SVNProperties();
            sVNRepository.getRevisionProperties(l2, sVNProperties);
            for (String string2 : sVNProperties.nameSet()) {
                SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string2);
                iSVNPropertyHandler.handleProperty(l2, new SVNPropertyData(string2, sVNPropertyValue, this.getOptions()));
            }
        }
    }

    private void addDirectory(File file, File file2, SVNAdminArea sVNAdminArea, boolean bl2, boolean bl3, SVNDepth sVNDepth, boolean bl4) {
        String string;
        block9: {
            this.checkCancelled();
            try {
                SVNWCManager.add(file2, sVNAdminArea, null, SVNRevision.UNDEFINED, bl4 ? SVNDepth.INFINITY : null);
            }
            catch (SVNException sVNException) {
                if (bl2 && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_EXISTS) break block9;
                throw sVNException;
            }
        }
        SVNWCAccess sVNWCAccess = sVNAdminArea.getWCAccess();
        SVNAdminArea sVNAdminArea2 = sVNWCAccess.retrieve(file2);
        Collection collection = Collections.EMPTY_SET;
        if (!bl3) {
            collection = SVNStatusEditor.getIgnorePatterns(sVNAdminArea2, SVNStatusEditor.getGlobalIgnores(this.getOptions()));
        }
        string = (string = SVNPathUtil.getRelativePath(file.getAbsolutePath().replace(File.separatorChar, '/'), sVNAdminArea2.getRoot().getAbsolutePath().replace(File.separatorChar, '/'))) != null ? "/" + string : null;
        File[] fileArray = SVNFileListUtil.listFiles(sVNAdminArea2.getRoot());
        for (int i2 = 0; fileArray != null && i2 < fileArray.length; ++i2) {
            SVNFileType sVNFileType;
            this.checkCancelled();
            if (SVNFileUtil.getAdminDirectoryName().equals(fileArray[i2].getName())) continue;
            if (!bl3) {
                SVNFileType sVNFileType2 = sVNFileType = string != null ? SVNPathUtil.append(string, fileArray[i2].getName()) : null;
                if (SVNStatusEditor.isIgnored(collection, fileArray[i2], (String)((Object)sVNFileType))) continue;
            }
            if ((sVNFileType = SVNFileType.getType(fileArray[i2])) == SVNFileType.DIRECTORY && sVNDepth.compareTo(SVNDepth.IMMEDIATES) >= 0) {
                SVNDepth sVNDepth2 = sVNDepth;
                if (sVNDepth == SVNDepth.IMMEDIATES) {
                    sVNDepth2 = SVNDepth.EMPTY;
                }
                this.addDirectory(file, fileArray[i2], sVNAdminArea2, bl2, bl3, sVNDepth2, bl4);
                continue;
            }
            if (sVNFileType == SVNFileType.UNKNOWN || sVNFileType == SVNFileType.DIRECTORY || sVNDepth.compareTo(SVNDepth.FILES) < 0) continue;
            try {
                this.addFile(fileArray[i2], sVNFileType, sVNAdminArea2);
                continue;
            }
            catch (SVNException sVNException) {
                if (bl2 && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_EXISTS) continue;
                throw sVNException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(File file, SVNFileType sVNFileType, SVNAdminArea sVNAdminArea) {
        Object object;
        ISVNEventHandler iSVNEventHandler = sVNAdminArea.getWCAccess().getEventHandler();
        sVNAdminArea.getWCAccess().setEventHandler(null);
        SVNWCManager.add(file, sVNAdminArea, null, SVNRevision.UNDEFINED, null);
        sVNAdminArea.getWCAccess().setEventHandler(iSVNEventHandler);
        String string = null;
        if (sVNFileType == SVNFileType.SYMLINK) {
            SVNPropertiesManager.setProperty(sVNAdminArea.getWCAccess(), file, "svn:special", SVNProperty.getValueOfBooleanProperty("svn:special"), false);
        } else {
            object = SVNPropertiesManager.computeAutoProperties(this.getOptions(), file, null);
            for (String string2 : object.keySet()) {
                String string3 = (String)object.get(string2);
                try {
                    SVNPropertiesManager.setProperty(sVNAdminArea.getWCAccess(), file, string2, SVNPropertyValue.create(string3), false);
                }
                catch (SVNException sVNException) {
                    Object object2;
                    if ("svn:eol-style".equals(string2) && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.ILLEGAL_TARGET && sVNException.getErrorMessage().getMessage().indexOf("newlines") >= 0) {
                        object2 = this.getAddParameters().onInconsistentEOLs(file);
                        if (object2 == ISVNAddParameters.REPORT_ERROR) {
                            ISVNEventHandler iSVNEventHandler2 = this.getEventDispatcher();
                            try {
                                this.setEventHandler(null);
                                this.doRevert(file, sVNAdminArea, SVNDepth.EMPTY, false, null);
                            }
                            catch (SVNException sVNException2) {
                            }
                            finally {
                                this.setEventHandler(iSVNEventHandler2);
                            }
                            throw sVNException;
                        }
                        if (object2 == ISVNAddParameters.ADD_AS_IS) {
                            SVNPropertiesManager.setProperty(sVNAdminArea.getWCAccess(), file, string2, null, false);
                            continue;
                        }
                        if (object2 != ISVNAddParameters.ADD_AS_BINARY) continue;
                        SVNPropertiesManager.setProperty(sVNAdminArea.getWCAccess(), file, string2, null, false);
                        string = "application/octet-stream";
                        continue;
                    }
                    object2 = this.getEventDispatcher();
                    try {
                        this.setEventHandler(null);
                        this.doRevert(file, sVNAdminArea, SVNDepth.EMPTY, false, null);
                    }
                    catch (SVNException sVNException3) {
                    }
                    finally {
                        this.setEventHandler((ISVNEventHandler)object2);
                    }
                    throw sVNException;
                }
            }
            if (string != null) {
                SVNPropertiesManager.setProperty(sVNAdminArea.getWCAccess(), file, "svn:mime-type", SVNPropertyValue.create(string), false);
            } else {
                string = (String)object.get("svn:mime-type");
            }
        }
        object = SVNEventFactory.createSVNEvent(sVNAdminArea.getFile(file.getName()), SVNNodeKind.FILE, string, -1L, SVNEventAction.ADD, null, null, null);
        this.dispatchEvent((SVNEvent)object);
    }

    private SVNURL collectLockInfo(SVNWCAccess sVNWCAccess, File[] fileArray, Map map, Map map2, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        int n2;
        String[] stringArray = new String[fileArray.length];
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            stringArray[i2] = fileArray[i2].getAbsolutePath();
            stringArray[i2] = stringArray[i2].replace(File.separatorChar, '/');
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = SVNPathUtil.condencePaths(stringArray, arrayList, false);
        if (arrayList.isEmpty()) {
            arrayList.add(SVNPathUtil.tail(string));
            string = SVNPathUtil.removeTail(string);
        }
        if (string == null || "".equals(string)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "No common parent found, unable to operate on dijoint arguments");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        int n3 = 0;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            int n4 = SVNPathUtil.getSegmentsCount(stringArray[n2]);
            if (n3 >= n4) continue;
            n3 = n4;
        }
        sVNWCAccess.probeOpen(new File(string).getAbsoluteFile(), true, n3);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            File file = new File(string, stringArray[n2]);
            object2 = sVNWCAccess.getVersionedEntry(file, false);
            if (((SVNEntry)object2).getURL() == null) {
                object = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            if (bl2) {
                object = bl3 ? SVNRevision.UNDEFINED : SVNRevision.create(((SVNEntry)object2).getRevision());
                map.put(((SVNEntry)object2).getSVNURL(), new SVNWCClient16$LockInfo(file, (SVNRevision)object));
                continue;
            }
            if (!bl3 && ((SVNEntry)object2).getLockToken() == null) {
                object = SVNErrorMessage.create(SVNErrorCode.CLIENT_MISSING_LOCK_TOKEN, "''{0}'' is not locked in this working copy", (Object)file);
                SVNErrorManager.error(object, SVNLogType.WC);
            }
            map.put(((SVNEntry)object2).getSVNURL(), new SVNWCClient16$LockInfo(file, bl3 ? null : ((SVNEntry)object2).getLockToken()));
        }
        this.checkCancelled();
        SVNURL[] sVNURLArray = map.keySet().toArray(new SVNURL[map.size()]);
        SVNHashSet sVNHashSet = new SVNHashSet();
        object2 = SVNURLUtil.condenceURLs(sVNURLArray, sVNHashSet, false);
        if (sVNHashSet.isEmpty()) {
            sVNHashSet.add("");
        }
        if (object2 == null) {
            object = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Unable to lock/unlock across multiple repositories");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        for (String string2 : sVNHashSet) {
            SVNURL sVNURL = ((SVNURL)object2).appendPath(string2, true);
            SVNWCClient16$LockInfo sVNWCClient16$LockInfo = (SVNWCClient16$LockInfo)map.get(sVNURL);
            string2 = SVNEncodingUtil.uriDecode(string2);
            if (bl2) {
                if (SVNWCClient16$LockInfo.access$100(sVNWCClient16$LockInfo) == SVNRevision.UNDEFINED) {
                    map2.put(string2, null);
                    continue;
                }
                map2.put(string2, SVNWCClient16$LockInfo.access$100(sVNWCClient16$LockInfo).getNumber());
                continue;
            }
            map2.put(string2, SVNWCClient16$LockInfo.access$200(sVNWCClient16$LockInfo));
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crawlEntries(File file, SVNDepth sVNDepth, Collection collection, ISVNInfoHandler iSVNInfoHandler) {
        SVNWCAccess sVNWCAccess = this.createWCAccess();
        int n2 = this.getLevelsToLockFromDepth(sVNDepth);
        try {
            sVNWCAccess.probeOpen(file, false, n2);
            sVNWCAccess.walkEntries(file, new SVNWCClient16$12(this, collection, iSVNInfoHandler, sVNWCAccess), false, sVNDepth);
        }
        finally {
            sVNWCAccess.close();
        }
    }

    private void reportEntry(File file, SVNEntry sVNEntry, ISVNInfoHandler iSVNInfoHandler) {
        if (sVNEntry.isDirectory() && !"".equals(sVNEntry.getName())) {
            return;
        }
        iSVNInfoHandler.handleInfo(SVNInfo.createInfo(file, sVNEntry));
    }

    private boolean doRevert(File file, SVNAdminArea sVNAdminArea, SVNDepth sVNDepth, boolean bl2, Collection collection) {
        Object object;
        Object object2;
        this.checkCancelled();
        SVNWCAccess sVNWCAccess = sVNAdminArea.getWCAccess();
        SVNAdminArea sVNAdminArea2 = sVNWCAccess.probeRetrieve(file);
        SVNEntry sVNEntry = sVNWCAccess.getEntry(file, false);
        SVNTreeConflictDescription sVNTreeConflictDescription = sVNWCAccess.getTreeConflict(file);
        if (sVNEntry == null && sVNTreeConflictDescription == null) {
            object2 = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "Cannot revert unversioned item ''{0}''", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
        }
        if (sVNEntry != null && sVNEntry.getKind() == SVNNodeKind.DIR && (object2 = SVNFileType.getType(file)) != SVNFileType.DIRECTORY && !sVNEntry.isScheduledForAddition()) {
            if (this.isRevertMissingDirectories() && sVNEntry.getSchedule() != null && !sVNEntry.isThisDir()) {
                boolean bl3 = this.revert(sVNAdminArea, sVNEntry.getName(), sVNEntry, bl2);
                if (bl3) {
                    SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(sVNAdminArea2.getFile(sVNEntry.getName()), sVNEntry.getKind(), null, sVNEntry.getRevision(), SVNEventAction.REVERT, null, null, null);
                    this.dispatchEvent(sVNEvent);
                }
                return bl3;
            }
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(sVNAdminArea2.getFile(sVNEntry.getName()), sVNEntry.getKind(), null, sVNEntry.getRevision(), SVNEventAction.FAILED_REVERT, null, null, null);
            this.dispatchEvent(sVNEvent);
            return false;
        }
        if (sVNEntry != null && sVNEntry.getKind() != SVNNodeKind.DIR && sVNEntry.getKind() != SVNNodeKind.FILE) {
            object2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot revert ''{0}'': unsupported entry node kind", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
        }
        if ((object2 = SVNFileType.getType(file)) == SVNFileType.UNKNOWN) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot revert ''{0}'': unsupported node kind in working copy", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        boolean bl4 = false;
        if (SVNWCAccess.matchesChangeList(collection, sVNEntry)) {
            if (sVNTreeConflictDescription != null) {
                sVNAdminArea.deleteTreeConflict(file.getName());
                bl4 = true;
            }
            if (sVNEntry != null) {
                if (sVNEntry.isScheduledForAddition()) {
                    boolean bl5 = false;
                    if (sVNEntry.getKind() == SVNNodeKind.FILE) {
                        bl5 = sVNEntry.isDeleted();
                        sVNAdminArea.removeFromRevisionControl(file.getName(), false, false);
                    } else if (sVNEntry.getKind() == SVNNodeKind.DIR) {
                        object = sVNAdminArea.getEntry(file.getName(), true);
                        if (object != null) {
                            bl5 = ((SVNEntry)object).isDeleted();
                        }
                        if (object2 == SVNFileType.NONE || sVNWCAccess.isMissing(file)) {
                            sVNAdminArea.deleteEntry(file.getName());
                            sVNAdminArea.saveEntries(false);
                        } else {
                            sVNAdminArea2.removeFromRevisionControl("", false, false);
                        }
                    }
                    bl4 = true;
                    sVNDepth = SVNDepth.EMPTY;
                    if (bl5) {
                        object = new SVNHashMap();
                        object.put("svn:entry:kind", sVNEntry.getKind().toString());
                        object.put("svn:entry:deleted", Boolean.TRUE.toString());
                        sVNAdminArea.modifyEntry(file.getName(), (Map)object, true, false);
                    }
                } else if (sVNEntry.getSchedule() == null || sVNEntry.isScheduledForDeletion() || sVNEntry.isScheduledForReplacement()) {
                    if (sVNEntry.getKind() == SVNNodeKind.FILE) {
                        bl4 = this.revert(sVNAdminArea, sVNEntry.getName(), sVNEntry, bl2);
                    } else if (sVNEntry.getKind() == SVNNodeKind.DIR) {
                        bl4 = this.revert(sVNAdminArea2, sVNAdminArea2.getThisDirName(), sVNEntry, bl2);
                        if (bl4 && sVNAdminArea != sVNAdminArea2) {
                            SVNEntry sVNEntry2 = sVNAdminArea.getEntry(file.getName(), false);
                            this.revert(sVNAdminArea, file.getName(), sVNEntry2, bl2);
                        }
                        if (sVNEntry.isScheduledForReplacement()) {
                            sVNDepth = SVNDepth.INFINITY;
                        }
                    }
                }
            }
            if (bl4) {
                SVNEvent sVNEvent = null;
                sVNEvent = sVNEntry != null ? SVNEventFactory.createSVNEvent(sVNAdminArea2.getFile(sVNEntry.getName()), sVNEntry.getKind(), null, sVNEntry.getRevision(), SVNEventAction.REVERT, null, null, null) : SVNEventFactory.createSVNEvent(file, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.REVERT, null, null, null);
                this.dispatchEvent(sVNEvent);
            }
        }
        if (sVNEntry != null && sVNEntry.getKind() == SVNNodeKind.DIR && sVNDepth.compareTo(SVNDepth.EMPTY) > 0) {
            SVNDepth sVNDepth2 = sVNDepth;
            if (sVNDepth == SVNDepth.FILES || sVNDepth == SVNDepth.IMMEDIATES) {
                sVNDepth2 = SVNDepth.EMPTY;
            }
            object = sVNAdminArea2.entries(false);
            while (object.hasNext()) {
                SVNEntry sVNEntry3 = (SVNEntry)object.next();
                if (sVNAdminArea2.getThisDirName().equals(sVNEntry3.getName()) || sVNDepth == SVNDepth.FILES && !sVNEntry3.isFile()) continue;
                File file2 = new File(file, sVNEntry3.getName());
                bl4 |= this.doRevert(file2, sVNAdminArea2, sVNDepth2, bl2, collection);
            }
            object = SVNTreeConflictUtil.readTreeConflicts(file, sVNEntry.getTreeConflictData());
            for (File file2 : object.keySet()) {
                if (sVNAdminArea2.getEntry(file2.getName(), false) != null) continue;
                bl4 |= this.doRevert(file2, sVNAdminArea2, SVNDepth.EMPTY, bl2, collection);
            }
        }
        return bl4;
    }

    private boolean revert(SVNAdminArea sVNAdminArea, String string, SVNEntry sVNEntry, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        SVNLog sVNLog = sVNAdminArea.getLog();
        boolean bl3 = false;
        SVNVersionedProperties sVNVersionedProperties = null;
        SVNProperties sVNProperties = new SVNProperties();
        boolean bl4 = false;
        if (sVNEntry.isScheduledForReplacement()) {
            bl4 = true;
            sVNVersionedProperties = sVNAdminArea.getRevertProperties(string);
            String string2 = SVNAdminUtil.getPropRevertPath(string, sVNEntry.getKind(), false);
            sVNProperties.put("name", string2);
            sVNLog.addCommand("rm", sVNProperties, false);
            sVNProperties.clear();
            bl3 = true;
        }
        boolean bl5 = false;
        if (sVNVersionedProperties == null && sVNAdminArea.hasPropModifications(string)) {
            sVNVersionedProperties = sVNAdminArea.getBaseProperties(string);
            object4 = sVNAdminArea.getProperties(string).compareTo(sVNVersionedProperties);
            object3 = ((SVNVersionedProperties)object4).getPropertyNames(null);
            boolean bl6 = bl5 = object3.contains("svn:executable") || object3.contains("svn:keywords") || object3.contains("svn:eol-style") || object3.contains("svnkit:charset") || object3.contains("svn:special") || object3.contains("svn:needs-lock");
        }
        if (sVNVersionedProperties != null) {
            object4 = sVNVersionedProperties.asMap();
            object3 = sVNAdminArea.getBaseProperties(string);
            object2 = sVNAdminArea.getProperties(string);
            if (bl4) {
                ((SVNVersionedProperties)object3).removeAll();
            }
            ((SVNVersionedProperties)object2).removeAll();
            object = ((SVNProperties)object4).nameSet().iterator();
            while (object.hasNext()) {
                String string3 = (String)object.next();
                if (bl4) {
                    ((SVNVersionedProperties)object3).setPropertyValue(string3, ((SVNProperties)object4).getSVNPropertyValue(string3));
                }
                ((SVNVersionedProperties)object2).setPropertyValue(string3, ((SVNProperties)object4).getSVNPropertyValue(string3));
            }
            sVNAdminArea.saveVersionedProperties(sVNLog, false);
            bl3 = true;
        }
        object4 = new SVNProperties();
        if (sVNEntry.getKind() == SVNNodeKind.FILE) {
            object3 = SVNAdminUtil.getTextBasePath(string, false);
            object2 = SVNAdminUtil.getTextRevertPath(string, false);
            if (!bl5 && (object = SVNFileType.getType(sVNAdminArea.getFile(string))) == SVNFileType.NONE) {
                bl5 = true;
            }
            if (sVNAdminArea.getFile((String)object2).isFile()) {
                bl5 = true;
            } else {
                if (!sVNAdminArea.getFile((String)object3).isFile()) {
                    object = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Error restoring text for ''{0}''", (Object)sVNAdminArea.getFile(string));
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
                }
                object2 = null;
            }
            if (object2 != null) {
                sVNProperties.put("name", (String)object2);
                sVNProperties.put("dest", string);
                sVNLog.addCommand("cp-and-translate", sVNProperties, false);
                sVNProperties.clear();
                sVNProperties.put("name", (String)object2);
                sVNProperties.put("dest", (String)object3);
                sVNLog.addCommand("mv", sVNProperties, false);
                bl3 = true;
            } else {
                if (!bl5) {
                    bl5 = sVNAdminArea.hasTextModifications(string, false, false, false);
                }
                if (bl5) {
                    sVNProperties.put("name", SVNAdminUtil.getTextBasePath(string, false));
                    sVNProperties.put("dest", string);
                    sVNLog.addCommand("cp-and-translate", sVNProperties, false);
                    sVNProperties.clear();
                    if (bl2 && sVNEntry.getCommittedDate() != null) {
                        sVNProperties.put("name", string);
                        sVNProperties.put("timestamp", sVNEntry.getCommittedDate());
                        sVNLog.addCommand("set-timestamp", sVNProperties, false);
                        sVNProperties.clear();
                    } else {
                        sVNProperties.put("name", string);
                        sVNProperties.put("timestamp", SVNDate.formatDate(new Date(System.currentTimeMillis())));
                        sVNLog.addCommand("set-timestamp", sVNProperties, false);
                        sVNProperties.clear();
                    }
                    sVNProperties.put("name", string);
                    sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:text-time"), "working");
                    sVNLog.addCommand("modify-entry", sVNProperties, false);
                    sVNProperties.clear();
                    sVNProperties.put("name", string);
                    sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:working-size"), "working");
                    sVNLog.addCommand("modify-entry", sVNProperties, false);
                    sVNProperties.clear();
                }
                bl3 |= bl5;
            }
        }
        if (sVNEntry.getConflictNew() != null) {
            sVNProperties.put("name", sVNEntry.getConflictNew());
            sVNLog.addCommand("rm", sVNProperties, false);
            sVNProperties.clear();
            ((SVNProperties)object4).put(SVNProperty.shortPropertyName("svn:entry:conflict-new"), (String)null);
            if (!bl3) {
                bl3 |= sVNAdminArea.getFile(sVNEntry.getConflictNew()).exists();
            }
        }
        if (sVNEntry.getConflictOld() != null) {
            sVNProperties.put("name", sVNEntry.getConflictOld());
            sVNLog.addCommand("rm", sVNProperties, false);
            sVNProperties.clear();
            ((SVNProperties)object4).put(SVNProperty.shortPropertyName("svn:entry:conflict-old"), (String)null);
            if (!bl3) {
                bl3 |= sVNAdminArea.getFile(sVNEntry.getConflictOld()).exists();
            }
        }
        if (sVNEntry.getConflictWorking() != null) {
            sVNProperties.put("name", sVNEntry.getConflictWorking());
            sVNLog.addCommand("rm", sVNProperties, false);
            sVNProperties.clear();
            ((SVNProperties)object4).put(SVNProperty.shortPropertyName("svn:entry:conflict-wrk"), (String)null);
            if (!bl3) {
                bl3 |= sVNAdminArea.getFile(sVNEntry.getConflictWorking()).exists();
            }
        }
        if (sVNEntry.getPropRejectFile() != null) {
            sVNProperties.put("name", sVNEntry.getPropRejectFile());
            sVNLog.addCommand("rm", sVNProperties, false);
            sVNProperties.clear();
            ((SVNProperties)object4).put(SVNProperty.shortPropertyName("svn:entry:prop-reject-file"), (String)null);
            if (!bl3) {
                bl3 |= sVNAdminArea.getFile(sVNEntry.getPropRejectFile()).exists();
            }
        }
        if (sVNEntry.isScheduledForReplacement()) {
            ((SVNProperties)object4).put(SVNProperty.shortPropertyName("svn:entry:copied"), SVNProperty.toString(false));
            ((SVNProperties)object4).put(SVNProperty.shortPropertyName("svn:entry:copyfrom-url"), (String)null);
            ((SVNProperties)object4).put(SVNProperty.shortPropertyName("svn:entry:copyfrom-rev"), SVNProperty.toString(-1L));
            if (sVNEntry.isFile() && sVNEntry.getCopyFromURL() != null) {
                object3 = SVNAdminUtil.getTextRevertPath(string, false);
                object2 = sVNAdminArea.getFile((String)object3);
                object = SVNFileUtil.computeChecksum((File)object2);
                ((SVNProperties)object4).put(SVNProperty.shortPropertyName("svn:entry:checksum"), (String)object);
            }
        }
        if (sVNEntry.getSchedule() != null) {
            ((SVNProperties)object4).put(SVNProperty.shortPropertyName("svn:entry:schedule"), (String)null);
            bl3 = true;
        }
        if (!((SVNProperties)object4).isEmpty()) {
            ((SVNProperties)object4).put("name", string);
            sVNLog.addCommand("modify-entry", (SVNProperties)object4, false);
        }
        sVNLog.save();
        sVNAdminArea.runLogs();
        return bl3;
    }

    private void setWCFormat(SVNAdminAreaInfo sVNAdminAreaInfo, SVNAdminArea sVNAdminArea, int n2) {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        Object object4;
        if (!this.isIgnoreExternals()) {
            object4 = sVNAdminArea.getProperties(sVNAdminArea.getThisDirName());
            object3 = sVNAdminArea.getBaseProperties(sVNAdminArea.getThisDirName());
            object2 = ((SVNVersionedProperties)object4).getPropertyValue("svn:externals");
            serializable = ((SVNVersionedProperties)object3).getPropertyValue("svn:externals");
            if (object2 != null || serializable != null) {
                object = sVNAdminArea.getRelativePath(sVNAdminAreaInfo.getAnchor());
                sVNAdminAreaInfo.addExternal((String)object, object2 != null ? ((SVNPropertyValue)object2).getString() : null, serializable != null ? serializable.getString() : null);
            }
        }
        sVNAdminArea.getWCAccess().closeAdminArea(sVNAdminArea.getRoot());
        sVNAdminArea = sVNAdminArea.getWCAccess().open(sVNAdminArea.getRoot(), true, false, false, 0, Level.FINE);
        object4 = SVNAdminAreaFactory.changeWCFormat(sVNAdminArea, n2);
        object3 = ((SVNAdminArea)object4).entries(false);
        while (object3.hasNext()) {
            object2 = (SVNEntry)object3.next();
            if (((SVNEntry)object2).isThisDir() || ((SVNEntry)object2).isFile()) continue;
            serializable = new File(((SVNAdminArea)object4).getRoot(), ((SVNEntry)object2).getName());
            object = ((SVNAdminArea)object4).getWCAccess().getAdminArea((File)serializable);
            if (object == null) continue;
            this.setWCFormat(sVNAdminAreaInfo, (SVNAdminArea)object, n2);
        }
    }

    private void pushDirInfo(SVNRepository sVNRepository, SVNRevision sVNRevision, String string, SVNURL sVNURL, String string2, SVNURL sVNURL2, Map map, SVNDepth sVNDepth, ISVNInfoHandler iSVNInfoHandler) {
        Collection collection = sVNRepository.getDir(string, sVNRevision.getNumber(), null, 57, new ArrayList());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.checkCancelled();
            SVNDirEntry sVNDirEntry = (SVNDirEntry)iterator.next();
            SVNURL sVNURL3 = sVNURL2.appendPath(sVNDirEntry.getName(), false);
            String string3 = SVNPathUtil.append(string, sVNDirEntry.getName());
            String string4 = sVNRepository.getFullPath(string3);
            string4 = string4.substring(sVNRepository.getLocation().getPath().length());
            if (string4.startsWith("/")) {
                string4 = string4.substring(1);
            }
            if ("".equals(string4)) {
                string4 = string;
            }
            SVNLock sVNLock = (SVNLock)map.get(string);
            SVNInfo sVNInfo = SVNInfo.createInfo(string4, sVNURL, string2, sVNURL3, sVNRevision, sVNDirEntry, sVNLock);
            if (sVNDepth.compareTo(SVNDepth.IMMEDIATES) >= 0 || sVNDepth == SVNDepth.FILES && sVNDirEntry.getKind() == SVNNodeKind.FILE) {
                iSVNInfoHandler.handleInfo(sVNInfo);
            }
            if (sVNDepth != SVNDepth.INFINITY || sVNDirEntry.getKind() != SVNNodeKind.DIR) continue;
            this.pushDirInfo(sVNRepository, sVNRevision, SVNPathUtil.append(string, sVNDirEntry.getName()), sVNURL, string2, sVNURL3, map, sVNDepth, iSVNInfoHandler);
        }
    }

    private void doGetRemoteProperty(SVNURL sVNURL, String string, SVNRepository sVNRepository, String string2, SVNRevision sVNRevision, SVNDepth sVNDepth, ISVNPropertyHandler iSVNPropertyHandler) {
        this.checkCancelled();
        long l2 = this.getRevisionNumber(sVNRevision, sVNRepository, null);
        SVNNodeKind sVNNodeKind = sVNRepository.checkPath(string, l2);
        SVNProperties sVNProperties = new SVNProperties();
        if (sVNNodeKind == SVNNodeKind.DIR) {
            Object object;
            Collection collection = sVNRepository.getDir(string, l2, sVNProperties, 1, SVNDepth.FILES.compareTo(sVNDepth) <= 0 ? new ArrayList() : null);
            if (string2 != null) {
                SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string2);
                if (sVNPropertyValue != null) {
                    iSVNPropertyHandler.handleProperty(sVNURL, new SVNPropertyData(string2, sVNPropertyValue, this.getOptions()));
                }
            } else {
                for (Object object2 : sVNProperties.nameSet()) {
                    if (((String)object2).startsWith("svn:entry:") || ((String)object2).startsWith("svn:wc:")) continue;
                    object = sVNProperties.getSVNPropertyValue((String)object2);
                    iSVNPropertyHandler.handleProperty(sVNURL, new SVNPropertyData((String)object2, (SVNPropertyValue)object, this.getOptions()));
                }
            }
            if (SVNDepth.FILES.compareTo(sVNDepth) <= 0) {
                this.checkCancelled();
                for (Object object2 : collection) {
                    object = sVNURL.appendPath(((SVNDirEntry)object2).getName(), false);
                    String string3 = "".equals(string) ? ((SVNDirEntry)object2).getName() : SVNPathUtil.append(string, ((SVNDirEntry)object2).getName());
                    SVNDepth sVNDepth2 = sVNDepth;
                    if (((SVNDirEntry)object2).getKind() == SVNNodeKind.DIR && sVNDepth == SVNDepth.FILES) continue;
                    if (sVNDepth == SVNDepth.FILES || sVNDepth == SVNDepth.IMMEDIATES) {
                        sVNDepth2 = SVNDepth.EMPTY;
                    }
                    this.doGetRemoteProperty((SVNURL)object, string3, sVNRepository, string2, sVNRevision, sVNDepth2, iSVNPropertyHandler);
                }
            }
        } else if (sVNNodeKind == SVNNodeKind.FILE) {
            sVNRepository.getFile(string, l2, sVNProperties, null);
            if (string2 != null) {
                SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string2);
                if (sVNPropertyValue != null) {
                    iSVNPropertyHandler.handleProperty(sVNURL, new SVNPropertyData(string2, sVNPropertyValue, this.getOptions()));
                }
            } else {
                for (String string4 : sVNProperties.nameSet()) {
                    if (string4.startsWith("svn:entry:") || string4.startsWith("svn:wc:")) continue;
                    SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string4);
                    iSVNPropertyHandler.handleProperty(sVNURL, new SVNPropertyData(string4, sVNPropertyValue, this.getOptions()));
                }
            }
        } else if (sVNNodeKind == SVNNodeKind.NONE) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' does not exist in revision {1}", string, String.valueOf(l2));
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        } else {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unknown node kind for ''{0}''", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
    }

    private void doGetLocalProperty(SVNEntry sVNEntry, SVNAdminArea sVNAdminArea, String string, boolean bl2, ISVNPropertyHandler iSVNPropertyHandler, SVNDepth sVNDepth, Collection collection) {
        if (sVNDepth == null || sVNDepth == SVNDepth.UNKNOWN) {
            sVNDepth = SVNDepth.EMPTY;
        }
        File file = sVNAdminArea.getFile(sVNEntry.getName());
        SVNWCAccess sVNWCAccess = sVNAdminArea.getWCAccess();
        SVNWCClient16$PropFetchHandler sVNWCClient16$PropFetchHandler = new SVNWCClient16$PropFetchHandler(this, collection, string, iSVNPropertyHandler, bl2);
        if (SVNDepth.FILES.compareTo(sVNDepth) <= 0 && sVNEntry.isDirectory()) {
            sVNWCAccess.walkEntries(file, sVNWCClient16$PropFetchHandler, false, sVNDepth);
        } else if (SVNWCAccess.matchesChangeList(collection, sVNEntry)) {
            if (string == null) {
                SVNVersionedProperties sVNVersionedProperties = bl2 ? sVNAdminArea.getBaseProperties(sVNEntry.getName()) : sVNAdminArea.getProperties(sVNEntry.getName());
                SVNProperties sVNProperties = sVNVersionedProperties.asMap();
                for (String string2 : sVNProperties.nameSet()) {
                    SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string2);
                    iSVNPropertyHandler.handleProperty(sVNAdminArea.getFile(sVNEntry.getName()), new SVNPropertyData(string2, sVNPropertyValue, this.getOptions()));
                }
            } else {
                sVNWCClient16$PropFetchHandler.handleEntry(file, sVNEntry);
            }
        }
    }

    private void setLocalProperties(File file, SVNEntry sVNEntry, SVNAdminArea sVNAdminArea, boolean bl2, ISVNPropertyValueProvider iSVNPropertyValueProvider, ISVNPropertyHandler iSVNPropertyHandler) {
        SVNVersionedProperties sVNVersionedProperties = sVNAdminArea.getProperties(sVNEntry.getName());
        SVNProperties sVNProperties = sVNVersionedProperties.asMap();
        SVNProperties sVNProperties2 = SVNProperties.unmodifiableProperties(sVNProperties);
        SVNProperties sVNProperties3 = iSVNPropertyValueProvider.providePropertyValues(file, sVNProperties2);
        SVNProperties sVNProperties4 = sVNProperties.compareTo(sVNProperties3);
        for (String string : sVNProperties4.nameSet()) {
            SVNErrorMessage sVNErrorMessage;
            SVNPropertyValue sVNPropertyValue = sVNProperties4.getSVNPropertyValue(string);
            if (sVNPropertyValue != null && !SVNPropertiesManager.isValidPropertyName(string)) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Bad property name ''{0}''", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            if (SVNRevisionProperty.isRevisionProperty(string)) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Revision property ''{0}'' not allowed in this context", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            } else if (SVNProperty.isWorkingCopyProperty(string)) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            } else if (SVNProperty.isEntryProperty(string)) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property ''{0}'' is an entry property", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            try {
                boolean bl3 = SVNPropertiesManager.setProperty(sVNAdminArea.getWCAccess(), file, string, sVNPropertyValue, bl2);
                if (!bl3 || iSVNPropertyHandler == null) continue;
                iSVNPropertyHandler.handleProperty(file, new SVNPropertyData(string, sVNPropertyValue, this.getOptions()));
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.ILLEGAL_TARGET) continue;
                throw sVNException;
            }
        }
    }

    private Map fetchLockTokens(SVNRepository sVNRepository, Map map) {
        SVNHashMap sVNHashMap = new SVNHashMap();
        for (String string : map.keySet()) {
            SVNLock sVNLock = sVNRepository.getLock(string);
            if (sVNLock == null || sVNLock.getID() == null) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_MISSING_LOCK_TOKEN, "''{0}'' is not locked", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                continue;
            }
            sVNHashMap.put(string, sVNLock.getID());
        }
        return sVNHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetLocalFileContents(File file, OutputStream outputStream, SVNRevision sVNRevision, boolean bl2, SVNProperties sVNProperties) {
        SVNWCAccess sVNWCAccess = this.createWCAccess();
        InputStream inputStream = null;
        boolean bl3 = false;
        SVNVersionedProperties sVNVersionedProperties = null;
        try {
            Object object;
            Object object2;
            SVNAdminArea sVNAdminArea = sVNWCAccess.open(file.getParentFile(), false, 0);
            SVNEntry sVNEntry = sVNWCAccess.getVersionedEntry(file, false);
            if (sVNEntry.getKind() != SVNNodeKind.FILE) {
                object2 = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' refers to a directory", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
            }
            object2 = file.getName();
            if (sVNRevision != SVNRevision.WORKING) {
                inputStream = sVNAdminArea.getBaseFileForReading((String)object2, false);
                sVNVersionedProperties = sVNAdminArea.getBaseProperties((String)object2);
            } else {
                inputStream = SVNFileUtil.openFileForReading(sVNAdminArea.getFile(file.getName()), SVNLogType.WC);
                bl3 = sVNAdminArea.hasPropModifications((String)object2) || sVNAdminArea.hasTextModifications((String)object2, true);
                sVNVersionedProperties = sVNAdminArea.getProperties((String)object2);
            }
            if (sVNProperties != null) {
                sVNProperties.putAll(sVNVersionedProperties.asMap());
            }
            String string = sVNVersionedProperties.getStringPropertyValue("svnkit:charset");
            String string2 = sVNVersionedProperties.getStringPropertyValue("svn:mime-type");
            String string3 = sVNVersionedProperties.getStringPropertyValue("svn:eol-style");
            String string4 = sVNVersionedProperties.getStringPropertyValue("svn:keywords");
            boolean bl4 = sVNVersionedProperties.getPropertyValue("svn:special") != null;
            byte[] byArray = null;
            Map map = null;
            String string5 = null;
            String string6 = SVNTranslator.getCharset(string, string2, file.getPath(), this.getOptions());
            byArray = SVNTranslator.getEOL(string3, this.getOptions());
            string5 = bl3 && !bl4 ? SVNDate.formatDate(new Date(SVNFileUtil.getFileLastModified(file))) : sVNEntry.getCommittedDate();
            if (string4 != null) {
                object = sVNEntry.getURL();
                String string7 = sVNEntry.getRepositoryRoot();
                String string8 = bl3 ? "(local)" : sVNEntry.getAuthor();
                String string9 = bl3 ? sVNEntry.getCommittedRevision() + "M" : sVNEntry.getCommittedRevision() + "";
                map = SVNTranslator.computeKeywords(string4, (String)(bl2 ? object : null), string7, string8, string5, string9, this.getOptions());
            }
            object = string6 != null || byArray != null || map != null ? SVNTranslator.getTranslatingOutputStream(outputStream, string6, byArray, false, map, bl2) : outputStream;
            try {
                SVNTranslator.copy(inputStream, new SVNCancellableOutputStream((OutputStream)object, this.getEventDispatcher()));
                outputStream.flush();
            }
            catch (IOExceptionWrapper iOExceptionWrapper) {
                throw iOExceptionWrapper.getOriginalException();
            }
            catch (IOException iOException) {
                if (iOException instanceof SVNCancellableOutputStream$IOCancelException) {
                    SVNErrorManager.cancel(iOException.getMessage(), SVNLogType.NETWORK);
                }
                SVNTranslator.translationError(file, iOException);
            }
        }
        catch (Throwable throwable) {
            SVNFileUtil.closeFile(inputStream);
            sVNWCAccess.close();
            throw throwable;
        }
        SVNFileUtil.closeFile(inputStream);
        sVNWCAccess.close();
    }

    static /* synthetic */ void access$300(SVNWCClient16 sVNWCClient16, File file, SVNEntry sVNEntry, ISVNInfoHandler iSVNInfoHandler) {
        sVNWCClient16.reportEntry(file, sVNEntry, iSVNInfoHandler);
    }

    static /* synthetic */ void access$400(SVNWCClient16 sVNWCClient16, File file, SVNEntry sVNEntry, SVNAdminArea sVNAdminArea, boolean bl2, ISVNPropertyValueProvider iSVNPropertyValueProvider, ISVNPropertyHandler iSVNPropertyHandler) {
        sVNWCClient16.setLocalProperties(file, sVNEntry, sVNAdminArea, bl2, iSVNPropertyValueProvider, iSVNPropertyHandler);
    }
}

