/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc16;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNAmbientDepthFilterEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExportEditor;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNReporter;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate;
import org.tmatesoft.svn.core.internal.wc16.SVNUpdateClient16$1;
import org.tmatesoft.svn.core.internal.wc16.SVNUpdateClient16$2;
import org.tmatesoft.svn.core.internal.wc16.SVNUpdateClient16$ExternalDiff;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNUpdateClient16
extends SVNBasicDelegate {
    private ISVNExternalsHandler myExternalsHandler;
    private boolean myIsUpdateLocksOnDemand;
    private boolean myIsExportExpandsKeywords;

    public SVNUpdateClient16(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
        this.setExportExpandsKeywords(true);
        this.setExternalsHandler(ISVNExternalsHandler.DEFAULT);
    }

    public SVNUpdateClient16(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
        this.setExportExpandsKeywords(true);
        this.setExternalsHandler(ISVNExternalsHandler.DEFAULT);
    }

    public void setExternalsHandler(ISVNExternalsHandler iSVNExternalsHandler) {
        if (iSVNExternalsHandler == null) {
            iSVNExternalsHandler = ISVNExternalsHandler.DEFAULT;
        }
        this.myExternalsHandler = iSVNExternalsHandler;
    }

    public ISVNExternalsHandler getExternalsHandler() {
        return this.myExternalsHandler;
    }

    public long doUpdate(File file, SVNRevision sVNRevision, boolean bl2) {
        return this.doUpdate(file, sVNRevision, SVNDepth.fromRecurse(bl2), false, false);
    }

    public long doUpdate(File file, SVNRevision sVNRevision, boolean bl2, boolean bl3) {
        return this.doUpdate(file, sVNRevision, SVNDepth.fromRecurse(bl2), bl3, false);
    }

    public long[] doUpdate(File[] fileArray, SVNRevision sVNRevision, SVNDepth sVNDepth, boolean bl2, boolean bl3) {
        if (fileArray == null) {
            return new long[0];
        }
        LinkedList<Long> linkedList = new LinkedList<Long>();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            this.checkCancelled();
            File file = fileArray[i2];
            try {
                this.setEventPathPrefix("");
                this.handlePathListItem(file);
                long l2 = this.doUpdate(file, sVNRevision, sVNDepth, bl2, bl3);
                linkedList.add(l2);
                continue;
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                    SVNEvent object = SVNEventFactory.createSVNEvent(file, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.SKIP, SVNEventAction.UPDATE_COMPLETED, null, null);
                    this.dispatchEvent(object);
                    linkedList.add(-1L);
                    continue;
                }
                throw sVNException;
            }
            finally {
                this.setEventPathPrefix(null);
            }
        }
        this.sleepForTimeStamp();
        long[] lArray = new long[linkedList.size()];
        int n2 = 0;
        for (Long l2 : linkedList) {
            lArray[n2++] = l2;
        }
        return lArray;
    }

    public long doUpdate(File file, SVNRevision sVNRevision, SVNDepth sVNDepth, boolean bl2, boolean bl3) {
        return this.update(file, sVNRevision, sVNDepth, bl2, bl3, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doSwitchImpl(SVNWCAccess sVNWCAccess, File file, SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, boolean bl3) {
        SVNErrorMessage sVNErrorMessage;
        if (!SVNWCUtil.isVersionedDirectory(file.isDirectory() ? file : file.getParentFile())) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' does not appear to be a working copy path", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.CLIENT);
        }
        if (sVNDepth == SVNDepth.UNKNOWN) {
            bl3 = false;
        }
        if (bl3 && sVNDepth == SVNDepth.EXCLUDE) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot both exclude and switch a path");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        boolean bl4 = sVNWCAccess == null;
        try {
            String[] stringArray;
            Object object;
            Object object2;
            SVNAdminArea sVNAdminArea;
            Object object3;
            SVNAdminAreaInfo sVNAdminAreaInfo = null;
            if (sVNWCAccess != null) {
                object3 = null;
                try {
                    object3 = this.createWCAccess();
                    sVNAdminAreaInfo = ((SVNWCAccess)object3).openAnchor(file, false, -1);
                }
                finally {
                    ((SVNWCAccess)object3).close();
                }
                sVNAdminArea = sVNAdminAreaInfo.getAnchor();
                object2 = sVNAdminAreaInfo.getTarget();
                sVNAdminArea = sVNWCAccess.retrieve(sVNAdminArea.getRoot());
                object2 = sVNWCAccess.retrieve(((SVNAdminArea)object2).getRoot());
                sVNAdminAreaInfo.setAnchor(sVNAdminArea);
                sVNAdminAreaInfo.setTarget((SVNAdminArea)object2);
                sVNAdminAreaInfo.setWCAccess(sVNWCAccess);
            } else {
                sVNWCAccess = this.createWCAccess();
                sVNAdminAreaInfo = sVNWCAccess.openAnchor(file, true, -1);
            }
            object3 = new SVNReporter(sVNAdminAreaInfo, file, true, false, sVNDepth, false, false, !bl3, this.getDebugLog());
            sVNAdminArea = sVNAdminAreaInfo.getAnchor();
            object2 = sVNAdminArea.getVersionedEntry(sVNAdminArea.getThisDirName(), false);
            SVNURL sVNURL2 = ((SVNEntry)object2).getSVNURL();
            if (sVNURL2 == null) {
                object = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Directory ''{0}'' has no URL", (Object)sVNAdminArea.getRoot());
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            object = new long[1];
            SVNRepository sVNRepository = this.createRepository(sVNURL, null, sVNAdminArea, sVNRevision, sVNRevision2, (long[])object);
            long l2 = object[0];
            sVNURL = sVNRepository.getLocation();
            SVNURL sVNURL3 = sVNRepository.getRepositoryRoot(true);
            if (!SVNPathUtil.isAncestor(sVNURL3.toString(), sVNURL2.toString())) {
                stringArray = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SWITCH, "''{0}''\nis not the same repository as\n''{1}''", sVNURL2.toString(), sVNURL3.toString());
                SVNErrorManager.error((SVNErrorMessage)stringArray, SVNLogType.WC);
            }
            if (bl3 && sVNDepth.compareTo(SVNDepth.INFINITY) < 0 && (stringArray = sVNAdminArea.getEntry(sVNAdminAreaInfo.getTargetName(), true)) != null && stringArray.isDirectory()) {
                SVNWCManager.crop(sVNAdminAreaInfo, sVNDepth);
            }
            sVNRepository.setLocation(sVNURL2, false);
            stringArray = this.getOptions().getPreservedConflictFileExtensions();
            ISVNUpdateEditor iSVNUpdateEditor = sVNWCAccess.createUpdateEditor(sVNAdminAreaInfo, sVNURL.toString(), bl2, bl3, sVNDepth, stringArray, null, false);
            ISVNEditor iSVNEditor = SVNAmbientDepthFilterEditor.wrap(iSVNUpdateEditor, sVNAdminAreaInfo, bl3);
            String string = "".equals(sVNAdminAreaInfo.getTargetName()) ? null : sVNAdminAreaInfo.getTargetName();
            sVNRepository.update(sVNURL, l2, string, sVNDepth, (ISVNReporterBaton)object3, SVNCancellableEditor.newInstance(iSVNEditor, this, this.getDebugLog()));
            long l3 = iSVNUpdateEditor.getTargetRevision();
            if (l3 >= 0L && !this.isIgnoreExternals() && sVNDepth.isRecursive()) {
                sVNURL = string == null ? sVNURL : sVNURL.removePathTail();
                this.handleExternals(sVNWCAccess, sVNAdminAreaInfo.getAnchor().getRoot(), sVNAdminAreaInfo.getOldExternals(), sVNAdminAreaInfo.getNewExternals(), sVNAdminAreaInfo.getDepths(), sVNURL, sVNURL3, sVNDepth, false, true);
            }
            this.dispatchEvent(SVNEventFactory.createSVNEvent(sVNAdminAreaInfo.getTarget().getRoot(), SVNNodeKind.NONE, null, l3, SVNEventAction.UPDATE_COMPLETED, null, null, null, ((SVNReporter)object3).getReportedFilesCount(), ((SVNReporter)object3).getTotalFilesCount()));
            long l4 = l3;
            return l4;
        }
        finally {
            if (bl4) {
                sVNWCAccess.close();
            }
            this.sleepForTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long update(File file, SVNRevision sVNRevision, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4) {
        SVNDepth sVNDepth2 = sVNDepth = sVNDepth == null ? SVNDepth.UNKNOWN : sVNDepth;
        if (sVNDepth == SVNDepth.UNKNOWN) {
            bl3 = false;
        }
        file = file.getAbsoluteFile();
        SVNWCAccess sVNWCAccess = this.createWCAccess();
        SVNAdminAreaInfo sVNAdminAreaInfo = null;
        int n2 = bl3 ? -1 : this.getLevelsToLockFromDepth(sVNDepth);
        try {
            Object object;
            SVNAdminArea sVNAdminArea;
            SVNEntry sVNEntry;
            SVNURL sVNURL;
            if (this.isUpdateLocksOnDemand()) {
                sVNWCAccess.openAnchor(file, true, 0);
                sVNWCAccess.close();
            }
            if ((sVNURL = (sVNEntry = (sVNAdminArea = (sVNAdminAreaInfo = sVNWCAccess.openAnchor(file, !this.isUpdateLocksOnDemand(), n2)).getAnchor()).getEntry(sVNAdminArea.getThisDirName(), false)).getSVNURL()) == null) {
                object = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Entry ''{0}'' has no URL", (Object)sVNAdminArea.getRoot());
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            if (bl3 && sVNDepth.compareTo(SVNDepth.INFINITY) < 0 && (object = sVNAdminArea.getEntry(sVNAdminAreaInfo.getTargetName(), true)) != null && ((SVNEntry)object).isDirectory()) {
                SVNWCManager.crop(sVNAdminAreaInfo, sVNDepth);
                if (sVNDepth == SVNDepth.EXCLUDE) {
                    long l2 = -1L;
                    return l2;
                }
            }
            object = this.getOptions().getPreservedConflictFileExtensions();
            SVNRepository sVNRepository = this.createRepository(sVNURL, sVNAdminArea.getRoot(), sVNWCAccess, true);
            boolean bl5 = sVNRepository.hasCapability(SVNCapability.DEPTH);
            SVNReporter sVNReporter = new SVNReporter(sVNAdminAreaInfo, file, true, !bl5, sVNDepth, this.isUpdateLocksOnDemand(), false, !bl3, this.getDebugLog());
            String string = "".equals(sVNAdminAreaInfo.getTargetName()) ? null : sVNAdminAreaInfo.getTargetName();
            long l3 = this.getRevisionNumber(sVNRevision, sVNRepository, file);
            SVNURL sVNURL2 = sVNRepository.getRepositoryRoot(true);
            sVNWCAccess.setRepositoryRoot(file, sVNURL2);
            SVNRepository[] sVNRepositoryArray = new SVNRepository[1];
            SVNUpdateClient16$1 sVNUpdateClient16$1 = new SVNUpdateClient16$1(this, sVNURL2, sVNRepositoryArray);
            ISVNUpdateEditor iSVNUpdateEditor = sVNWCAccess.createUpdateEditor(sVNAdminAreaInfo, null, bl2, bl3, sVNDepth, (String[])object, sVNUpdateClient16$1, this.isUpdateLocksOnDemand());
            ISVNEditor iSVNEditor = SVNAmbientDepthFilterEditor.wrap(iSVNUpdateEditor, sVNAdminAreaInfo, bl3);
            try {
                sVNRepository.update(l3, string, sVNDepth, bl4, (ISVNReporterBaton)sVNReporter, SVNCancellableEditor.newInstance(iSVNEditor, this, this.getDebugLog()));
            }
            finally {
                if (sVNRepositoryArray[0] != null) {
                    sVNRepositoryArray[0].closeSession();
                }
            }
            long l4 = iSVNUpdateEditor.getTargetRevision();
            if (l4 >= 0L) {
                if (!(sVNDepth != SVNDepth.INFINITY && sVNDepth != SVNDepth.UNKNOWN || this.isIgnoreExternals())) {
                    this.handleExternals(sVNWCAccess, sVNAdminAreaInfo.getAnchor().getRoot(), sVNAdminAreaInfo.getOldExternals(), sVNAdminAreaInfo.getNewExternals(), sVNAdminAreaInfo.getDepths(), sVNURL, sVNURL2, sVNDepth, false, true);
                }
                this.dispatchEvent(SVNEventFactory.createSVNEvent(sVNAdminAreaInfo.getTarget().getRoot(), SVNNodeKind.NONE, null, l4, SVNEventAction.UPDATE_COMPLETED, null, null, null, sVNReporter.getReportedFilesCount(), sVNReporter.getTotalFilesCount()));
            }
            long l5 = l4;
            return l5;
        }
        finally {
            sVNWCAccess.close();
            this.sleepForTimeStamp();
        }
    }

    public void setUpdateLocksOnDemand(boolean bl2) {
        this.myIsUpdateLocksOnDemand = bl2;
    }

    public boolean isUpdateLocksOnDemand() {
        return this.myIsUpdateLocksOnDemand;
    }

    public long doSwitch(File file, SVNURL sVNURL, SVNRevision sVNRevision, boolean bl2) {
        return this.doSwitch(file, sVNURL, SVNRevision.UNDEFINED, sVNRevision, SVNDepth.getInfinityOrFilesDepth(bl2), false, false);
    }

    public long doSwitch(File file, SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2) {
        return this.doSwitch(file, sVNURL, sVNRevision, sVNRevision2, SVNDepth.getInfinityOrFilesDepth(bl2), false, false);
    }

    public long doSwitch(File file, SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, boolean bl3) {
        return this.doSwitch(file, sVNURL, sVNRevision, sVNRevision2, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, false);
    }

    public long doSwitch(File file, SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, boolean bl3) {
        return this.doSwitchImpl(null, file, sVNURL, sVNRevision, sVNRevision2, sVNDepth, bl2, bl3);
    }

    public long doCheckout(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2) {
        return this.doCheckout(sVNURL, file, sVNRevision, sVNRevision2, SVNDepth.fromRecurse(bl2), false);
    }

    public long doCheckout(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, boolean bl3) {
        return this.doCheckout(sVNURL, file, sVNRevision, sVNRevision2, SVNDepth.fromRecurse(bl2), bl3);
    }

    public long doCheckout(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2) {
        Object object;
        Object object2;
        if (file == null) {
            object2 = SVNErrorMessage.create(SVNErrorCode.BAD_FILENAME, "Checkout destination path can not be NULL");
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
        }
        SVNRevision sVNRevision3 = sVNRevision = sVNRevision == null ? SVNRevision.UNDEFINED : sVNRevision;
        if (!sVNRevision2.isValid() && sVNRevision.isValid()) {
            sVNRevision2 = sVNRevision;
        }
        if (!sVNRevision2.isValid()) {
            sVNRevision2 = SVNRevision.HEAD;
        }
        object2 = this.createRepository(sVNURL, null, null, sVNRevision, sVNRevision2, null);
        sVNURL = ((SVNRepository)object2).getLocation();
        long l2 = this.getRevisionNumber(sVNRevision2, (SVNRepository)object2, null);
        SVNNodeKind sVNNodeKind = ((SVNRepository)object2).checkPath("", l2);
        if (sVNNodeKind == SVNNodeKind.FILE) {
            object = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "URL ''{0}'' refers to a file, not a directory", (Object)sVNURL);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        } else if (sVNNodeKind == SVNNodeKind.NONE) {
            object = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' doesn''t exist", (Object)sVNURL);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = ((SVNRepository)object2).getRepositoryUUID(true);
        SVNURL sVNURL2 = ((SVNRepository)object2).getRepositoryRoot(true);
        long l3 = -1L;
        sVNDepth = sVNDepth == null ? SVNDepth.UNKNOWN : sVNDepth;
        SVNWCAccess sVNWCAccess = this.createWCAccess();
        SVNFileType sVNFileType = SVNFileType.getType(file);
        if (sVNFileType == SVNFileType.NONE) {
            sVNDepth = sVNDepth == SVNDepth.UNKNOWN ? SVNDepth.INFINITY : sVNDepth;
            SVNAdminAreaFactory.createVersionedDirectory(file, sVNURL, sVNURL2, (String)object, l2, sVNDepth);
            l3 = this.update(file, sVNRevision2, sVNDepth, bl2, true, false);
        } else if (sVNFileType == SVNFileType.DIRECTORY) {
            int n2 = SVNAdminAreaFactory.checkWC(file, true);
            if (n2 != 0) {
                SVNAdminArea sVNAdminArea = sVNWCAccess.open(file, false, 0);
                SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
                sVNWCAccess.closeAdminArea(file);
                if (sVNEntry.getSVNURL() != null && sVNURL.equals(sVNEntry.getSVNURL())) {
                    l3 = this.update(file, sVNRevision2, sVNDepth, bl2, true, false);
                } else {
                    String string = "''{0}'' is already a working copy for a different URL";
                    if (sVNEntry.isIncomplete()) {
                        string = string + "; perform update to complete it";
                    }
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, string, (Object)file);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
            } else {
                sVNDepth = sVNDepth == SVNDepth.UNKNOWN ? SVNDepth.INFINITY : sVNDepth;
                SVNAdminAreaFactory.createVersionedDirectory(file, sVNURL, sVNURL2, (String)object, l2, sVNDepth);
                l3 = this.update(file, sVNRevision2, sVNDepth, bl2, true, false);
            }
        } else {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NODE_KIND_CHANGE, "''{0}'' already exists and is not a directory", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        return l3;
    }

    public long doExport(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, String string, boolean bl2, boolean bl3) {
        return this.doExport(sVNURL, file, sVNRevision, sVNRevision2, string, bl2, SVNDepth.fromRecurse(bl3));
    }

    public long doExport(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, String string, boolean bl2, SVNDepth sVNDepth) {
        long[] lArray = new long[]{-1L};
        SVNRepository sVNRepository = this.createRepository(sVNURL, null, null, sVNRevision, sVNRevision2, lArray);
        long l2 = this.doRemoteExport(sVNRepository, lArray[0], file, string, bl2, sVNDepth);
        this.dispatchEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, l2, SVNEventAction.UPDATE_COMPLETED, null, null, null));
        return l2;
    }

    public long doExport(File file, File file2, SVNRevision sVNRevision, SVNRevision sVNRevision2, String string, boolean bl2, boolean bl3) {
        return this.doExport(file, file2, sVNRevision, sVNRevision2, string, bl2, SVNDepth.fromRecurse(bl3));
    }

    public long doExport(File file, File file2, SVNRevision sVNRevision, SVNRevision sVNRevision2, String string, boolean bl2, SVNDepth sVNDepth) {
        long l2 = -1L;
        if (sVNRevision2 != SVNRevision.BASE && sVNRevision2 != SVNRevision.WORKING && sVNRevision2 != SVNRevision.COMMITTED && sVNRevision2 != SVNRevision.UNDEFINED) {
            SVNRepository sVNRepository = this.createRepository(null, file, null, sVNRevision, sVNRevision2, null);
            long l3 = this.getRevisionNumber(sVNRevision2, sVNRepository, file);
            l2 = this.doRemoteExport(sVNRepository, l3, file2, string, bl2, sVNDepth);
        } else {
            if (sVNRevision2 == SVNRevision.UNDEFINED) {
                sVNRevision2 = SVNRevision.WORKING;
            }
            this.copyVersionedDir(file, file2, sVNRevision2, string, bl2, sVNDepth);
        }
        this.dispatchEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, l2, SVNEventAction.UPDATE_COMPLETED, null, null, null));
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRelocate(File file, SVNURL sVNURL, SVNURL sVNURL2, boolean bl2) {
        try (SVNWCAccess sVNWCAccess = this.createWCAccess();){
            SVNAdminArea sVNAdminArea = sVNWCAccess.probeOpen(file, true, bl2 ? -1 : 0);
            String string = file.equals(sVNAdminArea.getRoot()) ? sVNAdminArea.getThisDirName() : file.getName();
            String string2 = sVNURL.toString();
            String string3 = sVNURL2.toString();
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            this.doRelocate(sVNAdminArea, string, string2, string3, bl2, new SVNHashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCanonicalizeURLs(File file, boolean bl2, boolean bl3) {
        try (SVNWCAccess sVNWCAccess = this.createWCAccess();){
            SVNAdminAreaInfo sVNAdminAreaInfo = sVNWCAccess.openAnchor(file, true, bl3 ? -1 : 0);
            SVNAdminArea sVNAdminArea = sVNAdminAreaInfo.getTarget();
            SVNEntry sVNEntry = sVNWCAccess.getEntry(file, false);
            String string = sVNAdminArea.getThisDirName();
            if (sVNEntry != null && sVNEntry.isFile()) {
                string = sVNEntry.getName();
            }
            this.doCanonicalizeURLs(sVNAdminAreaInfo, sVNAdminArea, string, bl2, bl3);
            if (bl3 && !this.isIgnoreExternals()) {
                for (String string2 : sVNAdminAreaInfo.getNewExternals().keySet()) {
                    String string3 = (String)sVNAdminAreaInfo.getNewExternals().get(string2);
                    SVNExternal[] sVNExternalArray = SVNExternal.parseExternals(string2, string3);
                    File file2 = new File(sVNAdminAreaInfo.getAnchor().getRoot(), string2);
                    for (int i2 = 0; i2 < sVNExternalArray.length; ++i2) {
                        File file3 = new File(file2, sVNExternalArray[i2].getPath());
                        try {
                            this.doCanonicalizeURLs(file3, bl2, true);
                            continue;
                        }
                        catch (SVNCancelException sVNCancelException) {
                            throw sVNCancelException;
                        }
                        catch (SVNException sVNException) {
                            this.getDebugLog().logFine(SVNLogType.WC, sVNException);
                        }
                    }
                }
            }
        }
    }

    public void setExportExpandsKeywords(boolean bl2) {
        this.myIsExportExpandsKeywords = bl2;
    }

    public boolean isExportExpandsKeywords() {
        return this.myIsExportExpandsKeywords;
    }

    private void copyVersionedDir(File file, File file2, SVNRevision sVNRevision, String string, boolean bl2, SVNDepth sVNDepth) {
        SVNWCAccess sVNWCAccess = this.createWCAccess();
        SVNAdminArea sVNAdminArea = sVNWCAccess.probeOpen(file, false, 0);
        SVNEntry sVNEntry = null;
        try {
            sVNEntry = sVNWCAccess.getVersionedEntry(file, false);
        }
        catch (SVNException sVNException) {
            sVNWCAccess.close();
            throw sVNException;
        }
        if (sVNRevision == SVNRevision.WORKING && sVNEntry.isScheduledForDeletion()) {
            return;
        }
        if (sVNRevision != SVNRevision.WORKING && sVNEntry.isScheduledForAddition()) {
            return;
        }
        if (sVNEntry.isDirectory()) {
            Object object;
            Object object2;
            Object object3;
            boolean bl3 = file2.mkdirs();
            if (!file2.exists() || file2.isFile()) {
                object3 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create directory ''{0}''", (Object)file2);
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
            }
            if (!bl3 && file2.isDirectory() && !bl2) {
                object3 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "''{0}'' already exists and will not be owerwritten unless forced", (Object)file2);
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
            }
            if (sVNEntry.isDirectory() && sVNEntry.isThisDir()) {
                object3 = sVNAdminArea.entries(false);
                while (object3.hasNext()) {
                    object2 = (SVNEntry)object3.next();
                    if (((SVNEntry)object2).isDirectory()) {
                        if (sVNAdminArea.getThisDirName().equals(((SVNEntry)object2).getName()) || sVNDepth != SVNDepth.INFINITY) continue;
                        object = new File(file2, ((SVNEntry)object2).getName());
                        File file3 = new File(file, ((SVNEntry)object2).getName());
                        this.copyVersionedDir(file3, (File)object, sVNRevision, string, bl2, sVNDepth);
                        continue;
                    }
                    if (!((SVNEntry)object2).isFile()) continue;
                    object = new File(file2, ((SVNEntry)object2).getName());
                    this.copyVersionedFile((File)object, sVNAdminArea, ((SVNEntry)object2).getName(), sVNRevision, string);
                }
            }
            if (!this.isIgnoreExternals() && sVNDepth == SVNDepth.INFINITY && sVNEntry.getDepth() == SVNDepth.INFINITY && (object2 = ((SVNVersionedProperties)(object3 = sVNAdminArea.getProperties(sVNAdminArea.getThisDirName()))).getStringPropertyValue("svn:externals")) != null) {
                object = SVNExternal.parseExternals(sVNAdminArea.getRoot().getAbsolutePath(), (String)object2);
                for (int i2 = 0; i2 < ((SVNExternal[])object).length; ++i2) {
                    SVNExternal sVNExternal = object[i2];
                    File file4 = new File(sVNAdminArea.getRoot(), sVNExternal.getPath());
                    File file5 = new File(file2, sVNExternal.getPath());
                    if (SVNPathUtil.getSegmentsCount(sVNExternal.getPath()) > 1 && !file5.getParentFile().exists() && !file5.getParentFile().mkdirs()) {
                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CLIENT_IS_DIRECTORY, "Could not create directory ''{0}''", (Object)file5.getParentFile()), SVNLogType.WC);
                    }
                    this.copyVersionedDir(file4, file5, sVNRevision, string, bl2, SVNDepth.INFINITY);
                }
            }
        } else if (sVNEntry.isFile()) {
            this.copyVersionedFile(file2, sVNAdminArea, sVNEntry.getName(), sVNRevision, string);
        }
        sVNWCAccess.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyVersionedFile(File file, SVNAdminArea sVNAdminArea, String string, SVNRevision sVNRevision, String string2) {
        Object object;
        Object object2;
        byte[] byArray;
        SVNEntry sVNEntry = sVNAdminArea.getEntry(string, false);
        if (sVNRevision == SVNRevision.WORKING && sVNEntry.isScheduledForDeletion()) {
            return;
        }
        if (sVNRevision != SVNRevision.WORKING && sVNEntry.isScheduledForAddition()) {
            return;
        }
        boolean bl2 = false;
        SVNVersionedProperties sVNVersionedProperties = null;
        if (sVNRevision != SVNRevision.WORKING) {
            sVNVersionedProperties = sVNAdminArea.getBaseProperties(string);
        } else {
            sVNVersionedProperties = sVNAdminArea.getProperties(string);
            bl2 = sVNAdminArea.hasTextModifications(string, false);
        }
        boolean bl3 = sVNVersionedProperties.getPropertyValue("svn:special") != null;
        boolean bl4 = sVNVersionedProperties.getPropertyValue("svn:executable") != null;
        String string3 = sVNVersionedProperties.getStringPropertyValue("svn:keywords");
        String string4 = sVNVersionedProperties.getStringPropertyValue("svnkit:charset");
        String string5 = sVNVersionedProperties.getStringPropertyValue("svn:mime-type");
        String string6 = SVNTranslator.getCharset(string4, string5, sVNAdminArea.getFile(string).getPath(), this.getOptions());
        byte[] byArray2 = byArray = string2 != null ? SVNTranslator.getEOL(string2, this.getOptions()) : null;
        if (byArray == null) {
            string2 = sVNVersionedProperties.getStringPropertyValue("svn:eol-style");
            byArray = SVNTranslator.getEOL(string2, this.getOptions());
        }
        long l2 = bl2 && !bl3 ? SVNFileUtil.getFileLastModified(sVNAdminArea.getFile(string)) : SVNDate.parseDateAsMilliseconds(sVNEntry.getCommittedDate());
        Map map = null;
        if (string3 != null) {
            object2 = Long.toString(sVNEntry.getCommittedRevision());
            if (bl2) {
                object = "(local)";
                object2 = (String)object2 + "M";
            } else {
                object = sVNEntry.getAuthor();
            }
            map = SVNTranslator.computeKeywords(string3, sVNEntry.getURL(), sVNEntry.getRepositoryRoot(), (String)object, sVNEntry.getCommittedDate(), (String)object2, this.getOptions());
        }
        if ((object = SVNFileType.getType((File)(object2 = sVNRevision == SVNRevision.WORKING ? sVNAdminArea.getFile(string) : sVNAdminArea.getBaseFile(string, false)))) == SVNFileType.SYMLINK && sVNRevision == SVNRevision.WORKING) {
            File file2 = sVNAdminArea.getBaseFile(string, true);
            try {
                SVNTranslator.translate((File)object2, file2, string6, byArray, map, bl3, false);
                SVNTranslator.translate(file2, file, string6, byArray, map, bl3, true);
            }
            finally {
                file2.delete();
            }
        } else {
            SVNTranslator.translate((File)object2, file, string6, byArray, map, bl3, true);
        }
        if (bl4) {
            SVNFileUtil.setExecutable(file, true);
        }
        if (!bl3 && l2 > 0L) {
            SVNFileUtil.setLastModified(file, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doRemoteExport(SVNRepository sVNRepository, long l2, File file, String string, boolean bl2, SVNDepth sVNDepth) {
        SVNNodeKind sVNNodeKind = sVNRepository.checkPath("", l2);
        if (sVNNodeKind == SVNNodeKind.DIR) {
            SVNExportEditor sVNExportEditor = new SVNExportEditor(this, sVNRepository.getLocation().toString(), file, bl2, string, this.isExportExpandsKeywords(), sVNRepository.getRepositoryRoot(true).toString(), this.getOptions());
            sVNRepository.update(l2, null, sVNDepth, false, (ISVNReporterBaton)new SVNUpdateClient16$2(this, l2), SVNCancellableEditor.newInstance(sVNExportEditor, this, this.getDebugLog()));
            SVNFileType sVNFileType = SVNFileType.getType(file);
            if (sVNFileType == SVNFileType.NONE) {
                sVNExportEditor.openRoot(l2);
            }
            if (!this.isIgnoreExternals() && sVNDepth == SVNDepth.INFINITY) {
                Map map = sVNExportEditor.getCollectedExternals();
                this.handleExternals(null, file, Collections.EMPTY_MAP, map, Collections.EMPTY_MAP, sVNRepository.getLocation(), sVNRepository.getRepositoryRoot(true), sVNDepth, true, true);
            }
        } else if (sVNNodeKind == SVNNodeKind.FILE) {
            Serializable serializable;
            String string2;
            String string3 = sVNRepository.getLocation().toString();
            String string4 = string2 = this.isExportExpandsKeywords() ? sVNRepository.getRepositoryRoot(true).toString() : null;
            if (file.isDirectory()) {
                file = new File(file, SVNEncodingUtil.uriDecode(SVNPathUtil.tail(string3)));
            }
            if (file.exists()) {
                if (!bl2) {
                    serializable = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Path ''{0}'' already exists", (Object)file);
                    SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
                }
            } else {
                file.getParentFile().mkdirs();
            }
            serializable = new SVNProperties();
            OutputStream outputStream = null;
            File file2 = SVNFileUtil.createUniqueFile(file.getParentFile(), ".export", ".tmp", false);
            try {
                outputStream = SVNFileUtil.openFileForWriting(file2);
                try {
                    sVNRepository.getFile("", l2, (SVNProperties)serializable, new SVNCancellableOutputStream(outputStream, this));
                }
                finally {
                    SVNFileUtil.closeFile(outputStream);
                }
                if (bl2 && file.exists()) {
                    SVNFileUtil.deleteAll(file, this);
                }
                if (!this.isExportExpandsKeywords()) {
                    ((SVNProperties)serializable).put("svn:mime-type", "application/octet-stream");
                }
                String string5 = ((SVNProperties)serializable).getStringValue("svn:mime-type");
                boolean bl3 = SVNProperty.isBinaryMimeType(string5);
                String string6 = SVNTranslator.getCharset(((SVNProperties)serializable).getStringValue("svnkit:charset"), string5, string3, this.getOptions());
                Map map = SVNTranslator.computeKeywords(((SVNProperties)serializable).getStringValue("svn:keywords"), string3, string2, ((SVNProperties)serializable).getStringValue("svn:entry:last-author"), ((SVNProperties)serializable).getStringValue("svn:entry:committed-date"), ((SVNProperties)serializable).getStringValue("svn:entry:committed-rev"), this.getOptions());
                byte[] byArray = null;
                if ("native".equals(((SVNProperties)serializable).getStringValue("svn:eol-style"))) {
                    byArray = SVNTranslator.getEOL(string != null ? string : ((SVNProperties)serializable).getStringValue("svn:eol-style"), this.getOptions());
                } else if (((SVNProperties)serializable).containsName("svn:eol-style")) {
                    byArray = SVNTranslator.getEOL(((SVNProperties)serializable).getStringValue("svn:eol-style"), this.getOptions());
                }
                if (bl3) {
                    string6 = null;
                    byArray = null;
                    map = null;
                }
                SVNTranslator.translate(file2, file, string6, byArray, map, ((SVNProperties)serializable).getStringValue("svn:special") != null, true);
            }
            finally {
                SVNFileUtil.deleteFile(file2);
            }
            if (((SVNProperties)serializable).getStringValue("svn:executable") != null) {
                SVNFileUtil.setExecutable(file, true);
            }
            this.dispatchEvent(SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, null, -1L, SVNEventAction.UPDATE_ADD, null, null, null));
        } else {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' doesn''t exist", (Object)sVNRepository.getLocation());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        return l2;
    }

    private void doCanonicalizeURLs(SVNAdminAreaInfo sVNAdminAreaInfo, SVNAdminArea sVNAdminArea, String string, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        Object object3;
        boolean bl4 = false;
        this.checkCancelled();
        if (!sVNAdminArea.getThisDirName().equals(string)) {
            SVNEntry sVNEntry = sVNAdminArea.getEntry(string, true);
            bl4 = SVNUpdateClient16.canonicalizeEntry(sVNEntry, bl2);
            sVNAdminArea.getWCProperties(string).setPropertyValue("svn:wc:ra_dav:version-url", null);
            if (bl4) {
                sVNAdminArea.saveEntries(false);
            }
            return;
        }
        if (!this.isIgnoreExternals() && (object3 = sVNAdminArea.getProperties(sVNAdminArea.getThisDirName()).getPropertyValue("svn:externals")) != null) {
            object2 = sVNAdminArea.getRelativePath(sVNAdminAreaInfo.getAnchor());
            object = object3 == null ? null : ((SVNPropertyValue)object3).getString();
            sVNAdminAreaInfo.addExternal((String)object2, (String)object, (String)object);
            if (object3 != null) {
                object3 = SVNPropertyValue.create(SVNUpdateClient16.canonicalizeExtenrals((String)object, bl2));
                sVNAdminArea.getProperties(sVNAdminArea.getThisDirName()).setPropertyValue("svn:externals", (SVNPropertyValue)object3);
            }
        }
        object3 = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), true);
        bl4 = SVNUpdateClient16.canonicalizeEntry((SVNEntry)object3, bl2);
        sVNAdminArea.getWCProperties(sVNAdminArea.getThisDirName()).setPropertyValue("svn:wc:ra_dav:version-url", null);
        object2 = sVNAdminArea.entries(true);
        while (object2.hasNext()) {
            Object object4;
            object = (SVNEntry)object2.next();
            if (sVNAdminArea.getThisDirName().equals(((SVNEntry)object).getName())) continue;
            this.checkCancelled();
            if (bl3 && ((SVNEntry)object).isDirectory() && (((SVNEntry)object).isScheduledForAddition() || !((SVNEntry)object).isDeleted()) && !((SVNEntry)object).isAbsent() && (object4 = sVNAdminArea.getWCAccess().retrieve(sVNAdminArea.getFile(((SVNEntry)object).getName()))) != null) {
                this.doCanonicalizeURLs(sVNAdminAreaInfo, (SVNAdminArea)object4, "", bl2, bl3);
            }
            bl4 |= SVNUpdateClient16.canonicalizeEntry((SVNEntry)object, bl2);
            object4 = sVNAdminArea.getWCProperties(((SVNEntry)object).getName());
            if (object4 == null) continue;
            ((SVNVersionedProperties)object4).setPropertyValue("svn:wc:ra_dav:version-url", null);
        }
        if (bl4) {
            sVNAdminArea.saveEntries(true);
        }
    }

    public static String canonicalizeExtenrals(String string, boolean bl2) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            SVNURL sVNURL;
            String string2 = stringTokenizer.nextToken();
            if (string2.trim().length() == 0 || string2.trim().startsWith("#") || string2.indexOf(13) >= 0 || string2.indexOf(10) >= 0) {
                stringBuffer.append(string2);
                continue;
            }
            String[] stringArray = string2.split("[ \t]");
            int n2 = stringArray.length - 1;
            SVNURL sVNURL2 = null;
            if (n2 >= 1) {
                try {
                    sVNURL2 = SVNURL.parseURIEncoded(stringArray[n2]);
                }
                catch (SVNException sVNException) {
                    sVNURL2 = null;
                }
            }
            if ((sVNURL = SVNUpdateClient16.canonicalizeURL(sVNURL2, bl2)) == null) {
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(stringArray[0]);
            stringBuffer.append(' ');
            if (n2 == 2) {
                stringBuffer.append(stringArray[1]);
                stringBuffer.append(' ');
            }
            stringBuffer.append(sVNURL.toString());
        }
        return stringBuffer.toString();
    }

    private static boolean canonicalizeEntry(SVNEntry sVNEntry, boolean bl2) {
        SVNURL sVNURL;
        SVNURL sVNURL2;
        boolean bl3 = false;
        SVNURL sVNURL3 = SVNUpdateClient16.canonicalizeURL(sVNEntry.getRepositoryRootURL(), bl2);
        if (sVNURL3 != null) {
            bl3 |= sVNEntry.setRepositoryRootURL(sVNURL3);
        }
        if ((sVNURL2 = SVNUpdateClient16.canonicalizeURL(sVNEntry.getSVNURL(), bl2)) != null) {
            bl3 |= sVNEntry.setURL(sVNURL2.toString());
        }
        if ((sVNURL = SVNUpdateClient16.canonicalizeURL(sVNEntry.getCopyFromSVNURL(), bl2)) != null) {
            bl3 |= sVNEntry.setCopyFromURL(sVNURL.toString());
        }
        return bl3;
    }

    public static SVNURL canonicalizeURL(SVNURL sVNURL, boolean bl2) {
        if (sVNURL == null || sVNURL.getPort() <= 0) {
            return null;
        }
        int n2 = SVNURL.getDefaultPortNumber(sVNURL.getProtocol());
        if (n2 <= 0) {
            return null;
        }
        if (bl2) {
            if (sVNURL.hasPort() && sVNURL.getPort() == n2) {
                return SVNURL.create(sVNURL.getProtocol(), sVNURL.getUserInfo(), sVNURL.getHost(), -1, sVNURL.getPath(), false);
            }
        } else if (!sVNURL.hasPort()) {
            return SVNURL.create(sVNURL.getProtocol(), sVNURL.getUserInfo(), sVNURL.getHost(), sVNURL.getPort(), sVNURL.getPath(), false);
        }
        return null;
    }

    private void handleExternals(SVNWCAccess sVNWCAccess, File file, Map map, Map map2, Map map3, SVNURL sVNURL, SVNURL sVNURL2, SVNDepth sVNDepth, boolean bl2, boolean bl3) {
        SVNHashSet sVNHashSet = new SVNHashSet();
        if (map != null) {
            sVNHashSet.addAll(map.keySet());
        }
        if (map2 != null) {
            sVNHashSet.addAll(map2.keySet());
        }
        for (String string : sVNHashSet) {
            int n2;
            Object object;
            SVNDepth sVNDepth2;
            SVNDepth sVNDepth3 = sVNDepth2 = map3 == Collections.EMPTY_MAP ? SVNDepth.INFINITY : (SVNDepth)map3.get(string);
            if (sVNDepth2 == null) {
                object = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Traversal of ''{0}'' found no ambient depth", (Object)string);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            if (!sVNDepth2.isRecursive() || !sVNDepth.isRecursive()) continue;
            object = (String)map.get(string);
            String string2 = (String)map2.get(string);
            SVNExternal[] sVNExternalArray = object != null ? SVNExternal.parseExternals(string, (String)object) : null;
            SVNExternal[] sVNExternalArray2 = string2 != null ? SVNExternal.parseExternals(string, string2) : null;
            LinkedHashMap<String, SVNExternal> linkedHashMap = new LinkedHashMap<String, SVNExternal>();
            LinkedHashMap<String, SVNExternal> linkedHashMap2 = new LinkedHashMap<String, SVNExternal>();
            for (n2 = 0; sVNExternalArray2 != null && n2 < sVNExternalArray2.length; ++n2) {
                linkedHashMap2.put(sVNExternalArray2[n2].getPath(), sVNExternalArray2[n2]);
            }
            for (n2 = 0; sVNExternalArray != null && n2 < sVNExternalArray.length; ++n2) {
                linkedHashMap.put(sVNExternalArray[n2].getPath(), sVNExternalArray[n2]);
            }
            SVNUpdateClient16$ExternalDiff sVNUpdateClient16$ExternalDiff = new SVNUpdateClient16$ExternalDiff();
            sVNUpdateClient16$ExternalDiff.isExport = bl2;
            sVNUpdateClient16$ExternalDiff.isUpdateUnchanged = bl3;
            sVNUpdateClient16$ExternalDiff.rootURL = sVNURL2;
            for (String string3 : linkedHashMap.keySet()) {
                sVNUpdateClient16$ExternalDiff.oldExternal = (SVNExternal)linkedHashMap.get(string3);
                sVNUpdateClient16$ExternalDiff.newExternal = (SVNExternal)linkedHashMap2.get(string3);
                sVNUpdateClient16$ExternalDiff.owner = new File(file, string);
                if (!bl2) {
                    sVNUpdateClient16$ExternalDiff.ownerURL = this.getOwnerURL(sVNUpdateClient16$ExternalDiff.owner);
                }
                if (sVNUpdateClient16$ExternalDiff.ownerURL == null) {
                    sVNUpdateClient16$ExternalDiff.ownerURL = sVNURL.appendPath(string, false);
                }
                this.handleExternalItemChange(sVNWCAccess, sVNUpdateClient16$ExternalDiff.oldExternal.getPath(), sVNUpdateClient16$ExternalDiff);
            }
            for (String string3 : linkedHashMap2.keySet()) {
                if (linkedHashMap.containsKey(string3)) continue;
                sVNUpdateClient16$ExternalDiff.oldExternal = null;
                sVNUpdateClient16$ExternalDiff.newExternal = (SVNExternal)linkedHashMap2.get(string3);
                sVNUpdateClient16$ExternalDiff.owner = new File(file, string);
                if (!bl2) {
                    sVNUpdateClient16$ExternalDiff.ownerURL = this.getOwnerURL(sVNUpdateClient16$ExternalDiff.owner);
                }
                if (sVNUpdateClient16$ExternalDiff.ownerURL == null) {
                    sVNUpdateClient16$ExternalDiff.ownerURL = sVNURL.appendPath(string, false);
                }
                this.handleExternalItemChange(sVNWCAccess, sVNUpdateClient16$ExternalDiff.newExternal.getPath(), sVNUpdateClient16$ExternalDiff);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNURL getOwnerURL(File file) {
        if (file != null && SVNFileType.getType(file) == SVNFileType.DIRECTORY) {
            SVNWCAccess sVNWCAccess = this.createWCAccess();
            try {
                sVNWCAccess.open(file, false, 0);
                SVNEntry sVNEntry = sVNWCAccess.getVersionedEntry(file, false);
                if (sVNEntry != null) {
                    SVNURL sVNURL = sVNEntry.getSVNURL();
                    return sVNURL;
                }
            }
            catch (SVNException sVNException) {
                sVNException.printStackTrace();
            }
            finally {
                if (sVNWCAccess != null) {
                    try {
                        sVNWCAccess.close();
                    }
                    catch (SVNException sVNException) {}
                }
            }
        }
        return null;
    }

    private void handleExternalItemChange(SVNWCAccess sVNWCAccess, String string, SVNUpdateClient16$ExternalDiff sVNUpdateClient16$ExternalDiff) {
        try {
            this.handleExternalChange(sVNWCAccess, string, sVNUpdateClient16$ExternalDiff);
        }
        catch (SVNException sVNException) {
            File file = new File(sVNUpdateClient16$ExternalDiff.owner, string);
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.FAILED_EXTERNAL, SVNEventAction.UPDATE_EXTERNAL, sVNException.getErrorMessage(), null);
            this.dispatchEvent(sVNEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleExternalChange(SVNWCAccess sVNWCAccess, String string, SVNUpdateClient16$ExternalDiff sVNUpdateClient16$ExternalDiff) {
        Object object;
        Object object2;
        File file = new File(sVNUpdateClient16$ExternalDiff.owner, string);
        SVNURL sVNURL = null;
        SVNURL sVNURL2 = null;
        String string2 = null;
        if (sVNUpdateClient16$ExternalDiff.oldExternal != null && !sVNUpdateClient16$ExternalDiff.isExport) {
            sVNURL = sVNUpdateClient16$ExternalDiff.oldExternal.resolveURL(sVNUpdateClient16$ExternalDiff.rootURL, sVNUpdateClient16$ExternalDiff.ownerURL);
            string2 = sVNUpdateClient16$ExternalDiff.oldExternal.getRawValue();
        }
        SVNRevision sVNRevision = SVNRevision.UNDEFINED;
        SVNRevision sVNRevision2 = SVNRevision.UNDEFINED;
        if (sVNUpdateClient16$ExternalDiff.newExternal != null) {
            sVNURL2 = sVNUpdateClient16$ExternalDiff.newExternal.resolveURL(sVNUpdateClient16$ExternalDiff.rootURL, sVNUpdateClient16$ExternalDiff.ownerURL);
            sVNRevision = sVNUpdateClient16$ExternalDiff.newExternal.getRevision();
            sVNRevision2 = sVNUpdateClient16$ExternalDiff.newExternal.getPegRevision();
            string2 = sVNUpdateClient16$ExternalDiff.newExternal.getRawValue();
        }
        if (sVNURL == null && sVNURL2 == null) {
            return;
        }
        SVNRevision[] sVNRevisionArray = this.getExternalsHandler().handleExternal(file, sVNURL2, sVNRevision, sVNRevision2, string2, SVNRevision.UNDEFINED);
        if (sVNRevisionArray == null) {
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.DIR, null, -1L, SVNEventAction.SKIP, SVNEventAction.UPDATE_EXTERNAL, null, null);
            this.dispatchEvent(sVNEvent);
            return;
        }
        sVNRevision = sVNRevisionArray.length > 0 && sVNRevisionArray[0] != null ? sVNRevisionArray[0] : sVNRevision;
        sVNRevision2 = sVNRevisionArray.length > 1 && sVNRevisionArray[1] != null ? sVNRevisionArray[1] : sVNRevision2;
        SVNRepository sVNRepository = null;
        SVNNodeKind sVNNodeKind = null;
        SVNURL sVNURL3 = null;
        if (sVNURL2 != null) {
            object2 = new long[]{-1L};
            sVNRepository = this.createRepository(sVNURL2, null, null, sVNRevision2, sVNRevision, (long[])object2);
            sVNURL3 = sVNRepository.getRepositoryRoot(true);
            sVNNodeKind = sVNRepository.checkPath("", (long)object2[0]);
            if (sVNNodeKind == SVNNodeKind.NONE) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' at revision {1} doesn''t exist", sVNRepository.getLocation(), String.valueOf((long)object2[0]));
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            if (sVNNodeKind != SVNNodeKind.DIR && sVNNodeKind != SVNNodeKind.FILE) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' at revision {1} is not a file or a directory", sVNRepository.getLocation(), String.valueOf((long)object2[0]));
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
        }
        try {
            this.setEventPathPrefix("path");
            if (sVNURL == null) {
                if (sVNNodeKind == SVNNodeKind.DIR) {
                    file.mkdirs();
                    this.dispatchEvent(SVNEventFactory.createSVNEvent(file, SVNNodeKind.DIR, null, -1L, SVNEventAction.UPDATE_EXTERNAL, null, null, null));
                    if (sVNUpdateClient16$ExternalDiff.isExport) {
                        this.doExport(sVNURL2, file, sVNRevision2, sVNRevision, null, true, SVNDepth.INFINITY);
                        return;
                    }
                    this.doCheckout(sVNURL2, file, sVNRevision2, sVNRevision, SVNDepth.INFINITY, false);
                    return;
                }
                if (sVNNodeKind != SVNNodeKind.FILE) return;
                this.dispatchEvent(SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, null, -1L, SVNEventAction.UPDATE_EXTERNAL, null, null, null));
                if (sVNUpdateClient16$ExternalDiff.isExport) {
                    boolean bl2 = this.isIgnoreExternals();
                    this.setIgnoreExternals(true);
                    this.doExport(sVNURL2, file, sVNRevision2, sVNRevision, null, false, SVNDepth.INFINITY);
                    this.setIgnoreExternals(bl2);
                    return;
                }
                this.switchFileExternal(sVNWCAccess, file, sVNURL2, sVNRevision2, sVNRevision, sVNURL3);
                return;
            }
            if (sVNURL2 == null) {
                object2 = this.createWCAccess();
                object = ((SVNWCAccess)object2).open(file, true, -1);
                SVNException sVNException = null;
                try {
                    ((SVNAdminArea)object).removeFromRevisionControl(((SVNAdminArea)object).getThisDirName(), true, false);
                }
                catch (SVNException sVNException2) {
                    sVNException = sVNException2;
                }
                if (sVNException == null || sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) {
                    try {
                        ((SVNWCAccess)object2).close();
                    }
                    catch (SVNException sVNException3) {
                        sVNException = sVNException == null ? sVNException3 : sVNException;
                    }
                }
                if (sVNException == null) return;
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) return;
                throw sVNException;
            }
            if (!sVNUpdateClient16$ExternalDiff.isUpdateUnchanged) {
                if (sVNUpdateClient16$ExternalDiff.compareExternals(sVNURL, sVNURL2)) return;
            }
            if (sVNNodeKind == SVNNodeKind.DIR) {
                Object object3;
                object2 = SVNFileType.getType(file);
                boolean bl3 = false;
                if (object2 == SVNFileType.DIRECTORY && (object3 = file.listFiles()) != null && ((File[])object3).length == 0) {
                    bl3 = true;
                }
                if (object2 == SVNFileType.DIRECTORY && !bl3) {
                    this.dispatchEvent(SVNEventFactory.createSVNEvent(file, SVNNodeKind.DIR, null, -1L, SVNEventAction.UPDATE_EXTERNAL, null, null, null));
                    object3 = this.createWCAccess();
                    SVNAdminArea sVNAdminArea = ((SVNWCAccess)object3).open(file, true, 0);
                    SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
                    ((SVNWCAccess)object3).close();
                    String string3 = sVNEntry.getURL();
                    if (sVNEntry != null && sVNEntry.getURL() != null) {
                        if (sVNURL2.toString().equals(string3)) {
                            this.doUpdate(file, sVNRevision, SVNDepth.UNKNOWN, true, false);
                            return;
                        }
                        if (sVNEntry.getRepositoryRoot() != null) {
                            if (!SVNPathUtil.isAncestor(sVNEntry.getRepositoryRoot(), sVNURL2.toString())) {
                                SVNRepository sVNRepository2 = this.createRepository(sVNURL2, null, null, true);
                                SVNURL sVNURL4 = sVNRepository2.getRepositoryRoot(true);
                                try {
                                    this.doRelocate(file, sVNEntry.getSVNURL(), sVNURL4, true);
                                }
                                catch (SVNException sVNException) {
                                    if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_INVALID_RELOCATION) {
                                        if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.CLIENT_INVALID_RELOCATION) throw sVNException;
                                    }
                                    this.deleteExternal(file);
                                    file.mkdirs();
                                    this.doCheckout(sVNURL2, file, sVNRevision2, sVNRevision, SVNDepth.INFINITY, false);
                                    this.setEventPathPrefix(null);
                                    return;
                                }
                            }
                            this.doSwitch(file, sVNURL2, sVNRevision2, sVNRevision, SVNDepth.INFINITY, false, true);
                            return;
                        }
                    }
                    this.deleteExternal(file);
                    file.mkdirs();
                    this.dispatchEvent(SVNEventFactory.createSVNEvent(file, SVNNodeKind.DIR, null, -1L, SVNEventAction.UPDATE_EXTERNAL, null, null, null));
                    this.doCheckout(sVNURL2, file, sVNRevision2, sVNRevision, SVNDepth.INFINITY, false);
                    return;
                }
                if (object2 != SVNFileType.DIRECTORY) {
                    file.mkdirs();
                }
                this.dispatchEvent(SVNEventFactory.createSVNEvent(file, SVNNodeKind.DIR, null, -1L, SVNEventAction.UPDATE_EXTERNAL, null, null, null));
                this.doCheckout(sVNURL2, file, sVNRevision2, sVNRevision, SVNDepth.INFINITY, true);
                return;
            }
            this.dispatchEvent(SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, null, -1L, SVNEventAction.UPDATE_EXTERNAL, null, null, null));
            this.switchFileExternal(sVNWCAccess, file, sVNURL2, sVNRevision2, sVNRevision, sVNURL3);
            return;
        }
        catch (SVNCancelException sVNCancelException) {
            throw sVNCancelException;
        }
        catch (SVNException sVNException) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, sVNException);
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.DIR, null, -1L, SVNEventAction.SKIP, SVNEventAction.UPDATE_EXTERNAL, sVNException.getErrorMessage(), null);
            this.dispatchEvent(sVNEvent);
            return;
        }
        finally {
            this.setEventPathPrefix(null);
        }
    }

    private void switchFileExternal(SVNWCAccess sVNWCAccess, File file, SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNURL sVNURL2) {
        Object object;
        String string = SVNWCManager.getActualTarget(file);
        File file2 = "".equals(string) ? file : file.getParentFile();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = this.isIgnoreExternals();
        SVNAdminArea sVNAdminArea = null;
        try {
            Object object2;
            try {
                sVNAdminArea = sVNWCAccess.retrieve(file2);
            }
            catch (SVNException sVNException) {
                object = sVNException.getErrorMessage();
                if (((SVNErrorMessage)object).getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                    SVNWCAccess sVNWCAccess2 = SVNWCAccess.newInstance(null);
                    sVNAdminArea = sVNWCAccess2.open(file2, true, 1);
                    bl2 = true;
                    object2 = this.getReposRoot(file2, null, SVNRevision.BASE, sVNAdminArea, sVNWCAccess2);
                    if (!sVNURL2.equals(object2)) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_REPOS_ROOT_URL_MISMATCH, "Cannot insert a file external from ''{0}'' into a working copy from a different repository rooted at ''{1}''", sVNURL, object2);
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                    }
                }
                throw sVNException;
            }
            if (sVNAdminArea.getFormatVersion() < 10) {
                this.dispatchEvent(SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, null, -1L, SVNEventAction.SKIP, SVNEventAction.UPDATE_EXTERNAL, null, null));
                return;
            }
            SVNEntry sVNEntry = sVNAdminArea.getEntry(string, false);
            if (sVNEntry != null) {
                if (sVNEntry.getExternalFilePath() == null) {
                    object = SVNErrorMessage.create(SVNErrorCode.CLIENT_FILE_EXTERNAL_OVERWRITE_VERSIONED, "The file external from ''{0}'' cannot overwrite the existing versioned item at ''{1}''", sVNURL, file);
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
                }
            } else {
                sVNAdminArea.getVersionedEntry(sVNAdminArea.getThisDirName(), false);
                boolean bl8 = sVNAdminArea.hasPropConflict(sVNAdminArea.getThisDirName());
                boolean bl9 = sVNAdminArea.hasTreeConflict(sVNAdminArea.getThisDirName());
                if (bl8 || bl9) {
                    object2 = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "The file external from ''{0}'' cannot be written to ''{1}'' while ''{2}'' remains in conflict", sVNURL, file, file2);
                    SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
                }
                if (!file.exists()) {
                    SVNFileUtil.createEmptyFile(file);
                    bl5 = true;
                }
                object2 = sVNAdminArea.getWCAccess().getEventHandler();
                try {
                    sVNAdminArea.getWCAccess().setEventHandler(null);
                    SVNWCManager.add(file, sVNAdminArea, null, -1L, SVNDepth.INFINITY);
                }
                catch (SVNException sVNException) {
                    bl6 = true;
                    throw sVNException;
                }
                finally {
                    if (object2 != null) {
                        sVNAdminArea.getWCAccess().setEventHandler((ISVNEventHandler)object2);
                    }
                }
                bl3 = true;
                try {
                    sVNAdminArea.setFileExternalLocation(string, sVNURL, sVNRevision, sVNRevision2, sVNURL2);
                }
                catch (SVNException sVNException) {
                    bl6 = true;
                    throw sVNException;
                }
            }
            this.setIgnoreExternals(true);
            try {
                this.doSwitchImpl(sVNAdminArea.getWCAccess(), file, sVNURL, sVNRevision, sVNRevision2, SVNDepth.EMPTY, false, false);
            }
            catch (SVNException sVNException) {
                bl6 = true;
                throw sVNException;
            }
            if (bl5) {
                bl3 = false;
                bl4 = true;
            }
        }
        catch (SVNException sVNException) {
            if (bl6) {
                if (bl3) {
                    object = new SVNWCClient16(this.getRepositoryPool(), this.getOptions());
                    try {
                        ((SVNWCClient16)object).doRevert(new File[]{file}, SVNDepth.EMPTY, null);
                    }
                    catch (SVNException sVNException2) {
                        // empty catch block
                    }
                }
                if (bl4) {
                    try {
                        sVNAdminArea.removeFromRevisionControl(string, true, false);
                    }
                    catch (SVNException sVNException3) {
                        // empty catch block
                    }
                }
                if (bl5) {
                    try {
                        SVNFileUtil.deleteFile(file);
                    }
                    catch (SVNException sVNException4) {
                        // empty catch block
                    }
                }
            }
            throw sVNException;
        }
        finally {
            this.setIgnoreExternals(bl7);
            if (bl2) {
                sVNAdminArea.getWCAccess().close();
            }
        }
    }

    private void deleteExternal(File file) {
        SVNWCAccess sVNWCAccess = this.createWCAccess();
        SVNAdminArea sVNAdminArea = sVNWCAccess.open(file, true, -1);
        SVNException sVNException = null;
        try {
            sVNAdminArea.removeFromRevisionControl(sVNAdminArea.getThisDirName(), true, false);
        }
        catch (SVNException sVNException2) {
            this.getDebugLog().logFine(SVNLogType.WC, sVNException2);
            sVNException = sVNException2;
        }
        if (sVNException == null || sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) {
            sVNWCAccess.close();
        }
        if (sVNException != null && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) {
            file.getParentFile().mkdirs();
            File file2 = SVNFileUtil.createUniqueFile(file.getParentFile(), file.getName(), ".OLD", false);
            SVNFileUtil.rename(file, file2);
        } else if (sVNException != null) {
            throw sVNException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map validateRelocateTargetURL(SVNURL sVNURL, String string, Map map, boolean bl2) {
        if (map == null) {
            return null;
        }
        for (SVNURL sVNURL2 : map.keySet()) {
            Object object;
            if (!sVNURL.toString().startsWith(sVNURL2.toString())) continue;
            if (bl2 && !sVNURL.equals(sVNURL2)) {
                object = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "''{0}'' is not the root of the repository", (Object)sVNURL);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            object = (String)map.get(sVNURL2);
            if (string != null && !string.equals(object)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "The repository at ''{0}'' has uuid ''{1}'', but the WC has ''{2}''", sVNURL2, object, string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            return map;
        }
        SVNRepository sVNRepository = this.createRepository(sVNURL, null, null, false);
        try {
            Object object;
            SVNURL sVNURL2;
            sVNURL2 = sVNRepository.getRepositoryRoot(true);
            if (bl2 && !sVNURL.equals(sVNURL2)) {
                object = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "''{0}'' is not the root of the repository", (Object)sVNURL);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            object = sVNRepository.getRepositoryUUID(true);
            if (string != null && !string.equals(object)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "The repository at ''{0}'' has uuid ''{1}'', but the WC has ''{2}''", sVNURL, object, string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            map.put(sVNURL, object);
        }
        finally {
            sVNRepository.closeSession();
        }
        return map;
    }

    private Map relocateEntry(SVNEntry sVNEntry, String string, String string2, Map map) {
        if (sVNEntry.getRepositoryRoot() != null) {
            String string3 = sVNEntry.getRepositoryRoot();
            if (string.length() > string3.length()) {
                String string4 = string.substring(string3.length());
                if (!string2.endsWith(string4)) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_RELOCATION, "Relocate can only change the repository part of an URL");
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
                string = string3;
                string2 = string2.substring(0, string2.length() - string4.length());
            }
            if (string3.startsWith(string)) {
                sVNEntry.setRepositoryRoot(string2 + string3.substring(string.length()));
                map = this.validateRelocateTargetURL(sVNEntry.getRepositoryRootURL(), sVNEntry.getUUID(), map, true);
            }
        }
        if (sVNEntry.getURL() != null && sVNEntry.getURL().startsWith(string)) {
            sVNEntry.setURL(string2 + sVNEntry.getURL().substring(string.length()));
            if (sVNEntry.getUUID() != null && map != null) {
                map = this.validateRelocateTargetURL(sVNEntry.getSVNURL(), sVNEntry.getUUID(), map, false);
            }
        }
        if (sVNEntry.getCopyFromURL() != null && sVNEntry.getCopyFromURL().startsWith(string)) {
            sVNEntry.setCopyFromURL(string2 + sVNEntry.getCopyFromURL().substring(string.length()));
            if (sVNEntry.getUUID() != null && map != null) {
                map = this.validateRelocateTargetURL(sVNEntry.getCopyFromSVNURL(), sVNEntry.getUUID(), map, false);
            }
        }
        return map;
    }

    private Map doRelocate(SVNAdminArea sVNAdminArea, String string, String string2, String string3, boolean bl2, Map map) {
        Object object;
        SVNEntry sVNEntry = sVNAdminArea.getEntry(string, true);
        if (sVNEntry == null) {
            object = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (sVNEntry.isFile()) {
            this.relocateEntry(sVNEntry, string2, string3, map);
            SVNPropertiesManager.deleteWCProperties(sVNAdminArea, string, false);
            sVNAdminArea.saveEntries(false);
            return map;
        }
        map = this.relocateEntry(sVNEntry, string2, string3, map);
        object = sVNAdminArea.getWCAccess();
        Iterator iterator = sVNAdminArea.entries(true);
        while (iterator.hasNext()) {
            SVNEntry sVNEntry2 = (SVNEntry)iterator.next();
            if (sVNAdminArea.getThisDirName().equals(sVNEntry2.getName())) continue;
            if (bl2 && sVNEntry2.isDirectory() && (sVNEntry2.isScheduledForAddition() || !sVNEntry2.isDeleted()) && !sVNEntry2.isAbsent() && sVNEntry2.getDepth() != SVNDepth.EXCLUDE) {
                File file = sVNAdminArea.getFile(sVNEntry2.getName());
                if (((SVNWCAccess)object).isMissing(file)) continue;
                SVNAdminArea sVNAdminArea2 = ((SVNWCAccess)object).retrieve(file);
                map = this.doRelocate(sVNAdminArea2, sVNAdminArea2.getThisDirName(), string2, string3, bl2, map);
            }
            map = this.relocateEntry(sVNEntry2, string2, string3, map);
            SVNPropertiesManager.deleteWCProperties(sVNAdminArea, sVNEntry2.getName(), false);
        }
        SVNPropertiesManager.deleteWCProperties(sVNAdminArea, "", false);
        sVNAdminArea.saveEntries(false);
        return map;
    }
}

