/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc16;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNRemoteStatusEditor;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor;
import org.tmatesoft.svn.core.internal.wc.SVNStatusReporter;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNReporter;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate;
import org.tmatesoft.svn.core.internal.wc16.SVNStatusClient16$1;
import org.tmatesoft.svn.core.internal.wc16.SVNStatusClient16$2;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNStatusClient16
extends SVNBasicDelegate {
    private ISVNStatusFileProvider myFilesProvider;

    public SVNStatusClient16(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
    }

    public SVNStatusClient16(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public long doStatus(File file, boolean bl2, boolean bl3, boolean bl4, boolean bl5, ISVNStatusHandler iSVNStatusHandler) {
        return this.doStatus(file, SVNRevision.HEAD, SVNDepth.fromRecurse(bl2), bl3, bl4, bl5, false, iSVNStatusHandler, null);
    }

    public long doStatus(File file, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, ISVNStatusHandler iSVNStatusHandler) {
        return this.doStatus(file, SVNRevision.HEAD, SVNDepth.fromRecurse(bl2), bl3, bl4, bl5, bl6, iSVNStatusHandler, null);
    }

    public long doStatus(File file, SVNRevision sVNRevision, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, ISVNStatusHandler iSVNStatusHandler) {
        return this.doStatus(file, sVNRevision, SVNDepth.fromRecurse(bl2), bl3, bl4, bl5, bl6, iSVNStatusHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doStatus(File file, SVNRevision sVNRevision, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, boolean bl5, ISVNStatusHandler iSVNStatusHandler, Collection collection) {
        SVNStatusEditor sVNStatusEditor;
        block26: {
            if (iSVNStatusHandler == null) {
                return -1L;
            }
            sVNDepth = sVNDepth == null ? SVNDepth.UNKNOWN : sVNDepth;
            SVNWCAccess sVNWCAccess = this.createWCAccess();
            sVNStatusEditor = null;
            boolean[] blArray = new boolean[]{false};
            SVNStatusClient16$1 sVNStatusClient16$1 = new SVNStatusClient16$1(this, blArray, collection, iSVNStatusHandler);
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                SVNAdminAreaInfo sVNAdminAreaInfo = null;
                try {
                    object4 = sVNWCAccess.open(file, false, SVNDepth.recurseFromDepth(sVNDepth) ? -1 : 1);
                    sVNAdminAreaInfo = new SVNAdminAreaInfo(sVNWCAccess, (SVNAdminArea)object4, (SVNAdminArea)object4, "");
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                        sVNAdminAreaInfo = sVNWCAccess.openAnchor(file, false, SVNDepth.recurseFromDepth(sVNDepth) ? -1 : 1);
                        if (sVNDepth == SVNDepth.EMPTY) {
                            sVNDepth = SVNDepth.IMMEDIATES;
                        }
                    }
                    throw sVNException;
                }
                object4 = null;
                if (bl2) {
                    Iterator iterator;
                    object3 = sVNAdminAreaInfo.getAnchor();
                    object4 = sVNWCAccess.getVersionedEntry(((SVNAdminArea)object3).getRoot(), false);
                    if (((SVNEntry)object4).getURL() == null) {
                        iterator = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Entry ''{0}'' has no URL", (Object)sVNAdminAreaInfo.getAnchor().getRoot());
                        SVNErrorManager.error((SVNErrorMessage)((Object)iterator), SVNLogType.WC);
                    }
                    iterator = ((SVNEntry)object4).getSVNURL();
                    Object object5 = this.createRepository((SVNURL)((Object)iterator), ((SVNAdminArea)object3).getRoot(), sVNWCAccess, true);
                    long l2 = sVNRevision == SVNRevision.HEAD ? -1L : this.getRevisionNumber(sVNRevision, (SVNRepository)object5, file);
                    SVNNodeKind sVNNodeKind = ((SVNRepository)object5).checkPath("", l2);
                    this.checkCancelled();
                    object2 = null;
                    if (sVNNodeKind == SVNNodeKind.NONE) {
                        if (!((SVNEntry)object4).isScheduledForAddition()) {
                            blArray[0] = true;
                        }
                        sVNStatusEditor = new SVNStatusEditor(this.getOptions(), sVNWCAccess, sVNAdminAreaInfo, bl4, bl3, sVNDepth, sVNStatusClient16$1);
                        this.checkCancelled();
                        sVNStatusEditor.closeEdit();
                    } else {
                        sVNStatusEditor = new SVNRemoteStatusEditor(this.getOptions(), sVNWCAccess, sVNAdminAreaInfo, bl4, bl3, sVNDepth, sVNStatusClient16$1);
                        object = this.createRepository((SVNURL)((Object)iterator), ((SVNAdminArea)object3).getRoot(), sVNWCAccess, false);
                        this.checkCancelled();
                        boolean bl6 = ((SVNRepository)object5).hasCapability(SVNCapability.DEPTH);
                        object2 = new SVNReporter(sVNAdminAreaInfo, file, false, !bl6, sVNDepth, false, true, true, this.getDebugLog());
                        SVNStatusReporter sVNStatusReporter = new SVNStatusReporter((SVNRepository)object, (ISVNReporterBaton)object2, sVNStatusEditor);
                        String string = "".equals(sVNAdminAreaInfo.getTargetName()) ? null : sVNAdminAreaInfo.getTargetName();
                        ((SVNRepository)object5).status(l2, string, sVNDepth, (ISVNReporterBaton)sVNStatusReporter, SVNCancellableEditor.newInstance((ISVNEditor)((Object)sVNStatusEditor), this.getEventDispatcher(), this.getDebugLog()));
                    }
                    if (this.getEventDispatcher() != null) {
                        long l3 = object2 != null ? ((SVNReporter)object2).getReportedFilesCount() : 0L;
                        long l4 = object2 != null ? ((SVNReporter)object2).getTotalFilesCount() : 0L;
                        SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(sVNAdminAreaInfo.getAnchor().getFile(sVNAdminAreaInfo.getTargetName()), SVNNodeKind.NONE, null, sVNStatusEditor.getTargetRevision(), SVNEventAction.STATUS_COMPLETED, null, null, null, l3, l4);
                        this.getEventDispatcher().handleEvent(sVNEvent, -1.0);
                    }
                } else {
                    sVNStatusEditor = new SVNStatusEditor(this.getOptions(), sVNWCAccess, sVNAdminAreaInfo, bl4, bl3, sVNDepth, iSVNStatusHandler);
                    if (this.myFilesProvider != null) {
                        sVNStatusEditor.setFileProvider(this.myFilesProvider);
                    }
                    sVNStatusEditor.closeEdit();
                }
                if (this.isIgnoreExternals() || sVNDepth != SVNDepth.INFINITY && sVNDepth != SVNDepth.UNKNOWN) break block26;
                object3 = sVNAdminAreaInfo.getNewExternals();
                for (Object object5 : object3.keySet()) {
                    String string = (String)object3.get(object5);
                    SVNExternal[] sVNExternalArray = SVNExternal.parseExternals(object5, string);
                    for (int i2 = 0; i2 < sVNExternalArray.length; ++i2) {
                        object2 = sVNExternalArray[i2];
                        object = SVNPathUtil.append((String)object5, ((SVNExternal)object2).getPath());
                        File file2 = sVNAdminAreaInfo.getAnchor().getFile((String)object);
                        if (SVNFileType.getType(file2) != SVNFileType.DIRECTORY) continue;
                        try {
                            int n2 = SVNAdminAreaFactory.checkWC(file2, true);
                            if (n2 == 0) {
                            }
                        }
                        catch (SVNException sVNException) {}
                        continue;
                        this.handleEvent(SVNEventFactory.createSVNEvent(file2, SVNNodeKind.DIR, null, -1L, SVNEventAction.STATUS_EXTERNAL, null, null, null), -1.0);
                        this.setEventPathPrefix((String)object);
                        try {
                            this.doStatus(file2, SVNRevision.HEAD, sVNDepth, bl2, bl3, bl4, false, iSVNStatusHandler, null);
                            continue;
                        }
                        catch (SVNException sVNException) {
                            if (!(sVNException instanceof SVNCancelException)) continue;
                            throw sVNException;
                        }
                        finally {
                            this.setEventPathPrefix(null);
                        }
                    }
                }
            }
            finally {
                sVNWCAccess.close();
            }
        }
        return sVNStatusEditor.getTargetRevision();
    }

    public SVNStatus doStatus(File file, boolean bl2) {
        return this.doStatus(file, bl2, false);
    }

    public SVNStatus doStatus(File file, boolean bl2, boolean bl3) {
        SVNStatus[] sVNStatusArray = new SVNStatus[]{null};
        File file2 = file.getAbsoluteFile();
        SVNStatusClient16$2 sVNStatusClient16$2 = new SVNStatusClient16$2(this, file2, sVNStatusArray);
        this.doStatus(file2, SVNRevision.HEAD, SVNDepth.EMPTY, bl2, true, true, bl3, sVNStatusClient16$2, null);
        return sVNStatusArray[0];
    }

    public void setFilesProvider(ISVNStatusFileProvider iSVNStatusFileProvider) {
        this.myFilesProvider = iSVNStatusFileProvider;
    }
}

