/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc16;

import java.io.File;
import java.util.Iterator;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCopyDriver;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc16.SVNCopyClient16;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMoveClient16
extends SVNCopyDriver {
    private SVNWCClient16 myWCClient;
    private SVNCopyClient16 myCopyClient;

    public SVNMoveClient16(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
        this.myWCClient = new SVNWCClient16(iSVNAuthenticationManager, iSVNOptions);
        this.myCopyClient = new SVNCopyClient16(iSVNAuthenticationManager, iSVNOptions);
    }

    public SVNMoveClient16(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
        this.myWCClient = new SVNWCClient16(iSVNRepositoryPool, iSVNOptions);
        this.myCopyClient = new SVNCopyClient16(iSVNRepositoryPool, iSVNOptions);
    }

    @Override
    public void setEventHandler(ISVNEventHandler iSVNEventHandler) {
        super.setEventHandler(iSVNEventHandler);
        this.myWCClient.setEventHandler(iSVNEventHandler);
        this.myCopyClient.setEventHandler(iSVNEventHandler);
    }

    @Override
    public void setDebugLog(ISVNDebugLog iSVNDebugLog) {
        super.setDebugLog(iSVNDebugLog);
        this.myWCClient.setDebugLog(iSVNDebugLog);
        this.myCopyClient.setDebugLog(iSVNDebugLog);
    }

    @Override
    public void setOptions(ISVNOptions iSVNOptions) {
        super.setOptions(iSVNOptions);
        if (this.myWCClient != null) {
            this.myWCClient.setOptions(iSVNOptions);
        }
        if (this.myCopyClient != null) {
            this.myCopyClient.setOptions(iSVNOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMove(File file, File file2) {
        SVNErrorMessage sVNErrorMessage;
        if (file2.exists()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "File ''{0}'' already exists", (Object)file2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        } else if (!file.exists()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Path ''{0}'' does not exist", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        boolean bl2 = SVNMoveClient16.isVersionedFile(file);
        boolean bl3 = SVNMoveClient16.isVersionedFile(file2.getParentFile());
        if (!bl2 && !bl3) {
            SVNFileUtil.rename(file, file2);
        } else if (!bl3) {
            SVNFileUtil.copy(file, file2, false, false);
            this.myWCClient.doDelete(file, true, false);
        } else if (!bl2) {
            SVNFileUtil.rename(file, file2);
        } else {
            SVNWCAccess sVNWCAccess = this.createWCAccess();
            File file3 = file.getParentFile();
            File file4 = file2.getParentFile();
            SVNAdminArea sVNAdminArea = null;
            SVNAdminArea sVNAdminArea2 = null;
            try {
                Object object;
                Object object2;
                boolean bl4;
                if (file3.equals(file4)) {
                    sVNWCAccess.closeAdminArea(file3);
                    sVNAdminArea = sVNAdminArea2 = sVNWCAccess.open(file3, true, 0);
                } else {
                    sVNAdminArea = sVNWCAccess.open(file3, false, 0);
                    sVNAdminArea2 = sVNWCAccess.open(file4, true, 0);
                }
                SVNEntry sVNEntry = sVNAdminArea.getVersionedEntry(file.getName(), false);
                SVNEntry sVNEntry2 = sVNAdminArea2.getEntry(file2.getName(), false);
                File file5 = SVNWCUtil.getWorkingCopyRoot(file, true);
                File file6 = SVNWCUtil.getWorkingCopyRoot(file2, true);
                boolean bl5 = bl4 = file5 != null && file5.equals(file6);
                if (bl4 && sVNEntry2 != null && (sVNEntry2.isScheduledForDeletion() || sVNEntry2.getKind() != sVNEntry.getKind())) {
                    sVNWCAccess.close();
                    if (sVNEntry.getKind() == sVNEntry2.getKind() && sVNEntry.getSchedule() == null && sVNEntry.isFile()) {
                        SVNCopySource sVNCopySource = new SVNCopySource(SVNRevision.UNDEFINED, SVNRevision.WORKING, file);
                        this.myCopyClient.doCopy(new SVNCopySource[]{sVNCopySource}, file2, true, false, true);
                        return;
                    }
                    SVNFileUtil.copy(file, file2, false, false);
                    try {
                        this.myWCClient.doAdd(file2, false, false, false, SVNDepth.INFINITY, false, false);
                    }
                    catch (SVNException sVNException) {
                        // empty catch block
                    }
                    this.myWCClient.doDelete(file, true, false);
                    return;
                }
                if (!bl4) {
                    object2 = sVNEntry2 != null && sVNEntry2.isThisDir() ? sVNEntry2 : sVNAdminArea2.getVersionedEntry(sVNAdminArea2.getThisDirName(), false);
                    Object object3 = object = sVNEntry != null && sVNEntry.isThisDir() ? sVNEntry : sVNAdminArea.getVersionedEntry(sVNAdminArea.getThisDirName(), false);
                    if (((SVNEntry)object).getRepositoryRoot() != null && ((SVNEntry)object2).getRepositoryRoot() != null && ((SVNEntry)object).getRepositoryRoot().equals(((SVNEntry)object2).getRepositoryRoot())) {
                        sVNWCAccess.close();
                        SVNCopySource sVNCopySource = new SVNCopySource(SVNRevision.UNDEFINED, SVNRevision.WORKING, file);
                        this.myCopyClient.doCopy(new SVNCopySource[]{sVNCopySource}, file2, true, false, true);
                        return;
                    }
                }
                if (sVNEntry2 != null) {
                    object2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "There is already a versioned item ''{0}''", (Object)file2);
                    SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
                }
                SVNFileUtil.copy(file, file2, false, bl4);
                if (!bl4) {
                    sVNWCAccess.close();
                    try {
                        this.myWCClient.doAdd(file2, false, false, false, SVNDepth.INFINITY, false, false);
                    }
                    catch (SVNException sVNException) {}
                } else if (sVNEntry.isFile()) {
                    if (sVNEntry2 == null) {
                        sVNEntry2 = sVNAdminArea2.addEntry(file2.getName());
                    }
                    object2 = sVNEntry.getURL();
                    object = sVNEntry.getCopyFromURL();
                    long l2 = sVNEntry.getRevision();
                    long l3 = sVNEntry.getCopyFromRevision();
                    SVNVersionedProperties sVNVersionedProperties = sVNAdminArea.getProperties(file.getName());
                    SVNVersionedProperties sVNVersionedProperties2 = sVNAdminArea2.getProperties(file2.getName());
                    sVNVersionedProperties.copyTo(sVNVersionedProperties2);
                    File file7 = sVNAdminArea.getBaseFile(file.getName(), false);
                    File file8 = sVNAdminArea2.getBaseFile(file2.getName(), false);
                    if (file7.isFile()) {
                        SVNFileUtil.copy(file7, file8, false, false);
                    }
                    if (sVNEntry.isScheduledForAddition() && sVNEntry.isCopied()) {
                        sVNEntry2.scheduleForAddition();
                        sVNEntry2.setCopyFromRevision(l3);
                        sVNEntry2.setCopyFromURL((String)object);
                        sVNEntry2.setKind(SVNNodeKind.FILE);
                        sVNEntry2.setRevision(l2);
                        sVNEntry2.setCopied(true);
                    } else if (!sVNEntry.isCopied() && !sVNEntry.isScheduledForAddition()) {
                        sVNEntry2.setCopied(true);
                        sVNEntry2.scheduleForAddition();
                        sVNEntry2.setKind(SVNNodeKind.FILE);
                        sVNEntry2.setCopyFromRevision(l2);
                        sVNEntry2.setCopyFromURL((String)object2);
                    } else {
                        sVNEntry2.scheduleForAddition();
                        sVNEntry2.setKind(SVNNodeKind.FILE);
                        if (!sVNEntry2.isScheduledForReplacement()) {
                            sVNEntry2.setRevision(0L);
                        }
                    }
                    SVNLog sVNLog = sVNAdminArea2.getLog();
                    sVNAdminArea2.saveEntries(false);
                    sVNAdminArea2.saveVersionedProperties(sVNLog, true);
                    sVNLog.save();
                    sVNAdminArea2.runLogs();
                } else if (sVNEntry.isDirectory()) {
                    object2 = sVNWCAccess.open(file, false, 0);
                    sVNEntry = ((SVNAdminArea)object2).getEntry(((SVNAdminArea)object2).getThisDirName(), false);
                    if (sVNEntry2 == null) {
                        sVNEntry2 = sVNAdminArea2.addEntry(file2.getName());
                    }
                    object = sVNWCAccess.open(file2, true, -1);
                    SVNVersionedProperties sVNVersionedProperties = ((SVNAdminArea)object2).getProperties(((SVNAdminArea)object2).getThisDirName());
                    SVNVersionedProperties sVNVersionedProperties3 = ((SVNAdminArea)object).getProperties(((SVNAdminArea)object).getThisDirName());
                    SVNEntry sVNEntry3 = sVNAdminArea2.getEntry(sVNAdminArea2.getThisDirName(), false);
                    String string = sVNEntry.getURL();
                    String string2 = sVNEntry.getCopyFromURL();
                    String string3 = sVNEntry3.getURL();
                    String string4 = sVNEntry3.getRepositoryRoot();
                    long l4 = sVNEntry.getRevision();
                    long l5 = sVNEntry.getCopyFromRevision();
                    string3 = SVNPathUtil.append(string3, SVNEncodingUtil.uriEncode(file2.getName()));
                    if (sVNEntry.isScheduledForAddition() && sVNEntry.isCopied()) {
                        sVNVersionedProperties.copyTo(sVNVersionedProperties3);
                        sVNEntry2.scheduleForAddition();
                        sVNEntry2.setKind(SVNNodeKind.DIR);
                        sVNEntry2.setCopied(true);
                        sVNEntry2.setCopyFromRevision(l5);
                        sVNEntry2.setCopyFromURL(string2);
                        SVNEntry sVNEntry4 = ((SVNAdminArea)object).getEntry(((SVNAdminArea)object).getThisDirName(), false);
                        sVNEntry4.scheduleForAddition();
                        sVNEntry4.setKind(SVNNodeKind.DIR);
                        sVNEntry4.setCopyFromRevision(l5);
                        sVNEntry4.setCopyFromURL(string2);
                        sVNEntry4.setRevision(l4);
                        sVNEntry4.setCopied(true);
                        SVNLog sVNLog = ((SVNAdminArea)object).getLog();
                        ((SVNAdminArea)object).saveVersionedProperties(sVNLog, true);
                        sVNAdminArea2.saveEntries(false);
                        sVNLog.save();
                        ((SVNAdminArea)object).runLogs();
                        ((SVNAdminArea)object).updateURL(string3, true);
                        sVNAdminArea2.saveEntries(true);
                    } else if (!sVNEntry.isCopied() && !sVNEntry.isScheduledForAddition()) {
                        sVNVersionedProperties.copyTo(sVNVersionedProperties3);
                        sVNEntry2.scheduleForAddition();
                        sVNEntry2.setKind(SVNNodeKind.DIR);
                        sVNEntry2.setCopied(true);
                        sVNEntry2.setCopyFromRevision(l4);
                        sVNEntry2.setCopyFromURL(string);
                        SVNEntry sVNEntry5 = ((SVNAdminArea)object).getEntry(((SVNAdminArea)object).getThisDirName(), false);
                        sVNEntry5.scheduleForAddition();
                        sVNEntry5.setKind(SVNNodeKind.DIR);
                        sVNEntry5.setCopied(true);
                        sVNEntry5.scheduleForAddition();
                        sVNEntry5.setKind(SVNNodeKind.DIR);
                        sVNEntry5.setCopyFromRevision(l4);
                        sVNEntry5.setCopyFromURL(string);
                        sVNEntry5.setURL(string3);
                        sVNEntry5.setRepositoryRoot(string4);
                        SVNLog sVNLog = ((SVNAdminArea)object).getLog();
                        ((SVNAdminArea)object).saveVersionedProperties(sVNLog, true);
                        ((SVNAdminArea)object).saveEntries(false);
                        sVNLog.save();
                        ((SVNAdminArea)object).runLogs();
                        this.updateCopiedDirectory((SVNAdminArea)object, ((SVNAdminArea)object).getThisDirName(), string3, string4, null, -1L);
                        ((SVNAdminArea)object).saveEntries(true);
                        sVNAdminArea2.saveEntries(true);
                    } else {
                        sVNAdminArea2.deleteEntry(file2.getName());
                        sVNAdminArea2.saveEntries(true);
                        SVNFileUtil.deleteAll(file2, this);
                        SVNFileUtil.copy(file, file2, false, false);
                        sVNWCAccess.close();
                        this.myWCClient.doAdd(file2, false, false, false, SVNDepth.INFINITY, false, false);
                    }
                }
                try {
                    sVNWCAccess.close();
                    this.myWCClient.doDelete(file, true, false);
                }
                catch (SVNException sVNException) {
                    // empty catch block
                }
            }
            finally {
                sVNWCAccess.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoMove(File file, File file2) {
        if (!file.exists()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Path ''{0}'' does not exist", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        boolean bl2 = SVNMoveClient16.isVersionedFile(file);
        boolean bl3 = SVNMoveClient16.isVersionedFile(file2.getParentFile());
        if (!bl2 && !bl3) {
            SVNFileUtil.rename(file, file2);
        } else if (!bl3) {
            SVNFileUtil.copy(file, file2, false, false);
            this.myWCClient.doDelete(file, true, false);
        } else if (!bl2) {
            SVNFileUtil.rename(file, file2);
            boolean bl4 = false;
            try (SVNWCAccess sVNWCAccess = this.createWCAccess();){
                sVNWCAccess.probeOpen(file2, false, 0);
                SVNEntry sVNEntry = sVNWCAccess.getEntry(file2, false);
                bl4 = sVNEntry != null && sVNEntry.isScheduledForDeletion();
            }
            if (bl4) {
                this.myWCClient.doRevert(new File[]{file2}, SVNDepth.INFINITY, null);
            }
        } else {
            SVNWCAccess sVNWCAccess = this.createWCAccess();
            File file3 = file.getParentFile();
            File file4 = file2.getParentFile();
            SVNAdminArea sVNAdminArea = null;
            SVNAdminArea sVNAdminArea2 = null;
            try {
                if (file3.equals(file4)) {
                    sVNWCAccess.closeAdminArea(file3);
                    sVNAdminArea = sVNAdminArea2 = sVNWCAccess.open(file3, true, 0);
                } else {
                    sVNAdminArea = sVNWCAccess.open(file3, false, 0);
                    sVNAdminArea2 = sVNWCAccess.open(file4, true, 0);
                }
                SVNEntry sVNEntry = sVNAdminArea.getEntry(file.getName(), true);
                SVNEntry sVNEntry2 = sVNAdminArea2.getEntry(file2.getName(), true);
                if (sVNEntry2 != null && sVNEntry2.isScheduledForDeletion()) {
                    sVNWCAccess.close();
                    this.myWCClient.doRevert(new File[]{file2}, SVNDepth.INFINITY, null);
                    this.myWCClient.doDelete(file, true, false);
                    return;
                }
                SVNEntry sVNEntry3 = sVNWCAccess.getEntry(file4, false);
                File file5 = SVNWCUtil.getWorkingCopyRoot(file, true);
                File file6 = SVNWCUtil.getWorkingCopyRoot(file2, true);
                boolean bl5 = file5 != null && file5.equals(file6);
                SVNFileUtil.copy(file, file2, false, bl5);
                if (sVNEntry2 != null && sVNEntry2.getKind() != sVNEntry.getKind()) {
                    sVNWCAccess.close();
                    this.myWCClient.doDelete(file, true, false);
                    return;
                }
                if (!bl5) {
                    sVNWCAccess.close();
                    try {
                        this.myWCClient.doAdd(file2, false, false, false, SVNDepth.INFINITY, false, false);
                    }
                    catch (SVNException sVNException) {}
                } else if (sVNEntry.isFile()) {
                    if (sVNEntry2 == null) {
                        sVNEntry2 = sVNAdminArea2.addEntry(file2.getName());
                    }
                    String string = sVNEntry.getURL();
                    String string2 = sVNEntry.getCopyFromURL();
                    long l2 = sVNEntry.getRevision();
                    long l3 = sVNEntry.getCopyFromRevision();
                    if (sVNEntry.isScheduledForAddition() && sVNEntry.isCopied()) {
                        sVNEntry2.scheduleForAddition();
                        sVNEntry2.setCopyFromRevision(l3);
                        sVNEntry2.setCopyFromURL(string2);
                        sVNEntry2.setKind(SVNNodeKind.FILE);
                        sVNEntry2.setRevision(l2);
                        sVNEntry2.setCopied(true);
                    } else if (!sVNEntry.isCopied() && !sVNEntry.isScheduledForAddition()) {
                        sVNEntry2.setCopied(true);
                        sVNEntry2.scheduleForAddition();
                        sVNEntry2.setKind(SVNNodeKind.FILE);
                        sVNEntry2.setCopyFromRevision(l2);
                        sVNEntry2.setCopyFromURL(string);
                    } else {
                        sVNEntry2.scheduleForAddition();
                        sVNEntry2.setKind(SVNNodeKind.FILE);
                        if (!sVNEntry2.isScheduledForReplacement()) {
                            sVNEntry2.setRevision(0L);
                        }
                    }
                    sVNAdminArea2.saveEntries(false);
                } else if (sVNEntry.isDirectory()) {
                    SVNAdminArea sVNAdminArea3 = sVNWCAccess.open(file, false, 0);
                    sVNEntry = sVNAdminArea3.getEntry(sVNAdminArea3.getThisDirName(), false);
                    if (sVNEntry2 == null) {
                        sVNEntry2 = sVNAdminArea2.addEntry(file2.getName());
                    }
                    String string = sVNEntry.getURL();
                    String string3 = sVNEntry3.getURL();
                    long l4 = sVNEntry.getRevision();
                    String string4 = sVNEntry.getRepositoryRoot();
                    string3 = SVNPathUtil.append(string3, SVNEncodingUtil.uriEncode(file2.getName()));
                    SVNAdminArea sVNAdminArea4 = sVNWCAccess.open(file2, true, -1);
                    if (sVNEntry.isScheduledForAddition() && sVNEntry.isCopied()) {
                        sVNEntry2.scheduleForAddition();
                        sVNEntry2.setKind(SVNNodeKind.DIR);
                        sVNAdminArea2.saveEntries(true);
                        sVNAdminArea4.updateURL(string3, true);
                        sVNAdminArea4.saveEntries(true);
                    } else if (!sVNEntry.isCopied() && !sVNEntry.isScheduledForAddition()) {
                        sVNEntry2.setCopied(true);
                        sVNEntry2.scheduleForAddition();
                        sVNEntry2.setKind(SVNNodeKind.DIR);
                        sVNEntry2.setCopyFromRevision(l4);
                        sVNEntry2.setCopyFromURL(string);
                        sVNAdminArea2.saveEntries(true);
                        SVNEntry sVNEntry4 = sVNAdminArea4.getEntry(sVNAdminArea4.getThisDirName(), false);
                        sVNEntry4.setCopied(true);
                        sVNEntry4.scheduleForAddition();
                        sVNEntry4.setKind(SVNNodeKind.DIR);
                        sVNEntry4.setCopyFromRevision(l4);
                        sVNEntry4.setURL(string3);
                        sVNEntry4.setCopyFromURL(string);
                        sVNEntry4.setRepositoryRoot(string4);
                        this.updateCopiedDirectory(sVNAdminArea4, sVNAdminArea4.getThisDirName(), string3, string4, null, -1L);
                        sVNAdminArea4.saveEntries(true);
                    } else {
                        sVNAdminArea2.deleteEntry(file2.getName());
                        sVNAdminArea2.saveEntries(true);
                        sVNWCAccess.close();
                        SVNFileUtil.deleteAll(file2, this);
                        SVNFileUtil.copy(file, file2, false, false);
                        this.myWCClient.doAdd(file2, false, false, false, SVNDepth.INFINITY, false, false);
                    }
                }
                try {
                    sVNWCAccess.close();
                    this.myWCClient.doDelete(file, true, false);
                }
                catch (SVNException sVNException) {
                    // empty catch block
                }
            }
            finally {
                sVNWCAccess.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doVirtualCopy(File file, File file2, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        SVNFileType sVNFileType = SVNFileType.getType(file);
        SVNFileType sVNFileType2 = SVNFileType.getType(file2);
        String string2 = string = bl2 ? "move" : "copy";
        if (bl2 && sVNFileType != SVNFileType.NONE) {
            object5 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Cannot perform 'virtual' {0}: ''{1}'' still exists", string, file);
            SVNErrorManager.error((SVNErrorMessage)object5, SVNLogType.WC);
        }
        if (sVNFileType2 == SVNFileType.NONE) {
            object5 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Cannot perform 'virtual' {0}: ''{1}'' does not exist", string, file2);
            SVNErrorManager.error((SVNErrorMessage)object5, SVNLogType.WC);
        }
        if (sVNFileType2 == SVNFileType.DIRECTORY) {
            object5 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot perform 'virtual' {0}: ''{1}'' is a directory", string, file2);
            SVNErrorManager.error((SVNErrorMessage)object5, SVNLogType.WC);
        }
        if (!bl2 && sVNFileType == SVNFileType.DIRECTORY) {
            object5 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot perform 'virtual' {0}: ''{1}'' is a directory", string, file);
            SVNErrorManager.error((SVNErrorMessage)object5, SVNLogType.WC);
        }
        object5 = null;
        SVNURL sVNURL = null;
        boolean bl3 = false;
        try (SVNWCAccess sVNWCAccess = this.createWCAccess();){
            sVNWCAccess.probeOpen(file2, false, 0);
            object4 = sVNWCAccess.getEntry(file2, false);
            if (object4 != null) {
                if (!((SVNEntry)object4).isScheduledForAddition() && !((SVNEntry)object4).isScheduledForReplacement()) {
                    object3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_ATTRIBUTE_INVALID, "Cannot perform 'virtual' {0}: ''{1}'' is scheduled neither for addition nor for replacement", string, file2);
                    SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
                }
                bl3 = true;
                sVNURL = ((SVNEntry)object4).getRepositoryRootURL();
            }
        }
        object4 = this.createWCAccess();
        object3 = null;
        boolean bl4 = false;
        long l2 = -1L;
        try {
            ((SVNWCAccess)object4).probeOpen(file, false, 0);
            object2 = ((SVNWCAccess)object4).getEntry(file, false);
            if (object2 == null) {
                object = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            object5 = ((SVNEntry)object2).getRepositoryRootURL();
            if (this.isCopiedAsAChild(file, (SVNEntry)object2)) {
                object3 = this.getCopyFromURL(file.getParentFile(), SVNEncodingUtil.uriEncode(file.getName()));
                l2 = this.getCopyFromRevision(file.getParentFile());
                if (object3 == null || l2 < 0L) {
                    object = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Cannot locate copied directory root for ''{0}''", (Object)file);
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
                }
                bl4 = false;
            } else {
                object3 = ((SVNEntry)object2).isCopied() ? ((SVNEntry)object2).getCopyFromURL() : ((SVNEntry)object2).getURL();
                l2 = ((SVNEntry)object2).isCopied() ? ((SVNEntry)object2).getCopyFromRevision() : ((SVNEntry)object2).getRevision();
                bl4 = ((SVNEntry)object2).isScheduledForAddition() && !((SVNEntry)object2).isCopied();
            }
        }
        finally {
            ((SVNWCAccess)object4).close();
        }
        if (bl4 && !bl3) {
            if (bl2) {
                this.myWCClient.doDelete(file, true, false);
            }
            this.myWCClient.doAdd(file2, true, false, false, SVNDepth.EMPTY, false, false);
            return;
        }
        sVNWCAccess = this.createWCAccess();
        object4 = this.createWCAccess();
        try {
            Object object6;
            object2 = sVNWCAccess.probeOpen(file2, true, 0);
            object = sVNWCAccess.getEntry(file2, false);
            if (object != null && !((SVNEntry)object).isScheduledForAddition() && !((SVNEntry)object).isScheduledForReplacement()) {
                object6 = SVNErrorMessage.create(SVNErrorCode.ENTRY_ATTRIBUTE_INVALID, "Cannot perform 'virtual' {0}: ''{1}'' is scheduled neither for addition nor for replacement", string, file2);
                SVNErrorManager.error((SVNErrorMessage)object6, SVNLogType.WC);
            }
            if (object5 != null && sVNURL != null && !sVNURL.equals(object5)) {
                object6 = SVNErrorMessage.create(SVNErrorCode.ENTRY_ATTRIBUTE_INVALID, "Cannot perform 'virtual' {0}: paths belong to different repositories", (Object)string);
                SVNErrorManager.error((SVNErrorMessage)object6, SVNLogType.WC);
            }
            object6 = ((SVNWCAccess)object4).probeOpen(file, false, 0);
            SVNVersionedProperties sVNVersionedProperties = ((SVNAdminArea)object6).getProperties(file.getName());
            SVNVersionedProperties sVNVersionedProperties2 = ((SVNAdminArea)object6).getBaseProperties(file.getName());
            SVNVersionedProperties sVNVersionedProperties3 = ((SVNAdminArea)object2).getProperties(file2.getName());
            SVNVersionedProperties sVNVersionedProperties4 = ((SVNAdminArea)object2).getBaseProperties(file2.getName());
            sVNVersionedProperties4.removeAll();
            sVNVersionedProperties.copyTo(sVNVersionedProperties3);
            sVNVersionedProperties2.copyTo(sVNVersionedProperties4);
            object = ((SVNAdminArea)object2).addEntry(file2.getName());
            ((SVNEntry)object).setCopyFromURL((String)object3);
            ((SVNEntry)object).setCopyFromRevision(l2);
            ((SVNEntry)object).setCopied(true);
            ((SVNEntry)object).setKind(SVNNodeKind.FILE);
            File file3 = ((SVNAdminArea)object6).getBaseFile(file.getName(), false);
            File file4 = ((SVNAdminArea)object2).getBaseFile(file2.getName(), false);
            SVNFileUtil.copyFile(file3, file4, false);
            if (((SVNEntry)object).isScheduledForDeletion()) {
                ((SVNEntry)object).unschedule();
                ((SVNEntry)object).scheduleForReplacement();
            } else if (!((SVNEntry)object).isScheduledForReplacement()) {
                ((SVNEntry)object).unschedule();
                ((SVNEntry)object).scheduleForAddition();
            }
            ((SVNAdminArea)object2).saveEntries(false);
            SVNLog sVNLog = ((SVNAdminArea)object2).getLog();
            ((SVNAdminArea)object2).saveVersionedProperties(sVNLog, true);
            sVNLog.save();
            ((SVNAdminArea)object2).runLogs();
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file2, SVNNodeKind.FILE, null, -1L, SVNEventAction.COPY, null, null, null);
            this.dispatchEvent(sVNEvent);
        }
        finally {
            ((SVNWCAccess)object4).close();
            sVNWCAccess.close();
        }
        if (bl2) {
            this.myWCClient.doDelete(file, true, false);
        }
    }

    private boolean isCopiedAsAChild(File file, SVNEntry sVNEntry) {
        if (!sVNEntry.isScheduledForAddition() && sVNEntry.isCopied()) {
            return true;
        }
        if (sVNEntry.isScheduledForDeletion() && file != null) {
            return this.getCopyFromURL(file.getParentFile(), SVNEncodingUtil.uriEncode(sVNEntry.getName())) != null;
        }
        return false;
    }

    private void updateCopiedDirectory(SVNAdminArea sVNAdminArea, String string, String string2, String string3, String string4, long l2) {
        SVNWCAccess sVNWCAccess = sVNAdminArea.getWCAccess();
        SVNEntry sVNEntry = sVNAdminArea.getEntry(string, true);
        if (sVNEntry != null) {
            sVNEntry.setCopied(true);
            if (string2 != null) {
                sVNEntry.setURL(string2);
            }
            sVNEntry.setRepositoryRoot(string3);
            if (sVNEntry.isFile()) {
                if (sVNAdminArea.getWCProperties(string) != null) {
                    sVNAdminArea.getWCProperties(string).removeAll();
                    sVNAdminArea.saveWCProperties(false);
                }
                if (string4 != null) {
                    sVNEntry.setCopyFromURL(string4);
                    sVNEntry.setCopyFromRevision(l2);
                }
            }
            boolean bl2 = false;
            if (sVNEntry.isDeleted() && string2 != null) {
                bl2 = true;
                sVNEntry.setDeleted(false);
                sVNEntry.scheduleForDeletion();
                if (sVNEntry.isDirectory()) {
                    sVNEntry.setKind(SVNNodeKind.FILE);
                }
            }
            if (sVNEntry.getLockToken() != null && string2 != null) {
                sVNEntry.setLockToken(null);
                sVNEntry.setLockOwner(null);
                sVNEntry.setLockComment(null);
                sVNEntry.setLockCreationDate(null);
            }
            if (!sVNAdminArea.getThisDirName().equals(string) && sVNEntry.isDirectory() && !bl2) {
                SVNAdminArea sVNAdminArea2 = sVNWCAccess.retrieve(sVNAdminArea.getFile(string));
                if (sVNAdminArea2 != null) {
                    String string5 = string4 == null ? null : SVNPathUtil.append(string4, SVNEncodingUtil.uriEncode(sVNEntry.getName()));
                    this.updateCopiedDirectory(sVNAdminArea2, sVNAdminArea2.getThisDirName(), string2, string3, string5, l2);
                }
            } else if (sVNAdminArea.getThisDirName().equals(string)) {
                sVNAdminArea.getWCProperties(sVNAdminArea.getThisDirName()).removeAll();
                sVNAdminArea.saveWCProperties(false);
                if (string4 != null) {
                    sVNEntry.setCopyFromURL(string4);
                    sVNEntry.setCopyFromRevision(l2);
                }
                Iterator iterator = sVNAdminArea.entries(true);
                while (iterator.hasNext()) {
                    SVNEntry sVNEntry2 = (SVNEntry)iterator.next();
                    if (sVNAdminArea.getThisDirName().equals(sVNEntry2.getName())) continue;
                    String string6 = string4 == null ? null : SVNPathUtil.append(string4, SVNEncodingUtil.uriEncode(sVNEntry2.getName()));
                    String string7 = string2 == null ? null : SVNPathUtil.append(string2, SVNEncodingUtil.uriEncode(sVNEntry2.getName()));
                    this.updateCopiedDirectory(sVNAdminArea, sVNEntry2.getName(), string7, string3, string6, l2);
                }
                sVNAdminArea.saveEntries(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCopyFromURL(File file, String string) {
        if (file == null) {
            return null;
        }
        SVNWCAccess sVNWCAccess = this.createWCAccess();
        try {
            sVNWCAccess.probeOpen(file, false, 0);
        }
        catch (SVNException sVNException) {
            sVNWCAccess.close();
            return null;
        }
        try {
            SVNEntry sVNEntry = sVNWCAccess.getEntry(file, false);
            if (sVNEntry == null) {
                String string2 = null;
                return string2;
            }
            String string3 = sVNEntry.getCopyFromURL();
            if (string3 != null) {
                String string4 = SVNPathUtil.append(string3, string);
                return string4;
            }
            string = SVNPathUtil.append(SVNEncodingUtil.uriEncode(file.getName()), string);
            file = file.getParentFile();
            String string5 = this.getCopyFromURL(file, string);
            return string5;
        }
        finally {
            sVNWCAccess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCopyFromRevision(File file) {
        if (file == null) {
            return -1L;
        }
        SVNWCAccess sVNWCAccess = this.createWCAccess();
        try {
            sVNWCAccess.probeOpen(file, false, 0);
        }
        catch (SVNException sVNException) {
            sVNWCAccess.close();
            return -1L;
        }
        try {
            SVNEntry sVNEntry = sVNWCAccess.getEntry(file, false);
            if (sVNEntry == null) {
                long l2 = -1L;
                return l2;
            }
            long l3 = sVNEntry.getCopyFromRevision();
            if (l3 >= 0L) {
                long l4 = l3;
                return l4;
            }
            file = file.getParentFile();
            long l5 = this.getCopyFromRevision(file);
            return l5;
        }
        finally {
            sVNWCAccess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isVersionedFile(File file) {
        SVNWCAccess sVNWCAccess = SVNWCAccess.newInstance(null);
        try {
            SVNAdminArea sVNAdminArea = sVNWCAccess.probeOpen(file, false, 0);
            if (sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false) == null) {
                boolean bl2 = false;
                return bl2;
            }
            SVNFileType sVNFileType = SVNFileType.getType(file);
            if (sVNFileType.isFile() || sVNFileType == SVNFileType.NONE) {
                boolean bl3 = sVNAdminArea.getEntry(file.getName(), false) != null;
                return bl3;
            }
            if (sVNFileType != SVNFileType.NONE && !sVNAdminArea.getRoot().equals(file)) {
                boolean bl4 = false;
                return bl4;
            }
            boolean bl5 = true;
            return bl5;
        }
        catch (SVNException sVNException) {
            boolean bl6 = false;
            return bl6;
        }
        finally {
            try {
                sVNWCAccess.close();
            }
            catch (SVNException sVNException) {}
        }
    }
}

