/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc16;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNAnnotationGenerator;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate;
import org.tmatesoft.svn.core.internal.wc16.SVNLogClient16$1;
import org.tmatesoft.svn.core.internal.wc16.SVNLogClient16$2;
import org.tmatesoft.svn.core.internal.wc16.SVNLogClient16$3;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNLogClient16
extends SVNBasicDelegate {
    private SVNDiffOptions myDiffOptions;

    public SVNLogClient16(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
    }

    public SVNLogClient16(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public void setDiffOptions(SVNDiffOptions sVNDiffOptions) {
        this.myDiffOptions = sVNDiffOptions;
    }

    public SVNDiffOptions getDiffOptions() {
        return this.myDiffOptions;
    }

    public void doAnnotate(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, ISVNAnnotateHandler iSVNAnnotateHandler) {
        this.doAnnotate(file, sVNRevision, sVNRevision2, sVNRevision3, false, false, iSVNAnnotateHandler, null);
    }

    public void doAnnotate(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl2, ISVNAnnotateHandler iSVNAnnotateHandler) {
        this.doAnnotate(file, sVNRevision, sVNRevision2, sVNRevision3, bl2, false, iSVNAnnotateHandler, null);
    }

    public void doAnnotate(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl2, boolean bl3, ISVNAnnotateHandler iSVNAnnotateHandler, String string) {
        long l2;
        long l3;
        Object object;
        if (sVNRevision2 == null || !sVNRevision2.isValid()) {
            sVNRevision2 = SVNRevision.create(1L);
        }
        if (sVNRevision3 == null || !sVNRevision3.isValid()) {
            sVNRevision3 = sVNRevision;
        }
        if (sVNRevision2 == SVNRevision.WORKING || sVNRevision3 == SVNRevision.WORKING) {
            object = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Blame of the WORKING revision is not supported");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if ((l3 = this.getRevisionNumber(sVNRevision3, (SVNRepository)(object = this.createRepository(null, file, null, sVNRevision, sVNRevision3, null)), file)) < (l2 = this.getRevisionNumber(sVNRevision2, (SVNRepository)object, file))) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Start revision must precede end revision"), SVNLogType.DEFAULT);
        }
        File file2 = new File(file.getParentFile(), SVNFileUtil.getAdminDirectoryName());
        if (!(file2 = new File(file2, "tmp/text-base")).isDirectory()) {
            file2 = SVNFileUtil.createTempDirectory("annotate");
        }
        this.doAnnotate(file.getAbsolutePath(), l2, file2, (SVNRepository)object, l3, bl2, iSVNAnnotateHandler, string, bl3);
    }

    public void doAnnotate(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, ISVNAnnotateHandler iSVNAnnotateHandler) {
        this.doAnnotate(sVNURL, sVNRevision, sVNRevision2, sVNRevision3, false, false, iSVNAnnotateHandler, null);
    }

    public void doAnnotate(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, ISVNAnnotateHandler iSVNAnnotateHandler, String string) {
        this.doAnnotate(sVNURL, sVNRevision, sVNRevision2, sVNRevision3, false, false, iSVNAnnotateHandler, string);
    }

    public void doAnnotate(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl2, ISVNAnnotateHandler iSVNAnnotateHandler, String string) {
        this.doAnnotate(sVNURL, sVNRevision, sVNRevision2, sVNRevision3, bl2, false, iSVNAnnotateHandler, string);
    }

    public void doAnnotate(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl2, boolean bl3, ISVNAnnotateHandler iSVNAnnotateHandler, String string) {
        long l2;
        long l3;
        Object object;
        if (sVNRevision2 == null || !sVNRevision2.isValid()) {
            sVNRevision2 = SVNRevision.create(1L);
        }
        if (sVNRevision3 == null || !sVNRevision3.isValid()) {
            sVNRevision3 = sVNRevision;
        }
        if (sVNRevision2 == SVNRevision.WORKING || sVNRevision3 == SVNRevision.WORKING) {
            object = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Blame of the WORKING revision is not supported");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if ((l3 = this.getRevisionNumber(sVNRevision3, (SVNRepository)(object = this.createRepository(sVNURL, null, null, sVNRevision, sVNRevision3, null)), null)) < (l2 = this.getRevisionNumber(sVNRevision2, (SVNRepository)object, null))) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Start revision must precede end revision"), SVNLogType.DEFAULT);
        }
        File file = SVNFileUtil.createTempDirectory("annotate");
        this.doAnnotate(((SVNRepository)object).getLocation().toString(), l2, file, (SVNRepository)object, l3, bl2, iSVNAnnotateHandler, string, bl3);
    }

    public void doLog(File[] fileArray, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, boolean bl3, long l2, ISVNLogEntryHandler iSVNLogEntryHandler) {
        this.doLog(fileArray, sVNRevision, sVNRevision2, SVNRevision.UNDEFINED, bl2, bl3, false, l2, null, iSVNLogEntryHandler);
    }

    public void doLog(File[] fileArray, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl2, boolean bl3, boolean bl4, long l2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        ArrayList<SVNRevisionRange> arrayList = new ArrayList<SVNRevisionRange>(1);
        arrayList.add(new SVNRevisionRange(sVNRevision, sVNRevision2));
        this.doLog(fileArray, arrayList, sVNRevision3, bl2, bl3, bl4, l2, stringArray, iSVNLogEntryHandler);
    }

    public void doLog(File[] fileArray, Collection collection, SVNRevision sVNRevision, boolean bl2, boolean bl3, boolean bl4, long l2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        String[] stringArray2;
        Object object;
        Object object2;
        TreeSet treeSet;
        Object object3;
        Object object4;
        Object object5;
        Object object62;
        if (fileArray == null || fileArray.length == 0 || iSVNLogEntryHandler == null) {
            return;
        }
        Object object7 = SVNRevision.UNDEFINED;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object62 : collection) {
            if (((SVNRevisionRange)object62).getStartRevision().isValid() && !((SVNRevisionRange)object62).getEndRevision().isValid()) {
                object62 = new SVNRevisionRange(((SVNRevisionRange)object62).getStartRevision(), ((SVNRevisionRange)object62).getStartRevision());
            } else if (!((SVNRevisionRange)object62).getStartRevision().isValid()) {
                object5 = SVNRevision.UNDEFINED;
                object4 = SVNRevision.UNDEFINED;
                object5 = !sVNRevision.isValid() ? SVNRevision.BASE : sVNRevision;
                if (!((SVNRevisionRange)object62).getEndRevision().isValid()) {
                    object4 = SVNRevision.create(0L);
                }
                object62 = new SVNRevisionRange((SVNRevision)object5, (SVNRevision)object4);
            }
            if (!((SVNRevisionRange)object62).getStartRevision().isValid() || !((SVNRevisionRange)object62).getEndRevision().isValid()) {
                object5 = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Missing required revision specification");
                SVNErrorManager.error((SVNErrorMessage)object5, SVNLogType.WC);
            }
            linkedList.add(object62);
            if (((SVNRevision)object7).isValid()) continue;
            object5 = ((SVNRevisionRange)object62).getStartRevision();
            object4 = ((SVNRevisionRange)object62).getEndRevision();
            if (SVNRevision.isValidRevisionNumber(((SVNRevision)object5).getNumber()) && SVNRevision.isValidRevisionNumber(((SVNRevision)object4).getNumber())) {
                object7 = ((SVNRevision)object5).getNumber() > ((SVNRevision)object4).getNumber() ? object5 : object4;
                continue;
            }
            if (((SVNRevision)object5).getDate() == null || ((SVNRevision)object4).getDate() == null) continue;
            object7 = ((SVNRevision)object5).getDate().compareTo(((SVNRevision)object4).getDate()) > 0 ? object5 : object4;
        }
        if (l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        SVNLogClient16$1 sVNLogClient16$1 = new SVNLogClient16$1(this, iSVNLogEntryHandler);
        object62 = new SVNURL[fileArray.length];
        object5 = this.createWCAccess();
        object4 = new ArrayList();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            this.checkCancelled();
            object3 = fileArray[i2];
            object4.add(((File)object3).getAbsolutePath().replace(File.separatorChar, '/'));
            treeSet = ((SVNWCAccess)object5).probeOpen((File)object3, false, 0);
            object2 = ((SVNWCAccess)object5).getVersionedEntry((File)object3, false);
            if (((SVNEntry)object2).getURL() == null) {
                object = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Entry ''{0}'' has no URL", object3);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            object62[i2] = ((SVNEntry)object2).getSVNURL();
            if (treeSet == null) continue;
            ((SVNWCAccess)object5).closeAdminArea(((SVNAdminArea)((Object)treeSet)).getRoot());
        }
        if (((Object)object62).length == 0) {
            return;
        }
        String[] stringArray3 = object4.toArray(new String[object4.size()]);
        object3 = SVNPathUtil.condencePaths(stringArray3, null, true);
        treeSet = new TreeSet();
        object2 = SVNURLUtil.condenceURLs((SVNURL[])object62, treeSet, true);
        if (object2 == null) {
            object = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "target log paths belong to different repositories");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (treeSet.isEmpty()) {
            treeSet.add("");
        }
        if (!sVNRevision.isValid()) {
            sVNRevision = SVNRevision.WORKING;
        }
        object = null;
        if (object3 != null && this.needsWC(sVNRevision)) {
            stringArray2 = new File((String)object3);
            SVNAdminArea sVNAdminArea = ((SVNWCAccess)object5).probeOpen((File)stringArray2, false, 0);
            object = this.createRepository(null, (File)stringArray2, sVNAdminArea, sVNRevision, (SVNRevision)object7, null);
            if (sVNAdminArea != null) {
                ((SVNWCAccess)object5).closeAdminArea(sVNAdminArea.getRoot());
            }
        } else {
            object = this.createRepository((SVNURL)object2, null, null, sVNRevision, (SVNRevision)object7, null);
        }
        stringArray2 = treeSet.toArray(new String[treeSet.size()]);
        for (int i3 = 0; i3 < stringArray2.length; ++i3) {
            stringArray2[i3] = SVNEncodingUtil.uriDecode(stringArray2[i3]);
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            this.checkCancelled();
            SVNRevisionRange sVNRevisionRange = (SVNRevisionRange)iterator.next();
            SVNRevision sVNRevision2 = sVNRevisionRange.getStartRevision();
            SVNRevision sVNRevision3 = sVNRevisionRange.getEndRevision();
            if (sVNRevision2.isLocal() || sVNRevision3.isLocal()) {
                for (int i4 = 0; i4 < fileArray.length; ++i4) {
                    this.checkCancelled();
                    long l3 = this.getRevisionNumber(sVNRevision2, (SVNRepository)object, fileArray[i4]);
                    long l4 = this.getRevisionNumber(sVNRevision3, (SVNRepository)object, fileArray[i4]);
                    ((SVNRepository)object).log(stringArray2, l3, l4, bl3, bl2, l2, bl4, stringArray, sVNLogClient16$1);
                }
                continue;
            }
            long l5 = this.getRevisionNumber(sVNRevision2, (SVNRepository)object, null);
            long l6 = this.getRevisionNumber(sVNRevision3, (SVNRepository)object, null);
            ((SVNRepository)object).log(stringArray2, l5, l6, bl3, bl2, l2, bl4, stringArray, sVNLogClient16$1);
        }
    }

    public void doLog(File[] fileArray, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl2, boolean bl3, long l2, ISVNLogEntryHandler iSVNLogEntryHandler) {
        this.doLog(fileArray, sVNRevision2, sVNRevision3, sVNRevision, bl2, bl3, false, l2, null, iSVNLogEntryHandler);
    }

    public void doLog(SVNURL sVNURL, String[] stringArray, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl2, boolean bl3, long l2, ISVNLogEntryHandler iSVNLogEntryHandler) {
        this.doLog(sVNURL, stringArray, sVNRevision, sVNRevision2, sVNRevision3, bl2, bl3, false, l2, null, iSVNLogEntryHandler);
    }

    public void doLog(SVNURL sVNURL, String[] stringArray, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl2, boolean bl3, boolean bl4, long l2, String[] stringArray2, ISVNLogEntryHandler iSVNLogEntryHandler) {
        ArrayList<SVNRevisionRange> arrayList = new ArrayList<SVNRevisionRange>(1);
        arrayList.add(new SVNRevisionRange(sVNRevision2, sVNRevision3));
        this.doLog(sVNURL, stringArray, sVNRevision, arrayList, bl2, bl3, bl4, l2, stringArray2, iSVNLogEntryHandler);
    }

    public void doLog(SVNURL sVNURL, String[] stringArray, SVNRevision sVNRevision, Collection collection, boolean bl2, boolean bl3, boolean bl4, long l2, String[] stringArray2, ISVNLogEntryHandler iSVNLogEntryHandler) {
        String[] stringArray3;
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Object object5 = SVNRevision.UNDEFINED;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object42 : collection) {
            if (((SVNRevisionRange)object42).getStartRevision().isValid() && !((SVNRevisionRange)object42).getEndRevision().isValid()) {
                object42 = new SVNRevisionRange(((SVNRevisionRange)object42).getStartRevision(), ((SVNRevisionRange)object42).getStartRevision());
            } else if (!((SVNRevisionRange)object42).getStartRevision().isValid()) {
                object3 = SVNRevision.UNDEFINED;
                object2 = SVNRevision.UNDEFINED;
                object3 = !sVNRevision.isValid() ? SVNRevision.HEAD : sVNRevision;
                if (!((SVNRevisionRange)object42).getEndRevision().isValid()) {
                    object2 = SVNRevision.create(0L);
                }
                object42 = new SVNRevisionRange((SVNRevision)object3, (SVNRevision)object2);
            }
            if (!((SVNRevisionRange)object42).getStartRevision().isValid() || !((SVNRevisionRange)object42).getEndRevision().isValid()) {
                object3 = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Missing required revision specification");
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
            }
            if (this.needsWC(((SVNRevisionRange)object42).getStartRevision()) || this.needsWC(((SVNRevisionRange)object42).getEndRevision())) {
                object3 = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Revision type requires a working copy path, not a URL");
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
            }
            linkedList.add(object42);
            if (((SVNRevision)object5).isValid()) continue;
            object3 = ((SVNRevisionRange)object42).getStartRevision();
            object2 = ((SVNRevisionRange)object42).getEndRevision();
            if (SVNRevision.isValidRevisionNumber(((SVNRevision)object3).getNumber()) && SVNRevision.isValidRevisionNumber(((SVNRevision)object2).getNumber())) {
                object5 = ((SVNRevision)object3).getNumber() > ((SVNRevision)object2).getNumber() ? object3 : object2;
                continue;
            }
            if (((SVNRevision)object3).getDate() == null || ((SVNRevision)object2).getDate() == null) continue;
            object5 = ((SVNRevision)object3).getDate().compareTo(((SVNRevision)object2).getDate()) > 0 ? object3 : object2;
        }
        if (this.needsWC(sVNRevision)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Revision type requires a working copy path, not a URL");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        if (stringArray == null || stringArray.length == 0) {
            String[] stringArray4 = new String[1];
            stringArray3 = stringArray4;
            stringArray4[0] = "";
        } else {
            stringArray3 = stringArray;
        }
        stringArray = stringArray3;
        object = new SVNLogClient16$2(this, iSVNLogEntryHandler);
        object42 = ((SVNRevision)object5).isValid() ? this.createRepository(sVNURL, null, null, sVNRevision, (SVNRevision)object5, null) : this.createRepository(sVNURL, null, null, true);
        object3 = linkedList.iterator();
        while (object3.hasNext()) {
            this.checkCancelled();
            object2 = (SVNRevisionRange)object3.next();
            long l3 = this.getRevisionNumber(((SVNRevisionRange)object2).getStartRevision(), (SVNRepository)object42, null);
            long l4 = this.getRevisionNumber(((SVNRevisionRange)object2).getEndRevision(), (SVNRepository)object42, null);
            ((SVNRepository)object42).log(stringArray, l3, l4, bl3, bl2, l2, bl4, stringArray2, (ISVNLogEntryHandler)object);
        }
    }

    public void doList(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, boolean bl3, ISVNDirEntryHandler iSVNDirEntryHandler) {
        this.doList(file, sVNRevision, sVNRevision2, bl2, bl3 ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES, -1, iSVNDirEntryHandler);
    }

    public void doList(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, SVNDepth sVNDepth, int n2, ISVNDirEntryHandler iSVNDirEntryHandler) {
        if (sVNRevision2 == null || !sVNRevision2.isValid()) {
            sVNRevision2 = SVNRevision.BASE;
        }
        SVNRepository sVNRepository = this.createRepository(null, file, null, sVNRevision, sVNRevision2, null);
        long l2 = this.getRevisionNumber(sVNRevision2, sVNRepository, file);
        this.doList(sVNRepository, l2, iSVNDirEntryHandler, bl2, sVNDepth, n2);
    }

    public void doList(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, ISVNDirEntryHandler iSVNDirEntryHandler) {
        this.doList(file, sVNRevision, sVNRevision2, false, bl2 ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES, -1, iSVNDirEntryHandler);
    }

    public void doList(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, boolean bl3, ISVNDirEntryHandler iSVNDirEntryHandler) {
        this.doList(sVNURL, sVNRevision, sVNRevision2, bl2, bl3 ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES, -1, iSVNDirEntryHandler);
    }

    public void doList(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, SVNDepth sVNDepth, int n2, ISVNDirEntryHandler iSVNDirEntryHandler) {
        long[] lArray = new long[]{-1L};
        SVNRepository sVNRepository = this.createRepository(sVNURL, null, null, sVNRevision, sVNRevision2, lArray);
        if (lArray[0] < 0L) {
            lArray[0] = this.getRevisionNumber(sVNRevision2, sVNRepository, null);
        }
        this.doList(sVNRepository, lArray[0], iSVNDirEntryHandler, bl2, sVNDepth, n2);
    }

    public void doList(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, ISVNDirEntryHandler iSVNDirEntryHandler) {
        this.doList(sVNURL, sVNRevision, sVNRevision2, false, bl2, iSVNDirEntryHandler);
    }

    private boolean needsWC(SVNRevision sVNRevision) {
        return sVNRevision == SVNRevision.BASE || sVNRevision == SVNRevision.COMMITTED || sVNRevision == SVNRevision.WORKING || sVNRevision == SVNRevision.PREVIOUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAnnotate(String string, long l2, File file, SVNRepository sVNRepository, long l3, boolean bl2, ISVNAnnotateHandler iSVNAnnotateHandler, String string2, boolean bl3) {
        boolean bl4;
        boolean bl5;
        SVNAnnotationGenerator sVNAnnotationGenerator;
        block5: {
            sVNAnnotationGenerator = new SVNAnnotationGenerator(string, file, l2, bl2, bl3, this.getDiffOptions(), string2, iSVNAnnotateHandler, this);
            sVNAnnotationGenerator.setEndRevision(l3);
            bl5 = iSVNAnnotateHandler != null && !iSVNAnnotateHandler.getClass().getName().startsWith("org.tmatesoft.svn.");
            bl4 = false;
            if (bl5 && sVNRepository instanceof DAVRepository) {
                bl4 = ((DAVRepository)sVNRepository).isSpoolResponse();
                ((DAVRepository)sVNRepository).setSpoolResponse(true);
            }
            try {
                sVNRepository.getFileRevisions("", l2 > 0L ? l2 - 1L : l2, l3, bl3, sVNAnnotationGenerator);
                if (sVNAnnotationGenerator.isLastRevisionReported()) break block5;
                sVNAnnotationGenerator.reportAnnotations(iSVNAnnotateHandler, string2);
            }
            catch (Throwable throwable) {
                if (bl5 && sVNRepository instanceof DAVRepository) {
                    ((DAVRepository)sVNRepository).setSpoolResponse(bl4);
                }
                sVNAnnotationGenerator.dispose();
                SVNFileUtil.deleteAll(file, !"text-base".equals(file.getName()), null);
                throw throwable;
            }
        }
        if (bl5 && sVNRepository instanceof DAVRepository) {
            ((DAVRepository)sVNRepository).setSpoolResponse(bl4);
        }
        sVNAnnotationGenerator.dispose();
        SVNFileUtil.deleteAll(file, !"text-base".equals(file.getName()), null);
    }

    private void doList(SVNRepository sVNRepository, long l2, ISVNDirEntryHandler iSVNDirEntryHandler, boolean bl2, SVNDepth sVNDepth, int n2) {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        SVNURL sVNURL = sVNRepository.getLocation();
        SVNURL sVNURL2 = sVNRepository.getRepositoryRoot(false);
        Object object4 = null;
        SVNException sVNException = null;
        try {
            object4 = sVNRepository.info("", l2);
        }
        catch (SVNException sVNException2) {
            if (sVNException2.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                sVNException = sVNException2;
            }
            throw sVNException2;
        }
        if (sVNException != null) {
            serializable = sVNRepository.checkPath("", l2);
            if (serializable != SVNNodeKind.NONE) {
                Object object5;
                if (!sVNURL.equals(sVNURL2)) {
                    object3 = SVNPathUtil.tail(sVNRepository.getLocation().getPath());
                    sVNRepository.setLocation(sVNRepository.getLocation().removePathTail(), false);
                    object2 = sVNRepository.getDir("", l2, null, n2, (Collection)null);
                    sVNRepository.setLocation(sVNURL, false);
                    object5 = object2.iterator();
                    while (object5.hasNext()) {
                        object = (SVNDirEntry)object5.next();
                        if (!((String)object3).equals(((SVNDirEntry)object).getName())) continue;
                        object4 = object;
                        break;
                    }
                    if (object4 != null) {
                        ((SVNDirEntry)object4).setRelativePath((String)(serializable == SVNNodeKind.FILE ? object3 : ""));
                    }
                } else {
                    object3 = new SVNProperties();
                    sVNRepository.getDir("", l2, (SVNProperties)object3, n2, (Collection)null);
                    object2 = sVNRepository.getRevisionProperties(l2, null);
                    object5 = ((SVNProperties)object2).getStringValue("svn:author");
                    object = ((SVNProperties)object2).getStringValue("svn:date");
                    Date date = null;
                    if (object != null) {
                        date = SVNDate.parseDateString((String)object);
                    }
                    object4 = new SVNDirEntry(sVNURL, sVNURL2, "", (SVNNodeKind)serializable, 0L, !((SVNProperties)object3).isEmpty(), l2, date, (String)object5);
                    ((SVNDirEntry)object4).setRelativePath("");
                }
            }
        } else if (object4 != null) {
            ((SVNDirEntry)object4).setRelativePath(((SVNDirEntry)object4).getKind() == SVNNodeKind.DIR ? "" : ((SVNDirEntry)object4).getName());
        }
        if (object4 == null) {
            serializable = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "URL ''{0}'' non-existent in that revision", (Object)sVNURL);
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        serializable = new SVNHashMap();
        if (bl2) {
            block19: {
                object3 = new SVNLock[]{};
                try {
                    object3 = sVNRepository.getLocks("");
                }
                catch (SVNException sVNException3) {
                    if (sVNException3.getErrorMessage() != null && sVNException3.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) break block19;
                    throw sVNException3;
                }
            }
            if (object3 != null && ((Object)object3).length > 0) {
                object2 = sVNRepository.getRepositoryRoot(true);
                for (int i2 = 0; i2 < ((Object)object3).length; ++i2) {
                    object = ((SVNLock)object3[i2]).getPath();
                    serializable.put(((SVNURL)object2).appendPath((String)object, false), object3[i2]);
                }
            }
        }
        object3 = new SVNLogClient16$3(this, (Map)((Object)serializable), iSVNDirEntryHandler);
        object3.handleDirEntry((SVNDirEntry)object4);
        if (((SVNDirEntry)object4).getKind() == SVNNodeKind.DIR && (sVNDepth == SVNDepth.FILES || sVNDepth == SVNDepth.IMMEDIATES || sVNDepth == SVNDepth.INFINITY)) {
            SVNLogClient16.list(sVNRepository, "", l2, sVNDepth, n2, (ISVNDirEntryHandler)object3);
        }
    }

    private static void list(SVNRepository sVNRepository, String string, long l2, SVNDepth sVNDepth, int n2, ISVNDirEntryHandler iSVNDirEntryHandler) {
        if (sVNDepth == SVNDepth.EMPTY) {
            return;
        }
        Collection collection = new TreeSet();
        try {
            collection = sVNRepository.getDir(string, l2, null, n2, collection);
        }
        catch (SVNAuthenticationException sVNAuthenticationException) {
            return;
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_AUTHORIZED) {
                return;
            }
            throw sVNException;
        }
        for (SVNDirEntry sVNDirEntry : collection) {
            String string2 = SVNPathUtil.append(string, sVNDirEntry.getName());
            sVNDirEntry.setRelativePath(string2);
            if (sVNDirEntry.getKind() == SVNNodeKind.FILE || sVNDepth == SVNDepth.IMMEDIATES || sVNDepth == SVNDepth.INFINITY) {
                iSVNDirEntryHandler.handleDirEntry(sVNDirEntry);
            }
            if (sVNDirEntry.getKind() != SVNNodeKind.DIR || sVNDirEntry.getDate() == null || sVNDepth != SVNDepth.INFINITY) continue;
            SVNLogClient16.list(sVNRepository, string2, l2, sVNDepth, n2, iSVNDirEntryHandler);
        }
    }
}

