/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc16;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAmbientDepthFilterEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNDiffCallback;
import org.tmatesoft.svn.core.internal.wc.SVNDiffEditor;
import org.tmatesoft.svn.core.internal.wc.SVNDiffStatusEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver;
import org.tmatesoft.svn.core.internal.wc.SVNRemoteDiffEditor;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNReporter;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatch;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchFileStream;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchTarget;
import org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate$SVNRepositoryLocation;
import org.tmatesoft.svn.core.internal.wc16.SVNDiffClient16$1;
import org.tmatesoft.svn.core.internal.wc16.SVNDiffClient16$2;
import org.tmatesoft.svn.core.internal.wc16.SVNDiffClient16$3;
import org.tmatesoft.svn.core.internal.wc16.SVNDiffClient16$4;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffStatusHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDiffClient16
extends SVNMergeDriver {
    private ISVNDiffGenerator myDiffGenerator;
    private SVNDiffOptions myDiffOptions;

    public SVNDiffClient16(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
    }

    public SVNDiffClient16(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public void setDiffGenerator(ISVNDiffGenerator iSVNDiffGenerator) {
        this.myDiffGenerator = iSVNDiffGenerator;
    }

    public ISVNDiffGenerator getDiffGenerator() {
        return this.myDiffGenerator;
    }

    public void setMergeOptions(SVNDiffOptions sVNDiffOptions) {
        this.myDiffOptions = sVNDiffOptions;
    }

    @Override
    public SVNDiffOptions getMergeOptions() {
        if (this.myDiffOptions == null) {
            this.myDiffOptions = new SVNDiffOptions();
        }
        return this.myDiffOptions;
    }

    public void doDiff(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl2, boolean bl3, OutputStream outputStream) {
        this.doDiff(sVNURL, sVNRevision, sVNRevision2, sVNRevision3, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, outputStream);
    }

    public void doDiff(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, SVNDepth sVNDepth, boolean bl2, OutputStream outputStream) {
        SVNErrorMessage sVNErrorMessage;
        if (!sVNRevision2.isValid() || !sVNRevision3.isValid()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if (sVNRevision2.isLocal() || sVNRevision3.isLocal()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions must be non-local for a pegged diff of an URL");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        this.getDiffGenerator().init(sVNURL.toString(), sVNURL.toString());
        this.doDiffURLURL(sVNURL, null, sVNRevision2, sVNURL, null, sVNRevision3, sVNRevision, sVNDepth, bl2, outputStream);
    }

    public void doDiff(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl2, boolean bl3, OutputStream outputStream) {
        this.doDiff(file, sVNRevision, sVNRevision2, sVNRevision3, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, outputStream, null);
    }

    public void doDiff(File[] fileArray, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, SVNDepth sVNDepth, boolean bl2, OutputStream outputStream, Collection collection) {
        if (fileArray == null) {
            return;
        }
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file = fileArray[i2];
            try {
                this.doDiff(file, sVNRevision3, sVNRevision, sVNRevision2, sVNDepth, bl2, outputStream, collection);
                continue;
            }
            catch (SVNException sVNException) {
                this.dispatchEvent(SVNEventFactory.createErrorEvent(sVNException.getErrorMessage(), null));
            }
        }
    }

    public void doDiff(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, SVNDepth sVNDepth, boolean bl2, OutputStream outputStream, Collection collection) {
        boolean bl3;
        if (!sVNRevision2.isValid() || !sVNRevision3.isValid()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        boolean bl4 = sVNRevision2 == SVNRevision.BASE || sVNRevision2 == SVNRevision.WORKING;
        boolean bl5 = bl3 = sVNRevision3 == SVNRevision.BASE || sVNRevision3 == SVNRevision.WORKING;
        if (bl4 && bl3) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "At least one revision must be non-local for a pegged diff");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        file = file.getAbsoluteFile();
        this.getDiffGenerator().init(file.getAbsolutePath(), file.getAbsolutePath());
        if (sVNRevision3 != SVNRevision.BASE && sVNRevision3 != SVNRevision.WORKING && sVNRevision3 != SVNRevision.COMMITTED) {
            if (sVNRevision2 == SVNRevision.BASE || sVNRevision2 == SVNRevision.WORKING || sVNRevision2 == SVNRevision.COMMITTED) {
                this.doDiffURLWC(file, sVNRevision3, sVNRevision, file, sVNRevision2, true, sVNDepth, bl2, outputStream, collection);
            } else {
                this.doDiffURLURL(null, file, sVNRevision2, null, file, sVNRevision3, sVNRevision, sVNDepth, bl2, outputStream);
            }
        } else {
            this.doDiffURLWC(file, sVNRevision2, sVNRevision, file, sVNRevision3, false, sVNDepth, bl2, outputStream, collection);
        }
    }

    public void doDiff(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, boolean bl2, boolean bl3, OutputStream outputStream) {
        this.doDiff(sVNURL, sVNRevision, sVNURL2, sVNRevision2, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, outputStream);
    }

    public void doDiff(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, OutputStream outputStream) {
        if (!sVNRevision.isValid() || !sVNRevision2.isValid()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        this.getDiffGenerator().init(sVNURL.toString(), sVNURL2.toString());
        this.doDiffURLURL(sVNURL, null, sVNRevision, sVNURL2, null, sVNRevision2, SVNRevision.UNDEFINED, sVNDepth, bl2, outputStream);
    }

    public void doDiff(File file, SVNRevision sVNRevision, SVNURL sVNURL, SVNRevision sVNRevision2, boolean bl2, boolean bl3, OutputStream outputStream) {
        this.doDiff(file, sVNRevision, sVNURL, sVNRevision2, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, outputStream, null);
    }

    public void doDiff(File file, SVNRevision sVNRevision, SVNURL sVNURL, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, OutputStream outputStream, Collection collection) {
        if (!sVNRevision.isValid() || !sVNRevision2.isValid()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        this.getDiffGenerator().init(file.getAbsolutePath(), sVNURL.toString());
        if (sVNRevision == SVNRevision.BASE || sVNRevision == SVNRevision.WORKING) {
            this.doDiffURLWC(sVNURL, sVNRevision2, SVNRevision.UNDEFINED, file, sVNRevision, true, sVNDepth, bl2, outputStream, collection);
        } else {
            this.doDiffURLURL(null, file, sVNRevision, sVNURL, null, sVNRevision2, SVNRevision.UNDEFINED, sVNDepth, bl2, outputStream);
        }
    }

    public void doDiff(SVNURL sVNURL, SVNRevision sVNRevision, File file, SVNRevision sVNRevision2, boolean bl2, boolean bl3, OutputStream outputStream) {
        this.doDiff(sVNURL, sVNRevision, file, sVNRevision2, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, outputStream, null);
    }

    public void doDiff(SVNURL sVNURL, SVNRevision sVNRevision, File file, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, OutputStream outputStream, Collection collection) {
        if (!sVNRevision.isValid() || !sVNRevision2.isValid()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        this.getDiffGenerator().init(sVNURL.toString(), file.getAbsolutePath());
        if (sVNRevision2 == SVNRevision.BASE || sVNRevision2 == SVNRevision.WORKING) {
            this.doDiffURLWC(sVNURL, sVNRevision, SVNRevision.UNDEFINED, file, sVNRevision2, false, sVNDepth, bl2, outputStream, collection);
        } else {
            this.doDiffURLURL(sVNURL, null, sVNRevision, null, file, sVNRevision2, SVNRevision.UNDEFINED, sVNDepth, bl2, outputStream);
        }
    }

    public void doDiff(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, boolean bl2, boolean bl3, OutputStream outputStream) {
        this.doDiff(file, sVNRevision, file2, sVNRevision2, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, outputStream, null);
    }

    public void doDiff(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, OutputStream outputStream, Collection collection) {
        if (!sVNRevision.isValid() || !sVNRevision2.isValid()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        boolean bl3 = sVNRevision == SVNRevision.WORKING || sVNRevision == SVNRevision.BASE;
        boolean bl4 = sVNRevision2 == SVNRevision.WORKING || sVNRevision2 == SVNRevision.BASE;
        this.getDiffGenerator().init(file.getAbsolutePath(), file2.getAbsolutePath());
        if (bl3 && bl4) {
            this.doDiffWCWC(file, sVNRevision, file2, sVNRevision2, sVNDepth, bl2, outputStream, collection);
        } else if (bl3) {
            this.doDiffURLWC(file2, sVNRevision2, SVNRevision.UNDEFINED, file, sVNRevision, true, sVNDepth, bl2, outputStream, collection);
        } else if (bl4) {
            this.doDiffURLWC(file, sVNRevision, SVNRevision.UNDEFINED, file2, sVNRevision2, false, sVNDepth, bl2, outputStream, collection);
        } else {
            this.doDiffURLURL(null, file, sVNRevision, null, file2, sVNRevision2, SVNRevision.UNDEFINED, sVNDepth, bl2, outputStream);
        }
    }

    public void doDiffStatus(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, boolean bl2, boolean bl3, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        this.doDiffStatus(file, sVNRevision, file2, sVNRevision2, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, iSVNDiffStatusHandler);
    }

    public void doDiffStatus(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, SVNDepth sVNDepth, boolean bl2, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        boolean bl3;
        if (iSVNDiffStatusHandler == null) {
            return;
        }
        if (sVNRevision3 == null) {
            sVNRevision3 = SVNRevision.UNDEFINED;
        }
        if (!sVNRevision.isValid() || !sVNRevision2.isValid()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all required revisions are specified");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        boolean bl4 = sVNRevision == SVNRevision.WORKING || sVNRevision == SVNRevision.BASE;
        boolean bl5 = bl3 = sVNRevision2 == SVNRevision.WORKING || sVNRevision2 == SVNRevision.BASE;
        if (bl4 || bl3) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Summarizing diff can only compare repository to repository");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        this.doDiffURLURL(null, file, sVNRevision, null, file, sVNRevision2, sVNRevision3, sVNDepth, bl2, iSVNDiffStatusHandler);
    }

    public void doDiffStatus(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        boolean bl3;
        if (iSVNDiffStatusHandler == null) {
            return;
        }
        if (!sVNRevision.isValid() || !sVNRevision2.isValid()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all required revisions are specified");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        boolean bl4 = sVNRevision == SVNRevision.WORKING || sVNRevision == SVNRevision.BASE;
        boolean bl5 = bl3 = sVNRevision2 == SVNRevision.WORKING || sVNRevision2 == SVNRevision.BASE;
        if (bl4 || bl3) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Summarizing diff can only compare repository to repository");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        this.doDiffURLURL(null, file, sVNRevision, null, file2, sVNRevision2, SVNRevision.UNDEFINED, sVNDepth, bl2, iSVNDiffStatusHandler);
    }

    public void doDiffStatus(File file, SVNRevision sVNRevision, SVNURL sVNURL, SVNRevision sVNRevision2, boolean bl2, boolean bl3, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        this.doDiffStatus(file, sVNRevision, sVNURL, sVNRevision2, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, iSVNDiffStatusHandler);
    }

    public void doDiffStatus(File file, SVNRevision sVNRevision, SVNURL sVNURL, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        SVNErrorMessage sVNErrorMessage;
        if (iSVNDiffStatusHandler == null) {
            return;
        }
        if (!sVNRevision.isValid() || !sVNRevision2.isValid()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all required revisions are specified");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if (sVNRevision == SVNRevision.BASE || sVNRevision == SVNRevision.WORKING) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Summarizing diff can only compare repository to repository");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        } else {
            this.doDiffURLURL(null, file, sVNRevision, sVNURL, null, sVNRevision2, SVNRevision.UNDEFINED, sVNDepth, bl2, iSVNDiffStatusHandler);
        }
    }

    public void doDiffStatus(SVNURL sVNURL, SVNRevision sVNRevision, File file, SVNRevision sVNRevision2, boolean bl2, boolean bl3, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        this.doDiffStatus(sVNURL, sVNRevision, file, sVNRevision2, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, iSVNDiffStatusHandler);
    }

    public void doDiffStatus(SVNURL sVNURL, SVNRevision sVNRevision, File file, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        SVNErrorMessage sVNErrorMessage;
        if (iSVNDiffStatusHandler == null) {
            return;
        }
        if (!sVNRevision.isValid() || !sVNRevision2.isValid()) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if (sVNRevision2 == SVNRevision.BASE || sVNRevision2 == SVNRevision.WORKING) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Summarizing diff can only compare repository to repository");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        } else {
            this.doDiffURLURL(sVNURL, null, sVNRevision, null, file, sVNRevision2, SVNRevision.UNDEFINED, sVNDepth, bl2, iSVNDiffStatusHandler);
        }
    }

    public void doDiffStatus(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, boolean bl2, boolean bl3, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        this.doDiffStatus(sVNURL, sVNRevision, sVNURL2, sVNRevision2, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, iSVNDiffStatusHandler);
    }

    public void doDiffStatus(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, SVNDepth sVNDepth, boolean bl2, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        if (iSVNDiffStatusHandler == null) {
            return;
        }
        if (sVNRevision3 == null) {
            sVNRevision3 = SVNRevision.UNDEFINED;
        }
        if (!sVNRevision.isValid() || !sVNRevision2.isValid()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        this.doDiffURLURL(sVNURL, null, sVNRevision, sVNURL, null, sVNRevision2, sVNRevision3, sVNDepth, bl2, iSVNDiffStatusHandler);
    }

    public void doDiffStatus(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        if (iSVNDiffStatusHandler == null) {
            return;
        }
        if (!sVNRevision.isValid() || !sVNRevision2.isValid()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        this.doDiffURLURL(sVNURL, null, sVNRevision, sVNURL2, null, sVNRevision2, SVNRevision.UNDEFINED, sVNDepth, bl2, iSVNDiffStatusHandler);
    }

    public void doMerge(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, File file3, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.doMerge(file, sVNRevision, file2, sVNRevision2, file3, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, bl4, bl5, false);
    }

    public void doMerge(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, File file3, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Object object;
        file = file.getAbsoluteFile();
        file2 = file2.getAbsoluteFile();
        file3 = file3.getAbsoluteFile();
        SVNURL sVNURL = this.getURL(file);
        if (sVNURL == null) {
            object = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if ((object = this.getURL(file2)) == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)file2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        this.runMerge(sVNURL, sVNRevision, (SVNURL)object, sVNRevision2, file3, sVNDepth, bl4, bl3, !bl2, bl5);
    }

    public void doMerge(File file, SVNRevision sVNRevision, SVNURL sVNURL, SVNRevision sVNRevision2, File file2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.doMerge(file, sVNRevision, sVNURL, sVNRevision2, file2, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, bl4, bl5, false);
    }

    public void doMerge(File file, SVNRevision sVNRevision, SVNURL sVNURL, SVNRevision sVNRevision2, File file2, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        file = file.getAbsoluteFile();
        file2 = file2.getAbsoluteFile();
        SVNURL sVNURL2 = this.getURL(file);
        if (sVNURL2 == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        this.runMerge(sVNURL2, sVNRevision, sVNURL, sVNRevision2, file2, sVNDepth, bl4, bl3, !bl2, bl5);
    }

    public void doMerge(SVNURL sVNURL, SVNRevision sVNRevision, File file, SVNRevision sVNRevision2, File file2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.doMerge(sVNURL, sVNRevision, file, sVNRevision2, file2, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, bl4, bl5, false);
    }

    public void doMerge(SVNURL sVNURL, SVNRevision sVNRevision, File file, SVNRevision sVNRevision2, File file2, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        file = file.getAbsoluteFile();
        file2 = file2.getAbsoluteFile();
        SVNURL sVNURL2 = this.getURL(file);
        if (sVNURL2 == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        this.runMerge(sVNURL, sVNRevision, sVNURL2, sVNRevision2, file2, sVNDepth, bl4, bl3, !bl2, bl5);
    }

    public void doMerge(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, File file, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.doMerge(sVNURL, sVNRevision, sVNURL2, sVNRevision2, file, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, bl4, bl5, false);
    }

    public void doMerge(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, File file, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.runMerge(sVNURL, sVNRevision, sVNURL2, sVNRevision2, file, sVNDepth, bl4, bl3, !bl2, bl5);
    }

    public void doMerge(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, File file, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        SVNRevisionRange sVNRevisionRange = new SVNRevisionRange(sVNRevision2, sVNRevision3);
        LinkedList<SVNRevisionRange> linkedList = new LinkedList<SVNRevisionRange>();
        linkedList.add(sVNRevisionRange);
        this.doMerge(sVNURL, sVNRevision, linkedList, file, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, bl4, bl5, false);
    }

    public void doMerge(SVNURL sVNURL, SVNRevision sVNRevision, Collection collection, File file, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (sVNRevision == null || !sVNRevision.isValid()) {
            sVNRevision = SVNRevision.HEAD;
        }
        this.runPeggedMerge(sVNURL, null, collection, sVNRevision, file, sVNDepth, bl4, bl3, !bl2, bl5);
    }

    public void doMerge(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, File file2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        SVNRevisionRange sVNRevisionRange = new SVNRevisionRange(sVNRevision2, sVNRevision3);
        LinkedList<SVNRevisionRange> linkedList = new LinkedList<SVNRevisionRange>();
        linkedList.add(sVNRevisionRange);
        this.doMerge(file, sVNRevision, linkedList, file2, SVNDepth.getInfinityOrFilesDepth(bl2), bl3, bl4, bl5, false);
    }

    public void doMerge(File file, SVNRevision sVNRevision, Collection collection, File file2, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (sVNRevision == null || !sVNRevision.isValid()) {
            sVNRevision = SVNRevision.WORKING;
        }
        this.runPeggedMerge(null, file, collection, sVNRevision, file2, sVNDepth, bl4, bl3, !bl2, bl5);
    }

    public void doMergeReIntegrate(File file, SVNRevision sVNRevision, File file2, boolean bl2) {
        if (sVNRevision == null || !sVNRevision.isValid()) {
            sVNRevision = SVNRevision.WORKING;
        }
        this.runMergeReintegrate(null, file, sVNRevision, file2, bl2);
    }

    public void doMergeReIntegrate(SVNURL sVNURL, SVNRevision sVNRevision, File file, boolean bl2) {
        if (sVNRevision == null || !sVNRevision.isValid()) {
            sVNRevision = SVNRevision.HEAD;
        }
        this.runMergeReintegrate(sVNURL, null, sVNRevision, file, bl2);
    }

    public void doGetLogMergedMergeInfo(File file, SVNRevision sVNRevision, SVNURL sVNURL, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        this.getLogMergedMergeInfoImpl(file, null, sVNRevision, sVNURL, null, sVNRevision2, bl2, stringArray, iSVNLogEntryHandler);
    }

    public void doGetLogMergedMergeInfo(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        this.getLogMergedMergeInfoImpl(null, sVNURL, sVNRevision, sVNURL2, null, sVNRevision2, bl2, stringArray, iSVNLogEntryHandler);
    }

    public void doGetLogMergedMergeInfo(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        this.getLogMergedMergeInfoImpl(file, null, sVNRevision, null, file2, sVNRevision2, bl2, stringArray, iSVNLogEntryHandler);
    }

    public void doGetLogMergedMergeInfo(SVNURL sVNURL, SVNRevision sVNRevision, File file, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        this.getLogMergedMergeInfoImpl(null, sVNURL, sVNRevision, null, file, sVNRevision2, bl2, stringArray, iSVNLogEntryHandler);
    }

    public void doGetLogEligibleMergeInfo(File file, SVNRevision sVNRevision, SVNURL sVNURL, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        this.getLogEligibleMergeInfoImpl(file, null, sVNRevision, sVNURL, null, sVNRevision2, bl2, stringArray, iSVNLogEntryHandler);
    }

    public void doGetLogEligibleMergeInfo(SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        this.getLogEligibleMergeInfoImpl(null, sVNURL, sVNRevision, sVNURL2, null, sVNRevision2, bl2, stringArray, iSVNLogEntryHandler);
    }

    public void doGetLogEligibleMergeInfo(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        this.getLogEligibleMergeInfoImpl(file, null, sVNRevision, null, file2, sVNRevision2, bl2, stringArray, iSVNLogEntryHandler);
    }

    public void doGetLogEligibleMergeInfo(SVNURL sVNURL, SVNRevision sVNRevision, File file, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        this.getLogEligibleMergeInfoImpl(null, sVNURL, sVNRevision, null, file, sVNRevision2, bl2, stringArray, iSVNLogEntryHandler);
    }

    public Map doGetMergedMergeInfo(File file, SVNRevision sVNRevision) {
        SVNURL[] sVNURLArray = new SVNURL[1];
        TreeMap<SVNURL, SVNMergeRangeList> treeMap = this.getMergeInfo(file, sVNRevision, sVNURLArray);
        SVNURL sVNURL = sVNURLArray[0];
        if (treeMap != null) {
            TreeMap<SVNURL, SVNMergeRangeList> treeMap2 = new TreeMap<SVNURL, SVNMergeRangeList>(new SVNDiffClient16$1(this));
            for (String string : treeMap.keySet()) {
                SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)treeMap.get(string);
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                SVNURL sVNURL2 = sVNURL.appendPath(string, false);
                treeMap2.put(sVNURL2, sVNMergeRangeList);
            }
            treeMap = treeMap2;
        }
        return treeMap;
    }

    public Map doGetMergedMergeInfo(SVNURL sVNURL, SVNRevision sVNRevision) {
        SVNURL[] sVNURLArray = new SVNURL[1];
        TreeMap<SVNURL, SVNMergeRangeList> treeMap = this.getMergeInfo(sVNURL, sVNRevision, sVNURLArray);
        SVNURL sVNURL2 = sVNURLArray[0];
        if (treeMap != null) {
            TreeMap<SVNURL, SVNMergeRangeList> treeMap2 = new TreeMap<SVNURL, SVNMergeRangeList>(new SVNDiffClient16$2(this));
            for (String string : treeMap.keySet()) {
                SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)treeMap.get(string);
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                SVNURL sVNURL3 = sVNURL2.appendPath(string, false);
                treeMap2.put(sVNURL3, sVNMergeRangeList);
            }
            treeMap = treeMap2;
        }
        return treeMap;
    }

    public Collection doSuggestMergeSources(File file, SVNRevision sVNRevision) {
        Object object;
        LinkedList<SVNURL> linkedList = new LinkedList<SVNURL>();
        SVNURL sVNURL = this.getReposRoot(file, null, sVNRevision, null, null);
        SVNLocationEntry sVNLocationEntry = this.getCopySource(file, null, sVNRevision);
        String string = sVNLocationEntry.getPath();
        SVNURL sVNURL2 = null;
        if (string != null) {
            object = string.startsWith("/") ? string.substring(1) : string;
            sVNURL2 = sVNURL.appendPath((String)object, false);
            linkedList.add(sVNURL2);
        }
        if ((object = this.doGetMergedMergeInfo(file, sVNRevision)) != null) {
            for (SVNURL sVNURL3 : object.keySet()) {
                if (sVNURL2 != null && sVNURL2.equals(sVNURL3)) continue;
                linkedList.add(sVNURL3);
            }
        }
        return linkedList;
    }

    public Collection doSuggestMergeSources(SVNURL sVNURL, SVNRevision sVNRevision) {
        Object object;
        LinkedList<SVNURL> linkedList = new LinkedList<SVNURL>();
        SVNURL sVNURL2 = this.getReposRoot(null, sVNURL, sVNRevision, null, null);
        SVNLocationEntry sVNLocationEntry = this.getCopySource(null, sVNURL, sVNRevision);
        String string = sVNLocationEntry.getPath();
        SVNURL sVNURL3 = null;
        if (string != null) {
            object = string.startsWith("/") ? string.substring(1) : string;
            sVNURL3 = sVNURL2.appendPath((String)object, false);
            linkedList.add(sVNURL3);
        }
        if ((object = this.doGetMergedMergeInfo(sVNURL, sVNRevision)) != null) {
            for (SVNURL sVNURL4 : object.keySet()) {
                if (sVNURL3 != null && sVNURL3.equals(sVNURL4)) continue;
                linkedList.add(sVNURL4);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffURLWC(SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, File file, SVNRevision sVNRevision3, boolean bl2, SVNDepth sVNDepth, boolean bl3, OutputStream outputStream, Collection collection) {
        try (SVNWCAccess sVNWCAccess = this.createWCAccess();){
            SVNBasicDelegate$SVNRepositoryLocation[] sVNBasicDelegate$SVNRepositoryLocationArray;
            Object object;
            SVNAdminAreaInfo sVNAdminAreaInfo = sVNWCAccess.openAnchor(file, false, SVNDepth.recurseFromDepth(sVNDepth) ? -1 : 0);
            File file2 = sVNAdminAreaInfo.getAnchor().getRoot();
            String string = "".equals(sVNAdminAreaInfo.getTargetName()) ? null : sVNAdminAreaInfo.getTargetName();
            SVNEntry sVNEntry = sVNAdminAreaInfo.getAnchor().getVersionedEntry("", false);
            if (sVNEntry.getURL() == null) {
                object = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)file2);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            object = sVNEntry.getSVNURL();
            if (sVNRevision2.isValid()) {
                sVNBasicDelegate$SVNRepositoryLocationArray = this.getLocations(sVNURL, null, null, sVNRevision2, sVNRevision, SVNRevision.UNDEFINED);
                sVNURL = sVNBasicDelegate$SVNRepositoryLocationArray[0].getURL();
                String string2 = SVNPathUtil.append(((SVNURL)object).toString(), string == null ? "" : string);
                this.getDiffGenerator().init(sVNURL.toString(), string2);
            }
            sVNBasicDelegate$SVNRepositoryLocationArray = this.createRepository((SVNURL)object, null, null, true);
            long l2 = this.getRevisionNumber(sVNRevision, (SVNRepository)sVNBasicDelegate$SVNRepositoryLocationArray, null);
            SVNDiffCallback sVNDiffCallback = new SVNDiffCallback(sVNAdminAreaInfo.getAnchor(), this.getDiffGenerator(), bl2 ? -1L : l2, bl2 ? l2 : -1L, outputStream);
            SVNDiffEditor sVNDiffEditor = new SVNDiffEditor(sVNWCAccess, sVNAdminAreaInfo, sVNDiffCallback, bl3, bl2, sVNRevision3 == SVNRevision.BASE || sVNRevision3 == SVNRevision.COMMITTED, sVNDepth, collection);
            boolean bl4 = sVNBasicDelegate$SVNRepositoryLocationArray.hasCapability(SVNCapability.DEPTH);
            SVNReporter sVNReporter = new SVNReporter(sVNAdminAreaInfo, sVNAdminAreaInfo.getAnchor().getFile(sVNAdminAreaInfo.getTargetName()), false, !bl4, sVNDepth, false, false, true, this.getDebugLog());
            long l3 = this.getRevisionNumber(sVNRevision3, (SVNRepository)sVNBasicDelegate$SVNRepositoryLocationArray, file);
            try {
                sVNBasicDelegate$SVNRepositoryLocationArray.diff(sVNURL, l2, l3, string, !bl3, sVNDepth, true, (ISVNReporterBaton)sVNReporter, SVNCancellableEditor.newInstance(sVNDiffEditor, this, this.getDebugLog()));
            }
            finally {
                sVNDiffEditor.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffURLWC(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, File file2, SVNRevision sVNRevision3, boolean bl2, SVNDepth sVNDepth, boolean bl3, OutputStream outputStream, Collection collection) {
        try (SVNWCAccess sVNWCAccess = this.createWCAccess();){
            Object object;
            Object object2;
            int n2 = this.getAdminDepth(sVNDepth);
            SVNAdminAreaInfo sVNAdminAreaInfo = sVNWCAccess.openAnchor(file2, false, n2);
            File file3 = sVNAdminAreaInfo.getAnchor().getRoot();
            String string = "".equals(sVNAdminAreaInfo.getTargetName()) ? null : sVNAdminAreaInfo.getTargetName();
            SVNEntry sVNEntry = sVNAdminAreaInfo.getAnchor().getVersionedEntry("", false);
            if (sVNEntry.getURL() == null) {
                object2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)file3);
                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
            }
            SVNURL sVNURL = sVNEntry.getSVNURL();
            if (sVNRevision2.isValid()) {
                object = this.getLocations(null, file, null, sVNRevision2, sVNRevision, SVNRevision.UNDEFINED);
                object2 = object[0].getURL();
                String string2 = SVNPathUtil.append(sVNURL.toString(), string == null ? "" : string);
                if (!bl2) {
                    this.getDiffGenerator().init(((SVNURL)object2).toString(), string2);
                } else {
                    this.getDiffGenerator().init(string2, ((SVNURL)object2).toString());
                }
            } else {
                object2 = this.getURL(file);
            }
            object = this.createRepository(sVNURL, null, null, true);
            long l2 = this.getRevisionNumber(sVNRevision, (SVNRepository)object, file);
            SVNDiffCallback sVNDiffCallback = new SVNDiffCallback(sVNAdminAreaInfo.getAnchor(), this.getDiffGenerator(), bl2 ? -1L : l2, bl2 ? l2 : -1L, outputStream);
            SVNDiffEditor sVNDiffEditor = new SVNDiffEditor(sVNWCAccess, sVNAdminAreaInfo, sVNDiffCallback, bl3, bl2, sVNRevision3 == SVNRevision.BASE || sVNRevision3 == SVNRevision.COMMITTED, sVNDepth, collection);
            ISVNEditor iSVNEditor = SVNAmbientDepthFilterEditor.wrap(sVNDiffEditor, sVNAdminAreaInfo, false);
            boolean bl4 = ((SVNRepository)object).hasCapability(SVNCapability.DEPTH);
            SVNReporter sVNReporter = new SVNReporter(sVNAdminAreaInfo, sVNAdminAreaInfo.getAnchor().getFile(sVNAdminAreaInfo.getTargetName()), false, !bl4, sVNDepth, false, false, true, this.getDebugLog());
            long l3 = this.getRevisionNumber(sVNRevision3, (SVNRepository)object, file2);
            try {
                ((SVNRepository)object).diff((SVNURL)object2, l2, l3, string, !bl3, sVNDepth, true, (ISVNReporterBaton)sVNReporter, SVNCancellableEditor.newInstance(iSVNEditor, this, this.getDebugLog()));
            }
            finally {
                sVNDiffEditor.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffWCWC(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, OutputStream outputStream, Collection collection) {
        Object object;
        if (!file.equals(file2) || sVNRevision != SVNRevision.BASE || sVNRevision2 != SVNRevision.WORKING) {
            object = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Only diffs between a path's text-base and its working files are supported at this time (-rBASE:WORKING)");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = this.createWCAccess();
        try {
            int n2 = this.getAdminDepth(sVNDepth);
            SVNAdminAreaInfo sVNAdminAreaInfo = ((SVNWCAccess)object).openAnchor(file, false, n2);
            ((SVNWCAccess)object).getVersionedEntry(file, false);
            long l2 = this.getRevisionNumber(sVNRevision, null, file);
            SVNDiffCallback sVNDiffCallback = new SVNDiffCallback(sVNAdminAreaInfo.getAnchor(), this.getDiffGenerator(), l2, -1L, outputStream);
            SVNDiffEditor sVNDiffEditor = new SVNDiffEditor((SVNWCAccess)object, sVNAdminAreaInfo, sVNDiffCallback, bl2, false, false, sVNDepth, collection);
            try {
                sVNDiffEditor.closeEdit();
            }
            finally {
                sVNDiffEditor.cleanup();
            }
        }
        finally {
            ((SVNWCAccess)object).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffURLURL(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNURL sVNURL2, File file2, SVNRevision sVNRevision2, SVNRevision sVNRevision3, SVNDepth sVNDepth, boolean bl2, OutputStream outputStream) {
        Object object;
        Object object2;
        File file3 = null;
        if (file != null) {
            file3 = file;
        }
        if (file2 != null) {
            file3 = file2;
        }
        if (sVNRevision3.isValid()) {
            object2 = this.getLocations(sVNURL2, file2, null, sVNRevision3, sVNRevision, sVNRevision2);
            sVNURL = object2[0].getURL();
            sVNURL2 = object2[1].getURL();
            this.getDiffGenerator().init(sVNURL.toString(), sVNURL2.toString());
        } else {
            sVNURL = sVNURL == null ? this.getURL(file) : sVNURL;
            sVNURL2 = sVNURL2 == null ? this.getURL(file2) : sVNURL2;
        }
        object2 = this.createRepository(sVNURL, null, null, true);
        SVNRepository sVNRepository = this.createRepository(sVNURL2, null, null, false);
        long l2 = this.getRevisionNumber(sVNRevision, (SVNRepository)object2, file);
        long l3 = -1L;
        String string = null;
        SVNNodeKind sVNNodeKind = null;
        SVNNodeKind sVNNodeKind2 = null;
        try {
            l3 = this.getRevisionNumber(sVNRevision2, sVNRepository, file2);
            sVNNodeKind = ((SVNRepository)object2).checkPath("", l2);
            sVNNodeKind2 = sVNRepository.checkPath("", l3);
            if (sVNNodeKind == SVNNodeKind.NONE) {
                object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "''{0}'' was not found in the repository at revision {1}", sVNURL, l2);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            } else if (sVNNodeKind2 == SVNNodeKind.NONE) {
                object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "''{0}'' was not found in the repository at revision {1}", sVNURL2, l3);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
        }
        finally {
            sVNRepository.closeSession();
        }
        if (sVNNodeKind == SVNNodeKind.FILE || sVNNodeKind2 == SVNNodeKind.FILE) {
            string = SVNPathUtil.tail(sVNURL.getPath());
            if (file3 != null) {
                file3 = file3.getParentFile();
            }
            sVNURL = SVNURL.parseURIEncoded(SVNPathUtil.removeTail(sVNURL.toString()));
            object2 = this.createRepository(sVNURL, null, null, true);
        }
        sVNRepository = this.createRepository(sVNURL, null, null, false);
        object = null;
        try {
            SVNDiffCallback sVNDiffCallback = new SVNDiffCallback(null, this.getDiffGenerator(), l2, l3, outputStream);
            sVNDiffCallback.setBasePath(file3);
            object = new SVNRemoteDiffEditor(null, null, sVNDiffCallback, sVNRepository, l2, l3, false, null, this);
            ((SVNRemoteDiffEditor)object).setUseGlobalTmp(true);
            SVNDiffClient16$3 sVNDiffClient16$3 = new SVNDiffClient16$3(this, l2);
            ((SVNRepository)object2).diff(sVNURL2, l3, l2, string, !bl2, sVNDepth, true, (ISVNReporterBaton)sVNDiffClient16$3, SVNCancellableEditor.newInstance((ISVNEditor)object, this, this.getDebugLog()));
        }
        finally {
            if (object != null) {
                ((SVNRemoteDiffEditor)object).cleanup();
            }
            sVNRepository.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffURLURL(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNURL sVNURL2, File file2, SVNRevision sVNRevision2, SVNRevision sVNRevision3, SVNDepth sVNDepth, boolean bl2, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        Serializable serializable;
        Object object;
        File file3 = null;
        if (file != null) {
            file3 = file;
        }
        if (file2 != null) {
            file3 = file2;
        }
        if (sVNRevision3.isValid()) {
            object = this.getLocations(sVNURL2, file2, null, sVNRevision3, sVNRevision, sVNRevision2);
            sVNURL = object[0].getURL();
            sVNURL2 = object[1].getURL();
            this.getDiffGenerator().init(sVNURL.toString(), sVNURL2.toString());
        } else {
            sVNURL = sVNURL == null ? this.getURL(file) : sVNURL;
            sVNURL2 = sVNURL2 == null ? this.getURL(file2) : sVNURL2;
        }
        object = this.createRepository(sVNURL, null, null, true);
        SVNRepository sVNRepository = this.createRepository(sVNURL2, null, null, false);
        long l2 = this.getRevisionNumber(sVNRevision, (SVNRepository)object, file);
        long l3 = -1L;
        SVNNodeKind sVNNodeKind = null;
        SVNNodeKind sVNNodeKind2 = null;
        String string = null;
        try {
            l3 = this.getRevisionNumber(sVNRevision2, sVNRepository, file2);
            sVNNodeKind = ((SVNRepository)object).checkPath("", l2);
            sVNNodeKind2 = sVNRepository.checkPath("", l3);
            if (sVNNodeKind == SVNNodeKind.NONE) {
                serializable = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "''{0}'' was not found in the repository at revision {1}", sVNURL, l2);
                SVNErrorManager.error(serializable, SVNLogType.WC);
            } else if (sVNNodeKind2 == SVNNodeKind.NONE) {
                serializable = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "''{0}'' was not found in the repository at revision {1}", sVNURL2, l3);
                SVNErrorManager.error(serializable, SVNLogType.WC);
            }
            if (sVNNodeKind == SVNNodeKind.FILE || sVNNodeKind2 == SVNNodeKind.FILE) {
                string = SVNPathUtil.tail(sVNURL.getPath());
                if (file3 != null) {
                    file3 = file3.getParentFile();
                }
                sVNURL = SVNURL.parseURIEncoded(SVNPathUtil.removeTail(sVNURL.toString()));
                object = this.createRepository(sVNURL, null, null, true);
            }
        }
        finally {
            sVNRepository.closeSession();
        }
        sVNRepository = this.createRepository(sVNURL, null, null, false);
        serializable = this.getDiffGenerator().createTempDirectory();
        try {
            SVNDiffStatusEditor sVNDiffStatusEditor = new SVNDiffStatusEditor(file3, string, sVNRepository, l2, iSVNDiffStatusHandler);
            SVNDiffClient16$4 sVNDiffClient16$4 = new SVNDiffClient16$4(this, l2);
            ((SVNRepository)object).diff(sVNURL2, l3, l2, string, !bl2, sVNDepth, false, (ISVNReporterBaton)sVNDiffClient16$4, SVNCancellableEditor.newInstance(sVNDiffStatusEditor, this, this.getDebugLog()));
        }
        finally {
            if (serializable != null) {
                SVNFileUtil.deleteAll((File)serializable, true, null);
            }
            sVNRepository.closeSession();
        }
    }

    private int getAdminDepth(SVNDepth sVNDepth) {
        int n2 = -1;
        if (sVNDepth == SVNDepth.IMMEDIATES) {
            n2 = 1;
        } else if (sVNDepth == SVNDepth.EMPTY || sVNDepth == SVNDepth.FILES) {
            n2 = 0;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getLocationFromPathAndRevision(File file, SVNURL sVNURL, SVNRevision sVNRevision) {
        SVNWCAccess sVNWCAccess = null;
        SVNRepository sVNRepository = null;
        SVNAdminArea sVNAdminArea = null;
        try {
            if (file != null && (sVNRevision == SVNRevision.BASE || sVNRevision == SVNRevision.WORKING || sVNRevision == SVNRevision.COMMITTED || sVNRevision == SVNRevision.UNDEFINED)) {
                int n2 = this.getLevelsToLockFromDepth(SVNDepth.EMPTY);
                sVNWCAccess = this.createWCAccess();
                sVNWCAccess.probeOpen(file, false, n2);
            }
            long[] lArray = new long[]{-1L};
            sVNRepository = this.createRepository(sVNURL, file, sVNAdminArea, sVNRevision, sVNRevision, lArray);
            Object[] objectArray = new Object[]{sVNRepository.getLocation(), SVNRevision.create(lArray[0])};
            return objectArray;
        }
        finally {
            if (sVNWCAccess != null) {
                sVNWCAccess.close();
            }
            if (sVNRepository != null) {
                sVNRepository.closeSession();
            }
        }
    }

    private void getLogMergedMergeInfoImpl(File file, SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, File file2, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        Map map;
        SVNURL[] sVNURLArray = new SVNURL[1];
        Object[] objectArray = this.getLocationFromPathAndRevision(file2, sVNURL2, sVNRevision2);
        SVNURL sVNURL3 = (SVNURL)objectArray[0];
        SVNRevision sVNRevision3 = (SVNRevision)objectArray[1];
        Map map2 = map = file != null ? this.getMergeInfo(file, sVNRevision, sVNURLArray) : this.getMergeInfo(sVNURL, sVNRevision, sVNURLArray);
        if (map == null) {
            return;
        }
        Map map3 = this.getHistoryAsMergeInfo(sVNURL3, null, sVNRevision3, -1L, -1L, null, null);
        Map map4 = SVNMergeInfoUtil.intersectMergeInfo(map, map3, false);
        SVNMergeRangeList sVNMergeRangeList = new SVNMergeRangeList(new SVNMergeRange[0]);
        long l2 = -1L;
        String string = null;
        for (String string2 : map4.keySet()) {
            SVNMergeRangeList sVNMergeRangeList2 = (SVNMergeRangeList)map4.get(string2);
            SVNMergeRange[] sVNMergeRangeArray = sVNMergeRangeList2.getRanges();
            SVNMergeRange sVNMergeRange = sVNMergeRangeArray[sVNMergeRangeArray.length - 1];
            if (!SVNRevision.isValidRevisionNumber(l2) || sVNMergeRange.getEndRevision() > l2) {
                l2 = sVNMergeRange.getEndRevision();
                string = string2;
            }
            sVNMergeRangeList = sVNMergeRangeList.merge(sVNMergeRangeList2);
        }
        if (sVNMergeRangeList.isEmpty()) {
            return;
        }
        this.getLogsForMergeInfoRangeList(sVNURLArray[0], new String[]{string}, sVNMergeRangeList, bl2, stringArray, iSVNLogEntryHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLogEligibleMergeInfoImpl(File file, SVNURL sVNURL, SVNRevision sVNRevision, SVNURL sVNURL2, File file2, SVNRevision sVNRevision2, boolean bl2, String[] stringArray, ISVNLogEntryHandler iSVNLogEntryHandler) {
        SVNURL[] sVNURLArray = new SVNURL[1];
        Object[] objectArray = this.getLocationFromPathAndRevision(file2, sVNURL2, sVNRevision2);
        SVNURL sVNURL3 = (SVNURL)objectArray[0];
        SVNRevision sVNRevision3 = (SVNRevision)objectArray[1];
        Map map = file != null ? this.getMergeInfo(file, sVNRevision, sVNURLArray) : this.getMergeInfo(sVNURL, sVNRevision, sVNURLArray);
        Map map2 = this.getHistoryAsMergeInfo(sVNURL, file, sVNRevision, -1L, -1L, null, null);
        map = map == null ? map2 : SVNMergeInfoUtil.mergeMergeInfos(map, map2);
        SVNRepository sVNRepository = null;
        Map map3 = null;
        try {
            sVNRepository = this.createRepository(sVNURL3, null, null, true);
            map3 = this.getHistoryAsMergeInfo(sVNURL3, null, sVNRevision3, -1L, -1L, sVNRepository, null);
        }
        finally {
            if (sVNRepository != null) {
                sVNRepository.closeSession();
            }
        }
        Map map4 = SVNMergeInfoUtil.removeMergeInfo(map, map3, false);
        SVNMergeRangeList sVNMergeRangeList = new SVNMergeRangeList(new SVNMergeRange[0]);
        long l2 = -1L;
        String string = null;
        for (String string2 : map4.keySet()) {
            SVNMergeRangeList sVNMergeRangeList2 = (SVNMergeRangeList)map4.get(string2);
            SVNMergeRange[] sVNMergeRangeArray = sVNMergeRangeList2.getRanges();
            SVNMergeRange sVNMergeRange = sVNMergeRangeArray[sVNMergeRangeArray.length - 1];
            if (!SVNRevision.isValidRevisionNumber(l2) || sVNMergeRange.getEndRevision() > l2) {
                l2 = sVNMergeRange.getEndRevision();
                string = string2;
            }
            sVNMergeRangeList = sVNMergeRangeList.merge(sVNMergeRangeList2);
        }
        if (sVNMergeRangeList.isEmpty()) {
            return;
        }
        this.getLogsForMergeInfoRangeList(sVNURLArray[0], new String[]{string}, sVNMergeRangeList, bl2, stringArray, iSVNLogEntryHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyPatches(File file, File file2, boolean bl2, int n2, SVNAdminArea sVNAdminArea) {
        try (SVNPatchFileStream sVNPatchFileStream = SVNPatchFileStream.openReadOnly(file);){
            Object object;
            SVNPatch sVNPatch;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            do {
                this.checkCancelled();
                sVNPatch = SVNPatch.parseNextPatch(sVNPatchFileStream);
                if (sVNPatch == null) continue;
                object = SVNPatchTarget.applyPatch(sVNPatch, file2, n2, sVNAdminArea);
                arrayList.add(object);
            } while (sVNPatch != null);
            object = arrayList.iterator();
            while (object.hasNext()) {
                this.checkCancelled();
                SVNPatchTarget sVNPatchTarget = (SVNPatchTarget)object.next();
                if (!sVNPatchTarget.isSkipped()) {
                    sVNPatchTarget.installPatchedTarget(file2, bl2, sVNAdminArea);
                }
                sVNPatchTarget.sendPatchNotification(sVNAdminArea);
                sVNPatchTarget.getPatch().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPatch(File file, File file2, boolean bl2, int n2) {
        Object object;
        if (n2 < 0) {
            object = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "strip count must be positive");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.CLIENT);
        }
        object = this.createWCAccess();
        try {
            ((SVNWCAccess)object).setEventHandler(this);
            SVNAdminArea sVNAdminArea = ((SVNWCAccess)object).open(file2, true, -1);
            this.applyPatches(file, file2, bl2, n2, sVNAdminArea);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.CLIENT);
        }
        finally {
            ((SVNWCAccess)object).close();
        }
    }
}

