/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc16;

import java.io.File;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCopyDriver;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCopyClient16
extends SVNCopyDriver {
    protected ISVNCommitHandler myCommitHandler;
    protected ISVNCommitParameters myCommitParameters;
    protected ISVNExternalsHandler myExternalsHandler;

    public SVNCopyClient16(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
    }

    public SVNCopyClient16(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public void setCommitHandler(ISVNCommitHandler iSVNCommitHandler) {
        this.myCommitHandler = iSVNCommitHandler;
    }

    public ISVNCommitHandler getCommitHandler() {
        return this.myCommitHandler;
    }

    public void setCommitParameters(ISVNCommitParameters iSVNCommitParameters) {
        this.myCommitParameters = iSVNCommitParameters;
    }

    public ISVNCommitParameters getCommitParameters() {
        return this.myCommitParameters;
    }

    public void setExternalsHandler(ISVNExternalsHandler iSVNExternalsHandler) {
        this.myExternalsHandler = iSVNExternalsHandler;
    }

    public ISVNExternalsHandler getExternalsHandler() {
        if (this.myExternalsHandler == null) {
            return ISVNExternalsHandler.DEFAULT;
        }
        return this.myExternalsHandler;
    }

    public void doCopy(SVNCopySource[] sVNCopySourceArray, File file, boolean bl2, boolean bl3, boolean bl4) {
        this.doCopy(sVNCopySourceArray, file, bl2, bl3, bl4, false, null);
    }

    private void doCopy(SVNCopySource[] sVNCopySourceArray, File file, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Map map) {
        if (sVNCopySourceArray.length > 1 && bl4) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_MULTIPLE_SOURCES_DISALLOWED);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if ((sVNCopySourceArray = this.expandCopySources(sVNCopySourceArray)).length == 0) {
            return;
        }
        try {
            this.setupCopy(sVNCopySourceArray, new SVNPath(file.getAbsolutePath(), false, false), bl2, bl3, bl5, map, null, null, this.getCommitHandler(), this.getCommitParameters(), this.getExternalsHandler());
        }
        catch (SVNException sVNException) {
            SVNErrorCode sVNErrorCode = sVNException.getErrorMessage().getErrorCode();
            if (!(bl4 || sVNCopySourceArray.length != 1 || sVNErrorCode != SVNErrorCode.ENTRY_EXISTS && sVNErrorCode != SVNErrorCode.FS_ALREADY_EXISTS)) {
                SVNCopySource sVNCopySource = sVNCopySourceArray[0];
                String string = sVNCopySource.getName();
                if (sVNCopySource.isURL()) {
                    string = SVNEncodingUtil.uriDecode(string);
                }
                this.setupCopy(sVNCopySourceArray, new SVNPath(new File(file, string).getAbsolutePath(), false, false), bl2, bl3, bl5, map, null, null, this.getCommitHandler(), this.getCommitParameters(), this.getExternalsHandler());
                return;
            }
            throw sVNException;
        }
    }

    public SVNCommitInfo doCopy(SVNCopySource[] sVNCopySourceArray, SVNURL sVNURL, boolean bl2, boolean bl3, boolean bl4, String string, SVNProperties sVNProperties) {
        return this.doCopy(sVNCopySourceArray, sVNURL, bl2, bl3, bl4, false, null, string, sVNProperties);
    }

    public SVNCommitInfo doCopy(SVNCopySource[] sVNCopySourceArray, SVNURL sVNURL, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Map map, String string, SVNProperties sVNProperties) {
        if (sVNCopySourceArray.length > 1 && bl4) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_MULTIPLE_SOURCES_DISALLOWED);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if ((sVNCopySourceArray = this.expandCopySources(sVNCopySourceArray)).length == 0) {
            return SVNCommitInfo.NULL;
        }
        try {
            return this.setupCopy(sVNCopySourceArray, new SVNPath(sVNURL.toString(), false, false), bl2, bl3, bl5, map, string, sVNProperties, this.getCommitHandler(), this.getCommitParameters(), this.getExternalsHandler());
        }
        catch (SVNException sVNException) {
            SVNErrorCode sVNErrorCode = sVNException.getErrorMessage().getErrorCode();
            if (!(bl4 || sVNCopySourceArray.length != 1 || sVNErrorCode != SVNErrorCode.ENTRY_EXISTS && sVNErrorCode != SVNErrorCode.FS_ALREADY_EXISTS)) {
                SVNCopySource sVNCopySource = sVNCopySourceArray[0];
                String string2 = sVNCopySource.getName();
                if (!sVNCopySource.isURL()) {
                    string2 = SVNEncodingUtil.uriEncode(string2);
                }
                return this.setupCopy(sVNCopySourceArray, new SVNPath(sVNURL.appendPath(string2, true).toString(), false, false), bl2, bl3, bl5, map, string, sVNProperties, this.getCommitHandler(), this.getCommitParameters(), this.getExternalsHandler());
            }
            throw sVNException;
        }
    }

    public void doCopy(File file) {
        this.copyDisjointWCToWC(file);
    }
}

