/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc16;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCommitMediator;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCommitter;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNImportMediator;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate;
import org.tmatesoft.svn.core.internal.wc16.SVNCommitClient16$1;
import org.tmatesoft.svn.core.internal.wc16.SVNCommitClient16$2;
import org.tmatesoft.svn.core.internal.wc16.SVNCommitClient16$3;
import org.tmatesoft.svn.core.internal.wc16.SVNCommitClient16$4;
import org.tmatesoft.svn.core.internal.wc16.SVNCommitClient16$5;
import org.tmatesoft.svn.core.internal.wc16.SVNStatusClient16;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNFileFilter;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNCommitPacket;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc2.SvnGetProperties;
import org.tmatesoft.svn.core.wc2.SvnInheritedProperties;
import org.tmatesoft.svn.core.wc2.SvnOperation;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCommitClient16
extends SVNBasicDelegate {
    private ISVNCommitHandler myCommitHandler;
    private ISVNCommitParameters myCommitParameters;

    public SVNCommitClient16(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
    }

    public SVNCommitClient16(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public void setCommitHander(ISVNCommitHandler iSVNCommitHandler) {
        this.myCommitHandler = iSVNCommitHandler;
    }

    public void setCommitHandler(ISVNCommitHandler iSVNCommitHandler) {
        this.myCommitHandler = iSVNCommitHandler;
    }

    public ISVNCommitHandler getCommitHandler() {
        return this.myCommitHandler;
    }

    public void setCommitParameters(ISVNCommitParameters iSVNCommitParameters) {
        this.myCommitParameters = iSVNCommitParameters;
    }

    public ISVNCommitParameters getCommitParameters() {
        return this.myCommitParameters;
    }

    public SVNCommitInfo doDelete(SVNURL[] sVNURLArray, String string) {
        return this.doDelete(sVNURLArray, string, null);
    }

    public SVNCommitInfo doDelete(SVNURL[] sVNURLArray, String string, SVNProperties sVNProperties) {
        Object object;
        Object object4;
        SVNCommitItem[] sVNCommitItemArray;
        if (sVNURLArray == null || sVNURLArray.length == 0) {
            return SVNCommitInfo.NULL;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        SVNURL sVNURL = SVNURLUtil.condenceURLs(sVNURLArray, arrayList, true);
        if (sVNURL == null) {
            sVNCommitItemArray = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "Can not compute common root URL for specified URLs");
            SVNErrorManager.error((SVNErrorMessage)sVNCommitItemArray, SVNLogType.DEFAULT);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(SVNPathUtil.tail(sVNURL.getURIEncodedPath()));
            sVNURL = sVNURL.removePathTail();
        }
        sVNCommitItemArray = new SVNCommitItem[arrayList.size()];
        for (int i2 = 0; i2 < sVNCommitItemArray.length; ++i2) {
            object4 = (String)arrayList.get(i2);
            sVNCommitItemArray[i2] = new SVNCommitItem(null, sVNURL.appendPath((String)object4, true), null, SVNNodeKind.NONE, SVNRevision.UNDEFINED, SVNRevision.UNDEFINED, false, true, false, false, false, false);
        }
        string = this.getCommitHandler().getCommitMessage(string, sVNCommitItemArray);
        if (string == null) {
            return SVNCommitInfo.NULL;
        }
        string = SVNCommitUtil.validateCommitMessage(string);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String object32 : arrayList) {
            arrayList2.add(SVNEncodingUtil.uriDecode(object32));
        }
        arrayList = arrayList2;
        object4 = this.createRepository(sVNURL, null, null, true);
        for (String string2 : arrayList) {
            object = ((SVNRepository)object4).checkPath(string2, -1L);
            if (object != SVNNodeKind.NONE) continue;
            SVNURL sVNURL2 = sVNURL.appendPath(string2, false);
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "URL ''{0}'' does not exist", (Object)sVNURL2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        string = SVNCommitUtil.validateCommitMessage(string);
        SVNPropertiesManager.validateRevisionProperties(sVNProperties);
        ISVNEditor iSVNEditor = ((SVNRepository)object4).getCommitEditor(string, null, false, sVNProperties, null);
        SVNCommitClient16$1 sVNCommitClient16$1 = new SVNCommitClient16$1(this);
        try {
            SVNCommitUtil.driveCommitEditor(sVNCommitClient16$1, arrayList, iSVNEditor, -1L);
            object = iSVNEditor.closeEdit();
        }
        catch (SVNException sVNException) {
            try {
                iSVNEditor.abortEdit();
            }
            catch (SVNException sVNException2) {
                // empty catch block
            }
            throw sVNException;
        }
        if (object != null && ((SVNCommitInfo)object).getNewRevision() >= 0L) {
            this.dispatchEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, ((SVNCommitInfo)object).getNewRevision(), SVNEventAction.COMMIT_COMPLETED, null, null, null), -1.0);
        }
        return object != null ? object : SVNCommitInfo.NULL;
    }

    public SVNCommitInfo doMkDir(SVNURL[] sVNURLArray, String string) {
        return this.doMkDir(sVNURLArray, string, null, false);
    }

    public SVNCommitInfo doMkDir(SVNURL[] sVNURLArray, String string, SVNProperties sVNProperties, boolean bl2) {
        SVNCommitInfo sVNCommitInfo;
        Object object3;
        Object object22;
        SVNCommitItem[] sVNCommitItemArray;
        ArrayList<Object> arrayList;
        AbstractCollection abstractCollection;
        if (bl2) {
            abstractCollection = new LinkedList();
            for (int i2 = 0; i2 < sVNURLArray.length; ++i2) {
                arrayList = sVNURLArray[i2];
                this.addURLParents((List)((Object)abstractCollection), (SVNURL)((Object)arrayList));
            }
            sVNURLArray = abstractCollection.toArray(new SVNURL[abstractCollection.size()]);
        }
        if (sVNURLArray == null || sVNURLArray.length == 0) {
            return SVNCommitInfo.NULL;
        }
        abstractCollection = new SVNHashSet();
        SVNURL sVNURL = SVNURLUtil.condenceURLs(sVNURLArray, abstractCollection, false);
        if (sVNURL == null) {
            arrayList = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "Can not compute common root URL for specified URLs");
            SVNErrorManager.error((SVNErrorMessage)((Object)arrayList), SVNLogType.DEFAULT);
        }
        if (abstractCollection.isEmpty()) {
            abstractCollection.add(SVNPathUtil.tail(sVNURL.getURIEncodedPath()));
            sVNURL = sVNURL.removePathTail();
        }
        if (abstractCollection.contains("")) {
            arrayList = new ArrayList<Object>();
            sVNCommitItemArray = SVNPathUtil.tail(sVNURL.getURIEncodedPath());
            sVNURL = sVNURL.removePathTail();
            for (Object object22 : abstractCollection) {
                if ("".equals(object22)) {
                    arrayList.add(sVNCommitItemArray);
                    continue;
                }
                arrayList.add(SVNPathUtil.append((String)sVNCommitItemArray, (String)object22));
            }
            abstractCollection = arrayList;
        }
        arrayList = new ArrayList(abstractCollection);
        Collections.sort(arrayList, SVNPathUtil.PATH_COMPARATOR);
        sVNCommitItemArray = new SVNCommitItem[arrayList.size()];
        for (int i3 = 0; i3 < sVNCommitItemArray.length; ++i3) {
            object22 = (String)arrayList.get(i3);
            sVNCommitItemArray[i3] = new SVNCommitItem(null, sVNURL.appendPath((String)object22, true), null, SVNNodeKind.DIR, SVNRevision.UNDEFINED, SVNRevision.UNDEFINED, true, false, false, false, false, false);
        }
        string = this.getCommitHandler().getCommitMessage(string, sVNCommitItemArray);
        if (string == null) {
            return SVNCommitInfo.NULL;
        }
        string = SVNCommitClient16.validateCommitMessage(string);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Object object3 : arrayList) {
            arrayList2.add(SVNEncodingUtil.uriDecode((String)object3));
        }
        abstractCollection = arrayList2;
        object22 = this.createRepository(sVNURL, null, null, true);
        string = SVNCommitUtil.validateCommitMessage(string);
        SVNPropertiesManager.validateRevisionProperties(sVNProperties);
        object3 = ((SVNRepository)object22).getCommitEditor(string, null, false, sVNProperties, null);
        SVNCommitClient16$2 sVNCommitClient16$2 = new SVNCommitClient16$2(this);
        try {
            SVNCommitUtil.driveCommitEditor(sVNCommitClient16$2, abstractCollection, (ISVNEditor)object3, -1L);
            sVNCommitInfo = object3.closeEdit();
        }
        catch (SVNException sVNException) {
            try {
                object3.abortEdit();
            }
            catch (SVNException sVNException2) {
                // empty catch block
            }
            throw sVNException;
        }
        if (sVNCommitInfo != null && sVNCommitInfo.getNewRevision() >= 0L) {
            this.dispatchEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, sVNCommitInfo.getNewRevision(), SVNEventAction.COMMIT_COMPLETED, null, null, null), -1.0);
        }
        return sVNCommitInfo != null ? sVNCommitInfo : SVNCommitInfo.NULL;
    }

    public SVNCommitInfo doImport(File file, SVNURL sVNURL, String string, boolean bl2) {
        return this.doImport(file, sVNURL, string, null, true, false, SVNDepth.fromRecurse(bl2));
    }

    public SVNCommitInfo doImport(File file, SVNURL sVNURL, String string, boolean bl2, boolean bl3) {
        return this.doImport(file, sVNURL, string, null, bl2, false, SVNDepth.fromRecurse(bl3));
    }

    public SVNCommitInfo doImport(File file, SVNURL sVNURL, String string, SVNProperties sVNProperties, boolean bl2, boolean bl3, SVNDepth sVNDepth) {
        return this.doImport(file, sVNURL, string, sVNProperties, bl2, bl3, sVNDepth, true);
    }

    public SVNCommitInfo doImport(File file, SVNURL sVNURL, String string, SVNProperties sVNProperties, boolean bl2, boolean bl3, SVNDepth sVNDepth, boolean bl4) {
        return this.doImport(file, sVNURL, string, sVNProperties, bl2, bl3, sVNDepth, bl4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNCommitInfo doImport(File file, SVNURL sVNURL, String string, SVNProperties sVNProperties, boolean bl2, boolean bl3, SVNDepth sVNDepth, boolean bl4, ISVNFileFilter iSVNFileFilter) {
        Map map;
        SVNCommitItem[] sVNCommitItemArray;
        Serializable serializable;
        SVNRepository sVNRepository = null;
        SVNFileType sVNFileType = SVNFileType.getType(file);
        if (sVNFileType == SVNFileType.NONE) {
            serializable = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Path ''{0}'' does not exist", (Object)file);
            SVNErrorManager.error(serializable, SVNLogType.WC);
        }
        serializable = new ArrayList();
        SVNURL sVNURL2 = sVNURL;
        sVNRepository = this.createRepository(sVNURL2, null, null, true);
        SVNURL sVNURL3 = sVNRepository.getRepositoryRoot(true);
        while (!sVNURL3.equals(sVNURL2) && sVNRepository.checkPath("", -1L) == SVNNodeKind.NONE) {
            serializable.add(SVNPathUtil.tail(sVNURL2.getPath()));
            sVNURL2 = sVNURL2.removePathTail();
            sVNRepository = this.createRepository(sVNURL2, null, null, true);
        }
        if (serializable.isEmpty() && (sVNFileType == SVNFileType.FILE || sVNFileType == SVNFileType.SYMLINK)) {
            sVNCommitItemArray = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Path ''{0}'' already exists", (Object)sVNURL);
            SVNErrorManager.error((SVNErrorMessage)sVNCommitItemArray, SVNLogType.WC);
        }
        if (serializable.contains(SVNFileUtil.getAdminDirectoryName())) {
            sVNCommitItemArray = SVNErrorMessage.create(SVNErrorCode.CL_ADM_DIR_RESERVED, "''{0}'' is a reserved name and cannot be imported", (Object)SVNFileUtil.getAdminDirectoryName());
            SVNErrorManager.error((SVNErrorMessage)sVNCommitItemArray, SVNLogType.WC);
        }
        sVNCommitItemArray = new SVNCommitItem[]{new SVNCommitItem(file, null, null, SVNNodeKind.NONE, SVNRevision.UNDEFINED, SVNRevision.UNDEFINED, true, false, false, false, false, false)};
        sVNCommitItemArray[0].setPath(file.getName());
        string = this.getCommitHandler().getCommitMessage(string, sVNCommitItemArray);
        if (string == null) {
            return SVNCommitInfo.NULL;
        }
        string = SVNCommitUtil.validateCommitMessage(string);
        SVNPropertiesManager.validateRevisionProperties(sVNProperties);
        if (bl4) {
            map = this.getVersionedAutoProperties(sVNURL, sVNURL3);
            sVNRepository.setLocation(sVNURL2, false);
        } else {
            map = null;
        }
        ISVNEditor iSVNEditor = sVNRepository.getCommitEditor(string, null, false, sVNProperties, new SVNImportMediator());
        String string2 = "";
        if (sVNFileType != SVNFileType.DIRECTORY) {
            string2 = (String)serializable.remove(0);
            for (int i2 = 0; i2 < serializable.size(); ++i2) {
                String string3 = (String)serializable.get(i2);
                string2 = string3 + "/" + string2;
            }
        }
        Collection collection = bl2 ? SVNStatusEditor.getGlobalIgnores(this.getOptions()) : null;
        this.checkCancelled();
        boolean bl5 = false;
        SVNCommitInfo sVNCommitInfo = null;
        try {
            Object object;
            iSVNEditor.openRoot(-1L);
            String string4 = null;
            for (int i3 = serializable.size() - 1; i3 >= 0; --i3) {
                string4 = string4 == null ? (String)serializable.get(i3) : SVNPathUtil.append(string4, (String)serializable.get(i3));
                iSVNEditor.addDir(string4, null, -1L);
            }
            bl5 = serializable.size() > 0;
            SVNDeltaGenerator sVNDeltaGenerator = new SVNDeltaGenerator();
            if (sVNFileType == SVNFileType.DIRECTORY) {
                bl5 |= this.importDir(sVNDeltaGenerator, file, string4, bl2, bl3, sVNDepth, map, iSVNFileFilter, iSVNEditor);
            } else if (sVNFileType == SVNFileType.FILE || sVNFileType == SVNFileType.SYMLINK) {
                if (!bl2 || !SVNStatusEditor.isIgnored(collection, file, "/" + file.getName())) {
                    bl5 |= this.importFile(sVNDeltaGenerator, file, sVNFileType, string2, map, iSVNEditor);
                }
            } else if (sVNFileType == SVNFileType.NONE || sVNFileType == SVNFileType.UNKNOWN) {
                object = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "''{0}'' does not exist", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            if (!bl5) {
                try {
                    iSVNEditor.abortEdit();
                }
                catch (SVNException sVNException) {
                    // empty catch block
                }
                object = SVNCommitInfo.NULL;
                return object;
            }
            for (int i4 = 0; i4 < serializable.size(); ++i4) {
                iSVNEditor.closeDir();
            }
            sVNCommitInfo = iSVNEditor.closeEdit();
        }
        finally {
            if (!bl5 || sVNCommitInfo == null) {
                try {
                    iSVNEditor.abortEdit();
                }
                catch (SVNException sVNException) {}
            }
        }
        if (sVNCommitInfo != null && sVNCommitInfo.getNewRevision() >= 0L) {
            this.dispatchEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, sVNCommitInfo.getNewRevision(), SVNEventAction.COMMIT_COMPLETED, null, null, null), -1.0);
        }
        return sVNCommitInfo != null ? sVNCommitInfo : SVNCommitInfo.NULL;
    }

    public SVNCommitInfo doCommit(File[] fileArray, boolean bl2, String string, boolean bl3, boolean bl4) {
        return this.doCommit(fileArray, bl2, string, null, null, false, bl3, SVNDepth.getInfinityOrEmptyDepth(bl4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNCommitInfo doCommit(File[] fileArray, boolean bl2, String string, SVNProperties sVNProperties, String[] stringArray, boolean bl3, boolean bl4, SVNDepth sVNDepth) {
        SVNCommitPacket sVNCommitPacket = this.doCollectCommitItems(fileArray, bl2, bl4, sVNDepth, stringArray);
        try {
            sVNCommitPacket = sVNCommitPacket.removeSkippedItems();
            SVNCommitInfo sVNCommitInfo = this.doCommit(sVNCommitPacket, bl2, bl3, string, sVNProperties);
            return sVNCommitInfo;
        }
        finally {
            if (sVNCommitPacket != null) {
                sVNCommitPacket.dispose();
            }
        }
    }

    public SVNCommitInfo doCommit(SVNCommitPacket sVNCommitPacket, boolean bl2, String string) {
        return this.doCommit(sVNCommitPacket, bl2, false, string, null);
    }

    public SVNCommitInfo doCommit(SVNCommitPacket sVNCommitPacket, boolean bl2, boolean bl3, String string, SVNProperties sVNProperties) {
        SVNCommitInfo[] sVNCommitInfoArray = this.doCommit(new SVNCommitPacket[]{sVNCommitPacket}, bl2, bl3, string, sVNProperties);
        if (sVNCommitInfoArray != null && sVNCommitInfoArray.length > 0) {
            if (sVNCommitInfoArray[0].getErrorMessage() != null && sVNCommitInfoArray[0].getErrorMessage().getErrorCode() != SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED) {
                SVNErrorManager.error(sVNCommitInfoArray[0].getErrorMessage(), SVNLogType.DEFAULT);
            }
            return sVNCommitInfoArray[0];
        }
        return SVNCommitInfo.NULL;
    }

    public SVNCommitInfo[] doCommit(SVNCommitPacket[] sVNCommitPacketArray, boolean bl2, String string) {
        return this.doCommit(sVNCommitPacketArray, bl2, false, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNCommitInfo[] doCommit(SVNCommitPacket[] sVNCommitPacketArray, boolean bl2, boolean bl3, String string, SVNProperties sVNProperties) {
        if (sVNCommitPacketArray == null || sVNCommitPacketArray.length == 0) {
            return new SVNCommitInfo[0];
        }
        Collection collection = null;
        SVNCommitInfo sVNCommitInfo = null;
        ISVNEditor iSVNEditor = null;
        ArrayList<SVNCommitInfo> arrayList = new ArrayList<SVNCommitInfo>();
        boolean bl4 = false;
        for (int i2 = 0; i2 < sVNCommitPacketArray.length; ++i2) {
            Object object;
            SVNCommitPacket sVNCommitPacket = sVNCommitPacketArray[i2].removeSkippedItems();
            if (sVNCommitPacket.getCommitItems().length == 0) continue;
            try {
                SVNCommitItem sVNCommitItem;
                string = this.getCommitHandler().getCommitMessage(string, sVNCommitPacket.getCommitItems());
                if (string == null) {
                    arrayList.add(SVNCommitInfo.NULL);
                    continue;
                }
                string = SVNCommitUtil.validateCommitMessage(string);
                Iterator iterator = new TreeMap();
                object = SVNCommitUtil.translateCommitables(sVNCommitPacket.getCommitItems(), (Map)((Object)iterator));
                Map map = SVNCommitUtil.translateLockTokens(sVNCommitPacket.getLockTokens(), ((SVNURL)object).toString());
                Object object2 = sVNCommitPacket.getCommitItems()[0];
                SVNRepository sVNRepository = this.createRepository((SVNURL)object, ((SVNCommitItem)object2).getFile(), ((SVNCommitItem)object2).getWCAccess(), true);
                SVNCommitMediator sVNCommitMediator = new SVNCommitMediator((Map)((Object)iterator));
                collection = sVNCommitMediator.getTmpFiles();
                SVNURL sVNURL = sVNRepository.getRepositoryRoot(true);
                String string2 = sVNURL.getPath();
                SVNPropertiesManager.validateRevisionProperties(sVNProperties);
                iSVNEditor = sVNRepository.getCommitEditor(string, map, bl2, sVNProperties, sVNCommitMediator);
                for (int i3 = 0; i3 < sVNCommitPacket.getCommitItems().length; ++i3) {
                    sVNCommitPacket.getCommitItems()[i3].getWCAccess().setEventHandler(this.getEventDispatcher());
                }
                sVNCommitInfo = SVNCommitter.commit(sVNCommitMediator.getTmpFiles(), (Map)((Object)iterator), sVNURL, iSVNEditor, this.getEventDispatcher());
                SVNHashSet sVNHashSet = new SVNHashSet();
                SVNHashSet sVNHashSet2 = new SVNHashSet();
                for (String string3 : iterator.keySet()) {
                    sVNCommitItem = (SVNCommitItem)iterator.get(string3);
                    sVNHashSet2.add(sVNCommitItem.getPath());
                }
                for (String string3 : iterator.keySet()) {
                    Object object3;
                    SVNEntry sVNEntry;
                    String string4;
                    SVNAdminArea sVNAdminArea;
                    String string5;
                    SVNWCAccess sVNWCAccess;
                    block36: {
                        sVNCommitItem = (SVNCommitItem)iterator.get(string3);
                        sVNWCAccess = sVNCommitItem.getWCAccess();
                        string5 = sVNCommitItem.getPath();
                        sVNAdminArea = null;
                        string4 = null;
                        try {
                            if (sVNCommitItem.getKind() == SVNNodeKind.DIR) {
                                string4 = "";
                                sVNAdminArea = sVNWCAccess.retrieve(sVNCommitItem.getFile());
                            } else {
                                string4 = SVNPathUtil.tail(string5);
                                sVNAdminArea = sVNWCAccess.retrieve(sVNCommitItem.getFile().getParentFile());
                            }
                        }
                        catch (SVNException sVNException) {
                            if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_LOCKED) break block36;
                            sVNAdminArea = null;
                        }
                    }
                    if (sVNAdminArea == null) {
                        if (SVNCommitClient16.hasProcessedParents(sVNHashSet, string5)) {
                            sVNHashSet.add(string5);
                            continue;
                        }
                        if (sVNCommitItem.isDeleted() && sVNCommitItem.getKind() == SVNNodeKind.DIR) {
                            SVNAdminArea sVNAdminArea2;
                            String string6;
                            sVNEntry = "".equals(string5) ? null : sVNCommitItem.getFile().getParentFile();
                            String string7 = string6 = "".equals(string5) ? null : SVNPathUtil.tail(string5);
                            if (sVNEntry != null && (sVNAdminArea2 = sVNWCAccess.retrieve((File)((Object)sVNEntry))) != null && (object3 = sVNAdminArea2.getEntry(string6, true)) != null) {
                                SVNHashMap sVNHashMap = new SVNHashMap();
                                sVNHashMap.put("svn:entry:schedule", null);
                                sVNHashMap.put("svn:entry:deleted", Boolean.TRUE.toString());
                                sVNAdminArea2.modifyEntry(string6, sVNHashMap, true, true);
                            }
                            sVNHashSet.add(string5);
                            continue;
                        }
                    }
                    if ((sVNEntry = sVNAdminArea.getEntry(string4, true)) == null && SVNCommitClient16.hasProcessedParents(sVNHashSet, string5)) {
                        sVNHashSet.add(string5);
                        continue;
                    }
                    boolean bl5 = false;
                    if (sVNCommitItem.isAdded() && sVNCommitItem.getCopyFromURL() != null && sVNCommitItem.getKind() == SVNNodeKind.DIR) {
                        bl5 = true;
                    }
                    boolean bl6 = !bl2 && sVNCommitItem.isLocked();
                    object3 = sVNCommitMediator.getWCProperties(sVNCommitItem);
                    sVNAdminArea.commit(string4, sVNCommitInfo, (SVNProperties)object3, bl6, bl5, !bl3, sVNHashSet2, this.getCommitParameters());
                    sVNHashSet.add(string5);
                }
                bl4 = true;
                this.dispatchEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, sVNCommitInfo.getNewRevision(), SVNEventAction.COMMIT_COMPLETED, null, null, null), -1.0);
            }
            catch (SVNException sVNException) {
                if (sVNException instanceof SVNCancelException) {
                    throw sVNException;
                }
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, sVNException);
                object = sVNException.getErrorMessage().wrap("Commit failed (details follow):");
                arrayList.add(new SVNCommitInfo(-1L, null, null, (SVNErrorMessage)object));
                this.dispatchEvent(SVNEventFactory.createErrorEvent((SVNErrorMessage)object, SVNEventAction.COMMIT_COMPLETED), -1.0);
                continue;
            }
            finally {
                if (sVNCommitInfo == null && iSVNEditor != null) {
                    try {
                        iSVNEditor.abortEdit();
                    }
                    catch (SVNException sVNException) {}
                }
                if (collection != null) {
                    for (Object object2 : collection) {
                        ((File)object2).delete();
                    }
                }
                if (sVNCommitPacket != null) {
                    sVNCommitPacket.dispose();
                }
            }
            arrayList.add(sVNCommitInfo != null ? sVNCommitInfo : SVNCommitInfo.NULL);
        }
        if (bl4) {
            this.sleepForTimeStamp();
        }
        return arrayList.toArray(new SVNCommitInfo[arrayList.size()]);
    }

    public SVNCommitPacket doCollectCommitItems(File[] fileArray, boolean bl2, boolean bl3, boolean bl4) {
        SVNDepth sVNDepth = bl4 ? SVNDepth.INFINITY : SVNDepth.EMPTY;
        return this.doCollectCommitItems(fileArray, bl2, bl3, sVNDepth, null);
    }

    public SVNCommitPacket doCollectCommitItems(File[] fileArray, boolean bl2, boolean bl3, SVNDepth sVNDepth, String[] stringArray) {
        SVNDepth sVNDepth2 = sVNDepth = sVNDepth == null ? SVNDepth.UNKNOWN : sVNDepth;
        if (sVNDepth == SVNDepth.UNKNOWN) {
            sVNDepth = SVNDepth.INFINITY;
        }
        if (fileArray == null || fileArray.length == 0) {
            return SVNCommitPacket.EMPTY;
        }
        ArrayList arrayList = new ArrayList();
        SVNStatusClient16 sVNStatusClient16 = new SVNStatusClient16(this.getRepositoryPool(), this.getOptions());
        sVNStatusClient16.setEventHandler(new SVNCommitClient16$3(this));
        SVNWCAccess sVNWCAccess = SVNCommitUtil.createCommitWCAccess(fileArray, sVNDepth, bl3, arrayList, sVNStatusClient16);
        SVNAdminArea[] sVNAdminAreaArray = sVNWCAccess.getAdminAreas();
        for (int i2 = 0; sVNAdminAreaArray != null && i2 < sVNAdminAreaArray.length; ++i2) {
            if (sVNAdminAreaArray[i2] == null) continue;
            sVNAdminAreaArray[i2].setCommitParameters(this.getCommitParameters());
        }
        try {
            SVNHashSet sVNHashSet;
            SVNHashMap sVNHashMap = new SVNHashMap();
            this.checkCancelled();
            SVNHashSet sVNHashSet2 = sVNHashSet = stringArray != null ? new SVNHashSet() : null;
            if (stringArray != null) {
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    sVNHashSet.add(stringArray[i3]);
                }
            }
            SVNCommitItem[] sVNCommitItemArray = SVNCommitUtil.harvestCommitables(sVNWCAccess, arrayList, sVNHashMap, !bl2, sVNDepth, bl3, sVNHashSet, this.getCommitParameters());
            boolean bl4 = false;
            this.checkCancelled();
            for (int i4 = 0; sVNCommitItemArray != null && i4 < sVNCommitItemArray.length; ++i4) {
                SVNCommitItem sVNCommitItem = sVNCommitItemArray[i4];
                if (!sVNCommitItem.isAdded() && !sVNCommitItem.isDeleted() && !sVNCommitItem.isContentsModified() && !sVNCommitItem.isPropertiesModified() && !sVNCommitItem.isCopied()) continue;
                bl4 = true;
                break;
            }
            if (!bl4) {
                sVNWCAccess.close();
                return SVNCommitPacket.EMPTY;
            }
            return new SVNCommitPacket(sVNWCAccess, sVNCommitItemArray, sVNHashMap);
        }
        catch (SVNException sVNException) {
            sVNWCAccess.close();
            if (sVNException instanceof SVNCancelException) {
                throw sVNException;
            }
            SVNErrorMessage sVNErrorMessage = sVNException.getErrorMessage();
            SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(sVNErrorMessage.getErrorCode(), "Commit failed (details follow):");
            SVNErrorManager.error(sVNErrorMessage2, sVNException, SVNLogType.DEFAULT);
            return null;
        }
    }

    public SVNCommitPacket[] doCollectCommitItems(File[] fileArray, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        SVNDepth sVNDepth = bl4 ? SVNDepth.INFINITY : SVNDepth.EMPTY;
        return this.doCollectCommitItems(fileArray, bl2, bl3, sVNDepth, bl5, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNCommitPacket[] doCollectCommitItems(File[] fileArray, boolean bl2, boolean bl3, SVNDepth sVNDepth, boolean bl4, String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        Iterator iterator;
        Object object4;
        Object object5;
        SVNDepth sVNDepth2 = sVNDepth = sVNDepth == null ? SVNDepth.UNKNOWN : sVNDepth;
        if (sVNDepth == SVNDepth.UNKNOWN) {
            sVNDepth = SVNDepth.INFINITY;
        }
        if (fileArray == null || fileArray.length == 0) {
            return new SVNCommitPacket[0];
        }
        ArrayList<SVNCommitPacket> arrayList = new ArrayList<SVNCommitPacket>();
        SVNHashMap sVNHashMap = new SVNHashMap();
        SVNStatusClient16 sVNStatusClient16 = new SVNStatusClient16(this.getRepositoryPool(), this.getOptions());
        sVNStatusClient16.setEventHandler(new SVNCommitClient16$4(this));
        SVNWCAccess[] sVNWCAccessArray = SVNCommitUtil.createCommitWCAccess2(fileArray, sVNDepth, bl3, sVNHashMap, sVNStatusClient16);
        for (int i2 = 0; i2 < sVNWCAccessArray.length; ++i2) {
            object5 = sVNWCAccessArray[i2];
            object4 = ((SVNWCAccess)object5).getAdminAreas();
            for (int i3 = 0; object4 != null && i3 < ((SVNAdminArea[])object4).length; ++i3) {
                if (object4[i3] == null) continue;
                object4[i3].setCommitParameters(this.getCommitParameters());
            }
            Collection collection = (Collection)sVNHashMap.get(object5);
            try {
                this.checkCancelled();
                iterator = new SVNHashMap();
                Object object6 = object3 = stringArray != null ? new SVNHashSet() : null;
                if (stringArray != null) {
                    for (int i4 = 0; i4 < stringArray.length; ++i4) {
                        object3.add(stringArray[i4]);
                    }
                }
                object2 = SVNCommitUtil.harvestCommitables((SVNWCAccess)object5, collection, iterator, !bl2, sVNDepth, bl3, (Collection)object3, this.getCommitParameters());
                this.checkCancelled();
                boolean bl5 = false;
                for (int i5 = 0; object2 != null && i5 < ((Object)object2).length; ++i5) {
                    object = object2[i5];
                    if (!((SVNCommitItem)object).isAdded() && !((SVNCommitItem)object).isDeleted() && !((SVNCommitItem)object).isContentsModified() && !((SVNCommitItem)object).isPropertiesModified() && !((SVNCommitItem)object).isCopied()) continue;
                    bl5 = true;
                    break;
                }
                if (!bl5) {
                    ((SVNWCAccess)object5).close();
                    continue;
                }
                arrayList.add(new SVNCommitPacket((SVNWCAccess)object5, (SVNCommitItem[])object2, (Map)((Object)iterator)));
                continue;
            }
            catch (SVNException sVNException) {
                for (int i6 = 0; i6 < sVNWCAccessArray.length; ++i6) {
                    sVNWCAccessArray[i6].close();
                }
                if (sVNException instanceof SVNCancelException) {
                    throw sVNException;
                }
                object3 = sVNException.getErrorMessage();
                object2 = SVNErrorMessage.create(((SVNErrorMessage)object3).getErrorCode(), "Commit failed (details follow):");
                SVNErrorManager.error((SVNErrorMessage)object2, sVNException, SVNLogType.DEFAULT);
            }
        }
        SVNCommitPacket[] sVNCommitPacketArray = arrayList.toArray(new SVNCommitPacket[arrayList.size()]);
        if (!bl4) {
            return sVNCommitPacketArray;
        }
        object5 = new SVNHashMap();
        object4 = new SVNHashMap();
        try {
            int n2;
            for (n2 = 0; n2 < sVNCommitPacketArray.length; ++n2) {
                this.checkCancelled();
                iterator = sVNCommitPacketArray[n2];
                object3 = SVNWCUtil.getWorkingCopyRoot(((SVNCommitPacket)((Object)iterator)).getCommitItems()[0].getWCAccess().getAnchor(), true);
                object2 = this.createWCAccess();
                String string = null;
                SVNURL sVNURL = null;
                try {
                    object = ((SVNWCAccess)object2).open((File)object3, false, 0);
                    string = ((SVNAdminArea)object).getEntry(((SVNAdminArea)object).getThisDirName(), false).getUUID();
                    sVNURL = ((SVNAdminArea)object).getEntry(((SVNAdminArea)object).getThisDirName(), false).getSVNURL();
                }
                finally {
                    ((SVNWCAccess)object2).close();
                }
                this.checkCancelled();
                if (string == null) {
                    if (sVNURL != null) {
                        object = this.createRepository(sVNURL, (File)object3, (SVNWCAccess)object2, true);
                        string = ((SVNRepository)object).getRepositoryUUID(true);
                    } else {
                        object = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", object3);
                        SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
                    }
                }
                if (!object5.containsKey(string = string + sVNURL.getProtocol() + ":" + sVNURL.getHost() + ":" + sVNURL.getPort() + ":" + sVNURL.getUserInfo())) {
                    object5.put(string, new ArrayList());
                    object4.put(string, new SVNHashMap());
                }
                object = (Collection)object5.get(string);
                Map map = (Map)object4.get(string);
                for (int i7 = 0; i7 < ((SVNCommitPacket)((Object)iterator)).getCommitItems().length; ++i7) {
                    object.add(((SVNCommitPacket)((Object)iterator)).getCommitItems()[i7]);
                }
                if (((SVNCommitPacket)((Object)iterator)).getLockTokens() != null) {
                    map.putAll(((SVNCommitPacket)((Object)iterator)).getLockTokens());
                }
                this.checkCancelled();
            }
            sVNCommitPacketArray = new SVNCommitPacket[object5.size()];
            n2 = 0;
            iterator = object5.keySet().iterator();
            while (iterator.hasNext()) {
                this.checkCancelled();
                object3 = (String)iterator.next();
                object2 = (Collection)object5.get(object3);
                Map map = (Map)object4.get(object3);
                SVNCommitItem[] sVNCommitItemArray = object2.toArray(new SVNCommitItem[object2.size()]);
                sVNCommitPacketArray[n2++] = new SVNCommitPacket(null, sVNCommitItemArray, map);
            }
        }
        catch (SVNException sVNException) {
            for (int i8 = 0; i8 < sVNWCAccessArray.length; ++i8) {
                sVNWCAccessArray[i8].close();
            }
            if (sVNException instanceof SVNCancelException) {
                throw sVNException;
            }
            SVNErrorMessage sVNErrorMessage = sVNException.getErrorMessage();
            object3 = SVNErrorMessage.create(sVNErrorMessage.getErrorCode(), "Commit failed (details follow):");
            SVNErrorManager.error((SVNErrorMessage)object3, sVNException, SVNLogType.DEFAULT);
        }
        return sVNCommitPacketArray;
    }

    private void addURLParents(List list, SVNURL sVNURL) {
        SVNURL sVNURL2 = sVNURL.removePathTail();
        SVNRepository sVNRepository = this.createRepository(sVNURL2, null, null, true);
        SVNNodeKind sVNNodeKind = sVNRepository.checkPath("", -1L);
        if (sVNNodeKind == SVNNodeKind.NONE) {
            this.addURLParents(list, sVNURL2);
        }
        list.add(sVNURL);
    }

    private boolean importDir(SVNDeltaGenerator sVNDeltaGenerator, File file, String string, boolean bl2, boolean bl3, SVNDepth sVNDepth, Map map, ISVNFileFilter iSVNFileFilter, ISVNEditor iSVNEditor) {
        this.checkCancelled();
        File[] fileArray = SVNFileListUtil.listFiles(file);
        boolean bl4 = false;
        ISVNFileFilter iSVNFileFilter2 = this.getCommitHandler() instanceof ISVNFileFilter ? (ISVNFileFilter)((Object)this.getCommitHandler()) : null;
        Collection collection = bl2 ? SVNStatusEditor.getGlobalIgnores(this.getOptions()) : null;
        for (int i2 = 0; fileArray != null && i2 < fileArray.length; ++i2) {
            Object object;
            Object object2;
            File file2 = fileArray[i2];
            if (SVNFileUtil.getAdminDirectoryName().equals(file2.getName())) {
                object2 = SVNEventFactory.createSVNEvent(file2, SVNNodeKind.NONE, null, -1L, SVNEventAction.SKIP, SVNEventAction.COMMIT_ADDED, null, null);
                this.handleEvent((SVNEvent)object2, -1.0);
                continue;
            }
            if (iSVNFileFilter2 != null && !iSVNFileFilter2.accept(file2) || iSVNFileFilter != null && !iSVNFileFilter.accept(file2)) continue;
            Object object3 = object2 = string == null ? file2.getName() : SVNPathUtil.append(string, file2.getName());
            if (bl2 && SVNStatusEditor.isIgnored(collection, file2, "/" + (String)object2)) continue;
            SVNFileType sVNFileType = SVNFileType.getType(file2);
            if (sVNFileType == SVNFileType.DIRECTORY && sVNDepth.compareTo(SVNDepth.IMMEDIATES) >= 0) {
                iSVNEditor.addDir((String)object2, null, -1L);
                bl4 |= true;
                object = SVNEventFactory.createSVNEvent(file2, SVNNodeKind.DIR, null, -1L, SVNEventAction.COMMIT_ADDED, null, null, null);
                this.handleEvent((SVNEvent)object, -1.0);
                SVNDepth sVNDepth2 = sVNDepth;
                if (sVNDepth == SVNDepth.IMMEDIATES) {
                    sVNDepth2 = SVNDepth.EMPTY;
                }
                this.importDir(sVNDeltaGenerator, file2, (String)object2, bl2, bl3, sVNDepth2, map, iSVNFileFilter, iSVNEditor);
                iSVNEditor.closeDir();
                continue;
            }
            if ((sVNFileType == SVNFileType.FILE || sVNFileType == SVNFileType.SYMLINK) && sVNDepth.compareTo(SVNDepth.FILES) >= 0) {
                bl4 |= this.importFile(sVNDeltaGenerator, file2, sVNFileType, (String)object2, map, iSVNEditor);
                continue;
            }
            if (sVNFileType == SVNFileType.DIRECTORY || sVNFileType == SVNFileType.FILE) continue;
            if (bl3) {
                object = SVNEventFactory.createSVNEvent(file2, SVNNodeKind.NONE, null, -1L, SVNEventAction.SKIP, SVNEventAction.COMMIT_ADDED, null, null);
                this.handleEvent((SVNEvent)object, -1.0);
                continue;
            }
            object = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unknown or unversionable type for ''{0}''", (Object)file2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        return bl4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importFile(SVNDeltaGenerator sVNDeltaGenerator, File file, SVNFileType sVNFileType, String string, Map map, ISVNEditor iSVNEditor) {
        Object object;
        Object object2;
        String string2;
        String string32;
        Object object3;
        if (sVNFileType == null || sVNFileType == SVNFileType.UNKNOWN) {
            object3 = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "unknown or unversionable type for ''{0}''", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
        }
        iSVNEditor.addFile(string, null, -1L);
        object3 = SvnNgPropertiesManager.getMatchedAutoProperties(SVNFileUtil.getFileName(file), map);
        Map map2 = new SVNHashMap();
        if (sVNFileType != SVNFileType.SYMLINK) {
            map2 = SVNPropertiesManager.computeAutoProperties(this.getOptions(), file, map2);
        } else {
            map2.put("svn:special", "*");
        }
        map2.putAll(object3);
        String string4 = (String)map2.get("svn:mime-type");
        for (String string32 : map2.keySet()) {
            string2 = (String)map2.get(string32);
            if ("svn:eol-style".equals(string32) && string2 != null && (SVNProperty.isBinaryMimeType(string4) || !SVNTranslator.checkNewLines(file))) continue;
            if ("svnkit:charset".equals(string32) && string2 != null) {
                if (SVNProperty.isBinaryMimeType(string4)) continue;
                try {
                    SVNTranslator.getCharset(string2, string4, string, this.getOptions());
                }
                catch (SVNException sVNException) {
                    continue;
                }
            }
            iSVNEditor.changeFileProperty(string, string32, SVNPropertyValue.create(string2));
        }
        SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, string4, -1L, SVNEventAction.COMMIT_ADDED, null, null, null);
        this.handleEvent(sVNEvent, -1.0);
        string32 = SVNTranslator.getCharset((String)map2.get("svnkit:charset"), string4, file.getPath(), this.getOptions());
        string2 = (String)map2.get("svn:eol-style");
        String string5 = (String)map2.get("svn:keywords");
        boolean bl2 = map2.get("svn:special") != null;
        File file2 = null;
        if (string32 != null || string2 != null || string5 != null || bl2) {
            object2 = SVNTranslator.getBaseEOL(string2);
            object = string5 != null ? SVNTranslator.computeKeywords(string5, null, null, null, null, null, this.getOptions()) : null;
            file2 = SVNFileUtil.createTempFile("import", ".tmp");
            SVNTranslator.translate(file, file2, string32, object2, (Map)object, bl2, false);
        }
        object2 = file2 != null ? file2 : file;
        object = null;
        String string6 = null;
        try {
            object = SVNFileUtil.openFileForReading((File)object2, SVNLogType.WC);
            iSVNEditor.applyTextDelta(string, null);
            string6 = sVNDeltaGenerator.sendDelta(string, (InputStream)object, iSVNEditor, true);
        }
        finally {
            SVNFileUtil.closeFile((InputStream)object);
            SVNFileUtil.deleteFile(file2);
        }
        iSVNEditor.closeFile(string, string6);
        return true;
    }

    private static boolean hasProcessedParents(Collection collection, String string) {
        if (collection.contains(string = SVNPathUtil.removeTail(string))) {
            return true;
        }
        if ("".equals(string)) {
            return false;
        }
        return SVNCommitClient16.hasProcessedParents(collection, string);
    }

    static String validateCommitMessage(String string) {
        if (string == null) {
            return string;
        }
        string = string.replaceAll("\r\n", "\n");
        string = string.replace('\r', '\n');
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getVersionedAutoProperties(SVNURL sVNURL, SVNURL sVNURL2) {
        SVNURL sVNURL3 = sVNURL.removePathTail();
        if (sVNURL.equals(sVNURL2)) {
            return null;
        }
        List[] listArray = new List[1];
        SvnOperationFactory svnOperationFactory = new SvnOperationFactory();
        try {
            Object object;
            Object object2;
            SVNProperties sVNProperties;
            Object object3;
            svnOperationFactory.setRepositoryPool(this.getRepositoryPool());
            svnOperationFactory.setOptions(this.getOptions());
            svnOperationFactory.setEventHandler(this.getEventDispatcher());
            svnOperationFactory.setAutoDisposeRepositoryPool(false);
            svnOperationFactory.setCanceller(this.getEventDispatcher());
            while (true) {
                object3 = svnOperationFactory.createGetProperties();
                ((SvnOperation)object3).setSingleTarget(SvnTarget.fromURL(sVNURL3, SVNRevision.HEAD));
                ((SvnOperation)object3).setRevision(SVNRevision.HEAD);
                ((SvnOperation)object3).setDepth(SVNDepth.EMPTY);
                ((SvnGetProperties)object3).setTargetInheritedPropertiesReceiver(new SVNCommitClient16$5(this, listArray));
                try {
                    sVNProperties = (SVNProperties)((SvnOperation)object3).run();
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.RA_LOCAL_REPOS_OPEN_FAILED && sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.ENTRY_NOT_FOUND) {
                        throw sVNException;
                    }
                    if (sVNURL3.equals(sVNURL2)) {
                        sVNProperties = null;
                        break;
                    }
                    sVNURL3 = sVNURL3.removePathTail();
                    continue;
                }
                break;
            }
            object3 = new HashMap();
            if (listArray[0] != null) {
                for (Object object4 : listArray[0]) {
                    SVNProperties object5 = ((SvnInheritedProperties)object4).getProperties();
                    object2 = object5.asMap();
                    for (Map.Entry entry : object2.entrySet()) {
                        String string = (String)entry.getKey();
                        if (!"svn:auto-props".equals(string)) continue;
                        SVNPropertyValue sVNPropertyValue = (SVNPropertyValue)entry.getValue();
                        object3 = SvnNgPropertiesManager.parseAutoProperties(sVNPropertyValue, (Map)object3);
                    }
                }
            }
            if (sVNProperties != null) {
                object = sVNProperties.asMap();
                for (Map.Entry entry : object.entrySet()) {
                    object2 = (String)entry.getKey();
                    if (!"svn:auto-props".equals(object2)) continue;
                    SVNPropertyValue sVNPropertyValue = (SVNPropertyValue)entry.getValue();
                    object3 = SvnNgPropertiesManager.parseAutoProperties(sVNPropertyValue, object3);
                }
            }
            object = object3;
            return object;
        }
        finally {
            svnOperationFactory.dispose();
        }
    }
}

