/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc16;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate;
import org.tmatesoft.svn.core.internal.wc16.SVNChangelistClient16$1;
import org.tmatesoft.svn.core.internal.wc16.SVNChangelistClient16$SVNChangeListWalker;
import org.tmatesoft.svn.core.wc.ISVNChangelistHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNChangelistClient16
extends SVNBasicDelegate {
    public SVNChangelistClient16(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
    }

    public SVNChangelistClient16(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public void getChangeLists(File file, Collection collection, SVNDepth sVNDepth, ISVNChangelistHandler iSVNChangelistHandler) {
        this.doGetChangeLists(file, collection, sVNDepth, iSVNChangelistHandler);
    }

    public void getChangeListPaths(Collection collection, Collection collection2, SVNDepth sVNDepth, ISVNChangelistHandler iSVNChangelistHandler) {
        this.doGetChangeListPaths(collection, collection2, sVNDepth, iSVNChangelistHandler);
    }

    public void addToChangelist(File[] fileArray, SVNDepth sVNDepth, String string, String[] stringArray) {
        this.doAddToChangelist(fileArray, sVNDepth, string, stringArray);
    }

    public void removeFromChangelist(File[] fileArray, SVNDepth sVNDepth, String[] stringArray) {
        this.doRemoveFromChangelist(fileArray, sVNDepth, stringArray);
    }

    public void doAddToChangelist(File[] fileArray, SVNDepth sVNDepth, String string, String[] stringArray) {
        this.setChangelist(fileArray, string, stringArray, sVNDepth);
    }

    public void doRemoveFromChangelist(File[] fileArray, SVNDepth sVNDepth, String[] stringArray) {
        this.setChangelist(fileArray, null, stringArray, sVNDepth);
    }

    public void doGetChangeListPaths(Collection collection, Collection collection2, SVNDepth sVNDepth, ISVNChangelistHandler iSVNChangelistHandler) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        collection2 = collection2 == null ? Collections.EMPTY_LIST : collection2;
        for (File file : collection2) {
            this.doGetChangeLists(file, collection, sVNDepth, iSVNChangelistHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetChangeLists(File file, Collection collection, SVNDepth sVNDepth, ISVNChangelistHandler iSVNChangelistHandler) {
        file = file.getAbsoluteFile();
        try (SVNWCAccess sVNWCAccess = this.createWCAccess();){
            sVNWCAccess.probeOpen(file, false, -1);
            SVNChangelistClient16$1 sVNChangelistClient16$1 = new SVNChangelistClient16$1(this, collection, iSVNChangelistHandler);
            sVNWCAccess.walkEntries(file, sVNChangelistClient16$1, false, sVNDepth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setChangelist(File[] fileArray, String string, String[] stringArray, SVNDepth sVNDepth) {
        Object object;
        if ("".equals(string)) {
            object = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Changelist names must not be empty");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = this.createWCAccess();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            this.checkCancelled();
            File file = fileArray[i2].getAbsoluteFile();
            SVNHashSet sVNHashSet = null;
            if (stringArray != null && stringArray.length > 0) {
                sVNHashSet = new SVNHashSet();
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    sVNHashSet.add(stringArray[i3]);
                }
            }
            try {
                ((SVNWCAccess)object).probeOpen(file, true, -1);
                ((SVNWCAccess)object).walkEntries(file, new SVNChangelistClient16$SVNChangeListWalker(this, (SVNWCAccess)object, string, sVNHashSet), false, sVNDepth);
                continue;
            }
            finally {
                ((SVNWCAccess)object).close();
            }
        }
    }
}

