/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc16;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNEntryHandler;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc16.SVNChangelistClient16;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.util.SVNLogType;

class SVNChangelistClient16$SVNChangeListWalker
implements ISVNEntryHandler {
    private String myChangelist;
    private Collection myChangelists;
    private SVNWCAccess myWCAccess;
    final /* synthetic */ SVNChangelistClient16 this$0;

    public SVNChangelistClient16$SVNChangeListWalker(SVNChangelistClient16 sVNChangelistClient16, SVNWCAccess sVNWCAccess, String string, Collection collection) {
        this.this$0 = sVNChangelistClient16;
        this.myChangelist = string;
        this.myChangelists = collection;
        this.myWCAccess = sVNWCAccess;
    }

    @Override
    public void handleEntry(File file, SVNEntry sVNEntry) {
        Object object;
        Serializable serializable;
        if (!SVNWCAccess.matchesChangeList(this.myChangelists, sVNEntry)) {
            return;
        }
        if (!sVNEntry.isFile()) {
            if (sVNEntry.isThisDir()) {
                SVNEventAction sVNEventAction = this.myChangelist != null ? SVNEventAction.CHANGELIST_SET : SVNEventAction.CHANGELIST_CLEAR;
                SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.DIR, null, -1L, SVNEventAction.SKIP, sVNEventAction, null, null);
                this.this$0.dispatchEvent(sVNEvent);
            }
            return;
        }
        if (sVNEntry.getChangelistName() == null && this.myChangelist == null) {
            return;
        }
        if (sVNEntry.getChangelistName() != null && sVNEntry.getChangelistName().equals(this.myChangelist)) {
            return;
        }
        if (this.myChangelist != null && sVNEntry.getChangelistName() != null) {
            serializable = SVNErrorMessage.create(SVNErrorCode.WC_CHANGELIST_MOVE, "Removing ''{0}'' from changelist ''{1}''.", file, sVNEntry.getChangelistName());
            object = SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, null, -1L, SVNEventAction.CHANGELIST_MOVED, SVNEventAction.CHANGELIST_MOVED, (SVNErrorMessage)serializable, null);
            this.this$0.dispatchEvent((SVNEvent)object);
        }
        serializable = new SVNHashMap();
        serializable.put("svn:entry:changelist", this.myChangelist);
        object = this.myWCAccess.retrieve(file.getParentFile());
        sVNEntry = ((SVNAdminArea)object).modifyEntry(sVNEntry.getName(), (Map)((Object)serializable), true, false);
        SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.UNKNOWN, null, -1L, null, null, null, this.myChangelist != null ? SVNEventAction.CHANGELIST_SET : SVNEventAction.CHANGELIST_CLEAR, null, null, null, this.myChangelist);
        this.this$0.dispatchEvent(sVNEvent);
    }

    @Override
    public void handleError(File file, SVNErrorMessage sVNErrorMessage) {
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
    }
}

