/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc16;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate$1;
import org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate$2;
import org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate$LocationsLogEntryHandler;
import org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate$SVNRepositoryLocation;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.DefaultSVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNPathListHandler;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNBasicDelegate
implements ISVNEventHandler {
    private ISVNRepositoryPool myRepositoryPool;
    private ISVNOptions myOptions;
    private ISVNEventHandler myEventDispatcher;
    private List myPathPrefixesStack;
    private boolean myIsIgnoreExternals;
    private boolean myIsLeaveConflictsUnresolved;
    private ISVNDebugLog myDebugLog;
    private ISVNPathListHandler myPathListHandler;

    public SVNBasicDelegate(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        this(new DefaultSVNRepositoryPool(iSVNAuthenticationManager == null ? SVNWCUtil.createDefaultAuthenticationManager() : iSVNAuthenticationManager, (ISVNTunnelProvider)iSVNOptions, 0L, false), iSVNOptions);
    }

    protected SVNBasicDelegate(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        this.myRepositoryPool = iSVNRepositoryPool;
        this.setOptions(iSVNOptions);
        this.myPathPrefixesStack = new LinkedList();
    }

    public ISVNOptions getOptions() {
        return this.myOptions;
    }

    public void setOptions(ISVNOptions iSVNOptions) {
        this.myOptions = iSVNOptions;
    }

    public void setIgnoreExternals(boolean bl2) {
        this.myIsIgnoreExternals = bl2;
    }

    public boolean isIgnoreExternals() {
        return this.myIsIgnoreExternals;
    }

    public void setLeaveConflictsUnresolved(boolean bl2) {
        this.myIsLeaveConflictsUnresolved = bl2;
    }

    public boolean isLeaveConflictsUnresolved() {
        return this.myIsLeaveConflictsUnresolved;
    }

    public void setEventHandler(ISVNEventHandler iSVNEventHandler) {
        this.myEventDispatcher = iSVNEventHandler;
    }

    public void setPathListHandler(ISVNPathListHandler iSVNPathListHandler) {
        this.myPathListHandler = iSVNPathListHandler;
    }

    public void setDebugLog(ISVNDebugLog iSVNDebugLog) {
        this.myDebugLog = iSVNDebugLog;
    }

    public ISVNDebugLog getDebugLog() {
        return this.myDebugLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNURL getReposRoot(File file, SVNURL sVNURL, SVNRevision sVNRevision, SVNAdminArea sVNAdminArea, SVNWCAccess sVNWCAccess) {
        SVNURL sVNURL2 = null;
        if (file != null && (sVNRevision == SVNRevision.WORKING || sVNRevision == SVNRevision.BASE)) {
            if (sVNWCAccess == null) {
                sVNWCAccess = this.createWCAccess();
            }
            boolean bl2 = false;
            try {
                if (sVNAdminArea == null) {
                    sVNAdminArea = sVNWCAccess.probeOpen(file, false, 0);
                    bl2 = true;
                }
                SVNEntry sVNEntry = sVNWCAccess.getVersionedEntry(file, false);
                sVNURL = this.getEntryLocation(file, sVNEntry, null, SVNRevision.UNDEFINED);
                sVNURL2 = sVNEntry.getRepositoryRootURL();
            }
            finally {
                if (bl2) {
                    sVNWCAccess.closeAdminArea(file);
                }
            }
        }
        if (sVNURL2 == null) {
            SVNRepository sVNRepository = null;
            try {
                sVNRepository = this.createRepository(sVNURL, file, null, sVNRevision, sVNRevision, null);
                sVNURL2 = sVNRepository.getRepositoryRoot(true);
            }
            finally {
                if (sVNRepository != null) {
                    sVNRepository.closeSession();
                }
            }
        }
        return sVNURL2;
    }

    protected void sleepForTimeStamp() {
        if (this.myPathPrefixesStack == null || this.myPathPrefixesStack.isEmpty()) {
            SVNFileUtil.sleepForTimestamp();
        }
    }

    protected SVNRepository createRepository(SVNURL sVNURL, File file, SVNWCAccess sVNWCAccess, boolean bl2) {
        SVNEntry sVNEntry;
        String string = null;
        if (sVNWCAccess != null && (sVNEntry = sVNWCAccess.getEntry(file, false)) != null) {
            string = sVNEntry.getUUID();
        }
        return this.createRepository(sVNURL, string, bl2);
    }

    protected SVNRepository createRepository(SVNURL sVNURL, String string, boolean bl2) {
        String string2;
        SVNRepository sVNRepository = null;
        sVNRepository = this.myRepositoryPool == null ? SVNRepositoryFactory.create(sVNURL, null) : this.myRepositoryPool.createRepository(sVNURL, bl2);
        if (string != null && !string.equals(string2 = sVNRepository.getRepositoryUUID(true))) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_UUID_MISMATCH, "Repository UUID ''{0}'' doesn''t match expected UUID ''{1}''", string2, string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        sVNRepository.setDebugLog(this.getDebugLog());
        sVNRepository.setCanceller(this.getEventDispatcher());
        return sVNRepository;
    }

    protected ISVNRepositoryPool getRepositoryPool() {
        return this.myRepositoryPool;
    }

    protected void dispatchEvent(SVNEvent sVNEvent) {
        this.dispatchEvent(sVNEvent, -1.0);
    }

    protected void dispatchEvent(SVNEvent sVNEvent, double d2) {
        if (this.myEventDispatcher != null) {
            try {
                this.myEventDispatcher.handleEvent(sVNEvent, d2);
            }
            catch (SVNException sVNException) {
                throw sVNException;
            }
            catch (Throwable throwable) {
                SVNDebugLog.getDefaultLog().logSevere(SVNLogType.WC, throwable);
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Error while dispatching event: {0}", new Object[]{throwable.getMessage()}, 0, throwable);
                SVNErrorManager.error(sVNErrorMessage, throwable, SVNLogType.DEFAULT);
            }
        }
    }

    public void setEventPathPrefix(String string) {
        if (string == null && !this.myPathPrefixesStack.isEmpty()) {
            this.myPathPrefixesStack.remove(this.myPathPrefixesStack.size() - 1);
        } else if (string != null) {
            this.myPathPrefixesStack.add(string);
        }
    }

    protected ISVNEventHandler getEventDispatcher() {
        return this.myEventDispatcher;
    }

    protected SVNWCAccess createWCAccess() {
        return this.createWCAccess(null);
    }

    protected SVNWCAccess createWCAccess(String string) {
        ISVNEventHandler iSVNEventHandler = null;
        iSVNEventHandler = string != null ? new SVNBasicDelegate$1(this) : this;
        SVNWCAccess sVNWCAccess = SVNWCAccess.newInstance(iSVNEventHandler);
        sVNWCAccess.setOptions(this.myOptions);
        return sVNWCAccess;
    }

    @Override
    public void handleEvent(SVNEvent sVNEvent, double d2) {
        this.dispatchEvent(sVNEvent, d2);
    }

    public void handlePathListItem(File file) {
        if (this.myPathListHandler != null && file != null) {
            this.myPathListHandler.handlePathListItem(file);
        }
    }

    @Override
    public void checkCancelled() {
        if (this.myEventDispatcher != null) {
            this.myEventDispatcher.checkCancelled();
        }
    }

    protected long getRevisionNumber(SVNRevision sVNRevision, SVNRepository sVNRepository, File file) {
        return this.getRevisionNumber(sVNRevision, null, sVNRepository, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getRevisionNumber(SVNRevision sVNRevision, long[] lArray, SVNRepository sVNRepository, File file) {
        Object object;
        if (sVNRepository == null && (sVNRevision == SVNRevision.HEAD || sVNRevision.getDate() != null)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_RA_ACCESS_REQUIRED);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (sVNRevision.getNumber() >= 0L) {
            return sVNRevision.getNumber();
        }
        if (sVNRevision.getDate() != null) {
            return sVNRepository.getDatedRevision(sVNRevision.getDate());
        }
        if (sVNRevision == SVNRevision.HEAD) {
            if (lArray != null && lArray.length > 0 && SVNRevision.isValidRevisionNumber(lArray[0])) {
                return lArray[0];
            }
            long l2 = sVNRepository.getLatestRevision();
            if (lArray != null && lArray.length > 0) {
                lArray[0] = l2;
            }
            return l2;
        }
        if (!sVNRevision.isValid()) {
            return -1L;
        }
        if (sVNRevision == SVNRevision.COMMITTED || sVNRevision == SVNRevision.WORKING || sVNRevision == SVNRevision.BASE || sVNRevision == SVNRevision.PREVIOUS) {
            if (file == null) {
                object = SVNErrorMessage.create(SVNErrorCode.CLIENT_VERSIONED_PATH_REQUIRED);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            object = this.createWCAccess();
            ((SVNWCAccess)object).probeOpen(file, false, 0);
            SVNEntry sVNEntry = null;
            try {
                sVNEntry = ((SVNWCAccess)object).getVersionedEntry(file, false);
            }
            finally {
                ((SVNWCAccess)object).close();
            }
            if (sVNRevision == SVNRevision.WORKING || sVNRevision == SVNRevision.BASE) {
                return sVNEntry.getRevision();
            }
            if (sVNEntry.getCommittedRevision() < 0L) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Path ''{0}'' has no committed revision", (Object)file);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            return sVNRevision == SVNRevision.PREVIOUS ? sVNEntry.getCommittedRevision() - 1L : sVNEntry.getCommittedRevision();
        }
        object = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Unrecognized revision type requested for ''{0}''", file != null ? file : sVNRepository.getLocation());
        SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        return -1L;
    }

    protected SVNRepository createRepository(SVNURL sVNURL, File file, SVNAdminArea sVNAdminArea, SVNRevision sVNRevision, SVNRevision sVNRevision2, long[] lArray) {
        SVNRevision[] sVNRevisionArray;
        Object object;
        if (sVNURL == null && (object = this.getURL(file)) == null) {
            sVNRevisionArray = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)sVNRevisionArray, SVNLogType.WC);
        }
        object = sVNRevision2;
        sVNRevisionArray = this.resolveRevisions(sVNRevision, (SVNRevision)object, sVNURL != null, true);
        sVNRevision = sVNRevisionArray[0];
        object = sVNRevisionArray[1];
        SVNBasicDelegate$SVNRepositoryLocation[] sVNBasicDelegate$SVNRepositoryLocationArray = this.getLocations(sVNURL, file, null, sVNRevision, (SVNRevision)object, SVNRevision.UNDEFINED);
        sVNURL = sVNBasicDelegate$SVNRepositoryLocationArray[0].getURL();
        long l2 = sVNBasicDelegate$SVNRepositoryLocationArray[0].getRevisionNumber();
        SVNRepository sVNRepository = this.createRepository(sVNURL, sVNAdminArea != null ? sVNAdminArea.getRoot() : null, sVNAdminArea != null ? sVNAdminArea.getWCAccess() : null, true);
        if ((l2 = this.getRevisionNumber(SVNRevision.create(l2), sVNRepository, file)) < 0L) {
            l2 = sVNRepository.getLatestRevision();
        }
        if (lArray != null && lArray.length > 0) {
            lArray[0] = l2;
        }
        return sVNRepository;
    }

    protected SVNRevision[] resolveRevisions(SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, boolean bl3) {
        if (!sVNRevision.isValid()) {
            sVNRevision = bl2 ? SVNRevision.HEAD : (bl3 ? SVNRevision.WORKING : SVNRevision.BASE);
        }
        if (!sVNRevision2.isValid()) {
            sVNRevision2 = sVNRevision;
        }
        return new SVNRevision[]{sVNRevision, sVNRevision2};
    }

    protected void elideMergeInfo(SVNWCAccess sVNWCAccess, File file, SVNEntry sVNEntry, File file2) {
        if (file2 == null || !file2.equals(file)) {
            Map map = null;
            Map map2 = null;
            boolean[] blArray = new boolean[1];
            map2 = this.getWCMergeInfo(file, sVNEntry, file2, SVNMergeInfoInheritance.INHERITED, false, blArray);
            if (blArray[0] || map2 == null) {
                return;
            }
            map = this.getWCMergeInfo(file, sVNEntry, file2, SVNMergeInfoInheritance.NEAREST_ANCESTOR, false, blArray);
            if (map == null && file2 == null) {
                map = this.getWCOrRepositoryMergeInfo(file, sVNEntry, SVNMergeInfoInheritance.NEAREST_ANCESTOR, blArray, true, null);
            }
            if (map == null && file2 != null) {
                return;
            }
            SVNMergeInfoUtil.elideMergeInfo(map, map2, file, null, sVNWCAccess);
        }
    }

    protected Map getReposMergeInfo(SVNRepository sVNRepository, String string, long l2, SVNMergeInfoInheritance sVNMergeInfoInheritance, boolean bl2) {
        SVNMergeInfo sVNMergeInfo;
        Map map;
        block3: {
            map = null;
            try {
                map = sVNRepository.getMergeInfo(new String[]{string}, l2, sVNMergeInfoInheritance, false);
            }
            catch (SVNException sVNException) {
                if (bl2 && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.UNSUPPORTED_FEATURE) break block3;
                throw sVNException;
            }
        }
        String string2 = this.getPathRelativeToRoot(null, sVNRepository.getLocation(), sVNRepository.getRepositoryRoot(false), null, sVNRepository);
        Map map2 = null;
        if (map != null && (sVNMergeInfo = (SVNMergeInfo)map.get(string2)) != null) {
            map2 = sVNMergeInfo.getMergeSourcesToMergeLists();
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getWCOrRepositoryMergeInfo(File file, SVNEntry sVNEntry, SVNMergeInfoInheritance sVNMergeInfoInheritance, boolean[] blArray, boolean bl2, SVNRepository sVNRepository) {
        Map map;
        SVNPropertyValue sVNPropertyValue;
        Map map2 = null;
        long[] lArray = new long[]{-1L};
        SVNURL sVNURL = this.getEntryLocation(file, sVNEntry, lArray, SVNRevision.WORKING);
        long l2 = lArray[0];
        if (!bl2) {
            map2 = this.getWCMergeInfo(file, sVNEntry, null, sVNMergeInfoInheritance, false, blArray);
        }
        if (map2 == null && !sVNEntry.isScheduledForAddition() && (sVNPropertyValue = (SVNPropertyValue)(map = SVNPropertiesManager.getWorkingCopyPropertyValues(file, sVNEntry, "svn:mergeinfo", SVNDepth.EMPTY, true)).get(file)) == null) {
            SVNURL sVNURL2 = null;
            boolean bl3 = false;
            Map map3 = null;
            String string = null;
            try {
                if (sVNRepository == null) {
                    sVNRepository = this.createRepository(sVNURL, null, null, false);
                    bl3 = true;
                }
                string = this.getPathRelativeToSession(sVNURL, null, sVNRepository);
                sVNURL2 = sVNRepository.getLocation();
                if (string == null) {
                    string = "";
                    sVNRepository.setLocation(sVNURL, false);
                }
                map3 = this.getReposMergeInfo(sVNRepository, string, l2, sVNMergeInfoInheritance, true);
                if (bl3) {
                    sVNRepository.closeSession();
                } else if (sVNURL2 != null) {
                    sVNRepository.setLocation(sVNURL2, false);
                }
            }
            catch (Throwable throwable) {
                if (bl3) {
                    sVNRepository.closeSession();
                } else if (sVNURL2 != null) {
                    sVNRepository.setLocation(sVNURL2, false);
                }
                throw throwable;
            }
            if (map3 != null) {
                blArray[0] = true;
                map2 = map3;
            }
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getWCMergeInfo(File file, SVNEntry sVNEntry, File file2, SVNMergeInfoInheritance sVNMergeInfoInheritance, boolean bl2, boolean[] blArray) {
        Map map;
        Map map2;
        String string;
        block19: {
            string = "";
            map2 = null;
            SVNWCAccess sVNWCAccess = this.createWCAccess();
            map = null;
            if (file2 != null) {
                file2 = new File(SVNPathUtil.validateFilePath(file2.getAbsolutePath())).getAbsoluteFile();
            }
            while (true) {
                if (sVNMergeInfoInheritance == SVNMergeInfoInheritance.NEAREST_ANCESTOR) {
                    map2 = null;
                    sVNMergeInfoInheritance = SVNMergeInfoInheritance.INHERITED;
                } else {
                    map2 = SVNPropertiesManager.parseMergeInfo(file, sVNEntry, bl2);
                }
                if (SVNWCManager.isEntrySwitched(file, sVNEntry)) {
                    break block19;
                }
                file = new File(SVNPathUtil.validateFilePath(file.getAbsolutePath())).getAbsoluteFile();
                if (map2 != null || sVNMergeInfoInheritance == SVNMergeInfoInheritance.EXPLICIT || file.getParentFile() == null) break block19;
                if (file2 != null && file2.equals(file)) {
                    break block19;
                }
                string = SVNPathUtil.append(file.getName(), string);
                file = file.getParentFile();
                try {
                    sVNWCAccess.open(file, false, 0);
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                        map = map2;
                        blArray[0] = false;
                        Map map3 = map;
                        sVNWCAccess.close();
                        return map3;
                    }
                    throw sVNException;
                }
                sVNEntry = sVNWCAccess.getEntry(file, false);
                if (sVNEntry != null) {
                    continue;
                }
                break block19;
                break;
            }
            finally {
                sVNWCAccess.close();
            }
        }
        blArray[0] = false;
        if (string.length() == 0) {
            map = map2;
        } else if (map2 != null) {
            map = SVNMergeInfoUtil.adjustMergeInfoSourcePaths(null, string, map2);
            blArray[0] = true;
        } else {
            map = null;
        }
        if (blArray[0]) {
            map = SVNMergeInfoUtil.getInheritableMergeInfo(map, null, -1L, -1L);
            SVNMergeInfoUtil.removeEmptyRangeLists(map);
        }
        return map;
    }

    protected long getPathLastChangeRevision(String string, long l2, SVNRepository sVNRepository) {
        long[] lArray = new long[]{-1L};
        sVNRepository.log(new String[]{string}, 1L, l2, false, true, 1L, false, null, new SVNBasicDelegate$2(this, lArray));
        return lArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPathRelativeToRoot(File file, SVNURL sVNURL, SVNURL sVNURL2, SVNWCAccess sVNWCAccess, SVNRepository sVNRepository) {
        Object object;
        if (file != null) {
            boolean bl2 = false;
            try {
                if (sVNWCAccess == null) {
                    sVNWCAccess = this.createWCAccess();
                    sVNWCAccess.probeOpen(file, false, 0);
                    bl2 = true;
                }
                object = sVNWCAccess.getVersionedEntry(file, false);
                sVNURL = this.getEntryLocation(file, (SVNEntry)object, null, SVNRevision.UNDEFINED);
                if (sVNURL2 == null) {
                    sVNURL2 = ((SVNEntry)object).getRepositoryRootURL();
                }
            }
            finally {
                if (bl2) {
                    sVNWCAccess.closeAdminArea(file);
                }
            }
        }
        if (sVNURL2 == null) {
            sVNURL2 = sVNRepository.getRepositoryRoot(true);
        }
        String string = sVNURL2.getPath();
        object = sVNURL.getPath();
        if (!((String)object).startsWith(string)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "URL ''{0}'' is not a child of repository root URL ''{1}''", sVNURL, sVNURL2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (!((String)(object = ((String)object).substring(string.length()))).startsWith("/")) {
            object = "/" + (String)object;
        }
        return object;
    }

    protected String getPathRelativeToSession(SVNURL sVNURL, SVNURL sVNURL2, SVNRepository sVNRepository) {
        if (sVNURL2 == null) {
            sVNURL2 = sVNRepository.getLocation();
        }
        String string = sVNURL2.getPath();
        String string2 = sVNURL.getPath();
        if (!string2.startsWith(string + "/") && !string2.equals(string)) {
            return null;
        }
        if ((string2 = string2.substring(string.length())).startsWith("/")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SVNBasicDelegate$SVNRepositoryLocation[] getLocations(SVNURL sVNURL, File file, SVNRepository sVNRepository, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3) {
        Object object;
        SVNBasicDelegate$SVNRepositoryLocation[] sVNBasicDelegate$SVNRepositoryLocationArray;
        long[] lArray;
        Object object2;
        Object object3;
        Object object4;
        if (!sVNRevision.isValid() || !sVNRevision2.isValid()) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION), SVNLogType.DEFAULT);
        }
        long l2 = -1L;
        long[] lArray2 = new long[]{-1L};
        if (file != null) {
            object4 = SVNWCAccess.newInstance(null);
            try {
                ((SVNWCAccess)object4).openAnchor(file, false, 0);
                object3 = ((SVNWCAccess)object4).getVersionedEntry(file, false);
                if (((SVNEntry)object3).getCopyFromURL() != null && sVNRevision == SVNRevision.WORKING) {
                    sVNURL = ((SVNEntry)object3).getCopyFromSVNURL();
                    l2 = ((SVNEntry)object3).getCopyFromRevision();
                    if (((SVNEntry)object3).getURL() == null || !((SVNEntry)object3).getURL().equals(((SVNEntry)object3).getCopyFromURL())) {
                        sVNRepository = null;
                    }
                } else if (((SVNEntry)object3).getURL() != null) {
                    sVNURL = ((SVNEntry)object3).getSVNURL();
                } else {
                    object2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)file);
                    SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
                }
            }
            finally {
                ((SVNWCAccess)object4).close();
            }
        }
        object4 = "";
        object3 = null;
        object2 = null;
        if (sVNRepository == null) {
            sVNRepository = this.createRepository(sVNURL, null, null, true);
        } else {
            object4 = SVNPathUtil.getPathAsChild(sVNRepository.getLocation().toString(), sVNURL.toString());
            if (object4 == null) {
                object4 = "";
            }
        }
        if (l2 < 0L) {
            l2 = this.getRevisionNumber(sVNRevision, lArray2, sVNRepository, file);
        }
        long l3 = sVNRevision == sVNRevision2 && sVNRevision == SVNRevision.HEAD ? l2 : this.getRevisionNumber(sVNRevision2, lArray2, sVNRepository, file);
        long l4 = !sVNRevision3.isValid() ? l3 : this.getRevisionNumber(sVNRevision3, lArray2, sVNRepository, file);
        if (l4 == l2 && l3 == l2) {
            SVNBasicDelegate$SVNRepositoryLocation[] sVNBasicDelegate$SVNRepositoryLocationArray2 = new SVNBasicDelegate$SVNRepositoryLocation[]{new SVNBasicDelegate$SVNRepositoryLocation(sVNURL, l3), new SVNBasicDelegate$SVNRepositoryLocation(sVNURL, l4)};
            return sVNBasicDelegate$SVNRepositoryLocationArray2;
        }
        object2 = sVNRepository.getRepositoryRoot(true);
        if (l3 == l4) {
            long[] lArray3 = new long[1];
            lArray = lArray3;
            lArray3[0] = l3;
        } else {
            long[] lArray4 = new long[2];
            lArray4[0] = l3;
            lArray = lArray4;
            lArray4[1] = l4;
        }
        long[] lArray5 = lArray;
        try {
            object3 = sVNRepository.getLocations((String)object4, (Map)null, l2, lArray5);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage() != null && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                object3 = this.getLocations10(sVNRepository, l2, l3, l4);
            }
            throw sVNException;
        }
        SVNLocationEntry sVNLocationEntry = (SVNLocationEntry)object3.get(l3);
        SVNLocationEntry sVNLocationEntry2 = (SVNLocationEntry)object3.get(l4);
        if (sVNLocationEntry == null) {
            sVNBasicDelegate$SVNRepositoryLocationArray = file != null ? file : sVNURL;
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "Unable to find repository location for ''{0}'' in revision ''{1}''", sVNBasicDelegate$SVNRepositoryLocationArray, l3);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (sVNLocationEntry2 == null) {
            sVNBasicDelegate$SVNRepositoryLocationArray = file != null ? file : sVNURL;
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "The location for ''{0}'' for revision {1} does not exist in the repository or refers to an unrelated object", sVNBasicDelegate$SVNRepositoryLocationArray, l4);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        sVNBasicDelegate$SVNRepositoryLocationArray = new SVNBasicDelegate$SVNRepositoryLocation[2];
        object = SVNURL.parseURIEncoded(SVNPathUtil.append(((SVNURL)object2).toString(), SVNEncodingUtil.uriEncode(sVNLocationEntry.getPath())));
        sVNBasicDelegate$SVNRepositoryLocationArray[0] = new SVNBasicDelegate$SVNRepositoryLocation((SVNURL)object, l3);
        if (sVNRevision3.isValid()) {
            SVNURL sVNURL2 = SVNURL.parseURIEncoded(SVNPathUtil.append(((SVNURL)object2).toString(), SVNEncodingUtil.uriEncode(sVNLocationEntry2.getPath())));
            sVNBasicDelegate$SVNRepositoryLocationArray[1] = new SVNBasicDelegate$SVNRepositoryLocation(sVNURL2, l4);
        }
        return sVNBasicDelegate$SVNRepositoryLocationArray;
    }

    private Map getLocations10(SVNRepository sVNRepository, long l2, long l3, long l4) {
        Serializable serializable;
        String string;
        String string2 = sVNRepository.getRepositoryPath("");
        SVNNodeKind sVNNodeKind = sVNRepository.checkPath("", l2);
        if (sVNNodeKind == SVNNodeKind.NONE) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "path ''{0}'' doesn't exist at revision {1}", string2, l2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        long l5 = l2;
        l5 = Math.max(l3, l5);
        l5 = Math.max(l4, l5);
        long l6 = l2;
        l5 = Math.min(l3, l5);
        l5 = Math.min(l4, l5);
        SVNBasicDelegate$LocationsLogEntryHandler sVNBasicDelegate$LocationsLogEntryHandler = new SVNBasicDelegate$LocationsLogEntryHandler(string2, l3, l4, l2, sVNNodeKind, this.getEventDispatcher(), null);
        sVNRepository.log(new String[]{""}, l5, l6, true, false, sVNBasicDelegate$LocationsLogEntryHandler);
        String string3 = SVNBasicDelegate$LocationsLogEntryHandler.access$100(sVNBasicDelegate$LocationsLogEntryHandler) == null ? SVNBasicDelegate$LocationsLogEntryHandler.access$200(sVNBasicDelegate$LocationsLogEntryHandler) : SVNBasicDelegate$LocationsLogEntryHandler.access$100(sVNBasicDelegate$LocationsLogEntryHandler);
        String string4 = SVNBasicDelegate$LocationsLogEntryHandler.access$300(sVNBasicDelegate$LocationsLogEntryHandler) == null ? SVNBasicDelegate$LocationsLogEntryHandler.access$200(sVNBasicDelegate$LocationsLogEntryHandler) : SVNBasicDelegate$LocationsLogEntryHandler.access$300(sVNBasicDelegate$LocationsLogEntryHandler);
        String string5 = string = SVNBasicDelegate$LocationsLogEntryHandler.access$400(sVNBasicDelegate$LocationsLogEntryHandler) == null ? SVNBasicDelegate$LocationsLogEntryHandler.access$200(sVNBasicDelegate$LocationsLogEntryHandler) : SVNBasicDelegate$LocationsLogEntryHandler.access$400(sVNBasicDelegate$LocationsLogEntryHandler);
        if (string3 == null) {
            serializable = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "path ''{0}'' in revision {1} is an unrelated object", string2, l5);
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        serializable = new SVNHashMap();
        serializable.put(l3, new SVNLocationEntry(-1L, string4));
        serializable.put(l4, new SVNLocationEntry(-1L, string));
        return serializable;
    }

    private static String getPreviousLogPath(String string, SVNLogEntry sVNLogEntry, SVNNodeKind sVNNodeKind) {
        Serializable serializable;
        String string2 = null;
        SVNLogEntryPath sVNLogEntryPath = (SVNLogEntryPath)sVNLogEntry.getChangedPaths().get(string);
        if (sVNLogEntryPath != null) {
            if (sVNLogEntryPath.getType() != 'A' && sVNLogEntryPath.getType() != 'R') {
                return sVNLogEntryPath.getPath();
            }
            if (sVNLogEntryPath.getCopyPath() != null) {
                return sVNLogEntryPath.getCopyPath();
            }
            return null;
        }
        if (!sVNLogEntry.getChangedPaths().isEmpty()) {
            serializable = new SVNHashMap();
            serializable.putAll(sVNLogEntry.getChangedPaths());
            ArrayList arrayList = new ArrayList(serializable.keySet());
            Collections.sort(arrayList, SVNPathUtil.PATH_COMPARATOR);
            Collections.reverse(arrayList);
            for (String string3 : arrayList) {
                SVNLogEntryPath sVNLogEntryPath2;
                if (!string.startsWith(string3 + "/") || (sVNLogEntryPath2 = (SVNLogEntryPath)serializable.get(string3)).getCopyPath() == null) continue;
                string2 = SVNPathUtil.append(sVNLogEntryPath2.getCopyPath(), string.substring(string3.length()));
                break;
            }
        }
        if (string2 == null) {
            if (sVNNodeKind == SVNNodeKind.DIR) {
                string2 = string;
            } else {
                serializable = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "Missing changed-path information for ''{0}'' in revision {1}", string, sVNLogEntry.getRevision());
                SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
            }
        }
        return string2;
    }

    protected SVNURL getURL(File file) {
        return this.deriveLocation(file, null, null, SVNRevision.UNDEFINED, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SVNURL deriveLocation(File file, SVNURL sVNURL, long[] lArray, SVNRevision sVNRevision, SVNRepository sVNRepository, SVNWCAccess sVNWCAccess) {
        if (file != null) {
            SVNEntry sVNEntry = null;
            if (sVNWCAccess != null) {
                sVNEntry = sVNWCAccess.getVersionedEntry(file, false);
            } else {
                try (SVNWCAccess sVNWCAccess2 = this.createWCAccess();){
                    sVNWCAccess2.probeOpen(file, false, 0);
                    sVNEntry = sVNWCAccess2.getVersionedEntry(file, false);
                }
            }
            sVNURL = this.getEntryLocation(file, sVNEntry, lArray, sVNRevision);
        }
        if (lArray != null && lArray.length > 0 && !SVNRevision.isValidRevisionNumber(lArray[0])) {
            boolean bl2 = false;
            try {
                if (sVNRepository == null) {
                    sVNRepository = this.createRepository(sVNURL, null, null, false);
                    bl2 = true;
                }
                lArray[0] = this.getRevisionNumber(sVNRevision, null, sVNRepository, file);
            }
            finally {
                if (bl2) {
                    sVNRepository.closeSession();
                }
            }
        }
        return sVNURL;
    }

    protected SVNURL getEntryLocation(File file, SVNEntry sVNEntry, long[] lArray, SVNRevision sVNRevision) {
        SVNURL sVNURL = null;
        if (sVNEntry.getCopyFromURL() != null && sVNRevision == SVNRevision.WORKING) {
            sVNURL = sVNEntry.getCopyFromSVNURL();
            if (lArray != null && lArray.length > 0) {
                lArray[0] = sVNEntry.getCopyFromRevision();
            }
        } else if (sVNEntry.getURL() != null) {
            sVNURL = sVNEntry.getSVNURL();
            if (lArray != null && lArray.length > 0) {
                lArray[0] = sVNEntry.getRevision();
            }
        } else {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Entry for ''{0}'' has no URL", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        return sVNURL;
    }

    protected SVNURL ensureSessionURL(SVNRepository sVNRepository, SVNURL sVNURL) {
        SVNURL sVNURL2 = sVNRepository.getLocation();
        if (sVNURL == null) {
            sVNURL = sVNRepository.getRepositoryRoot(true);
        }
        if (!sVNURL.equals(sVNURL2)) {
            sVNRepository.setLocation(sVNURL, false);
            return sVNURL2;
        }
        return null;
    }

    protected int getLevelsToLockFromDepth(SVNDepth sVNDepth) {
        return sVNDepth == SVNDepth.EMPTY || sVNDepth == SVNDepth.FILES ? 0 : (sVNDepth == SVNDepth.IMMEDIATES ? 1 : -1);
    }

    protected void setCommitItemAccess(SVNCommitItem sVNCommitItem, SVNWCAccess sVNWCAccess) {
        sVNCommitItem.setWCAccess(sVNWCAccess);
    }

    protected void setCommitItemProperty(SVNCommitItem sVNCommitItem, String string, SVNPropertyValue sVNPropertyValue) {
        sVNCommitItem.setProperty(string, sVNPropertyValue);
    }

    protected void setCommitItemFlags(SVNCommitItem sVNCommitItem, boolean bl2, boolean bl3) {
        sVNCommitItem.setContentsModified(bl2);
        sVNCommitItem.setPropertiesModified(bl3);
    }

    static /* synthetic */ String access$500(String string, SVNLogEntry sVNLogEntry, SVNNodeKind sVNNodeKind) {
        return SVNBasicDelegate.getPreviousLogPath(string, sVNLogEntry, sVNNodeKind);
    }
}

