/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.patch;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNStatusUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatch;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchFileStream;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchHunk;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchHunkInfo;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPatchTarget {
    private static final int MAX_FUZZ = 2;
    private SVNPatch patch;
    private List lines = new ArrayList();
    private List hunks = new ArrayList();
    private boolean localMods;
    private boolean executable;
    private boolean skipped;
    private String eolStr;
    private Map keywords;
    private String eolStyle;
    private SVNNodeKind kind;
    private int currentLine;
    private boolean modified;
    private boolean hadRejects;
    private boolean deleted;
    private boolean eof;
    private boolean added;
    private File absPath;
    private File relPath;
    private File canonPathFromPatchfile;
    private RandomAccessFile file;
    private SVNPatchFileStream stream;
    private File patchedPath;
    private OutputStream patchedRaw;
    private OutputStream patched;
    private File rejectPath;
    private SVNPatchFileStream reject;
    private boolean parentDirExists;

    private SVNPatchTarget() {
    }

    public boolean isLocalMods() {
        return this.localMods;
    }

    public String getEolStr() {
        return this.eolStr;
    }

    public Map getKeywords() {
        return this.keywords;
    }

    public String getEolStyle() {
        return this.eolStyle;
    }

    public RandomAccessFile getFile() {
        return this.file;
    }

    public OutputStream getPatchedRaw() {
        return this.patchedRaw;
    }

    public File getCanonPathFromPatchfile() {
        return this.canonPathFromPatchfile;
    }

    public SVNPatch getPatch() {
        return this.patch;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isEof() {
        return this.eof;
    }

    public List getLines() {
        return this.lines;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public List getHunks() {
        return this.hunks;
    }

    public SVNNodeKind getKind() {
        return this.kind;
    }

    public SVNPatchFileStream getStream() {
        return this.stream;
    }

    public OutputStream getPatched() {
        return this.patched;
    }

    public SVNPatchFileStream getReject() {
        return this.reject;
    }

    public File getPatchedPath() {
        return this.patchedPath;
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public File getRejectPath() {
        return this.rejectPath;
    }

    public File getAbsPath() {
        return this.absPath;
    }

    public File getRelPath() {
        return this.relPath;
    }

    public boolean isHadRejects() {
        return this.hadRejects;
    }

    public boolean isParentDirExists() {
        return this.parentDirExists;
    }

    public static SVNPatchTarget initPatchTarget(SVNPatch sVNPatch, File file, int n2, SVNAdminArea sVNAdminArea) {
        SVNPatchTarget sVNPatchTarget = new SVNPatchTarget();
        sVNPatchTarget.resolveTargetPath(sVNPatch.getNewFilename(), file, n2, sVNAdminArea);
        sVNPatchTarget.localMods = false;
        sVNPatchTarget.executable = false;
        if (!sVNPatchTarget.skipped) {
            Object object;
            String string;
            sVNPatchTarget.eolStr = string = SVNFileUtil.getNativeEOLMarker(sVNAdminArea.getWCAccess().getOptions());
            sVNPatchTarget.keywords = null;
            sVNPatchTarget.eolStyle = null;
            if (sVNPatchTarget.kind == SVNNodeKind.FILE) {
                Object object2;
                sVNPatchTarget.file = SVNFileUtil.openRAFileForReading(sVNPatchTarget.absPath);
                sVNPatchTarget.stream = SVNPatchFileStream.openReadOnly(sVNPatchTarget.absPath);
                object = sVNAdminArea.getProperties(sVNPatchTarget.absPath.getAbsolutePath());
                String string2 = ((SVNVersionedProperties)object).getStringPropertyValue("svn:keywords");
                if (null != string2) {
                    object2 = sVNAdminArea.getEntry(sVNPatchTarget.absPath.getAbsolutePath(), false);
                    long l2 = ((SVNEntry)object2).getRevision();
                    String string3 = ((SVNEntry)object2).getAuthor();
                    String string4 = ((SVNEntry)object2).getCommittedDate();
                    String string5 = ((SVNEntry)object2).getURL();
                    String string6 = ((SVNEntry)object2).getRepositoryRoot();
                    String string7 = Long.toString(l2);
                    sVNPatchTarget.keywords = SVNTranslator.computeKeywords(string2, string5, string6, string3, string4, string7, sVNAdminArea.getWCAccess().getOptions());
                }
                if (null != (object2 = ((SVNVersionedProperties)object).getStringPropertyValue("svn:eol-style"))) {
                    sVNPatchTarget.eolStyle = new String(SVNTranslator.getEOL((String)object2, sVNAdminArea.getWCAccess().getOptions()));
                } else {
                    sVNPatchTarget.eolStr = SVNPatchTarget.detectFileEOL(sVNPatchTarget.file);
                    sVNPatchTarget.eolStyle = null;
                }
                if (sVNPatchTarget.eolStyle == null) {
                    sVNPatchTarget.eolStr = string;
                    sVNPatchTarget.eolStyle = "native";
                }
                sVNPatchTarget.localMods = sVNAdminArea.hasTextModifications(sVNPatchTarget.absPath.getAbsolutePath(), false);
                sVNPatchTarget.executable = SVNFileUtil.isExecutable(sVNPatchTarget.absPath);
            }
            sVNPatchTarget.patchedPath = SVNFileUtil.createTempFile("", null);
            sVNPatchTarget.patchedRaw = SVNFileUtil.openFileForWriting(sVNPatchTarget.patchedPath);
            sVNPatchTarget.patched = SVNTranslator.getTranslatingOutputStream(sVNPatchTarget.patchedRaw, null, sVNPatchTarget.eolStr.getBytes(), sVNPatchTarget.eolStyle != null, sVNPatchTarget.keywords, true);
            sVNPatchTarget.rejectPath = SVNFileUtil.createTempFile("", null);
            sVNPatchTarget.reject = SVNPatchFileStream.openForWrite(sVNPatchTarget.rejectPath);
            object = "--- " + sVNPatchTarget.canonPathFromPatchfile + string + "+++ " + sVNPatchTarget.canonPathFromPatchfile + string;
            sVNPatchTarget.reject.write((String)object);
        }
        sVNPatchTarget.patch = sVNPatch;
        sVNPatchTarget.currentLine = 1;
        sVNPatchTarget.modified = false;
        sVNPatchTarget.hadRejects = false;
        sVNPatchTarget.deleted = false;
        sVNPatchTarget.eof = false;
        sVNPatchTarget.lines = new ArrayList();
        sVNPatchTarget.hunks = new ArrayList();
        return sVNPatchTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String detectFileEOL(RandomAccessFile randomAccessFile) {
        long l2 = randomAccessFile.getFilePointer();
        try {
            int n2;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(randomAccessFile.getFD()));
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = bufferedInputStream.read()) > 0) {
                char c2;
                int n3;
                char c3 = (char)n2;
                if (c3 != '\n' && c3 != '\r') continue;
                stringBuffer.append(c3);
                if (c3 == '\r' && (n3 = bufferedInputStream.read()) > 0 && (c2 = (char)n3) == '\n') {
                    stringBuffer.append(c2);
                }
                String string = stringBuffer.toString();
                return string;
            }
        }
        finally {
            randomAccessFile.seek(l2);
        }
        return null;
    }

    private void resolveTargetPath(File file, File file2, int n2, SVNAdminArea sVNAdminArea) {
        SVNPatchTarget sVNPatchTarget = this;
        sVNPatchTarget.canonPathFromPatchfile = file;
        if ("".equals(sVNPatchTarget.canonPathFromPatchfile.getPath())) {
            sVNPatchTarget.skipped = true;
            sVNPatchTarget.kind = SVNNodeKind.FILE;
            sVNPatchTarget.absPath = null;
            sVNPatchTarget.relPath = null;
            return;
        }
        File file3 = n2 > 0 ? SVNPatchTarget.stripPath(sVNPatchTarget.canonPathFromPatchfile, n2) : sVNPatchTarget.canonPathFromPatchfile;
        if (file3.isAbsolute()) {
            sVNPatchTarget.relPath = this.getChildPath(file2, file3);
            if (null == sVNPatchTarget.relPath) {
                sVNPatchTarget.skipped = true;
                sVNPatchTarget.kind = SVNNodeKind.FILE;
                sVNPatchTarget.absPath = null;
                sVNPatchTarget.relPath = file3;
                return;
            }
        } else {
            sVNPatchTarget.relPath = file3;
        }
        if (!SVNPatchTarget.isChildPath(file2, sVNPatchTarget.relPath)) {
            sVNPatchTarget.skipped = true;
            sVNPatchTarget.kind = SVNNodeKind.FILE;
            sVNPatchTarget.absPath = null;
            return;
        }
        sVNPatchTarget.absPath = new File(file2, sVNPatchTarget.relPath.getPath());
        SVNStatus sVNStatus = SVNStatusUtil.getStatus(sVNPatchTarget.absPath, sVNAdminArea.getWCAccess());
        SVNStatusType sVNStatusType = sVNStatus.getContentsStatus();
        if (sVNStatusType == SVNStatusType.STATUS_UNVERSIONED || sVNStatusType == SVNStatusType.STATUS_IGNORED || sVNStatusType == SVNStatusType.STATUS_OBSTRUCTED) {
            sVNPatchTarget.skipped = true;
            sVNPatchTarget.kind = SVNFileType.getNodeKind(SVNFileType.getType(sVNPatchTarget.absPath));
            return;
        }
        sVNPatchTarget.kind = sVNStatus.getKind();
        if (SVNNodeKind.FILE.equals(sVNPatchTarget.kind)) {
            sVNPatchTarget.added = false;
            sVNPatchTarget.parentDirExists = true;
        } else if (SVNNodeKind.NONE.equals(sVNPatchTarget.kind) || SVNNodeKind.UNKNOWN.equals(sVNPatchTarget.kind)) {
            sVNPatchTarget.added = true;
            File file4 = sVNPatchTarget.absPath.getParentFile();
            SVNStatus sVNStatus2 = SVNStatusUtil.getStatus(file4, sVNAdminArea.getWCAccess());
            SVNStatusType sVNStatusType2 = sVNStatus2.getContentsStatus();
            SVNNodeKind sVNNodeKind = sVNStatus2.getKind();
            sVNPatchTarget.parentDirExists = sVNNodeKind == SVNNodeKind.DIR && sVNStatusType2 != SVNStatusType.STATUS_DELETED && sVNStatusType2 != SVNStatusType.STATUS_MISSING;
        } else {
            sVNPatchTarget.skipped = true;
        }
    }

    public static boolean isChildPath(File file, File file2) {
        if (null != file2 && file != null) {
            String string = file.getCanonicalPath();
            File file3 = new File(string, file2.getPath());
            String string2 = file3.getCanonicalPath();
            return string2.startsWith(string) && string2.length() > string.length();
        }
        return false;
    }

    private File getChildPath(File file, File file2) {
        if (null != file2 && file != null) {
            String string = file.getCanonicalPath();
            String string2 = file2.getCanonicalPath();
            if (string2.startsWith(string) && string2.length() > string.length()) {
                String string3 = string2.substring(string.length());
                File file3 = new File(string3);
                if (!file3.isAbsolute()) {
                    return file3;
                }
                if (string3.length() > 1 && !(file3 = new File(string3 = string3.substring(1))).isAbsolute()) {
                    return file3;
                }
            }
        }
        return null;
    }

    public static File stripPath(File file, int n2) {
        if (file != null && n2 > 0) {
            String[] stringArray = SVNPatchTarget.decomposePath(file);
            StringBuffer stringBuffer = new StringBuffer();
            if (n2 <= stringArray.length) {
                for (int i2 = n2; i2 < stringArray.length; ++i2) {
                    if (i2 > n2) {
                        stringBuffer.append(File.separatorChar);
                    }
                    stringBuffer.append(stringArray[i2]);
                }
                return new File(stringBuffer.toString());
            }
        }
        return file;
    }

    public void rejectHunk(SVNPatchHunkInfo sVNPatchHunkInfo) {
        boolean bl2;
        SVNPatchTarget sVNPatchTarget = this;
        SVNPatchHunk sVNPatchHunk = sVNPatchHunkInfo.getHunk();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@@");
        stringBuffer.append(" -").append(sVNPatchHunk.getOriginal().getStart()).append(",").append(sVNPatchHunk.getOriginal().getLength());
        stringBuffer.append(" +").append(sVNPatchHunk.getModified().getStart()).append(",").append(sVNPatchHunk.getModified().getLength());
        stringBuffer.append(" ").append(sVNPatchTarget.eolStr);
        sVNPatchTarget.reject.write(stringBuffer);
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        do {
            stringBuffer2.setLength(0);
            stringBuffer3.setLength(0);
            bl2 = sVNPatchHunk.getDiffText().readLineWithEol(stringBuffer2, stringBuffer3);
            if (bl2) continue;
            if (stringBuffer2.length() > 0) {
                sVNPatchTarget.reject.tryWrite(stringBuffer2);
            }
            if (stringBuffer3.length() <= 0) continue;
            sVNPatchTarget.reject.tryWrite(stringBuffer3);
        } while (!bl2);
        sVNPatchTarget.hadRejects = true;
    }

    public void applyHunk(SVNPatchHunkInfo sVNPatchHunkInfo) {
        SVNPatchTarget sVNPatchTarget = this;
        SVNPatchHunk sVNPatchHunk = sVNPatchHunkInfo.getHunk();
        if (sVNPatchTarget.kind == SVNNodeKind.FILE) {
            sVNPatchTarget.copyLinesToTarget(sVNPatchHunkInfo.getMatchedLine() + sVNPatchHunkInfo.getFuzz());
            sVNPatchTarget.seekToLine(sVNPatchTarget.getCurrentLine() + sVNPatchHunk.getOriginal().getLength() - 2 * sVNPatchHunkInfo.getFuzz());
        }
        long l2 = 0L;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        do {
            if ((bl2 = sVNPatchHunk.getModifiedText().readLineWithEol(stringBuffer, stringBuffer2)) || ++l2 <= (long)sVNPatchHunkInfo.getFuzz() || l2 > (long)(sVNPatchHunk.getModified().getLength() - sVNPatchHunkInfo.getFuzz())) continue;
            if (stringBuffer.length() > 0) {
                this.tryWrite(sVNPatchTarget.getPatched(), stringBuffer);
            }
            if (stringBuffer2.length() <= 0) continue;
            this.tryWrite(sVNPatchTarget.getPatched(), stringBuffer2);
        } while (!bl2);
    }

    public void seekToLine(int n2) {
        Object object;
        if (n2 <= 0) {
            object = SVNErrorMessage.create(SVNErrorCode.ASSERTION_FAIL, "Line to seek must be more than zero");
            SVNErrorManager.error((SVNErrorMessage)object, Level.FINE, SVNLogType.WC);
        }
        object = this;
        if (n2 == ((SVNPatchTarget)object).currentLine) {
            return;
        }
        if (n2 <= ((SVNPatchTarget)object).lines.size()) {
            Long l2 = (Long)((SVNPatchTarget)object).lines.get(n2 - 1);
            ((SVNPatchTarget)object).stream.setSeekPosition(l2);
            ((SVNPatchTarget)object).currentLine = n2;
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            while (((SVNPatchTarget)object).currentLine < n2) {
                ((SVNPatchTarget)object).readLine(stringBuffer);
            }
        }
    }

    public void readLine(StringBuffer stringBuffer) {
        Serializable serializable;
        SVNPatchTarget sVNPatchTarget = this;
        if (sVNPatchTarget.eof) {
            return;
        }
        if (sVNPatchTarget.currentLine > sVNPatchTarget.lines.size() + 1) {
            serializable = SVNErrorMessage.create(SVNErrorCode.ASSERTION_FAIL, "Lines reading isn't sequenced");
            SVNErrorManager.error((SVNErrorMessage)serializable, Level.FINE, SVNLogType.WC);
        }
        if (sVNPatchTarget.currentLine == sVNPatchTarget.lines.size() + 1) {
            serializable = Long.valueOf(sVNPatchTarget.stream.getSeekPosition());
            sVNPatchTarget.lines.add(serializable);
        }
        serializable = new StringBuffer();
        sVNPatchTarget.eof = sVNPatchTarget.stream.readLine((StringBuffer)serializable, sVNPatchTarget.eolStr);
        byte[] byArray = sVNPatchTarget.eolStr.getBytes();
        stringBuffer.append(SVNTranslator.translateString(((StringBuffer)serializable).toString(), byArray, sVNPatchTarget.keywords, false, false));
        ++sVNPatchTarget.currentLine;
    }

    public void copyLinesToTarget(int n2) {
        SVNPatchTarget sVNPatchTarget = this;
        while (!(sVNPatchTarget.currentLine >= n2 && n2 != 0 || sVNPatchTarget.eof)) {
            StringBuffer stringBuffer = new StringBuffer();
            sVNPatchTarget.readLine(stringBuffer);
            if (!sVNPatchTarget.eof) {
                stringBuffer.append(sVNPatchTarget.eolStr);
            }
            this.tryWrite(sVNPatchTarget.patched, stringBuffer);
        }
    }

    public void installPatchedTarget(File file, boolean bl2, SVNAdminArea sVNAdminArea) {
        Object object;
        SVNPatchTarget sVNPatchTarget = this;
        if (sVNPatchTarget.deleted) {
            if (!bl2) {
                SVNWCManager.delete(sVNAdminArea.getWCAccess(), sVNAdminArea, sVNPatchTarget.getAbsPath(), false, false);
            }
        } else {
            if (sVNPatchTarget.isAdded() && !sVNPatchTarget.isParentDirExists()) {
                Object object2;
                String string;
                int n2;
                object = file;
                String[] stringArray = SVNPatchTarget.decomposePath(sVNPatchTarget.getRelPath());
                int n3 = 0;
                for (n2 = 0; n2 < stringArray.length - 1; ++n2) {
                    SVNNodeKind sVNNodeKind;
                    string = stringArray[n2];
                    object = new File((File)object, string);
                    object2 = sVNAdminArea.getWCAccess().getEntry((File)object, false);
                    SVNNodeKind sVNNodeKind2 = sVNNodeKind = object2 != null ? ((SVNEntry)object2).getKind() : null;
                    if (sVNNodeKind == SVNNodeKind.FILE) {
                        sVNPatchTarget.skipped = true;
                        break;
                    }
                    if (sVNNodeKind == SVNNodeKind.DIR) {
                        if (((SVNEntry)object2).isDeleted()) {
                            sVNPatchTarget.skipped = true;
                            break;
                        }
                        ++n3;
                        continue;
                    }
                    SVNFileType sVNFileType = SVNFileType.getType((File)object);
                    if (sVNFileType == SVNFileType.NONE) continue;
                    sVNPatchTarget.skipped = true;
                    break;
                }
                if (!sVNPatchTarget.isSkipped()) {
                    object = file;
                    for (n2 = 0; n2 < n3; ++n2) {
                        string = stringArray[n2];
                        object = new File((File)object, string);
                        if (bl2) {
                            object2 = SVNEventFactory.createSVNEvent((File)object, SVNNodeKind.NONE, null, -1L, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.ADD, null, null, null);
                            sVNAdminArea.getWCAccess().handleEvent((SVNEvent)object2);
                            continue;
                        }
                        if (!((File)object).mkdirs()) continue;
                        SVNWCManager.add((File)object, sVNAdminArea, null, -1L, SVNDepth.INFINITY);
                    }
                }
            }
            if (!bl2 && !sVNPatchTarget.isSkipped()) {
                SVNFileUtil.copyFile(sVNPatchTarget.getPatchedPath(), sVNPatchTarget.getAbsPath(), false);
                if (sVNPatchTarget.isAdded()) {
                    SVNWCManager.add(sVNPatchTarget.getAbsPath(), sVNAdminArea, null, -1L, SVNDepth.INFINITY);
                }
                SVNFileUtil.setExecutable(sVNPatchTarget.getAbsPath(), sVNPatchTarget.isExecutable());
            }
        }
        if (!bl2 && !sVNPatchTarget.skipped && sVNPatchTarget.hadRejects) {
            object = sVNPatchTarget.getAbsPath().getPath() + ".svnpatch.rej";
            SVNFileUtil.copyFile(sVNPatchTarget.getRejectPath(), new File((String)object), true);
        }
    }

    public static String[] decomposePath(File file) {
        String string = SVNFileUtil.getFilePath(file);
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string.split(String.valueOf(File.separatorChar));
    }

    public static SVNPatchTarget applyPatch(SVNPatch sVNPatch, File file, int n2, SVNAdminArea sVNAdminArea) {
        SVNPatchTarget sVNPatchTarget = SVNPatchTarget.initPatchTarget(sVNPatch, file, n2, sVNAdminArea);
        if (sVNPatchTarget.skipped) {
            return sVNPatchTarget;
        }
        for (Object object : sVNPatch.getHunks()) {
            SVNPatchHunkInfo sVNPatchHunkInfo;
            int n3 = 0;
            while ((sVNPatchHunkInfo = sVNPatchTarget.getHunkInfo((SVNPatchHunk)object, n3)).isRejected() && ++n3 <= 2) {
            }
            sVNPatchTarget.hunks.add(sVNPatchHunkInfo);
        }
        for (Object object : sVNPatchTarget.hunks) {
            if (((SVNPatchHunkInfo)object).isRejected()) {
                sVNPatchTarget.rejectHunk((SVNPatchHunkInfo)object);
                continue;
            }
            sVNPatchTarget.applyHunk((SVNPatchHunkInfo)object);
        }
        if (sVNPatchTarget.kind == SVNNodeKind.FILE) {
            sVNPatchTarget.copyLinesToTarget(0);
            if (!sVNPatchTarget.eof) {
                sVNPatchTarget.skipped = true;
            }
        }
        if (sVNPatchTarget.getKind() == SVNNodeKind.FILE) {
            sVNPatchTarget.stream.close();
        }
        sVNPatchTarget.patched.close();
        sVNPatchTarget.reject.close();
        if (!sVNPatchTarget.skipped) {
            long l2;
            long l3 = sVNPatchTarget.patchedPath.length();
            long l4 = l2 = sVNPatchTarget.kind == SVNNodeKind.FILE ? sVNPatchTarget.absPath.length() : 0L;
            if (l3 == 0L && l2 > 0L) {
                sVNPatchTarget.deleted = sVNPatchTarget.kind != SVNNodeKind.NONE;
            } else if (l2 == 0L && l3 == 0L) {
                if (sVNPatchTarget.kind != SVNNodeKind.FILE) {
                    sVNPatchTarget.skipped = true;
                }
            } else if (sVNPatchTarget.kind != SVNNodeKind.FILE && l3 > 0L) {
                sVNPatchTarget.added = true;
            }
        }
        return sVNPatchTarget;
    }

    public SVNPatchHunkInfo getHunkInfo(SVNPatchHunk sVNPatchHunk, int n2) {
        int n3;
        SVNPatchTarget sVNPatchTarget = this;
        if (sVNPatchHunk.getOriginal().getStart() == 0) {
            n3 = sVNPatchTarget.getKind() == SVNNodeKind.FILE ? 0 : 1;
        } else if (sVNPatchHunk.getOriginal().getStart() > 0 && sVNPatchTarget.getKind() == SVNNodeKind.FILE) {
            int n4 = sVNPatchTarget.getCurrentLine();
            boolean bl2 = sVNPatchTarget.isEof();
            sVNPatchTarget.seekToLine(sVNPatchHunk.getOriginal().getStart());
            n3 = sVNPatchTarget.scanForMatch(sVNPatchHunk, true, sVNPatchHunk.getOriginal().getStart() + 1, n2);
            if (n3 != sVNPatchHunk.getOriginal().getStart()) {
                sVNPatchTarget.seekToLine(1);
                n3 = sVNPatchTarget.scanForMatch(sVNPatchHunk, false, sVNPatchHunk.getOriginal().getStart(), n2);
                if (n3 == 0) {
                    n3 = sVNPatchTarget.scanForMatch(sVNPatchHunk, true, 0, n2);
                }
            }
            sVNPatchTarget.seekToLine(n4);
            sVNPatchTarget.eof = bl2;
        } else {
            n3 = 0;
        }
        return new SVNPatchHunkInfo(sVNPatchHunk, n3, n3 == 0, n2);
    }

    public int scanForMatch(SVNPatchHunk sVNPatchHunk, boolean bl2, int n2, int n3) {
        SVNPatchTarget sVNPatchTarget = this;
        int n4 = 0;
        while (!(sVNPatchTarget.currentLine >= n2 && n2 != 0 || sVNPatchTarget.eof)) {
            boolean bl3 = sVNPatchTarget.matchHunk(sVNPatchHunk, n3);
            if (bl3) {
                SVNPatchHunkInfo sVNPatchHunkInfo;
                boolean bl4 = false;
                Iterator iterator = sVNPatchTarget.hunks.iterator();
                while (iterator.hasNext() && !(bl4 = !(sVNPatchHunkInfo = (SVNPatchHunkInfo)iterator.next()).isRejected() && sVNPatchTarget.currentLine >= sVNPatchHunkInfo.getMatchedLine() && sVNPatchTarget.currentLine < sVNPatchHunkInfo.getMatchedLine() + sVNPatchHunkInfo.getHunk().getOriginal().getLength())) {
                }
                if (!bl4) {
                    n4 = sVNPatchTarget.currentLine;
                    if (bl2) break;
                }
            }
            sVNPatchTarget.seekToLine(sVNPatchTarget.currentLine + 1);
        }
        return n4;
    }

    private boolean matchHunk(SVNPatchHunk sVNPatchHunk, int n2) {
        boolean bl2;
        SVNPatchTarget sVNPatchTarget = this;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        boolean bl3 = false;
        if (sVNPatchTarget.eof) {
            return bl3;
        }
        int n3 = sVNPatchTarget.currentLine;
        int n4 = 0;
        boolean bl4 = false;
        sVNPatchHunk.getOriginalText().reset();
        do {
            stringBuffer.setLength(0);
            stringBuffer3.setLength(0);
            bl2 = sVNPatchHunk.getOriginalText().readLineWithEol(stringBuffer, stringBuffer3);
            byte[] byArray = stringBuffer3.toString().getBytes();
            String string = SVNTranslator.translateString(stringBuffer.toString(), byArray, sVNPatchTarget.keywords, false, false);
            ++n4;
            stringBuffer2.setLength(0);
            sVNPatchTarget.readLine(stringBuffer2);
            if (bl2) continue;
            bl4 = n4 <= n2 && sVNPatchHunk.getLeadingContext() > (long)n2 ? true : (n4 > sVNPatchHunk.getOriginal().getLength() - n2 && sVNPatchHunk.getTrailingContext() > (long)n2 ? true : string.equals(stringBuffer2.toString()));
        } while (bl4 && !bl2 && !sVNPatchTarget.eof);
        if (bl2) {
            bl3 = bl4;
        } else if (sVNPatchTarget.eof) {
            bl2 = sVNPatchHunk.getOriginalText().readLineWithEol(stringBuffer, null);
            bl3 = stringBuffer.length() == 0 && bl2 ? bl4 : false;
        }
        sVNPatchTarget.seekToLine(n3);
        sVNPatchTarget.eof = false;
        return bl3;
    }

    private void tryWrite(OutputStream outputStream, StringBuffer stringBuffer) {
        outputStream.write(stringBuffer.toString().getBytes());
    }

    public void sendPatchNotification(SVNAdminArea sVNAdminArea) {
        SVNPatchTarget sVNPatchTarget = this;
        ISVNEventHandler iSVNEventHandler = sVNAdminArea.getWCAccess().getEventHandler();
        if (iSVNEventHandler == null) {
            return;
        }
        SVNEventAction sVNEventAction = sVNPatchTarget.skipped ? SVNEventAction.SKIP : (sVNPatchTarget.deleted ? SVNEventAction.DELETE : (sVNPatchTarget.added ? SVNEventAction.ADD : SVNEventAction.PATCH));
        SVNStatusType sVNStatusType = SVNStatusType.INAPPLICABLE;
        sVNStatusType = sVNEventAction == SVNEventAction.SKIP ? (sVNPatchTarget.parentDirExists && (sVNPatchTarget.kind == SVNNodeKind.NONE || sVNPatchTarget.kind == SVNNodeKind.UNKNOWN) ? SVNStatusType.MISSING : (sVNPatchTarget.kind == SVNNodeKind.DIR ? SVNStatusType.OBSTRUCTED : SVNStatusType.UNKNOWN)) : (sVNPatchTarget.hadRejects ? SVNStatusType.CONFLICTED : (sVNPatchTarget.localMods ? SVNStatusType.MERGED : SVNStatusType.CHANGED));
        SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(sVNPatchTarget.absPath != null ? sVNPatchTarget.absPath : sVNPatchTarget.relPath, sVNPatchTarget.kind, null, 0L, sVNStatusType, SVNStatusType.INAPPLICABLE, SVNStatusType.LOCK_INAPPLICABLE, sVNEventAction, null, null, null);
        iSVNEventHandler.handleEvent(sVNEvent, -1.0);
        if (sVNEventAction == SVNEventAction.PATCH) {
            for (SVNPatchHunkInfo sVNPatchHunkInfo : sVNPatchTarget.hunks) {
                sVNEventAction = sVNPatchHunkInfo.isRejected() ? SVNEventAction.PATCH_REJECTED_HUNK : SVNEventAction.PATCH_APPLIED_HUNK;
                SVNEvent sVNEvent2 = SVNEventFactory.createSVNEvent(sVNPatchTarget.absPath != null ? sVNPatchTarget.absPath : sVNPatchTarget.relPath, sVNPatchTarget.kind, null, 0L, sVNEventAction, null, null, null);
                sVNEvent2.setInfo(sVNPatchHunkInfo);
                iSVNEventHandler.handleEvent(sVNEvent2, -1.0);
            }
        }
    }
}

