/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.patch;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.util.BufferedRandomAccessFile;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchFileStream$SVNPatchFileLineFilter;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchFileStream$SVNPatchFileLineTransformer;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPatchFileStream {
    private File path;
    private boolean write;
    private long start = 0L;
    private long end = -1L;
    private RandomAccessFile file;
    private BufferedRandomAccessFile bufferedFile;
    private SVNPatchFileStream$SVNPatchFileLineFilter lineFilter;
    private SVNPatchFileStream$SVNPatchFileLineTransformer lineTransformer;

    private SVNPatchFileStream(File file, boolean bl2, long l2, long l3) {
        this(file, bl2);
        if (l2 < 0L || l3 < 0L || l2 > l3) {
            throw new IllegalArgumentException("Bad start or end");
        }
        this.start = l2;
        this.end = l3;
    }

    private SVNPatchFileStream(File file, boolean bl2) {
        if (file == null) {
            throw new IllegalArgumentException("Bad path");
        }
        this.path = file;
        this.write = bl2;
    }

    public static SVNPatchFileStream openReadOnly(File file) {
        SVNPatchFileStream sVNPatchFileStream = new SVNPatchFileStream(file, false);
        sVNPatchFileStream.reset();
        return sVNPatchFileStream;
    }

    public static SVNPatchFileStream openRangeReadOnly(File file, long l2, long l3) {
        SVNPatchFileStream sVNPatchFileStream = new SVNPatchFileStream(file, false, l2, l3);
        sVNPatchFileStream.reset();
        return sVNPatchFileStream;
    }

    public static SVNPatchFileStream openForWrite(File file) {
        SVNPatchFileStream sVNPatchFileStream = new SVNPatchFileStream(file, true);
        sVNPatchFileStream.reset();
        return sVNPatchFileStream;
    }

    public File getPath() {
        return this.path;
    }

    public void setLineFilter(SVNPatchFileStream$SVNPatchFileLineFilter sVNPatchFileStream$SVNPatchFileLineFilter) {
        this.lineFilter = sVNPatchFileStream$SVNPatchFileLineFilter;
    }

    public void setLineTransformer(SVNPatchFileStream$SVNPatchFileLineTransformer sVNPatchFileLineTransformer) {
        this.lineTransformer = sVNPatchFileLineTransformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessFile getFile() {
        if (this.file == null) {
            SVNPatchFileStream sVNPatchFileStream = this;
            synchronized (sVNPatchFileStream) {
                if (this.file == null) {
                    if (this.write) {
                        this.file = SVNFileUtil.openRAFileForWriting(this.path, false);
                        this.bufferedFile = null;
                    } else {
                        this.file = SVNFileUtil.openRAFileForReading(this.path);
                        this.bufferedFile = new BufferedRandomAccessFile(this.file);
                    }
                }
            }
        }
        return this.file;
    }

    public void reset() {
        RandomAccessFile randomAccessFile = this.getFile();
        if (this.start != randomAccessFile.getFilePointer()) {
            randomAccessFile.seek(this.start);
        }
    }

    public void close() {
        if (this.file != null) {
            this.file.close();
        }
    }

    public boolean isEOF() {
        RandomAccessFile randomAccessFile = this.getFile();
        return randomAccessFile.getFilePointer() >= (this.end > 0L ? this.end : randomAccessFile.length());
    }

    public long getSeekPosition() {
        RandomAccessFile randomAccessFile = this.getFile();
        return randomAccessFile.getFilePointer();
    }

    public void setSeekPosition(long l2) {
        this.checkPos(l2);
        RandomAccessFile randomAccessFile = this.getFile();
        randomAccessFile.seek(l2);
    }

    private void checkPos(long l2) {
        if (!this.isPosValid(l2)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Bad position for file ''{0}'': {1}. Range is {2}..{3}.", this.path, l2, this.start, this.end);
            SVNErrorManager.error(sVNErrorMessage, Level.FINE, SVNLogType.DEFAULT);
        }
    }

    private boolean isPosValid(long l2) {
        return this.start <= l2 && (this.end <= 0L || l2 <= this.end);
    }

    public void write(String string) {
        RandomAccessFile randomAccessFile = this.getFile();
        long l2 = randomAccessFile.getFilePointer();
        this.checkPos(l2 + (long)string.length());
        randomAccessFile.write(string.getBytes());
    }

    public void write(StringBuffer stringBuffer) {
        this.write(stringBuffer.toString());
    }

    public void tryWrite(StringBuffer stringBuffer) {
        this.write(stringBuffer);
    }

    public boolean readLineWithEol(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        return this.readLine(stringBuffer, stringBuffer2, true);
    }

    public boolean readLine(StringBuffer stringBuffer) {
        return this.readLine(stringBuffer, null);
    }

    public boolean readLine(StringBuffer stringBuffer, String string) {
        StringBuffer stringBuffer2 = string != null ? new StringBuffer(string) : null;
        return this.readLine(stringBuffer, stringBuffer2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readLine(StringBuffer stringBuffer, StringBuffer stringBuffer2, boolean bl2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.bufferedFile.loadPosition();
        try {
            int n2;
            boolean bl3;
            do {
                n2 = -1;
                boolean bl4 = false;
                bl3 = false;
                byteArrayOutputStream.reset();
                if (stringBuffer2 != null) {
                    stringBuffer2.setLength(0);
                }
                block13: while (!bl4) {
                    n2 = this.bufferedFile.read();
                    switch (n2) {
                        case -1: {
                            bl4 = true;
                            continue block13;
                        }
                        case 10: {
                            if (bl2 && stringBuffer2 != null) {
                                stringBuffer2.append((char)n2);
                            }
                            bl4 = true;
                            continue block13;
                        }
                        case 13: {
                            if (bl2 && stringBuffer2 != null) {
                                stringBuffer2.append((char)n2);
                            }
                            long l2 = this.bufferedFile.getFilePointer();
                            int n3 = this.bufferedFile.read();
                            if (n3 != 10) {
                                this.bufferedFile.seek(l2);
                            } else if (bl2 && stringBuffer2 != null) {
                                stringBuffer2.append((char)n3);
                            }
                            bl4 = true;
                            continue block13;
                        }
                    }
                    byteArrayOutputStream.write(n2);
                }
                if (this.lineFilter == null || !(bl3 = this.lineFilter.lineFilter(byteArrayOutputStream.toString("UTF-8")))) continue;
                byteArrayOutputStream.reset();
            } while (bl3 && !this.isEOF());
            if (this.lineTransformer != null) {
                String string = this.lineTransformer.lineTransformer(byteArrayOutputStream.toString("UTF-8"));
                byteArrayOutputStream.reset();
                byteArrayOutputStream.write(string.getBytes("UTF-8"));
            }
            stringBuffer.append(byteArrayOutputStream.toString("UTF-8"));
            boolean bl5 = byteArrayOutputStream.size() == 0 && n2 == -1 && this.isEOF();
            return bl5;
        }
        finally {
            try {
                this.bufferedFile.savePosition();
            }
            catch (Throwable throwable) {}
        }
    }
}

