/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.patch;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchFileStream;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchHunk;

public class SVNPatch {
    public static final String MINUS = "--- ";
    public static final String PLUS = "+++ ";
    public static final String ATAT = "@@";
    private File path;
    private SVNPatchFileStream patchFile;
    private File oldFilename;
    private File newFilename;
    private List hunks;

    public File getPath() {
        return this.path;
    }

    public SVNPatchFileStream getPatchFile() {
        return this.patchFile;
    }

    public File getOldFilename() {
        return this.oldFilename;
    }

    public File getNewFilename() {
        return this.newFilename;
    }

    public List getHunks() {
        return this.hunks;
    }

    public void close() {
        int n2;
        if (this.hunks != null && (n2 = this.hunks.size()) > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                SVNPatchHunk sVNPatchHunk = (SVNPatchHunk)this.hunks.get(i2);
                sVNPatchHunk.close();
            }
        }
    }

    public static SVNPatch parseNextPatch(SVNPatchFileStream sVNPatchFileStream) {
        Object object;
        if (sVNPatchFileStream.isEOF()) {
            return null;
        }
        File file = sVNPatchFileStream.getPath();
        SVNPatch sVNPatch = new SVNPatch();
        sVNPatch.patchFile = sVNPatchFileStream;
        sVNPatch.path = file;
        String string = MINUS;
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            stringBuffer.setLength(0);
            bl2 = sVNPatchFileStream.readLine(stringBuffer);
            object = stringBuffer.toString();
            if (bl2 || ((String)object).length() <= string.length() || !((String)object).startsWith(string)) continue;
            int n2 = ((String)object).indexOf(9);
            File file2 = new File(((String)object).substring(string.length(), n2 > 0 ? n2 : ((String)object).length()));
            if (!bl3 && MINUS.equals(string)) {
                sVNPatch.oldFilename = file2;
                string = PLUS;
                bl3 = true;
                continue;
            }
            if (bl3 && PLUS.equals(string)) {
                sVNPatch.newFilename = file2;
                bl3 = false;
                break;
            }
            bl3 = false;
        } while (!bl2);
        if (sVNPatch.oldFilename == null || sVNPatch.newFilename == null) {
            return null;
        }
        sVNPatch.hunks = new ArrayList(10);
        do {
            if ((object = SVNPatchHunk.parseNextHunk(sVNPatch)) == null) continue;
            sVNPatch.hunks.add(object);
        } while (object != null);
        Collections.sort(sVNPatch.hunks, SVNPatchHunk.COMPARATOR);
        return sVNPatch;
    }
}

