/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNXMLAdminArea;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNXMLAdminAreaFactory
extends SVNAdminAreaFactory {
    public static final int WC_FORMAT = 4;

    @Override
    protected void doCreateVersionedDirectory(File file, String string, String string2, String string3, long l2, SVNDepth sVNDepth) {
        SVNXMLAdminArea sVNXMLAdminArea = new SVNXMLAdminArea(file);
        sVNXMLAdminArea.createVersionedDirectory(file, string, string2, string3, l2, true, sVNDepth);
    }

    @Override
    protected SVNAdminArea doOpen(File file, int n2) {
        if (n2 != 4) {
            return null;
        }
        return new SVNXMLAdminArea(file);
    }

    @Override
    protected SVNAdminArea doChangeWCFormat(SVNAdminArea sVNAdminArea) {
        if (sVNAdminArea == null || sVNAdminArea.getClass() == SVNXMLAdminArea.class) {
            return sVNAdminArea;
        }
        SVNXMLAdminArea sVNXMLAdminArea = new SVNXMLAdminArea(sVNAdminArea.getRoot());
        sVNXMLAdminArea.setLocked(true);
        return sVNXMLAdminArea.formatWC(sVNAdminArea);
    }

    @Override
    public int getSupportedVersion() {
        return 4;
    }

    /*
     * Loose catch block
     */
    @Override
    protected int doCheckWC(File file, Level level) {
        SVNErrorMessage sVNErrorMessage;
        File file2 = new File(file, SVNFileUtil.getAdminDirectoryName());
        File file3 = new File(file2, "format");
        int n2 = -1;
        BufferedReader bufferedReader = null;
        String string = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(file3, level, SVNLogType.WC), "UTF-8"));
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read entries file ''{0}'': {1}", file3, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
            SVNFileUtil.closeFile(bufferedReader);
        }
        catch (SVNException sVNException) {
            block13: {
                SVNErrorMessage sVNErrorMessage2;
                SVNFileType sVNFileType = SVNFileType.getType(file);
                if (sVNFileType == SVNFileType.DIRECTORY && file3.isFile()) break block13;
                if (sVNFileType == SVNFileType.NONE) {
                    sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "''{0}'' does not exist", (Object)file);
                    SVNErrorManager.error(sVNErrorMessage2, SVNLogType.WC);
                } else if (!file3.isFile() && file2.isDirectory()) {
                    sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "File ''{0}'' does not exist", (Object)file3);
                    SVNErrorManager.error(sVNErrorMessage2, SVNLogType.WC);
                }
                int n3 = 0;
                {
                    catch (Throwable throwable) {
                        SVNFileUtil.closeFile(bufferedReader);
                        throw throwable;
                    }
                }
                SVNFileUtil.closeFile(bufferedReader);
                return n3;
            }
            throw sVNException;
        }
        SVNFileUtil.closeFile(bufferedReader);
        if (string == null || string.length() == 0) {
            SVNErrorMessage sVNErrorMessage3 = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF, "Reading ''{0}''", (Object)file3);
            SVNErrorManager.error(sVNErrorMessage3, SVNLogType.WC);
        }
        try {
            n2 = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "First line of ''{0}'' contains non-digit", (Object)file3);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected int getVersion(File file) {
        SVNErrorMessage sVNErrorMessage;
        File file2 = new File(file, SVNFileUtil.getAdminDirectoryName());
        File file3 = new File(file2, "format");
        BufferedReader bufferedReader = null;
        String string = null;
        int n2 = -1;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(file3, Level.FINEST, SVNLogType.WC), "UTF-8"));
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read format file ''{0}'': {1}", file3, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
            SVNFileUtil.closeFile(bufferedReader);
        }
        catch (SVNException sVNException) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)file);
            sVNErrorMessage.setChildErrorMessage(sVNException.getErrorMessage());
            SVNErrorManager.error(sVNErrorMessage, sVNException, Level.FINEST, SVNLogType.WC);
            {
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(bufferedReader);
                    throw throwable;
                }
            }
            SVNFileUtil.closeFile(bufferedReader);
        }
        SVNFileUtil.closeFile(bufferedReader);
        if (string == null || string.length() == 0) {
            SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF, "Reading ''{0}''", (Object)file3);
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)file);
            sVNErrorMessage.setChildErrorMessage(sVNErrorMessage2);
            SVNErrorManager.error(sVNErrorMessage, Level.FINEST, SVNLogType.WC);
        }
        try {
            n2 = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "First line of ''{0}'' contains non-digit", (Object)file3);
            SVNErrorMessage sVNErrorMessage3 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)file);
            sVNErrorMessage3.setChildErrorMessage(sVNErrorMessage);
            SVNErrorManager.error(sVNErrorMessage3, Level.FINEST, SVNLogType.WC);
        }
        return n2;
    }
}

