/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry16;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNProperties13;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNXMLAdminArea
extends SVNAdminArea {
    public static final int WC_FORMAT = 4;
    private static final String THIS_DIR = "";
    private static final Set BOOLEAN_PROPERTIES = new SVNHashSet();
    private static final Set INAPPLICABLE_PROPERTIES = new SVNHashSet();
    private File myLockFile = new File(this.getAdminDirectory(), "lock");
    private File myEntriesFile = new File(this.getAdminDirectory(), "entries");

    public SVNXMLAdminArea(File file) {
        super(file);
    }

    private void saveProperties(SVNLog sVNLog) {
        Map map = this.getPropertiesStorage(false);
        if (map == null || map.isEmpty()) {
            return;
        }
        SVNProperties sVNProperties = new SVNProperties();
        for (String string : map.keySet()) {
            SVNVersionedProperties sVNVersionedProperties = (SVNVersionedProperties)map.get(string);
            if (!sVNVersionedProperties.isModified()) continue;
            String string2 = this.getThisDirName().equals(string) ? "dir-props" : "props/" + string + ".svn-work";
            string2 = this.getAdminDirectory().getName() + "/" + string2;
            if (sVNVersionedProperties.isEmpty()) {
                sVNProperties.put("name", string2);
                sVNLog.addCommand("rm", sVNProperties, false);
            } else {
                String string3 = "tmp/";
                string3 = string3 + (this.getThisDirName().equals(string) ? "dir-props" : "props/" + string + ".svn-work");
                File file = this.getAdminFile(string3);
                String string4 = this.getAdminDirectory().getName() + "/" + string3;
                SVNWCProperties sVNWCProperties = new SVNWCProperties(file, string4);
                sVNWCProperties.setProperties(sVNVersionedProperties.asMap());
                sVNProperties.put("name", string4);
                sVNProperties.put("dest", string2);
                sVNLog.addCommand("mv", sVNProperties, false);
                sVNProperties.clear();
                sVNProperties.put("name", string2);
                sVNLog.addCommand("readonly", sVNProperties, false);
            }
            sVNVersionedProperties.setModified(false);
            sVNProperties.clear();
        }
    }

    private void saveBaseProperties(SVNLog sVNLog) {
        Map map = this.getBasePropertiesStorage(false);
        if (map == null || map.isEmpty()) {
            return;
        }
        SVNProperties sVNProperties = new SVNProperties();
        for (String string : map.keySet()) {
            SVNVersionedProperties sVNVersionedProperties = (SVNVersionedProperties)map.get(string);
            if (!sVNVersionedProperties.isModified()) continue;
            String string2 = this.getThisDirName().equals(string) ? "dir-prop-base" : "prop-base/" + string + ".svn-base";
            string2 = this.getAdminDirectory().getName() + "/" + string2;
            if (sVNVersionedProperties.isEmpty()) {
                sVNProperties.put("name", string2);
                sVNLog.addCommand("rm", sVNProperties, false);
            } else {
                String string3 = "tmp/";
                string3 = string3 + (this.getThisDirName().equals(string) ? "dir-prop-base" : "prop-base/" + string + ".svn-base");
                File file = this.getAdminFile(string3);
                String string4 = this.getAdminDirectory().getName() + "/" + string3;
                SVNWCProperties sVNWCProperties = new SVNWCProperties(file, string4);
                sVNWCProperties.setProperties(sVNVersionedProperties.asMap());
                sVNProperties.put("name", string4);
                sVNProperties.put("dest", string2);
                sVNLog.addCommand("mv", sVNProperties, false);
                sVNProperties.clear();
                sVNProperties.put("name", string2);
                sVNLog.addCommand("readonly", sVNProperties, false);
            }
            sVNVersionedProperties.setModified(false);
            sVNProperties.clear();
        }
    }

    @Override
    public void saveWCProperties(boolean bl2) {
        Map map = this.getWCPropertiesStorage(false);
        if (map == null) {
            return;
        }
        for (String string : map.keySet()) {
            SVNVersionedProperties sVNVersionedProperties = (SVNVersionedProperties)map.get(string);
            if (!sVNVersionedProperties.isModified()) continue;
            String string2 = this.getThisDirName().equals(string) ? "dir-wcprops" : "wcprops/" + string + ".svn-work";
            File file = this.getAdminFile(string2);
            if (sVNVersionedProperties.isEmpty()) {
                SVNFileUtil.deleteFile(file);
            } else {
                String string3 = "tmp/";
                string3 = string3 + (this.getThisDirName().equals(string) ? "dir-wcprops" : "wcprops/" + string + ".svn-work");
                File file2 = this.getAdminFile(string3);
                SVNWCProperties.setProperties(sVNVersionedProperties.asMap(), file, file2, "END");
            }
            sVNVersionedProperties.setModified(false);
        }
        if (bl2) {
            this.closeWCProperties();
        }
    }

    @Override
    public SVNVersionedProperties getBaseProperties(String string) {
        Map map = this.getBasePropertiesStorage(true);
        SVNVersionedProperties sVNVersionedProperties = (SVNVersionedProperties)map.get(string);
        if (sVNVersionedProperties != null) {
            return sVNVersionedProperties;
        }
        SVNProperties sVNProperties = null;
        try {
            sVNProperties = this.readBaseProperties(string);
        }
        catch (SVNException sVNException) {
            SVNErrorMessage sVNErrorMessage = sVNException.getErrorMessage().wrap("Failed to load properties from disk");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        sVNVersionedProperties = new SVNProperties13(sVNProperties);
        map.put(string, sVNVersionedProperties);
        return sVNVersionedProperties;
    }

    @Override
    public SVNVersionedProperties getRevertProperties(String string) {
        Map map = this.getRevertPropertiesStorage(true);
        SVNVersionedProperties sVNVersionedProperties = (SVNVersionedProperties)map.get(string);
        if (sVNVersionedProperties != null) {
            return sVNVersionedProperties;
        }
        SVNProperties sVNProperties = null;
        try {
            sVNProperties = this.readRevertProperties(string);
        }
        catch (SVNException sVNException) {
            SVNErrorMessage sVNErrorMessage = sVNException.getErrorMessage().wrap("Failed to load properties from disk");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        sVNVersionedProperties = new SVNProperties13(sVNProperties);
        map.put(string, sVNVersionedProperties);
        return sVNVersionedProperties;
    }

    @Override
    public SVNVersionedProperties getProperties(String string) {
        Map map = this.getPropertiesStorage(true);
        SVNVersionedProperties sVNVersionedProperties = (SVNVersionedProperties)map.get(string);
        if (sVNVersionedProperties != null) {
            return sVNVersionedProperties;
        }
        SVNProperties sVNProperties = null;
        try {
            sVNProperties = this.readProperties(string);
        }
        catch (SVNException sVNException) {
            SVNErrorMessage sVNErrorMessage = sVNException.getErrorMessage().wrap("Failed to load properties from disk");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        sVNVersionedProperties = new SVNProperties13(sVNProperties);
        map.put(string, sVNVersionedProperties);
        return sVNVersionedProperties;
    }

    @Override
    public SVNVersionedProperties getWCProperties(String string) {
        Map map = this.getWCPropertiesStorage(true);
        SVNVersionedProperties sVNVersionedProperties = (SVNVersionedProperties)map.get(string);
        if (sVNVersionedProperties != null) {
            return sVNVersionedProperties;
        }
        SVNProperties sVNProperties = null;
        try {
            sVNProperties = this.readWCProperties(string);
        }
        catch (SVNException sVNException) {
            SVNErrorMessage sVNErrorMessage = sVNException.getErrorMessage().wrap("Failed to load properties from disk");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        sVNVersionedProperties = new SVNProperties13(sVNProperties);
        map.put(string, sVNVersionedProperties);
        return sVNVersionedProperties;
    }

    private SVNProperties readProperties(String string) {
        File file = this.getPropertiesFile(string, false);
        SVNWCProperties sVNWCProperties = new SVNWCProperties(file, null);
        return sVNWCProperties.asMap();
    }

    private SVNProperties readBaseProperties(String string) {
        File file = this.getBasePropertiesFile(string, false);
        SVNWCProperties sVNWCProperties = new SVNWCProperties(file, null);
        return sVNWCProperties.asMap();
    }

    private SVNProperties readRevertProperties(String string) {
        File file = this.getRevertPropertiesFile(string, false);
        SVNWCProperties sVNWCProperties = new SVNWCProperties(file, null);
        return sVNWCProperties.asMap();
    }

    private SVNProperties readWCProperties(String string) {
        String string2 = this.getThisDirName().equals(string) ? "dir-wcprops" : "wcprops/" + string + ".svn-work";
        File file = this.getAdminFile(string2);
        SVNWCProperties sVNWCProperties = new SVNWCProperties(file, this.getAdminDirectory().getName() + "/" + string2);
        return sVNWCProperties.asMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveEntries(boolean bl2) {
        block7: {
            Serializable serializable;
            Object object;
            if (this.myEntries == null) break block7;
            SVNEntry sVNEntry = (SVNEntry)this.myEntries.get(this.getThisDirName());
            if (sVNEntry == null) {
                object = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "No default entry in directory ''{0}''", (Object)this.getRoot());
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            object = sVNEntry.getRepositoryRoot();
            String string = sVNEntry.getURL();
            if (object != null && !SVNPathUtil.isAncestor((String)object, string)) {
                serializable = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Entry ''{0}'' has inconsistent repository root and url", (Object)this.getThisDirName());
                SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
            }
            serializable = new File(this.getAdminDirectory(), "tmp/entries");
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter(SVNFileUtil.openFileForWriting(serializable), "UTF-8");
                this.writeEntries(outputStreamWriter);
            }
            catch (IOException iOException) {
                try {
                    SVNFileUtil.closeFile(outputStreamWriter);
                    SVNFileUtil.deleteFile(serializable);
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write entries file ''{0}'': {1}", this.myEntriesFile, iOException.getLocalizedMessage());
                    SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(outputStreamWriter);
                    throw throwable;
                }
                SVNFileUtil.closeFile(outputStreamWriter);
            }
            SVNFileUtil.closeFile(outputStreamWriter);
            SVNFileUtil.rename(serializable, this.myEntriesFile);
            SVNFileUtil.setReadonly(this.myEntriesFile, true);
            if (bl2) {
                this.myEntries = null;
            }
        }
    }

    @Override
    public void saveVersionedProperties(SVNLog sVNLog, boolean bl2) {
        this.saveProperties(sVNLog);
        this.saveBaseProperties(sVNLog);
        if (bl2) {
            this.myBaseProperties = null;
            this.myProperties = null;
        }
    }

    @Override
    public void installProperties(String string, SVNProperties sVNProperties, SVNProperties sVNProperties2, SVNLog sVNLog, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        String string2;
        SVNProperties sVNProperties3 = new SVNProperties();
        SVNNodeKind sVNNodeKind = string.equals(this.getThisDirName()) ? SVNNodeKind.DIR : SVNNodeKind.FILE;
        String string3 = SVNAdminUtil.getPropPath(string, sVNNodeKind, false);
        if (!sVNProperties2.isEmpty()) {
            string2 = SVNAdminUtil.getPropPath(string, sVNNodeKind, true);
            object2 = this.getFile(string2);
            object = new SVNWCProperties((File)object2, string2);
            if (!sVNProperties2.isEmpty()) {
                ((SVNWCProperties)object).setProperties(sVNProperties2);
            } else {
                SVNFileUtil.createEmptyFile((File)object2);
            }
            sVNProperties3.put("name", string2);
            sVNProperties3.put("dest", string3);
            sVNLog.addCommand("mv", sVNProperties3, false);
            sVNProperties3.clear();
            sVNProperties3.put("name", string3);
            sVNLog.addCommand("readonly", sVNProperties3, false);
        } else {
            sVNProperties3.put("name", string3);
            sVNLog.addCommand("rm", sVNProperties3, false);
        }
        sVNProperties3.clear();
        if (bl2) {
            string2 = SVNAdminUtil.getPropBasePath(string, sVNNodeKind, false);
            if (!sVNProperties.isEmpty()) {
                object2 = SVNAdminUtil.getPropBasePath(string, sVNNodeKind, true);
                object = this.getFile((String)object2);
                SVNWCProperties sVNWCProperties = new SVNWCProperties((File)object, (String)object2);
                sVNWCProperties.setProperties(sVNProperties);
                sVNProperties3.put("name", (String)object2);
                sVNProperties3.put("dest", string2);
                sVNLog.addCommand("mv", sVNProperties3, false);
                sVNProperties3.clear();
                sVNProperties3.put("name", string2);
                sVNLog.addCommand("readonly", sVNProperties3, false);
            } else {
                sVNProperties3.put("name", string2);
                sVNLog.addCommand("rm", sVNProperties3, false);
            }
        }
        if (bl3) {
            this.myBaseProperties = null;
            this.myProperties = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map fetchEntries() {
        if (!this.myEntriesFile.exists()) {
            return null;
        }
        var1_1 = new SVNHashMap();
        var2_2 = null;
        try {
            var2_2 = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(this.myEntriesFile, SVNLogType.WC), "UTF-8"));
            var4_3 = null;
lbl8:
            // 5 sources

            while ((var3_4 = var2_2.readLine()) != null) {
                if ((var3_4 = var3_4.trim()).equals("<entry")) {
                    var4_3 = this.createEntryHashMap(null);
                    continue;
                }
                if (var4_3 == null || var3_4.indexOf(61) <= 0 || var3_4.indexOf(34) <= 0 || var3_4.indexOf(34) == var3_4.lastIndexOf(34)) continue;
                var5_6 = var3_4.substring(0, var3_4.indexOf(61));
                var6_7 = var3_4.substring(var3_4.indexOf(34) + 1, var3_4.lastIndexOf(34));
                var6_7 = SVNEncodingUtil.xmlDecode(var6_7);
                var4_3.put("svn:entry:" + var5_6, var6_7);
                if (var3_4.charAt(var3_4.length() - 1) != '>') continue;
                var7_8 = (String)var4_3.get("svn:entry:name");
                if (var7_8 != null) ** GOTO lbl-1000
                var8_9 = var1_1;
                ** GOTO lbl32
            }
            ** GOTO lbl57
        }
        catch (IOException var3_5) {
            try {
                var4_3 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read entries file ''{0}'': {1}", new Object[]{this.myEntriesFile, var3_5.getLocalizedMessage()});
                SVNErrorManager.error((SVNErrorMessage)var4_3, var3_5, SVNLogType.WC);
            }
            catch (Throwable var11_12) {
                SVNFileUtil.closeFile(var2_2);
                throw var11_12;
            }
lbl32:
            // 1 sources

            SVNFileUtil.closeFile(var2_2);
            return var8_9;
lbl-1000:
            // 1 sources

            {
                var4_3.put("svn:entry:depth", SVNDepth.INFINITY.getName());
                var1_1.put(var7_8, new SVNEntry16((Map)var4_3, this, var7_8));
                if (!this.getThisDirName().equals(var7_8) && (var8_9 = (SVNEntry)var1_1.get(this.getThisDirName())) != null) {
                    var9_10 = var8_9.asMap();
                    if (var4_3.get("svn:entry:revision") == null) {
                        var4_3.put("svn:entry:revision", var9_10.get("svn:entry:revision"));
                    }
                    if (var4_3.get("svn:entry:url") == null) {
                        var10_11 = (String)var9_10.get("svn:entry:url");
                        if (var10_11 != null) {
                            var10_11 = SVNPathUtil.append(var10_11, SVNEncodingUtil.uriEncode(var7_8));
                        }
                        var4_3.put("svn:entry:url", var10_11);
                    }
                    if (var4_3.get("svn:entry:uuid") == null) {
                        var4_3.put("svn:entry:uuid", var9_10.get("svn:entry:uuid"));
                    }
                    if (var4_3.get("svn:entry:repos") == null && var9_10.get("svn:entry:repos") != null) {
                        var4_3.put("svn:entry:repos", var9_10.get("svn:entry:repos"));
                    }
                }
                var4_3 = null;
                ** GOTO lbl8
            }
lbl57:
            // 1 sources

            SVNFileUtil.closeFile(var2_2);
            return var1_1;
            SVNFileUtil.closeFile(var2_2);
            return var1_1;
        }
    }

    @Override
    public String getThisDirName() {
        return THIS_DIR;
    }

    @Override
    protected void writeEntries(Writer writer) {
        SVNEntry sVNEntry = (SVNEntry)this.myEntries.get(this.getThisDirName());
        Map map = sVNEntry.asMap();
        writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        writer.write("<wc-entries\n");
        writer.write("   xmlns=\"svn:\">\n");
        ArrayList arrayList = new ArrayList(this.myEntries.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            SVNEntry sVNEntry2 = (SVNEntry)this.myEntries.get(string);
            Map map2 = sVNEntry2.asMap();
            writer.write("<entry");
            for (String string2 : map2.keySet()) {
                Object object;
                Object v2;
                if (!this.isEntryPropertyApplicable(string2) || !((v2 = map2.get(string2)) instanceof String)) continue;
                String string3 = (String)v2;
                if (BOOLEAN_PROPERTIES.contains(string2) && !Boolean.TRUE.toString().equals(string3) || !this.getThisDirName().equals(string) && (!"dir".equals(map2.get("svn:entry:kind")) ? string3.equals(object = "svn:entry:url".equals(string2) ? SVNPathUtil.append((String)map.get(string2), SVNEncodingUtil.uriEncode(string)) : ("svn:entry:uuid".equals(string2) || "svn:entry:revision".equals(string2) ? map.get(string2) : ("svn:entry:repos".equals(string2) ? map.get(string2) : null))) : "svn:entry:uuid".equals(string2) || "svn:entry:revision".equals(string2) || "svn:entry:url".equals(string2) || "svn:entry:repos".equals(string2))) continue;
                if (string2 == null || !string2.startsWith("svn:entry:")) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "attempt to write invalid entry property: " + string2 + "=" + string3);
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, new Exception());
                    continue;
                }
                string2 = string2.substring("svn:entry:".length());
                string3 = SVNEncodingUtil.xmlEncodeAttr(string3);
                writer.write("\n   ");
                writer.write(string2);
                writer.write("=\"");
                writer.write(string3);
                writer.write("\"");
            }
            writer.write("/>\n");
            writer.flush();
        }
        writer.write("</wc-entries>\n");
        writer.flush();
    }

    @Override
    public boolean hasPropModifications(String string) {
        SVNVersionedProperties sVNVersionedProperties;
        String string2;
        boolean bl2;
        File file;
        File file2;
        if (this.getThisDirName().equals(string)) {
            file2 = this.getAdminFile("dir-props");
            file = this.getAdminFile("dir-prop-base");
        } else {
            file2 = this.getAdminFile("props/" + string + ".svn-work");
            file = this.getAdminFile("prop-base/" + string + ".svn-base");
        }
        SVNEntry sVNEntry = this.getEntry(string, true);
        long l2 = SVNFileUtil.getFileLength(file2);
        boolean bl3 = bl2 = l2 <= 4L;
        if (sVNEntry.isScheduledForReplacement()) {
            return !bl2;
        }
        if (bl2) {
            boolean bl4;
            boolean bl5 = bl4 = SVNFileUtil.getFileLength(file) <= 4L;
            if (bl4) {
                return !bl2;
            }
            return true;
        }
        if (l2 != SVNFileUtil.getFileLength(file)) {
            return true;
        }
        String string3 = string2 = SVNDate.formatDate(new Date(SVNFileUtil.getFileLastModified(file2)));
        string2 = string2.substring(0, 23);
        String string4 = sVNEntry.getPropTime();
        if (string4 != null && string2.equals(string4 = string4.substring(0, 23))) {
            return false;
        }
        SVNVersionedProperties sVNVersionedProperties2 = this.getProperties(string);
        if (sVNVersionedProperties2.equals(sVNVersionedProperties = this.getBaseProperties(string))) {
            if (this.isLocked()) {
                sVNEntry.setPropTime(string3);
                this.saveEntries(false);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasTextModifications(String string, boolean bl2) {
        long l2;
        Object object;
        long l3;
        SVNFileType sVNFileType = SVNFileType.getType(this.getFile(string));
        if (sVNFileType == SVNFileType.DIRECTORY || sVNFileType == SVNFileType.NONE) {
            return false;
        }
        SVNEntry sVNEntry = this.getEntry(string, true);
        if (sVNEntry.isDirectory()) {
            return false;
        }
        if (!bl2 && (l3 = SVNDate.parseDateAsMilliseconds((String)(object = sVNEntry.getTextTime()))) == (l2 = SVNFileUtil.getFileLastModified(this.getFile(string)))) {
            return false;
        }
        object = this.getBaseFile(string, false);
        if (!((File)object).isFile()) {
            return true;
        }
        File file = SVNFileUtil.createUniqueFile(this.getRoot(), SVNFileUtil.getBasePath(this.getBaseFile(string, true)), ".tmp", true);
        File file2 = this.getFile(string);
        SVNTranslator.translate((SVNAdminArea)this, string, string, SVNFileUtil.getBasePath(file), false);
        boolean bl3 = true;
        try {
            String string2;
            MessageDigest messageDigest = bl2 ? MessageDigest.getInstance("MD5") : null;
            bl3 = SVNFileUtil.compareFiles((File)object, file, messageDigest);
            if (bl2 && !(string2 = SVNFileUtil.toHexDigest(messageDigest)).equals(sVNEntry.getChecksum())) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch indicates corrupt text base: ''{0}''\n   expected: {1}\n     actual: {2}\n", object, sVNEntry.getChecksum(), string2);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", (Object)noSuchAlgorithmException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, noSuchAlgorithmException, SVNLogType.WC);
        }
        finally {
            file.delete();
        }
        if (bl3 && this.isLocked()) {
            sVNEntry.setTextTime(SVNDate.formatDate(new Date(SVNFileUtil.getFileLastModified(file2))));
            this.saveEntries(false);
        }
        return !bl3;
    }

    @Override
    public boolean hasProperties(String string) {
        File file;
        File file2;
        if (this.getThisDirName().equals(string)) {
            file2 = this.getAdminFile("dir-props");
            file = this.getAdminFile("dir-prop-base");
        } else {
            file2 = this.getAdminFile("props/" + string + ".svn-work");
            file = this.getAdminFile("prop-base/" + string + ".svn-base");
        }
        SVNWCProperties sVNWCProperties = new SVNWCProperties(file, null);
        if (sVNWCProperties.isEmpty()) {
            SVNWCProperties sVNWCProperties2 = new SVNWCProperties(file2, null);
            return !sVNWCProperties2.isEmpty();
        }
        return true;
    }

    @Override
    public boolean lock(boolean bl2) {
        if (!this.isVersioned()) {
            return false;
        }
        if (this.myLockFile.isFile()) {
            if (bl2) {
                this.setLocked(true);
                return true;
            }
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' locked; try performing ''cleanup''", (Object)this.getRoot());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        boolean bl3 = false;
        try {
            bl3 = this.myLockFile.createNewFile();
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Cannot lock working copy ''{0}'': {1}", this.getRoot(), iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
        }
        if (!bl3) {
            if (this.myLockFile.isFile()) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' is locked; try performing 'cleanup'", (Object)this.getRoot());
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            } else {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Cannot lock working copy ''{0}''", (Object)this.getRoot());
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
        }
        this.setLocked(true);
        return bl3;
    }

    boolean innerLock() {
        if (this.myLockFile.isFile()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' locked; try performing ''cleanup''", (Object)this.getRoot());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        boolean bl2 = false;
        try {
            bl2 = this.myLockFile.createNewFile();
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Cannot lock working copy ''{0}'': {1}", this.getRoot(), iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
        }
        if (!bl2) {
            if (this.myLockFile.isFile()) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' is locked; try performing 'cleanup'", (Object)this.getRoot());
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            } else {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Cannot lock working copy ''{0}''", (Object)this.getRoot());
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
        }
        return bl2;
    }

    @Override
    public boolean unlock() {
        Serializable serializable;
        int n2;
        if (!this.myLockFile.exists()) {
            return true;
        }
        boolean bl2 = this.getAdminFile("KILLME").exists();
        if (bl2) {
            return false;
        }
        File[] fileArray = SVNFileListUtil.listFiles(this.getAdminDirectory());
        for (n2 = 0; fileArray != null && n2 < fileArray.length; ++n2) {
            serializable = fileArray[n2];
            if (!"log".equals(((File)serializable).getName()) && !((File)serializable).getName().startsWith("log.")) continue;
            return false;
        }
        n2 = SVNFileUtil.deleteFile(this.myLockFile) ? 1 : 0;
        if (n2 == 0) {
            serializable = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Failed to unlock working copy ''{0}''", (Object)this.getRoot());
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        return n2 != 0;
    }

    @Override
    public boolean isVersioned() {
        if (this.getAdminDirectory().isDirectory() && this.myEntriesFile.canRead()) {
            try {
                if (this.getEntry(this.getThisDirName(), false) != null) {
                    return true;
                }
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public SVNAdminArea createVersionedDirectory(File file, String string, String string2, String string3, long l2, boolean bl2, SVNDepth sVNDepth) {
        file = bl2 ? this.getRoot() : file;
        file.mkdirs();
        File file2 = bl2 ? this.getAdminDirectory() : new File(file, SVNFileUtil.getAdminDirectoryName());
        file2.mkdir();
        SVNFileUtil.setHidden(file2, true);
        File file3 = bl2 ? this.myLockFile : new File(file2, "lock");
        SVNFileUtil.createEmptyFile(file3);
        SVNAdminUtil.createReadmeFile(file2);
        SVNFileUtil.createEmptyFile(bl2 ? this.getAdminFile("empty-file") : new File(file2, "empty-file"));
        File[] fileArray = new File[]{bl2 ? this.getAdminFile("tmp") : new File(file2, "tmp"), bl2 ? this.getAdminFile("tmp" + File.separatorChar + "props") : new File(file2, "tmp" + File.separatorChar + "props"), bl2 ? this.getAdminFile("tmp" + File.separatorChar + "prop-base") : new File(file2, "tmp" + File.separatorChar + "prop-base"), bl2 ? this.getAdminFile("tmp" + File.separatorChar + "text-base") : new File(file2, "tmp" + File.separatorChar + "text-base"), bl2 ? this.getAdminFile("tmp" + File.separatorChar + "wcprops") : new File(file2, "tmp" + File.separatorChar + "wcprops"), bl2 ? this.getAdminFile("props") : new File(file2, "props"), bl2 ? this.getAdminFile("prop-base") : new File(file2, "prop-base"), bl2 ? this.getAdminFile("text-base") : new File(file2, "text-base"), bl2 ? this.getAdminFile("wcprops") : new File(file2, "wcprops")};
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            fileArray[i2].mkdir();
        }
        SVNAdminUtil.createFormatFile(file2);
        SVNXMLAdminArea sVNXMLAdminArea = bl2 ? this : new SVNXMLAdminArea(file);
        sVNXMLAdminArea.setLocked(true);
        SVNEntry sVNEntry = sVNXMLAdminArea.getEntry(((SVNAdminArea)sVNXMLAdminArea).getThisDirName(), true);
        if (sVNEntry == null) {
            sVNEntry = sVNXMLAdminArea.addEntry(((SVNAdminArea)sVNXMLAdminArea).getThisDirName());
        }
        if (string != null) {
            sVNEntry.setURL(string);
        }
        sVNEntry.setRepositoryRoot(string2);
        sVNEntry.setRevision(l2);
        sVNEntry.setKind(SVNNodeKind.DIR);
        if (string3 != null) {
            sVNEntry.setUUID(string3);
        }
        if (l2 > 0L) {
            sVNEntry.setIncomplete(true);
        }
        ((SVNAdminArea)sVNXMLAdminArea).saveEntries(false);
        SVNFileUtil.deleteFile(file3);
        return sVNXMLAdminArea;
    }

    @Override
    public boolean isLocked() {
        if (!this.myWasLocked) {
            return false;
        }
        return this.myLockFile.isFile();
    }

    @Override
    public int getFormatVersion() {
        return 4;
    }

    @Override
    protected SVNVersionedProperties formatBaseProperties(SVNProperties sVNProperties) {
        SVNProperties sVNProperties2 = new SVNProperties(sVNProperties);
        sVNProperties2.remove("svn:mergeinfo");
        return new SVNProperties13(sVNProperties);
    }

    @Override
    protected SVNVersionedProperties formatProperties(SVNEntry sVNEntry, SVNProperties sVNProperties) {
        SVNProperties sVNProperties2 = new SVNProperties(sVNProperties);
        sVNProperties2.remove("svn:mergeinfo");
        return new SVNProperties13(sVNProperties2);
    }

    @Override
    public void handleKillMe() {
        boolean bl2 = this.isKillMe();
        if (bl2) {
            boolean bl3;
            SVNWCAccess sVNWCAccess;
            File file;
            long l2;
            block5: {
                SVNEntry sVNEntry = this.getEntry(this.getThisDirName(), false);
                l2 = sVNEntry != null ? sVNEntry.getRevision() : -1L;
                file = this.getRoot();
                sVNWCAccess = this.getWCAccess();
                bl3 = sVNWCAccess.isWCRoot(this.getRoot());
                try {
                    this.removeFromRevisionControl(this.getThisDirName(), true, false);
                }
                catch (SVNException sVNException) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, sVNException);
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) break block5;
                    throw sVNException;
                }
            }
            if (bl3) {
                return;
            }
            SVNAdminArea sVNAdminArea = sVNWCAccess.retrieve(file.getParentFile());
            SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
            if (l2 > sVNEntry.getRevision()) {
                SVNEntry sVNEntry2 = sVNAdminArea.addEntry(file.getName());
                sVNEntry2.setDeleted(true);
                sVNEntry2.setKind(SVNNodeKind.DIR);
                sVNEntry2.setRevision(l2);
                sVNAdminArea.saveEntries(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postCommit(String string, long l2, boolean bl2, boolean bl3, SVNErrorCode sVNErrorCode) {
        Serializable serializable;
        Object object;
        Object object2;
        Serializable serializable2;
        Object object3;
        Object object4;
        boolean bl4;
        File file;
        SVNFileType sVNFileType;
        Object object5;
        SVNEntry sVNEntry = this.getEntry(string, true);
        if (sVNEntry == null || !this.getThisDirName().equals(string) && sVNEntry.getKind() != SVNNodeKind.FILE) {
            object5 = SVNErrorMessage.create(sVNErrorCode, "Log command for directory ''{0}'' is mislocated", (Object)this.getRoot());
            SVNErrorManager.error((SVNErrorMessage)object5, SVNLogType.WC);
        }
        if (!bl2 && sVNEntry.isScheduledForDeletion()) {
            if (this.getThisDirName().equals(string)) {
                sVNEntry.setRevision(l2);
                sVNEntry.setKind(SVNNodeKind.DIR);
                object5 = this.getAdminFile("KILLME");
                if (bl3 && ((File)object5).isFile()) {
                    return;
                }
                if (((File)object5).getParentFile().isDirectory()) {
                    try {
                        ((File)object5).createNewFile();
                    }
                    catch (IOException iOException) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create file ''{0}'': {1}", object5, iOException.getLocalizedMessage());
                        SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
                    }
                }
            } else {
                this.removeFromRevisionControl(string, false, false);
                object5 = this.getEntry(this.getThisDirName(), true);
                if (l2 > ((SVNEntry)object5).getRevision()) {
                    SVNEntry sVNEntry2 = this.addEntry(string);
                    sVNEntry2.setKind(SVNNodeKind.FILE);
                    sVNEntry2.setDeleted(true);
                    sVNEntry2.setRevision(l2);
                }
            }
            return;
        }
        if (!bl2 && sVNEntry.isScheduledForReplacement() && this.getThisDirName().equals(string)) {
            object5 = this.entries(true);
            while (object5.hasNext()) {
                SVNEntry sVNEntry3 = (SVNEntry)object5.next();
                if (!sVNEntry3.isScheduledForDeletion() || sVNEntry3.getKind() != SVNNodeKind.FILE && sVNEntry3.getKind() != SVNNodeKind.DIR) continue;
                this.removeFromRevisionControl(sVNEntry3.getName(), false, false);
            }
        }
        long l3 = 0L;
        if (!(bl2 || this.getThisDirName().equals(string) || (sVNFileType = SVNFileType.getType(file = this.getBaseFile(string, true))) != SVNFileType.FILE && sVNFileType != SVNFileType.SYMLINK)) {
            bl4 = false;
            File file2 = this.getFile(string);
            object4 = SVNFileUtil.createUniqueFile(file.getParentFile(), string, ".tmp", true);
            try {
                object3 = SVNFileUtil.getBasePath((File)object4);
                SVNTranslator.translate((SVNAdminArea)this, string, string, (String)object3, false);
                bl4 = !SVNFileUtil.compareFiles(file, (File)object4, null);
            }
            catch (SVNException sVNException) {
                serializable2 = SVNErrorMessage.create(sVNErrorCode, "Error comparing ''{0}'' and ''{1}''", file2, file);
                SVNErrorManager.error((SVNErrorMessage)serializable2, sVNException, SVNLogType.WC);
            }
            finally {
                ((File)object4).delete();
            }
            long l4 = l3 = bl4 ? SVNFileUtil.getFileLastModified(file) : SVNFileUtil.getFileLastModified(file2);
        }
        if (!bl2 && sVNEntry.isScheduledForReplacement()) {
            SVNFileUtil.deleteFile(this.getBasePropertiesFile(string, false));
        }
        long l5 = 0L;
        bl4 = false;
        boolean bl5 = false;
        object4 = this.getBaseProperties(string);
        object3 = this.getProperties(string);
        serializable2 = this.getPropertiesFile(string, true);
        File file3 = this.getPropertiesFile(string, false);
        File file4 = this.getBasePropertiesFile(string, false);
        SVNFileType sVNFileType2 = SVNFileType.getType((File)serializable2);
        if (sVNFileType2 == SVNFileType.FILE) {
            object2 = new SVNWCProperties(file3, null);
            object = new SVNWCProperties((File)serializable2, null);
            serializable = ((SVNWCProperties)object2).compareTo((SVNWCProperties)object);
            boolean bl6 = serializable == null || serializable.isEmpty();
            long l6 = l5 = bl6 ? SVNFileUtil.getFileLastModified(file3) : SVNFileUtil.getFileLastModified((File)serializable2);
            if (!this.getThisDirName().equals(string)) {
                SVNVersionedProperties sVNVersionedProperties = ((SVNVersionedProperties)object4).compareTo((SVNVersionedProperties)object3);
                bl4 = sVNVersionedProperties != null && sVNVersionedProperties.containsProperty("svn:needs-lock") && sVNVersionedProperties.getPropertyValue("svn:needs-lock") == null;
                bl5 = sVNVersionedProperties != null && sVNVersionedProperties.containsProperty("svn:executable") && sVNVersionedProperties.getPropertyValue("svn:executable") == null;
            }
            try {
                if (!((File)serializable2).exists() || ((File)serializable2).length() <= 4L) {
                    SVNFileUtil.deleteFile(file4);
                }
                SVNFileUtil.copyFile((File)serializable2, file4, true);
                SVNFileUtil.setReadonly(file4, true);
            }
            finally {
                SVNFileUtil.deleteFile((File)serializable2);
            }
        } else if (sVNEntry.getPropTime() == null && !((SVNVersionedProperties)object3).isEmpty()) {
            l5 = SVNFileUtil.getFileLastModified(file3);
        }
        if (!this.getThisDirName().equals(string) && !bl2) {
            Object object6;
            object2 = this.getBaseFile(string, true);
            object = this.getBaseFile(string, false);
            serializable = this.getFile(string);
            File file5 = null;
            try {
                boolean bl7;
                boolean bl8;
                file5 = SVNFileUtil.createUniqueFile(((File)object2).getParentFile(), string, ".tmp", false);
                boolean bl9 = false;
                object6 = SVNFileType.getType((File)object2);
                boolean bl10 = bl8 = this.getProperties(string).getPropertyValue("svn:special") != null;
                if (!SVNFileUtil.symlinksSupported() || !bl8) {
                    if (object6 == SVNFileType.FILE) {
                        SVNTranslator.translate((SVNAdminArea)this, string, SVNFileUtil.getBasePath((File)object2), SVNFileUtil.getBasePath(file5), true);
                    } else {
                        SVNTranslator.translate((SVNAdminArea)this, string, string, SVNFileUtil.getBasePath(file5), true);
                    }
                    if (!SVNFileUtil.compareFiles(file5, (File)serializable, null)) {
                        SVNFileUtil.copyFile(file5, (File)serializable, true);
                        bl9 = true;
                    }
                }
                boolean bl11 = this.getProperties(string).getPropertyValue("svn:needs-lock") != null && sVNEntry.getLockToken() == null;
                boolean bl12 = bl7 = this.getProperties(string).getPropertyValue("svn:executable") != null;
                if (bl11) {
                    SVNFileUtil.setReadonly((File)serializable, true);
                    bl9 = true;
                }
                if (bl7) {
                    SVNFileUtil.setExecutable((File)serializable, true);
                    bl9 = true;
                }
                if (object6 == SVNFileType.FILE) {
                    SVNFileUtil.rename((File)object2, (File)object);
                }
                if (bl4) {
                    SVNFileUtil.setReadonly((File)serializable, false);
                    bl9 = true;
                }
                if (bl5) {
                    SVNFileUtil.setExecutable((File)serializable, false);
                    bl9 = true;
                }
                if (bl9) {
                    l3 = SVNFileUtil.getFileLastModified((File)serializable);
                }
            }
            catch (SVNException sVNException) {
                object6 = SVNErrorMessage.create(sVNErrorCode, "Error replacing text-base of ''{0}''", (Object)string);
                SVNErrorManager.error((SVNErrorMessage)object6, sVNException, SVNLogType.WC);
            }
            finally {
                file5.delete();
                ((File)object2).delete();
            }
        }
        object2 = new SVNHashMap();
        object2.put("svn:entry:revision", SVNProperty.toString(l2));
        object2.put("svn:entry:kind", this.getThisDirName().equals(string) ? "dir" : "file");
        if (!bl2) {
            object2.put("svn:entry:schedule", null);
        }
        object2.put("svn:entry:copied", SVNProperty.toString(false));
        object2.put("svn:entry:deleted", SVNProperty.toString(false));
        if (l3 != 0L && !bl2) {
            object2.put("svn:entry:text-time", SVNDate.formatDate(new Date(l3)));
        }
        if (l5 != 0L && !bl2) {
            object2.put("svn:entry:prop-time", SVNDate.formatDate(new Date(l5)));
        }
        object2.put("svn:entry:conflict-new", null);
        object2.put("svn:entry:conflict-old", null);
        object2.put("svn:entry:conflict-wrk", null);
        object2.put("svn:entry:prop-reject-file", null);
        object2.put("svn:entry:copyfrom-rev", null);
        object2.put("svn:entry:copyfrom-url", null);
        try {
            this.modifyEntry(string, (Map)object2, false, true);
        }
        catch (SVNException sVNException) {
            serializable = SVNErrorMessage.create(sVNErrorCode, "Error modifying entry of ''{0}''", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)serializable, sVNException, SVNLogType.WC);
        }
        if (!this.getThisDirName().equals(string)) {
            return;
        }
        object = this.getRoot();
        if (this.getWCAccess().isWCRoot(this.getRoot())) {
            return;
        }
        boolean bl13 = false;
        SVNAdminArea sVNAdminArea = null;
        try {
            sVNAdminArea = this.getWCAccess().retrieve(((File)object).getParentFile());
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                sVNAdminArea = this.getWCAccess().open(((File)object).getParentFile(), true, false, 0);
                bl13 = true;
            }
            throw sVNException;
        }
        SVNEntry sVNEntry4 = sVNAdminArea.getEntry(((File)object).getName(), false);
        if (sVNEntry4 != null) {
            object2.clear();
            if (!bl2) {
                object2.put("svn:entry:schedule", null);
            }
            object2.put("svn:entry:copied", SVNProperty.toString(false));
            object2.put("svn:entry:copyfrom-rev", null);
            object2.put("svn:entry:copyfrom-url", null);
            object2.put("svn:entry:deleted", SVNProperty.toString(false));
            try {
                sVNAdminArea.modifyEntry(sVNEntry4.getName(), (Map)object2, true, true);
            }
            catch (SVNException sVNException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(sVNErrorCode, "Error modifying entry of ''{0}''", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, sVNException, SVNLogType.WC);
            }
        }
        sVNAdminArea.saveEntries(false);
        if (bl13) {
            this.getWCAccess().closeAdminArea(((File)object).getParentFile());
        }
    }

    @Override
    public boolean hasTreeConflict(String string) {
        return false;
    }

    @Override
    public SVNTreeConflictDescription getTreeConflict(String string) {
        return null;
    }

    @Override
    public void addTreeConflict(SVNTreeConflictDescription sVNTreeConflictDescription) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "This feature is not supported in version {0} of working copy format", (Object)String.valueOf(this.getFormatVersion()));
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
    }

    @Override
    public SVNTreeConflictDescription deleteTreeConflict(String string) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "This feature is not supported in version {0} of working copy format", (Object)String.valueOf(this.getFormatVersion()));
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        return null;
    }

    @Override
    public void setFileExternalLocation(String string, SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNURL sVNURL2) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "This feature is not supported in version {0} of working copy format", (Object)String.valueOf(this.getFormatVersion()));
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
    }

    @Override
    protected boolean isEntryPropertyApplicable(String string) {
        return string != null && !INAPPLICABLE_PROPERTIES.contains(string);
    }

    @Override
    protected boolean readExtraOptions(BufferedReader bufferedReader, SVNEntry sVNEntry) {
        return false;
    }

    @Override
    protected int writeExtraOptions(Writer writer, String string, SVNEntry sVNEntry, int n2) {
        return n2;
    }

    static {
        BOOLEAN_PROPERTIES.add("svn:entry:copied");
        BOOLEAN_PROPERTIES.add("svn:entry:deleted");
        BOOLEAN_PROPERTIES.add("svn:entry:absent");
        BOOLEAN_PROPERTIES.add("svn:entry:incomplete");
        INAPPLICABLE_PROPERTIES.add("svn:entry:cachable-props");
        INAPPLICABLE_PROPERTIES.add("svn:entry:present-props");
        INAPPLICABLE_PROPERTIES.add("svn:entry:has-prop-mods");
        INAPPLICABLE_PROPERTIES.add("svn:entry:working-size");
        INAPPLICABLE_PROPERTIES.add("svn:entry:depth");
        INAPPLICABLE_PROPERTIES.add("svn:entry:has-props");
        INAPPLICABLE_PROPERTIES.add("svn:entry:keep-local");
        INAPPLICABLE_PROPERTIES.add("svn:entry:changelist");
        INAPPLICABLE_PROPERTIES.add("svn:entry:file-external-path");
        INAPPLICABLE_PROPERTIES.add("svn:entry:file-external-revision");
        INAPPLICABLE_PROPERTIES.add("svn:entry:file-external-peg-revision");
        INAPPLICABLE_PROPERTIES.add("svn:entry:tree-conflicts");
    }
}

