/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNFileFetcher;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeCallback;
import org.tmatesoft.svn.core.internal.wc.SVNMergeCallback15;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver;
import org.tmatesoft.svn.core.internal.wc.SVNObjectsPool;
import org.tmatesoft.svn.core.internal.wc.SVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNUpdateEditor15;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNCleanupHandler;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNEntryHandler;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess$TCEntryHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNWCAccess
implements ISVNEventHandler {
    public static final int INFINITE_DEPTH = -1;
    private ISVNEventHandler myEventHandler;
    private ISVNOptions myOptions;
    private Map myAdminAreas;
    private Map myCleanupHandlers;
    private SVNObjectsPool myObjectsPool;
    private File myAnchor;
    private static boolean ourNeverDescendIntoSymlinks = Boolean.getBoolean("svnkit.symlinks.neverDescend");

    public static SVNWCAccess newInstance(ISVNEventHandler iSVNEventHandler) {
        return new SVNWCAccess(iSVNEventHandler);
    }

    private static boolean isObjectsPoolEnabled() {
        return Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("svnkit.entry.pool", "true"));
    }

    private SVNWCAccess(ISVNEventHandler iSVNEventHandler) {
        this.myEventHandler = iSVNEventHandler;
        if (SVNWCAccess.isObjectsPoolEnabled()) {
            this.myObjectsPool = new SVNObjectsPool();
        }
    }

    public void setEventHandler(ISVNEventHandler iSVNEventHandler) {
        this.myEventHandler = iSVNEventHandler;
    }

    public ISVNEventHandler getEventHandler() {
        return this.myEventHandler;
    }

    @Override
    public void checkCancelled() {
        if (this.myEventHandler != null) {
            this.myEventHandler.checkCancelled();
        }
    }

    public void handleEvent(SVNEvent sVNEvent) {
        this.handleEvent(sVNEvent, -1.0);
    }

    public void registerCleanupHandler(SVNAdminArea sVNAdminArea, ISVNCleanupHandler iSVNCleanupHandler) {
        if (sVNAdminArea == null || iSVNCleanupHandler == null) {
            return;
        }
        if (this.myCleanupHandlers == null) {
            this.myCleanupHandlers = new SVNHashMap();
        }
        this.myCleanupHandlers.put(sVNAdminArea, iSVNCleanupHandler);
    }

    @Override
    public void handleEvent(SVNEvent sVNEvent, double d2) {
        if (this.myEventHandler != null) {
            try {
                this.myEventHandler.handleEvent(sVNEvent, d2);
            }
            catch (SVNException sVNException) {
                throw sVNException;
            }
            catch (Throwable throwable) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Error while dispatching event: {0}", (Object)throwable.getMessage());
                SVNErrorManager.error(sVNErrorMessage, throwable, SVNLogType.WC);
            }
        }
    }

    public void setOptions(ISVNOptions iSVNOptions) {
        this.myOptions = iSVNOptions;
    }

    public ISVNOptions getOptions() {
        if (this.myOptions == null) {
            this.myOptions = new DefaultSVNOptions();
        }
        return this.myOptions;
    }

    public void setAnchor(File file) {
        this.myAnchor = file;
    }

    public File getAnchor() {
        return this.myAnchor;
    }

    public SVNAdminAreaInfo openAnchor(File file, boolean bl2, int n2) {
        Object object;
        Object object2;
        SVNException sVNException;
        SVNAdminArea sVNAdminArea;
        SVNAdminArea sVNAdminArea2;
        String string;
        File file2;
        block37: {
            block36: {
                file2 = file.getParentFile();
                if (file2 == null || "..".equals(file.getName())) {
                    SVNAdminArea sVNAdminArea3 = this.open(file, bl2, n2);
                    return new SVNAdminAreaInfo(this, sVNAdminArea3, sVNAdminArea3, "");
                }
                string = file.getName();
                sVNAdminArea2 = null;
                sVNAdminArea = null;
                sVNException = null;
                try {
                    sVNAdminArea2 = this.open(file2, bl2, false, 0);
                }
                catch (SVNException sVNException2) {
                    if (bl2 && sVNException2.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LOCKED) {
                        try {
                            sVNAdminArea2 = this.open(file2, false, false, 0);
                        }
                        catch (SVNException sVNException3) {
                            throw sVNException2;
                        }
                        sVNException = sVNException2;
                    }
                    if (sVNException2.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) break block36;
                    throw sVNException2;
                }
            }
            try {
                sVNAdminArea = this.open(file, bl2, false, n2);
            }
            catch (SVNException sVNException4) {
                if (sVNAdminArea2 != null && sVNException4.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) break block37;
                try {
                    this.close();
                }
                catch (SVNException sVNException5) {
                    // empty catch block
                }
                throw sVNException4;
            }
        }
        if (sVNAdminArea2 != null && sVNAdminArea != null) {
            object2 = null;
            object = null;
            SVNEntry sVNEntry = null;
            try {
                sVNEntry = sVNAdminArea2.getEntry(string, false);
                object = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
                object2 = sVNAdminArea2.getEntry(sVNAdminArea2.getThisDirName(), false);
            }
            catch (SVNException sVNException6) {
                try {
                    this.close();
                }
                catch (SVNException sVNException7) {
                    // empty catch block
                }
                throw sVNException6;
            }
            SVNURL sVNURL = object2 != null ? ((SVNEntry)object2).getSVNURL() : null;
            SVNURL sVNURL2 = object != null ? ((SVNEntry)object).getSVNURL() : null;
            String string2 = SVNEncodingUtil.uriEncode(string);
            if (sVNEntry == null || sVNURL != null && sVNURL2 != null && (!sVNURL.equals(sVNURL2.removePathTail()) || !string2.equals(SVNPathUtil.tail(sVNURL2.getURIEncodedPath())))) {
                if (this.myAdminAreas != null) {
                    this.myAdminAreas.remove(file2);
                }
                try {
                    this.doClose(sVNAdminArea2, false);
                }
                catch (SVNException sVNException8) {
                    try {
                        this.close();
                    }
                    catch (SVNException sVNException9) {
                        // empty catch block
                    }
                    throw sVNException8;
                }
                sVNAdminArea2 = null;
            }
        }
        if (sVNAdminArea2 != null && sVNException != null && sVNAdminArea != null) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LOCKED) {
                try {
                    this.doClose(sVNAdminArea2, false);
                }
                catch (SVNException sVNException10) {
                    try {
                        this.close();
                    }
                    catch (SVNException sVNException11) {
                        // empty catch block
                    }
                    throw sVNException10;
                }
                sVNAdminArea2 = null;
            } else {
                try {
                    this.close();
                }
                catch (SVNException sVNException12) {
                    // empty catch block
                }
                throw sVNException;
            }
        }
        if (sVNAdminArea == null) {
            object2 = null;
            try {
                object2 = sVNAdminArea2.getEntry(string, false);
            }
            catch (SVNException sVNException13) {
                try {
                    this.close();
                }
                catch (SVNException sVNException14) {
                    // empty catch block
                }
                throw sVNException13;
            }
            if (object2 != null && ((SVNEntry)object2).isDirectory() && this.myAdminAreas != null) {
                this.myAdminAreas.put(file, null);
            }
        }
        object2 = sVNAdminArea2 != null ? sVNAdminArea2 : sVNAdminArea;
        object = sVNAdminArea != null ? sVNAdminArea : sVNAdminArea2;
        return new SVNAdminAreaInfo(this, (SVNAdminArea)object2, (SVNAdminArea)object, sVNAdminArea2 == null ? "" : string);
    }

    public SVNAdminArea open(File file, boolean bl2, int n2) {
        return this.open(file, bl2, false, n2);
    }

    public SVNAdminArea open(File file, boolean bl2, boolean bl3, int n2) {
        return this.open(file, bl2, bl3, true, n2, Level.FINE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNAdminArea open(File file, boolean bl2, boolean bl3, boolean bl4, int n2, Level level) {
        SVNAdminArea sVNAdminArea;
        SVNHashMap sVNHashMap = new SVNHashMap();
        try {
            sVNAdminArea = this.doOpen(file, bl2, bl3, bl4, n2, sVNHashMap, level);
        }
        finally {
            for (Object k2 : sVNHashMap.keySet()) {
                SVNAdminArea sVNAdminArea2 = (SVNAdminArea)sVNHashMap.get(k2);
                this.myAdminAreas.put(k2, sVNAdminArea2);
            }
        }
        return sVNAdminArea;
    }

    public SVNAdminArea probeOpen(File file, boolean bl2, int n2) {
        return this.probeOpen(file, bl2, n2, Level.FINE);
    }

    public SVNAdminArea probeOpen(File file, boolean bl2, int n2, Level level) {
        Object object;
        File file2 = this.probe(file, level);
        if (file2 == null) {
            object = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object, level, SVNLogType.WC);
        }
        if (!file.equals(file2)) {
            n2 = 0;
        }
        object = null;
        try {
            object = this.open(file2, bl2, false, true, n2, level);
        }
        catch (SVNException sVNException) {
            SVNFileType sVNFileType = SVNFileType.getType(file);
            SVNErrorCode sVNErrorCode = sVNException.getErrorMessage().getErrorCode();
            if (!(file.equals(file2) || sVNFileType != SVNFileType.DIRECTORY && sVNFileType != SVNFileType.NONE || sVNErrorCode != SVNErrorCode.WC_NOT_DIRECTORY)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)file);
                SVNErrorManager.error(sVNErrorMessage, level, SVNLogType.WC);
            }
            throw sVNException;
        }
        return object;
    }

    public SVNAdminArea probeTry(File file, boolean bl2, int n2) {
        SVNAdminArea sVNAdminArea;
        block6: {
            sVNAdminArea = null;
            try {
                sVNAdminArea = this.probeRetrieve(file);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                    try {
                        sVNAdminArea = this.probeOpen(file, bl2, n2);
                    }
                    catch (SVNException sVNException2) {
                        if (sVNException2.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_DIRECTORY) {
                            throw sVNException2;
                        }
                        break block6;
                    }
                }
                throw sVNException;
            }
        }
        return sVNAdminArea;
    }

    public void close() {
        if (this.myAdminAreas != null) {
            this.doClose(this.myAdminAreas, false);
            this.myAdminAreas.clear();
        }
        this.myCleanupHandlers = null;
        if (this.getObjectsPool() != null) {
            this.getObjectsPool().clear();
        }
    }

    public void closeAdminArea(File file) {
        SVNAdminArea sVNAdminArea;
        if (this.myAdminAreas != null && (sVNAdminArea = (SVNAdminArea)this.myAdminAreas.get(file)) != null) {
            this.doClose(sVNAdminArea, false);
            this.myAdminAreas.remove(file);
        }
    }

    private SVNAdminArea doOpen(File file, boolean bl2, boolean bl3, boolean bl4, int n2, Map map, Level level) {
        Object object;
        SVNAdminArea sVNAdminArea;
        Map map2 = map = map == null ? new SVNHashMap() : map;
        if (this.myAdminAreas != null) {
            sVNAdminArea = (SVNAdminArea)this.myAdminAreas.get(file);
            if (this.myAdminAreas.containsKey(file) && sVNAdminArea != null) {
                object = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' locked", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
        } else {
            this.myAdminAreas = new SVNHashMap();
        }
        sVNAdminArea = SVNAdminAreaFactory.open(file, level);
        sVNAdminArea.setWCAccess(this);
        if (bl2) {
            sVNAdminArea.lock(bl3);
            if (bl4) {
                sVNAdminArea = SVNAdminAreaFactory.upgrade(sVNAdminArea);
            }
        }
        map.put(file, sVNAdminArea);
        if (n2 != 0) {
            if (n2 > 0) {
                --n2;
            }
            object = sVNAdminArea.entries(false);
            while (object.hasNext()) {
                SVNAdminArea sVNAdminArea2;
                try {
                    this.checkCancelled();
                }
                catch (SVNCancelException sVNCancelException) {
                    this.doClose(map, false);
                    throw sVNCancelException;
                }
                SVNEntry sVNEntry = (SVNEntry)object.next();
                if (sVNEntry.getKind() != SVNNodeKind.DIR || sVNAdminArea.getThisDirName().equals(sVNEntry.getName()) || sVNEntry.getDepth() == SVNDepth.EXCLUDE) continue;
                File file2 = new File(file, sVNEntry.getName());
                try {
                    this.doOpen(file2, bl2, bl3, bl4, n2, map, level);
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_DIRECTORY) {
                        this.doClose(map, false);
                        throw sVNException;
                    }
                    map.put(file2, null);
                }
                if ((sVNAdminArea2 = (SVNAdminArea)map.get(file2)) == null) continue;
                SVNEntry sVNEntry2 = sVNAdminArea2.getEntry(sVNAdminArea2.getThisDirName(), false);
                SVNEntry sVNEntry3 = sVNAdminArea.getEntry(sVNAdminArea2.getThisDirName(), false);
                String string = sVNEntry2.getRepositoryRoot();
                String string2 = sVNEntry3.getRepositoryRoot();
                if (string == null || string.equals(string2)) continue;
                SVNHashMap sVNHashMap = new SVNHashMap();
                sVNHashMap.put(file2, sVNAdminArea2);
                String string3 = file2.getAbsolutePath().replace(File.separatorChar, '/');
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    File file3 = (File)iterator.next();
                    String string4 = file3.getAbsolutePath().replace(File.separatorChar, '/');
                    if (!SVNPathUtil.isAncestor(string3, string4)) continue;
                    sVNHashMap.put(file3, map.get(file3));
                    iterator.remove();
                }
                map.put(file2, null);
                this.doClose(sVNHashMap, false);
            }
        }
        return sVNAdminArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose(Map map, boolean bl2) {
        SVNHashSet sVNHashSet = new SVNHashSet();
        while (!map.isEmpty()) {
            SVNHashMap sVNHashMap = new SVNHashMap(map);
            try {
                for (File file : sVNHashMap.keySet()) {
                    SVNAdminArea sVNAdminArea = (SVNAdminArea)sVNHashMap.get(file);
                    if (sVNAdminArea == null) {
                        sVNHashSet.add(file);
                        continue;
                    }
                    this.doClose(sVNAdminArea, bl2);
                    sVNHashSet.add(file);
                }
            }
            finally {
                for (File file : sVNHashSet) {
                    map.remove(file);
                }
            }
        }
    }

    private void doClose(SVNAdminArea sVNAdminArea, boolean bl2) {
        ISVNCleanupHandler iSVNCleanupHandler;
        if (sVNAdminArea == null) {
            return;
        }
        if (this.myCleanupHandlers != null && (iSVNCleanupHandler = (ISVNCleanupHandler)this.myCleanupHandlers.remove(sVNAdminArea)) != null) {
            iSVNCleanupHandler.cleanup(sVNAdminArea);
        }
        if (!bl2 && sVNAdminArea.isLocked()) {
            sVNAdminArea.unlock();
        }
        sVNAdminArea.close();
    }

    public SVNAdminArea probeRetrieve(File file) {
        File file2 = this.probe(file, Level.FINE);
        if (file2 == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        return this.retrieve(file2);
    }

    public boolean isMissing(File file) {
        if (this.myAdminAreas != null) {
            return this.myAdminAreas.containsKey(file) && this.myAdminAreas.get(file) == null;
        }
        return false;
    }

    public boolean isLocked(File file) {
        File file2 = new File(file, SVNFileUtil.getAdminDirectoryName());
        if (SVNFileType.getType(file2 = new File(file2, "lock")) == SVNFileType.FILE) {
            return true;
        }
        if (SVNFileType.getType(file2) == SVNFileType.NONE) {
            return false;
        }
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Lock file ''{0}'' is not a regular file", (Object)file2);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWCRoot(File file) {
        block23: {
            SVNEntry sVNEntry;
            SVNEntry sVNEntry2 = this.getEntry(file, false);
            File file2 = file.getParentFile();
            if (file2 == null && sVNEntry2 != null) {
                return true;
            }
            SVNAdminArea sVNAdminArea = this.getAdminArea(file2);
            SVNWCAccess sVNWCAccess = null;
            SVNWCAccess sVNWCAccess2 = this;
            if (sVNAdminArea == null) {
                sVNWCAccess = new SVNWCAccess(null);
                try {
                    sVNAdminArea = sVNWCAccess.probeOpen(file2, false, 0, Level.FINEST);
                }
                catch (SVNException sVNException) {
                    boolean bl2 = true;
                    if (sVNWCAccess != null) {
                        try {
                            sVNWCAccess.close();
                        }
                        catch (SVNException sVNException2) {
                            // empty catch block
                        }
                    }
                    return bl2;
                }
                sVNWCAccess2 = sVNWCAccess;
            }
            if ((sVNEntry = sVNWCAccess2.getEntry(file2, false)) == null || !sVNEntry.isThisDir()) {
                boolean bl3 = true;
                return bl3;
            }
            if (sVNEntry.getURL() == null) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no ancestry information", (Object)file2);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            if ((sVNEntry2 = sVNAdminArea.getEntry(file.getName(), false)) != null) break block23;
            boolean bl4 = true;
            return bl4;
            finally {
                if (sVNWCAccess != null) {
                    try {
                        sVNWCAccess.close();
                    }
                    catch (SVNException sVNException) {}
                }
            }
        }
        return false;
    }

    public SVNTreeConflictDescription getTreeConflict(File file) {
        Object object;
        SVNAdminArea sVNAdminArea;
        boolean bl2;
        File file2;
        block8: {
            file2 = file.getParentFile();
            if (file2 == null) {
                return null;
            }
            bl2 = false;
            sVNAdminArea = null;
            try {
                sVNAdminArea = this.retrieve(file2);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                    object = null;
                    try {
                        sVNAdminArea = this.open(file2, false, 0);
                        bl2 = true;
                    }
                    catch (SVNException sVNException2) {
                        if (sVNException2.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY || sVNException2.getErrorMessage().getErrorCode() == SVNErrorCode.WC_UNSUPPORTED_FORMAT) {
                            return null;
                        }
                        object = sVNException2;
                    }
                }
                if (object == null) break block8;
                throw object;
            }
        }
        object = sVNAdminArea.getTreeConflict(file.getName());
        if (bl2) {
            this.closeAdminArea(file2);
        }
        return object;
    }

    public boolean hasTreeConflict(File file) {
        SVNTreeConflictDescription sVNTreeConflictDescription = this.getTreeConflict(file);
        return sVNTreeConflictDescription != null;
    }

    public SVNEntry getEntry(File file, boolean bl2) {
        SVNAdminArea sVNAdminArea = this.getAdminArea(file);
        String string = null;
        if (sVNAdminArea == null) {
            sVNAdminArea = this.getAdminArea(file.getParentFile());
            string = file.getName();
        } else {
            string = sVNAdminArea.getThisDirName();
        }
        if (sVNAdminArea != null) {
            return sVNAdminArea.getEntry(string, bl2);
        }
        return null;
    }

    public SVNEntry getVersionedEntry(File file, boolean bl2) {
        SVNEntry sVNEntry = this.getEntry(file, bl2);
        if (sVNEntry == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        return sVNEntry;
    }

    public void setRepositoryRoot(File file, SVNURL sVNURL) {
        SVNEntry sVNEntry = this.getEntry(file, false);
        if (sVNEntry == null) {
            return;
        }
        SVNAdminArea sVNAdminArea = null;
        String string = null;
        if (sVNEntry.isFile()) {
            sVNAdminArea = this.getAdminArea(file.getParentFile());
            string = file.getName();
        } else {
            sVNAdminArea = this.getAdminArea(file);
            String string2 = string = sVNAdminArea != null ? sVNAdminArea.getThisDirName() : null;
        }
        if (sVNAdminArea == null) {
            return;
        }
        if (sVNAdminArea.tweakEntry(string, null, sVNURL.toString(), -1L, false)) {
            sVNAdminArea.saveEntries(false);
        }
    }

    public SVNAdminArea[] getAdminAreas() {
        if (this.myAdminAreas != null) {
            return this.myAdminAreas.values().toArray(new SVNAdminArea[this.myAdminAreas.size()]);
        }
        return new SVNAdminArea[0];
    }

    public SVNAdminArea upgrade(File file) {
        SVNAdminArea sVNAdminArea;
        SVNAdminArea sVNAdminArea2 = null;
        if (this.myAdminAreas != null && (sVNAdminArea = (SVNAdminArea)this.myAdminAreas.get(file)) != null) {
            ISVNCleanupHandler iSVNCleanupHandler = null;
            if (this.myCleanupHandlers != null) {
                iSVNCleanupHandler = (ISVNCleanupHandler)this.myCleanupHandlers.get(sVNAdminArea);
            }
            if ((sVNAdminArea2 = SVNAdminAreaFactory.upgrade(sVNAdminArea)) != sVNAdminArea) {
                this.myAdminAreas.put(file, sVNAdminArea2);
                if (iSVNCleanupHandler != null) {
                    this.myCleanupHandlers.remove(sVNAdminArea);
                    this.myCleanupHandlers.put(sVNAdminArea2, iSVNCleanupHandler);
                }
            }
        }
        return sVNAdminArea2;
    }

    public SVNAdminArea retrieve(File file) {
        SVNAdminArea sVNAdminArea = this.getAdminArea(file);
        if (sVNAdminArea == null) {
            SVNErrorMessage sVNErrorMessage;
            Serializable serializable;
            Object object;
            SVNEntry sVNEntry = null;
            try {
                object = this.getAdminArea(file.getParentFile());
                if (object != null) {
                    sVNEntry = ((SVNAdminArea)object).getEntry(file.getName(), true);
                }
            }
            catch (SVNException sVNException) {
                sVNEntry = null;
            }
            object = SVNFileType.getType(file);
            if (sVNEntry != null) {
                if (sVNEntry.getKind() == SVNNodeKind.DIR && object == SVNFileType.FILE) {
                    serializable = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Expected ''{0}'' to be a directory but found a file", (Object)file);
                    SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
                } else if (sVNEntry.getKind() == SVNNodeKind.FILE && object == SVNFileType.DIRECTORY) {
                    serializable = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Expected ''{0}'' to be a file but found a directory", (Object)file);
                    SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
                }
            }
            serializable = new File(file, SVNFileUtil.getAdminDirectoryName());
            SVNFileType sVNFileType = SVNFileType.getType(serializable);
            if (object == SVNFileType.NONE) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "Directory ''{0}'' is missing", (Object)file);
                SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Directory ''{0}'' is missing", (Object)file);
                sVNErrorMessage2.setChildErrorMessage(sVNErrorMessage);
                SVNErrorManager.error(sVNErrorMessage2, SVNLogType.WC);
            } else if (object == SVNFileType.DIRECTORY && sVNFileType == SVNFileType.NONE) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Directory ''{0}'' containing working copy admin area is missing", (Object)serializable);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            } else if (object == SVNFileType.DIRECTORY && sVNFileType == SVNFileType.DIRECTORY) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Unable to lock ''{0}''", (Object)file);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Working copy ''{0}'' is not locked", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        return sVNAdminArea;
    }

    public SVNAdminArea getAdminArea(File file) {
        SVNAdminArea sVNAdminArea = null;
        if (this.myAdminAreas != null) {
            sVNAdminArea = (SVNAdminArea)this.myAdminAreas.get(file);
        }
        return sVNAdminArea;
    }

    public void walkEntries(File file, ISVNEntryHandler iSVNEntryHandler, boolean bl2, SVNDepth sVNDepth) {
        this.walkEntries(file, iSVNEntryHandler, bl2, false, sVNDepth);
    }

    public void walkEntries(File file, ISVNEntryHandler iSVNEntryHandler, boolean bl2, boolean bl3, SVNDepth sVNDepth) {
        SVNEntry sVNEntry;
        if (bl3) {
            iSVNEntryHandler = new SVNWCAccess$TCEntryHandler(file, this, iSVNEntryHandler, sVNDepth);
        }
        if ((sVNEntry = this.getEntry(file, bl2)) == null) {
            SVNTreeConflictDescription sVNTreeConflictDescription;
            if (bl3 && (sVNTreeConflictDescription = this.getTreeConflict(file)) != null) {
                iSVNEntryHandler.handleEntry(file, null);
                return;
            }
            iSVNEntryHandler.handleError(file, SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", (Object)file));
            return;
        }
        if (sVNEntry.isFile()) {
            try {
                iSVNEntryHandler.handleEntry(file, sVNEntry);
            }
            catch (SVNException sVNException) {
                iSVNEntryHandler.handleError(file, sVNException.getErrorMessage());
            }
        } else if (sVNEntry.isDirectory()) {
            SVNAdminArea sVNAdminArea = sVNEntry.getAdminArea();
            try {
                sVNAdminArea.walkThisDirectory(iSVNEntryHandler, bl3 ? true : bl2, sVNDepth);
            }
            catch (SVNException sVNException) {
                iSVNEntryHandler.handleError(file, sVNException.getErrorMessage());
            }
        } else {
            iSVNEntryHandler.handleError(file, SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "''{0}'' has an unrecognized node kind", (Object)file));
        }
    }

    private File probe(File file, Level level) {
        boolean bl2;
        int n2 = -1;
        SVNFileType sVNFileType = SVNFileType.getType(file);
        boolean bl3 = bl2 = sVNFileType == SVNFileType.DIRECTORY;
        if (bl2) {
            n2 = SVNAdminAreaFactory.checkWC(file, true, level);
        } else if (sVNFileType == SVNFileType.SYMLINK && file.isDirectory()) {
            boolean bl4 = bl2 = !ourNeverDescendIntoSymlinks && this.isWCRoot(file);
            if (bl2) {
                n2 = SVNAdminAreaFactory.checkWC(file, true, level);
            }
        } else {
            n2 = 0;
        }
        if (!bl2 || n2 == 0) {
            if ("..".equals(file.getName()) || ".".equals(file.getName())) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_BAD_PATH, "Path ''{0}'' ends in ''{1}'', which is unsupported for this operation", file, file.getName());
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            file = file.getParentFile();
        }
        return file;
    }

    public static boolean matchesChangeList(Collection collection, SVNEntry sVNEntry) {
        return collection == null || collection.isEmpty() || sVNEntry != null && sVNEntry.getChangelistName() != null && collection.contains(sVNEntry.getChangelistName());
    }

    int getMaxFormatVersion() {
        int n2 = -1;
        for (SVNAdminArea sVNAdminArea : this.myAdminAreas.values()) {
            if (sVNAdminArea == null || sVNAdminArea.getFormatVersion() <= n2) continue;
            n2 = sVNAdminArea.getFormatVersion();
        }
        return n2;
    }

    public ISVNUpdateEditor createUpdateEditor(SVNAdminAreaInfo sVNAdminAreaInfo, String string, boolean bl2, boolean bl3, SVNDepth sVNDepth, String[] stringArray, ISVNFileFetcher iSVNFileFetcher, boolean bl4) {
        int n2 = this.getMaxFormatVersion();
        if (0 < n2 && n2 < 10) {
            return SVNUpdateEditor15.createUpdateEditor(sVNAdminAreaInfo, string, bl2, bl3, sVNDepth, stringArray, iSVNFileFetcher, bl4);
        }
        return SVNUpdateEditor.createUpdateEditor(sVNAdminAreaInfo, string, bl2, bl3, sVNDepth, stringArray, iSVNFileFetcher, bl4);
    }

    public SVNMergeCallback createMergeCallback(SVNMergeDriver sVNMergeDriver, SVNAdminArea sVNAdminArea, SVNURL sVNURL, SVNDiffOptions sVNDiffOptions, Map map, boolean bl2, boolean bl3) {
        int n2 = this.getMaxFormatVersion();
        if (n2 < 10) {
            return new SVNMergeCallback15(sVNAdminArea, sVNURL, bl2, bl3, sVNDiffOptions, map, sVNMergeDriver);
        }
        return new SVNMergeCallback(sVNAdminArea, sVNURL, bl2, bl3, sVNDiffOptions, map, sVNMergeDriver);
    }

    public SVNObjectsPool getObjectsPool() {
        return this.myObjectsPool;
    }
}

