/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.File;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNEntryHandler;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;

class SVNWCAccess$TCEntryHandler
implements ISVNEntryHandler {
    private ISVNEntryHandler myDelegate;
    private SVNDepth myDepth;
    private File myTargetPath;
    private SVNWCAccess myWCAccess;

    public SVNWCAccess$TCEntryHandler(File file, SVNWCAccess sVNWCAccess, ISVNEntryHandler iSVNEntryHandler, SVNDepth sVNDepth) {
        this.myDelegate = iSVNEntryHandler;
        this.myDepth = sVNDepth;
        this.myTargetPath = file;
        this.myWCAccess = sVNWCAccess;
    }

    @Override
    public void handleEntry(File file, SVNEntry sVNEntry) {
        this.myDelegate.handleEntry(file, sVNEntry);
        if (sVNEntry == null || !sVNEntry.isDirectory() || sVNEntry.isHidden()) {
            return;
        }
        boolean bl2 = false;
        if (this.myDepth == SVNDepth.IMMEDIATES || this.myDepth == SVNDepth.FILES) {
            bl2 = file.equals(this.myTargetPath);
        } else if (this.myDepth == SVNDepth.INFINITY || this.myDepth == SVNDepth.EXCLUDE || this.myDepth == SVNDepth.UNKNOWN) {
            bl2 = true;
        } else {
            return;
        }
        if (!bl2) {
            return;
        }
        Map map = sVNEntry.getTreeConflicts();
        for (File file2 : map.keySet()) {
            SVNEntry sVNEntry2;
            SVNTreeConflictDescription sVNTreeConflictDescription = (SVNTreeConflictDescription)map.get(file2);
            if (sVNTreeConflictDescription.getNodeKind() == SVNNodeKind.DIR && this.myDepth == SVNDepth.FILES || (sVNEntry2 = this.myWCAccess.getEntry(file2, true)) != null && !sVNEntry2.isDeleted()) continue;
            this.myDelegate.handleEntry(file2, null);
        }
    }

    @Override
    public void handleError(File file, SVNErrorMessage sVNErrorMessage) {
        SVNTreeConflictDescription sVNTreeConflictDescription;
        if (sVNErrorMessage != null && sVNErrorMessage.getErrorCode() == SVNErrorCode.UNVERSIONED_RESOURCE && (sVNTreeConflictDescription = this.myWCAccess.getTreeConflict(file)) != null) {
            this.myDelegate.handleEntry(file, null);
            return;
        }
        this.myDelegate.handleError(file, sVNErrorMessage);
    }
}

