/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;

public abstract class SVNVersionedProperties {
    private SVNProperties myProperties;
    private boolean myIsModified;

    protected SVNVersionedProperties(SVNProperties sVNProperties) {
        this.myProperties = sVNProperties;
        this.myIsModified = false;
    }

    public abstract boolean containsProperty(String var1);

    public abstract SVNPropertyValue getPropertyValue(String var1);

    public String getStringPropertyValue(String string) {
        SVNPropertyValue sVNPropertyValue = this.getPropertyValue(string);
        return sVNPropertyValue == null ? null : sVNPropertyValue.getString();
    }

    public boolean isModified() {
        return this.myIsModified;
    }

    protected void setModified(boolean bl2) {
        this.myIsModified = bl2;
    }

    public boolean isEmpty() {
        SVNProperties sVNProperties = this.loadProperties();
        return sVNProperties == null || sVNProperties.isEmpty();
    }

    public Collection getPropertyNames(Collection collection) {
        SVNProperties sVNProperties = this.loadProperties();
        Collection collection2 = collection = collection == null ? new TreeSet() : collection;
        if (this.isEmpty()) {
            return collection;
        }
        Iterator iterator = sVNProperties.nameSet().iterator();
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    public void setPropertyValue(String string, SVNPropertyValue sVNPropertyValue) {
        SVNProperties sVNProperties = this.loadProperties();
        if (sVNPropertyValue != null) {
            sVNProperties.put(string, sVNPropertyValue);
        } else {
            sVNProperties.remove(string);
        }
        this.myIsModified = true;
    }

    public SVNVersionedProperties compareTo(SVNVersionedProperties sVNVersionedProperties) {
        SVNProperties sVNProperties = this.loadProperties();
        if (sVNProperties == null) {
            return this.wrap(new SVNProperties());
        }
        return this.wrap(sVNProperties.compareTo(sVNVersionedProperties.loadProperties()));
    }

    public void copyTo(SVNVersionedProperties sVNVersionedProperties) {
        SVNProperties sVNProperties = this.loadProperties();
        if (this.isEmpty()) {
            sVNVersionedProperties.removeAll();
        } else {
            sVNVersionedProperties.put(sVNProperties);
        }
    }

    public void removeAll() {
        SVNProperties sVNProperties = this.loadProperties();
        if (!this.isEmpty()) {
            sVNProperties.clear();
            this.myIsModified = true;
        }
    }

    public boolean equals(SVNVersionedProperties sVNVersionedProperties) {
        return this.compareTo(sVNVersionedProperties).isEmpty();
    }

    public SVNProperties asMap() {
        return this.loadProperties() != null ? new SVNProperties(this.loadProperties()) : new SVNProperties();
    }

    protected void put(SVNProperties sVNProperties) {
        SVNProperties sVNProperties2 = this.loadProperties();
        sVNProperties2.clear();
        sVNProperties2.putAll(sVNProperties);
        this.myIsModified = true;
    }

    protected SVNProperties getProperties() {
        return this.myProperties;
    }

    protected void setPropertiesMap(SVNProperties sVNProperties) {
        this.myProperties = sVNProperties;
    }

    protected abstract SVNVersionedProperties wrap(SVNProperties var1);

    protected abstract SVNProperties loadProperties();
}

