/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.SVNSubstitutor;

public class SVNTranslatorOutputStream
extends OutputStream {
    private SVNSubstitutor mySubstitutor;
    private OutputStream myDst;
    private ByteBuffer mySrcBuffer;
    private ByteBuffer myDstBuffer;

    public SVNTranslatorOutputStream(OutputStream outputStream, byte[] byArray, boolean bl2, Map map, boolean bl3) {
        this.mySubstitutor = new SVNSubstitutor(byArray, bl2, map, bl3);
        this.myDst = outputStream;
        this.mySrcBuffer = ByteBuffer.allocate(2048);
        this.myDstBuffer = ByteBuffer.allocate(2048);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.mySrcBuffer = SVNTranslatorOutputStream.write(this.mySrcBuffer, byArray, n2, n3);
        this.mySrcBuffer.flip();
        try {
            this.myDstBuffer = this.mySubstitutor.translateChunk(this.mySrcBuffer, this.myDstBuffer);
        }
        catch (SVNException sVNException) {
            IOExceptionWrapper iOExceptionWrapper = new IOExceptionWrapper(sVNException);
            throw iOExceptionWrapper;
        }
        this.myDstBuffer.flip();
        this.myDst.write(this.myDstBuffer.array(), this.myDstBuffer.arrayOffset() + this.myDstBuffer.position(), this.myDstBuffer.remaining());
        this.mySrcBuffer.clear();
        this.myDstBuffer.clear();
    }

    @Override
    public void flush() {
        try {
            this.myDstBuffer = this.mySubstitutor.translateChunk(null, this.myDstBuffer);
        }
        catch (SVNException sVNException) {
            IOExceptionWrapper iOExceptionWrapper = new IOExceptionWrapper(sVNException);
            throw iOExceptionWrapper;
        }
        this.myDstBuffer.flip();
        if (this.myDstBuffer.hasRemaining()) {
            this.myDst.write(this.myDstBuffer.array(), this.myDstBuffer.arrayOffset() + this.myDstBuffer.position(), this.myDstBuffer.remaining());
        }
        this.myDstBuffer.clear();
        this.myDst.flush();
    }

    @Override
    public void close() {
        this.flush();
        this.myDst.close();
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n2) {
        this.write(new byte[]{(byte)(n2 & 0xFF)});
    }

    private static ByteBuffer write(ByteBuffer byteBuffer, byte[] byArray, int n2, int n3) {
        if (byteBuffer.remaining() < n3) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate((byteBuffer.position() + n3) * 3 / 2);
            byteBuffer.flip();
            byteBuffer = byteBuffer2.put(byteBuffer);
        }
        return byteBuffer.put(byArray, n2, n3);
    }
}

