/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.SVNSubstitutor;

public class SVNTranslatorInputStream
extends InputStream {
    private InputStream mySource;
    private ByteBuffer myTranslatedBuffer;
    private SVNSubstitutor mySubstitutor;
    private byte[] mySourceBuffer;

    public SVNTranslatorInputStream(InputStream inputStream, byte[] byArray, boolean bl2, Map map, boolean bl3) {
        this.mySource = inputStream;
        this.mySubstitutor = new SVNSubstitutor(byArray, bl2, map, bl3);
        this.myTranslatedBuffer = ByteBuffer.allocate(2048);
        this.mySourceBuffer = new byte[2048];
    }

    @Override
    public int read() {
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray);
        if (n2 <= 0) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        boolean bl2 = false;
        int n4 = this.myTranslatedBuffer.position();
        while (n4 < n3) {
            int n5 = this.mySource.read(this.mySourceBuffer, 0, this.mySourceBuffer.length);
            if (n5 < 0) {
                bl2 = true;
                try {
                    this.myTranslatedBuffer = this.mySubstitutor.translateChunk(null, this.myTranslatedBuffer);
                    break;
                }
                catch (SVNException sVNException) {
                    IOExceptionWrapper iOExceptionWrapper = new IOExceptionWrapper(sVNException);
                    throw iOExceptionWrapper;
                }
            }
            try {
                this.myTranslatedBuffer = this.mySubstitutor.translateChunk(ByteBuffer.wrap(this.mySourceBuffer, 0, n5), this.myTranslatedBuffer);
            }
            catch (SVNException sVNException) {
                IOExceptionWrapper iOExceptionWrapper = new IOExceptionWrapper(sVNException);
                throw iOExceptionWrapper;
            }
            n4 = this.myTranslatedBuffer.position();
        }
        this.myTranslatedBuffer.flip();
        n3 = Math.min(this.myTranslatedBuffer.remaining(), n3);
        this.myTranslatedBuffer.get(byArray, n2, n3);
        this.myTranslatedBuffer.compact();
        if (bl2 && n3 == 0) {
            return -1;
        }
        return n3;
    }

    @Override
    public void close() {
        this.mySource.close();
    }
}

