/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator$1;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.util.SVNLogType;

class SVNTranslator$SVNKeywordFormatter {
    private boolean expand;
    private boolean expandCustomKeywords;
    private String authorString;
    private String dateString;
    private String revisionString;
    private ISVNOptions options;
    private byte[] date;
    private byte[] idDate;
    private byte[] url;
    private byte[] baseUrl;
    private byte[] repositoryRoot;
    private byte[] reposRelPath;
    private byte[] rev;
    private byte[] author;
    private byte[] name;
    private byte[] id;
    private byte[] header;
    private Date javaDate;
    private SVNURL locationUrl;
    private SVNURL repositoryRootUrl;

    private SVNTranslator$SVNKeywordFormatter(boolean bl2, boolean bl3, SVNURL sVNURL, SVNURL sVNURL2, String string, String string2, String string3, ISVNOptions iSVNOptions) {
        this.expand = bl2;
        this.expandCustomKeywords = bl3;
        this.authorString = string;
        this.dateString = string2;
        this.revisionString = string3;
        this.options = iSVNOptions;
        this.locationUrl = sVNURL;
        this.repositoryRootUrl = sVNURL2;
        this.date = null;
        this.idDate = null;
        this.url = null;
        this.rev = null;
        this.author = null;
        this.name = null;
        this.id = null;
        this.header = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] format(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] byArray;
            while (true) {
                int n2;
                for (n2 = 0; n2 < string.length() && string.charAt(n2) != '%'; ++n2) {
                }
                byteArrayOutputStream.write(string.substring(0, n2).getBytes("UTF-8"));
                if (n2 == string.length()) break;
                if (n2 + 1 == string.length()) {
                    byteArrayOutputStream.write(string.charAt(n2));
                    --n2;
                } else {
                    switch (string.charAt(n2 + 1)) {
                        case 'a': {
                            byArray = this.getAuthor();
                            if (byArray == null) break;
                            byteArrayOutputStream.write(byArray);
                            break;
                        }
                        case 'b': {
                            byte[] byArray2 = this.getName();
                            if (byArray2 == null) break;
                            byteArrayOutputStream.write(byArray2);
                            break;
                        }
                        case 'd': {
                            byte[] byArray3 = this.getIdDate();
                            if (byArray3 == null) break;
                            byteArrayOutputStream.write(byArray3);
                            break;
                        }
                        case 'D': {
                            byte[] byArray4 = this.getDate();
                            if (byArray4 == null) break;
                            byteArrayOutputStream.write(byArray4);
                            break;
                        }
                        case 'P': {
                            byte[] byArray5 = this.getReposRelPath();
                            if (byArray5 == null) break;
                            byteArrayOutputStream.write(byArray5);
                            break;
                        }
                        case 'R': {
                            byte[] byArray6 = this.getRepositoryRoot();
                            if (byArray6 == null) break;
                            byteArrayOutputStream.write(byArray6);
                            break;
                        }
                        case 'r': {
                            byte[] byArray7 = this.getRevision();
                            if (byArray7 == null) break;
                            byteArrayOutputStream.write(byArray7);
                            break;
                        }
                        case 'u': {
                            byte[] byArray8 = this.getUrl();
                            if (byArray8 == null) break;
                            byteArrayOutputStream.write(byArray8);
                            break;
                        }
                        case '_': {
                            byteArrayOutputStream.write(32);
                            break;
                        }
                        case '%': {
                            byteArrayOutputStream.write(37);
                            break;
                        }
                        case 'H': {
                            byteArrayOutputStream.write(this.format("%P%_%r%_%d%_%a"));
                            break;
                        }
                        case 'I': {
                            byteArrayOutputStream.write(this.format("%b%_%r%_%d%_%a"));
                            break;
                        }
                        default: {
                            byteArrayOutputStream.write(string.charAt(n2));
                            byteArrayOutputStream.write(string.charAt(n2 + 1));
                        }
                    }
                }
                string = string.substring(n2 + 2);
            }
            byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, unsupportedEncodingException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.CLIENT);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.CLIENT);
        }
        finally {
            SVNFileUtil.closeFile(byteArrayOutputStream);
        }
        return null;
    }

    private Date getJavaDate() {
        if (this.javaDate == null) {
            this.javaDate = this.dateString == null ? null : SVNDate.parseDate(this.dateString);
        }
        return this.javaDate;
    }

    private byte[] getAuthor() {
        if (this.author == null) {
            this.author = this.expand ? (this.authorString == null ? new byte[]{} : this.authorString.getBytes("UTF-8")) : this.author;
        }
        return this.author;
    }

    private byte[] getDate() {
        if (this.date == null) {
            this.date = this.expand ? SVNDate.formatHumanDate(this.getJavaDate(), this.options).getBytes("UTF-8") : this.date;
        }
        return this.date;
    }

    private byte[] getRevision() {
        if (this.rev == null) {
            this.rev = this.expand ? this.revisionString.getBytes("UTF-8") : this.rev;
        }
        return this.rev;
    }

    private byte[] getUrl() {
        if (this.url == null && this.locationUrl != null) {
            this.url = this.expand ? this.locationUrl.toString().getBytes("UTF-8") : this.url;
        }
        return this.url;
    }

    private byte[] getBaseUrl() {
        if (this.baseUrl == null && this.locationUrl != null) {
            this.baseUrl = this.locationUrl.removePathTail().toString().getBytes("UTF-8");
        }
        return this.baseUrl;
    }

    private byte[] getRepositoryRoot() {
        if (this.repositoryRoot == null && this.repositoryRootUrl != null) {
            this.repositoryRoot = this.repositoryRootUrl.toString().getBytes("UTF-8");
        }
        return this.repositoryRoot;
    }

    private byte[] getReposRelPath() {
        if (this.reposRelPath == null && this.repositoryRootUrl != null && this.locationUrl != null) {
            this.reposRelPath = SVNPathUtil.getRelativePath(this.repositoryRootUrl.toDecodedString(), this.locationUrl.toDecodedString()).getBytes("UTF-8");
        }
        return this.reposRelPath;
    }

    private byte[] getName() {
        if (this.name == null && this.locationUrl != null) {
            this.name = SVNEncodingUtil.uriDecode(SVNPathUtil.tail(this.locationUrl.toDecodedString())).getBytes("UTF-8");
        }
        return this.name;
    }

    private byte[] getIdDate() {
        if (this.idDate == null) {
            this.idDate = SVNDate.formatShortDate(this.getJavaDate()).getBytes("UTF-8");
        }
        return this.idDate;
    }

    private byte[] getId() {
        if (this.id == null && this.expand) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.getName());
            byteArrayOutputStream.write(32);
            byteArrayOutputStream.write(this.getRevision());
            byteArrayOutputStream.write(32);
            byteArrayOutputStream.write(this.getIdDate());
            byteArrayOutputStream.write(32);
            byteArrayOutputStream.write(this.getAuthor());
            byteArrayOutputStream.close();
            this.id = byteArrayOutputStream.toByteArray();
        }
        return this.id;
    }

    private byte[] getHeader() {
        if (this.header == null && this.expand) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.getUrl());
            byteArrayOutputStream.write(32);
            byteArrayOutputStream.write(this.getRevision());
            byteArrayOutputStream.write(32);
            byteArrayOutputStream.write(this.getIdDate());
            byteArrayOutputStream.write(32);
            byteArrayOutputStream.write(this.getAuthor());
            byteArrayOutputStream.close();
            this.header = byteArrayOutputStream.toByteArray();
        }
        return this.header;
    }

    /* synthetic */ SVNTranslator$SVNKeywordFormatter(boolean bl2, boolean bl3, SVNURL sVNURL, SVNURL sVNURL2, String string, String string2, String string3, ISVNOptions iSVNOptions, SVNTranslator$1 sVNTranslator$1) {
        this(bl2, bl3, sVNURL, sVNURL2, string, string2, string3, iSVNOptions);
    }

    static /* synthetic */ byte[] access$100(SVNTranslator$SVNKeywordFormatter sVNTranslator$SVNKeywordFormatter, String string) {
        return sVNTranslator$SVNKeywordFormatter.format(string);
    }
}

