/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.File;
import java.util.Iterator;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNReporter
implements ISVNReporterBaton {
    private SVNAdminAreaInfo myInfo;
    private SVNDepth myDepth;
    private boolean myIsRestore;
    private boolean myUseDepthCompatibilityTrick;
    private boolean myIsStatus;
    private boolean myIsHonorDepthExclude;
    private File myTarget;
    private ISVNDebugLog myLog;
    private boolean myIsLockOnDemand;
    private long myTotalFilesCount;
    private long myReportedFilesCount;

    public SVNReporter(SVNAdminAreaInfo sVNAdminAreaInfo, File file, boolean bl2, boolean bl3, SVNDepth sVNDepth, boolean bl4, boolean bl5, boolean bl6, ISVNDebugLog iSVNDebugLog) {
        this.myInfo = sVNAdminAreaInfo;
        this.myDepth = sVNDepth;
        this.myIsRestore = bl2;
        this.myIsStatus = bl5;
        this.myUseDepthCompatibilityTrick = bl3;
        this.myLog = iSVNDebugLog;
        this.myTarget = file;
        this.myIsLockOnDemand = bl4;
        this.myIsHonorDepthExclude = bl6;
        this.myTotalFilesCount = 0L;
        this.myReportedFilesCount = 0L;
    }

    @Override
    public void report(ISVNReporter iSVNReporter) {
        try {
            Object object;
            long l2;
            SVNAdminArea sVNAdminArea = this.myInfo.getTarget();
            SVNWCAccess sVNWCAccess = this.myInfo.getWCAccess();
            SVNEntry sVNEntry = sVNWCAccess.getEntry(this.myTarget, false);
            if (sVNEntry == null || sVNEntry.isDirectory() && sVNEntry.isScheduledForAddition()) {
                SVNEntry sVNEntry2 = sVNWCAccess.getVersionedEntry(this.myTarget.getParentFile(), false);
                long l3 = sVNEntry2.getRevision();
                if (this.myDepth == SVNDepth.UNKNOWN) {
                    this.myDepth = SVNDepth.INFINITY;
                }
                iSVNReporter.setPath("", null, l3, this.myDepth, sVNEntry == null || sVNEntry.isIncomplete());
                if (sVNEntry == null || sVNEntry.isIncomplete()) {
                    this.myInfo.addIncompleteEntry("");
                }
                iSVNReporter.deletePath("");
                iSVNReporter.finishReport();
                ++this.myReportedFilesCount;
                ++this.myTotalFilesCount;
                return;
            }
            SVNEntry sVNEntry3 = null;
            boolean bl2 = sVNEntry.isIncomplete();
            if (this.myUseDepthCompatibilityTrick && sVNEntry.getDepth().compareTo(SVNDepth.IMMEDIATES) <= 0 && this.myDepth.compareTo(sVNEntry.getDepth()) > 0) {
                bl2 = true;
            }
            if (!SVNRevision.isValidRevisionNumber(l2 = sVNEntry.getRevision())) {
                sVNEntry3 = sVNWCAccess.getVersionedEntry(this.myTarget.getParentFile(), false);
                l2 = sVNEntry3.getRevision();
            }
            iSVNReporter.setPath("", null, l2, sVNEntry.getDepth(), bl2);
            if (bl2) {
                this.myInfo.addIncompleteEntry("");
            }
            boolean bl3 = false;
            if (!sVNEntry.isScheduledForDeletion()) {
                object = SVNFileType.getType(this.myTarget);
                bl3 = object == SVNFileType.NONE;
            }
            this.myTotalFilesCount = 1L;
            this.myReportedFilesCount = 1L;
            if (sVNEntry.isDirectory()) {
                if (!(this.myIsStatus || bl3 || sVNEntry.isThisDir())) {
                    bl3 = true;
                }
                if (bl3) {
                    iSVNReporter.deletePath("");
                } else if (this.myDepth != SVNDepth.EMPTY) {
                    this.reportEntries(iSVNReporter, sVNAdminArea, "", l2, bl2, this.myDepth);
                }
            } else if (sVNEntry.isFile()) {
                if (bl3) {
                    this.restoreFile(sVNAdminArea, sVNEntry.getName());
                }
                sVNEntry3 = sVNEntry3 == null ? sVNWCAccess.getEntry(this.myTarget.getParentFile(), false) : sVNEntry3;
                object = sVNEntry.getURL();
                String string = sVNEntry3.getURL();
                String string2 = SVNPathUtil.append(string, SVNEncodingUtil.uriEncode(sVNEntry.getName()));
                if (sVNEntry3 != null && !string2.equals(object)) {
                    SVNURL sVNURL = SVNURL.parseURIEncoded((String)object);
                    iSVNReporter.linkPath(sVNURL, "", sVNEntry.getLockToken(), sVNEntry.getRevision(), sVNEntry.getDepth(), false);
                } else if (sVNEntry.getRevision() != l2 || sVNEntry.getLockToken() != null) {
                    iSVNReporter.setPath("", sVNEntry.getLockToken(), sVNEntry.getRevision(), sVNEntry.getDepth(), false);
                }
            }
            iSVNReporter.finishReport();
        }
        catch (SVNException sVNException) {
            try {
                iSVNReporter.abortReport();
            }
            catch (SVNException sVNException2) {
                this.myLog.logFine(SVNLogType.WC, sVNException2);
            }
            throw sVNException;
        }
        catch (Throwable throwable) {
            this.myLog.logFine(SVNLogType.WC, throwable);
            try {
                iSVNReporter.abortReport();
            }
            catch (SVNException sVNException) {
                this.myLog.logFine(SVNLogType.WC, sVNException);
            }
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "WC report failed: {0}", (Object)throwable.getMessage());
            SVNErrorManager.error(sVNErrorMessage, throwable, SVNLogType.WC);
        }
    }

    private void reportEntries(ISVNReporter iSVNReporter, SVNAdminArea sVNAdminArea, String string, long l2, boolean bl2, SVNDepth sVNDepth) {
        String string2;
        SVNWCAccess sVNWCAccess = this.myInfo.getWCAccess();
        String string3 = sVNAdminArea.getProperties(sVNAdminArea.getThisDirName()).getStringPropertyValue("svn:externals");
        SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), true);
        if (string3 != null) {
            string2 = sVNAdminArea.getRelativePath(this.myInfo.getAnchor());
            this.myInfo.addExternal(string2, string3, string3);
            this.myInfo.addDepth(string2, sVNEntry.getDepth());
        }
        string2 = sVNEntry.getURL();
        Iterator iterator = sVNAdminArea.entries(true);
        while (iterator.hasNext()) {
            SVNURL sVNURL;
            Object object;
            String string4;
            SVNEntry sVNEntry2 = (SVNEntry)iterator.next();
            if (sVNAdminArea.getThisDirName().equals(sVNEntry2.getName())) continue;
            ++this.myTotalFilesCount;
            String string5 = string4 = "".equals(string) ? sVNEntry2.getName() : SVNPathUtil.append(string, sVNEntry2.getName());
            if (sVNEntry2.isDeleted() || sVNEntry2.isAbsent()) {
                if (bl2) continue;
                iSVNReporter.deletePath(string4);
                ++this.myReportedFilesCount;
                continue;
            }
            if (sVNEntry2.getDepth() == SVNDepth.EXCLUDE) {
                if (this.myIsHonorDepthExclude) {
                    iSVNReporter.setPath(string4, null, l2, SVNDepth.EXCLUDE, false);
                    continue;
                }
                if (bl2) continue;
                iSVNReporter.deletePath(string4);
                continue;
            }
            if (sVNEntry2.isScheduledForAddition()) continue;
            File file = sVNAdminArea.getFile(sVNEntry2.getName());
            SVNFileType sVNFileType = SVNFileType.getType(file);
            boolean bl3 = sVNFileType == SVNFileType.NONE;
            String string6 = SVNPathUtil.append(string2, SVNEncodingUtil.uriEncode(sVNEntry2.getName()));
            if (sVNEntry2.isFile()) {
                if (bl3 && !sVNEntry2.isScheduledForDeletion() && !sVNEntry2.isScheduledForReplacement()) {
                    sVNAdminArea = this.restoreFile(sVNAdminArea, sVNEntry2.getName());
                }
                String string7 = sVNEntry2.getURL();
                if (bl2) {
                    if (!string7.equals(string6)) {
                        object = SVNURL.parseURIEncoded(string7);
                        iSVNReporter.linkPath((SVNURL)object, string4, sVNEntry2.getLockToken(), sVNEntry2.getRevision(), sVNEntry2.getDepth(), false);
                        continue;
                    }
                    iSVNReporter.setPath(string4, sVNEntry2.getLockToken(), sVNEntry2.getRevision(), sVNEntry2.getDepth(), false);
                    ++this.myReportedFilesCount;
                    continue;
                }
                if (!(sVNEntry2.isScheduledForAddition() || sVNEntry2.isScheduledForReplacement() || string7.equals(string6))) {
                    object = SVNURL.parseURIEncoded(string7);
                    iSVNReporter.linkPath((SVNURL)object, string4, sVNEntry2.getLockToken(), sVNEntry2.getRevision(), sVNEntry2.getDepth(), false);
                    continue;
                }
                if (sVNEntry2.getRevision() == l2 && sVNEntry2.getLockToken() == null && sVNEntry.getDepth() != SVNDepth.EMPTY) continue;
                iSVNReporter.setPath(string4, sVNEntry2.getLockToken(), sVNEntry2.getRevision(), sVNEntry2.getDepth(), false);
                ++this.myReportedFilesCount;
                continue;
            }
            if (!sVNEntry2.isDirectory() || sVNDepth.compareTo(SVNDepth.FILES) <= 0 && sVNDepth != SVNDepth.UNKNOWN) continue;
            if (bl3) {
                if (this.myIsRestore) {
                    boolean bl4;
                    boolean bl5 = bl4 = this.myInfo.getAnchor().getWCAccess().getMaxFormatVersion() < 10;
                    if (sVNEntry2.isScheduledForReplacement() || bl4 && sVNEntry2.isScheduledForDeletion()) {
                        sVNEntry2.setSchedule(null);
                        sVNAdminArea.saveEntries(false);
                    }
                }
                if (bl2) continue;
                iSVNReporter.deletePath(string4);
                ++this.myReportedFilesCount;
                continue;
            }
            if (sVNWCAccess.isMissing(sVNAdminArea.getFile(sVNEntry2.getName()))) {
                if (this.myIsStatus) continue;
                iSVNReporter.deletePath(string4);
                ++this.myReportedFilesCount;
                continue;
            }
            SVNAdminArea sVNAdminArea2 = sVNWCAccess.retrieve(sVNAdminArea.getFile(sVNEntry2.getName()));
            object = sVNAdminArea2.getEntry(sVNAdminArea2.getThisDirName(), true);
            String string8 = ((SVNEntry)object).getURL();
            boolean bl6 = ((SVNEntry)object).isIncomplete();
            if (this.myUseDepthCompatibilityTrick && ((SVNEntry)object).getDepth().compareTo(SVNDepth.FILES) <= 0 && sVNDepth.compareTo(((SVNEntry)object).getDepth()) > 0) {
                bl6 = true;
                this.myInfo.addIncompleteEntry(string4);
            }
            if (bl2) {
                if (!string8.equals(string6)) {
                    sVNURL = SVNURL.parseURIEncoded(string8);
                    iSVNReporter.linkPath(sVNURL, string4, ((SVNEntry)object).getLockToken(), ((SVNEntry)object).getRevision(), ((SVNEntry)object).getDepth(), bl6);
                } else {
                    iSVNReporter.setPath(string4, ((SVNEntry)object).getLockToken(), ((SVNEntry)object).getRevision(), ((SVNEntry)object).getDepth(), bl6);
                    ++this.myReportedFilesCount;
                }
            } else if (!string8.equals(string6)) {
                sVNURL = SVNURL.parseURIEncoded(string8);
                iSVNReporter.linkPath(sVNURL, string4, ((SVNEntry)object).getLockToken(), ((SVNEntry)object).getRevision(), ((SVNEntry)object).getDepth(), bl6);
            } else if (((SVNEntry)object).getLockToken() != null || ((SVNEntry)object).getRevision() != l2 || ((SVNEntry)object).isIncomplete() || sVNEntry.getDepth() == SVNDepth.EMPTY || sVNEntry.getDepth() == SVNDepth.FILES || sVNEntry.getDepth() == SVNDepth.IMMEDIATES && ((SVNEntry)object).getDepth() != SVNDepth.EMPTY || SVNDepth.INFINITY.compareTo(((SVNEntry)object).getDepth()) > 0 && sVNDepth == SVNDepth.INFINITY) {
                iSVNReporter.setPath(string4, ((SVNEntry)object).getLockToken(), ((SVNEntry)object).getRevision(), ((SVNEntry)object).getDepth(), bl6);
                ++this.myReportedFilesCount;
            }
            if (sVNDepth != SVNDepth.INFINITY && sVNDepth != SVNDepth.UNKNOWN) continue;
            this.reportEntries(iSVNReporter, sVNAdminArea2, string4, ((SVNEntry)object).getRevision(), bl6, sVNDepth);
        }
    }

    private SVNAdminArea restoreFile(SVNAdminArea sVNAdminArea, String string) {
        if (!this.myIsRestore) {
            return sVNAdminArea;
        }
        if (this.myIsLockOnDemand && !sVNAdminArea.isLocked()) {
            sVNAdminArea.lock(false);
            sVNAdminArea = this.myInfo.getWCAccess().upgrade(sVNAdminArea.getRoot());
        }
        sVNAdminArea.restoreFile(string);
        SVNEntry sVNEntry = sVNAdminArea.getEntry(string, true);
        this.myInfo.getWCAccess().handleEvent(SVNEventFactory.createSVNEvent(sVNAdminArea.getFile(sVNEntry.getName()), sVNEntry.getKind(), null, sVNEntry.getRevision(), SVNEventAction.RESTORE, null, null, null));
        return sVNAdminArea;
    }

    public long getReportedFilesCount() {
        return this.myReportedFilesCount;
    }

    public long getTotalFilesCount() {
        return this.myTotalFilesCount;
    }
}

