/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNLogRunner {
    private boolean myIsEntriesChanged;
    private boolean myIsWCPropertiesChanged;
    private Map myTreeConflicts;
    private boolean myHasAddedTreeConflicts;
    private int myLogCount;
    private boolean myIsRerun;

    public SVNLogRunner(boolean bl2) {
        this.myIsRerun = bl2;
    }

    private Map getTreeConflicts() {
        if (this.myTreeConflicts == null) {
            this.myTreeConflicts = new SVNHashMap();
        }
        return this.myTreeConflicts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void runCommand(SVNAdminArea sVNAdminArea, String string, SVNProperties sVNProperties, int n2) {
        Object object;
        SVNException sVNException;
        block106: {
            String string2;
            block116: {
                block115: {
                    block114: {
                        block113: {
                            block112: {
                                block111: {
                                    block110: {
                                        sVNException = null;
                                        string2 = sVNProperties.getStringValue("name");
                                        if ("delete-entry".equals(string)) {
                                            object = sVNAdminArea.getFile(string2);
                                            SVNAdminArea sVNAdminArea2 = sVNAdminArea.getWCAccess().probeRetrieve((File)object);
                                            SVNEntry sVNEntry = sVNAdminArea2.getWCAccess().getEntry((File)object, false);
                                            if (sVNEntry == null) {
                                                return;
                                            }
                                            try {
                                                if (sVNEntry.isDirectory()) {
                                                    try {
                                                        SVNAdminArea sVNAdminArea3 = sVNAdminArea2.getWCAccess().retrieve((File)object);
                                                        if (sVNAdminArea3 != null) {
                                                            sVNAdminArea3.extendLockToTree();
                                                            sVNAdminArea3.removeFromRevisionControl(sVNAdminArea3.getThisDirName(), true, false);
                                                        } else {
                                                            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED), SVNLogType.DEFAULT);
                                                        }
                                                        break block106;
                                                    }
                                                    catch (SVNException sVNException2) {
                                                        if (sVNException2.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                                                            if (!sVNEntry.isScheduledForAddition()) {
                                                                sVNAdminArea.deleteEntry(string2);
                                                                sVNAdminArea.saveEntries(false);
                                                            }
                                                            break block106;
                                                        }
                                                        throw sVNException2;
                                                    }
                                                }
                                                if (sVNEntry.isFile()) {
                                                    sVNAdminArea.removeFromRevisionControl(string2, true, false);
                                                }
                                                break block106;
                                            }
                                            catch (SVNException sVNException3) {
                                                if (sVNException3.getErrorMessage().getErrorCode() != SVNErrorCode.WC_LEFT_LOCAL_MOD) {
                                                    sVNException = sVNException3;
                                                }
                                                break block106;
                                            }
                                        }
                                        if (!"modify-entry".equals(string)) break block110;
                                        try {
                                            Object object2;
                                            Object object3;
                                            object = new SVNHashMap();
                                            Object object4 = sVNProperties.nameSet().iterator();
                                            while (object4.hasNext()) {
                                                object3 = (String)object4.next();
                                                if ("".equals(object3) || "name".equals(object3) || "force".equals(object3)) continue;
                                                object2 = sVNProperties.getStringValue((String)object3);
                                                object3 = "svn:entry:" + (String)object3;
                                                object.put(object3, object2);
                                            }
                                            if (object.containsKey("svn:entry:text-time") && "working".equals(object4 = (String)object.get("svn:entry:text-time"))) {
                                                object3 = sVNAdminArea.getFile(string2);
                                                object4 = SVNDate.formatDate(new Date(SVNFileUtil.getFileLastModified((File)object3)));
                                                object.put("svn:entry:text-time", object4);
                                            }
                                            if (object.containsKey("svn:entry:prop-time") && "working".equals(object4 = (String)object.get("svn:entry:prop-time"))) {
                                                object3 = sVNAdminArea.getEntry(string2, false);
                                                if (object3 == null) {
                                                    return;
                                                }
                                                object4 = sVNAdminArea.getPropertyTime(string2);
                                                object.put("svn:entry:prop-time", object4);
                                            }
                                            if (object.containsKey("svn:entry:working-size") && "working".equals(object4 = (String)object.get("svn:entry:working-size"))) {
                                                object3 = sVNAdminArea.getEntry(string2, false);
                                                if (object3 == null) {
                                                    return;
                                                }
                                                object2 = sVNAdminArea.getFile(string2);
                                                if (!((File)object2).exists()) {
                                                    object.put("svn:entry:working-size", "0");
                                                } else {
                                                    try {
                                                        object.put("svn:entry:working-size", Long.toString(SVNFileUtil.getFileLength((File)object2)));
                                                    }
                                                    catch (SecurityException securityException) {
                                                        SVNErrorCode sVNErrorCode = n2 <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                                                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(sVNErrorCode, "Error getting file size on ''{0}''", object2);
                                                        SVNErrorManager.error(sVNErrorMessage, securityException, SVNLogType.WC);
                                                    }
                                                }
                                            }
                                            boolean bl2 = false;
                                            if (sVNProperties.containsName("force")) {
                                                object3 = sVNProperties.getStringValue("force");
                                                bl2 = SVNProperty.booleanValue((String)object3);
                                            }
                                            if (this.myIsRerun && sVNAdminArea.getEntry(string2, true) == null) break block106;
                                            try {
                                                sVNAdminArea.modifyEntry(string2, (Map)object, false, bl2);
                                            }
                                            catch (SVNException sVNException4) {
                                                object2 = n2 <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                                                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)object2, "Error modifying entry for ''{0}''", (Object)string2);
                                                SVNErrorManager.error(sVNErrorMessage, sVNException4, SVNLogType.WC);
                                            }
                                            this.setEntriesChanged(true);
                                        }
                                        catch (SVNException sVNException5) {
                                            sVNException = sVNException5;
                                        }
                                        break block106;
                                    }
                                    if (!"modify-wcprop".equals(string)) break block111;
                                    try {
                                        object = sVNAdminArea.getWCProperties(string2);
                                        if (object != null) {
                                            String string3 = sVNProperties.getStringValue("propname");
                                            SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue("propval");
                                            ((SVNVersionedProperties)object).setPropertyValue(string3, sVNPropertyValue);
                                            this.setWCPropertiesChanged(true);
                                        }
                                        break block106;
                                    }
                                    catch (SVNException sVNException6) {
                                        sVNException = sVNException6;
                                    }
                                    break block106;
                                }
                                if (!"delete-lock".equals(string)) break block112;
                                try {
                                    object = sVNAdminArea.getEntry(string2, true);
                                    if (object != null) {
                                        ((SVNEntry)object).setLockToken(null);
                                        ((SVNEntry)object).setLockOwner(null);
                                        ((SVNEntry)object).setLockCreationDate(null);
                                        ((SVNEntry)object).setLockComment(null);
                                        this.setEntriesChanged(true);
                                    }
                                    break block106;
                                }
                                catch (SVNException sVNException7) {
                                    SVNErrorCode sVNErrorCode = n2 <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(sVNErrorCode, "Error removing lock from entry for ''{0}''", (Object)string2);
                                    sVNException = new SVNException(sVNErrorMessage, (Throwable)sVNException7);
                                }
                                break block106;
                            }
                            if (!"delete-changelist".equals(string)) break block113;
                            try {
                                object = new SVNHashMap();
                                object.put("svn:entry:changelist", null);
                                sVNAdminArea.modifyEntry(string2, (Map)object, false, false);
                                this.setEntriesChanged(true);
                            }
                            catch (SVNException sVNException8) {
                                SVNErrorCode sVNErrorCode = n2 <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(sVNErrorCode, "Error removing changelist from entry ''{0}''", (Object)string2);
                                sVNException = new SVNException(sVNErrorMessage, (Throwable)sVNException8);
                            }
                            break block106;
                        }
                        if (!"rm".equals(string)) break block114;
                        object = sVNAdminArea.getFile(string2);
                        SVNFileUtil.deleteFile((File)object);
                        break block106;
                    }
                    if (!"readonly".equals(string)) break block115;
                    object = sVNAdminArea.getFile(string2);
                    SVNFileUtil.setReadonly((File)object, true);
                    break block106;
                }
                if ("mv".equals(string)) {
                    object = sVNAdminArea.getFile(string2);
                    File file = sVNAdminArea.getFile(sVNProperties.getStringValue("dest"));
                    try {
                        SVNFileUtil.rename((File)object, file);
                    }
                    catch (SVNException sVNException9) {
                        if (!this.myIsRerun || ((File)object).exists()) {
                            sVNException = new SVNException(sVNException9.getErrorMessage().wrap("Can't move source to dest"), (Throwable)sVNException9);
                        }
                        break block106;
                    }
                }
                if (!"append".equals(string)) break block116;
                object = sVNAdminArea.getFile(string2);
                File file = sVNAdminArea.getFile(sVNProperties.getStringValue("dest"));
                OutputStream outputStream = null;
                InputStream inputStream = null;
                try {
                    int n3;
                    outputStream = SVNFileUtil.openFileForWriting(file, true);
                    inputStream = SVNFileUtil.openFileForReading((File)object, SVNLogType.WC);
                    while ((n3 = inputStream.read()) >= 0) {
                        outputStream.write(n3);
                    }
                }
                catch (IOException iOException) {
                    block107: {
                        if (this.myIsRerun && iOException instanceof FileNotFoundException) break block107;
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write to ''{0}'': {1}", file, iOException.getLocalizedMessage());
                        sVNException = new SVNException(sVNErrorMessage, (Throwable)iOException);
                    }
                    SVNFileUtil.closeFile(outputStream);
                    SVNFileUtil.closeFile(inputStream);
                    break block106;
                }
                catch (SVNException sVNException10) {
                    block108: {
                        if (this.myIsRerun && !((File)object).exists()) break block108;
                        sVNException = sVNException10;
                        {
                            catch (Throwable throwable) {
                                SVNFileUtil.closeFile(outputStream);
                                SVNFileUtil.closeFile(inputStream);
                                throw throwable;
                            }
                        }
                    }
                    SVNFileUtil.closeFile(outputStream);
                    SVNFileUtil.closeFile(inputStream);
                    break block106;
                }
                SVNFileUtil.closeFile(outputStream);
                SVNFileUtil.closeFile(inputStream);
                break block106;
            }
            if ("set-timestamp".equals(string)) {
                object = sVNAdminArea.getFile(string2);
                String string4 = sVNProperties.getStringValue("timestamp");
                try {
                    Serializable serializable;
                    if (string4 == null) {
                        serializable = n2 <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)serializable, "Missing 'timestamp' attribute in ''{0}''", (Object)sVNAdminArea.getRoot());
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                    }
                    if (!SVNFileUtil.setLastModified((File)object, ((Date)(serializable = SVNDate.parseDate(string4))).getTime()) && !((File)object).canWrite() && ((File)object).isFile()) {
                        SVNFileUtil.setReadonly((File)object, false);
                        SVNFileUtil.setLastModified((File)object, ((Date)serializable).getTime());
                        SVNFileUtil.setReadonly((File)object, true);
                    }
                }
                catch (SVNException sVNException11) {
                    sVNException = sVNException11;
                }
            } else if ("upgrade-format".equals(string)) {
                object = sVNProperties.getStringValue("format");
                SVNErrorCode sVNErrorCode = n2 <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                try {
                    if (object == null) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(sVNErrorCode, "Invalid 'format' attribute");
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                    }
                    int n4 = -1;
                    try {
                        n4 = Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(sVNErrorCode, "Invalid 'format' attribute");
                        SVNErrorManager.error(sVNErrorMessage, numberFormatException, SVNLogType.WC);
                    }
                    if (n4 == 0) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(sVNErrorCode, "Invalid 'format' attribute");
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                    }
                    sVNAdminArea.postUpgradeFormat(n4);
                    this.setEntriesChanged(true);
                }
                catch (SVNException sVNException12) {
                    sVNException = sVNException12;
                }
            } else if ("maybe-readonly".equals(string)) {
                object = sVNAdminArea.getFile(string2);
                try {
                    SVNEntry sVNEntry = sVNAdminArea.getEntry(string2, false);
                    if (sVNEntry == null) break block106;
                    sVNAdminArea.closeVersionedProperties();
                    SVNVersionedProperties sVNVersionedProperties = sVNAdminArea.getProperties(string2);
                    String string5 = sVNVersionedProperties.getStringPropertyValue("svn:needs-lock");
                    if (sVNEntry.getLockToken() == null && string5 != null) {
                        SVNFileUtil.setReadonly((File)object, true);
                    }
                }
                catch (SVNException sVNException13) {
                    sVNException = sVNException13;
                }
            } else if ("maybe-executable".equals(string)) {
                boolean bl3;
                sVNAdminArea.closeVersionedProperties();
                object = sVNAdminArea.getProperties(string2);
                boolean bl4 = SVNFileUtil.isWindows ? false : (bl3 = ((SVNVersionedProperties)object).getPropertyValue("svn:executable") != null);
                if (bl3) {
                    SVNFileUtil.setExecutable(sVNAdminArea.getFile(string2), true);
                }
            } else if ("cp-and-translate".equals(string)) {
                object = sVNProperties.getStringValue("dest");
                Object object5 = sVNProperties.getStringValue("arg2");
                if (object5 == null) {
                    object5 = object;
                }
                File file = sVNAdminArea.getFile(string2);
                File file2 = sVNAdminArea.getFile((String)object);
                sVNAdminArea.closeVersionedProperties();
                try {
                    SVNEntry sVNEntry;
                    boolean bl5;
                    block109: {
                        try {
                            SVNTranslator.translate(sVNAdminArea, (String)object5, file, file2, null, true);
                        }
                        catch (SVNException sVNException14) {
                            if (this.myIsRerun && !file.exists()) break block109;
                            throw sVNException14;
                        }
                    }
                    SVNVersionedProperties sVNVersionedProperties = sVNAdminArea.getProperties((String)object);
                    boolean bl6 = SVNFileUtil.isWindows ? false : (bl5 = sVNVersionedProperties.getPropertyValue("svn:executable") != null);
                    if (bl5) {
                        SVNFileUtil.setExecutable(file2, true);
                    }
                    if ((sVNEntry = sVNAdminArea.getEntry((String)object, false)) != null && sVNEntry.getLockToken() == null && sVNVersionedProperties.getPropertyValue("svn:needs-lock") != null) {
                        SVNFileUtil.setReadonly(file2, true);
                    }
                }
                catch (SVNException sVNException15) {
                    sVNException = sVNException15;
                }
            } else if ("cp-and-detranslate".equals(string)) {
                object = sVNProperties.getStringValue("dest");
                String string6 = sVNProperties.getStringValue("arg2");
                sVNAdminArea.closeVersionedProperties();
                try {
                    SVNTranslator.translate(sVNAdminArea, string6 != null ? string6 : string2, string2, (String)object, false);
                }
                catch (SVNException sVNException16) {
                    sVNException = sVNException16;
                }
            } else if ("cp".equals(string)) {
                object = sVNAdminArea.getFile(string2);
                File file = sVNAdminArea.getFile(sVNProperties.getStringValue("dest"));
                try {
                    SVNFileUtil.copy((File)object, file, true, false);
                }
                catch (SVNException sVNException17) {
                    sVNException = sVNException17;
                }
            } else if ("add-tree-conflict".equals(string)) {
                object = sVNAdminArea.getRoot();
                String string7 = sVNProperties.getStringValue("data");
                Map map = SVNTreeConflictUtil.readTreeConflicts((File)object, string7);
                Object[] objectArray = map.values().toArray();
                SVNTreeConflictDescription sVNTreeConflictDescription = (SVNTreeConflictDescription)objectArray[0];
                if (!this.getTreeConflicts().containsKey(sVNTreeConflictDescription.getPath())) {
                    this.getTreeConflicts().put(sVNTreeConflictDescription.getPath(), sVNTreeConflictDescription);
                    this.setTreeConflictsAdded(true);
                }
            } else {
                if ("merge".equals(string)) {
                    object = sVNAdminArea.getFile(string2);
                    try {
                        Object object6;
                        Object object7;
                        SVNErrorCode sVNErrorCode = n2 <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                        String string8 = sVNProperties.getStringValue("arg1");
                        if (string8 == null) {
                            object7 = SVNErrorMessage.create(sVNErrorCode, "Missing 'left' attribute in ''{0}''", (Object)sVNAdminArea.getRoot());
                            SVNErrorManager.error((SVNErrorMessage)object7, SVNLogType.WC);
                        }
                        if ((object7 = sVNProperties.getStringValue("arg2")) == null) {
                            object6 = SVNErrorMessage.create(sVNErrorCode, "Missing 'right' attribute in ''{0}''", (Object)sVNAdminArea.getRoot());
                            SVNErrorManager.error((SVNErrorMessage)object6, SVNLogType.WC);
                        }
                        object6 = (object6 = sVNProperties.getStringValue("arg3")) == null ? ".old" : object6;
                        String string9 = sVNProperties.getStringValue("arg4");
                        string9 = string9 == null ? ".new" : string9;
                        String string10 = sVNProperties.getStringValue("arg5");
                        string10 = string10 == null ? ".working" : string10;
                        sVNAdminArea.closeVersionedProperties();
                        SVNVersionedProperties sVNVersionedProperties = sVNAdminArea.getProperties(string2);
                        SVNEntry sVNEntry = sVNAdminArea.getEntry(string2, true);
                        SVNStatusType sVNStatusType = sVNAdminArea.mergeText(string2, sVNAdminArea.getFile(string8), sVNAdminArea.getFile((String)object7), null, string10, (String)object6, string9, null, false, null, null);
                        if (sVNVersionedProperties.getPropertyValue("svn:executable") != null) {
                            SVNFileUtil.setExecutable((File)object, true);
                        }
                        if (sVNVersionedProperties.getPropertyValue("svn:needs-lock") != null && sVNEntry.getLockToken() == null) {
                            SVNFileUtil.setReadonly((File)object, true);
                        }
                        this.setEntriesChanged(sVNStatusType == SVNStatusType.CONFLICTED || sVNStatusType == SVNStatusType.CONFLICTED_UNRESOLVED);
                    }
                    catch (SVNException sVNException18) {
                        sVNException = sVNException18;
                        if (this.myIsRerun && sVNException18.getCause() instanceof FileNotFoundException) {
                            sVNException = null;
                        }
                        break block106;
                    }
                }
                if ("committed".equals(string)) {
                    try {
                        Object object8;
                        Object object9 = object = n2 <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                        if (sVNProperties.getStringValue("revision") == null) {
                            object8 = SVNErrorMessage.create((SVNErrorCode)object, "Missing revision attribute for ''{0}''", (Object)string2);
                            SVNErrorManager.error((SVNErrorMessage)object8, SVNLogType.WC);
                        }
                        object8 = sVNAdminArea.getEntry(string2, true);
                        if (this.myIsRerun && (object8 == null || ((SVNEntry)object8).isScheduledForDeletion() && ((SVNEntry)object8).isDeleted())) break block106;
                        if (object8 == null || !sVNAdminArea.getThisDirName().equals(string2) && ((SVNEntry)object8).getKind() != SVNNodeKind.FILE) {
                            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)object, "Log command for directory ''{0}'' is mislocated", (Object)sVNAdminArea.getRoot());
                            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                        }
                        boolean bl7 = sVNProperties.getStringValue("implicit") != null && ((SVNEntry)object8).isCopied();
                        this.setEntriesChanged(true);
                        long l2 = -1L;
                        try {
                            l2 = Long.parseLong(sVNProperties.getStringValue("revision"));
                        }
                        catch (NumberFormatException numberFormatException) {
                            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.WC_BAD_ADM_LOG, numberFormatException), SVNLogType.WC);
                        }
                        sVNAdminArea.postCommit(string2, l2, bl7, this.myIsRerun, (SVNErrorCode)object);
                    }
                    catch (SVNException sVNException19) {
                        sVNException = sVNException19;
                    }
                } else {
                    object = n2 <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)object, "Unrecognized logfile element ''{0}'' in ''{1}''", string, sVNAdminArea.getRoot());
                    SVNErrorManager.error(sVNErrorMessage.wrap("In directory ''{0}''", sVNAdminArea.getRoot()), SVNLogType.WC);
                }
            }
        }
        this.myLogCount = n2;
        if (sVNException != null) {
            object = n2 <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)object, "Error processing command ''{0}'' in ''{1}''", string, sVNAdminArea.getRoot());
            SVNErrorManager.error(sVNErrorMessage, sVNException, SVNLogType.WC);
        }
    }

    private void setTreeConflictsAdded(boolean bl2) {
        this.myHasAddedTreeConflicts |= bl2;
    }

    private void setEntriesChanged(boolean bl2) {
        this.myIsEntriesChanged |= bl2;
    }

    private void setWCPropertiesChanged(boolean bl2) {
        this.myIsWCPropertiesChanged |= bl2;
    }

    private void saveTreeConflicts(SVNAdminArea sVNAdminArea) {
        SVNHashMap sVNHashMap = new SVNHashMap();
        String string = SVNTreeConflictUtil.getTreeConflictData(this.getTreeConflicts());
        sVNHashMap.put("svn:entry:tree-conflicts", string);
        try {
            sVNAdminArea.modifyEntry(sVNAdminArea.getThisDirName(), sVNHashMap, false, false);
        }
        catch (SVNException sVNException) {
            SVNErrorCode sVNErrorCode = this.myLogCount <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(sVNErrorCode, "Error recording tree conflicts in ''{0}''", (Object)sVNAdminArea.getRoot());
            SVNErrorManager.error(sVNErrorMessage, sVNException, SVNLogType.WC);
        }
        this.myIsEntriesChanged = true;
    }

    public void logStarted(SVNAdminArea sVNAdminArea) {
        SVNEntry sVNEntry = sVNAdminArea.getEntry(sVNAdminArea.getThisDirName(), false);
        Map map = sVNEntry.getTreeConflicts();
        if (map != null) {
            this.getTreeConflicts().putAll(map);
        }
        this.myHasAddedTreeConflicts = false;
        this.myLogCount = 0;
    }

    public void logFailed(SVNAdminArea sVNAdminArea) {
        if (this.myHasAddedTreeConflicts) {
            this.saveTreeConflicts(sVNAdminArea);
        }
        if (this.myIsWCPropertiesChanged) {
            sVNAdminArea.saveWCProperties(true);
        } else {
            sVNAdminArea.closeWCProperties();
        }
        if (this.myIsEntriesChanged) {
            sVNAdminArea.saveEntries(false);
        } else {
            sVNAdminArea.closeEntries();
        }
        this.myLogCount = 0;
    }

    public void logCompleted(SVNAdminArea sVNAdminArea) {
        if (this.myHasAddedTreeConflicts) {
            this.saveTreeConflicts(sVNAdminArea);
        }
        if (this.myIsWCPropertiesChanged) {
            sVNAdminArea.saveWCProperties(true);
        }
        if (this.myIsEntriesChanged) {
            sVNAdminArea.saveEntries(false);
        }
        sVNAdminArea.handleKillMe();
        this.myIsEntriesChanged = false;
        this.myIsWCPropertiesChanged = false;
        this.myHasAddedTreeConflicts = false;
        this.myLogCount = 0;
    }
}

