/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNLogImpl
extends SVNLog {
    private File myFile;
    private File myTmpFile;

    public SVNLogImpl(File file, File file2, SVNAdminArea sVNAdminArea) {
        super(sVNAdminArea);
        this.myFile = file;
        this.myTmpFile = file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        if (this.myCache == null) {
            return;
        }
        OutputStreamWriter outputStreamWriter = null;
        File file = this.myTmpFile != null ? this.myTmpFile : SVNFileUtil.createUniqueFile(this.myAdminArea.getAdminFile("tmp"), "log", ".tmp", false);
        try {
            outputStreamWriter = new OutputStreamWriter(SVNFileUtil.openFileForWriting(file), "UTF-8");
            for (SVNProperties sVNProperties : this.myCache) {
                SVNPropertyValue sVNPropertyValue = sVNProperties.remove("");
                outputStreamWriter.write("<");
                outputStreamWriter.write(sVNPropertyValue.getString());
                for (String string : sVNProperties.nameSet()) {
                    SVNPropertyValue sVNPropertyValue2 = sVNProperties.getSVNPropertyValue(string);
                    String string2 = null;
                    string2 = sVNPropertyValue2 == null ? "" : SVNPropertyValue.getPropertyAsString(sVNPropertyValue2);
                    string2 = SVNEncodingUtil.xmlEncodeAttr(string2);
                    outputStreamWriter.write("\n   ");
                    outputStreamWriter.write(string);
                    outputStreamWriter.write("=\"");
                    outputStreamWriter.write(string2);
                    outputStreamWriter.write("\"");
                }
                outputStreamWriter.write("/>\n");
            }
        }
        catch (IOException iOException) {
            try {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write log file ''{0}'': {1}", this.myFile, iOException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(outputStreamWriter);
                this.myCache = null;
                throw throwable;
            }
            SVNFileUtil.closeFile(outputStreamWriter);
            this.myCache = null;
        }
        SVNFileUtil.closeFile(outputStreamWriter);
        this.myCache = null;
        SVNFileUtil.rename(file, this.myFile);
        SVNFileUtil.setReadonly(this.myFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection readCommands() {
        if (!this.myFile.exists()) {
            return null;
        }
        BufferedReader bufferedReader = null;
        ArrayList<SVNProperties> arrayList = new ArrayList<SVNProperties>();
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(this.myFile, SVNLogType.WC), "UTF-8"));
            SVNProperties sVNProperties = new SVNProperties();
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).startsWith("<")) {
                    string2 = string.substring(1);
                    continue;
                }
                int n2 = string.indexOf(61);
                if (n2 > 0) {
                    String string3 = string.substring(0, n2).trim();
                    String string4 = string.substring(n2 + 1).trim();
                    if (string4.endsWith("/>")) {
                        string4 = string4.substring(0, string4.length() - "/>".length());
                    }
                    if (string4.startsWith("\"")) {
                        string4 = string4.substring(1);
                    }
                    if (string4.endsWith("\"")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    if ("".equals(string4 = SVNEncodingUtil.xmlDecode(string4)) && !"name".equals(string3)) {
                        string4 = null;
                    }
                    sVNProperties.put(string3, string4);
                }
                if (!string.endsWith("/>") || string2 == null) continue;
                sVNProperties.put("", string2);
                arrayList.add(sVNProperties);
                sVNProperties = new SVNProperties();
                string2 = null;
            }
        }
        catch (IOException iOException) {
            try {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read log file ''{0}'': {1}", this.myFile, iOException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.WC);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(bufferedReader);
                throw throwable;
            }
            SVNFileUtil.closeFile(bufferedReader);
        }
        SVNFileUtil.closeFile(bufferedReader);
        return arrayList;
    }

    @Override
    public String toString() {
        return "Log: " + this.myFile;
    }

    @Override
    public void delete() {
        SVNFileUtil.deleteFile(this.myFile);
        SVNFileUtil.deleteFile(this.myTmpFile);
    }

    @Override
    public boolean exists() {
        return this.myFile.exists();
    }
}

