/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLogRunner;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SVNLog {
    public static final String DELETE_CHANGELIST = "delete-changelist";
    public static final String DELETE_ENTRY = "delete-entry";
    public static final String MODIFY_ENTRY = "modify-entry";
    public static final String MODIFY_WC_PROPERTY = "modify-wcprop";
    public static final String DELETE_LOCK = "delete-lock";
    public static final String MOVE = "mv";
    public static final String APPEND = "append";
    public static final String DELETE = "rm";
    public static final String READONLY = "readonly";
    public static final String COPY_AND_TRANSLATE = "cp-and-translate";
    public static final String COPY_AND_DETRANSLATE = "cp-and-detranslate";
    public static final String COPY = "cp";
    public static final String MERGE = "merge";
    public static final String MAYBE_READONLY = "maybe-readonly";
    public static final String MAYBE_EXECUTABLE = "maybe-executable";
    public static final String SET_TIMESTAMP = "set-timestamp";
    public static final String COMMIT = "committed";
    public static final String UPGRADE_FORMAT = "upgrade-format";
    public static final String ADD_TREE_CONFLICT = "add-tree-conflict";
    public static final String NAME_ATTR = "name";
    public static final String DATA_ATTR = "data";
    public static final String PROPERTY_NAME_ATTR = "propname";
    public static final String PROPERTY_VALUE_ATTR = "propval";
    public static final String DEST_ATTR = "dest";
    public static final String TIMESTAMP_ATTR = "timestamp";
    public static final String REVISION_ATTR = "revision";
    public static final String FORMAT_ATTR = "format";
    public static final String FORCE_ATTR = "force";
    public static final String ATTR1 = "arg1";
    public static final String ATTR2 = "arg2";
    public static final String ATTR3 = "arg3";
    public static final String ATTR4 = "arg4";
    public static final String ATTR5 = "arg5";
    public static final String ATTR6 = "arg6";
    public static final String WC_TIMESTAMP = "working";
    public static final String WC_WORKING_SIZE = "working";
    protected Collection myCache;
    protected SVNAdminArea myAdminArea;

    public abstract void save();

    public abstract String toString();

    public abstract void delete();

    public abstract boolean exists();

    protected SVNLog(SVNAdminArea sVNAdminArea) {
        this.myAdminArea = sVNAdminArea;
    }

    public void addCommand(String string, SVNProperties sVNProperties, boolean bl2) {
        if (this.myCache == null) {
            this.myCache = new ArrayList();
        }
        sVNProperties = new SVNProperties(sVNProperties);
        sVNProperties.put("", string);
        this.myCache.add(sVNProperties);
        if (bl2) {
            this.save();
        }
    }

    public void deleteCommandsByName(String string, boolean bl2) {
        if (this.myCache == null) {
            return;
        }
        Iterator iterator = this.myCache.iterator();
        while (iterator.hasNext()) {
            SVNProperties sVNProperties;
            String string2;
            Object e2 = iterator.next();
            if (!(e2 instanceof SVNProperties) || !string.equals(string2 = (sVNProperties = (SVNProperties)e2).getStringValue(""))) continue;
            iterator.remove();
        }
        if (bl2) {
            this.save();
        }
    }

    public void deleteLastCommand(boolean bl2) {
        if (this.myCache == null) {
            return;
        }
        int n2 = this.myCache.size();
        int n3 = 0;
        Iterator iterator = this.myCache.iterator();
        while (iterator.hasNext()) {
            if (n3 == n2 - 1) {
                iterator.remove();
            }
            ++n3;
        }
        if (bl2) {
            this.save();
        }
    }

    public void deleteCommandsByNameAndAttributes(String string, SVNProperties sVNProperties, boolean bl2) {
        if (this.myCache == null) {
            return;
        }
        Iterator iterator = this.myCache.iterator();
        while (iterator.hasNext()) {
            SVNProperties sVNProperties2;
            String string2;
            Object e2 = iterator.next();
            if (!(e2 instanceof SVNProperties) || !string.equals(string2 = (sVNProperties2 = (SVNProperties)e2).getStringValue(""))) continue;
            SVNProperties sVNProperties3 = new SVNProperties(sVNProperties2);
            sVNProperties3.remove("");
            if (!sVNProperties3.equals(sVNProperties)) continue;
            iterator.remove();
        }
        if (bl2) {
            this.save();
        }
    }

    public SVNStatusType logChangedEntryProperties(String string, SVNProperties sVNProperties) {
        SVNStatusType sVNStatusType = SVNStatusType.LOCK_UNCHANGED;
        if (sVNProperties != null) {
            SVNProperties sVNProperties2 = new SVNProperties();
            sVNProperties2.put(NAME_ATTR, string);
            for (String string2 : sVNProperties.nameSet()) {
                String string3;
                SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string2);
                String string4 = string3 = !string2.startsWith("svn:entry:") ? "svn:entry:" + string2 : string2;
                if ("svn:entry:lock-token".equals(string3)) {
                    SVNProperties sVNProperties3 = new SVNProperties();
                    sVNProperties3.put(NAME_ATTR, string);
                    this.addCommand(DELETE_LOCK, sVNProperties3, false);
                    sVNStatusType = SVNStatusType.LOCK_UNLOCKED;
                    continue;
                }
                if (sVNPropertyValue == null) continue;
                sVNProperties2.put(string2, sVNPropertyValue);
            }
            this.addCommand(MODIFY_ENTRY, sVNProperties2, false);
            sVNProperties2.clear();
        }
        return sVNStatusType;
    }

    public void logChangedWCProperties(String string, SVNProperties sVNProperties) {
        if (sVNProperties != null) {
            SVNProperties sVNProperties2 = new SVNProperties();
            sVNProperties2.put(NAME_ATTR, string);
            for (String string2 : sVNProperties.nameSet()) {
                SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string2);
                sVNProperties2.put(PROPERTY_NAME_ATTR, string2);
                if (sVNPropertyValue != null) {
                    sVNProperties2.put(PROPERTY_VALUE_ATTR, sVNPropertyValue);
                } else {
                    sVNProperties2.remove(PROPERTY_VALUE_ATTR);
                }
                this.addCommand(MODIFY_WC_PROPERTY, sVNProperties2, false);
            }
        }
    }

    public void logTweakEntry(String string, String string2, long l2) {
        SVNProperties sVNProperties = new SVNProperties();
        sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:kind"), "file");
        sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:revision"), Long.toString(l2));
        sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:deleted"), Boolean.FALSE.toString());
        sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:absent"), Boolean.FALSE.toString());
        sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:working-size"), Long.toString(-1L));
        sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:text-time"), SVNDate.NULL.format());
        if (string2 != null) {
            sVNProperties.put(SVNProperty.shortPropertyName("svn:entry:url"), string2);
        }
        this.logChangedEntryProperties(string, sVNProperties);
    }

    public void logRemoveRevertFile(String string, SVNAdminArea sVNAdminArea, boolean bl2) {
        String string2 = null;
        string2 = bl2 ? SVNAdminUtil.getPropRevertPath(string, SVNNodeKind.FILE, false) : SVNAdminUtil.getTextRevertPath(string, false);
        File file = sVNAdminArea.getFile(string2);
        if (file.isFile()) {
            SVNProperties sVNProperties = new SVNProperties();
            sVNProperties.put(NAME_ATTR, string2);
            this.addCommand(DELETE, sVNProperties, false);
            sVNProperties.clear();
        }
    }

    public void run(SVNLogRunner sVNLogRunner) {
        Collection collection = this.readCommands();
        if (collection == null || collection.isEmpty()) {
            return;
        }
        try {
            int n2 = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SVNProperties sVNProperties = (SVNProperties)iterator.next();
                String string = sVNProperties.getStringValue("");
                String string2 = sVNProperties.getStringValue(NAME_ATTR);
                if (string2 == null && !UPGRADE_FORMAT.equals(string)) {
                    SVNErrorCode sVNErrorCode = n2 <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(sVNErrorCode, "Log entry missing ''name'' attribute (entry ''{0}'' for directory ''{1}'')", string, this.myAdminArea.getRoot());
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
                if (sVNLogRunner != null) {
                    sVNLogRunner.runCommand(this.myAdminArea, string, sVNProperties, ++n2);
                }
                iterator.remove();
            }
        }
        catch (SVNException sVNException) {
            this.myCache = null;
            for (SVNProperties sVNProperties : collection) {
                SVNPropertyValue sVNPropertyValue = sVNProperties.remove("");
                this.addCommand(sVNPropertyValue.getString(), sVNProperties, false);
            }
            this.save();
            throw sVNException;
        }
    }

    protected abstract Collection readCommands();
}

