/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.util.Arrays;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea14;
import org.tmatesoft.svn.core.wc.SVNRevision;

public abstract class SVNEntry {
    private String myName;
    private String author;
    private String[] cachableProperties;
    private String changelistName;
    private String checksum;
    private SVNDate committedDate;
    private long committedRevision;
    private String conflictNew;
    private String conflictOld;
    private String conflictWorking;
    private long copyFromRevision;
    private String copyFromURL;
    private SVNDepth depth;
    private String externalFilePath;
    private SVNRevision externalFilePegRevision;
    private SVNRevision externalFileRevision;
    private SVNNodeKind kind;
    private String lockComment;
    private SVNDate lockCreationDate;
    private String lockOwner;
    private String lockToken;
    private String[] presentProperties;
    private String propRejectFile;
    private SVNDate propTime;
    private String repositoryRoot;
    private long revision;
    private String schedule;
    private SVNDate textTime;
    private String treeConflictData;
    private String url;
    private String uuid;
    private long workingSize;
    private boolean absent;
    private boolean copied;
    private boolean deleted;
    private boolean incomplete;
    private boolean keepLocal;
    private boolean hasProperties;
    private boolean hasPropertiesModifications;
    private String parentURL;

    public abstract boolean isThisDir();

    public abstract SVNAdminArea getAdminArea();

    public String getURL() {
        if (this.url == null && this.parentURL != null) {
            return SVNPathUtil.append(this.parentURL, SVNEncodingUtil.uriEncode(this.myName));
        }
        return this.url;
    }

    public SVNURL getSVNURL() {
        String string = this.getURL();
        if (string != null) {
            return SVNURL.parseURIEncoded(string);
        }
        return null;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isDirectory() {
        return this.kind == SVNNodeKind.DIR;
    }

    public long getRevision() {
        return this.revision;
    }

    public boolean isScheduledForAddition() {
        return "add".equals(this.schedule);
    }

    public boolean isScheduledForDeletion() {
        return "delete".equals(this.schedule);
    }

    public boolean isScheduledForReplacement() {
        return "replace".equals(this.schedule);
    }

    public boolean isHidden() {
        return this.isDeleted() && !this.isScheduledForAddition() && !this.isScheduledForReplacement() || this.isAbsent() || this.getDepth() == SVNDepth.EXCLUDE;
    }

    public boolean isFile() {
        return this.kind == SVNNodeKind.FILE;
    }

    public String getLockToken() {
        return this.lockToken;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isAbsent() {
        return this.absent;
    }

    public String toString() {
        return this.myName;
    }

    public boolean setRevision(long l2) {
        boolean bl2 = l2 != this.revision;
        this.revision = l2;
        return bl2;
    }

    public boolean setCommittedRevision(long l2) {
        boolean bl2 = l2 != this.committedRevision;
        this.committedRevision = l2;
        return bl2;
    }

    public boolean setAuthor(String string) {
        boolean bl2 = string != null ? !string.equals(this.author) : string != this.author;
        this.author = string;
        return bl2;
    }

    public boolean setChangelistName(String string) {
        boolean bl2 = string != null ? !string.equals(this.changelistName) : string != this.changelistName;
        this.changelistName = string;
        return bl2;
    }

    public String getChangelistName() {
        return this.changelistName;
    }

    public boolean setWorkingSize(long l2) {
        boolean bl2 = this.workingSize != l2;
        this.workingSize = l2;
        return bl2;
    }

    public long getWorkingSize() {
        return this.workingSize;
    }

    public SVNDepth getDepth() {
        return this.depth;
    }

    public void setDepth(SVNDepth sVNDepth) {
        if (sVNDepth == null) {
            sVNDepth = SVNDepth.INFINITY;
        }
        this.depth = sVNDepth;
    }

    public boolean setURL(String string) {
        boolean bl2 = string != null ? !string.equals(this.url) : string != this.url;
        this.url = string;
        return bl2;
    }

    public void setIncomplete(boolean bl2) {
        this.incomplete = bl2;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public String getConflictOld() {
        return this.conflictOld;
    }

    public void setConflictOld(String string) {
        this.conflictOld = string;
    }

    public String getConflictNew() {
        return this.conflictNew;
    }

    public void setConflictNew(String string) {
        this.conflictNew = string;
    }

    public String getConflictWorking() {
        return this.conflictWorking;
    }

    public void setConflictWorking(String string) {
        this.conflictWorking = string;
    }

    public String getPropRejectFile() {
        return this.propRejectFile;
    }

    public void setPropRejectFile(String string) {
        this.propRejectFile = string;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setCommittedDate(String string) {
        this.committedDate = string != null ? SVNDate.parseDate(string) : null;
    }

    public String getCommittedDate() {
        return this.committedDate != null ? this.committedDate.format() : null;
    }

    public long getCommittedRevision() {
        return this.committedRevision;
    }

    public void setTextTime(String string) {
        this.textTime = string != null ? SVNDate.parseDate(string) : null;
    }

    public void setKind(SVNNodeKind sVNNodeKind) {
        this.kind = sVNNodeKind;
    }

    public void setAbsent(boolean bl2) {
        this.absent = bl2;
    }

    public void setDeleted(boolean bl2) {
        this.deleted = bl2;
    }

    public SVNNodeKind getKind() {
        return this.kind;
    }

    public String getTextTime() {
        return this.textTime != null ? this.textTime.format() : null;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String string) {
        this.checksum = string;
    }

    public void setLockComment(String string) {
        this.lockComment = string;
    }

    public void setLockOwner(String string) {
        this.lockOwner = string;
    }

    public void setLockCreationDate(String string) {
        this.lockCreationDate = string != null ? SVNDate.parseDate(string) : null;
    }

    public void setLockToken(String string) {
        this.lockToken = string;
    }

    public void setUUID(String string) {
        this.uuid = string;
    }

    public void unschedule() {
        this.schedule = null;
    }

    public void scheduleForAddition() {
        this.schedule = "add";
    }

    public void scheduleForDeletion() {
        this.schedule = "delete";
    }

    public void scheduleForReplacement() {
        this.schedule = "replace";
    }

    public void setSchedule(String string) {
        this.schedule = string;
    }

    public void setCopyFromRevision(long l2) {
        this.copyFromRevision = l2;
    }

    public boolean setCopyFromURL(String string) {
        boolean bl2 = string != null ? !string.equals(this.copyFromURL) : string != this.copyFromURL;
        this.copyFromURL = string;
        return bl2;
    }

    public void setCopied(boolean bl2) {
        this.copied = bl2;
    }

    public String getCopyFromURL() {
        return this.copyFromURL;
    }

    public SVNURL getCopyFromSVNURL() {
        String string = this.getCopyFromURL();
        if (string != null) {
            return SVNURL.parseURIEncoded(string);
        }
        return null;
    }

    public long getCopyFromRevision() {
        return this.copyFromRevision;
    }

    public String getPropTime() {
        return this.propTime != null ? this.propTime.format() : null;
    }

    public void setPropTime(String string) {
        this.propTime = string != null ? SVNDate.parseDate(string) : null;
    }

    public boolean isCopied() {
        return this.copied;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public SVNURL getRepositoryRootURL() {
        String string = this.getRepositoryRoot();
        if (string != null) {
            return SVNURL.parseURIEncoded(string);
        }
        return null;
    }

    public boolean setRepositoryRoot(String string) {
        boolean bl2 = string != null ? !string.equals(this.repositoryRoot) : string != this.repositoryRoot;
        this.repositoryRoot = string;
        return bl2;
    }

    public boolean setRepositoryRootURL(SVNURL sVNURL) {
        return this.setRepositoryRoot(sVNURL == null ? null : sVNURL.toString());
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public String getLockComment() {
        return this.lockComment;
    }

    public String getLockCreationDate() {
        return this.lockCreationDate != null ? this.lockCreationDate.format() : null;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setCachableProperties(String[] stringArray) {
        this.cachableProperties = stringArray;
    }

    public void setPresentProperties(String[] stringArray) {
        this.presentProperties = stringArray;
    }

    public void setKeepLocal(boolean bl2) {
        this.keepLocal = bl2;
    }

    public boolean isKeepLocal() {
        return this.keepLocal;
    }

    public String[] getCachableProperties() {
        return this.cachableProperties;
    }

    public String[] getPresentProperties() {
        return this.presentProperties;
    }

    public String getExternalFilePath() {
        return this.externalFilePath;
    }

    public SVNRevision getExternalFileRevision() {
        return this.externalFileRevision;
    }

    public SVNRevision getExternalFilePegRevision() {
        return this.externalFilePegRevision;
    }

    public void setExternalFilePath(String string) {
        this.externalFilePath = string;
    }

    public void setExternalFileRevision(SVNRevision sVNRevision) {
        this.externalFileRevision = sVNRevision;
    }

    public void setExternalFilePegRevision(SVNRevision sVNRevision) {
        this.externalFilePegRevision = sVNRevision;
    }

    public String getTreeConflictData() {
        return this.treeConflictData;
    }

    public abstract Map getTreeConflicts();

    public void setTreeConflictData(String string) {
        this.treeConflictData = string;
    }

    public void setTreeConflicts(Map map) {
        String string = SVNTreeConflictUtil.getTreeConflictData(map);
        this.setTreeConflictData(string);
    }

    public void setHasProperties(boolean bl2) {
        this.hasProperties = bl2;
    }

    public void setHasPropertiesModifications(boolean bl2) {
        this.hasPropertiesModifications = bl2;
    }

    public boolean hasPropertiesModifications() {
        return this.hasPropertiesModifications;
    }

    public boolean hasProperties() {
        return this.hasProperties;
    }

    public void setParentURL(String string) {
        this.parentURL = string;
    }

    public void setName(String string) {
        this.myName = string;
    }

    public void applyChanges(Map map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (String string : map.keySet()) {
            this.setAttribute(string, map.get(string));
        }
    }

    private void setAttribute(String string, Object stringArray) {
        if ("svn:entry:absent".equals(string)) {
            this.setAbsent(SVNProperty.booleanValue((String)stringArray));
        } else if ("svn:entry:cachable-props".equals(string)) {
            if (stringArray instanceof String) {
                stringArray = SVNAdminArea.fromString((String)stringArray, " ");
            }
            if (Arrays.equals(stringArray, SVNAdminArea14.getCachableProperties())) {
                stringArray = SVNAdminArea14.getCachableProperties();
            }
            this.setCachableProperties(stringArray);
        } else if ("svn:entry:changelist".equals(string)) {
            this.setChangelistName((String)stringArray);
        } else if ("svn:entry:checksum".equals(string)) {
            this.setChecksum((String)stringArray);
        } else if ("svn:entry:committed-date".equals(string)) {
            this.setCommittedDate((String)stringArray);
        } else if ("svn:entry:committed-rev".equals(string)) {
            this.setCommittedRevision(SVNProperty.longValue((String)stringArray));
        } else if ("svn:entry:conflict-new".equals(string)) {
            this.setConflictNew((String)stringArray);
        } else if ("svn:entry:conflict-old".equals(string)) {
            this.setConflictOld((String)stringArray);
        } else if ("svn:entry:conflict-wrk".equals(string)) {
            this.setConflictWorking((String)stringArray);
        } else if ("svn:entry:copied".equals(string)) {
            this.setCopied(SVNProperty.booleanValue((String)stringArray));
        } else if ("svn:entry:copyfrom-rev".equals(string)) {
            this.setCopyFromRevision(SVNProperty.longValue((String)stringArray));
        } else if ("svn:entry:copyfrom-url".equals(string)) {
            this.setCopyFromURL((String)stringArray);
        } else if ("svn:entry:deleted".equals(string)) {
            this.setDeleted(SVNProperty.booleanValue((String)stringArray));
        } else if ("svn:entry:depth".equals(string)) {
            SVNDepth sVNDepth = null;
            if (stringArray instanceof String) {
                sVNDepth = SVNDepth.fromString((String)stringArray);
            }
            if (sVNDepth == null) {
                sVNDepth = SVNDepth.INFINITY;
            }
            this.setDepth(sVNDepth);
        } else if ("svn:entry:file-external-path".equals(string)) {
            this.setExternalFilePath((String)stringArray);
        } else if ("svn:entry:file-external-peg-revision".equals(string)) {
            this.setExternalFilePegRevision((SVNRevision)stringArray);
        } else if ("svn:entry:file-external-revision".equals(string)) {
            this.setExternalFileRevision((SVNRevision)stringArray);
        } else if ("svn:entry:has-prop-mods".equals(string)) {
            this.setHasPropertiesModifications(SVNProperty.booleanValue((String)stringArray));
        } else if ("svn:entry:has-props".equals(string)) {
            this.setHasProperties(SVNProperty.booleanValue((String)stringArray));
        } else if ("svn:entry:incomplete".equals(string)) {
            this.setIncomplete(SVNProperty.booleanValue((String)stringArray));
        } else if ("svn:entry:keep-local".equals(string)) {
            this.setKeepLocal(SVNProperty.booleanValue((String)stringArray));
        } else if ("svn:entry:kind".equals(string)) {
            SVNNodeKind sVNNodeKind = null;
            if (stringArray instanceof String) {
                sVNNodeKind = SVNNodeKind.parseKind((String)stringArray);
            }
            this.setKind(sVNNodeKind);
        } else if ("svn:entry:last-author".equals(string)) {
            this.setAuthor((String)stringArray);
        } else if ("svn:entry:lock-comment".equals(string)) {
            this.setLockComment((String)stringArray);
        } else if ("svn:entry:lock-creation-date".equals(string)) {
            this.setLockCreationDate((String)stringArray);
        } else if ("svn:entry:lock-owner".equals(string)) {
            this.setLockOwner((String)stringArray);
        } else if ("svn:entry:lock-token".equals(string)) {
            this.setLockToken((String)stringArray);
        } else if ("svn:entry:name".equals(string)) {
            this.myName = (String)stringArray;
        } else if ("svn:entry:present-props".equals(string)) {
            if (stringArray instanceof String) {
                stringArray = SVNAdminArea.fromString((String)stringArray, " ");
            }
            this.setPresentProperties(stringArray);
        } else if ("svn:entry:prop-reject-file".equals(string)) {
            this.setPropRejectFile((String)stringArray);
        } else if ("svn:entry:prop-time".equals(string)) {
            this.setPropTime((String)stringArray);
        } else if ("svn:entry:repos".equals(string)) {
            this.setRepositoryRoot((String)stringArray);
        } else if ("svn:entry:revision".equals(string)) {
            this.setRevision(SVNProperty.longValue((String)stringArray));
        } else if ("svn:entry:schedule".equals(string)) {
            this.setSchedule((String)stringArray);
        } else if ("svn:entry:text-time".equals(string)) {
            this.setTextTime((String)stringArray);
        } else if ("svn:entry:tree-conflicts".equals(string)) {
            this.setTreeConflictData((String)stringArray);
        } else if ("svn:entry:url".equals(string)) {
            this.setURL((String)stringArray);
        } else if ("svn:entry:uuid".equals(string)) {
            this.setUUID((String)stringArray);
        } else if ("svn:entry:working-size".equals(string)) {
            this.setWorkingSize(SVNProperty.longValue((String)stringArray));
        }
    }

    public Map asMap() {
        SVNHashMap sVNHashMap = new SVNHashMap();
        if (this.isAbsent()) {
            sVNHashMap.put("svn:entry:absent", Boolean.TRUE.toString());
        }
        if (this.getCachableProperties() != null) {
            sVNHashMap.put("svn:entry:cachable-props", this.getCachableProperties());
        }
        if (this.getChangelistName() != null) {
            sVNHashMap.put("svn:entry:changelist", this.getChangelistName());
        }
        if (this.getChecksum() != null) {
            sVNHashMap.put("svn:entry:checksum", this.getChecksum());
        }
        if (this.getCommittedDate() != null) {
            sVNHashMap.put("svn:entry:committed-date", this.getCommittedDate());
        }
        if (this.getCommittedRevision() >= 0L) {
            sVNHashMap.put("svn:entry:committed-rev", Long.toString(this.getCommittedRevision()));
        }
        if (this.getConflictNew() != null) {
            sVNHashMap.put("svn:entry:conflict-new", this.getConflictNew());
        }
        if (this.getConflictOld() != null) {
            sVNHashMap.put("svn:entry:conflict-old", this.getConflictOld());
        }
        if (this.getConflictWorking() != null) {
            sVNHashMap.put("svn:entry:conflict-wrk", this.getConflictWorking());
        }
        if (this.isCopied()) {
            sVNHashMap.put("svn:entry:copied", Boolean.TRUE.toString());
        }
        if (this.getCopyFromRevision() >= 0L) {
            sVNHashMap.put("svn:entry:copyfrom-rev", Long.toString(this.getCopyFromRevision()));
        }
        if (this.getCopyFromURL() != null) {
            sVNHashMap.put("svn:entry:copyfrom-url", this.getCopyFromURL());
        }
        if (this.isDeleted()) {
            sVNHashMap.put("svn:entry:deleted", Boolean.TRUE.toString());
        }
        if (this.getDepth() != null) {
            sVNHashMap.put("svn:entry:depth", this.getDepth().toString());
        }
        if (this.getExternalFilePath() != null) {
            sVNHashMap.put("svn:entry:file-external-path", this.getExternalFilePath());
        }
        if (this.getExternalFileRevision() != null) {
            sVNHashMap.put("svn:entry:file-external-revision", this.getExternalFileRevision());
        }
        if (this.getExternalFilePegRevision() != null) {
            sVNHashMap.put("svn:entry:file-external-peg-revision", this.getExternalFilePegRevision());
        }
        if (this.hasProperties()) {
            sVNHashMap.put("svn:entry:has-props", Boolean.TRUE.toString());
        }
        if (this.hasPropertiesModifications()) {
            sVNHashMap.put("svn:entry:has-prop-mods", Boolean.TRUE.toString());
        }
        if (this.isIncomplete()) {
            sVNHashMap.put("svn:entry:incomplete", Boolean.TRUE.toString());
        }
        if (this.isKeepLocal()) {
            sVNHashMap.put("svn:entry:keep-local", Boolean.TRUE.toString());
        }
        if (this.getKind() != null) {
            sVNHashMap.put("svn:entry:kind", this.getKind().toString());
        }
        if (this.getAuthor() != null) {
            sVNHashMap.put("svn:entry:last-author", this.getAuthor());
        }
        if (this.getLockComment() != null) {
            sVNHashMap.put("svn:entry:lock-comment", this.getLockComment());
        }
        if (this.getLockCreationDate() != null) {
            sVNHashMap.put("svn:entry:lock-creation-date", this.getLockCreationDate());
        }
        if (this.getLockOwner() != null) {
            sVNHashMap.put("svn:entry:lock-owner", this.getLockOwner());
        }
        if (this.getLockToken() != null) {
            sVNHashMap.put("svn:entry:lock-token", this.getLockToken());
        }
        if (this.getName() != null) {
            sVNHashMap.put("svn:entry:name", this.getName());
        }
        if (this.getPresentProperties() != null) {
            sVNHashMap.put("svn:entry:present-props", this.getPresentProperties());
        }
        if (this.getPropRejectFile() != null) {
            sVNHashMap.put("svn:entry:prop-reject-file", this.getPropRejectFile());
        }
        if (this.getPropTime() != null) {
            sVNHashMap.put("svn:entry:prop-time", this.getPropTime());
        }
        if (this.getRepositoryRoot() != null) {
            sVNHashMap.put("svn:entry:repos", this.getRepositoryRoot());
        }
        if (this.getRevision() >= 0L) {
            sVNHashMap.put("svn:entry:revision", Long.toString(this.getRevision()));
        }
        if (this.getSchedule() != null) {
            sVNHashMap.put("svn:entry:schedule", this.getSchedule());
        }
        if (this.getTextTime() != null) {
            sVNHashMap.put("svn:entry:text-time", this.getTextTime());
        }
        if (this.getTreeConflictData() != null) {
            sVNHashMap.put("svn:entry:tree-conflicts", this.getTreeConflictData());
        }
        if (this.getURL() != null) {
            sVNHashMap.put("svn:entry:url", this.getURL());
        }
        if (this.getUUID() != null) {
            sVNHashMap.put("svn:entry:uuid", this.getUUID());
        }
        if (this.getWorkingSize() >= 0L) {
            sVNHashMap.put("svn:entry:working-size", Long.toString(this.getWorkingSize()));
        }
        return sVNHashMap;
    }
}

