/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNChecksumOutputStream
extends OutputStream {
    public static final String MD5_ALGORITHM = "MD5";
    private OutputStream myTarget;
    private MessageDigest myDigest;
    private byte[] myDigestResult;
    private boolean myCloseTarget;

    public SVNChecksumOutputStream(OutputStream outputStream, String string, boolean bl2) {
        this.myTarget = outputStream;
        this.myCloseTarget = bl2;
        string = string == null ? MD5_ALGORITHM : string;
        try {
            this.myDigest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    @Override
    public void write(int n2) {
        this.myDigest.update((byte)(n2 & 0xFF));
        this.myTarget.write(n2);
    }

    @Override
    public void write(byte[] byArray) {
        if (byArray != null) {
            this.myDigest.update(byArray);
        }
        this.myTarget.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (byArray != null) {
            this.myDigest.update(byArray, n2, n3);
        }
        this.myTarget.write(byArray, n2, n3);
    }

    @Override
    public void close() {
        if (this.myDigestResult == null) {
            this.myDigestResult = this.myDigest.digest();
        }
        if (this.myCloseTarget) {
            this.myTarget.close();
        }
    }

    public String getDigest() {
        if (this.myDigestResult == null) {
            this.myDigestResult = this.myDigest.digest();
        }
        return SVNFileUtil.toHexDigest(this.myDigestResult);
    }
}

