/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.File;
import java.util.Collection;
import java.util.TreeSet;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNClassLoader;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory$DefaultSelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SVNAdminAreaFactory
implements Comparable {
    public static final int WC_FORMAT_13 = 4;
    public static final int WC_FORMAT_14 = 8;
    public static final int WC_FORMAT_15 = 9;
    public static final int WC_FORMAT_16 = 10;
    private static final Collection ourFactories = new TreeSet();
    private static boolean ourIsUpgradeEnabled = Boolean.valueOf(System.getProperty("svnkit.upgradeWC", System.getProperty("javasvn.upgradeWC", "true")));
    private static ISVNAdminAreaFactorySelector ourSelector;
    private static ISVNAdminAreaFactorySelector ourDefaultSelector;

    public static void setUpgradeEnabled(boolean bl2) {
        ourIsUpgradeEnabled = bl2;
    }

    public static boolean isUpgradeEnabled() {
        return ourIsUpgradeEnabled;
    }

    public static void setSelector(ISVNAdminAreaFactorySelector iSVNAdminAreaFactorySelector) {
        ourSelector = iSVNAdminAreaFactorySelector;
    }

    public static ISVNAdminAreaFactorySelector getSelector() {
        return ourSelector != null ? ourSelector : ourDefaultSelector;
    }

    public static int checkWC(File file, boolean bl2) {
        return SVNAdminAreaFactory.checkWC(file, bl2, Level.FINE);
    }

    public static int checkWC(File file, boolean bl2, Level level) {
        Collection collection = ourFactories;
        if (bl2) {
            collection = SVNAdminAreaFactory.getSelector().getEnabledFactories(file, collection, false);
        }
        SVNErrorMessage sVNErrorMessage = null;
        int n2 = -1;
        for (SVNAdminAreaFactory sVNAdminAreaFactory : collection) {
            block9: {
                try {
                    n2 = sVNAdminAreaFactory.doCheckWC(file, level);
                    if (n2 == 0) {
                        return n2;
                    }
                    if (n2 > sVNAdminAreaFactory.getSupportedVersion()) {
                        SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT, "The path ''{0}'' appears to be part of a Subversion 1.7 or greater\nworking copy.  Please upgrade your Subversion client to use this\nworking copy.", (Object)file);
                        SVNErrorManager.error(sVNErrorMessage2, SVNLogType.WC);
                        break block9;
                    }
                    if (n2 >= sVNAdminAreaFactory.getSupportedVersion()) break block9;
                    SVNErrorMessage sVNErrorMessage3 = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT, "Working copy format of {0} is too old ({1}); please check out your working copy again", new Object[]{file, n2});
                    SVNErrorManager.error(sVNErrorMessage3, SVNLogType.WC);
                }
                catch (SVNException sVNException) {
                    if (sVNErrorMessage != null) {
                        sVNErrorMessage.setChildErrorMessage(sVNException.getErrorMessage());
                        continue;
                    }
                    sVNErrorMessage = sVNException.getErrorMessage();
                    continue;
                }
            }
            return n2;
        }
        if (sVNErrorMessage == null) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)file);
        }
        if (sVNErrorMessage.getErrorCode() == SVNErrorCode.WC_UNSUPPORTED_FORMAT) {
            sVNErrorMessage.setChildErrorMessage(null);
        }
        SVNErrorManager.error(sVNErrorMessage, level, SVNLogType.WC);
        return 0;
    }

    public static SVNAdminArea open(File file, Level level) {
        SVNErrorMessage sVNErrorMessage = null;
        int n2 = -1;
        Collection collection = SVNAdminAreaFactory.getSelector().getEnabledFactories(file, ourFactories, false);
        File file2 = new File(file, SVNFileUtil.getAdminDirectoryName());
        if (file2.isDirectory()) {
            for (SVNAdminAreaFactory sVNAdminAreaFactory : collection) {
                Object object;
                block8: {
                    try {
                        n2 = sVNAdminAreaFactory.getVersion(file);
                        if (n2 > sVNAdminAreaFactory.getSupportedVersion()) {
                            object = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT, "The path ''{0}'' appears to be part of a Subversion 1.7 or greater\nworking copy.  Please upgrade your Subversion client to use this\nworking copy.", (Object)file);
                            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
                            break block8;
                        }
                        if (n2 >= sVNAdminAreaFactory.getSupportedVersion()) break block8;
                        object = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT, "Working copy format of {0} is too old ({1}); please check out your working copy again", new Object[]{file, n2});
                        SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
                    }
                    catch (SVNException sVNException) {
                        if (sVNErrorMessage != null) {
                            sVNErrorMessage.setChildErrorMessage(sVNException.getErrorMessage());
                            continue;
                        }
                        sVNErrorMessage = sVNException.getErrorMessage();
                        continue;
                    }
                }
                if ((object = sVNAdminAreaFactory.doOpen(file, n2)) == null) continue;
                ((SVNAdminArea)object).setWorkingCopyFormatVersion(n2);
                return object;
            }
        }
        if (sVNErrorMessage == null) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)file);
        }
        if (sVNErrorMessage.getErrorCode() == SVNErrorCode.WC_UNSUPPORTED_FORMAT) {
            sVNErrorMessage.setChildErrorMessage(null);
        }
        SVNErrorManager.error(sVNErrorMessage, level, SVNLogType.WC);
        return null;
    }

    public static SVNAdminArea upgrade(SVNAdminArea sVNAdminArea) {
        Collection collection;
        if (SVNAdminAreaFactory.isUpgradeEnabled() && !ourFactories.isEmpty() && !(collection = SVNAdminAreaFactory.getSelector().getEnabledFactories(sVNAdminArea.getRoot(), ourFactories, true)).isEmpty()) {
            SVNAdminAreaFactory sVNAdminAreaFactory = (SVNAdminAreaFactory)collection.iterator().next();
            SVNAdminArea sVNAdminArea2 = sVNAdminAreaFactory.doChangeWCFormat(sVNAdminArea);
            if (sVNAdminArea2 != null && sVNAdminArea2 != sVNAdminArea && sVNAdminArea2.getWCAccess() != null) {
                SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(sVNAdminArea2.getRoot(), SVNNodeKind.DIR, null, -1L, SVNEventAction.UPGRADE, null, null, null);
                sVNAdminArea2.getWCAccess().handleEvent(sVNEvent, -1.0);
            }
            sVNAdminArea = sVNAdminArea2;
        }
        return sVNAdminArea;
    }

    public static SVNAdminArea changeWCFormat(SVNAdminArea sVNAdminArea, int n2) {
        SVNAdminAreaFactory sVNAdminAreaFactory = SVNAdminAreaFactory.getAdminAreaFactory(n2);
        SVNAdminArea sVNAdminArea2 = sVNAdminAreaFactory.doChangeWCFormat(sVNAdminArea);
        if (sVNAdminArea2 != null && sVNAdminArea2 != sVNAdminArea && sVNAdminArea2.getWCAccess() != null) {
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(sVNAdminArea2.getRoot(), SVNNodeKind.DIR, null, -1L, SVNEventAction.UPGRADE, null, null, null);
            sVNAdminArea2.getWCAccess().handleEvent(sVNEvent, -1.0);
        }
        sVNAdminArea = sVNAdminArea2;
        return sVNAdminArea;
    }

    private static SVNAdminAreaFactory getAdminAreaFactory(int n2) {
        for (SVNAdminAreaFactory sVNAdminAreaFactory : ourFactories) {
            if (sVNAdminAreaFactory.getSupportedVersion() != n2) continue;
            return sVNAdminAreaFactory;
        }
        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT), SVNLogType.DEFAULT);
        return null;
    }

    private static int readFormatVersion(File file) {
        SVNErrorMessage sVNErrorMessage = null;
        int n2 = -1;
        Collection collection = SVNAdminAreaFactory.getSelector().getEnabledFactories(file.getParentFile(), ourFactories, false);
        for (SVNAdminAreaFactory sVNAdminAreaFactory : collection) {
            try {
                n2 = sVNAdminAreaFactory.getVersion(file);
            }
            catch (SVNException sVNException) {
                sVNErrorMessage = sVNException.getErrorMessage();
                continue;
            }
            return n2;
        }
        if (sVNErrorMessage == null) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)file);
        }
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        return -1;
    }

    public static void createVersionedDirectory(File file, String string, String string2, String string3, long l2, SVNDepth sVNDepth) {
        Collection collection;
        if (!(ourFactories.isEmpty() || SVNAdminAreaFactory.checkAdminAreaExists(file, string, l2) || (collection = SVNAdminAreaFactory.getSelector().getEnabledFactories(file, ourFactories, true)).isEmpty())) {
            SVNAdminAreaFactory sVNAdminAreaFactory = (SVNAdminAreaFactory)collection.iterator().next();
            sVNAdminAreaFactory.doCreateVersionedDirectory(file, string, string2, string3, l2, sVNDepth);
        }
    }

    public static void createVersionedDirectory(File file, SVNURL sVNURL, SVNURL sVNURL2, String string, long l2, SVNDepth sVNDepth) {
        SVNAdminAreaFactory.createVersionedDirectory(file, sVNURL != null ? sVNURL.toString() : null, sVNURL2 != null ? sVNURL2.toString() : null, string, l2, sVNDepth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkAdminAreaExists(File file, String string, long l2) {
        File file2 = new File(file, SVNFileUtil.getAdminDirectoryName());
        if (file2.exists() && !file2.isDirectory()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "''{0}'' is not a directory", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        } else if (!file2.exists()) {
            return false;
        }
        boolean bl2 = false;
        try {
            SVNAdminAreaFactory.readFormatVersion(file2);
            bl2 = true;
        }
        catch (SVNException sVNException) {
            return false;
        }
        if (bl2) {
            SVNWCAccess sVNWCAccess = SVNWCAccess.newInstance(null);
            SVNAdminArea sVNAdminArea = null;
            SVNEntry sVNEntry = null;
            try {
                sVNAdminArea = sVNWCAccess.open(file, false, 0);
                sVNEntry = sVNAdminArea.getVersionedEntry(sVNAdminArea.getThisDirName(), false);
            }
            finally {
                sVNWCAccess.closeAdminArea(file);
            }
            if (!sVNEntry.isScheduledForDeletion()) {
                SVNErrorMessage sVNErrorMessage;
                if (sVNEntry.getRevision() != l2) {
                    sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Revision {0} doesn''t match existing revision {1} in ''{2}''", l2, sVNEntry.getRevision(), file);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
                if (!string.equals(sVNEntry.getURL())) {
                    sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "URL ''{0}'' doesn''t match existing URL ''{1}'' in ''{2}''", string, sVNEntry.getURL(), file);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
            }
        }
        return bl2;
    }

    public abstract int getSupportedVersion();

    protected abstract int getVersion(File var1);

    protected abstract SVNAdminArea doOpen(File var1, int var2);

    protected abstract SVNAdminArea doChangeWCFormat(SVNAdminArea var1);

    protected abstract void doCreateVersionedDirectory(File var1, String var2, String var3, String var4, long var5, SVNDepth var7);

    protected abstract int doCheckWC(File var1, Level var2);

    protected static void registerFactory(SVNAdminAreaFactory sVNAdminAreaFactory) {
        if (sVNAdminAreaFactory != null) {
            ourFactories.add(sVNAdminAreaFactory);
        }
    }

    public int compareTo(Object object) {
        if (object == null || !(object instanceof SVNAdminAreaFactory)) {
            return -1;
        }
        int n2 = ((SVNAdminAreaFactory)object).getSupportedVersion();
        return this.getSupportedVersion() > n2 ? -1 : (this.getSupportedVersion() < n2 ? 1 : 0);
    }

    private static void registerFactories() {
        ourFactories.addAll(SVNClassLoader.getAvailableAdminAreaFactories());
    }

    static {
        ourDefaultSelector = new SVNAdminAreaFactory$DefaultSelector(null);
        SVNAdminAreaFactory.registerFactories();
    }
}

