/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea15;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAdminArea16
extends SVNAdminArea15 {
    public static final int WC_FORMAT = 10;

    public SVNAdminArea16(File file) {
        super(file);
    }

    @Override
    public boolean hasTreeConflict(String string) {
        return this.getTreeConflict(string) != null;
    }

    @Override
    public SVNTreeConflictDescription getTreeConflict(String string) {
        SVNEntry sVNEntry = this.getEntry(this.getThisDirName(), false);
        if (sVNEntry == null) {
            return null;
        }
        Map map = sVNEntry.getTreeConflicts();
        return (SVNTreeConflictDescription)map.get(this.getFile(string));
    }

    @Override
    public void addTreeConflict(SVNTreeConflictDescription sVNTreeConflictDescription) {
        Serializable serializable;
        SVNTreeConflictDescription sVNTreeConflictDescription2 = this.getTreeConflict(sVNTreeConflictDescription.getPath().getName());
        if (sVNTreeConflictDescription2 != null) {
            serializable = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Attempt to add tree conflict that already exists at ''{0}''", (Object)sVNTreeConflictDescription.getPath());
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        serializable = new SVNHashMap();
        serializable.put(sVNTreeConflictDescription.getPath(), sVNTreeConflictDescription);
        String string = SVNTreeConflictUtil.getTreeConflictData(serializable);
        SVNProperties sVNProperties = new SVNProperties();
        sVNProperties.put("name", this.getThisDirName());
        sVNProperties.put("data", string);
        SVNLog sVNLog = this.getLog();
        sVNLog.addCommand("add-tree-conflict", sVNProperties, false);
        sVNLog.save();
        this.runLogs();
    }

    @Override
    public SVNTreeConflictDescription deleteTreeConflict(String string) {
        File file;
        SVNEntry sVNEntry = this.getEntry(this.getThisDirName(), false);
        Map map = sVNEntry.getTreeConflicts();
        if (map.containsKey(file = this.getFile(string))) {
            SVNTreeConflictDescription sVNTreeConflictDescription = (SVNTreeConflictDescription)map.remove(file);
            String string2 = SVNTreeConflictUtil.getTreeConflictData(map);
            SVNHashMap sVNHashMap = new SVNHashMap();
            sVNHashMap.put("svn:entry:tree-conflicts", string2);
            this.modifyEntry(this.getThisDirName(), sVNHashMap, true, false);
            return sVNTreeConflictDescription;
        }
        return null;
    }

    @Override
    public void setFileExternalLocation(String string, SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNURL sVNURL2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (sVNURL != null) {
            String string2;
            String string3 = sVNURL.toDecodedString();
            String string4 = string3.substring((string2 = sVNURL2.toDecodedString()).length());
            if (!string4.startsWith("/")) {
                string4 = "/" + string4;
            }
            hashMap.put("svn:entry:file-external-peg-revision", sVNRevision);
            hashMap.put("svn:entry:file-external-revision", sVNRevision2);
            hashMap.put("svn:entry:file-external-path", string4);
        } else {
            hashMap.put("svn:entry:file-external-peg-revision", SVNRevision.UNDEFINED);
            hashMap.put("svn:entry:file-external-revision", SVNRevision.UNDEFINED);
            hashMap.put("svn:entry:file-external-path", null);
        }
        this.modifyEntry(string, hashMap, true, false);
    }

    @Override
    public int getFormatVersion() {
        return 10;
    }

    @Override
    public void postUpgradeFormat(int n2) {
        super.postUpgradeFormat(n2);
        try {
            SVNFileUtil.deleteFile(this.getAdminFile("format"));
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
    }

    @Override
    protected void createFormatFile(File file, boolean bl2) {
    }

    @Override
    protected boolean readExtraOptions(BufferedReader bufferedReader, SVNEntry sVNEntry) {
        if (super.readExtraOptions(bufferedReader, sVNEntry)) {
            return true;
        }
        String string = bufferedReader.readLine();
        if (this.isEntryFinished(string)) {
            return true;
        }
        String string2 = this.parseString(string);
        if (string2 != null) {
            sVNEntry.setTreeConflictData(string2);
        }
        if (this.isEntryFinished(string = bufferedReader.readLine())) {
            return true;
        }
        String string3 = this.parseString(string);
        if (string3 != null) {
            SVNAdminUtil.unserializeExternalFileData(sVNEntry, string3);
        }
        return false;
    }

    @Override
    protected int writeExtraOptions(Writer writer, String string, SVNEntry sVNEntry, int n2) {
        n2 = super.writeExtraOptions(writer, string, sVNEntry, n2);
        String string2 = sVNEntry.getTreeConflictData();
        n2 = this.writeString(writer, string2, n2) ? 0 : ++n2;
        String string3 = SVNAdminUtil.serializeExternalFileData(sVNEntry);
        n2 = this.writeString(writer, string3, n2) ? 0 : ++n2;
        return n2;
    }

    @Override
    protected boolean isEntryPropertyApplicable(String string) {
        return string != null;
    }
}

