/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.Writer;
import java.util.Set;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea14;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;

public class SVNAdminArea15
extends SVNAdminArea14 {
    public static final int WC_FORMAT = 9;
    protected static final String ATTRIBUTE_KEEP_LOCAL = "keep-local";
    private static final Set INAPPLICABLE_PROPERTIES = new SVNHashSet();

    public SVNAdminArea15(File file) {
        super(file);
    }

    @Override
    public int getFormatVersion() {
        return 9;
    }

    @Override
    protected boolean readExtraOptions(BufferedReader bufferedReader, SVNEntry sVNEntry) {
        String string = bufferedReader.readLine();
        if (this.isEntryFinished(string)) {
            return true;
        }
        String string2 = this.parseString(string);
        if (string2 != null) {
            sVNEntry.setChangelistName(string2);
        }
        if (this.isEntryFinished(string = bufferedReader.readLine())) {
            return true;
        }
        boolean bl2 = this.parseBoolean(string, ATTRIBUTE_KEEP_LOCAL);
        if (bl2) {
            sVNEntry.setKeepLocal(bl2);
        }
        if (this.isEntryFinished(string = bufferedReader.readLine())) {
            return true;
        }
        String string3 = this.parseString(string);
        if (string3 != null) {
            try {
                long l2 = Long.parseLong(string3);
                sVNEntry.setWorkingSize(l2);
            }
            catch (NumberFormatException numberFormatException) {
                sVNEntry.setWorkingSize(-1L);
            }
        }
        if (this.isEntryFinished(string = bufferedReader.readLine())) {
            return true;
        }
        String string4 = this.parseValue(string);
        if (string4 == null) {
            sVNEntry.setDepth(SVNDepth.INFINITY);
        } else {
            SVNDepth sVNDepth = SVNDepth.fromString(string4);
            sVNEntry.setDepth(sVNDepth);
        }
        return false;
    }

    @Override
    protected int writeExtraOptions(Writer writer, String string, SVNEntry sVNEntry, int n2) {
        n2 = super.writeExtraOptions(writer, string, sVNEntry, n2);
        String string2 = sVNEntry.getChangelistName();
        n2 = this.writeString(writer, string2, n2) ? 0 : ++n2;
        boolean bl2 = sVNEntry.isKeepLocal();
        if (bl2) {
            this.writeValue(writer, ATTRIBUTE_KEEP_LOCAL, n2);
            n2 = 0;
        } else {
            ++n2;
        }
        long l2 = sVNEntry.getWorkingSize();
        String string3 = Long.toString(l2);
        String string4 = string3 = "-1".equals(string3) ? null : string3;
        n2 = this.writeString(writer, string3, n2) ? 0 : ++n2;
        boolean bl3 = this.getThisDirName().equals(string);
        boolean bl4 = !bl3 && sVNEntry.isDirectory();
        SVNDepth sVNDepth = sVNEntry.getDepth();
        n2 = bl4 && sVNDepth != SVNDepth.EXCLUDE || sVNDepth == SVNDepth.INFINITY ? ++n2 : (this.writeValue(writer, sVNDepth.toString(), n2) ? 0 : ++n2);
        return n2;
    }

    @Override
    protected SVNAdminArea createAdminAreaForDir(File file) {
        return new SVNAdminArea15(file);
    }

    @Override
    protected boolean isEntryPropertyApplicable(String string) {
        return string != null && !INAPPLICABLE_PROPERTIES.contains(string);
    }

    static {
        INAPPLICABLE_PROPERTIES.add("svn:entry:file-external-path");
        INAPPLICABLE_PROPERTIES.add("svn:entry:file-external-revision");
        INAPPLICABLE_PROPERTIES.add("svn:entry:file-external-peg-revision");
        INAPPLICABLE_PROPERTIES.add("svn:entry:tree-conflicts");
    }
}

